/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CoreManagedObject;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.PerfMonitorState;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageStatisticalDataInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ControllerPerfData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageArrays;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageControllers;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfErrorCode;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfMonitorInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfStatsDataInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfTaskThread;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArrayPerfData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VolPerfCounterData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VolPerfData;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.AbstractVolRefList;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumePerformance;
import devmgr.versioned.symbol.VolumePerformanceList;
import devmgr.versioned.symbol.VolumeRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class PerfMonitor
extends CoreManagedObject
implements PerfMonitorInterface {
    private static final long DEFAULT_DATA_RETENTION_TIME = 3600000L;
    private Object dataCollectionLock = new Object();
    Hashtable volPerfTable = new Hashtable();
    Hashtable controllerPerfTable = new Hashtable(4);
    StorageArrayPerfData systemPerfData = null;
    String arrayWWN;
    PerfMonitorState state = PerfMonitorState.OFF;
    private static final ClockDaemon clockDaemon = new ClockDaemon();
    private Object perfTaskID = null;
    private Object flushTaskID = null;
    private long pollingRate = 60000L;
    private long dataRetentionTime = 3600000L;
    protected long samplesTaken = 0L;

    public PerfMonitor(String arrayWWN) {
        this.arrayWWN = arrayWWN;
        Map keyMap = ManageArrays.getArrayKeyMap(arrayWWN);
        this.setKey(keyMap);
        this.setName("Performance Monitor " + arrayWWN);
        this.systemPerfData = new StorageArrayPerfData(arrayWWN, keyMap, this.controllerPerfTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageStatisticalDataInterface getSystemStats() {
        Object object = this.dataCollectionLock;
        synchronized (object) {
            return (PerfStatsDataInterface)this.systemPerfData.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfStatsDataInterface getControllerStats(String controllerKey) throws ConfigMgmtException {
        String METHOD_NAME = "getControllerStats";
        if (controllerKey == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object controllerKey is null.");
        }
        Map map = Convert.keyAsStringToMap(controllerKey);
        String controllerRef = (String)map.get("controllerRef");
        if (controllerRef == null) {
            throw new SEItemNotFoundException(controllerKey);
        }
        Object object = this.dataCollectionLock;
        synchronized (object) {
            ControllerPerfData controllerData = (ControllerPerfData)this.controllerPerfTable.get(controllerRef);
            if (controllerData == null) {
                Trace.verbose((Object)this, "getControllerStats", "Lookup of " + controllerRef + " failed.");
                controllerData = new ControllerPerfData(controllerRef, map, this.volPerfTable);
            }
            return (PerfStatsDataInterface)controllerData.clone();
        }
    }

    public StorageStatisticalDataInterface getVolumeStats(String volKey) throws ConfigMgmtException {
        String METHOD_NAME = "getVolumeStatus";
        if (volKey == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object volKey is null.");
        }
        Map map = Convert.keyAsStringToMap(volKey);
        String volWWN = (String)map.get("volumeWwn");
        if (volWWN == null) {
            throw new SEItemNotFoundException(volKey);
        }
        VolPerfData volData = (VolPerfData)this.volPerfTable.get(volWWN);
        if (volData == null) {
            Trace.verbose((Object)this, "getVolumeStatus", "Lookup of " + volWWN + " failed.");
            volData = new VolPerfData(volWWN, map);
        }
        return volData;
    }

    protected ArrayList getVolumesStatsAll() {
        return new ArrayList(this.volPerfTable.values());
    }

    public synchronized long getPollingRate() {
        return this.pollingRate;
    }

    public synchronized void setPollingRate(long pollingRate) throws ConfigMgmtException {
        this.start(pollingRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long pollingRate) throws ConfigMgmtException {
        Object object = this.dataCollectionLock;
        synchronized (object) {
            PerfMonitor perfMonitor = this;
            synchronized (perfMonitor) {
                this.cancelFlushTask();
                this.pollingRate = pollingRate;
                boolean takeInitialSample = true;
                if (this.perfTaskID != null) {
                    ClockDaemon.cancel((Object)this.perfTaskID);
                    takeInitialSample = false;
                } else {
                    this.flushData();
                }
                this.perfTaskID = clockDaemon.executePeriodically(pollingRate, (Runnable)new PerfTaskThread(this), takeInitialSample);
                this.state = PerfMonitorState.ON;
            }
        }
    }

    public synchronized void stop() throws ConfigMgmtException {
        this.state = PerfMonitorState.OFF;
        if (this.perfTaskID == null) {
            throw new ConfigMgmtException(ErrorCode.PERFMONITOR_NOT_RUNNING.getKey(), null);
        }
        ClockDaemon.cancel((Object)this.perfTaskID);
        this.perfTaskID = null;
        this.createFlushTask();
    }

    public synchronized void setDataRetentionTime(long time) {
        this.dataRetentionTime = time;
        if (this.flushTaskID != null) {
            this.createFlushTask();
        }
    }

    public synchronized long getDataRetentionTime() {
        return this.dataRetentionTime;
    }

    public PerfMonitorState getState() {
        return this.state;
    }

    public String getVolumeRefKey(byte[] refToken) {
        return Convert.bytesToStringRaw(refToken);
    }

    public String getControllerRefKey(byte[] refToken) {
        return Convert.bytesToString(refToken);
    }

    public VolumePerformanceList getPerfData(SYMbolAPIClientV1 client, ControllerRef controllerRef, AbstractVolRefList volumeRefList) throws RPCError, IOException {
        ControllerDescriptor controllerDescriptor = new ControllerDescriptor();
        controllerDescriptor.setControllerRef(controllerRef);
        client.bindToController(controllerDescriptor);
        return client.getVolumePerformance(volumeRefList);
    }

    private void findAndHandleDeletedVolumes(List listOfVolumeWWNs) {
        String METHOD_NAME = "findAndHandleDeletedVolumes";
        String[] keys = this.volPerfTable.keySet().toArray(new String[this.volPerfTable.size()]);
        for (int i = 0; i < keys.length; ++i) {
            if (listOfVolumeWWNs.contains(keys[i])) continue;
            VolPerfData data = (VolPerfData)this.volPerfTable.get(keys[i]);
            if (!data.hasPerfData()) {
                this.volPerfTable.remove(keys[i]);
                continue;
            }
            VolPerfCounterData volPerfCounterData = data.getFirstPerfData();
            if (volPerfCounterData == null) {
                Trace.error((Object)this, "findAndHandleDeletedVolumes", "VolPerfCounterData for volume " + keys[i] + " was null, when it shouldn't be.");
            } else {
                ControllerPerfData controllerPerfData = (ControllerPerfData)this.controllerPerfTable.get(volPerfCounterData.ref);
                if (controllerPerfData != null) {
                    controllerPerfData.setVolumeDeletedAfterStart();
                } else {
                    Trace.error((Object)this, "findAndHandleDeletedVolumes", "Failed to find controller ref in controllerPerfTable with key of " + volPerfCounterData.ref);
                }
            }
            this.volPerfTable.remove(keys[i]);
        }
    }

    private VolPerfData[] markVolumeStatsInvalid(ErrorCode errorCode, HashMap volMap, AbstractVolRefList avrl) {
        String METHOD_NAME = "markVolumeStatsInvalid";
        long time = new Date().getTime();
        AbstractVolRef[] refs = avrl.getAbstractVolRef();
        Vector<VolPerfData> data = new Vector<VolPerfData>();
        for (int i = 0; i < refs.length; ++i) {
            String volRef = this.getVolumeRefKey(refs[i].getRefToken());
            Volume volume = (Volume)volMap.get(volRef);
            if (volume != null) {
                VolPerfData volPerfData;
                String volWWN = Convert.bytesToString(volume.getWorldWideName());
                if (this.volPerfTable.containsKey(volWWN)) {
                    volPerfData = (VolPerfData)this.volPerfTable.get(volWWN);
                    volPerfData = (VolPerfData)volPerfData.clone();
                } else {
                    volPerfData = new VolPerfData(this.arrayWWN, volume);
                }
                VolPerfCounterData volPerfCounterData = new VolPerfCounterData(time, this.getControllerRefKey(volume.getPreferredManager().getRefToken()), volume.getBlkSize());
                volPerfCounterData.setDataValid(false);
                volPerfCounterData.addErrorCode(errorCode);
                volPerfData.setPerfData(volPerfCounterData);
                this.volPerfTable.put(volWWN, volPerfData);
                data.add(volPerfData);
                continue;
            }
            if (!Trace.isTraceEnabled(this)) continue;
            StringBuffer buf = new StringBuffer();
            buf.append("Failed to find volRef (");
            buf.append(volRef);
            buf.append(") in volMap.\nvolMap=");
            buf.append(volMap.toString());
            Trace.error((Object)this, "markVolumeStatsInvalid", buf.toString());
        }
        return data.toArray(new VolPerfData[data.size()]);
    }

    private VolPerfData[] calcVolumePerfStats(HashMap volMap, VolumePerformanceList volumePerfList, boolean controllerWasReset) {
        String METHOD_NAME = "calcVolumePerfStats";
        VolumePerformance[] volPerf = volumePerfList.getVolumePerf();
        Vector<VolPerfData> data = new Vector<VolPerfData>();
        for (int i = 0; i < volPerf.length; ++i) {
            VolumePerformance volumePerf = volPerf[i];
            String volRef = this.getVolumeRefKey(volumePerf.getVolumeRef().getRefToken());
            Volume volume = (Volume)volMap.get(volRef);
            if (volume != null) {
                VolPerfData volPerfData;
                String volWWN = Convert.bytesToString(volume.getWorldWideName());
                if (this.volPerfTable.containsKey(volWWN)) {
                    volPerfData = (VolPerfData)this.volPerfTable.get(volWWN);
                    volPerfData = (VolPerfData)volPerfData.clone();
                } else {
                    volPerfData = new VolPerfData(this.arrayWWN, volume);
                    if (this.samplesTaken > 0L) {
                        volPerfData.setVolumeCreatedAfterStart();
                    }
                }
                VolPerfCounterData volPerfCounterData = new VolPerfCounterData(volumePerf, this.getControllerRefKey(volume.getPreferredManager().getRefToken()), volume.getBlkSize());
                if (controllerWasReset) {
                    volPerfData.setControllerResetAfterStart();
                }
                volPerfData.setPerfData(volPerfCounterData);
                this.volPerfTable.put(volWWN, volPerfData);
                data.add(volPerfData);
                continue;
            }
            if (!Trace.isTraceEnabled(this)) continue;
            StringBuffer buf = new StringBuffer();
            buf.append("Failed to find volRef (");
            buf.append(volRef);
            buf.append(") in volMap.\nvolMap=");
            buf.append(volMap.toString());
            Trace.error((Object)this, "calcVolumePerfStats", buf.toString());
        }
        return data.toArray(new VolPerfData[data.size()]);
    }

    private void displayVolumePerfStats() {
        System.out.println("-------- Volume Performance Data ----------\n\n");
        System.out.println("              Run                     Cache          Aver   Peak           Aver   Peak    Aver  Aver");
        System.out.println("              Aver. Peak Read  Write  Read   KB/sec  KB/sec KB/sec KB/sec  KB/sec KB/sec  Read  Write");
        System.out.println("Name    IOPs  IOPs  IOPs  %      %    Hit %  Read    Read   Read   Write   Write  Write   Size  Size");
        System.out.println("======= ===== ===== ==== ====  =====  =====  ======= ====== ====== ======= ====== ======  ===== =====");
        if (this.volPerfTable.isEmpty()) {
            System.out.println("Not currently available");
            return;
        }
        Enumeration e = this.volPerfTable.elements();
        while (e.hasMoreElements()) {
            VolPerfData data = (VolPerfData)e.nextElement();
            String errors = data.getErrorCodeStr();
            if (errors != null || errors.length() != 0) {
                System.out.println(errors);
            }
            System.out.println(data.getStatsStr("\n", false));
        }
    }

    private ControllerPerfData getControllerPerStats(ControllerRef controllerRef) {
        String controllerRefKey = this.getControllerRefKey(controllerRef.getRefToken());
        ControllerPerfData controllerData = (ControllerPerfData)this.controllerPerfTable.get(controllerRefKey);
        if (controllerData == null) {
            Map keyMap = ManageControllers.getControllerKeyMap(this.arrayWWN, controllerRefKey);
            controllerData = new ControllerPerfData(controllerRefKey, keyMap, this.volPerfTable);
            this.controllerPerfTable.put(controllerRefKey, controllerData);
        }
        return controllerData;
    }

    private void calcControllerPerfStats(ControllerPerfData controllerData, VolPerfData[] volData, boolean controllerWasReset) {
        if (controllerWasReset) {
            controllerData.setControllerResetAfterStart();
        } else {
            controllerData.setPerfData(volData);
        }
    }

    private void displayControllerPerfStats() {
        System.out.println("-------- Controller Performance Data ----------");
        if (this.controllerPerfTable.isEmpty()) {
            System.out.println("Not currently available");
            return;
        }
        Enumeration e = this.controllerPerfTable.elements();
        while (e.hasMoreElements()) {
            PerfData data = (PerfData)e.nextElement();
            String errors = data.getErrorCodeStr();
            if (errors != null || errors.length() > 0) {
                System.out.println();
                System.out.println(errors);
            }
            System.out.println(data.getStatsStr("\n", false));
        }
    }

    private void calcSystemPerfStats() {
        this.systemPerfData.calcPerfStats();
    }

    void displayPerfStats() {
        System.out.println("-------- System Performance Data ----------");
        if (this.systemPerfData == null) {
            System.out.println("Not currently available");
        } else {
            String errors = this.systemPerfData.getErrorCodeStr();
            if (errors != null || errors.length() > 0) {
                System.out.println(errors);
            }
            System.out.println(this.systemPerfData.getStatsStr("\n", false));
        }
        this.displayControllerPerfStats();
        this.displayVolumePerfStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void fetchAndProcessPerfSample() {
        String METHOD_NAME = "fetchAndProcessPerfSample";
        Trace.methodBegin(this, "fetchAndProcessPerfSample");
        try {
            ObjectBundleManager manager = ObjectBundleManager.getInstance();
            ObjectBundle objectBundle = null;
            try {
                objectBundle = manager.getObjectBundle(this.arrayWWN);
            }
            catch (Exception e) {
                Trace.error((Object)this, (Throwable)e);
                return;
            }
            HashMap<String, ControllerData> controllerToVolumeMappings = new HashMap<String, ControllerData>();
            Controller[] controllers = objectBundle.getController();
            for (int i = 0; i < controllers.length; ++i) {
                ControllerRef controllerRef = controllers[i].getControllerRef();
                controllerToVolumeMappings.put(this.getControllerRefKey(controllerRef.getRefToken()), new ControllerData(controllerRef));
            }
            HashMap<String, Volume> volumeMap = new HashMap<String, Volume>();
            Volume[] volumes = objectBundle.getVolume();
            ArrayList<String> listOfVolumeWWNs = new ArrayList<String>();
            for (int i = 0; i < volumes.length; ++i) {
                VolumeRef volumeRef = volumes[i].getVolumeRef();
                ControllerData controllerData = (ControllerData)controllerToVolumeMappings.get(this.getControllerRefKey(volumes[i].getCurrentManager().getRefToken()));
                controllerData.volumeRefs.add(volumeRef);
                volumeMap.put(this.getVolumeRefKey(volumes[i].getVolumeRef().getRefToken()), volumes[i]);
                listOfVolumeWWNs.add(Convert.bytesToString(volumes[i].getWorldWideName()));
            }
            if (this.samplesTaken > 1L) {
                this.findAndHandleDeletedVolumes(listOfVolumeWWNs);
            }
            ControllerData[] controllerData = controllerToVolumeMappings.values().toArray(new ControllerData[controllerToVolumeMappings.size()]);
            for (int i = 0; i < controllerData.length; ++i) {
                ControllerPerfData controllerPerfData;
                VolPerfData[] data;
                boolean controllerWasReset;
                block29: {
                    Vector vRefs = controllerData[i].volumeRefs;
                    controllerWasReset = false;
                    if (vRefs.isEmpty()) continue;
                    AbstractVolRefList avl = new AbstractVolRefList();
                    avl.setAbstractVolRef(vRefs.toArray(new AbstractVolRef[vRefs.size()]));
                    data = null;
                    SYMbolAPIClientV1 client = null;
                    controllerPerfData = this.getControllerPerStats(controllerData[i].controllerRef);
                    client = manager.getClient(this.arrayWWN, Convert.bytesToString(controllerData[i].controllerRef.getRefToken()));
                    long bootTime = client.getObjectGraph().getSa().getSaData().getBootTime();
                    long lastBootTime = controllerPerfData.getBootTime();
                    if (lastBootTime == 0L) {
                        controllerPerfData.setBootTime(bootTime);
                    } else if (lastBootTime != bootTime) {
                        controllerPerfData.setBootTime(bootTime);
                        controllerWasReset = true;
                    }
                    VolumePerformanceList volumePerformanceList = client.getVolumePerformance(avl);
                    data = this.calcVolumePerfStats(volumeMap, volumePerformanceList, controllerWasReset);
                    Object var25_29 = null;
                    try {
                        if (client != null) {
                            client.close();
                        }
                        break block29;
                    }
                    catch (IOException io) {}
                    break block29;
                    {
                        catch (SEItemNotFoundException se) {
                            data = this.markVolumeStatsInvalid(PerfErrorCode.NO_PATH_TO_CONTROLLER, volumeMap, avl);
                            var25_29 = null;
                            try {
                                if (client != null) {
                                    client.close();
                                }
                                break block29;
                            }
                            catch (IOException io) {}
                            break block29;
                        }
                        catch (RPCError re) {
                            data = this.markVolumeStatsInvalid(ErrorCode.ERROR_RPC, volumeMap, avl);
                            var25_29 = null;
                            try {
                                if (client != null) {
                                    client.close();
                                }
                                break block29;
                            }
                            catch (IOException io) {}
                            break block29;
                        }
                        catch (IOException ioe) {
                            data = this.markVolumeStatsInvalid(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY, volumeMap, avl);
                            var25_29 = null;
                            try {
                                if (client != null) {
                                    client.close();
                                }
                                break block29;
                            }
                            catch (IOException io) {}
                        }
                    }
                    catch (Throwable throwable) {
                        var25_29 = null;
                        try {
                            if (client != null) {
                                client.close();
                            }
                        }
                        catch (IOException io) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                this.calcControllerPerfStats(controllerPerfData, data, controllerWasReset);
            }
            this.calcSystemPerfStats();
            ++this.samplesTaken;
        }
        catch (Exception e) {
            Trace.error((Object)this, (Throwable)e);
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "fetchAndProcessPerfSample", "Exited, samples taken so far " + this.samplesTaken);
        }
    }

    long getSamplesTaken() {
        return this.samplesTaken;
    }

    void flushData() {
        this.samplesTaken = 0L;
        this.systemPerfData.clear();
        this.controllerPerfTable.clear();
        this.volPerfTable.clear();
    }

    private void cancelFlushTask() {
        if (this.flushTaskID != null) {
            ClockDaemon.cancel((Object)this.flushTaskID);
            this.flushTaskID = null;
        }
    }

    private void createFlushTask() {
        this.cancelFlushTask();
        if (this.dataRetentionTime == 0L) {
            this.flushData();
        } else {
            FlushTaskThread flushTaskThread = new FlushTaskThread(this);
            this.flushTaskID = clockDaemon.executeAfterDelay(this.dataRetentionTime, (Runnable)flushTaskThread);
        }
    }

    class FlushTaskThread
    extends Thread {
        PerfMonitor monitor;

        public FlushTaskThread(PerfMonitor monitor) {
            this.monitor = monitor;
        }

        public void run() {
            String METHOD_NAME = "run";
            if (this.monitor.getState().equals(PerfMonitorState.OFF)) {
                this.monitor.flushData();
            } else {
                Trace.verbose((Object)this, "run", "FlushTaskThread task not started, Monitor status is ON");
            }
        }
    }

    private class ControllerData {
        ControllerRef controllerRef;
        Vector volumeRefs;

        public ControllerData(ControllerRef controllerRef) {
            this.controllerRef = controllerRef;
            this.volumeRefs = new Vector();
        }
    }
}

