/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VDisk;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.FreeExtent;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.RAIDLevel;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeAction;
import devmgr.versioned.symbol.VolumeGroup;
import devmgr.versioned.symbol.VolumeGroupExpansionDescriptor;
import devmgr.versioned.symbol.VolumeGroupRef;
import devmgr.versioned.symbol.VolumeRAIDMigrationDescriptor;
import devmgr.versioned.symbol.VolumeStatus;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ManageVDisks
implements ManageVDisksInterface {
    public static final String ERROR_ANOTHER_VDISK_DEFRAG = "error.another.vdisk.defrag";
    private ConfigContext context;
    private SearchFilter filter;
    private Scope scope;
    public static final String START_TO_DEFRAGMENT = "true";
    public static final String LIST_OF_DISK_KEYS_DELIMITER = ",";

    public MethodCallStatus offline(List list) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus online(List list) throws ConfigMgmtException {
        return null;
    }

    public int getItemCount() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemCount");
        return this.getItemList().size();
    }

    private Collection getBundles() throws ConfigMgmtException {
        Trace.methodBegin(this, "getBundles");
        ArrayList<ObjectBundle> bundles = null;
        String trayRef = null;
        String arrayWWN = null;
        if (this.scope != null) {
            trayRef = this.getTrayRefFromFilter();
            arrayWWN = this.getArrayWWNFromScope();
        }
        if (arrayWWN != null) {
            bundles = new ArrayList<ObjectBundle>(1);
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWWN);
            bundles.add(ob);
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        return bundles;
    }

    private String getTrayRefFromFilter() {
        String trayRef = null;
        String trayKey = null;
        if (this.filter != null) {
            trayKey = this.filter.getFilterValue("filter-tray");
        }
        if (trayKey != null) {
            Map trayKeyMap = Convert.keyAsStringToMap(trayKey);
            trayRef = (String)trayKeyMap.get("trayRef");
        }
        return trayRef;
    }

    private String getArrayWWNFromScope() throws ConfigMgmtException {
        String arrayWWN = null;
        String trayKey = null;
        if (this.filter != null) {
            trayKey = this.filter.getFilterValue("filter-tray");
        }
        if (trayKey != null) {
            Map trayKeyMap = Convert.keyAsStringToMap(trayKey);
            arrayWWN = (String)trayKeyMap.get("array");
        }
        if (arrayWWN == null) {
            arrayWWN = Convert.scopeToArrayKey(this.scope);
        }
        return arrayWWN;
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD_NAME = "getItemList";
        Trace.methodBegin(this, "getItemList");
        Collection bundles = this.getBundles();
        ArrayList vdiskList = new ArrayList();
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            vdiskList.addAll(this.getVDisksFromBundle(bundle, this.filter));
        }
        Trace.verbose((Object)this, "getItemList", "Number of items in the list = " + vdiskList.size());
        return vdiskList;
    }

    private List getVDisksFromBundle(ObjectBundle bundle, SearchFilter filter) throws ConfigMgmtException {
        String METHOD_NAME = "getVDisksFromBundle";
        Trace.methodBegin(this, "getVDisksFromBundle");
        ArrayList<VDisk> vdiskList = new ArrayList<VDisk>();
        VolumeGroup[] ozVolumeGroups = bundle.getVolumeGroup();
        String trayRef = this.getTrayRefFromFilter();
        if (ozVolumeGroups == null || ozVolumeGroups.length == 0) {
            return vdiskList;
        }
        VolumeGroup ozVolumeGroup = null;
        String ozVolumeGroupRef = null;
        Integer numberOfDisks = null;
        Integer numberOfVolumes = null;
        Integer typeOfDisks = null;
        Integer vDiskDiskStatus = null;
        BigInteger configuredCapacity = null;
        BigInteger totalCapacity = null;
        BigInteger maxVolumeSize = null;
        BigInteger volSizeForActivateRepset = new BigInteger(String.valueOf(276480000));
        Volume[] ozVolumes = bundle.getVolume();
        Drive[] ozDrives = bundle.getDrive();
        FreeExtent[] ozFreeExtents = bundle.getFreeExtent();
        HashMap totalCapacityMap = new HashMap();
        HashMap configuredCapacityMap = new HashMap();
        HashMap maxVolumeSizeMap = new HashMap();
        HashMap numberOfVolumesMap = new HashMap();
        HashMap numberOfDisksMap = new HashMap();
        HashMap typeOfDisksMap = new HashMap();
        HashMap disksStatusMap = new HashMap();
        HashMap vdiskActionMap = new HashMap();
        HashMap vdiskTrayMap = new HashMap();
        ManageVDisks.populateDiskRelatedProperties(numberOfDisksMap, typeOfDisksMap, disksStatusMap, vdiskTrayMap, ozDrives);
        this.populateVolumeRelatedProperties(totalCapacityMap, configuredCapacityMap, maxVolumeSizeMap, numberOfVolumesMap, vdiskActionMap, ozVolumes, ozFreeExtents, bundle.getSa().getFeatureParameters().getMaxVolumesPerGroup());
        String vdiskRefFromKeyAsStringFilter = this.getVDiskRefFromKeyAsStringFilter();
        Map worstVolStatusMap = this.createVDiskWorstVolumeSYMSDKStatusMap(ozVolumes);
        int length = ozVolumeGroups.length;
        for (int i = 0; i < length; ++i) {
            List vdiskRefs;
            ozVolumeGroup = ozVolumeGroups[i];
            ozVolumeGroupRef = Convert.bytesToStringRaw(ozVolumeGroup.getVolumeGroupRef().getRefToken());
            if (!(filter == null || !filter.isEmpty() && vdiskRefFromKeyAsStringFilter != null && vdiskRefFromKeyAsStringFilter.equals(ozVolumeGroupRef) || !filter.isEmpty() && filter.getSearchField().equals("name") && filter.passesFilter("" + ozVolumeGroup.getSequenceNum())) && (filter.isEmpty() || !filter.getSearchField().equals("vdiskForReplicationSetMetadataVolume"))) continue;
            VDisk newVDisk = new VDisk();
            newVDisk.setName("" + ozVolumeGroup.getSequenceNum());
            newVDisk.setWWN(Convert.bytesToString(ozVolumeGroup.getWorldWideName()));
            newVDisk.setRaidLevel(ozVolumeGroup.getRaidLevel().getValue());
            newVDisk.setVDiskReference(ozVolumeGroupRef);
            newVDisk.setStatus(this.calculateVDiskStatus(ozVolumeGroup, worstVolStatusMap));
            if (trayRef != null && (vdiskRefs = (List)vdiskTrayMap.get(trayRef)).indexOf(ozVolumeGroupRef) < 0) continue;
            configuredCapacity = (BigInteger)configuredCapacityMap.get(ozVolumeGroupRef);
            newVDisk.setConfiguredCapacity(configuredCapacity != null ? configuredCapacity : BigInteger.ZERO);
            totalCapacity = (BigInteger)totalCapacityMap.get(ozVolumeGroupRef);
            newVDisk.setTotalCapacity(totalCapacity != null ? totalCapacity : BigInteger.ZERO);
            maxVolumeSize = (BigInteger)maxVolumeSizeMap.get(ozVolumeGroupRef);
            newVDisk.setMaxVolumeSize(maxVolumeSize != null ? maxVolumeSize : BigInteger.ZERO);
            numberOfDisks = (Integer)numberOfDisksMap.get(ozVolumeGroupRef);
            if (numberOfDisks != null) {
                newVDisk.setNumberOfDisks(numberOfDisks);
            }
            if ((typeOfDisks = (Integer)typeOfDisksMap.get(ozVolumeGroupRef)) != null) {
                newVDisk.setTypeOfDisks(typeOfDisks);
            }
            if ((vDiskDiskStatus = (Integer)disksStatusMap.get(ozVolumeGroupRef)) != null) {
                newVDisk.setVDiskDiskStatus(vDiskDiskStatus);
            } else {
                newVDisk.setVDiskDiskStatus(1);
            }
            if (filter != null && !filter.isEmpty() && filter.getSearchField().equals("vdiskForReplicationSetMetadataVolume") && (ozVolumeGroup.getRaidLevel().getValue() == 0 || newVDisk.getMaxVolumeSize().compareTo(volSizeForActivateRepset) < 0 || newVDisk.getVDiskDiskStatus() != 1)) {
                Trace.verbose((Object)this, "getVDisksFromBundle", "Not enough space:" + maxVolumeSize + " on VDisk:" + newVDisk.getName() + " or not all disks in a vdisk with optimal status.");
                continue;
            }
            numberOfVolumes = (Integer)numberOfVolumesMap.get(ozVolumeGroupRef);
            newVDisk.setNumberOfVolumes(numberOfVolumes != null ? numberOfVolumes : 0);
            newVDisk.setObjectItemType("vDisk");
            newVDisk.setAction((Integer)vdiskActionMap.get(ozVolumeGroupRef));
            String arrayWwn = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            Map key = ManageVDisks.getVDiskKeyMap(arrayWwn, ozVolumeGroupRef, newVDisk.getName());
            newVDisk.setKey(key);
            vdiskList.add(newVDisk);
        }
        return vdiskList;
    }

    private Map createVDiskWorstVolumeSYMSDKStatusMap(Volume[] vols) {
        HashMap<String, Integer> vDiskToVolMap = new HashMap<String, Integer>();
        boolean status = true;
        for (int i = 0; i < vols.length; ++i) {
            Volume vol = vols[i];
            String vDiskRef = Convert.bytesToString(vol.getVolumeGroupRef().getRefToken());
            VolumeStatus tmpStatus = vols[i].getStatus();
            if (vDiskToVolMap.get(vDiskRef) == null) {
                vDiskToVolMap.put(vDiskRef, new Integer(tmpStatus.getValue()));
                continue;
            }
            int oldStatus = (Integer)vDiskToVolMap.get(vDiskRef);
            int newStatus = this.getWorseSYMSDKStatus(oldStatus, tmpStatus.getValue());
            vDiskToVolMap.put(vDiskRef, new Integer(newStatus));
        }
        return vDiskToVolMap;
    }

    private int convertSYMStatus(int SYMSDKstatus) {
        int status = 15;
        switch (SYMSDKstatus) {
            case 1: {
                status = 7;
                break;
            }
            case 2: {
                status = 5;
                break;
            }
            case 3: {
                status = 2;
                break;
            }
            case 4: {
                status = 3;
                break;
            }
        }
        return status;
    }

    private int getWorseSYMSDKStatus(int status1, int status2) {
        int retVal = 1;
        if (status1 == status2) {
            retVal = status1;
        } else if (status1 == 4 || status2 == 4) {
            retVal = 4;
        } else if (status1 == 3 || status2 == 3) {
            retVal = 3;
        } else if (status1 == 2 || status2 == 2) {
            retVal = 2;
        }
        return retVal;
    }

    private int calculateVDiskStatus(VolumeGroup ozVolumeGroup, Map vDiskToVolMap) {
        int status = 4;
        String vDiskRef = Convert.bytesToString(ozVolumeGroup.getVolumeGroupRef().getRefToken());
        Integer SYMSDKstatus = (Integer)vDiskToVolMap.get(vDiskRef);
        if (!ozVolumeGroup.getOffline()) {
            if (null != SYMSDKstatus) {
                status = this.convertSYMStatus(SYMSDKstatus);
            }
        } else {
            status = 15;
        }
        return status;
    }

    static void populateDiskRelatedProperties(HashMap numberOfDisksMap, HashMap typeOfDisksMap, HashMap disksStatusMap, HashMap vdiskTrayMap, Drive[] drives) {
        if (drives == null || drives.length == 0) {
            return;
        }
        Drive ozDrive = null;
        String ozVolumeGroupRef = null;
        Integer numberOfDisks = null;
        Integer typeOfDisks = null;
        int drivesLength = drives.length;
        for (int i = 0; i < drivesLength; ++i) {
            String ozTrayRef;
            ArrayList<String> vdisksOnTray;
            ozDrive = drives[i];
            ozVolumeGroupRef = Convert.bytesToStringRaw(ozDrive.getCurrentVolumeGroupRef().getRefToken());
            numberOfDisks = (Integer)numberOfDisksMap.get(ozVolumeGroupRef);
            if (numberOfDisks != null) {
                numberOfDisks = new Integer(numberOfDisks + 1);
                numberOfDisksMap.put(ozVolumeGroupRef, numberOfDisks);
            } else {
                numberOfDisksMap.put(ozVolumeGroupRef, new Integer(1));
            }
            typeOfDisks = (Integer)typeOfDisksMap.get(ozVolumeGroupRef);
            if (typeOfDisks == null) {
                typeOfDisksMap.put(ozVolumeGroupRef, new Integer(ozDrive.getPhyDriveType().getValue()));
            }
            if (ozDrive.getStatus().getValue() != 1) {
                disksStatusMap.put(ozVolumeGroupRef, new Integer(ozDrive.getStatus().getValue()));
            }
            if ((vdisksOnTray = (ArrayList<String>)vdiskTrayMap.get(ozTrayRef = Convert.bytesToString(ozDrive.getPhysicalLocation().getTrayRef().getRefToken()))) == null) {
                vdisksOnTray = new ArrayList<String>();
                vdiskTrayMap.put(ozTrayRef, vdisksOnTray);
            }
            if (vdisksOnTray.indexOf(ozVolumeGroupRef) >= 0) continue;
            vdisksOnTray.add(ozVolumeGroupRef);
        }
    }

    private void populateVolumeRelatedProperties(HashMap totalCapacityMap, HashMap configuredCapacityMap, HashMap maxVolumeSizeMap, HashMap numberOfVolumesMap, HashMap vdiskActionMap, Volume[] volumes, FreeExtent[] freeExtents, int maxVolumePerVdisk) {
        int i;
        Volume ozVolume = null;
        String ozVolumeGroupRef = null;
        BigInteger someCapacity = null;
        Integer numberOfVolumes = null;
        FreeExtent ozFreeExtent = null;
        BigInteger freeExtentCapacity = null;
        BigInteger maxVolumeSize = null;
        if (volumes != null) {
            int volumesLength = volumes.length;
            for (i = 0; i < volumesLength; ++i) {
                ozVolume = volumes[i];
                ozVolumeGroupRef = Convert.bytesToStringRaw(ozVolume.getVolumeGroupRef().getRefToken());
                someCapacity = (BigInteger)configuredCapacityMap.get(ozVolumeGroupRef);
                if (someCapacity != null) {
                    someCapacity = someCapacity.add(new BigInteger("" + ozVolume.getCapacity()));
                    configuredCapacityMap.put(ozVolumeGroupRef, someCapacity);
                    totalCapacityMap.put(ozVolumeGroupRef, someCapacity);
                } else {
                    configuredCapacityMap.put(ozVolumeGroupRef, new BigInteger("" + ozVolume.getCapacity()));
                    totalCapacityMap.put(ozVolumeGroupRef, new BigInteger("" + ozVolume.getCapacity()));
                }
                numberOfVolumes = (Integer)numberOfVolumesMap.get(ozVolumeGroupRef);
                if (numberOfVolumes != null) {
                    numberOfVolumes = new Integer(numberOfVolumes + 1);
                    numberOfVolumesMap.put(ozVolumeGroupRef, numberOfVolumes);
                } else {
                    numberOfVolumesMap.put(ozVolumeGroupRef, new Integer(1));
                }
                VolumeAction action = ozVolume.getAction();
                if (vdiskActionMap.containsKey(ozVolumeGroupRef) && action.getValue() == 1) continue;
                vdiskActionMap.put(ozVolumeGroupRef, new Integer(action.getValue()));
            }
        }
        if (freeExtents != null) {
            int freeExtentsLength = freeExtents.length;
            for (i = 0; i < freeExtentsLength; ++i) {
                ozFreeExtent = freeExtents[i];
                ozVolumeGroupRef = Convert.bytesToStringRaw(ozFreeExtent.getVolumeGroupRef().getRefToken());
                freeExtentCapacity = new BigInteger("" + ozFreeExtent.getRawCapacity());
                someCapacity = (BigInteger)totalCapacityMap.get(ozVolumeGroupRef);
                if (someCapacity != null) {
                    someCapacity = someCapacity.add(freeExtentCapacity);
                    totalCapacityMap.put(ozVolumeGroupRef, someCapacity);
                } else {
                    totalCapacityMap.put(ozVolumeGroupRef, freeExtentCapacity);
                }
                maxVolumeSize = (BigInteger)maxVolumeSizeMap.get(ozVolumeGroupRef);
                numberOfVolumes = (Integer)numberOfVolumesMap.get(ozVolumeGroupRef);
                if (numberOfVolumes == null || numberOfVolumes >= maxVolumePerVdisk) continue;
                if (maxVolumeSize != null) {
                    if (maxVolumeSize.compareTo(freeExtentCapacity) >= 0) continue;
                    maxVolumeSizeMap.put(ozVolumeGroupRef, freeExtentCapacity);
                    continue;
                }
                maxVolumeSizeMap.put(ozVolumeGroupRef, freeExtentCapacity);
            }
        }
    }

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        this.context = context;
        this.scope = scope;
        this.filter = filter;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        if (key == null || props == null) {
            LogAPI.staticLog((String)"VDISK_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply non-null key and Properties object for modify.");
        }
        String arrayWwn = this.getArrayWwnFromScope();
        String vdiskRefString = null;
        String vdiskName = null;
        if (key instanceof Map) {
            vdiskRefString = (String)((Map)key).get("vdiskRef");
            vdiskName = (String)((Map)key).get("vdiskName");
        } else if (key instanceof String) {
            Map map = Convert.keyAsStringToMap((String)key);
            vdiskRefString = (String)map.get("vdiskRef");
            vdiskName = (String)map.get("vdiskName");
        }
        if (vdiskRefString == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply non-null key values for object to modify.");
        }
        VolumeGroupRef vdiskRef = new VolumeGroupRef();
        vdiskRef.setRefToken(Convert.stringToBytes(vdiskRefString));
        try {
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayWwn);
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                VDisk vd;
                String propName = (String)enumeration.nextElement();
                Trace.verbose((Object)this, "modify", "Processing request: " + propName);
                if (propName.equals("defragment")) {
                    if (!START_TO_DEFRAGMENT.equals(props.getProperty(propName))) continue;
                    this.startVolumeGroupDefrag(vdiskRef, arrayWwn, vdiskName);
                    continue;
                }
                if (propName.equals("listOfDiskKeys")) {
                    String listOfDiskKeyString = props.getProperty(propName);
                    if (listOfDiskKeyString == null) continue;
                    this.checkVDiskVolumesProfiles(vdiskRefString, arrayWwn);
                    StringTokenizer st = new StringTokenizer(listOfDiskKeyString, LIST_OF_DISK_KEYS_DELIMITER);
                    if (st.countTokens() > 0) {
                        String driveRefString = null;
                        DriveRef driveRef = null;
                        int tokenCount = st.countTokens();
                        DriveRef[] driveRefs = new DriveRef[tokenCount];
                        for (int i = 0; i < tokenCount; ++i) {
                            driveRefString = (String)Convert.keyAsStringToMap(st.nextToken()).get("diskRef");
                            driveRef = new DriveRef();
                            driveRef.setRefToken(Convert.stringToBytes(driveRefString));
                            driveRefs[i] = driveRef;
                        }
                        this.startVolumeGroupExpansion(vdiskRef, driveRefs, arrayWwn, vdiskName);
                        continue;
                    }
                    LogAPI.staticLog((String)"VDISK_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
                    throw new ConfigMgmtException("incorrect.method.parameter", "Invalid list of disk key strings passed." + listOfDiskKeyString);
                }
                if (propName.equals("raidLevel")) {
                    String newRAIDLevel = props.getProperty(propName);
                    int newRAIDLevelInt = -1;
                    try {
                        newRAIDLevelInt = Integer.parseInt(newRAIDLevel);
                    }
                    catch (NumberFormatException nfe) {
                        String msg = "Invalid raid level: " + newRAIDLevel;
                        Trace.error((Object)this, "modify", msg);
                        LogAPI.staticLog((String)"VDISK_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
                        throw new ConfigMgmtException("INVALID_PROFILE_RAID_LEVEL", msg);
                    }
                    ProfileDataManager.validateRaidLevel(newRAIDLevelInt);
                    VolumeGroup volumeGroup = this.getVolumeGroupByReference(ObjectBundleManager.getInstance().getObjectBundle(arrayWwn).getVolumeGroup(), vdiskRefString);
                    if (newRAIDLevelInt == volumeGroup.getRaidLevel().getValue()) continue;
                    this.startVolumeRAIDMigration(vdiskRef, newRAIDLevelInt, arrayWwn, vdiskName);
                    continue;
                }
                if (propName.equals("revive")) {
                    vd = this.findVDisk(key);
                    if (vd.getStatus() != 2) {
                        Trace.error((Object)this, "modify", "Virtual Disk is not failed, nothing to revive");
                        throw new ConfigMgmtException("error.cannot.revive.online.vdisk", new String[]{vd.getName()}, "Virtual Disk is not failed. Nothing to revive", null);
                    }
                    this.execRecoveryOperation(38, vdiskRef, vdiskName, arrayWwn);
                    continue;
                }
                if (propName.equals("offline")) {
                    vd = this.findVDisk(key);
                    if (vd.getStatus() == 15) {
                        Trace.error((Object)this, "modify", "Virtual Disk is already offline");
                        throw new ConfigMgmtException("error.vdisk.already.offline", new String[]{vd.getName()}, "Virtual Disk is already offline.", null);
                    }
                    this.execRecoveryOperation(17, vdiskRef, vdiskName, arrayWwn);
                    continue;
                }
                if (propName.equals("online")) {
                    vd = this.findVDisk(key);
                    if (vd.getStatus() != 15) {
                        Trace.error((Object)this, "modify", "Virtual Disk is already online");
                        throw new ConfigMgmtException("error.vdisk.already.online", new String[]{vd.getName()}, "Virtual Disk is already online.", null);
                    }
                    this.execRecoveryOperation(18, vdiskRef, vdiskName, arrayWwn);
                    continue;
                }
                if (propName.equals("init")) {
                    this.initializeVDisk(vdiskRefString, vdiskName, arrayWwn, bundle);
                    continue;
                }
                LogAPI.staticLog((String)"VDISK_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
                throw new ConfigMgmtException("incorrect.method.parameter", "Unknown modify request: " + propName);
            }
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"VDISK_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw cme;
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayWwn);
        }
        LogAPI.staticLog((String)"VDISK_MODIFY_SUCCESS", (String[])new String[0], (String[])new String[0]);
    }

    private VDisk findVDisk(Object key) throws ConfigMgmtException {
        String methodName = "findVDisk";
        String strKey = null;
        strKey = key instanceof Map ? Convert.keyToString((Map)key) : (String)key;
        SearchFilter _filter = new SearchFilter("keyAsString", strKey);
        Scope _scope = new Scope(this.scope);
        ManageVDisks mv = new ManageVDisks();
        mv.init(this.context, _scope, _filter);
        List vdiskList = mv.getItemList();
        if (!vdiskList.isEmpty()) {
            return (VDisk)vdiskList.get(0);
        }
        Trace.error((Object)this, "findVDisk", "Cannot find the vdisk with the key:" + strKey);
        throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), strKey);
    }

    private void initializeVDisk(String vdiskRefString, String vdiskName, String arraywwn, ObjectBundle bundle) throws ConfigMgmtException {
        String methodName = "initializeVDisk";
        try {
            CommandProcessor command = new CommandProcessor(arraywwn);
            ReturnCode rc = new ReturnCode();
            Volume[] ozVols = bundle.getVolume();
            int sz = ozVols == null ? 0 : ozVols.length;
            for (int i = 0; i < sz; ++i) {
                byte[] refToken = ozVols[i].getVolumeGroupRef().getRefToken();
                if (!vdiskRefString.equals(Convert.bytesToString(refToken))) continue;
                String volName = UnicodeTranslator.getString((byte[])ozVols[i].getLabel().getValue());
                Trace.verbose((Object)this, "initializeVDisk", "initialize volume:" + volName);
                command.execute(12, (XDRType)ozVols[i].getVolumeRef(), (XDRType)rc, true);
                int codeValue = rc.getValue();
                if (codeValue != 1 && codeValue != 14) {
                    Trace.error((Object)this, "initializeVDisk", "Volume initialization failed for volume:" + volName + " with error code:" + codeValue);
                    throw new ConfigMgmtException("error.volume.format.failed", new String[]{volName}, ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + codeValue), null);
                }
                Trace.verbose((Object)this, "initializeVDisk", "volume initalize operation started");
                rc.setValue(-1);
            }
        }
        catch (RPCError e) {
            Trace.error((Object)this, "initializeVDisk", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), new String[]{vdiskName}, "initialize vdisk failed with RPCError.", (Exception)((Object)e));
        }
        catch (IOException e) {
            Trace.error((Object)this, "initializeVDisk", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), new String[]{vdiskName}, "initialize vdisk failed with IOException.", e);
        }
    }

    private void execRecoveryOperation(int proc, VolumeGroupRef vdiskRef, String vdiskName, String arraywwn) throws ConfigMgmtException {
        String methodName = "execRecoveryOperation";
        try {
            int codeValue;
            CommandProcessor command = new CommandProcessor(arraywwn);
            ReturnCode rc = new ReturnCode();
            command.execute(proc, (XDRType)vdiskRef, (XDRType)rc, true);
            int n = codeValue = rc != null ? rc.getValue() : -1;
            if (codeValue != 1 && codeValue != 14) {
                String message = "Procedure: " + proc + " failed with the error code: " + codeValue;
                Trace.error((Object)this, "execRecoveryOperation", message);
                String key = ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + codeValue);
                throw new ConfigMgmtException(key, new String[]{vdiskName}, message, null);
            }
        }
        catch (RPCError e) {
            Trace.error((Object)this, "execRecoveryOperation", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), new String[]{vdiskName}, "revive vdisk failed with RPCError.", (Exception)((Object)e));
        }
        catch (IOException e) {
            Trace.error((Object)this, "execRecoveryOperation", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), new String[]{vdiskName}, "revive vdisk failed with IOException.", e);
        }
    }

    private void checkVDiskVolumesProfiles(String vdiskRefString, String arrayWwn) throws ConfigMgmtException {
        Volume[] ozVolumes = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn).getVolume();
        PoolDataManager pdm = new PoolDataManager(arrayWwn);
        Map poolMap = pdm.getRawPoolMap();
        ProfileDataManager profdm = new ProfileDataManager(arrayWwn);
        Map profileMap = profdm.getRawProfileMap();
        Volume ozVol = null;
        int vpid = -1;
        PoolData pd = null;
        Profile p = null;
        int size = ozVolumes == null ? 0 : ozVolumes.length;
        for (int i = 0; i < size; ++i) {
            ozVol = ozVolumes[i];
            if (!vdiskRefString.equals(Convert.bytesToStringRaw(ozVol.getVolumeGroupRef().getRefToken())) || (vpid = ozVol.getMgmtClientAttribute()) == 0 || poolMap == null || (pd = (PoolData)poolMap.get("" + vpid)) == null || profileMap == null || (p = (Profile)profileMap.get(pd.profileId)).getNumberOfDisks() == 0) continue;
            throw new ConfigMgmtException("vdisk.expand.error", "One of the vdisk volumes has profile with fixed number of disks.");
        }
    }

    void startVolumeGroupExpansion(VolumeGroupRef vdiskRef, DriveRef[] driveRefs, String arrayWwn, String vdiskName) throws ConfigMgmtException {
        String METHOD_NAME = "startVolumeGroupExpansion";
        Trace.methodBegin(this, "startVolumeGroupExpansion");
        VolumeGroupExpansionDescriptor vged = new VolumeGroupExpansionDescriptor();
        vged.setVolumeGroupRef(vdiskRef);
        vged.setDriveRef(driveRefs);
        this.modifyVDisk((XDRType)vged, arrayWwn, vdiskName);
    }

    void startVolumeGroupDefrag(VolumeGroupRef vdiskRef, String arrayWwn, String vdiskName) throws ConfigMgmtException {
        String METHOD_NAME = "startVolumeGroupDefrag";
        Trace.methodBegin(this, "startVolumeGroupDefrag");
        this.modifyVDisk((XDRType)vdiskRef, arrayWwn, vdiskName);
    }

    void startVolumeRAIDMigration(VolumeGroupRef vdiskRef, int raidLevel, String arrayWwn, String vdiskName) throws ConfigMgmtException {
        String METHOD_NAME = "startVolumeRAIDMigration";
        Trace.methodBegin(this, "startVolumeRAIDMigration");
        VolumeRAIDMigrationDescriptor vrmd = new VolumeRAIDMigrationDescriptor();
        vrmd.setNewRaidLevel(new RAIDLevel(raidLevel));
        vrmd.setVolumeGroupRef(vdiskRef);
        this.modifyVDisk((XDRType)vrmd, arrayWwn, vdiskName);
    }

    private void modifyVDisk(XDRType modifyDescriptor, String arrayWwn, String vdiskName) throws ConfigMgmtException {
        String METHOD_NAME = "modifyVDisk";
        Trace.methodBegin(this, "modifyVDisk");
        String modifyAction = null;
        try {
            int codeValue;
            CommandProcessor command = new CommandProcessor(arrayWwn);
            ReturnCode code = new ReturnCode();
            if (modifyDescriptor instanceof VolumeGroupExpansionDescriptor) {
                modifyAction = "VDisk expansion ";
                command.execute(21, modifyDescriptor, (XDRType)code, true);
            } else if (modifyDescriptor instanceof VolumeGroupRef) {
                modifyAction = "VDisk defragmentation ";
                command.execute(20, modifyDescriptor, (XDRType)code, true);
            } else if (modifyDescriptor instanceof VolumeRAIDMigrationDescriptor) {
                modifyAction = "VDisk RAID migration ";
                command.execute(22, modifyDescriptor, (XDRType)code, true);
            } else {
                throw new ConfigMgmtException("incorrect.method.parameter", new String[]{vdiskName}, "Object type passed not supported.", null);
            }
            int n = codeValue = code != null ? code.getValue() : -1;
            if (codeValue != 1) {
                String message = modifyAction + " failed with the error code: " + codeValue;
                Trace.verbose((Object)this, "modifyVDisk", message);
                String key = ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + codeValue);
                if (modifyDescriptor instanceof VolumeGroupRef && codeValue == 11) {
                    key = ERROR_ANOTHER_VDISK_DEFRAG;
                }
                throw new ConfigMgmtException(key, new String[]{vdiskName}, message, null);
            }
            Trace.verbose((Object)this, "modifyVDisk", modifyAction + " successfully started.");
        }
        catch (RPCError e) {
            Trace.error((Object)this, "modifyVDisk", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), new String[]{vdiskName}, modifyAction + " failed with RPCError.", (Exception)((Object)e));
        }
        catch (IOException e) {
            Trace.error((Object)this, "modifyVDisk", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), new String[]{vdiskName}, modifyAction + " failed with IOException.", e);
        }
    }

    private String getArrayWwnFromScope() throws ConfigMgmtException {
        if (this.scope != null) {
            return Convert.scopeToArrayKey(this.scope);
        }
        throw new ConfigMgmtException("error.scope.required", "Array scope not set before using of the vdisk manager.");
    }

    private String getVDiskRefFromKeyAsStringFilter() {
        String keyAsString;
        String vdiskRef = null;
        if (this.filter != null && !this.filter.isEmpty() && this.filter.getFilterValue("keyAsString") != null && (keyAsString = this.filter.getFilterValue("keyAsString")) != null) {
            Map map = Convert.keyAsStringToMap(keyAsString);
            vdiskRef = (String)map.get("vdiskRef");
        }
        return vdiskRef;
    }

    private VolumeGroup getVolumeGroupByReference(VolumeGroup[] volumeGroups, String volumeGroupRefString) throws ConfigMgmtException {
        VolumeGroup volumeGroup = null;
        if (volumeGroupRefString != null) {
            int size = volumeGroups == null ? 0 : volumeGroups.length;
            for (int i = 0; i < size; ++i) {
                if (!volumeGroupRefString.equals(Convert.bytesToStringRaw(volumeGroups[i].getVolumeGroupRef().getRefToken()))) continue;
                volumeGroup = volumeGroups[i];
                break;
            }
        }
        if (volumeGroup == null) {
            throw new ConfigMgmtException("vdisk.lookup.error", "Unable to lookup vdisk with reference = " + volumeGroupRefString);
        }
        return volumeGroup;
    }

    public List getVDisksByPoolAndSize(Object poolKey, BigInteger requestedSize) throws ConfigMgmtException {
        String METHOD_NAME = "getVDisksByPool";
        Trace.methodBegin(this, "getVDisksByPool");
        String arrayWwn = this.getArrayWwnFromScope();
        if (requestedSize == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a size for: getVDisksByPool");
        }
        Map poolKeyMap = null;
        PoolData pool = null;
        if (poolKey instanceof Map) {
            poolKeyMap = (Map)poolKey;
        } else if (poolKey instanceof String) {
            poolKeyMap = Convert.keyAsStringToMap((String)poolKey);
        }
        if (poolKeyMap != null) {
            PoolDataManager pooldm = new PoolDataManager(arrayWwn);
            String poolId = (String)poolKeyMap.get("id");
            pool = pooldm.getPoolData(poolId);
            if (pool == null) {
                throw new ConfigMgmtException("incorrect.method.parameter", "Could not look up the pool with the key passed.");
            }
        } else {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply pool key for: getVDisksByPool");
        }
        ProfileDataManager profdm = new ProfileDataManager(arrayWwn);
        Profile profile = profdm.getProfile(pool.profileId);
        int profileRaidLevel = profile.getRaidLevel();
        int profileDiskType = ProfileDataManager.convertProfileDriveTypeTo6130DriveType(profile.getDriveType());
        int profileNumberOfDisks = profile.getNumberOfDisks();
        List allVdisks = this.getItemList();
        ArrayList<VDisk> vdisksByPool = new ArrayList<VDisk>();
        Iterator iter = allVdisks.iterator();
        while (iter.hasNext()) {
            VDisk vdisk = (VDisk)iter.next();
            if (vdisk.getStatus() != 7 && vdisk.getStatus() != 4 || vdisk.getVDiskDiskStatus() != 1) continue;
            try {
                ManageVolumes.validateRaidLevel(profileRaidLevel, vdisk.getRaidLevel());
                ManageVolumes.validateDiskType(profileDiskType, vdisk.getTypeOfDisks());
                ManageVolumes.validateNumberOfDisks(profileNumberOfDisks, vdisk.getNumberOfDisks());
                if (requestedSize.compareTo(vdisk.getMaxVolumeSize()) > 0) continue;
                vdisksByPool.add(vdisk);
            }
            catch (ConfigMgmtException cme) {}
        }
        Trace.verbose((Object)this, "getVDisksByPool", "Number of items in the list = " + vdisksByPool.size());
        return vdisksByPool;
    }

    public List getBigEnoughVDisks(BigInteger requestedSize) throws ConfigMgmtException {
        String METHOD_NAME = "getBigEnoughVDisks";
        Trace.methodBegin(this, "getBigEnoughVDisks");
        if (requestedSize == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a size for: getBigEnoughVDisks");
        }
        VDisk vdisk = null;
        List allVDisks = this.getItemList();
        ArrayList<VDisk> bigEnoughVDisks = new ArrayList<VDisk>();
        Iterator iter = allVDisks.iterator();
        while (iter.hasNext()) {
            vdisk = (VDisk)iter.next();
            if (vdisk.getVDiskDiskStatus() != 1 || requestedSize.compareTo(vdisk.getMaxVolumeSize()) > 0) continue;
            bigEnoughVDisks.add(vdisk);
        }
        Trace.verbose((Object)this, "getBigEnoughVDisks", "Number of items in the list = " + bigEnoughVDisks.size());
        return bigEnoughVDisks;
    }

    public ArrayList getExternalItemsBySystem() throws ConfigMgmtException {
        return null;
    }

    public void init(ConfigContext cc, SearchFilter sf) {
    }

    public VDiskInterface getItemByName(String name) throws ConfigMgmtException {
        return null;
    }

    public ArrayList getUnassignedVDisks() throws ConfigMgmtException {
        return null;
    }

    public ArrayList getItemsByArray(String t4Name) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByTray(String t4Name, String trayId) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        return null;
    }

    public ArrayList getItemsByStorageDomain(String domainName) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByStoragePool(String poolName, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByVolume(String name) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public VDiskInterface getByKey(Collection key) throws ConfigMgmtException {
        return null;
    }

    public static Map getVDiskKeyMap(String arrayWwn, String vdiskRef, String vdiskName) {
        HashMap<String, String> key = new HashMap<String, String>(3);
        key.put("arrayRef", arrayWwn);
        key.put("vdiskRef", vdiskRef);
        key.put("vdiskName", vdiskName);
        key.put("array-type", "6130");
        return key;
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String VDISK_FOR_REPLICATION_SET_METADATA_VOLUME = "vdiskForReplicationSetMetadataVolume";
    }

    public static interface KeyMap {
        public static final String ARRAY = "array";
        public static final String VDISK_REF = "vdiskRef";
        public static final String VDISK_NAME = "vdiskName";
        public static final String ARRAY_TYPE = "array-type";
    }

    public static interface ModifyProps {
        public static final String DEFRAGMENT = "defragment";
        public static final String LIST_OF_DISK_KEYS = "listOfDiskKeys";
        public static final String RAID_LEVEL = "raidLevel";
        public static final String REVIVE = "revive";
        public static final String OFFLINE = "offline";
        public static final String ONLINE = "online";
        public static final String INITIALIZE = "init";
    }
}

