/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Tray;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.UnicodeTranslator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManageTrays
implements ManageTraysInterface {
    String arrayName;
    SearchFilter sf;
    ConfigContext cfgctx;
    Scope scope;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        this.arrayName = null;
        this.sf = filter;
        if (this.sf != null && this.sf.getSearchField() != null && this.sf.getSearchField().equals("array")) {
            this.arrayName = this.sf.getSearchString();
        }
    }

    public void init(ConfigContext ctx, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = ctx;
        this.scope = s;
        this.sf = f;
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        ArrayList<ObjectBundle> bundles = null;
        ArrayList<Tray> trayList = new ArrayList<Tray>();
        if (this.scope != null) {
            String arrayWWN = Convert.scopeToArrayKey(this.scope);
            ArrayList<ObjectBundle> bl = new ArrayList<ObjectBundle>(1);
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWWN);
            bl.add(ob);
            bundles = bl;
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            HashMap disks = this.hashDisks(bundle);
            String an = UnicodeTranslator.getString((byte[])bundle.getSa().getSaData().getStorageArrayLabel().getValue());
            String arrayWWN = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            if (this.arrayName != null && !an.equals(this.arrayName)) continue;
            devmgr.versioned.symbol.Tray[] ozTrays = bundle.getTray();
            int count = ozTrays == null ? 0 : ozTrays.length;
            for (int i = 0; i < count; ++i) {
                devmgr.versioned.symbol.Tray ozTray = ozTrays[i];
                String tok = Convert.bytesToStringRaw(ozTray.getTrayRef().getRefToken());
                Tray tray = new Tray();
                List driveListForTray = (List)disks.get(tok);
                int maxSpindleSpeed = 0;
                int driveType = -1;
                Iterator it = driveListForTray.iterator();
                while (it.hasNext()) {
                    Drive currDrive = (Drive)it.next();
                    int currSpindleSpeed = currDrive.getSpindleSpeed();
                    if (currSpindleSpeed > maxSpindleSpeed) {
                        maxSpindleSpeed = currSpindleSpeed;
                    }
                    if (driveType != -1) continue;
                    driveType = currDrive.getPhyDriveType().getValue();
                }
                tray.setMaxSpindleSpeed(maxSpindleSpeed);
                tray.setName(new String("" + ozTray.getTrayId()));
                tray.setStatus(new Integer(this.getTrayStatus(ozTray)).toString());
                tray.setRole(new Integer(this.getRole(ozTray)).toString());
                tray.setState(2);
                tray.setArrayName(an);
                tray.setTrayType(ozTray.getType().getValue());
                tray.setNumberOfDrives(((List)disks.get(tok)).size());
                tray.setDriveType(driveType);
                tray.setOrientation(ozTray.getOrientation().getValue());
                tray.setNumControllerSlots(ozTray.getNumControllerSlots());
                tray.setNumDriveSlots(ozTray.getNumDriveSlots());
                tray.setNonRedundantAccess(ozTray.getNonRedundantAccess());
                tray.setPartNumber(ozTray.getPartNumber());
                tray.setSerialNumber(ozTray.getSerialNumber());
                tray.setVendorName(ozTray.getVendorName());
                tray.setManufactureDate(Long.toString(ozTray.getManufacturerDate()));
                tray.setFruType(ozTray.getFruType());
                tray.setTrayIdMismatch(ozTray.getTrayIDMismatch());
                tray.setTrayIdConflict(ozTray.getTrayIDConflict());
                tray.setEsmVesionMismatch(ozTray.getEsmVersionMismatch());
                tray.setEsmMiswire(ozTray.getEsmMiswire());
                tray.setMhsSpeedMismatch(ozTray.getDrvMHSpeedMismatch());
                tray.setUnsupportedTray(ozTray.getUnsupportedTray());
                tray.setWorkingChannel(ozTray.getWorkingChannel());
                tray.setMaxSpeed(ozTray.getMaxSpeed().getValue());
                tray.setObjectItemType("tray");
                HashMap<String, String> refKey = new HashMap<String, String>(2);
                refKey.put("array", arrayWWN);
                refKey.put("trayRef", tok);
                tray.setKey(refKey);
                trayList.add(tray);
            }
        }
        if (this.sf != null) {
            return this.filterList(trayList);
        }
        return trayList;
    }

    private HashMap hashDisks(ObjectBundle bundle) {
        HashMap disks = new HashMap();
        Drive[] drive = bundle.getDrive();
        int size = drive == null ? 0 : drive.length;
        for (int i = 0; i < size; ++i) {
            Drive d = drive[i];
            String tok = Convert.bytesToStringRaw(d.getPhysicalLocation().getTrayRef().getRefToken());
            ArrayList<Drive> td = (ArrayList<Drive>)disks.get(tok);
            if (td == null) {
                td = new ArrayList<Drive>();
            }
            if (d.getStatus().getValue() != 6) {
                td.add(d);
            }
            disks.put(tok, td);
        }
        return disks;
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getItemList().size();
    }

    public boolean isOperationSupported(String operation) {
        return false;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        throw new ConfigMgmtException();
    }

    public void setScope(InstanceWrapper scope) {
    }

    private int getTrayStatus(devmgr.versioned.symbol.Tray ozTray) {
        if (ozTray.getTrayIDMismatch()) {
            return 1;
        }
        if (ozTray.getTrayIDConflict()) {
            return 2;
        }
        if (ozTray.getEsmVersionMismatch()) {
            return 3;
        }
        if (ozTray.getEsmMiswire()) {
            return 4;
        }
        if (ozTray.getDrvMHSpeedMismatch()) {
            return 5;
        }
        if (ozTray.getUnsupportedTray()) {
            return 6;
        }
        return 0;
    }

    private int getRole(devmgr.versioned.symbol.Tray ozTray) {
        int trayType = ozTray.getType().getValue();
        if (trayType == 1 || trayType == 3 || trayType == 4 || trayType == 7 || trayType == 8) {
            return 1;
        }
        if (trayType == 2 || trayType == 6 || trayType == 6) {
            return 2;
        }
        return 0;
    }

    private List filterList(List trayList) {
        String name;
        String methodName = "filterList";
        Trace.verbose((Object)this, "filterList", "Filtering tray list....");
        ArrayList<Tray> filteredList = new ArrayList<Tray>();
        String trayRef = this.getTrayRefFromFilter();
        if (trayRef != null) {
            Trace.verbose((Object)this, "filterList", "Filtering by tray key");
            Iterator iter = trayList.iterator();
            while (iter.hasNext()) {
                Tray t = (Tray)iter.next();
                Map key = t.getKey();
                String currTrayRef = (String)key.get("trayRef");
                if (!trayRef.equals(currTrayRef)) continue;
                filteredList.add(t);
                break;
            }
        }
        if ((name = this.getNameFromFilter()) != null) {
            Trace.verbose((Object)this, "filterList", "Filtering by tray name");
            Iterator iter = trayList.iterator();
            while (iter.hasNext()) {
                Tray t = (Tray)iter.next();
                Map key = t.getKey();
                if (!this.sf.passesFilter(t.getName())) continue;
                filteredList.add(t);
            }
        }
        return filteredList;
    }

    private String getTrayRefFromFilter() {
        String methodName = "getTrayRefFromFilter";
        String trayRef = null;
        if (this.sf != null && !this.sf.isEmpty()) {
            if (this.sf.getSearchField().equals("keyAsString")) {
                String keyAsString = this.sf.getSearchString();
                if (keyAsString != null) {
                    Map map = Convert.keyAsStringToMap(keyAsString);
                    trayRef = (String)map.get("trayRef");
                }
            } else if (this.sf.getSearchField().equals("trayRef")) {
                trayRef = this.sf.getSearchString();
            }
        }
        return trayRef;
    }

    private String getNameFromFilter() {
        String methodName = "getNameFromFilter";
        String ref = null;
        if (this.sf != null && !this.sf.isEmpty() && this.sf.getSearchField().equals("name")) {
            ref = this.sf.getSearchString();
        }
        return ref;
    }

    static interface TrayTypes {
        public static final int UNKNOWN = 0;
        public static final int CONTROLLER_MODULE = 1;
        public static final int DRIVE_MODULE = 2;
    }

    static interface TrayStatus {
        public static final int OK = 0;
        public static final int TRAY_ID_MISMATCH = 1;
        public static final int TRAY_ID_CONFLICT = 2;
        public static final int TRAY_ESM_VERSION_MISMATCH = 3;
        public static final int TRAY_ESM_MISWIRE = 4;
        public static final int TRAY_DRIVE_MINIHUB_SPEED_MISMATCH = 5;
        public static final int TRAY_UNSUPPORTED_TRAY = 6;
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String TRAY_REF = "trayRef";
    }

    public static interface KeyMap {
        public static final String ARRAY = "array";
        public static final String TRAY_REF = "trayRef";
    }
}

