/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageDomain;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ManageStorageDomains
implements ManageStorageDomainsInterface {
    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
    }

    public List getItemsBySystem() throws ConfigMgmtException {
        Trace.verbose((Object)this, "getItemsBySystem", "OZ Domains");
        ArrayList<StorageDomain> domList = new ArrayList<StorageDomain>();
        Collection obs = ObjectBundleManager.getInstance().getObjectBundles();
        Iterator it = obs.iterator();
        while (it.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)it.next();
            StorageDomain sd = new StorageDomain();
            sd.setName(UnicodeTranslator.getString((byte[])bundle.getSa().getSaData().getStorageArrayLabel().getValue()));
            sd.setAllocatedCapacity(this.getTotalVolumeCapacity(bundle));
            sd.setStorageCapacity(this.getTotalDiskCapacity(bundle));
            ArrayList<String> key = new ArrayList<String>(1);
            String id = UnicodeTranslator.getString((byte[])bundle.getSa().getSaData().getSaId().getWorldWideName());
            key.add(id);
            sd.setKeys(key);
            domList.add(sd);
        }
        return domList;
    }

    private BigInteger getTotalVolumeCapacity(ObjectBundle bundle) {
        Volume[] ozVols = bundle.getVolume();
        int size = ozVols == null ? 0 : ozVols.length;
        long t = 0L;
        for (int i = 0; i < size; ++i) {
            t += ozVols[i].getCapacity();
        }
        return BigInteger.valueOf(t);
    }

    private BigInteger getTotalDiskCapacity(ObjectBundle bundle) {
        Drive[] ozDisks = bundle.getDrive();
        int size = ozDisks == null ? 0 : ozDisks.length;
        long total = 0L;
        for (int i = 0; i < size; ++i) {
            total += ozDisks[i].getRawCapacity();
        }
        return BigInteger.valueOf(total);
    }

    public StorageDomainInterface getItemByName(String name) throws ConfigMgmtException {
        return null;
    }

    public StorageDomainInterface getByKey(Collection props) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus create(String name, String desc) throws ConfigMgmtException, BadParameterException {
        return null;
    }

    public MethodCallStatus delete(String name) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public MethodCallStatus delete(StorageDomainInterface storageDomain) throws ConfigMgmtException {
        return null;
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        return null;
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
    }

    public void validateDescription(String desc) throws BadParameterException {
    }
}

