/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageMappingsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageMappingsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.ManageMappings;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageSnapShotServicesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManagePremiumFeaturesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManagePremiumFeaturesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageArrays;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PremiumFeatures;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.SnapShotVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VDisk;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Volume;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.CandidateSelectionType;
import devmgr.versioned.symbol.CandidateSelectionTypeData;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRefList;
import devmgr.versioned.symbol.FreeExtent;
import devmgr.versioned.symbol.HLVolumeBundle;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PhysicalDriveType;
import devmgr.versioned.symbol.RAIDLevel;
import devmgr.versioned.symbol.RepositoryFullPolicy;
import devmgr.versioned.symbol.RepositoryUtilization;
import devmgr.versioned.symbol.RepositoryUtilizationList;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SnapshotCreationDescriptor;
import devmgr.versioned.symbol.SnapshotParamsUpdateDescriptor;
import devmgr.versioned.symbol.SnapshotRef;
import devmgr.versioned.symbol.SnapshotRefList;
import devmgr.versioned.symbol.SnapshotVolume;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.UserAssignedLabel;
import devmgr.versioned.symbol.VolumeCandidate;
import devmgr.versioned.symbol.VolumeCandidateList;
import devmgr.versioned.symbol.VolumeCandidateRequest;
import devmgr.versioned.symbol.VolumeLabelUpdateDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ManageSnapShotServices
implements ManageSnapShotServicesInterface,
Constants.OZMethodCallStatusReturnCodes {
    private ConfigContext context;
    private SearchFilter filter;
    private Scope scope;
    private static final int AUTOMATIC_MODE = 0;
    private static final int MANUAL_MODE = 1;
    private static final int CREATE_MODE = 2;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "create";
        Trace.methodBegin(this, "create");
        String arrayId = null;
        String volumeRef = null;
        String volumeWwn = null;
        int snapPercent = 100;
        boolean failSnapshotOnFull = true;
        int notifThreshold = 50;
        String snapName = null;
        String repName = null;
        String vdiskRef = null;
        Object poolRef = null;
        DriveRefList driveRefList = null;
        int numDisks = 0;
        int driveType = -1;
        int creationMode = 0;
        int raidLevel = -1;
        if (this.scope == null) {
            throw new ConfigMgmtException("error.scope.required", "Scope not set before invoking create method.");
        }
        arrayId = Convert.scopeToArrayKey(this.scope);
        Trace.verbose((Object)this, "create", arrayId);
        if (props == null || props.isEmpty()) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Properties passed empty.");
        }
        ManageVolumes.validateAdditionalCreationProps(props);
        String baseVolumeKey = props.getProperty("volumeKey");
        if (baseVolumeKey == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Base volume property not populated.");
        }
        volumeRef = Convert.extractRefFromProps(props, "volumeKey", "volumeRef");
        volumeWwn = Convert.extractRefFromProps(props, "volumeKey", "volumeWwn");
        snapPercent = this.extractRepositoryPercentSizeFromProps(props, "snapLevel");
        String string = props.getProperty("failureHandling");
        if (string != null && "failbasewrite".equalsIgnoreCase(string = string.trim())) {
            failSnapshotOnFull = false;
        }
        if ((string = props.getProperty("notifThreshold")) != null) {
            string = string.trim();
            try {
                int newThreshold = Integer.parseInt(string);
                if (newThreshold >= 0 && newThreshold <= 100) {
                    notifThreshold = newThreshold;
                }
            }
            catch (NumberFormatException nfe) {
                throw new ConfigMgmtException("incorrect.method.parameter", "Illegal value " + string + " suppied for threshold");
            }
        }
        if ((snapName = props.getProperty("snapshotName")) == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Snapshot volume name property not populated.");
        }
        snapName = snapName.trim();
        repName = props.getProperty("repositoryName");
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayId);
        if (props.getProperty("raidLevel") != null) {
            creationMode = 2;
            Profile tmpProfile = new Profile();
            String RAID = props.getProperty("raidLevel");
            try {
                raidLevel = Integer.parseInt(RAID);
            }
            catch (NumberFormatException nfe) {
                throw new ConfigMgmtException("INVALID_PROFILE_RAID_LEVEL", "Invalid raid level: " + RAID);
            }
            ProfileDataManager.validateRaidLevel(raidLevel);
            tmpProfile.setRaidLevel(raidLevel);
            String diskType = props.getProperty("driveType");
            if (null == diskType) {
                throw new ConfigMgmtException("incorrect.method.parameter", "If raid level is supplied disk type must also be supplied");
            }
            try {
                driveType = Integer.parseInt(diskType);
            }
            catch (NumberFormatException nfe) {
                throw new ConfigMgmtException("INVALID_PROFILE_DRIVE_TYPE", "Invalid drive type parameter: " + diskType);
            }
            ProfileDataManager.validateDriveType(driveType);
            if (props.getProperty("numberOfDisks") != null) {
                String numberOfDisksString = props.getProperty("numberOfDisks");
                try {
                    numDisks = Integer.parseInt(props.getProperty("numberOfDisks"));
                }
                catch (NumberFormatException nfe) {
                    throw new ConfigMgmtException("INVALID_PROFILE_NUMBER_OF_DRIVES", "Invalid number of disks: " + numberOfDisksString);
                }
                tmpProfile.setNumberOfDisks(numDisks);
                ProfileDataManager.validateConsistency(tmpProfile);
            } else {
                if (props.getProperty("listOfDiskKeys") == null) throw new ConfigMgmtException("incorrect.method.parameter", "If raid level is supplied then either number of disk or disk selection must be supplied");
                String listOfDiskKeys = props.getProperty("listOfDiskKeys");
                String[] diskKeysAsStrings = Convert.commaStringToArray(listOfDiskKeys);
                driveRefList = ManageVolumes.createDriveRefList(diskKeysAsStrings, numDisks, ProfileDataManager.convertProfileDriveTypeTo6130DriveType(driveType), bundle.getDrive());
                tmpProfile.setNumberOfDisks(driveRefList.getDriveRef().length);
                ProfileDataManager.validateConsistency(tmpProfile);
            }
        } else if (props.getProperty("vdiskKey") != null) {
            creationMode = 1;
            String vdiskKeyAsString = props.getProperty("vdiskKey");
            ManageVDisks vdiskManager = new ManageVDisks();
            SearchFilter vdiskKeyFilter = new SearchFilter("keyAsString", vdiskKeyAsString);
            vdiskManager.init(this.context, this.scope, vdiskKeyFilter);
            List vdisks = vdiskManager.getItemList();
            if (vdisks.size() != 1) {
                Trace.verbose((Object)this, "create", "Unable to find vdisk with key " + vdiskKeyAsString);
                throw new SEItemNotFoundException(vdiskKeyAsString);
            }
            VDisk vdisk = (VDisk)vdisks.get(0);
            numDisks = vdisk.getNumberOfDisks();
            driveType = vdisk.getTypeOfDisks();
            raidLevel = vdisk.getRaidLevel();
            if (vdisk.getNumberOfVolumes() >= bundle.getSa().getFeatureParameters().getMaxVolumesPerGroup()) {
                throw new ConfigMgmtException("error.vdisk.exceeded.volume.max", "Maximum number of snapshots already created on vdisk " + vdisk.getName());
            }
            if (vdisk.getVDiskDiskStatus() != 1) {
                throw new ConfigMgmtException("error.vdisk.disk.status.not.optimal", new String[]{vdisk.getName()}, "One or more disks on a vdisk " + vdisk.getName() + " do not have an optimal status.", null);
            }
            vdiskRef = Convert.extractRefFromProps(props, "vdiskKey", "vdiskRef");
        } else {
            devmgr.versioned.symbol.Volume ozVolume = this.getVolumeByWwn(bundle.getVolume(), volumeWwn);
            Drive[] ozDrives = bundle.getDrive();
            Drive ozDrive = null;
            String ozVdiskRef = Convert.bytesToStringRaw(ozVolume.getVolumeGroupRef().getRefToken());
            int drivesLength = ozDrives != null ? ozDrives.length : 0;
            for (int i = 0; i < drivesLength; ++i) {
                ozDrive = ozDrives[i];
                if (!ozVdiskRef.equals(Convert.bytesToStringRaw(ozDrive.getCurrentVolumeGroupRef().getRefToken()))) continue;
                ++numDisks;
                if (driveType != -1) continue;
                driveType = ozDrive.getPhyDriveType().getValue();
            }
            if (numDisks == 0 || driveType == -1) {
                String message = "Can not create snapshot with no disks.";
                Trace.verbose((Object)this, "create", message);
                throw new ConfigMgmtException("volume.create.error.no.disks", message);
            }
            raidLevel = ozVolume.getRaidLevel().getValue();
        }
        int maxPartitionCount = bundle.getSa().getFeatureParameters().getMaxPartitionCount();
        String repositoryName = this.createSnap(arrayId, creationMode, driveRefList, numDisks, driveType, volumeRef, vdiskRef, snapName, raidLevel, snapPercent, notifThreshold, failSnapshotOnFull, repName, bundle, maxPartitionCount);
        if (null == repositoryName && creationMode == 0) {
            creationMode = 2;
            repositoryName = this.createSnap(arrayId, creationMode, driveRefList, numDisks, driveType, volumeRef, vdiskRef, snapName, raidLevel, snapPercent, notifThreshold, failSnapshotOnFull, repName, bundle, maxPartitionCount);
        }
        if (null == repositoryName) {
            String message;
            if (creationMode == 1) {
                message = "No free extent (or one with enough capacity) exists on vdisk supplied";
                Trace.error((Object)this, "create", message);
                throw new ConfigMgmtException("snapshot.manual.create.error", message);
            }
            message = "No free extent - of same RAID level as volume - large enough to create snapshot on";
            Trace.error((Object)this, "create", message);
            throw new ConfigMgmtException("snapshot.automatic.create.error", message);
        }
        SnapshotVolume snapshot = null;
        int retryCounter = 20;
        while (retryCounter > 0) {
            bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayId);
            snapshot = this.getSnapshotByName(bundle.getHighLevelVolBundle().getSnapshotVol(), snapName);
            --retryCounter;
            if (snapshot != null) break;
            Trace.verbose((Object)this, "create", "Snapshot is still not visible, wait a little and retry");
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            Trace.verbose((Object)this, "create", "Retry count:" + retryCounter);
        }
        if (snapshot == null) {
            Trace.error((Object)this, "create", "Newly created snapshot cannot be retrieved....");
            throw new ConfigMgmtException("snapshot.lookup.error", "Unable to lookup snapshot with name = " + snapName);
        }
        if (maxPartitionCount != 0) return;
        Map key = ManageSnapShotServices.getVolumeKeyMap(arrayId, Convert.bytesToStringRaw(snapshot.getSnapshotRef().getRefToken()), snapshot.getLabel() != null && snapshot.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])snapshot.getLabel().getValue()) : "", Convert.bytesToString(snapshot.getWorldWideName()), null, null, null);
        ArrayList<Map> mappingsToDelete = new ArrayList<Map>();
        mappingsToDelete.add(key);
        Trace.verbose((Object)this, "create", "Deleting the default mapping.");
        ManageMappings mappingManager = new ManageMappings();
        mappingManager.init(this.context, this.scope, null);
        mappingManager.delete(mappingsToDelete);
    }

    private devmgr.versioned.symbol.Volume getVolumeByWwn(devmgr.versioned.symbol.Volume[] volumes, String volumeWwnString) throws ConfigMgmtException {
        devmgr.versioned.symbol.Volume volume = null;
        if (volumeWwnString != null) {
            int size = volumes == null ? 0 : volumes.length;
            for (int i = 0; i < size; ++i) {
                if (!volumeWwnString.equals(Convert.bytesToString(volumes[i].getWorldWideName()))) continue;
                volume = volumes[i];
                break;
            }
        }
        if (volume == null) {
            String message = "Unable to lookup the volume with wwn = " + volumeWwnString;
            Trace.verbose((Object)this, "getVolumeByWwn", message);
            throw new ConfigMgmtException("volume.lookup.error", message);
        }
        return volume;
    }

    private SnapshotVolume getSnapshotByName(SnapshotVolume[] snapshots, String snapshotName) {
        SnapshotVolume snapshot = null;
        String currentSnapshotName = null;
        if (snapshotName != null) {
            int size = snapshots == null ? 0 : snapshots.length;
            for (int i = 0; i < size; ++i) {
                if (snapshots[i].getLabel() == null || snapshots[i].getLabel().getValue() == null || !snapshotName.equals(currentSnapshotName = UnicodeTranslator.getString((byte[])snapshots[i].getLabel().getValue()))) continue;
                snapshot = snapshots[i];
                break;
            }
        }
        return snapshot;
    }

    private String createSnap(String arrayWwn, int creationMode, DriveRefList driveRefs, int numberDisks, int driveType, String volumeRef, String vdiskRef, String snapName, int volumeRaidLevel, int snapPercent, int notifThreshold, boolean failSnapshotOnFull, String repNameResult, ObjectBundle bundle, int maxPartitionCount) throws ConfigMgmtException {
        String METHOD_NAME = "createSnap";
        Trace.methodBegin(this, "createSnap");
        SnapshotCreationDescriptor descriptor = null;
        StorageArray sa = null;
        int selectionType = ManageVolumes.pickSelectionType(creationMode, driveRefs, numberDisks);
        CandidateSelectionTypeData selection = new CandidateSelectionTypeData();
        selection.setCandidateSelectionType(new CandidateSelectionType(selectionType));
        if (selectionType == 2) {
            selection.setDriveRefList(driveRefs);
        }
        sa = bundle.getSa();
        ObjectBundleManager.getInstance().stopMonitoringThread(arrayWwn);
        try {
            CommandProcessor command = new CommandProcessor(arrayWwn);
            FreeExtent[] freeExtents = bundle.getFreeExtent();
            devmgr.versioned.symbol.Volume[] ozVols = bundle.getVolume();
            if (ozVols == null || ozVols.length == 0) {
                throw new ConfigMgmtException("VOLUME_SNAPSHOT_ERROR", "There are no existing volumes.");
            }
            long volumeSize = -1L;
            int length = ozVols.length;
            String volVolumeRef = null;
            devmgr.versioned.symbol.Volume ozVol = null;
            for (int i = 0; i < length; ++i) {
                ozVol = ozVols[i];
                volVolumeRef = Convert.bytesToStringRaw(ozVol.getVolumeRef().getRefToken());
                if (volVolumeRef == null || !volVolumeRef.equals(volumeRef)) continue;
                volumeSize = ozVol.getCapacity();
                volumeSize = volumeSize * (long)snapPercent / 100L;
                Trace.verbose((Object)this, "createSnap", "Snapshot size in bytes: " + volumeSize);
                break;
            }
            if (volumeSize < 0L) {
                throw new ConfigMgmtException("VOLUME_SNAPSHOT_ERROR", "Base volume ref property is invalid.");
            }
            VolumeCandidate[] candidates = this.getVolumeCandidates(selection, volumeRaidLevel, command);
            VolumeCandidate candidate = this.pickVolumeCandidate(creationMode, candidates, volumeSize, volumeRaidLevel, vdiskRef, numberDisks, driveType, freeExtents);
            if (null == candidate) {
                Trace.verbose((Object)this, "createSnap", "No Volume candiates for creationMode " + creationMode);
                String string = null;
                return string;
            }
            descriptor = new SnapshotCreationDescriptor();
            descriptor.setBaseVolume((AbstractVolRef)ozVol.getVolumeRef());
            Trace.verbose((Object)this, "createSnap", "Base volume:" + ozVol.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])ozVol.getLabel().getValue()) : "");
            descriptor.setCandidate(candidate);
            Trace.verbose((Object)this, "createSnap", "Candidate volume usable size:" + candidate.getUsableSize());
            if (failSnapshotOnFull) {
                descriptor.setRepFullPolicy(new RepositoryFullPolicy(2));
            } else {
                descriptor.setRepFullPolicy(new RepositoryFullPolicy(1));
            }
            Trace.verbose((Object)this, "createSnap", "Full policy:" + descriptor.getRepFullPolicy().getValue());
            descriptor.setRepositoryCapacity(volumeSize);
            Trace.verbose((Object)this, "createSnap", "Capacity:" + volumeSize);
            descriptor.setWarnThreshold(notifThreshold);
            Trace.verbose((Object)this, "createSnap", "Warning Trashold:" + notifThreshold);
            UserAssignedLabel label = new UserAssignedLabel();
            label.setValue(UnicodeTranslator.getBytes((String)snapName));
            descriptor.setSnapshotLabel(label);
            label = new UserAssignedLabel();
            if (null == repNameResult && snapName.indexOf("-") != -1) {
                String snum = snapName.substring(snapName.lastIndexOf("-") + 1);
                snum = snum.trim();
                try {
                    int num = Integer.parseInt(snum);
                    repNameResult = snapName.substring(0, snapName.lastIndexOf("-") + 1) + "R" + num;
                }
                catch (NumberFormatException nfe) {
                    Trace.warn((Object)this, "Error generating reserve name, will use default", (Throwable)nfe);
                }
            }
            if (null == repNameResult) {
                repNameResult = snapName + "-R";
            }
            label.setValue(UnicodeTranslator.getBytes((String)new String(repNameResult)));
            descriptor.setRepositoryLabel(label);
            Trace.verbose((Object)this, "createSnap", "Label:" + UnicodeTranslator.getString((byte[])descriptor.getRepositoryLabel().getValue()));
            if (maxPartitionCount > 0) {
                descriptor.setNoMapping(true);
            } else {
                descriptor.setNoMapping(false);
            }
            ReturnCode ret = new ReturnCode();
            command.execute(96, (XDRType)descriptor, (XDRType)ret, true);
            if (ret.getValue() != 1) {
                String message = "Snapshot creation failed with the error code: " + ret.getValue();
                Trace.verbose((Object)this, "createSnap", message);
                LogAPI.staticLog((String)"SNAPSHOT_CREATE_ERROR", (String[])new String[]{snapName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + ret.getValue()), message);
            }
            Trace.verbose((Object)this, "createSnap", "Snapshot successfully created.");
            try {
                LogAPI.staticLog((String)"SNAPSHOT_CREATE", (String[])new String[]{snapName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        catch (IOException ioe) {
            Trace.error((Object)this, "createSnap", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        catch (RPCError ioe) {
            Trace.error((Object)this, "createSnap", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayWwn);
        }
        return repNameResult;
    }

    private int extractRepositoryPercentSizeFromProps(Properties props, String propertyName) throws ConfigMgmtException {
        String propertyValue = props.getProperty(propertyName);
        if (propertyValue == null) {
            return 20;
        }
        if ("low".equalsIgnoreCase(propertyValue = propertyValue.trim())) {
            return 10;
        }
        if ("verylittle".equalsIgnoreCase(propertyValue)) {
            return 25;
        }
        if ("little".equalsIgnoreCase(propertyValue)) {
            return 40;
        }
        if ("average".equalsIgnoreCase(propertyValue)) {
            return 50;
        }
        if ("high".equalsIgnoreCase(propertyValue)) {
            return 75;
        }
        if ("full".equalsIgnoreCase(propertyValue)) {
            return 100;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException nfe) {
            return 20;
        }
    }

    private VolumeCandidate[] getVolumeCandidates(CandidateSelectionTypeData selection, int volumeRaidLevel, CommandProcessor command) throws ConfigMgmtException {
        VolumeCandidateList candidateList = new VolumeCandidateList();
        VolumeCandidate[] candidates = null;
        VolumeCandidateRequest request = new VolumeCandidateRequest();
        request.setCandidateSelectionType(selection);
        request.setRaidLevel(new RAIDLevel(volumeRaidLevel));
        request.setPhyDriveType(new PhysicalDriveType(0));
        command.execute(6, (XDRType)request, (XDRType)candidateList, false);
        candidates = candidateList.getVolumeCandidate();
        if (null == candidates) {
            candidates = new VolumeCandidate[]{};
        }
        return candidates;
    }

    private VolumeCandidate pickVolumeCandidate(int creationMode, VolumeCandidate[] candidates, long volumeSize, int raidLevel, String vdiskRef, int numberOfDrives, int driveType, FreeExtent[] freeExtents) throws ConfigMgmtException {
        switch (creationMode) {
            case 0: 
            case 2: {
                int i;
                for (i = 0; i < candidates.length; ++i) {
                    if (!this.candidateMatch(candidates[i], volumeSize, driveType, raidLevel, numberOfDrives)) continue;
                    return candidates[i];
                }
                for (i = 0; i < candidates.length; ++i) {
                    if (!this.candidateMatch(candidates[i], volumeSize, driveType, raidLevel, 0)) continue;
                    return candidates[i];
                }
                if (2 != creationMode) break;
                for (i = 0; i < candidates.length; ++i) {
                    if (!this.candidateMatch(candidates[i], volumeSize, driveType, -1, 0)) continue;
                    return candidates[i];
                }
                for (i = 0; i < candidates.length; ++i) {
                    if (!this.candidateMatch(candidates[i], volumeSize, 0, -1, 0)) continue;
                    return candidates[i];
                }
                break;
            }
            case 1: {
                List possibleExtents = this.filterFreeExtentsByVDisk(freeExtents, vdiskRef);
                String freeExtentRef = null;
                for (int i = 0; i < candidates.length; ++i) {
                    freeExtentRef = Convert.bytesToStringRaw(candidates[i].getFreeExtentRef().getRefToken());
                    long usableSize = candidates[i].getUsableSize();
                    if (!possibleExtents.contains(freeExtentRef) || volumeSize > candidates[i].getUsableSize()) continue;
                    return candidates[i];
                }
                break;
            }
        }
        return null;
    }

    private boolean candidateMatch(VolumeCandidate candidate, long volumeSize, int driveType, int raidLevel, int numberDisks) {
        int selectionDriveCount = candidate.getDriveCount();
        long selectionVolumeSize = candidate.getUsableSize();
        int selectionRaidLevel = candidate.getRaidLevel().getValue();
        int selectionDriveType = candidate.getPhyDriveType().getValue();
        if (driveType == 1) {
            driveType = 3;
        }
        if (volumeSize > selectionVolumeSize) {
            return false;
        }
        if (0 != driveType && driveType != selectionDriveType) {
            return false;
        }
        if (-1 != raidLevel && raidLevel != selectionRaidLevel) {
            return false;
        }
        return 0 == numberDisks || numberDisks == selectionDriveCount;
    }

    private List filterFreeExtentsByVDisk(FreeExtent[] freeExtents, String vdiskRef) throws ConfigMgmtException {
        if (freeExtents == null || freeExtents.length == 0 || vdiskRef == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "No free extents available.");
        }
        String freeExtentRef = null;
        String volumeGroupRef = null;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < freeExtents.length; ++i) {
            volumeGroupRef = Convert.bytesToStringRaw(freeExtents[i].getVolumeGroupRef().getRefToken());
            if (!vdiskRef.equals(volumeGroupRef)) continue;
            freeExtentRef = Convert.bytesToStringRaw(freeExtents[i].getFreeExtentRef().getRefToken());
            list.add(freeExtentRef);
        }
        return list;
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String METHOD_NAME = "delete";
        Trace.methodBegin(this, "delete");
        MethodCallStatus mcs = new MethodCallStatus();
        String arrayWwn = null;
        Object errorDesc = null;
        Map key = null;
        String snapName = null;
        SnapshotRef snapRef = null;
        StorageArray sa = null;
        boolean allSnapshotsDeleted = true;
        int listSize = list.size();
        arrayWwn = Convert.scopeToArrayKey(this.scope);
        if (list == null || list.size() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null or empty list passed to SnapShot.delete() method.");
        }
        listSize = null == (list = Convert.listOfStringKeysToMap(list)) ? 0 : list.size();
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        sa = bundle.getSa();
        ObjectBundleManager.getInstance().stopMonitoringThread(arrayWwn);
        try {
            CommandProcessor command = new CommandProcessor(arrayWwn);
            for (int i = 0; i < listSize; ++i) {
                key = (Map)list.get(i);
                snapName = (String)key.get("volumeName");
                SnapshotVolume snapVol = this.getSnapVolumeFromBundle(snapName, bundle);
                if (snapVol != null) {
                    String snapshotScopeKey = "volumeWwn==" + Convert.bytesToString(snapVol.getWorldWideName());
                    MethodCallStatus mapDeleteResult = this.deleteAnyMappings(snapshotScopeKey);
                    if (mapDeleteResult != null && mapDeleteResult.getReturnCode() != 0) {
                        mcs.addErrorDescriptorList(mapDeleteResult.getErrorDescList());
                        allSnapshotsDeleted = false;
                        continue;
                    }
                    snapRef = snapVol.getSnapshotRef();
                    ReturnCode ret = new ReturnCode();
                    command.execute(9, (XDRType)snapRef, (XDRType)ret, true);
                    if (ret.getValue() != 1) {
                        Trace.verbose((Object)this, "delete", "Delete failed with error:" + ret.getValue() + " for volume :" + snapName);
                        LogAPI.staticLog((String)"SNAPSHOT_DELETE_ERROR", (String[])new String[]{snapName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                        this.setErrorDescriptor(mcs, snapName, "delete", OZErrorCode.ERROR_CODE_MIN + ret.getValue(), "error.snapshot.delete");
                        allSnapshotsDeleted = false;
                        continue;
                    }
                    Trace.verbose((Object)this, "delete", "delete successfull for snapshot:" + key.get("volumeName"));
                    LogAPI.staticLog((String)"SNAPSHOT_DELETE", (String[])new String[]{snapName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    this.setErrorDescriptor(mcs, (String)key.get("volumeName"), "delete", ErrorDescriptor.ERROR_SUCCESS, "success");
                    continue;
                }
                Trace.verbose((Object)this, "delete", "Snapshot volume not found : " + key.get("volumeName"));
                this.setErrorDescriptor(mcs, snapName, "delete", ErrorDescriptor.ERROR_ITEM_NOT_FOUND, "error.snapshot.delete");
                allSnapshotsDeleted = false;
            }
        }
        catch (IOException ioe) {
            Trace.error((Object)this, "delete", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        catch (RPCError ioe) {
            Trace.error((Object)this, "delete", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayWwn);
        }
        if (allSnapshotsDeleted) {
            mcs.setReturnCode(0);
        } else {
            mcs.setReturnCode(2);
        }
        return mcs;
    }

    private MethodCallStatus deleteAnyMappings(String currentSnapshotKey) throws ConfigMgmtException {
        String methodName = "deleteAnyMappings";
        Scope mapScope = new Scope(this.scope);
        mapScope.setAttribute("volume", currentSnapshotKey);
        mapScope.removeAttribute("host");
        mapScope.removeAttribute("hostGroup");
        ManageMappingsInterface mngMappings = ManageMappingsFactory.getManager(this.context, mapScope, null);
        MethodCallStatus result = null;
        List list = new ArrayList();
        list = mngMappings.getItemList();
        if (list.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(currentSnapshotKey);
            result = mngMappings.delete(keys);
        }
        mapScope.removeAttribute("volume");
        return result;
    }

    public MethodCallStatus disableSnapShot(List list) throws ConfigMgmtException {
        String METHOD_NAME = "disableSnapShot";
        Trace.methodBegin(this, "disableSnapShot");
        if (list == null || list.size() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null or empty list passed to disableSnapShot() method.");
        }
        MethodCallStatus mcs = new MethodCallStatus();
        mcs.setReturnCode(0);
        String volumeName = null;
        Map key = null;
        StorageArray sa = null;
        int listSize = list.size();
        List convertedList = Convert.listOfStringKeysToMap(list);
        String arrayRef = (String)((Map)convertedList.get(0)).get("array");
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayRef);
        sa = bundle.getSa();
        ObjectBundleManager.getInstance().stopMonitoringThread(arrayRef);
        try {
            CommandProcessor command = new CommandProcessor(arrayRef);
            for (int i = 0; i < listSize; ++i) {
                key = (Map)convertedList.get(i);
                volumeName = (String)key.get("volumeName");
                SnapshotVolume snapVolume = this.getSnapVolumeFromBundle(volumeName, bundle);
                if (null != snapVolume) {
                    if (snapVolume.getStatus().getValue() + 100 == 103) {
                        this.setErrorDescriptor(mcs, volumeName, "disableSnapShot", OZErrorCode.ERROR_CODE_MIN + ErrorCode.ERROR_SNAPSHOT_ALREADY_DISABLED.getErrorCode(), ErrorCode.ERROR_SNAPSHOT_ALREADY_DISABLED.getKey());
                        if (mcs.getReturnCode() != 0) continue;
                        mcs.setReturnCode(2);
                        continue;
                    }
                    ReturnCode ret = new ReturnCode();
                    command.execute(97, (XDRType)snapVolume.getSnapshotRef(), (XDRType)ret, true);
                    if (ret.getValue() != 1) {
                        Trace.verbose((Object)this, "disableSnapShot", "disable snap failed with error:" + ret.getValue() + " for volume :" + volumeName);
                        LogAPI.staticLog((String)"SNAPSHOT_DISABLE_ERROR", (String[])new String[]{volumeName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                        this.setErrorDescriptor(mcs, volumeName, "disableSnapShot", OZErrorCode.ERROR_CODE_MIN + ret.getValue(), "error.snapshot.disable");
                        if (mcs.getReturnCode() != 0) continue;
                        mcs.setReturnCode(2);
                        continue;
                    }
                    Trace.verbose((Object)this, "disableSnapShot", "disable snap successfull for snapshot:" + volumeName);
                    LogAPI.staticLog((String)"SNAPSHOT_DISABLE", (String[])new String[]{volumeName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    this.setErrorDescriptor(mcs, volumeName, "disableSnapShot", ErrorDescriptor.ERROR_SUCCESS, "success");
                    continue;
                }
                Trace.verbose((Object)this, "disableSnapShot", "Snapshot volume not found : " + volumeName);
                this.setErrorDescriptor(mcs, volumeName, "disableSnapShot", ErrorDescriptor.ERROR_ITEM_NOT_FOUND, "error.snapshot.disable");
                if (mcs.getReturnCode() != 0) continue;
                mcs.setReturnCode(2);
            }
        }
        catch (IOException ioe) {
            Trace.error((Object)this, "disableSnapShot", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        catch (RPCError ioe) {
            Trace.error((Object)this, "disableSnapShot", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayRef);
        }
        return mcs;
    }

    public MethodCallStatus resetSnapShot(List list) throws ConfigMgmtException {
        String METHOD_NAME = "resetSnapShot";
        Trace.methodBegin(this, "resetSnapShot");
        if (list == null || list.size() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null or empty list passed to resetSnapShot() method.");
        }
        MethodCallStatus mcs = new MethodCallStatus();
        String volumeName = null;
        Map key = null;
        int listSize = list.size();
        StorageArray sa = null;
        SnapshotParamsUpdateDescriptor descriptor = null;
        String arrayWwn = Convert.scopeToArrayKey(this.scope);
        if (!this.snapshotLicenseValid(arrayWwn)) {
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_LICENSE_DISABLED), 300);
        }
        List convertedList = Convert.listOfStringKeysToMap(list);
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        sa = bundle.getSa();
        ObjectBundleManager.getInstance().stopMonitoringThread(arrayWwn);
        try {
            CommandProcessor command = new CommandProcessor(arrayWwn);
            for (int i = 0; i < listSize; ++i) {
                key = (Map)convertedList.get(i);
                volumeName = (String)key.get("volumeName");
                SnapshotVolume snapVolume = this.getSnapVolumeFromBundle(volumeName, bundle);
                if (null != snapVolume) {
                    descriptor = new SnapshotParamsUpdateDescriptor();
                    descriptor.setSnapRef(snapVolume.getSnapshotRef());
                    descriptor.setWarnThreshold(snapVolume.getFullWarnThreshold());
                    descriptor.setRepFullPolicy(snapVolume.getRepFullPolicy());
                    ReturnCode ret = new ReturnCode();
                    command.execute(97, (XDRType)snapVolume.getSnapshotRef(), (XDRType)ret, true);
                    if (ret.getValue() != 1) {
                        Trace.verbose((Object)this, "resetSnapShot", "recreate snap (disable portion) failed with error:" + ret.getValue() + " for volume :" + volumeName);
                        LogAPI.staticLog((String)"SNAPSHOT_RESET_ERROR", (String[])new String[]{volumeName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                        this.setErrorDescriptor(mcs, volumeName, "resetSnapShot", OZErrorCode.ERROR_CODE_MIN + ret.getValue(), "error.snapshot.recreate");
                        continue;
                    }
                    command.execute(98, (XDRType)descriptor, (XDRType)ret, true);
                    if (ret.getValue() != 1) {
                        Trace.verbose((Object)this, "resetSnapShot", "recreate snap failed with error:" + ret.getValue() + " for volume :" + volumeName);
                        LogAPI.staticLog((String)"SNAPSHOT_RESET_ERROR", (String[])new String[]{volumeName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                        this.setErrorDescriptor(mcs, volumeName, "resetSnapShot", OZErrorCode.ERROR_CODE_MIN + ret.getValue(), "error.snapshot.recreate");
                        continue;
                    }
                    Trace.verbose((Object)this, "resetSnapShot", "recreate snap successful for snapshot:" + volumeName);
                    LogAPI.staticLog((String)"SNAPSHOT_RESET", (String[])new String[]{volumeName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    this.setErrorDescriptor(mcs, volumeName, "resetSnapShot", ErrorDescriptor.ERROR_SUCCESS, "success");
                    continue;
                }
                Trace.verbose((Object)this, "resetSnapShot", "Snapshot volume not found : " + volumeName);
                this.setErrorDescriptor(mcs, volumeName, "resetSnapShot", ErrorDescriptor.ERROR_ITEM_NOT_FOUND, "error.snapshot.delete");
            }
        }
        catch (IOException ioe) {
            Trace.error((Object)this, "resetSnapShot", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        catch (RPCError ioe) {
            Trace.error((Object)this, "resetSnapShot", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayWwn);
        }
        return mcs;
    }

    private boolean snapshotLicenseValid(String arrayWWN) throws ConfigMgmtException {
        ManagePremiumFeaturesInterface manager = ManagePremiumFeaturesFactory.getManager(this.context, this.scope, null);
        List pfList = manager.getItemList();
        boolean isEnabled = false;
        int sz = pfList == null ? 0 : pfList.size();
        for (int i = 0; i < sz; ++i) {
            PremiumFeatures pf = (PremiumFeatures)pfList.get(i);
            if (pf.getCapability() != 12) continue;
            isEnabled = pf.isEnabled();
            break;
        }
        return isEnabled;
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD_NAME = "getItemList";
        Trace.methodBegin(this, "getItemList");
        ArrayList snapshotList = new ArrayList();
        this.createItemList(snapshotList, true);
        Trace.verbose((Object)this, "getItemList", "List generated");
        return snapshotList;
    }

    private void createItemList(ArrayList snapshotList, boolean populateUsage) throws ConfigMgmtException {
        Collection bundles = this.getBundles();
        String referenceWWN = this.getReferenceWwnFromScope();
        String snapshotWWN = this.getSnapshotWwnFromFilter();
        String snapshotName = this.getSnapshotNameFromFilter();
        boolean foundRef = false;
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            devmgr.versioned.symbol.Volume[] ozVols = bundle.getVolume();
            if (ozVols == null || ozVols.length == 0) continue;
            String arrayName = this.getArrayNameFromBundle(bundle);
            String arrayWwn = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            HLVolumeBundle volumeBundle = bundle.getHighLevelVolBundle();
            SnapshotVolume[] snapshotVolumes = volumeBundle.getSnapshotVol();
            if (snapshotVolumes == null || snapshotVolumes.length == 0) continue;
            Set volumesWithMappingsRefs = this.populateVolumesWithMappingsRef(bundle);
            Map usageMap = null;
            if (populateUsage) {
                usageMap = this.getBytesUsedForSnapshot(snapshotVolumes);
            }
            HashMap volMap = this.fillVolMap(ozVols);
            this.fillTheList(snapshotList, referenceWWN, snapshotWWN, snapshotName, arrayName, arrayWwn, snapshotVolumes, volumesWithMappingsRefs, usageMap, volMap, bundle);
        }
    }

    private Set populateVolumesWithMappingsRef(ObjectBundle bundle) {
        Set volumesWithMappingsRefs = new HashSet();
        volumesWithMappingsRefs = ManageVolumes.getVolumesWithMappingsRefs(bundle.getStoragePoolBundle().getLunMapping());
        return volumesWithMappingsRefs;
    }

    private String getArrayNameFromBundle(ObjectBundle bundle) {
        String arrayName = "";
        byte[] arrayLabelBytes = bundle.getSa().getSaData().getStorageArrayLabel().getValue();
        if (arrayLabelBytes != null) {
            arrayName = UnicodeTranslator.getString((byte[])arrayLabelBytes);
        }
        return arrayName;
    }

    private HashMap fillVolMap(devmgr.versioned.symbol.Volume[] ozVols) {
        HashMap<String, devmgr.versioned.symbol.Volume> volMap = new HashMap<String, devmgr.versioned.symbol.Volume>();
        for (int j = 0; j < ozVols.length; ++j) {
            volMap.put(Convert.bytesToStringRaw(ozVols[j].getVolumeRef().getRefToken()), ozVols[j]);
        }
        return volMap;
    }

    private void fillTheList(ArrayList snapshotList, String referenceWWN, String snapshotWWN, String snapshotName, String arrayName, String arrayWwn, SnapshotVolume[] snapshotVolumes, Set volumesWithMappingsRefs, Map usageMap, HashMap volMap, ObjectBundle bundle) {
        String METHOD_NAME = "fillTheList";
        for (int i = 0; i < snapshotVolumes.length; ++i) {
            boolean foundRef = false;
            Trace.verbose((Object)this, "fillTheList", "Start loop pass");
            SnapshotVolume snapVol = snapshotVolumes[i];
            String snapRef = Convert.bytesToStringRaw(snapVol.getSnapshotRef().getRefToken());
            String snapWwn = Convert.bytesToString(snapVol.getWorldWideName());
            Trace.verbose((Object)this, "fillTheList", "Do the filter");
            if (this.filter != null && !"name".equals(this.filter.getSearchField()) && !"keyAsString".equals(this.filter.getSearchField()) && (!"wwn".equals(this.filter.getSearchField()) || !this.filter.passesFilter(snapWwn)) && (!"snapshotsWithoutMappings".equals(this.filter.getSearchField()) || !this.filter.passesFilter("snapshotsWithoutMappings") || volumesWithMappingsRefs.contains(snapRef))) continue;
            SnapShotVolume newVol = new SnapShotVolume();
            newVol.setName(snapVol.getLabel() != null && snapVol.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])snapVol.getLabel().getValue()) : "");
            newVol.setWwn(snapWwn);
            newVol.setArrayName(arrayName);
            newVol.setStatus(100 + snapVol.getStatus().getValue());
            newVol.setVdiskName(null);
            newVol.setObjectItemType("snapshot");
            if (volumesWithMappingsRefs.contains(snapRef)) {
                newVol.setState(1);
            } else {
                newVol.setState(0);
            }
            String baseRef = Convert.bytesToStringRaw(snapVol.getBaseVolume().getRefToken());
            devmgr.versioned.symbol.Volume ozVol = (devmgr.versioned.symbol.Volume)volMap.get(baseRef);
            String sName = "";
            String parentWwn = "";
            if (ozVol == null) {
                Trace.verbose((Object)this, "fillTheList", "Missing base volume.");
                continue;
            }
            sName = ozVol.getLabel() != null && ozVol.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])ozVol.getLabel().getValue()) : "";
            parentWwn = Convert.bytesToString(ozVol.getWorldWideName());
            newVol.setParentName(sName);
            Trace.verbose((Object)this, "fillTheList", "parent: " + sName + ":" + parentWwn);
            Trace.verbose((Object)this, "fillTheList", "Get volume key map");
            Map key = ManageVolumes.getVolumeKeyMap(arrayWwn, baseRef, sName, parentWwn);
            Volume volume = new Volume();
            volume.setKey(key);
            newVol.setParentKey(volume.getKeyAsString());
            Trace.verbose((Object)this, "fillTheList", "Get repository");
            String repRef = Convert.bytesToStringRaw(snapVol.getRepositoryVolume().getRefToken());
            ozVol = (devmgr.versioned.symbol.Volume)volMap.get(repRef);
            String repositoryWwn = "";
            if (ozVol == null) {
                Trace.verbose((Object)this, "fillTheList", "Missing repository volume.");
                continue;
            }
            sName = ozVol.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])ozVol.getLabel().getValue()) : "";
            repositoryWwn = Convert.bytesToString(ozVol.getWorldWideName());
            newVol.setRepositoryName(sName);
            Trace.verbose((Object)this, "fillTheList", "repository: " + sName + ":" + repositoryWwn);
            key = ManageVolumes.getVolumeKeyMap(arrayWwn, repRef, sName, repositoryWwn);
            volume = new Volume();
            volume.setKey(key);
            newVol.setRepositoryKey(volume.getKeyAsString());
            Trace.verbose((Object)this, "fillTheList", "Check scope");
            if (null != referenceWWN && referenceWWN.equals(parentWwn)) {
                foundRef = true;
            } else if (null != referenceWWN && referenceWWN.equals(repositoryWwn)) {
                foundRef = true;
            } else if (null != snapshotWWN && snapshotWWN.equals(newVol.getWwn())) {
                foundRef = true;
            } else if (this.filter != null && "name".equals(this.filter.getSearchField()) && this.filter.passesFilter(newVol.getName())) {
                foundRef = true;
            }
            if (null != referenceWWN && !foundRef || null != snapshotWWN && !foundRef || this.filter != null && "name".equals(this.filter.getSearchField()) && !foundRef) continue;
            Trace.verbose((Object)this, "fillTheList", "Set treshold");
            newVol.setWarningThreshold(snapVol.getFullWarnThreshold());
            int policy = snapVol.getRepFullPolicy().getValue();
            if (policy == 1) {
                newVol.setFailurePolicy("failbasewrite");
            } else if (policy == 2) {
                newVol.setFailurePolicy("failsnapshot");
            }
            newVol.setCreationDate(new Date(snapVol.getSnapshotTime() * 1000L));
            Trace.verbose((Object)this, "fillTheList", "Set usage");
            long repCapacity = -1L;
            if (ozVol != null) {
                repCapacity = ozVol.getCapacity();
            }
            newVol.setSize(BigInteger.valueOf(repCapacity));
            if (repCapacity == 0L) {
                newVol.setPercentFull(100);
            } else if (usageMap != null) {
                Long usage = (Long)usageMap.get(snapRef);
                newVol.setPercentFull((int)(100L * usage / repCapacity));
                if (newVol.getPercentFull() > 100) {
                    newVol.setPercentFull(100);
                }
            }
            key = ManageSnapShotServices.getVolumeKeyMap(arrayWwn, snapRef, newVol.getName(), newVol.getWwn(), parentWwn, repositoryWwn, Convert.bytesToString(snapVol.getCurrentManager().getRefToken()));
            newVol.setKey(key);
            snapshotList.add(newVol);
            Trace.verbose((Object)this, "fillTheList", "snaphot added");
            if (this.filter != null && "keyAsString".equals(this.filter.getSearchField())) break;
        }
    }

    private Collection getBundles() throws ConfigMgmtException {
        Trace.methodBegin(this, "getBundles");
        ArrayList<ObjectBundle> bundles = null;
        if (this.scope != null) {
            String arrayWwn = Convert.scopeToArrayKey(this.scope);
            bundles = new ArrayList<ObjectBundle>(1);
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
            bundles.add(ob);
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        return bundles;
    }

    private Map getBytesUsedForSnapshot(SnapshotVolume[] snapVols) throws ConfigMgmtException {
        int i;
        String METHOD_NAME = "getBytesUsedForSnapshot";
        Trace.methodBegin(this, "getBytesUsedForSnapshot");
        String arrayId = null;
        if (this.scope == null) {
            throw new ConfigMgmtException("error.scope.required", "Scope not set before getting snapshot volumes.");
        }
        arrayId = Convert.scopeToArrayKey(this.scope);
        Trace.verbose((Object)this, "getBytesUsedForSnapshot", arrayId);
        ControllerRef cr1 = null;
        ControllerRef cr2 = null;
        String cr1s = null;
        String cr2s = null;
        ArrayList<SnapshotRef> snaps1 = new ArrayList<SnapshotRef>();
        ArrayList<SnapshotRef> snaps2 = new ArrayList<SnapshotRef>();
        for (int i2 = 0; i2 < snapVols.length; ++i2) {
            if (i2 == 0) {
                cr1 = snapVols[i2].getCurrentManager();
                cr1s = Convert.bytesToString(cr1.getRefToken());
                snaps1.add(snapVols[i2].getSnapshotRef());
                continue;
            }
            if (cr1s.equals(Convert.bytesToString(snapVols[i2].getCurrentManager().getRefToken()))) {
                snaps1.add(snapVols[i2].getSnapshotRef());
                continue;
            }
            if (cr2 == null) {
                cr2 = snapVols[i2].getCurrentManager();
                cr2s = Convert.bytesToString(cr2.getRefToken());
            }
            snaps2.add(snapVols[i2].getSnapshotRef());
        }
        SnapshotRef[] snapRefs = null;
        HashMap usageMap = new HashMap();
        if (snaps1.size() > 0) {
            snapRefs = new SnapshotRef[snaps1.size()];
            for (i = 0; i < snaps1.size(); ++i) {
                snapRefs[i] = (SnapshotRef)snaps1.get(i);
            }
            this.getRepositoryUsage(arrayId, usageMap, cr1s, snapRefs);
        }
        if (snaps2.size() > 0) {
            snapRefs = new SnapshotRef[snaps2.size()];
            for (i = 0; i < snaps2.size(); ++i) {
                snapRefs[i] = (SnapshotRef)snaps2.get(i);
            }
            this.getRepositoryUsage(arrayId, usageMap, cr2s, snapRefs);
        }
        return usageMap;
    }

    private void getRepositoryUsage(String arrayId, Map resultMap, String controller, SnapshotRef[] snapRefs) throws ConfigMgmtException {
        String METHOD_NAME = "getRepositoryUsage";
        Trace.methodBegin(this, "getRepositoryUsage");
        SnapshotRefList snapList = new SnapshotRefList();
        snapList.setSnapshotRef(snapRefs);
        RepositoryUtilizationList lists = new RepositoryUtilizationList();
        RepositoryUtilization[] utilizations = null;
        try {
            CommandProcessor command = new CommandProcessor(arrayId);
            command.setPreferredController(controller);
            command.setAllowFailover(true);
            ReturnCode ret = new ReturnCode();
            command.execute(100, (XDRType)snapList, (XDRType)lists, false);
            utilizations = lists.getUtilization();
        }
        catch (IOException ioe) {
            Trace.error((Object)this, "getRepositoryUsage", (Throwable)ioe);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        catch (RPCError ioe) {
            Trace.error((Object)this, "getRepositoryUsage", (Throwable)ioe);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        if (snapRefs.length != utilizations.length) {
            throw new ConfigMgmtException("VOLUME_SNAPSHOT_ERROR", "Incorrect utilizations were returned for repository volumes.");
        }
        for (int i = 0; i < utilizations.length; ++i) {
            Trace.verbose((Object)this, "getRepositoryUsage", "i: " + utilizations[i].getRepositoryUsage());
            resultMap.put(Convert.bytesToStringRaw(snapRefs[i].getRefToken()), new Long(utilizations[i].getRepositoryUsage()));
        }
    }

    public int getItemCount() throws ConfigMgmtException {
        String METHOD_NAME = "getItemCount";
        Trace.methodBegin(this, "getItemCount");
        ArrayList list = new ArrayList();
        this.createItemList(list, false);
        return list.size();
    }

    public void init(ConfigContext context, Scope scope, SearchFilter filter) {
        this.context = context;
        this.scope = scope;
        this.filter = filter;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        if (key == null || props == null || props.isEmpty() || !(key instanceof String)) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null, empty or incorrect parameters passed to modify() method.");
        }
        String volumeWwn = null;
        String newVolumeName = null;
        String snapVolName = null;
        Map keyAsMap = null;
        StorageArray sa = null;
        keyAsMap = Convert.keyAsStringToMap((String)key);
        String arrayRef = (String)keyAsMap.get("array");
        volumeWwn = (String)keyAsMap.get("volumeWwn");
        snapVolName = (String)keyAsMap.get("volumeName");
        String sFail = props.getProperty("failureHandling");
        String sThresh = props.getProperty("notifThreshold");
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayRef);
        sa = bundle.getSa();
        ObjectBundleManager.getInstance().stopMonitoringThread(arrayRef);
        try {
            CommandProcessor command = new CommandProcessor(arrayRef);
            if (sFail != null || sThresh != null) {
                this.updateSnapshotParameters(sFail, sThresh, snapVolName, bundle, command);
            }
            if ((newVolumeName = props.getProperty("name")) != null) {
                SnapshotVolume snap = this.getSnapVolumeFromBundle(snapVolName, bundle);
                if (null == snap) {
                    Trace.verbose((Object)this, "modify", "Failed to find snapshot volume for name " + snapVolName);
                    throw new SEItemNotFoundException(snapVolName);
                }
                this.renameSnapshot(newVolumeName, snap, command, sa);
            }
        }
        catch (IOException ioe) {
            Trace.error((Object)this, "modify", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        catch (RPCError ioe) {
            Trace.error((Object)this, "modify", (Throwable)ioe);
            LogAPI.staticLog((String)"SNAPSHOT_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), ioe.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayRef);
        }
    }

    public int getMaxObjects() {
        String METHOD_NAME = "getMaxObjects";
        Trace.methodBegin(this, "getMaxObjects");
        int maxCount = 0;
        try {
            Collection bundles = this.getBundles();
            Iterator iter = bundles.iterator();
            while (iter.hasNext()) {
                maxCount += 1024;
            }
        }
        catch (Exception e) {
            return 0;
        }
        return maxCount;
    }

    static Map getVolumeKeyMap(String arrayWwn, String volumeRef, String volumeName, String volumeWwn, String parentWwn, String repositoryWwn, String controllerRef) {
        HashMap<String, String> key = new HashMap<String, String>(6);
        key.put("array", arrayWwn);
        key.put("volumeRef", volumeRef);
        key.put("volumeName", volumeName);
        key.put("volumeWwn", volumeWwn);
        key.put("parentWwn", parentWwn);
        key.put("repositoryWwn", repositoryWwn);
        key.put("controllerRef", controllerRef);
        return key;
    }

    private String getReferenceWwnFromScope() {
        String methodName = "getReferenceWwnFromScope";
        String hgRef = null;
        Object key = this.scope.getAttribute("reference");
        if (key != null) {
            Map map = null;
            map = !(key instanceof Map) ? Convert.keyAsStringToMap((String)key) : (Map)key;
            hgRef = (String)map.get("volumeWwn");
            Trace.verbose((Object)this, "getReferenceWwnFromScope", "Got reference volume (repository/or parent)" + hgRef);
        }
        return hgRef;
    }

    private String getSnapshotWwnFromFilter() {
        String methodName = "getSnapshotWwnFromFilter";
        String wwn = null;
        if (this.filter != null && "keyAsString".equals(this.filter.getSearchField())) {
            Trace.verbose((Object)this, "getSnapshotWwnFromFilter", "SEARCH FILTER FOR SNAP:" + this.filter.getSearchString());
            wwn = this.filter.getSearchString();
            if (wwn != null) {
                Map map = null;
                map = Convert.keyAsStringToMap(wwn);
                wwn = (String)map.get("volumeWwn");
                Trace.verbose((Object)this, "getSnapshotWwnFromFilter", "Got reference volume (repository/or parent)" + wwn);
            }
        }
        return wwn;
    }

    private String getSnapshotNameFromFilter() {
        String methodName = "getSnapshotNameFromFilter";
        String name = null;
        if (this.filter != null && "name".equals(this.filter.getSearchField())) {
            Trace.verbose((Object)this, "getSnapshotNameFromFilter", "SEARCH FILTER FOR NAME:" + this.filter.getSearchString());
            name = this.filter.getSearchString();
        }
        return name;
    }

    private SnapshotVolume getSnapVolumeFromBundle(String snapeName, ObjectBundle bundle) {
        Trace.verbose((Object)this, "getSnapVolumeFromBundle", "Get reference for snapVolume:" + snapeName);
        SnapshotVolume[] snaps = bundle.getHighLevelVolBundle().getSnapshotVol();
        SnapshotVolume snap = null;
        for (int i = 0; i < snaps.length; ++i) {
            String sName;
            byte[] nameBytes = snaps[i].getLabel().getValue();
            if (nameBytes == null || !(sName = UnicodeTranslator.getString((byte[])nameBytes)).equals(snapeName)) continue;
            snap = snaps[i];
            Trace.verbose((Object)this, "getRef", "Found snapshot volume");
            break;
        }
        return snap;
    }

    private void setErrorDescriptor(MethodCallStatus mcs, String name, String operation, int ret, String ikey) {
        ErrorDescriptor ed = new ErrorDescriptor();
        ed.setErrorCode(ret);
        ed.setI18nkey(ikey);
        String[] params = new String[]{name};
        ed.setI18nParams(params);
        if (ret != 1) {
            ed.setMsg("Failed " + operation + " for " + params[0]);
        } else {
            ed.setMsg("Success  " + operation + " for " + params[0]);
        }
        mcs.addErrorDescriptor(ed);
    }

    private void updateSnapshotParameters(String sFail, String sThresh, String volumeName, ObjectBundle bundle, CommandProcessor command) throws ConfigMgmtException {
        String METHOD_NAME = "updateSnapshotParameters";
        boolean failSnapshotOnFull = true;
        int notifThreshold = 50;
        RepositoryFullPolicy fail_handling = null;
        SnapshotParamsUpdateDescriptor descriptor = null;
        SnapshotVolume snapVol = this.getSnapVolumeFromBundle(volumeName, bundle);
        if (sFail == null || sThresh == null) {
            notifThreshold = snapVol.getFullWarnThreshold();
            fail_handling = snapVol.getRepFullPolicy();
        }
        if (sFail != null) {
            if ("failbasewrite".equalsIgnoreCase(sFail)) {
                failSnapshotOnFull = false;
            }
            fail_handling = failSnapshotOnFull ? new RepositoryFullPolicy(2) : new RepositoryFullPolicy(1);
        }
        if (sThresh != null) {
            try {
                int newThreshold = Integer.parseInt(sThresh);
                if (newThreshold >= 0 && newThreshold <= 100) {
                    notifThreshold = newThreshold;
                }
            }
            catch (NumberFormatException nfe) {
                Trace.warn((Object)this, "Error getting new threshold, old value will be used", (Throwable)nfe);
            }
        }
        descriptor = new SnapshotParamsUpdateDescriptor();
        descriptor.setSnapRef(snapVol.getSnapshotRef());
        descriptor.setWarnThreshold(notifThreshold);
        descriptor.setRepFullPolicy(fail_handling);
        ReturnCode ret = new ReturnCode();
        command.execute(99, (XDRType)descriptor, (XDRType)ret, true);
        if (ret.getValue() != 1) {
            String message = "Snapshot modify parameters failed with the error code: " + ret.getValue();
            Trace.verbose((Object)this, "updateSnapshotParameters", message);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + ret.getValue()), message);
        }
        Trace.verbose((Object)this, "updateSnapshotParameters", "Snapshot successfully modified.");
    }

    private void renameSnapshot(String snapVolName, SnapshotVolume vol, CommandProcessor command, StorageArray sa) throws ConfigMgmtException {
        String METHOD_NAME = "updateSnapshotName";
        VolumeLabelUpdateDescriptor vlud = new VolumeLabelUpdateDescriptor();
        UserAssignedLabel ual = new UserAssignedLabel();
        ual.setValue(UnicodeTranslator.getBytes((String)snapVolName));
        vlud.setVolumeRef((AbstractVolRef)vol.getSnapshotRef());
        vlud.setLabel(ual);
        ReturnCode ret = new ReturnCode();
        command.execute(31, (XDRType)vlud, (XDRType)ret, true);
        if (ret.getValue() != 1) {
            String message = "Snapshot modify name failed with the error code: " + ret.getValue();
            Trace.verbose((Object)this, "updateSnapshotName", message);
            LogAPI.staticLog((String)"SNAPSHOT_MODIFY_ERROR", (String[])new String[]{snapVolName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + ret.getValue()), message);
        }
        Trace.verbose((Object)this, "updateSnapshotName", "Snapshot successfully modified name.");
        LogAPI.staticLog((String)"SNAPSHOT_MODIFY", (String[])new String[]{snapVolName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
    }

    public boolean snapshotNameUsed(String snapshotName) throws ConfigMgmtException {
        Object snapName = null;
        String arrayId = null;
        SnapshotVolume snapshot = null;
        if (this.scope == null) {
            throw new ConfigMgmtException("error.scope.required", "Scope not set before invoking create method.");
        }
        arrayId = Convert.scopeToArrayKey(this.scope);
        Trace.verbose((Object)this, "snapshotNameUsed", arrayId);
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayId);
        CommandProcessor cmd = null;
        try {
            cmd = new CommandProcessor(arrayId);
        }
        catch (Exception e) {
            throw new ConfigMgmtException("error.communicating", "Error communicating with array");
        }
        cmd.execute(40, null, (XDRType)bundle, false);
        return bundle != null && bundle.getHighLevelVolBundle().getSnapshotVol() != null && (snapshot = this.getSnapshotByName(bundle.getHighLevelVolBundle().getSnapshotVol(), snapshotName)) != null;
    }

    public static interface ModifySnapshotProps {
        public static final String NAME = "name";
        public static final String FAILURE_HANDLING = "failureHandling";
        public static final String NOTIF_THRESHOLD = "notifThreshold";
    }

    public static interface CreateSnapshotProps {
        public static final String VOLUME_KEY = "volumeKey";
        public static final String SNAPSHOT_NAME = "snapshotName";
        public static final String REPOSITORY_NAME = "repositoryName";
        public static final String RAID_LEVEL = "raidLevel";
        public static final String DISK_TYPE = "driveType";
        public static final String VDISK_KEY = "vdiskKey";
        public static final String SNAP_LEVEL = "snapLevel";
        public static final String FAILURE_HANDLING = "failureHandling";
        public static final String NOTIF_THRESHOLD = "notifThreshold";
        public static final String NUMBER_OF_DISKS = "numberOfDisks";
        public static final String LIST_OF_DISK_KEYS = "listOfDiskKeys";
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String WWN = "wwn";
        public static final String SNAPSHOTS_WITHOUT_MAPPINGS = "snapshotsWithoutMappings";
    }

    public static interface KeyMap {
        public static final String ARRAY = "array";
        public static final String VOLUME_REF = "volumeRef";
        public static final String VOLUME_NAME = "volumeName";
        public static final String VOLUME_WWN = "volumeWwn";
        public static final String PARENT_WWN = "parentWwn";
        public static final String REPOSITORY_WWN = "repositoryWwn";
        public static final String OWNING_CONTROLLER = "controllerRef";
    }
}

