/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManagePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Pool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolCreationSingleton;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VDisk;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Volume;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.VolumeAttributeUpdateDescriptor;
import devmgr.versioned.symbol.VolumeCache;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManagePools
implements ManagePoolsInterface {
    public static final int[] RAID_LEVELS = new int[]{0, 1, 3, 5};
    public static final String DEFAULT_POOL_ID = "1";
    private Scope scope = null;
    private SearchFilter filter = null;
    private ConfigContext context = null;
    private Map profileMap = null;

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.scope = scope;
        this.filter = filter;
    }

    public List getItemList() throws ConfigMgmtException {
        return this.internalGetItemList(false);
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.internalGetItemList(false).size();
    }

    /*
     * Enabled aggressive block sorting
     */
    private List internalGetItemList(boolean doFullPopulate) throws ConfigMgmtException {
        ArrayList<Pool> forReturn;
        block14: {
            Iterator iter;
            String searchField;
            block13: {
                String METHOD = "internalGetItemList";
                String arrayKey = null;
                String profileId = null;
                if (this.scope == null) {
                    Trace.error((Object)this, "internalGetItemList", "no pool scope");
                    throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope must contain array data only for a pool.");
                }
                arrayKey = Convert.scopeToArrayKey(this.scope);
                if (arrayKey == null) {
                    Trace.error((Object)this, "internalGetItemList", "scope exists, but no array value in it.");
                    throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope must contain array data only for a pool.");
                }
                String profileKeyAsString = (String)this.scope.getAttribute("profile");
                if (profileKeyAsString != null) {
                    Map profileKey = Convert.keyAsStringToMap(profileKeyAsString);
                    profileId = (String)profileKey.get("id");
                    Trace.verbose((Object)this, "internalGetItemList", "profileId for scope: " + profileId);
                }
                this.profileMap = this.mapProfiles(arrayKey);
                PoolDataManager pdm = new PoolDataManager(arrayKey);
                forReturn = new ArrayList<Pool>();
                ProfileDataManager profdm = new ProfileDataManager(arrayKey);
                if (this.filter != null && !this.filter.isEmpty() && "keyAsString".equals(this.filter.getSearchField())) {
                    doFullPopulate = true;
                    Trace.verbose((Object)this, "internalGetItemList", "requesting pool by key: " + this.filter.getSearchString());
                    PoolData pd = null;
                    Map requestedPoolKey = Convert.keyAsStringToMap(this.filter.getSearchString());
                    String poolId = (String)requestedPoolKey.get("id");
                    pd = pdm.getPoolData(poolId);
                    if (pd == null) {
                        throw new SEItemNotFoundException(poolId);
                    }
                    forReturn.add(this.getPoolFromPoolData(arrayKey, profdm.getProfile(pd.profileId), pd));
                } else {
                    Collection possibles = pdm.getRawPools();
                    Trace.verbose((Object)this, "internalGetItemList", "performing standard scope and filter");
                    forReturn = new ArrayList();
                    Object volumesWWNMap = null;
                    ArrayList<Pool> correctlyScoped = new ArrayList<Pool>();
                    Iterator it = possibles.iterator();
                    while (it.hasNext()) {
                        PoolData pd = (PoolData)it.next();
                        if (profileId != null && !pd.profileId.equals(profileId)) continue;
                        correctlyScoped.add(this.getPoolFromPoolData(arrayKey, profdm.getProfile(pd.profileId), pd));
                    }
                    if (this.filter != null) {
                        Trace.verbose((Object)this, "internalGetItemList", "Applying SearchFilter");
                        searchField = this.filter.getSearchField();
                        if (searchField != null && (searchField.equals("name") || searchField.equals("profileName"))) {
                            iter = correctlyScoped.iterator();
                            break block13;
                        } else {
                            Trace.verbose((Object)this, "internalGetItemList", "Search field not supported: " + searchField);
                            throw new ConfigMgmtException("error.search.field.not.supported", "error.search.field.not.supported: " + searchField);
                        }
                    }
                    Trace.verbose((Object)this, "internalGetItemList", "no filter, return all propertly scoped.");
                    forReturn = correctlyScoped;
                }
                break block14;
            }
            while (iter.hasNext()) {
                Pool p = (Pool)iter.next();
                if (!this.filter.passesFilter(searchField.equals("name") ? p.getName() : p.getProfileName())) continue;
                if (forReturn == null) {
                    forReturn = new ArrayList();
                }
                forReturn.add(p);
            }
        }
        if (forReturn != null) {
            if (!forReturn.isEmpty()) return forReturn;
        }
        if (forReturn != null) return forReturn;
        return new ArrayList();
    }

    private Map mapProfiles(String arrayId) throws ConfigMgmtException {
        HashMap<String, Profile> pm = new HashMap<String, Profile>();
        ProfileDataManager pdm = new ProfileDataManager(arrayId);
        Collection rawProfiles = pdm.getRawProfiles();
        Iterator it = rawProfiles.iterator();
        while (it.hasNext()) {
            Profile p = (Profile)it.next();
            pm.put(p.getName(), p);
        }
        return pm;
    }

    private Pool getPoolFromPoolData(String arrayId, Profile profile, PoolData pd) throws ConfigMgmtException {
        Pool pool = new Pool();
        pool.setName(pd.poolName);
        pool.setProfileId(pd.profileId);
        pool.setDescription(pd.poolDesc);
        pool.setObjectItemType("pool");
        pool.setProfileName(profile.getName());
        Map m = ManagePools.getPoolKey(pd.poolId, arrayId);
        pool.setKey(m);
        pool.setArrayId(this.getArrayWwnFromScope());
        pool.setContext(this.context);
        pool.setProfile(profile);
        pool.setPoolId(pd.poolId);
        return pool;
    }

    public static Map getPoolKey(String poolId, String arrayId) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("id", poolId);
        m.put("array", arrayId);
        return m;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException, BadParameterException {
        String METHOD = "modify";
        Trace.methodBegin(this, "modify");
        String arrayKeyFromScope = this.getArrayWwnFromScope();
        if (props == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a non-null Properties object for modify.");
        }
        PoolDataManager pdm = new PoolDataManager(arrayKeyFromScope);
        String poolId = null;
        PoolData modifyPool = null;
        if (key instanceof Map) {
            Trace.verbose((Object)this, "modify", "Looking for pool from key.");
            poolId = (String)((Map)key).get("id");
        } else if (key instanceof String) {
            Trace.verbose((Object)this, "modify", "Looking for pool from string key.");
            Map km = Convert.keyAsStringToMap((String)key);
            poolId = (String)km.get("id");
        }
        modifyPool = pdm.getPoolData(poolId);
        if (modifyPool == null) {
            Trace.verbose((Object)this, "modify", "Unable to find pool to modify, failing.");
            LogAPI.staticLog((String)"POOL_MODIFY_ERROR", (String[])new String[]{modifyPool.poolName}, (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a valid pool for action: modify");
        }
        Profile newProfile = null;
        String oldProfileId = null;
        boolean madeMod = false;
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            Trace.verbose((Object)this, "modify", "Processing request: " + propName);
            if (propName.equals("name")) {
                String newName = props.getProperty(propName);
                if (newName.equals(modifyPool.poolName)) continue;
                try {
                    pdm.validateName(newName);
                }
                catch (BadParameterException bpe) {
                    LogAPI.staticLog((String)"POOL_MODIFY_ERROR", (String[])new String[]{modifyPool.poolName}, (String[])new String[0]);
                    throw bpe;
                }
                modifyPool.poolName = newName;
                madeMod = true;
                continue;
            }
            if (propName.equals("description")) {
                String newDesc = props.getProperty(propName);
                if (newDesc.equals(modifyPool.poolDesc)) continue;
                pdm.validateDescription(newDesc);
                modifyPool.poolDesc = newDesc;
                madeMod = true;
                continue;
            }
            if (propName.equals("profileName")) {
                String newProfName = props.getProperty(propName);
                this.profileMap = this.mapProfiles(arrayKeyFromScope);
                newProfile = (Profile)this.profileMap.get(newProfName);
                String profId = null;
                if (newProfile != null) {
                    profId = (String)newProfile.getKey().get("id");
                }
                if (profId != null) {
                    if (!profId.equals(modifyPool.profileId)) {
                        oldProfileId = modifyPool.profileId;
                        modifyPool.profileId = profId;
                        madeMod = true;
                        continue;
                    }
                    newProfile = null;
                    continue;
                }
                LogAPI.staticLog((String)"POOL_MODIFY_ERROR", (String[])new String[]{modifyPool.poolName}, (String[])new String[0]);
                throw new ConfigMgmtException("incorrect.method.parameter", "Unable to find requested profile to change to: " + newProfName);
            }
            LogAPI.staticLog((String)"POOL_MODIFY_ERROR", (String[])new String[]{modifyPool.poolName}, (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Unknown modify request: " + propName);
        }
        if (madeMod) {
            if (newProfile != null) {
                Trace.verbose((Object)this, "modify", "Modify Pool name:" + modifyPool.poolName);
                List volsInPool = this.getVolsInPool(modifyPool.poolId);
                this.changePoolsProfile(modifyPool, oldProfileId, newProfile, volsInPool);
            }
            try {
                pdm.updatePool(modifyPool);
                LogAPI.staticLog((String)"POOL_MODIFY_SUCCESS", (String[])new String[]{modifyPool.poolName}, (String[])new String[0]);
            }
            catch (RPCError e) {
                LogAPI.staticLog((String)"POOL_MODIFY_ERROR", (String[])new String[]{modifyPool.poolName}, (String[])new String[0]);
                Trace.error((Object)this, "modify", e.getMessage());
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY, e.getMessage());
            }
            catch (IOException e) {
                LogAPI.staticLog((String)"POOL_MODIFY_ERROR", (String[])new String[]{modifyPool.poolName}, (String[])new String[0]);
                Trace.error((Object)this, "modify", e.getMessage());
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_IO_KEY, e.getMessage());
            }
        } else {
            Trace.verbose((Object)this, "modify", "No change requested, returning success with no change.");
        }
    }

    public void create(Properties props) throws ConfigMgmtException {
        String METHOD = "create";
        Trace.methodBegin(this, "create");
        String arrayKey = this.getArrayWwnFromScope();
        PoolData p = new PoolData();
        p.poolName = props.getProperty("name", null);
        p.poolDesc = props.getProperty("description", null);
        p.profileName = props.getProperty("profileName", null);
        this.profileMap = this.mapProfiles(arrayKey);
        if (p.profileName == null) {
            Trace.verbose((Object)this, "create", "Profile name i srequired parameter");
            throw new SEItemNotFoundException("profile:" + p.profileName);
        }
        Profile selectedProfile = (Profile)this.profileMap.get(p.profileName);
        if (selectedProfile == null) {
            Trace.verbose((Object)this, "create", "Cannot find profile:" + p.profileName);
            throw new SEItemNotFoundException(p.profileName);
        }
        p.profileId = (String)selectedProfile.getKey().get("id");
        try {
            PoolCreationSingleton.getInstance().createPool(arrayKey, p);
            LogAPI.staticLog((String)"POOL_CREATE_SUCCESS", (String[])new String[]{p.poolName}, (String[])new String[0]);
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"POOL_CREATE_ERROR", (String[])new String[]{p.poolName}, (String[])new String[0]);
            throw cme;
        }
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        int i;
        String METHOD = "delete";
        Trace.methodBegin(this, "delete");
        String arrayKey = this.getArrayWwnFromScope();
        if (list == null || list.isEmpty()) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a list for delete");
        }
        MethodCallStatus mcs = new MethodCallStatus();
        PoolDataManager pdm = new PoolDataManager(arrayKey);
        Map volumesMap = this.mapVolumes();
        List keys = Convert.listOfStringKeysToMap(list);
        ArrayList ids = new ArrayList();
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            Map key = (Map)keys.get(i2);
            ids.add(key.get("id"));
        }
        Map rawPoolMap = pdm.getRawPoolMap();
        int sz = ids == null ? 0 : ids.size();
        String[] poolsDeleted = new String[sz];
        String[] poolsNotDeleted = new String[sz];
        int poolsDeletedCnt = 0;
        int poolsNotDeletedCnt = 0;
        for (i = 0; i < sz; ++i) {
            String poolId = (String)ids.get(i);
            PoolData pd = (PoolData)rawPoolMap.get(poolId);
            if (pd == null) {
                ErrorDescriptor ed = new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND);
                ed.setI18nParams(new String[]{poolId});
                mcs.addErrorDescriptor(ed);
                Trace.error((Object)this, "delete", "Pool:" + poolId + " not found!");
                continue;
            }
            Trace.verbose((Object)this, "delete", "delete pool with id:" + pd.poolId);
            List volList = (List)volumesMap.get(pd.poolId);
            if (volList != null && !volList.isEmpty()) {
                Trace.verbose((Object)this, "delete", "Attempting deletion of all volumes on pool: " + pd.poolId);
                ManageVolumes vMgr = new ManageVolumes();
                vMgr.init(this.context, this.scope, null);
                MethodCallStatus vmcs = vMgr.delete(volList);
                if (vmcs.getReturnCode() != 0) {
                    Trace.error((Object)this, "delete", "Volume delete failed - canot remove pool");
                    poolsNotDeleted[poolsNotDeletedCnt++] = pd.poolName;
                } else {
                    rawPoolMap.remove(poolId);
                    poolsDeleted[poolsDeletedCnt++] = pd.poolName;
                }
                mcs.addErrorDescriptorList(vmcs.getErrorDescList());
                continue;
            }
            Trace.verbose((Object)this, "delete", "No volumes on pool: " + pd.poolId);
            rawPoolMap.remove(poolId);
            poolsDeleted[poolsDeletedCnt++] = pd.poolName;
        }
        try {
            pdm.saveData(rawPoolMap.values());
            for (i = 0; i < poolsDeletedCnt; ++i) {
                LogAPI.staticLog((String)"POOL_DELETE_SUCCESS", (String[])new String[]{poolsDeleted[i]}, (String[])new String[0]);
            }
            for (i = 0; i < poolsNotDeletedCnt; ++i) {
                LogAPI.staticLog((String)"POOL_DELETE_ERROR", (String[])new String[]{poolsNotDeleted[i]}, (String[])new String[0]);
            }
        }
        catch (RPCError e) {
            int i3;
            for (i3 = 0; i3 < poolsDeletedCnt; ++i3) {
                LogAPI.staticLog((String)"POOL_DELETE_ERROR", (String[])new String[]{poolsDeleted[i3]}, (String[])new String[0]);
            }
            for (i3 = 0; i3 < poolsNotDeletedCnt; ++i3) {
                LogAPI.staticLog((String)"POOL_DELETE_ERROR", (String[])new String[]{poolsNotDeleted[i3]}, (String[])new String[0]);
            }
            Trace.error((Object)this, "delete", e.getMessage());
            mcs.addErrorDescriptor(new ErrorDescriptor(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY));
        }
        catch (IOException e) {
            int i4;
            for (i4 = 0; i4 < poolsDeletedCnt; ++i4) {
                LogAPI.staticLog((String)"POOL_DELETE_ERROR", (String[])new String[]{poolsDeleted[i4]}, (String[])new String[0]);
            }
            for (i4 = 0; i4 < poolsNotDeletedCnt; ++i4) {
                LogAPI.staticLog((String)"POOL_DELETE_ERROR", (String[])new String[]{poolsNotDeleted[i4]}, (String[])new String[0]);
            }
            Trace.error((Object)this, "delete", e.getMessage());
            mcs.addErrorDescriptor(new ErrorDescriptor(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY));
        }
        Trace.verbose((Object)this, "delete", "END");
        return mcs;
    }

    private Map mapVolumes() throws ConfigMgmtException {
        String methodName = "mapVolumes";
        Trace.methodBegin(this, "mapVolumes");
        HashMap<String, ArrayList<String>> volMap = new HashMap<String, ArrayList<String>>();
        ManageVolumes mv = new ManageVolumes();
        mv.init(this.context, new Scope(this.scope), null);
        List volList = mv.getItemList();
        int sz = volList == null ? 0 : volList.size();
        for (int i = 0; i < sz; ++i) {
            Volume v = (Volume)volList.get(i);
            String poolId = (String)Convert.keyAsStringToMap(v.getPoolKeyAsString()).get("id");
            ArrayList<String> volPoolList = (ArrayList<String>)volMap.get(poolId);
            if (volPoolList == null) {
                volPoolList = new ArrayList<String>();
            }
            volPoolList.add(v.getKeyAsString());
            volMap.put(poolId, volPoolList);
        }
        Trace.verbose((Object)this, "mapVolumes", "Map volumes Done!");
        return volMap;
    }

    public int getMaxObjects() {
        return Integer.MAX_VALUE;
    }

    private HashMap getProfilesByName() throws ConfigMgmtException {
        HashMap<String, Profile> profilesByName = new HashMap<String, Profile>();
        String arrayKey = this.getArrayWwnFromScope();
        ProfileDataManager pdm = new ProfileDataManager(arrayKey);
        Iterator iter = pdm.getRawProfiles().iterator();
        while (iter.hasNext()) {
            Profile prof = (Profile)iter.next();
            profilesByName.put(prof.getName(), prof);
        }
        return profilesByName;
    }

    private void changePoolsProfile(PoolData modifyPool, String oldProfileId, Profile newProfile, List volsInPool) throws ConfigMgmtException {
        String METHOD = "changePoolsProfile";
        Trace.methodBegin(this, "changePoolsProfile");
        String arrayKey = this.getArrayWwnFromScope();
        ProfileDataManager profDm = new ProfileDataManager(this.getArrayWwnFromScope());
        Profile currentProfile = profDm.getProfile(oldProfileId);
        if (currentProfile == null) {
            String msg = "failed to obtain current profile from id: " + oldProfileId;
            Trace.verbose((Object)this, "changePoolsProfile", msg);
            throw new ConfigMgmtException("error.systemError", msg);
        }
        List curVDisks = this.validatePoolsProfile(currentProfile, newProfile, null, volsInPool);
        Trace.verbose((Object)this, "changePoolsProfile", "validation successful, attempt modifications.");
        this.changeAllVolumes(modifyPool, currentProfile, newProfile, curVDisks, volsInPool);
    }

    List validatePoolsProfile(Profile currentProfile, Profile newProfile, List curVDisks, List volsInPool) throws ConfigMgmtException {
        boolean mustValidateDriveType;
        boolean segSizeChanged;
        String METHOD = "validatePoolsProfile";
        Trace.methodBegin(this, "validatePoolsProfile");
        if (volsInPool == null || volsInPool.isEmpty()) {
            return new ArrayList();
        }
        this.validateSegmentSizeChange(currentProfile.getSegmentSize(), newProfile.getSegmentSize());
        boolean bl = segSizeChanged = currentProfile.getSegmentSize() != newProfile.getSegmentSize();
        if (segSizeChanged && volsInPool != null && volsInPool.size() > 1) {
            String msg = "Not allowed to request multiple long running operations.";
            throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_MULTIPLE_OPERATIONS.getKey(), msg);
        }
        boolean mustValidateNewRaidLevel = currentProfile.getRaidLevel() != newProfile.getRaidLevel();
        boolean mustValidateNewNumDisks = currentProfile.getNumberOfDisks() != newProfile.getNumberOfDisks() && newProfile.getNumberOfDisks() != 0;
        boolean bl2 = mustValidateDriveType = currentProfile.getDriveType() != newProfile.getDriveType();
        if (volsInPool != null && volsInPool.size() >= 1 && (segSizeChanged && mustValidateNewRaidLevel || segSizeChanged && mustValidateNewNumDisks || mustValidateNewRaidLevel && mustValidateNewNumDisks)) {
            String msg = "Not allowed to request multiple long running operations.";
            Trace.verbose((Object)this, "validatePoolsProfile", msg);
            throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_MULTIPLE_OPERATIONS.getKey(), msg);
        }
        if (mustValidateNewRaidLevel || mustValidateNewNumDisks || mustValidateDriveType) {
            if (curVDisks == null) {
                curVDisks = this.getVDisksUsedByPool(volsInPool);
            }
            if (mustValidateNewRaidLevel && curVDisks.size() > 1) {
                String msg = "Not allowed to convert to RAID " + newProfile.getRaidLevel() + " when there are " + curVDisks + " in the pool (max 1 vdisk to modify RAID level).";
                Trace.verbose((Object)this, "validatePoolsProfile", msg);
                throw new ConfigMgmtException(ErrorCode.ERROR_POOL_RAID_CHANGE_NOT_ALLOWED.getKey(), msg);
            }
            int lSize = curVDisks == null ? 0 : curVDisks.size();
            int totalAffectedVolumesForRaidChange = 0;
            for (int i = 0; i < lSize; ++i) {
                VDisk vd = (VDisk)curVDisks.get(i);
                if (mustValidateDriveType && newProfile.getDriveType() != 0 && newProfile.getDriveType() != ProfileDataManager.convert6130DriveTypeToProfileDriveType(vd.getTypeOfDisks())) {
                    String msg = "profile's drive type: " + newProfile.getDriveType() + " is not valid with current vdisk drive type: " + ProfileDataManager.convert6130DriveTypeToProfileDriveType(vd.getTypeOfDisks());
                    Trace.verbose((Object)this, "validatePoolsProfile", msg);
                    throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_DRIVE_TYPE.getKey(), msg);
                }
                if (mustValidateNewNumDisks && vd.getNumberOfDisks() != newProfile.getNumberOfDisks()) {
                    String msg = "have existing Vdisk with mis-matching num disks: " + vd.getNumberOfDisks();
                    Trace.verbose((Object)this, "validatePoolsProfile", msg);
                    throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_NUM_DISKS.getKey(), msg);
                }
                if (mustValidateNewRaidLevel) {
                    if ((newProfile.getRaidLevel() == 3 || newProfile.getRaidLevel() == 5) && vd.getNumberOfDisks() < 3) {
                        String msg = "Not allowed to convert to RAID " + newProfile.getRaidLevel() + " when there are only " + vd.getNumberOfDisks() + " disks.";
                        Trace.verbose((Object)this, "validatePoolsProfile", msg);
                        throw new ConfigMgmtException(ErrorCode.ERROR_POOL_RAID_CHANGE_NOT_ALLOWED.getKey(), msg);
                    }
                    if (newProfile.getRaidLevel() == 1 && vd.getNumberOfDisks() % 2 != 0) {
                        String msg = "Not allowed to convert to RAID 1 with an odd number of disks.";
                        Trace.verbose((Object)this, "validatePoolsProfile", msg);
                        throw new ConfigMgmtException(ErrorCode.ERROR_POOL_RAID_CHANGE_NOT_ALLOWED.getKey(), msg);
                    }
                }
                totalAffectedVolumesForRaidChange += vd.getNumberOfVolumes();
            }
            if (mustValidateNewRaidLevel && totalAffectedVolumesForRaidChange != volsInPool.size()) {
                String msg = "RAID change would affect num vols: " + totalAffectedVolumesForRaidChange + " but since there are only " + volsInPool.size() + " volumes in the pool, others would be incorrectly modified";
                Trace.verbose((Object)this, "validatePoolsProfile", msg);
                throw new ConfigMgmtException(ErrorCode.ERROR_POOL_RAID_CHANGE_NOT_ALLOWED.getKey(), msg);
            }
        }
        return curVDisks;
    }

    public List getVolsInPool(String poolId) throws ConfigMgmtException {
        String METHOD = "getVolsInPool";
        String arrayWwn = this.getArrayWwnFromScope();
        ArrayList<devmgr.versioned.symbol.Volume> volList = new ArrayList<devmgr.versioned.symbol.Volume>();
        if (arrayWwn == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "No scope set");
        }
        Trace.verbose((Object)this, "getVolsInPool", "Looking for volumes in a pool with Id:" + poolId);
        devmgr.versioned.symbol.Volume[] ozVols = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn).getVolume();
        for (int i = 0; i < ozVols.length; ++i) {
            if (!poolId.equals("" + ozVols[i].getMgmtClientAttribute())) continue;
            Trace.verbose((Object)this, "getVolsInPool", "Volume found:" + UnicodeTranslator.getString((byte[])ozVols[i].getLabel().getValue()));
            volList.add(ozVols[i]);
        }
        Trace.verbose((Object)this, "getVolsInPool", "Number of volumes in a pool:" + volList.size());
        return volList;
    }

    private void changeAllVolumes(PoolData modifyPool, Profile currentProfile, Profile newProfile, List curVDisks, List volsInPool) throws ConfigMgmtException {
        devmgr.versioned.symbol.Volume ozVol;
        int i;
        ManageVolumes mVol;
        int vSize;
        String METHOD = "changeAllVolumes";
        Trace.methodBegin(this, "changeAllVolumes");
        ConfigMgmtException lastFailure = null;
        String arrayWwn = this.getArrayWwnFromScope();
        ArrayList<String> failedVolumes = new ArrayList<String>();
        if (currentProfile.isReadAheadEnabled() != newProfile.isReadAheadEnabled()) {
            vSize = volsInPool == null ? 0 : volsInPool.size();
            mVol = new ManageVolumes();
            mVol.init(this.context, this.scope, null);
            for (i = 0; i < vSize; ++i) {
                ozVol = (devmgr.versioned.symbol.Volume)volsInPool.get(i);
                try {
                    VolumeCache ozVolCache = ozVol.getCache();
                    ozVolCache.setReadAheadMultiplier(newProfile.isReadAheadEnabled() ? 3 : 0);
                    mVol.setVolumeCacheParams(ozVol, ozVolCache, arrayWwn);
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, "changeAllVolumes", cme);
                    lastFailure = cme;
                    failedVolumes.add(Convert.bytesToString(ozVol.getWorldWideName()));
                }
            }
        }
        if (currentProfile.getSegmentSize() != newProfile.getSegmentSize()) {
            vSize = volsInPool == null ? 0 : volsInPool.size();
            mVol = new ManageVolumes();
            mVol.init(this.context, this.scope, null);
            for (i = 0; i < vSize; ++i) {
                ozVol = (devmgr.versioned.symbol.Volume)volsInPool.get(i);
                try {
                    mVol.startVolumeSegmentSizing(ozVol, ProfileDataManager.convertProfileSegSizeToBytes(newProfile.getSegmentSize()), arrayWwn);
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, "changeAllVolumes", cme);
                    lastFailure = cme;
                    failedVolumes.add(Convert.bytesToString(ozVol.getWorldWideName()));
                }
            }
        }
        ArrayList<String> failedVDisks = new ArrayList<String>();
        if (currentProfile.getRaidLevel() != newProfile.getRaidLevel()) {
            int vDiskSize = curVDisks == null ? 0 : curVDisks.size();
            ManageVDisks mVDisks = new ManageVDisks();
            Properties prop = new Properties();
            prop.setProperty("raidLevel", "" + newProfile.getRaidLevel());
            mVDisks.init(this.context, this.scope, null);
            for (int i2 = 0; i2 < vDiskSize; ++i2) {
                VDisk vd = (VDisk)curVDisks.get(i2);
                try {
                    mVDisks.modify(vd.getKey(), prop);
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, "changeAllVolumes", cme);
                    lastFailure = cme;
                    failedVDisks.add(vd.getVDiskReference());
                }
            }
        }
        this.modifyProfileForVolumes(modifyPool.poolId, volsInPool, failedVolumes, failedVDisks);
        if (lastFailure != null) {
            String msg = "Not all the modifications completed successfully.";
            Trace.error((Object)this, "changeAllVolumes", msg + " The last exception is duplicated.");
            Trace.error((Object)this, "changeAllVolumes", lastFailure);
            throw new ConfigMgmtException(ErrorCode.ERROR_POOL_VOLUME_MODIFICATION_NOT_COMPLETE.getKey(), msg);
        }
    }

    private void modifyProfileForVolumes(String poolId, List volsInPool, List failedVolumes, List failedVDisks) throws ConfigMgmtException {
        String methodName = "modifyProfileForVolumes";
        int sz = volsInPool == null ? 0 : volsInPool.size();
        VolumeAttributeUpdateDescriptor vaud = new VolumeAttributeUpdateDescriptor();
        try {
            CommandProcessor command = new CommandProcessor(this.getArrayWwnFromScope());
            ReturnCode rc = new ReturnCode();
            for (int i = 0; i < sz; ++i) {
                devmgr.versioned.symbol.Volume ozVol = (devmgr.versioned.symbol.Volume)volsInPool.get(i);
                String volWwn = Convert.bytesToString(ozVol.getWorldWideName());
                String vdiskRef = Convert.bytesToStringRaw(ozVol.getVolumeGroupRef().getRefToken());
                vaud.setVolumeRef((AbstractVolRef)ozVol.getVolumeRef());
                if (failedVolumes.contains(volWwn) || failedVDisks.contains(vdiskRef)) {
                    Trace.verbose((Object)this, "modifyProfileForVolumes", "Reset volume pool to nothing - volume update failed:" + volWwn);
                    vaud.setMgmtClientAttribute(0);
                } else {
                    try {
                        vaud.setMgmtClientAttribute(Integer.parseInt(poolId));
                    }
                    catch (NumberFormatException e2) {
                        Trace.error((Object)this, "modifyProfileForVolumes", "Pool id is not valid number:" + poolId);
                        continue;
                    }
                }
                try {
                    command.execute(159, (XDRType)vaud, (XDRType)rc, true);
                    continue;
                }
                catch (ConfigMgmtException e1) {
                    Trace.error((Object)this, "modifyProfileForVolumes", e1);
                }
            }
        }
        catch (RPCError e) {
            Trace.error((Object)this, "modifyProfileForVolumes", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY, e.getMessage());
        }
        catch (IOException e) {
            Trace.error((Object)this, "modifyProfileForVolumes", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_IO_KEY, e.getMessage());
        }
    }

    private void validateSegmentSizeChange(int curSegSize, int newSegSize) throws ConfigMgmtException {
        if (Math.abs(curSegSize - newSegSize) > 1 || newSegSize > 7 || newSegSize < 1) {
            throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_SEGMENT_SIZE_CHANGE.getKey(), "Invalid segment size change: " + curSegSize + " to " + newSegSize);
        }
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(this.getArrayWwnFromScope());
        int arrayCacheBlkSize = ProfileDataManager.convertSegSizeBytesToProfileSegSize(bundle.getSa().getCache().getCacheBlkSize());
        this.validateSegmentSize(arrayCacheBlkSize, newSegSize);
    }

    private void validateSegmentSize(int arrayCacheBlkSize, int profileSegmentSize) throws ConfigMgmtException {
        if (arrayCacheBlkSize > profileSegmentSize) {
            throw new ConfigMgmtException(ErrorCode.ERROR_VOLUME_INVALID_SEGMENT_SIZE.getKey(), "Segment size can not be smaller than array cache block size.");
        }
    }

    public Volume validateVolumeForProfile(Profile profile, String volKeyAsString) throws ConfigMgmtException {
        String METHOD = "validateVolumeForPool";
        Trace.methodBegin(this, "validateVolumeForPool");
        ManageVolumes mVol = new ManageVolumes();
        SearchFilter filter = new SearchFilter("keyAsString", volKeyAsString);
        mVol.init(this.context, this.scope, filter);
        List vols = mVol.getItemList();
        Volume vol = null;
        if (vols == null || vols.isEmpty()) {
            String msg = "Unable to find volume: " + volKeyAsString;
            Trace.verbose((Object)this, "validateVolumeForPool", msg);
            throw new SEItemNotFoundException(volKeyAsString);
        }
        vol = (Volume)vols.get(0);
        this.validateVolumeForProfile(profile, vol);
        return vol;
    }

    public void validateVolumeForProfile(Profile profile, Volume vol) throws ConfigMgmtException {
        String METHOD = "validateVolumeForProfile";
        Trace.methodBegin(this, "validateVolumeForProfile");
        int driveType = 0;
        int numDisksUsed = 0;
        if (profile.getDriveType() != 0 || profile.getNumberOfDisks() != 0) {
            VDiskDriveInfo vddi = this.getVDiskDriveInfoForVolumeWwn(vol.getWwn());
            driveType = vddi.getDriveType();
            numDisksUsed = vddi.getNumberOfDisks();
        }
        this.validateVolumePropsForProfile(profile, vol.isReadCache(), vol.getSegmentSize(), vol.getRaidLevel(), driveType, numDisksUsed);
    }

    private void validateVolumePropsForProfile(Profile profile, boolean isReadCache, int segmentSize, int raidLevel, int volDriveType, int numberDisksUsed) throws ConfigMgmtException {
        if (profile.isReadAheadEnabled() != isReadCache) {
            throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_READ_AHEAD.getKey(), "Profile and volume have different read ahead settings.");
        }
        if (profile.getSegmentSize() != ProfileDataManager.convertSegSizeBytesToProfileSegSize(segmentSize)) {
            throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_SEGMENT_SIZE_CHANGE.getKey(), "Profile and volume have different segment size settings.");
        }
        if (profile.getRaidLevel() != raidLevel) {
            throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_RAID_LEVEL.getKey(), "Profile and volume have different raid level settings.");
        }
        if (volDriveType != 0 && profile.getDriveType() != 0 && profile.getDriveType() != ProfileDataManager.convert6130DriveTypeToProfileDriveType(volDriveType)) {
            throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_DRIVE_TYPE.getKey(), "Profile drive type not compatible with existing drive type.");
        }
        if (numberDisksUsed != 0 && profile.getNumberOfDisks() != 0 && profile.getNumberOfDisks() != numberDisksUsed) {
            throw new ConfigMgmtException(ErrorCode.ERROR_POOL_INVALID_NUM_DISKS.getKey(), "Profile number of disks not compatible with existing number of disks.");
        }
    }

    List getVDisksUsedByPool(List volsInPool) throws ConfigMgmtException {
        String METHOD = "getVDisksUsedByPool";
        Trace.methodBegin(this, "getVDisksUsedByPool");
        ArrayList<String> vdiskRefList = new ArrayList<String>();
        int sz = volsInPool.size();
        for (int i = 0; i < sz; ++i) {
            devmgr.versioned.symbol.Volume v = (devmgr.versioned.symbol.Volume)volsInPool.get(i);
            String vdiskRef = Convert.bytesToStringRaw(v.getVolumeGroupRef().getRefToken());
            vdiskRefList.add(vdiskRef);
        }
        ArrayList<VDisk> forReturn = new ArrayList<VDisk>();
        if (!vdiskRefList.isEmpty()) {
            ManageVDisks vDiskMgr = new ManageVDisks();
            Scope s1 = new Scope(this.scope);
            vDiskMgr.init(this.context, s1, null);
            List allVDisks = vDiskMgr.getItemList();
            Iterator vDIter = allVDisks.iterator();
            while (vDIter.hasNext()) {
                VDisk vd = (VDisk)vDIter.next();
                if (!vdiskRefList.contains(vd.getVDiskReference())) continue;
                forReturn.add(vd);
            }
        }
        return forReturn;
    }

    private String getArrayWwnFromScope() throws ConfigMgmtException {
        if (this.scope != null) {
            return Convert.scopeToArrayKey(this.scope);
        }
        throw new ConfigMgmtException("error.scope.required", "Array scope not set before using of the pool manager.");
    }

    VDiskDriveInfo getVDiskDriveInfoForVolumeWwn(String wwn) throws ConfigMgmtException {
        String arrayWwn = this.getArrayWwnFromScope();
        ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        devmgr.versioned.symbol.Volume[] ozVols = ob.getVolume();
        String vDiskRef = null;
        int ozVolSize = ozVols == null ? 0 : ozVols.length;
        for (int i = 1; i < ozVolSize && vDiskRef == null; ++i) {
            String volWwn = Convert.bytesToString(ozVols[i].getWorldWideName());
            if (!volWwn.equals(wwn)) continue;
            vDiskRef = Convert.bytesToStringRaw(ozVols[i].getVolumeGroupRef().getRefToken());
        }
        VDiskDriveInfo vddi = new VDiskDriveInfo();
        if (vDiskRef != null) {
            Integer driveType;
            HashMap numbers = new HashMap();
            HashMap types = new HashMap();
            HashMap statuses = new HashMap();
            HashMap vdiskTrayMap = new HashMap();
            Drive[] ozDrives = ob.getDrive();
            ManageVDisks.populateDiskRelatedProperties(numbers, types, statuses, vdiskTrayMap, ozDrives);
            int ozDriveSize = ozDrives == null ? 0 : ozDrives.length;
            Integer numberOfDisks = (Integer)numbers.get(vDiskRef);
            if (numberOfDisks != null) {
                vddi.setNumberOfDisks(numberOfDisks);
            }
            if ((driveType = (Integer)types.get(vDiskRef)) != null) {
                vddi.setDriveType(driveType);
            }
        }
        return vddi;
    }

    public List getPoolsCompatibleWithVolume(Volume volume) throws ConfigMgmtException {
        String METHOD_NAME = "getPoolsCompatibleWithVolume";
        Trace.methodBegin(this, "getPoolsCompatibleWithVolume");
        if (volume == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a volume for: getPoolsCompatibleWithVolume");
        }
        String arrayWwn = this.getArrayWwnFromScope();
        int volumeRaidLevel = volume.getRaidLevel();
        int volumeSegmentSize = volume.getSegmentSize();
        String volWwn = volume.getWwn();
        Profile volumeProfile = this.poolForVolumeFillProfile(volumeRaidLevel, volumeSegmentSize, volWwn);
        Map poolKey = Convert.keyAsStringToMap(volume.getPoolKeyAsString());
        String poolId = (String)poolKey.get("id");
        List volsOnTheVdisk = null;
        ArrayList vdisksUsedByVol = new ArrayList();
        devmgr.versioned.symbol.Volume ozVol = ManageVolumes.getVolumeForWwn(ObjectBundleManager.getInstance().getObjectBundle(arrayWwn).getVolume(), volume.getWwn());
        volsOnTheVdisk = this.getVolsOnVidskAndVdisksForVolume(volsOnTheVdisk, vdisksUsedByVol, ozVol);
        Trace.verbose((Object)this, "getPoolsCompatibleWithVolume", "Number of volumes on the vdisk:" + volsOnTheVdisk.size());
        List poolsCompatibleWithVolume = this.getFinalPoolListForVolume(arrayWwn, volumeProfile, volsOnTheVdisk, vdisksUsedByVol);
        Trace.verbose((Object)this, "getPoolsCompatibleWithVolume", "Number of items in the list = " + poolsCompatibleWithVolume.size());
        return poolsCompatibleWithVolume;
    }

    Profile poolForVolumeFillProfile(int volumeRaidLevel, int volumeSegmentSize, String wwn) throws ConfigMgmtException {
        VDiskDriveInfo vddi = this.getVDiskDriveInfoForVolumeWwn(wwn);
        Profile volumeProfile = new Profile();
        volumeProfile.setRaidLevel(volumeRaidLevel);
        volumeProfile.setSegmentSize(ProfileDataManager.convertSegSizeBytesToProfileSegSize(volumeSegmentSize));
        volumeProfile.setDriveType(ProfileDataManager.convert6130DriveTypeToProfileDriveType(vddi.getDriveType()));
        volumeProfile.setNumberOfDisks(vddi.getNumberOfDisks());
        return volumeProfile;
    }

    List getFinalPoolListForVolume(String arrayWwn, Profile volumeProfile, List volsOnTheVdisk, List vdisksUsedByVol) throws ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "getFinalPoolListForVolume";
        Pool pool = null;
        Profile profile = null;
        List allPools = this.internalGetItemList(false);
        ArrayList<Pool> poolsCompatibleWithVolume = new ArrayList<Pool>();
        Iterator iter = allPools.iterator();
        while (iter.hasNext()) {
            pool = (Pool)iter.next();
            ProfileDataManager profdm = new ProfileDataManager(arrayWwn);
            profile = profdm.getProfile(pool.getProfileId());
            if (volsOnTheVdisk != null && volsOnTheVdisk.size() > 1 && volumeProfile.getRaidLevel() != profile.getRaidLevel()) {
                Trace.verbose((Object)this, "getFinalPoolListForVolume", profile.getName());
                Trace.verbose((Object)this, "getFinalPoolListForVolume", "This profile is not compatible for change on a single volume, since RAID level does not match");
                continue;
            }
            try {
                Trace.verbose((Object)this, "getFinalPoolListForVolume", "Validate pool:" + pool.getName());
                this.validatePoolsProfile(volumeProfile, profile, vdisksUsedByVol, volsOnTheVdisk);
                poolsCompatibleWithVolume.add(pool);
            }
            catch (ConfigMgmtException cme) {
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "getFinalPoolListForVolume", "Pool " + pool.getName() + " not eligible because " + cme.getExceptionKey() + " message = " + cme.getExceptionMsg());
            }
        }
        return poolsCompatibleWithVolume;
    }

    List getVolsOnVidskAndVdisksForVolume(List volsOnTheVdisk, List vdisksUsedByVol, devmgr.versioned.symbol.Volume ozVol) throws ConfigMgmtException {
        ArrayList<String> vdiskRefList = new ArrayList<String>();
        String vdiskRef = Convert.bytesToStringRaw(ozVol.getVolumeGroupRef().getRefToken());
        vdiskRefList.add(vdiskRef);
        int numOfVolsOnTheVDisk = 1;
        if (!vdiskRefList.isEmpty()) {
            ManageVDisks vDiskMgr = new ManageVDisks();
            Scope s1 = new Scope(this.scope);
            vDiskMgr.init(this.context, s1, null);
            List allVDisks = vDiskMgr.getItemList();
            Iterator vDIter = allVDisks.iterator();
            while (vDIter.hasNext()) {
                VDisk vd = (VDisk)vDIter.next();
                if (!vdiskRefList.contains(vd.getVDiskReference())) continue;
                vdisksUsedByVol.add(vd);
                numOfVolsOnTheVDisk = vd.getNumberOfVolumes();
                Scope vdiskScope = new Scope(this.scope);
                vdiskScope.setAttribute("vdisk", vd.getKeyAsString());
                ManageVolumes mv = new ManageVolumes();
                mv.init(this.context, vdiskScope, null);
                volsOnTheVdisk = mv.getItemList();
                break;
            }
        }
        return volsOnTheVdisk;
    }

    public List getPoolsForVolumeCreation() throws ConfigMgmtException {
        String METHOD_NAME = "getPoolsForVolumeCreation";
        Trace.methodBegin(this, "getPoolsForVolumeCreation");
        Pool pool = null;
        Profile profile = null;
        ProfileDataManager profdm = new ProfileDataManager(this.getArrayWwnFromScope());
        List allPools = this.internalGetItemList(true);
        ArrayList<Pool> bigEnoughPools = new ArrayList<Pool>();
        if (allPools != null && allPools.size() > 0) {
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(this.getArrayWwnFromScope());
            int arrayCacheBlkSize = ProfileDataManager.convertSegSizeBytesToProfileSegSize(bundle.getSa().getCache().getCacheBlkSize());
            Iterator iter = allPools.iterator();
            while (iter.hasNext()) {
                pool = (Pool)iter.next();
                profile = profdm.getProfile(pool.getProfileId());
                try {
                    this.validateSegmentSize(arrayCacheBlkSize, profile.getSegmentSize());
                    if (BigInteger.ZERO.compareTo(pool.getMaximumVolumeSize()) >= 0) continue;
                    bigEnoughPools.add(pool);
                }
                catch (ConfigMgmtException cme) {}
            }
        }
        Trace.verbose((Object)this, "getPoolsForVolumeCreation", "Number of items in the list = " + bigEnoughPools.size());
        return bigEnoughPools;
    }

    class VDiskDriveInfo {
        private int numberOfDisks = 0;
        private int driveType = 0;

        public int getDriveType() {
            return this.driveType;
        }

        public int getNumberOfDisks() {
            return this.numberOfDisks;
        }

        public void setDriveType(int driveType) {
            this.driveType = driveType;
        }

        public void setNumberOfDisks(int numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }
    }

    public static interface SupportedActions {
        public static final String MODIFY_POOL_CHANGE_NAME = "name";
        public static final String MODIFY_POOL_CHANGE_DESCRIPTION = "description";
        public static final String MODIFY_POOL_CHANGE_PROFILE = "profileName";
    }

    public static interface CreateProps {
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String PROFILE_NAME = "profileName";
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String ID = "id";
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String PROFILE_NAME = "profileName";
    }
}

