/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManagePerfMonitorsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.PerfMonitorState;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfMonitor;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfMonitorFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfMonitorInterface;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManagePerfMonitors
implements ManagePerfMonitorsInterface {
    private SearchFilter filter = null;
    private ConfigContext context = null;
    private Scope scope = null;

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        this.scope = scope;
    }

    public List getItemList() throws ConfigMgmtException {
        if (this.scope == null) {
            return PerfMonitorFactory.getInstance().getAll();
        }
        ArrayList<com.sun.netstorage.array.mgmt.cfg.mgmt.business.PerfMonitorInterface> monitorList = new ArrayList<com.sun.netstorage.array.mgmt.cfg.mgmt.business.PerfMonitorInterface>();
        com.sun.netstorage.array.mgmt.cfg.mgmt.business.PerfMonitorInterface monitor = this.getPerfMonitor();
        if (monitor != null) {
            monitorList.add(monitor);
        }
        return monitorList;
    }

    public int getItemCount() throws ConfigMgmtException {
        if (this.scope == null) {
            List list = this.getItemList();
            return list.size();
        }
        if (this.getPerfMonitor() != null) {
            return 1;
        }
        return 0;
    }

    public int getMaxObjects() {
        return Integer.MAX_VALUE;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String arrayWWN;
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        if (key == null || props == null) {
            LogAPI.staticLog((String)"PERF_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply non-null key and Properties object for modify.");
        }
        Map keyMap = null;
        if (key instanceof Map) {
            keyMap = (Map)key;
        } else if (key instanceof String) {
            keyMap = Convert.keyAsStringToMap((String)key);
        }
        if (keyMap == null) {
            LogAPI.staticLog((String)"PERF_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_ILLEGAL_ARGUMENT.getKey(), "Key must be of type java.util.Map or java.lang.String");
        }
        String arrayID = (String)keyMap.get("array");
        if (arrayID != (arrayWWN = Convert.scopeToArrayKey(this.scope))) {
            LogAPI.staticLog((String)"PERF_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_ILLEGAL_ARGUMENT.getKey(), "Array Key doesn't match scope");
        }
        com.sun.netstorage.array.mgmt.cfg.mgmt.business.PerfMonitorInterface monitor = this.getPerfMonitor();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            Trace.verbose((Object)this, "modify", "Processing request: " + propName);
            String propValue = props.getProperty(propName);
            if (propValue == null) {
                throw new ConfigMgmtException("incorrect.method.parameter", "Must supply non-null property value for modify.");
            }
            long value = 0L;
            try {
                value = Long.parseLong(propValue);
            }
            catch (NumberFormatException nfe) {
                LogAPI.staticLog((String)"PERF_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
                throw new ConfigMgmtException(ErrorCode.ERROR_ILLEGAL_ARGUMENT.getKey(), "Value must be convertable to long via Long.getLong()");
            }
            if (propName.equals("pollingRate")) {
                monitor.setPollingRate(value);
                continue;
            }
            if (!propName.equals("retentionTime")) continue;
            ((PerfMonitorInterface)monitor).setDataRetentionTime(value);
        }
        LogAPI.staticLog((String)"PERF_MODIFY_SUCCESS", (String[])new String[0], (String[])new String[0]);
    }

    public com.sun.netstorage.array.mgmt.cfg.mgmt.business.PerfMonitorInterface getPerfMonitor() throws ConfigMgmtException {
        String arrayWWN = null;
        if (this.scope != null) {
            arrayWWN = Convert.scopeToArrayKey(this.scope);
            if (arrayWWN == null) {
                throw new ConfigMgmtException("error.scope.required", "Array key was not not found in scope");
            }
            PerfMonitorFactory perfFactory = PerfMonitorFactory.getInstance();
            PerfMonitorInterface monitor = perfFactory.get(arrayWWN);
            return monitor;
        }
        throw new ConfigMgmtException("error.scope.required", "No scope has been set.");
    }

    public void create(Properties props) throws ConfigMgmtException {
        if (this.scope == null) {
            LogAPI.staticLog((String)"PERF_CREATE_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException("ACTION_NOT_SUPPORTED", "Create with a scope of null not currently supported.");
        }
        com.sun.netstorage.array.mgmt.cfg.mgmt.business.PerfMonitorInterface monitor = this.getPerfMonitor();
        LogAPI.staticLog((String)"PERF_CREATE_SUCCESS", (String[])new String[0], (String[])new String[0]);
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String METHOD_NAME = "delete";
        Trace.methodBegin(this, "delete");
        if (list == null || list.size() == 0) {
            LogAPI.staticLog((String)"PERF_DELETE_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply non-null list to delete.");
        }
        String arrayWWN = null;
        if (this.scope != null && (arrayWWN = Convert.scopeToArrayKey(this.scope)) != null && list.size() > 1) {
            LogAPI.staticLog((String)"PERF_DELETE_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Too many parameters.  Only a single monitor can be deleted given current scope");
        }
        String arrayID = null;
        MethodCallStatus mcs = new MethodCallStatus();
        mcs.setReturnCode(0);
        for (int i = 0; i < list.size(); ++i) {
            PerfMonitorFactory perfFactory;
            ErrorDescriptor errorDesc;
            ErrorDescriptor errorDesc2;
            Map keyMap = null;
            Object key = list.get(i);
            if (key instanceof Map) {
                keyMap = (Map)key;
                arrayID = (String)keyMap.get("array");
            } else if (key instanceof String) {
                keyMap = Convert.keyAsStringToMap((String)key);
                arrayID = keyMap != null ? (String)keyMap.get("array") : (String)key;
            } else {
                String sKey = null;
                if (key != null) {
                    sKey = key.toString();
                }
                errorDesc2 = new ErrorDescriptor(ErrorCode.ERROR_ILLEGAL_ARGUMENT);
                errorDesc2.setI18nParams(new String[]{sKey});
                mcs.addErrorDescriptor(errorDesc2);
                mcs.setReturnCode(2);
            }
            if (this.scope != null && arrayID == null) {
                errorDesc = new ErrorDescriptor(ErrorCode.ERROR_ILLEGAL_ARGUMENT);
                errorDesc.setI18nParams(new String[]{"null"});
                errorDesc.setMsg("If scope is set KeyMap.ARRAY can not be null");
                mcs.addErrorDescriptor(errorDesc);
                mcs.setReturnCode(2);
            }
            if (this.scope != null && arrayID != arrayWWN) {
                errorDesc = new ErrorDescriptor(ErrorCode.ERROR_ILLEGAL_ARGUMENT);
                errorDesc.setI18nParams(new String[]{arrayID});
                errorDesc.setMsg("Array Key doesn't match scope");
                mcs.addErrorDescriptor(errorDesc);
                mcs.setReturnCode(2);
            }
            if ((perfFactory = PerfMonitorFactory.getInstance()).contains(arrayID)) {
                PerfMonitorInterface monitor = perfFactory.get(arrayID);
                ((PerfMonitor)monitor).setDataRetentionTime(0L);
                if (monitor.getState().equals(PerfMonitorState.ON)) {
                    monitor.stop();
                }
                perfFactory.remove(arrayID);
            }
            if (mcs.getReturnCode() == 2) {
                LogAPI.staticLog((String)"PERF_DELETE_ERROR", (String[])new String[0], (String[])new String[0]);
            } else {
                LogAPI.staticLog((String)"PERF_DELETE_SUCCESS", (String[])new String[0], (String[])new String[0]);
            }
            errorDesc2 = new ErrorDescriptor(ErrorCode.SUCCESS);
            errorDesc2.setI18nParams(new String[]{arrayID});
            mcs.addErrorDescriptor(errorDesc2);
        }
        return mcs;
    }

    public static interface ModifyProps {
        public static final String POLLING_RATE = "pollingRate";
        public static final String DATA_RETENTION_TIME = "retentionTime";
    }

    public static interface KeyMap {
        public static final String ARRAY = "array";
    }
}

