/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayReg;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayRegManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CoreManagedObject;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ControllerInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageControllersInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Controller;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.jrpc.XDRlong;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.EthernetParamsUpdateDescriptor;
import devmgr.versioned.symbol.FibreInterface;
import devmgr.versioned.symbol.IOInterfaceTypeData;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManageControllers
implements ManageControllersInterface {
    private ConfigContext cfgctx;
    private SearchFilter sf;
    private Scope scope;
    String arrayName;
    private final String INTERFACE_TYPE = "gei";
    private final int NET_CHANNEL = 1;

    public void init(ConfigContext ctx, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = ctx;
        this.scope = s;
        this.sf = f;
    }

    private Collection getBundles(Scope scope) throws ConfigMgmtException {
        ArrayList<ObjectBundle> bundles = null;
        if (scope != null) {
            String arrayWWN = Convert.scopeToArrayKey(scope);
            ArrayList<ObjectBundle> bl = new ArrayList<ObjectBundle>(1);
            try {
                ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWWN);
                bl.add(ob);
            }
            catch (SEItemNotFoundException e) {
                Trace.error((Object)this, (ConfigMgmtException)e);
            }
            bundles = bl;
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        return bundles;
    }

    public List getItemList() throws ConfigMgmtException {
        Controller c;
        Trace.methodBegin(this, "getItemList");
        ArrayList<Controller> controllerList = new ArrayList<Controller>();
        Collection bundles = this.getBundles(this.scope);
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            String arrayWWN = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            devmgr.versioned.symbol.Controller[] ozControllers = bundle.getController();
            int count = ozControllers == null ? 0 : ozControllers.length;
            for (int i = 0; i < count; ++i) {
                devmgr.versioned.symbol.Controller ozController = ozControllers[i];
                Controller controller = new Controller();
                this.setProps(ozController, controller);
                Map refKey = ManageControllers.getControllerKeyMap(arrayWWN, Convert.bytesToString(ozController.getControllerRef().getRefToken()));
                controller.setKey(refKey);
                controllerList.add(controller);
            }
        }
        if (controllerList != null && controllerList.size() > 1 && "B".equals((c = (Controller)controllerList.get(0)).getName())) {
            controllerList.add(c);
            controllerList.remove(0);
        }
        if (this.sf != null) {
            return this.filterList(controllerList);
        }
        return controllerList;
    }

    private void setProps(devmgr.versioned.symbol.Controller ozController, Controller controller) throws ConfigMgmtException {
        if (ozController == null || ozController.getPhysicalLocation() == null) {
            controller.setName(null);
        } else if (ozController.getPhysicalLocation().getSlot() == 1) {
            controller.setName("A");
        } else {
            controller.setName("B");
        }
        Trace.verbose((Object)this, "setProps", "Controller name:" + controller.getName());
        controller.setActive(ozController.getActive());
        controller.setState(ozController.getStatus().getValue());
        controller.setStatus(ozController.getStatus().getValue());
        controller.setCacheMemSize(ozController.getCacheMemorySize());
        controller.setLocation(ozController.getPhysicalLocation().getSlot());
        IOInterfaceTypeData[] driveInterfaces = ozController.getDriveInterfaces();
        if (driveInterfaces.length != 0) {
            controller.setDriveInterface(driveInterfaces[0].getInterfaceType().getValue());
        } else {
            controller.setDriveInterface(-1);
        }
        controller.setHardAddress(controller.getHardAddress());
        IOInterfaceTypeData[] hostInterfaces = ozController.getHostInterfaces();
        if (hostInterfaces.length != 0) {
            controller.setHostInterface(hostInterfaces[0].getInterfaceType().getValue());
            FibreInterface fibre = hostInterfaces[0].getFibre();
            if (fibre != null) {
                controller.setFcTopology(fibre.getTopology().getValue());
                controller.setFcSpeed(fibre.getSpeed());
                controller.setFcMaxSpeed(fibre.getMaxSpeed());
                controller.setChannel(fibre.getChannel());
                controller.setChannelMiswire(fibre.getChanMiswire());
                controller.setLinkStatus(fibre.getLinkStatus().getValue());
            }
        }
        controller.setManufacturer(ozController.getManufacturer());
        controller.setQuisced(ozController.getQuiesced());
        controller.setSerialNumber(ozController.getSerialNumber());
        Trace.verbose((Object)this, "setProps", "Set controller network configuration");
        NetInterfaceTypeData[] netInterfaces = ozController.getNetInterfaces();
        if (netInterfaces.length != 0 && netInterfaces[0].getInterfaceType().getValue() == 1) {
            controller.setBootpEnabled(netInterfaces[0].getEthernet().getBootpUsed());
            controller.setInterfaceName(netInterfaces[0].getEthernet().getInterfaceName());
            controller.setIpAddress(Convert.getIpStrFromInt(netInterfaces[0].getEthernet().getIp()));
            Trace.verbose((Object)this, "setProps", "IP:" + netInterfaces[0].getEthernet().getIp());
            controller.setGatewayAddress(Convert.getIpStrFromInt(netInterfaces[0].getEthernet().getGatewayIp()));
            Trace.verbose((Object)this, "setProps", "Netmask:" + netInterfaces[0].getEthernet().getSubnetMask());
            controller.setNetmask(Convert.getIpStrFromInt(netInterfaces[0].getEthernet().getSubnetMask()));
        }
        Trace.verbose((Object)this, "setProps", "Set properties DONE");
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getItemList().size();
    }

    public void modify(Object objKey, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        EthernetParamsUpdateDescriptor netConfig = null;
        String originalIP = "";
        Map key = null;
        key = objKey instanceof Map ? (Map)objKey : Convert.keyAsStringToMap((String)objKey);
        try {
            String arrayWWN = (String)key.get("array");
            CommandProcessor command = new CommandProcessor(arrayWWN);
            List controllerList = this.getItemList();
            Controller c = (Controller)this.getControllerForKey(key, controllerList, true);
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayWWN);
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String currElement = (String)enumeration.nextElement();
                Trace.verbose((Object)this, "modify", "Modify - Element: " + currElement);
                if (props.get(currElement) == null) {
                    Trace.error((Object)this, "modify", "Property value is null for property: " + currElement);
                    continue;
                }
                if ("TIME".equals(currElement)) {
                    Long requestedTime = new Long((String)props.get(currElement));
                    if (c.getTime() == requestedTime.longValue()) continue;
                    this.setTime(command, key, requestedTime);
                    continue;
                }
                if ("IP_ADDRESS".equals(currElement)) {
                    if (c == null || c.getIpAddress() == null || c.getIpAddress().equals(props.get(currElement))) continue;
                    if (netConfig == null) {
                        netConfig = new EthernetParamsUpdateDescriptor();
                        this.fillDefaultsForNetConfig(key, netConfig, controllerList);
                    }
                    originalIP = Convert.getIpStrFromInt(netConfig.getIp());
                    netConfig.setIp(Convert.getIpIntFromString((String)props.get(currElement)));
                    continue;
                }
                if ("GATEWAY".equals(currElement)) {
                    if (c == null || c.getGatewayAddress() == null || c.getGatewayAddress().equals(props.get(currElement))) continue;
                    if (netConfig == null) {
                        netConfig = new EthernetParamsUpdateDescriptor();
                        this.fillDefaultsForNetConfig(key, netConfig, controllerList);
                    }
                    netConfig.setGatewayIp(Convert.getIpIntFromString((String)props.get(currElement)));
                    continue;
                }
                if ("NET_MASK".equals(currElement)) {
                    if (c == null || c.getNetMask() == null || c.getNetMask().equals(props.get(currElement))) continue;
                    if (netConfig == null) {
                        netConfig = new EthernetParamsUpdateDescriptor();
                        this.fillDefaultsForNetConfig(key, netConfig, controllerList);
                    }
                    netConfig.setSubnetMask(Convert.getIpIntFromString((String)props.get(currElement)));
                    continue;
                }
                if (!"ACTIVE".equals(currElement) || c == null || c.getActive() && "ACTIVE".equals(props.get(currElement)) || !c.getActive() && "FAILED".equals(props.get(currElement))) continue;
                this.setActive(command, key, (String)props.get(currElement));
            }
            if (netConfig != null) {
                this.setNetworkParams(command, key, netConfig, originalIP, controllerList);
            }
            ObjectBundleManager.getInstance().forceBundleReload(arrayWWN);
        }
        catch (RPCError e) {
            Trace.error((Object)this, (Throwable)e);
            LogAPI.staticLog((String)"CONTROLLER_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage());
        }
        catch (IOException e) {
            Trace.error((Object)this, (Throwable)e);
            LogAPI.staticLog((String)"CONTROLLER_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"CONTROLLER_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw cme;
        }
        LogAPI.staticLog((String)"CONTROLLER_MODIFY_SUCCESS", (String[])new String[0], (String[])new String[0]);
    }

    private void fillDefaultsForNetConfig(Object key, EthernetParamsUpdateDescriptor netConfig, List controllerList) throws ConfigMgmtException {
        Map mapKey = null;
        mapKey = key instanceof Map ? (Map)key : Convert.keyAsStringToMap((String)key);
        Controller cont = (Controller)this.getControllerForKey(mapKey, controllerList, true);
        netConfig.setChannel(cont.getChannel());
        netConfig.setGatewayIp(Convert.getIpIntFromString(cont.getGatewayAddress()));
        netConfig.setIp(Convert.getIpIntFromString(cont.getIpAddress()));
        netConfig.setSubnetMask(Convert.getIpIntFromString(cont.getNetMask()));
        netConfig.setInterfaceName(cont.getInterfaceName());
    }

    public void setTime(CommandProcessor command, Object key, Long time) throws ConfigMgmtException {
        String METHOD_NAME = "setTime";
        Object sym = null;
        if (key == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object key is null.");
        }
        if (time == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "New time is null.");
        }
        ControllerRef cRef = new ControllerRef();
        String crefS = (String)((Map)key).get("controllerRef");
        cRef.setRefToken(Convert.stringToBytes(crefS));
        ReturnCode retCode = new ReturnCode();
        XDRlong xdrTime = new XDRlong();
        xdrTime.setValue(time.longValue());
        command.setPreferredController(crefS);
        command.execute(28, (XDRType)xdrTime, (XDRType)retCode, true);
        if (retCode.getValue() != 1) {
            String msg = "setTime operation failed: " + retCode.getValue();
            Trace.error((Object)this, "setTime", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    private void setNetworkParams(CommandProcessor command, Object key, EthernetParamsUpdateDescriptor netConfig, String originalIP, List controllerList) throws ConfigMgmtException {
        String METHOD_NAME = "setNetworkParams";
        if (key == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object key is null.");
        }
        if (netConfig == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "New EthernetParamsUpdateDescriptor is null.");
        }
        try {
            ArrayReg ar;
            int i;
            String arrayWWN = (String)((Map)key).get("array");
            ControllerRef cRef = new ControllerRef();
            String crefS = (String)((Map)key).get("controllerRef");
            cRef.setRefToken(Convert.stringToBytes(crefS));
            netConfig.setControllerRef(cRef);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "setNetworkParams", "setting netconfig mask:" + netConfig.getSubnetMask() + "\n IP:" + netConfig.getIp() + "\n Gateway:" + netConfig.getGatewayIp() + "\n Interface name:" + netConfig.getInterfaceName() + "\n Channel:" + netConfig.getChannel() + "\n Controller ref:" + Convert.bytesToString(netConfig.getControllerRef().getRefToken()));
            }
            ReturnCode retCode = new ReturnCode();
            ControllerInterface otherController = this.getControllerForKey((Map)key, controllerList, false);
            String otherContrRef = (String)otherController.getKey().get("controllerRef");
            command.setPreferredController(otherContrRef);
            command.setAllowFailover(false);
            command.execute(125, (XDRType)netConfig, (XDRType)retCode, true);
            if (retCode.getValue() != 1 && retCode.getValue() != 14) {
                String msg = "setNetworkParams operation failed: " + retCode.getValue();
                Trace.error((Object)this, "setNetworkParams", msg);
                throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
            }
            Trace.verbose((Object)this, "setNetworkParams", "Network params changed with return code:" + retCode.getValue());
            String expectedIP = Convert.getIpStrFromInt(netConfig.getIp());
            Trace.verbose((Object)this, "setNetworkParams", "Expected IP:" + expectedIP);
            boolean isDHCP = false;
            if (netConfig.getIp() == 0) {
                Trace.verbose((Object)this, "setNetworkParams", "DHCP Detected - try to get new IP");
                isDHCP = true;
            }
            CoreManagedObject contrBOL = null;
            String newIPForController = "0.0.0.0";
            int retryCounter = 60;
            block10: while (retryCounter > 0 && "0.0.0.0".equals(newIPForController)) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ObjectBundle bundle = new ObjectBundle();
                Trace.verbose((Object)this, "setNetworkParams", "Get the bundle!");
                try {
                    command.execute(40, null, (XDRType)bundle, false);
                    devmgr.versioned.symbol.Controller[] c = bundle.getController();
                    for (i = 0; i < c.length; ++i) {
                        String cref = Convert.bytesToString(c[i].getControllerRef().getRefToken());
                        if (!cref.equals(crefS)) continue;
                        Trace.verbose((Object)this, "setNetworkParams", "Found modified controller...");
                        contrBOL = new Controller();
                        this.setProps(c[i], (Controller)contrBOL);
                        if (!isDHCP && !expectedIP.equals(((com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.common.Controller)contrBOL).getIpAddress())) continue block10;
                        newIPForController = ((com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.common.Controller)contrBOL).getIpAddress();
                        continue block10;
                    }
                }
                catch (Exception cme) {
                    Trace.verbose((Object)this, "setNetworkParams", cme.getMessage());
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            if (!"0.0.0.0".equals(newIPForController)) {
                ar = ArrayRegManager.getInstance().getArrayRegistration(arrayWWN);
                String[] allIPs = ar.getIps();
                for (i = 0; i < allIPs.length; ++i) {
                    if (!allIPs[i].equals(originalIP)) continue;
                    allIPs[i] = newIPForController;
                    break;
                }
            } else {
                Trace.error((Object)this, "setNetworkParams", "The controller IP address cannot be verified.");
                String ctrlName = contrBOL == null ? "" : contrBOL.getName();
                throw new ConfigMgmtException("error.controller.ip.cannot.be.verified", new String[]{ctrlName}, "", null);
            }
            ar.setDirectIps(new String[0]);
            ObjectBundleManager man = ObjectBundleManager.getInstance();
            man.modifyRegistration(ar);
        }
        catch (IOException ex) {
            Trace.error((Object)this, "setNetworkParams", (Throwable)ex);
            throw new ConfigMgmtException("error.communication", "setNetworkParams", ex);
        }
        Trace.verbose((Object)this, "setNetworkParams", "All done, give the array some breathing room");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public void reset(Object key) throws UnsupportedOperationException, ConfigMgmtException {
        String METHOD_NAME = "reset";
        Object errorDesc = null;
        if (key == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object key is null.");
        }
        Map keyMap = null;
        keyMap = key instanceof Map ? (Map)key : Convert.keyAsStringToMap((String)key);
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        try {
            CommandProcessor command = new CommandProcessor(arrayKey);
            List controllerList = this.getItemList();
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayKey);
            ControllerRef cRef = new ControllerRef();
            String crefS = (String)keyMap.get("controllerRef");
            ControllerInterface otherController = this.getControllerForKey(keyMap, controllerList, false);
            ControllerInterface controllerToModify = this.getControllerForKey(keyMap, controllerList, true);
            String otherCtrlRefS = (String)otherController.getKey().get("controllerRef");
            cRef.setRefToken(Convert.stringToBytes(crefS));
            ReturnCode retCode = new ReturnCode();
            command.setPreferredController(otherCtrlRefS);
            command.setAllowFailover(false);
            int procNum = 92;
            if (controllerToModify.getStatus() != 1) {
                procNum = 36;
            } else if (!controllerToModify.getActive()) {
                procNum = 25;
            }
            command.execute(procNum, (XDRType)cRef, (XDRType)retCode, true);
            if (retCode.getValue() != 1 && retCode.getValue() != 14) {
                Trace.error((Object)this, "reset", "Reset controller returned error code:" + retCode.getValue());
                throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), "");
            }
            Trace.verbose((Object)this, "reset", "Controller reset/online success with code:" + retCode.getValue());
            this.validateConnectionAfterChange(command, crefS);
        }
        catch (RPCError e) {
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (IOException e) {
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayKey);
        }
    }

    private void validateConnectionAfterChange(CommandProcessor command, String crefS) throws ConfigMgmtException {
        String METHOD_NAME = "validateConnectionAfterChange";
        boolean gotBundle = false;
        int counter = 40;
        while (counter > 0 && !gotBundle) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            ObjectBundle bundle = new ObjectBundle();
            command.setPreferredController(crefS);
            command.setAllowFailover(false);
            try {
                command.execute(40, null, (XDRType)bundle, false);
                Trace.verbose((Object)this, "validateConnectionAfterChange", "Got the bundle, reset is complete");
                gotBundle = true;
            }
            catch (ConfigMgmtException e2) {
                Trace.verbose((Object)this, "validateConnectionAfterChange", "Could not get the bundle on the controller that was reset");
                --counter;
            }
        }
        if (!gotBundle) {
            throw new ConfigMgmtException("caution.controller.reset.cannot.be.verified", "");
        }
    }

    private void setActive(CommandProcessor command, Object key, String state) throws ConfigMgmtException {
        String METHOD_NAME = "setTime";
        Object sym = null;
        if (key == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object key is null.");
        }
        if (state == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "New time is null.");
        }
        ControllerRef cRef = new ControllerRef();
        String crefS = (String)((Map)key).get("controllerRef");
        cRef.setRefToken(Convert.stringToBytes(crefS));
        command.setPreferredController(crefS);
        ReturnCode retCode = new ReturnCode();
        if ("ACTIVE".equals(state)) {
            command.execute(25, (XDRType)cRef, (XDRType)retCode, true);
        } else if ("FAILED".equals(state)) {
            command.execute(10, (XDRType)cRef, (XDRType)retCode, true);
        } else if ("OPTIMAL".equals(state)) {
            command.execute(36, (XDRType)cRef, (XDRType)retCode, true);
        } else if ("PASSIVE".equals(state)) {
            command.execute(24, (XDRType)cRef, (XDRType)retCode, true);
        }
        if (retCode.getValue() != 1) {
            String msg = "setTime operation failed: " + retCode.getValue();
            Trace.error((Object)this, "setTime", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    private ControllerInterface getControllerForKey(Map key, List controllerList, boolean matchKey) throws ConfigMgmtException {
        ControllerInterface c = null;
        for (int i = 0; !(i >= controllerList.size() || (c = (ControllerInterface)controllerList.get(i)).getKey().get("controllerRef").equals((String)key.get("controllerRef")) && matchKey || !c.getKey().get("controllerRef").equals((String)key.get("controllerRef")) && !matchKey); ++i) {
        }
        return c;
    }

    static Map getControllerKeyMap(String arrayWWN, String controllerRef) {
        HashMap<String, String> key = new HashMap<String, String>(2);
        key.put("array", arrayWWN);
        key.put("controllerRef", controllerRef);
        return key;
    }

    private List filterList(List objList) {
        String name;
        String methodName = "filterList";
        Trace.verbose((Object)this, "filterList", "Filtering controller list....");
        ArrayList<Controller> filteredList = new ArrayList<Controller>();
        String ref = this.getRefFromFilter();
        if (ref != null) {
            Trace.verbose((Object)this, "filterList", "Filtering by controller key");
            Iterator iter = objList.iterator();
            while (iter.hasNext()) {
                Controller item = (Controller)iter.next();
                Map key = item.getKey();
                String currRef = (String)key.get("controllerRef");
                if (!ref.equals(currRef)) continue;
                filteredList.add(item);
                break;
            }
        }
        if ((name = this.getNameFromFilter()) != null) {
            Trace.verbose((Object)this, "filterList", "Filtering by controller name");
            Iterator iter = objList.iterator();
            while (iter.hasNext()) {
                Controller item = (Controller)iter.next();
                Map key = item.getKey();
                String currName = item.getName();
                if (!name.equals(currName)) continue;
                filteredList.add(item);
            }
        }
        return filteredList;
    }

    private String getRefFromFilter() {
        String keyAsString;
        String methodName = "getRefFromFilter";
        String ref = null;
        if (this.sf != null && !this.sf.isEmpty() && this.sf.getSearchField().equals("keyAsString") && (keyAsString = this.sf.getSearchString()) != null) {
            Map map = Convert.keyAsStringToMap(keyAsString);
            ref = (String)map.get("controllerRef");
        }
        return ref;
    }

    private String getNameFromFilter() {
        String methodName = "getNameFromFilter";
        String name = null;
        if (this.sf != null && !this.sf.isEmpty() && this.sf.getSearchField().equals("name")) {
            name = this.sf.getSearchString();
        }
        return name;
    }

    public static interface ControllerState {
        public static final String ACTIVE = "ACTIVE";
        public static final String PASSIVE = "PASSIVE";
        public static final String OPTIMAL = "OPTIMAL";
        public static final String FAILED = "FAILED";
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
    }

    public static interface ModifyProperties {
        public static final String TIME = "TIME";
        public static final String IP_ADDRESS = "IP_ADDRESS";
        public static final String NET_MASK = "NET_MASK";
        public static final String GATEWAY = "GATEWAY";
        public static final String ACTIVE = "ACTIVE";
    }

    public static interface ControllerName {
        public static final String A = "A";
        public static final String B = "B";
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String CONTROLLER_REF = "controllerRef";
    }
}

