/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.CoreManagedObjectInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCodeType;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayReg;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayRegDetail;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayRegManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CSMProxy;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ControllerInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageArraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageControllersFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageControllersInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ArrayImportExport;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ArrayImportManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageControllers;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.MgmtPath;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.oz.devices.CSMArray;
import com.sun.oz.devices.CSMArrayException;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.jrpc.XDRint;
import devmgr.versioned.jrpc.XDRvoid;
import devmgr.versioned.sam.security.PBE;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ControllerTime;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.DriveRefList;
import devmgr.versioned.symbol.EncryptedPassword;
import devmgr.versioned.symbol.EncryptionType;
import devmgr.versioned.symbol.HostPortRef;
import devmgr.versioned.symbol.HostPortTypeUpdateDescriptor;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PKCS5EncryptionData;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithRef;
import devmgr.versioned.symbol.SACache;
import devmgr.versioned.symbol.SACacheParamsUpdateDescriptor;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.UserAssignedLabel;
import devmgr.versioned.symbol.Volume;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManageArrays
implements ManageArraysInterface,
Constants.T4,
Constants.StorageSize {
    public static final String EXCLUDE_ARRAY_IN_SCOPE = "EXCLUDE_ARRAY_IN_SCOPE";
    public static String KEY1 = "array";
    public static final int[] VALID_CACHE_BLOCK_SIZE = new int[]{4096, 16384};
    ConfigContext cfgctx;
    Scope scope;
    SearchFilter filter;

    public void init(ConfigContext context, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = context;
        this.scope = s;
        this.filter = f;
    }

    public MethodCallStatus shutdown(List list) throws UnsupportedOperationException, ConfigMgmtException {
        throw new UnsupportedOperationException();
    }

    public MethodCallStatus restart(List list) throws UnsupportedOperationException, ConfigMgmtException {
        return this.reset(list);
    }

    public void setPassword(String oldPassword, String newPassword) throws UnsupportedOperationException, ConfigMgmtException {
        throw new UnsupportedOperationException();
    }

    public List discover() throws UnsupportedOperationException {
        Collection discoveredList = ObjectBundleManager.getInstance().discoverArrays();
        int sz = discoveredList == null ? 0 : discoveredList.size();
        ArrayList<ArrayRegDetail> newList = new ArrayList<ArrayRegDetail>();
        if (sz > 0) {
            Iterator it = discoveredList.iterator();
            while (it.hasNext()) {
                newList.add(new ArrayRegDetail((ArrayReg)it.next()));
            }
        }
        return newList;
    }

    public ErrorDescriptor register(Properties props) throws ConfigMgmtException {
        String methodName = "register";
        Trace.methodBegin(this, "register");
        ErrorDescriptor ed = null;
        ArrayReg ar = new ArrayReg();
        String[] ips = new String[]{props.getProperty("ip1")};
        ar.setIps(ips);
        ar.setPassword(props.getProperty("password"));
        ar.setType("6130");
        ArrayList<ArrayReg> al = new ArrayList<ArrayReg>(2);
        al.add(ar);
        MethodCallStatus mcs = ObjectBundleManager.getInstance().registerArrays(al);
        List el = mcs.getErrorDescList();
        ed = (ErrorDescriptor)el.get(0);
        Trace.verbose((Object)this, "register", "Return code:" + mcs.getReturnCode());
        String[] params = ed.getI18nParams();
        String[] newParams = null;
        if (params != null && params.length > 0) {
            newParams = new String[params.length + 1];
            for (int i = 0; i < params.length; ++i) {
                newParams[i] = params[i];
            }
            newParams[params.length] = ips[0];
        } else {
            newParams = new String[]{ips[0]};
        }
        ed.setI18nParams(newParams);
        if (mcs.getReturnCode() == 2) {
            ConfigMgmtException cme = new ConfigMgmtException();
            throw new ConfigMgmtException(ed.getI18nkey(), ed.getI18nParams(), ed.getMsg(), null);
        }
        if (Repository.getRepository().getProperty("allow-analyze-and-update") != null && Boolean.valueOf((String)Repository.getRepository().getProperty("allow-analyze-and-update")).booleanValue()) {
            ar = ArrayRegManager.getInstance().getArrayRegistration(ips, "6130");
            if (ar == null) {
                Trace.verbose((Object)this, "register", "Array Reg is null");
                ed = new ErrorDescriptor(ErrorCode.ERROR_REG_ARRAY_NOT_FOUND);
                throw new ConfigMgmtException(ed.getI18nkey(), ed.getMsg(), null);
            }
            Trace.verbose((Object)this, "register", "Array Reg is NOT null");
            ArrayList<ArrayReg> alist = new ArrayList<ArrayReg>();
            alist.add(ar);
            ArrayList resList = (ArrayList)this.analyzeArrayList(alist);
            return ((ArrayRegDetail)resList.get(0)).getErrDescriptor();
        }
        return ed;
    }

    public MethodCallStatus unregister(List list) throws ConfigMgmtException {
        List convertedList = Convert.listOfStringKeysToMap(list);
        int size = convertedList == null ? 0 : convertedList.size();
        ArrayList<String> wwnList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            wwnList.add((String)((Map)convertedList.get(i)).get("array"));
        }
        MethodCallStatus mcs = ObjectBundleManager.getInstance().unregisterArrays(wwnList);
        return mcs;
    }

    private EncryptedPassword getEncryptedPassword(String oldPassword, String newPassword) throws ConfigMgmtException {
        String METHOD_NAME = "getEncryptedPassword";
        int NUMBER_OF_ITERATIONS = 1000;
        int SALT_LENGTH = 8;
        EncryptedPassword encryptedPassword = new EncryptedPassword();
        byte[] salt = new byte[8];
        SecureRandom secureRandom = new SecureRandom();
        PKCS5EncryptionData pkcs5Data = encryptedPassword.getPkcs5Data();
        PBE pbe = new PBE();
        secureRandom.nextBytes(salt);
        try {
            pbe.init(true, UnicodeTranslator.getBytes((String)oldPassword), salt, 1000);
        }
        catch (NoSuchAlgorithmException e) {
            Trace.error((Object)this, "getEncryptedPassword", "Caught exception initializing encryption object:");
            throw new ConfigMgmtException(e);
        }
        pkcs5Data.setIterations(1000);
        pkcs5Data.setSalt(salt);
        pkcs5Data.setCipherText(pbe.crypt(UnicodeTranslator.getBytes((String)newPassword)));
        encryptedPassword.setType(new EncryptionType(1));
        encryptedPassword.setPkcs5Data(pkcs5Data);
        return encryptedPassword;
    }

    public MethodCallStatus reset(List list) throws UnsupportedOperationException, ConfigMgmtException {
        MethodCallStatus mcs = new MethodCallStatus();
        ArrayList mcsList = new ArrayList();
        Object errorDesc = null;
        if (list == null || list.size() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null or empty list passed to ManageArrays.reset().");
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Scope scope = new Scope();
            scope.setAttribute("array", key);
            ManageControllersInterface mgr = ManageControllersFactory.getManager(this.cfgctx, scope, null);
            List controllerList = mgr.getItemList();
            for (int j = 0; j < controllerList.size(); ++j) {
                ControllerInterface c = (ControllerInterface)controllerList.get(j);
                try {
                    mgr.reset(c.getKey());
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    ErrorDescriptor ed = new ErrorDescriptor();
                    ed.setErrorCode(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getErrorCode());
                    ed.setI18nkey(cme.getExceptionKey());
                    if (cme.getSubstitutions() != null) {
                        ed.setI18nParams(cme.getSubstitutions());
                    }
                    ed.setMsg(cme.getMessage());
                    mcs.addErrorDescriptor(ed);
                }
            }
        }
        return mcs;
    }

    public MethodCallStatus backupConfiguration(List list, String backupPath) throws UnsupportedOperationException, ConfigMgmtException {
        throw new UnsupportedOperationException();
    }

    public void addBackupConfiguration(StringBuffer config, String backupPath) throws UnsupportedOperationException, ConfigMgmtException {
        throw new UnsupportedOperationException();
    }

    public StringBuffer getBackupDetails(String backupPath) throws UnsupportedOperationException, ConfigMgmtException {
        throw new UnsupportedOperationException();
    }

    public List getConfigurationBackups(String backupDir) throws UnsupportedOperationException, ConfigMgmtException {
        throw new UnsupportedOperationException();
    }

    public void restoreConfiguration(String backupLocation, List targetArrays) throws UnsupportedOperationException, ConfigMgmtException {
        throw new UnsupportedOperationException();
    }

    public boolean validateConfiguration(StringBuffer config) throws UnsupportedOperationException, ConfigMgmtException {
        throw new UnsupportedOperationException();
    }

    public boolean validateConfiguration(String backupPath) throws UnsupportedOperationException, ConfigMgmtException {
        throw new UnsupportedOperationException();
    }

    public StringBuffer exportConfigToXml(Object arrayKey) throws UnsupportedOperationException, ConfigMgmtException {
        String METHOD_NAME = "exportConfigToXml";
        Trace.methodBegin(this, "exportConfigToXml");
        Map key = null;
        key = arrayKey instanceof Map ? (Map)arrayKey : Convert.keyAsStringToMap((String)arrayKey);
        String arrayWwn = (String)key.get("array");
        if (arrayWwn == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null or empty list passed to ManageArrays.exportConfigToXml() method.");
        }
        ArrayImportExport exporter = new ArrayImportExport(arrayWwn, this, this.cfgctx);
        StringBuffer sb = exporter.exportConfigToXml(arrayWwn);
        return sb;
    }

    public MethodCallStatus importConfigToArray(Object arrayKey, StringBuffer config, boolean checkOnly) throws UnsupportedOperationException, ConfigMgmtException {
        String METHOD_NAME = "importConfigToArray";
        Trace.methodBegin(this, "importConfigToArray");
        Map key = null;
        key = arrayKey instanceof Map ? (Map)arrayKey : Convert.keyAsStringToMap((String)arrayKey);
        String arrayWwn = (String)key.get("array");
        if (arrayWwn == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null key passed to ManageArrays.importConfigToArray method.");
        }
        ArrayImportManager mgr = ArrayImportManager.getInstance();
        return mgr.importConfigToArray(arrayWwn, this, this.cfgctx, config, checkOnly);
    }

    public void redistributeVolumes(ObjectBundle bundle, CommandProcessor command, String arrayWwn) throws ConfigMgmtException {
        String METHOD = "redistributeVolumes";
        Trace.methodBegin(this, "redistributeVolumes");
        Scope s = new Scope();
        s.setAttribute("array", arrayWwn);
        ManageVolumes mv = (ManageVolumes)ManageVolumesFactory.getManager(this.cfgctx, s, null);
        Volume[] ozVols = bundle.getVolume();
        int size = ozVols == null ? 0 : ozVols.length;
        for (int i = 0; i < size; ++i) {
            Volume thisVolume = ozVols[i];
            ControllerRef prefConRef = thisVolume.getPreferredManager();
            ControllerRef currConRef = thisVolume.getCurrentManager();
            String pref = Convert.bytesToStringRaw(prefConRef.getRefToken());
            String curr = Convert.bytesToStringRaw(currConRef.getRefToken());
            if (Trace.isTraceEnabled(this)) {
                String volName = null;
                if (thisVolume.getLabel().getValue() != null) {
                    volName = UnicodeTranslator.getString((byte[])thisVolume.getLabel().getValue());
                }
                Trace.verbose((Object)this, "redistributeVolumes", "check " + volName + "," + pref + "," + curr);
            }
            if (pref.equals(curr)) continue;
            mv.assignVolumeOwnership(thisVolume, prefConRef, arrayWwn);
        }
    }

    public void clearArrayConfiguration(CommandProcessor command, String wwn) throws ConfigMgmtException {
        String METHOD_NAME = "clearArrayConfiguration";
        ReturnCode retCode = new ReturnCode();
        ObjectBundleManager.getInstance().stopMonitoringThread(wwn);
        command.execute(49, null, (XDRType)retCode, true);
        Trace.verbose((Object)this, "clearArrayConfiguration", "clearSAConfiguration returned with error code:" + retCode.getValue());
        if (retCode.getValue() != 1 && retCode.getValue() != 14) {
            String msg = "clearArrayConfiguration operation failed: " + retCode.getValue();
            Trace.error((Object)this, "clearArrayConfiguration", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
        Trace.verbose((Object)this, "clearArrayConfiguration", "Assume all is well...");
        for (int retries = 1; retries < 11; ++retries) {
            Trace.verbose((Object)this, "clearArrayConfiguration", "getObjectBundle(), try " + retries);
            try {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                ObjectBundle bundle = new ObjectBundle();
                command.execute(40, null, (XDRType)bundle, false);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
    }

    public void setCustomData(StorageArray sa) throws ConfigMgmtException {
        int i;
        String METHOD_NAME = "setCustomData";
        Trace.methodBegin(this, "setCustomData");
        ObjectBundleManager man = ObjectBundleManager.getInstance();
        String arrayWWN = (String)sa.getKey().get("array");
        ObjectBundle bundle = man.getObjectBundle(arrayWWN);
        devmgr.versioned.symbol.StorageArray ozArray = bundle.getSa();
        sa.setWwn(arrayWWN);
        sa.setCacheBlockSize(ozArray.getCache().getCacheBlkSize());
        sa.setCacheFlushAmount(ozArray.getCache().getDemandFlushAmount());
        sa.setCacheFlushThreshold(ozArray.getCache().getDemandFlushThreshold());
        sa.setFailOverAlertDelay(ozArray.getVolXferAlertDelayPeriod());
        sa.setMediaScanPeriod(ozArray.getMediaScanPeriod());
        Controller[] controllers = bundle.getController();
        sa.setNumFibreChannelHotSpares(this.getNumHotSpares(bundle, 2));
        sa.setNumSataHotSpares(this.getNumHotSpares(bundle, 3));
        sa.setNumHotSpares(sa.getNumFibreChannelHotSpares() + sa.getNumSataHotSpares());
        NetInterfaceTypeData[] netData1 = controllers[0].getNetInterfaces();
        NetInterfaceTypeData[] netData2 = controllers[1].getNetInterfaces();
        for (i = 0; i < netData1.length; ++i) {
            if (netData1[i].getInterfaceType().getValue() != 1) continue;
            sa.setIpAddress1(netData1[i].getEthernet().getIp());
            sa.setGatewayAddress1(netData1[i].getEthernet().getGatewayIp());
            sa.setNetMask1(netData1[i].getEthernet().getSubnetMask());
            break;
        }
        for (i = 0; i < netData2.length; ++i) {
            if (netData1[i].getInterfaceType().getValue() != 1) continue;
            sa.setIpAddress2(netData2[i].getEthernet().getIp());
            sa.setGatewayAddress2(netData2[i].getEthernet().getGatewayIp());
            sa.setNetMask2(netData2[i].getEthernet().getSubnetMask());
            break;
        }
        sa.setDefaultHostPortType(ozArray.getDefaultHostPortTypeIndex());
        this.getControllerTime(sa, arrayWWN);
    }

    private void getControllerTime(StorageArray sa, String arrayWWN) throws ConfigMgmtException {
        block7: {
            String METHOD_NAME = "getControllerTime";
            ControllerTime ct = new ControllerTime();
            CommandProcessor command = null;
            try {
                command = new CommandProcessor(arrayWWN);
                command.execute(117, (XDRType)new XDRvoid(), (XDRType)ct, false);
                try {
                    Trace.verbose((Object)this, "getControllerTime", "Controller A TIME:" + ct.getControllerATime());
                    if (ct.getControllerATime() != 0L) {
                        sa.setTime(ct.getControllerATime());
                        break block7;
                    }
                    sa.setTime(ct.getControllerBTime());
                }
                catch (Exception e) {
                    sa.setTime(ct.getControllerBTime());
                }
            }
            catch (SEItemNotFoundException e) {
                Trace.error((Object)this, "getControllerTime", (ConfigMgmtException)e);
                throw new ConfigMgmtException(e);
            }
            catch (RPCError e) {
                Trace.error((Object)this, "getControllerTime", (Throwable)e);
                throw new ConfigMgmtException((Exception)((Object)e));
            }
            catch (IOException e) {
                Trace.error((Object)this, "getControllerTime", (Throwable)e);
                throw new ConfigMgmtException(e);
            }
        }
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD_NAME = "getItemList";
        Trace.methodBegin(this, "getItemList");
        Object manager = null;
        List arrayList = ObjectBundleManager.getInstance().getAllArraysData();
        if (this.scope != null) {
            String arrayWWN = Convert.scopeToArrayKey(this.scope);
            XDRvoid xdrVoid = new XDRvoid();
            ObjectBundle bundle = new ObjectBundle();
            Object commandProcessor = null;
            ArrayList<StorageArray> al = new ArrayList<StorageArray>();
            Iterator iter = arrayList.iterator();
            while (iter.hasNext()) {
                StorageArray sa = (StorageArray)iter.next();
                if (this.filter != null && this.filter.getSearchField().equals("replicationSetIsActivated")) {
                    if ("replicationSetIsActivated".equals(this.filter.getSearchField()) && this.filter.getSearchString().equals(EXCLUDE_ARRAY_IN_SCOPE)) {
                        Trace.verbose((Object)this, "getItemList", "arrayWWN: " + arrayWWN);
                        Trace.verbose((Object)this, "getItemList", "SA Array: " + (String)sa.getKey().get("array"));
                        if (arrayWWN.equals((String)sa.getKey().get("array"))) {
                            Trace.verbose((Object)this, "getItemList", "MATCH found:" + sa.getName());
                            continue;
                        }
                    }
                    if (sa.isRemoteMirroringActive()) {
                        Trace.verbose((Object)this, "getItemList", "Remote mirroring is active for array:" + sa.getName());
                        al.add(sa);
                        continue;
                    }
                    Trace.verbose((Object)this, "getItemList", "Remote mirroring is NOT active for array:" + sa.getName());
                    continue;
                }
                if (!sa.getKey().get("array").equals(arrayWWN)) continue;
                this.setCustomData(sa);
                al.add(sa);
                return al;
            }
            return al;
        }
        return arrayList;
    }

    private int getNumOfHS(String arrayWWN) throws ConfigMgmtException {
        ManageDisks diskManager = new ManageDisks();
        Scope ds = new Scope();
        ds.setAttribute(Scope.TYPE, "array");
        ds.setAttribute(Scope.VALUE, arrayWWN);
        SearchFilter diskFilter = new SearchFilter();
        diskFilter.setSearchFilter("role", "globalStandbyDisk");
        diskManager.init(this.cfgctx, this.scope, diskFilter);
        return diskManager.getItemCount();
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getItemList().size();
    }

    public void modify(Object objKey, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        SACacheParamsUpdateDescriptor saDesc = null;
        String oldPassword = null;
        String newPassword = null;
        String newLocalPassword = null;
        boolean reloadBundle = true;
        if (objKey == null) {
            LogAPI.staticLog((String)"ARRAY_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Object key is null.");
        }
        if (props == null) {
            LogAPI.staticLog((String)"ARRAY_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Properties object is null.");
        }
        Map key = null;
        key = objKey instanceof Map ? (Map)objKey : Convert.keyAsStringToMap((String)objKey);
        String arrayWwn = (String)key.get("array");
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        devmgr.versioned.symbol.StorageArray ozArray = bundle.getSa();
        String arrayName = ManageArrays.getArrayName(ozArray);
        boolean setCacheParams = false;
        SACache saCache = ozArray.getCache();
        saDesc = new SACacheParamsUpdateDescriptor();
        saDesc.setCacheBlkSize(saCache.getCacheBlkSize());
        saDesc.setDemandFlushAmount(saCache.getDemandFlushAmount());
        saDesc.setDemandFlushThreshold(saCache.getDemandFlushThreshold());
        ConfigMgmtException exc = null;
        try {
            Trace.verbose((Object)this, "modify", "Modify array with wwn:" + arrayWwn);
            CommandProcessor command = new CommandProcessor(arrayWwn);
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayWwn);
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String currElement = (String)enumeration.nextElement();
                if ("name".equals(currElement)) {
                    if (arrayName.equals((String)props.get(currElement))) continue;
                    this.setName(command, (String)props.get(currElement));
                    continue;
                }
                if ("TIME".equals(currElement)) {
                    try {
                        this.setTime(arrayWwn, props, command);
                    }
                    catch (ConfigMgmtException cme) {
                        exc = cme;
                    }
                    continue;
                }
                if ("failOverAlertDelay".equals(currElement)) {
                    if (ozArray.getVolXferAlertDelayPeriod() == new Integer((String)props.get(currElement)).intValue()) continue;
                    this.setFailOverAlertDelay(command, new Integer((String)props.get(currElement)));
                    continue;
                }
                if ("mediaScanPeriod".equals(currElement)) {
                    if (ozArray.getMediaScanPeriod() == new Integer((String)props.get(currElement)).intValue()) continue;
                    this.setMediaScanPeriod(command, new Integer((String)props.get(currElement)));
                    continue;
                }
                if ("cacheBlockSize".equals(currElement)) {
                    if (saCache.getCacheBlkSize() == new Integer((String)props.get(currElement)).intValue()) continue;
                    this.validateArrayCacheBlockSize(command, new Integer((String)props.get(currElement)));
                    setCacheParams = true;
                    saDesc.setCacheBlkSize(new Integer((String)props.get(currElement)).intValue());
                    continue;
                }
                if ("cacheFlushThreshold".equals(currElement)) {
                    if (saCache.getDemandFlushThreshold() == new Integer((String)props.get(currElement)).intValue()) continue;
                    setCacheParams = true;
                    saDesc.setDemandFlushThreshold(new Integer((String)props.get(currElement)).intValue());
                    continue;
                }
                if ("cacheFlushAmount".equals(currElement)) {
                    if (saCache.getDemandFlushAmount() == new Integer((String)props.get(currElement)).intValue()) continue;
                    setCacheParams = true;
                    saDesc.setDemandFlushAmount(new Integer((String)props.get(currElement)).intValue());
                    continue;
                }
                if ("numHotSpares".equals(currElement)) {
                    int numHotSpares = this.getNumHotSpares(bundle, 2) + this.getNumHotSpares(bundle, 3);
                    if (numHotSpares == new Integer((String)props.get(currElement))) continue;
                    this.setNumHotSpares(command, bundle, new Integer((String)props.get(currElement)));
                    continue;
                }
                if ("newPassword".equals(currElement)) {
                    newPassword = (String)props.get(currElement);
                    continue;
                }
                if ("oldPassword".equals(currElement)) {
                    oldPassword = (String)props.get(currElement);
                    continue;
                }
                if ("newLocalPassword".equals(currElement)) {
                    newLocalPassword = (String)props.get(currElement);
                    continue;
                }
                if ("arrayMgmtPath".equals(currElement)) {
                    if (this.mgmtPathsEqual((String)props.get(currElement))) continue;
                    this.modifyMgmtPaths((String)props.get(currElement));
                    continue;
                }
                if ("defaultHostType".equals(currElement)) {
                    if (props.get(currElement) == null || props.get(currElement).equals("") || ozArray.getDefaultHostPortTypeIndex() == new Integer((String)props.get(currElement)).intValue()) continue;
                    this.setDefaultHostPortType(command, (String)props.get(currElement));
                    continue;
                }
                if ("clearSAConfiguration".equals(currElement)) {
                    Trace.verbose((Object)this, "modify", "Clear array configuration");
                    this.clearArrayConfiguration(command, arrayWwn);
                    reloadBundle = false;
                    Trace.verbose((Object)this, "modify", "Configuration cleared - update registered password");
                    newLocalPassword = "";
                    continue;
                }
                if ("redistributeVolumes".equals(currElement)) {
                    Trace.verbose((Object)this, "modify", "Redistribute volumes");
                    this.redistributeVolumes(bundle, command, arrayWwn);
                    reloadBundle = false;
                    continue;
                }
                String msg = new String("Unsupported modify element: " + currElement);
                Trace.error((Object)this, "modify", msg);
            }
            if (newPassword != null && oldPassword != null) {
                this.setArrayPassword(command, arrayWwn, oldPassword, newPassword, false);
            } else if (newLocalPassword != null) {
                this.setArrayPassword(command, arrayWwn, "", newLocalPassword, true);
            }
            if (setCacheParams) {
                this.setCacheParams(command, saDesc);
            }
        }
        catch (RPCError e) {
            Trace.error((Object)this, (Throwable)e);
            LogAPI.staticLog((String)"ARRAY_MODIFY_ERROR", (String[])new String[]{arrayName}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage());
        }
        catch (IOException e) {
            Trace.error((Object)this, (Throwable)e);
            LogAPI.staticLog((String)"ARRAY_MODIFY_ERROR", (String[])new String[]{arrayName}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"ARRAY_MODIFY_ERROR", (String[])new String[]{arrayName}, (String[])new String[0]);
            throw cme;
        }
        finally {
            if (reloadBundle) {
                ObjectBundleManager.getInstance().forceBundleReload(arrayWwn);
            }
        }
        if (exc != null) {
            throw exc;
        }
        LogAPI.staticLog((String)"ARRAY_MODIFY_SUCCESS", (String[])new String[]{arrayName}, (String[])new String[0]);
    }

    private void validateArrayCacheBlockSize(CommandProcessor command, int requestedSize) throws ConfigMgmtException {
        String methodName = "validateArrayCacheBlockSize";
        Trace.verbose((Object)this, "validateArrayCacheBlockSize", "Requested cache size is:" + requestedSize);
        boolean isValid = false;
        for (int i = 0; i < VALID_CACHE_BLOCK_SIZE.length && !isValid; ++i) {
            if (requestedSize != VALID_CACHE_BLOCK_SIZE[i]) continue;
            isValid = true;
        }
        if (!isValid) {
            Trace.error((Object)this, "validateArrayCacheBlockSize", "Invalid requested cache block size for the array:" + requestedSize);
            throw new ConfigMgmtException("error.reason.100041", "");
        }
        ObjectBundle bundle = new ObjectBundle();
        command.execute(40, null, (XDRType)bundle, false);
        Volume[] ozVols = bundle.getVolume();
        int sz = ozVols == null ? 0 : ozVols.length;
        for (int i = 0; i < sz && isValid; ++i) {
            if (ozVols[i].getSegmentSize() >= requestedSize) continue;
            isValid = false;
            Trace.error((Object)this, "validateArrayCacheBlockSize", "Invalid requested cache block size for the array:" + requestedSize);
            Trace.error((Object)this, "validateArrayCacheBlockSize", "Volume with smaller block size exists:" + ozVols[i].getSegmentSize());
            throw new ConfigMgmtException("error.reason.100041", "");
        }
    }

    private void modifyMgmtPaths(String paths) throws ConfigMgmtException {
        String methodName = "modifyMgmtPaths";
        if (paths == null || paths.trim().equals("")) {
            throw new ConfigMgmtException(ErrorCode.EMPTY_LIST.getKey(), "No valid paths - cannot modify");
        }
        String[] ips = Convert.commaStringToArray(paths);
        String arrayWWN = Convert.scopeToArrayKey(this.scope);
        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(arrayWWN);
        ar.setIps(ips);
        try {
            ObjectBundleManager.getInstance().modifyRegistration(ar);
        }
        catch (UnknownHostException uhe) {
            Trace.error((Object)this, "modifyMgmtPaths", (Throwable)uhe);
            throw new ConfigMgmtException(uhe);
        }
    }

    private boolean mgmtPathsEqual(String paths) throws ConfigMgmtException {
        String methodName = "mgmtPathsEqual";
        String arrayWWN = Convert.scopeToArrayKey(this.scope);
        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(arrayWWN);
        return ar.getIps().equals(paths);
    }

    private void setName(CommandProcessor command, String name) throws ConfigMgmtException {
        String METHOD_NAME = "setName";
        Trace.methodBegin(this, "setName");
        if (name == null || name.length() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "New name is null or empty.");
        }
        UserAssignedLabel newLabel = new UserAssignedLabel();
        newLabel.setValue(UnicodeTranslator.getBytes((String)name));
        ReturnCode retCode = new ReturnCode();
        command.execute(27, (XDRType)newLabel, (XDRType)retCode, true);
        if (retCode.getValue() != 1) {
            String msg = "setName operation failed: " + retCode.getValue();
            Trace.error((Object)this, "setName", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    private void setTime(String arrayWWN, Properties props, CommandProcessor command) throws ConfigMgmtException {
        String METHOD_NAME = "setTime";
        Trace.methodBegin(this, "setTime");
        if (arrayWWN == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Array WWN is null.");
        }
        if (props == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "New time is null.");
        }
        Scope scope = new Scope();
        scope.setAttribute("array", arrayWWN);
        ManageControllers mgr = new ManageControllers();
        mgr.init(this.cfgctx, scope, null);
        String[] controllers = ObjectBundleManager.getInstance().getControlerReferences(arrayWWN);
        ConfigMgmtException exc = null;
        for (int i = 0; i < controllers.length; ++i) {
            HashMap<String, String> key = new HashMap<String, String>();
            key.put("controllerRef", controllers[i]);
            try {
                Trace.verbose((Object)this, "setTime", "Set time for controller:" + controllers[i]);
                mgr.setTime(command, key, new Long((String)props.get("TIME")));
                continue;
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "setTime", cme);
                if (cme.getExceptionKey() == null || !cme.getExceptionKey().equals(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + 30))) {
                    List ctrls = mgr.getItemList();
                    String ctrlName = null;
                    for (int j = 0; j < ctrls.size() && ctrlName == null; ++j) {
                        Map m = ((CoreManagedObjectInterface)ctrls.get(j)).getKey();
                        if (m == null || m.get("controllerRef") == null || !controllers[i].equals((String)m.get("controllerRef"))) continue;
                        ctrlName = ((CoreManagedObjectInterface)ctrls.get(j)).getName();
                    }
                    String[] p = new String[]{ctrlName};
                    exc = new ConfigMgmtException("error.failed.set.time.controller", p, "Error setting controller time", cme);
                    continue;
                }
                throw cme;
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    private void setFailOverAlertDelay(CommandProcessor command, int delay) throws ConfigMgmtException {
        String METHOD_NAME = "setFailOverAlterDelay";
        Trace.methodBegin(this, "setFailOverAlterDelay");
        ReturnCode retCode = new ReturnCode();
        XDRint xdrDelay = new XDRint();
        xdrDelay.setValue(delay);
        command.execute(127, (XDRType)xdrDelay, (XDRType)retCode, true);
        if (retCode.getValue() != 1) {
            String msg = "setFailOverAlterDelay operation failed: " + retCode.getValue();
            Trace.error((Object)this, "setFailOverAlterDelay", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    private void setMediaScanPeriod(CommandProcessor command, int period) throws ConfigMgmtException {
        String METHOD_NAME = "setMediaScanPeriod";
        Trace.methodBegin(this, "setMediaScanPeriod");
        ReturnCode retCode = new ReturnCode();
        XDRint xdrPeriod = new XDRint();
        xdrPeriod.setValue(period);
        command.execute(47, (XDRType)xdrPeriod, (XDRType)retCode, true);
        if (retCode.getValue() != 1) {
            String msg = "setMediaScanPeriod operation failed: " + retCode.getValue();
            Trace.error((Object)this, "setMediaScanPeriod", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    private void setCacheParams(CommandProcessor command, SACacheParamsUpdateDescriptor saDesc) throws ConfigMgmtException {
        String METHOD_NAME = "setCacheParams";
        Trace.methodBegin(this, "setCacheParams");
        if (saDesc == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "New SACacheParamsUpdateDescriptor is null.");
        }
        ReturnCode retCode = new ReturnCode();
        command.execute(26, (XDRType)saDesc, (XDRType)retCode, true);
        if (retCode.getValue() != 1) {
            String msg = "setCacheParams operation failed: " + retCode.getValue();
            Trace.error((Object)this, "setCacheParams", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    private BigInteger getTotalVolumeCapacity(ObjectBundle bundle) {
        Volume[] ozVols = bundle.getVolume();
        int size = ozVols == null ? 0 : ozVols.length;
        long t = 0L;
        for (int i = 0; i < size; ++i) {
            t += ozVols[i].getCapacity();
        }
        return BigInteger.valueOf(t);
    }

    private BigInteger getTotalDiskCapacity(ObjectBundle bundle) {
        Drive[] ozDisks = bundle.getDrive();
        int size = ozDisks == null ? 0 : ozDisks.length;
        long total = 0L;
        for (int i = 0; i < size; ++i) {
            total += ozDisks[i].getRawCapacity();
        }
        return BigInteger.valueOf(total);
    }

    public static String getArrayName(devmgr.versioned.symbol.StorageArray sa) {
        String name = null;
        if (sa.getSaData().getStorageArrayLabel().getValue() != null) {
            name = UnicodeTranslator.getString((byte[])sa.getSaData().getStorageArrayLabel().getValue());
        }
        if (name == null || name.trim().equals("")) {
            name = "array.no.name";
        }
        return name;
    }

    public static Map getArrayKeyMap(String arrayWWN) {
        HashMap<String, String> key = new HashMap<String, String>(1);
        key.put("array", arrayWWN);
        return key;
    }

    public List getManagementPaths() throws ConfigMgmtException {
        String methodName = "getManagementPaths";
        Trace.methodBegin(this, "getManagementPaths");
        ArrayList<MgmtPath> mp = new ArrayList<MgmtPath>();
        if (this.scope != null) {
            String arrayWWN = Convert.scopeToArrayKey(this.scope);
            Trace.verbose((Object)this, "getManagementPaths", "Search for array registration with wwn:" + arrayWWN);
            ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(arrayWWN);
            if (ar == null) {
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY, "Could not retrieve registration");
            }
            Trace.verbose((Object)this, "getManagementPaths", "Found array with WWN:" + ar.getWwn());
            for (int i = 0; i < ar.getIps().length; ++i) {
                MgmtPath path = new MgmtPath();
                path.setWwn(ar.getWwn());
                path.setIp(ar.getIps()[i]);
                Trace.verbose((Object)this, "getManagementPaths", "Validate IP:" + ar.getIps()[i]);
                try {
                    SYMbolAPIClientV1 sym = ObjectBundleManager.getInstance().validateConnectionToIP(InetAddress.getByName(path.getIp()));
                    if (sym != null) {
                        path.setStatus(0);
                        try {
                            sym.close();
                        }
                        catch (Exception e) {
                            Trace.error((Object)this, "getManagementPaths", e.getMessage());
                        }
                    } else {
                        path.setStatus(-1);
                    }
                }
                catch (UnknownHostException e) {
                    Trace.verbose((Object)this, "getManagementPaths", "Not a valid IP:" + path.getIp());
                    path.setStatus(-1);
                }
                mp.add(path);
            }
        } else {
            Trace.verbose((Object)this, "getManagementPaths", "Scope is null?");
        }
        return mp;
    }

    private void setNumHotSpares(CommandProcessor command, ObjectBundle bundle, int reqHotSpares) throws ConfigMgmtException {
        String METHOD_NAME = "setNumHotSpares";
        if (reqHotSpares < 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Invalid number of hot spares requested: " + reqHotSpares);
        }
        int numHotSpares = this.getNumHotSpares(bundle, 0);
        DriveRefList driveList = this.getDrivesForHotSpares(bundle, reqHotSpares);
        ReturnCode retCode = new ReturnCode();
        if (numHotSpares == reqHotSpares) {
            return;
        }
        if (numHotSpares > reqHotSpares) {
            command.execute(8, (XDRType)driveList, (XDRType)retCode, true);
        } else {
            command.execute(5, (XDRType)driveList, (XDRType)retCode, true);
        }
        if (retCode.getValue() != 1) {
            String msg = "setNumHotSpares operation failed: " + retCode.getValue();
            Trace.error((Object)this, "setNumHotSpares", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    private DriveRefList getDrivesForHotSpares(ObjectBundle bundle, int numHotSpares) throws ConfigMgmtException {
        Object obj;
        Iterator iter;
        String METHOD_NAME = "getDrivesForHotSpares";
        DriveRefList hotSpareList = new DriveRefList();
        ArrayList driveRefs = new ArrayList();
        HashMap<String, ArrayList<String>> trayDriveListMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> traySpareListMap = new HashMap<String, ArrayList<String>>();
        int maxDrives = 0;
        if (numHotSpares < 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Invalid number of hot spares requested: " + numHotSpares);
        }
        Drive[] ozDrives = bundle.getDrive();
        Tray[] ozTrays = bundle.getTray();
        for (int i = 0; i < ozTrays.length; ++i) {
            Tray tray = ozTrays[i];
            maxDrives = tray.getNumDriveSlots();
            trayDriveListMap.put(Convert.bytesToString(tray.getTrayRef().getRefToken()), null);
            traySpareListMap.put(Convert.bytesToString(tray.getTrayRef().getRefToken()), null);
        }
        int candidateSpares = 0;
        int currentSpares = 0;
        for (int i = 0; i < ozDrives.length; ++i) {
            Drive currDrive = ozDrives[i];
            Location loc = currDrive.getPhysicalLocation();
            String trayRef = Convert.bytesToString(loc.getTrayRef().getRefToken());
            if (!currDrive.getHotSpare() && (currDrive.getOffline() || !currDrive.getAvailable() || currDrive.getStatus().getValue() != 1)) continue;
            if (currDrive.getHotSpare()) {
                ArrayList<String> traysSpareList = (ArrayList<String>)traySpareListMap.get(trayRef);
                if (traysSpareList == null) {
                    traysSpareList = new ArrayList<String>();
                }
                traysSpareList.add(Convert.bytesToString(currDrive.getDriveRef().getRefToken()));
                traySpareListMap.put(trayRef, traysSpareList);
                ++currentSpares;
                continue;
            }
            ArrayList<String> traysDriveList = (ArrayList<String>)trayDriveListMap.get(trayRef);
            if (traysDriveList == null) {
                traysDriveList = new ArrayList<String>();
            }
            traysDriveList.add(Convert.bytesToString(currDrive.getDriveRef().getRefToken()));
            trayDriveListMap.put(trayRef, traysDriveList);
            ++candidateSpares;
        }
        int maxHotSpares = bundle.getSa().getFeatureParameters().getMaxHotSpares();
        Trace.verbose((Object)this, "getDrivesForHotSpares", "Maximum number of hot spares is: " + maxHotSpares);
        if (numHotSpares > maxHotSpares) {
            throw new ConfigMgmtException("error.array.more.than.max.hotSpares", "Maximum number of hot spares(" + maxHotSpares + ") is less than requested number(" + numHotSpares + ").");
        }
        int round = 0;
        if (numHotSpares > currentSpares) {
            if (candidateSpares + currentSpares < numHotSpares) {
                throw new ConfigMgmtException("error.array.too.many.hotSpares", "Number of candidate hot spares(" + candidateSpares + ") is less than requested number(" + numHotSpares + ").");
            }
            int numSparesToCreate = numHotSpares - currentSpares;
            while (numSparesToCreate > 0) {
                iter = trayDriveListMap.keySet().iterator();
                while (iter.hasNext() && numSparesToCreate > 0) {
                    obj = iter.next();
                    List driveListForTray = (List)trayDriveListMap.get(obj);
                    List spareListForTray = (List)traySpareListMap.get(obj);
                    int traySpares = 0;
                    if (spareListForTray != null) {
                        traySpares = spareListForTray.size();
                    }
                    if (driveListForTray == null || traySpares >= round || driveListForTray.size() <= 0) continue;
                    Trace.verbose((Object)this, "getDrivesForHotSpares", "Add as spare: " + driveListForTray.get(0) + " from tray: " + obj + " as spare");
                    driveRefs.add(driveListForTray.get(0));
                    driveListForTray.remove(0);
                    --numSparesToCreate;
                }
                ++round;
            }
        } else if (numHotSpares < currentSpares) {
            round = maxDrives;
            int numSparesToRemove = currentSpares - numHotSpares;
            while (numSparesToRemove > 0) {
                iter = traySpareListMap.keySet().iterator();
                while (iter.hasNext() && numSparesToRemove > 0) {
                    obj = iter.next();
                    List spareListForTray = (List)traySpareListMap.get(obj);
                    if (spareListForTray == null || spareListForTray.size() < round) {
                        --round;
                        continue;
                    }
                    if (spareListForTray.size() <= 0) continue;
                    Trace.verbose((Object)this, "getDrivesForHotSpares", "Remove from spares: " + spareListForTray.get(0) + " from tray: " + obj + " as spare");
                    driveRefs.add(spareListForTray.get(0));
                    spareListForTray.remove(0);
                    --numSparesToRemove;
                }
            }
            --round;
        }
        DriveRef[] refs = new DriveRef[driveRefs.size()];
        int index = 0;
        Iterator iter2 = driveRefs.iterator();
        while (iter2.hasNext()) {
            String driveRefStr = (String)iter2.next();
            DriveRef dr = new DriveRef();
            dr.setRefToken(Convert.stringToBytes(driveRefStr));
            refs[index++] = dr;
        }
        hotSpareList.setDriveRef(refs);
        return hotSpareList;
    }

    private int getNumHotSpares(ObjectBundle bundle, int DriveType2) throws ConfigMgmtException {
        Drive[] ozDrives = bundle.getDrive();
        int numHotSpares = 0;
        for (int i = 0; i < ozDrives.length; ++i) {
            Drive currDrive = ozDrives[i];
            if (!currDrive.getHotSpare() || DriveType2 != 0 && currDrive.getPhyDriveType().getValue() != DriveType2) continue;
            ++numHotSpares;
        }
        return numHotSpares;
    }

    protected void setArrayPassword(CommandProcessor command, String arrayWWN, String oldPassword, String newPassword, boolean localOnly) throws ConfigMgmtException {
        String METHOD_NAME = "setArrayPassword";
        Object errorDesc = null;
        if (arrayWWN == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Array WWN is null.");
        }
        if (oldPassword == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null old password given to ManageArrays.setPassword().");
        }
        if (newPassword == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null new password given to ManageArrays.setPassword().");
        }
        ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration(arrayWWN);
        try {
            ObjectBundleManager man = ObjectBundleManager.getInstance();
            if (!localOnly) {
                if (ar == null || !oldPassword.equals(ar.getPassword())) {
                    throw new ConfigMgmtException("error.old.password.different.from.registered", "");
                }
                EncryptedPassword encryptedPass = this.getEncryptedPassword(oldPassword, newPassword);
                ReturnCode retCode = new ReturnCode();
                command.execute(56, (XDRType)encryptedPass, (XDRType)retCode, true);
                if (retCode.getValue() != 1) {
                    String msg = "setArrayPassword operation failed: " + retCode.getValue();
                    Trace.error((Object)this, "setArrayPassword", msg);
                    throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
                }
            }
            ar.setPassword(newPassword);
            man.modifyRegistration(ar);
        }
        catch (IOException ex) {
            Trace.error((Object)this, "setArrayPassword", (Throwable)ex);
            throw new ConfigMgmtException("error.systemError", "setArrayPassword", ex);
        }
    }

    private void setDefaultHostPortType(CommandProcessor command, String newHostPortType) throws ConfigMgmtException, RPCError, IOException, SEItemNotFoundException {
        String methodName = "setDefaultHostPortType";
        HostPortTypeUpdateDescriptor hptud = new HostPortTypeUpdateDescriptor();
        HostPortRef hpr = new HostPortRef();
        byte[] defaultHostPortRef = new byte[20];
        for (int i = 0; i < defaultHostPortRef.length; ++i) {
            defaultHostPortRef[i] = 0;
        }
        hpr.setRefToken(defaultHostPortRef);
        hptud.setHostPortRef(hpr);
        hptud.setHostPortTypeIndex(Integer.parseInt(newHostPortType));
        ReturnCode rc = new ReturnCode();
        command.execute(80, (XDRType)hptud, (XDRType)rc, true);
        if (rc.getValue() != 1) {
            Trace.error((Object)this, "setDefaultHostPortType", "Error moving host port to host. Error code:" + rc.getValue());
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "Modify host port failed");
        }
    }

    public boolean isRegisteredPasswordValid(Object objKey) throws ConfigMgmtException {
        String methodName = "isRegisteredPasswordValid";
        Trace.methodBegin(this, "isRegisteredPasswordValid");
        boolean isValid = true;
        if (objKey == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object key is null.");
        }
        Map key = null;
        key = objKey instanceof Map ? (Map)objKey : Convert.keyAsStringToMap((String)objKey);
        String arrayWwn = (String)key.get("array");
        try {
            CommandProcessor command = new CommandProcessor(arrayWwn);
            ReturnCodeWithRef rc = new ReturnCodeWithRef();
            XDRvoid v = new XDRvoid();
            Trace.verbose((Object)this, "isRegisteredPasswordValid", "INITIATE VERIFY PASSWORD");
            command.execute(66, (XDRType)v, (XDRType)rc, true);
            Trace.verbose((Object)this, "isRegisteredPasswordValid", "VERIFY PASSWORD RETURNED:" + rc.getReturnCode().getValue());
            if (rc.getReturnCode().getValue() == 30) {
                isValid = false;
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)this, "isRegisteredPasswordValid", "Password is vaaalid - message received:" + e.getMessage());
        }
        return isValid;
    }

    private List analyzeArrayList(List arrayList) {
        String methodName = "analyzeArrayList";
        Trace.methodBegin(this, "analyzeArrayList");
        ArrayList<ArrayRegDetail> analyzedList = new ArrayList<ArrayRegDetail>();
        if (arrayList != null) {
            ArrayList<ThreadAnalyzer> threadList = new ArrayList<ThreadAnalyzer>();
            ArrayRegDetail ar = null;
            int i = 0;
            ThreadAnalyzer ta = null;
            for (i = 0; i < arrayList.size(); ++i) {
                ar = new ArrayRegDetail((ArrayReg)arrayList.get(i));
                Trace.verbose((Object)this, "analyzeArrayList", "Registration Entry : " + ar.toString());
                ta = new ThreadAnalyzer(ar);
                ta.setDaemon(true);
                ta.start();
                threadList.add(ta);
            }
            for (i = 0; i < threadList.size(); ++i) {
                try {
                    ta = (ThreadAnalyzer)threadList.get(i);
                    ta.join();
                    Trace.verbose((Object)this, "analyzeArrayList", "Registration Entry : " + ar.toString());
                    analyzedList.add(ta.arrayReg);
                    continue;
                }
                catch (InterruptedException ie) {
                    Trace.error((Object)this, "analyzeArrayList", "Error analyzing array  - thread interrupted");
                    Trace.error((Object)this, "analyzeArrayList", "registration data:" + ar);
                    Trace.error((Object)this, "analyzeArrayList", (Throwable)ie);
                    String[] errParams = new String[]{new String(ta.arrayReg.getResourceName() + " (" + ta.arrayReg.getDirectIps()[0] + ") ")};
                    ta.arrayReg.setErrDescriptor(new ErrorDescriptor(new ErrorCode("error.array.analyze.fail", 1537, ErrorCodeType.WARNING), errParams, "Array analyzing thread interrupted"));
                    analyzedList.add(ta.arrayReg);
                }
            }
        }
        return analyzedList;
    }

    public MethodCallStatus validate(List list) throws ConfigMgmtException {
        List convertedList = Convert.listOfStringKeysToMap(list);
        int size = convertedList == null ? 0 : convertedList.size();
        int i = 0;
        ArrayList<ArrayReg> arrayRegList = new ArrayList<ArrayReg>(size);
        MethodCallStatus mcs = new MethodCallStatus();
        for (i = 0; i < size; ++i) {
            ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration((String)((Map)convertedList.get(i)).get("array"));
            arrayRegList.add(ar);
        }
        List analyzeList = this.analyzeArrayList(arrayRegList);
        size = analyzeList == null ? 0 : convertedList.size();
        for (i = 0; i < size; ++i) {
            mcs.addErrorDescriptor(((ArrayRegDetail)analyzeList.get(i)).getErrDescriptor());
        }
        return mcs;
    }

    public MethodCallStatus upgrade(List list) throws ConfigMgmtException {
        List convertedList = Convert.listOfStringKeysToMap(list);
        int size = convertedList == null ? 0 : convertedList.size();
        int i = 0;
        ArrayList<ArrayReg> arrayRegList = new ArrayList<ArrayReg>(size);
        MethodCallStatus mcs = new MethodCallStatus();
        for (i = 0; i < size; ++i) {
            ArrayReg ar = ArrayRegManager.getInstance().getArrayRegistration((String)((Map)convertedList.get(i)).get("array"));
            arrayRegList.add(ar);
        }
        List analyzeList = this.upgradeArrayList(arrayRegList);
        size = analyzeList == null ? 0 : convertedList.size();
        for (i = 0; i < size; ++i) {
            mcs.addErrorDescriptor(((ArrayRegDetail)analyzeList.get(i)).getErrDescriptor());
        }
        return mcs;
    }

    private List upgradeArrayList(List arrayList) {
        String methodName = "upgradeArrayList";
        Trace.methodBegin(this, "upgradeArrayList");
        ArrayList<ArrayRegDetail> updatedList = new ArrayList<ArrayRegDetail>();
        if (arrayList != null) {
            ArrayList<ArrayUpgradeThread> threadList = new ArrayList<ArrayUpgradeThread>();
            ArrayRegDetail ar = null;
            int i = 0;
            ArrayUpgradeThread aut = null;
            for (i = 0; i < arrayList.size(); ++i) {
                ar = new ArrayRegDetail((ArrayReg)arrayList.get(i));
                Trace.verbose((Object)this, "upgradeArrayList", "Registration Entry : " + ar.toString());
                aut = new ArrayUpgradeThread(ar);
                aut.setDaemon(true);
                aut.start();
                threadList.add(aut);
            }
            for (i = 0; i < threadList.size(); ++i) {
                try {
                    aut = (ArrayUpgradeThread)threadList.get(i);
                    aut.join();
                    Trace.verbose((Object)this, "upgradeArrayList", "Registration Entry : " + ar.toString());
                    updatedList.add(aut.arrayReg);
                    continue;
                }
                catch (InterruptedException ie) {
                    Trace.error((Object)this, "upgradeArrayList", "Error upgrading array  - thread interrupted");
                    Trace.error((Object)this, "upgradeArrayList", "registration data:" + ar);
                    Trace.error((Object)this, "upgradeArrayList", (Throwable)ie);
                    String[] errParams = new String[]{new String(aut.arrayReg.getResourceName() + " (" + aut.arrayReg.getDirectIps()[0] + ") ")};
                    aut.arrayReg.setErrDescriptor(new ErrorDescriptor(new ErrorCode("error.array.upgrade.fail", 1538, ErrorCodeType.WARNING), errParams, "Array upgrading thread interrupted"));
                    updatedList.add(aut.arrayReg);
                }
            }
        }
        return updatedList;
    }

    class ArrayUpgradeThread
    extends Thread {
        ArrayRegDetail arrayReg = null;

        ArrayUpgradeThread(ArrayRegDetail ard) {
            this.arrayReg = ard;
        }

        public void run() {
            String[] arrayParams = null;
            try {
                CSMArray csmArray = CSMProxy.getCSMArray(this.arrayReg, null, null);
                csmArray.update();
                String[] components = CSMProxy.getUpgradeInfo(csmArray);
                int len = components.length;
                arrayParams = new String[len + 1];
                for (int i = 0; i < len; ++i) {
                    arrayParams[i] = components[i];
                }
                if (components.length > 0) {
                    this.arrayReg.setUpgradeInfo(components);
                }
                arrayParams[len] = this.arrayReg.getResourceName() != null ? this.arrayReg.getResourceName() + " (" + this.arrayReg.getDirectIps()[0] + ") " : this.arrayReg.getDirectIps()[0];
                if (len > 0) {
                    String msg = "error.array.components.upgraded." + len;
                    this.arrayReg.setErrDescriptor(new ErrorDescriptor(new ErrorCode(msg, 1524 + len, ErrorCodeType.INFO), arrayParams, "Firmware upgrade required for the array"));
                } else {
                    this.arrayReg.setErrDescriptor(new ErrorDescriptor(ErrorCode.ARRAY_COMPONENTS_NO_UPGRADE, arrayParams, "No Firmware upgrade required for the array"));
                }
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "run()", "Error implementing csmproxy for array");
                Trace.error((Object)this, "run()", "registration data:" + this.arrayReg);
                Trace.error((Object)this, "run()", cme);
                this.arrayReg.setErrDescriptor(new ErrorDescriptor(new ErrorCode("error.array.upgrade.fail", 1538, ErrorCodeType.WARNING), arrayParams, "Exception in array upgrade"));
            }
            catch (CSMArrayException cae) {
                Trace.error((Object)this, "run()", "Error updating the array");
                Trace.error((Object)this, "run()", "registration data:" + this.arrayReg);
                Trace.error((Object)this, "run()", (Throwable)cae);
                this.arrayReg.setErrDescriptor(new ErrorDescriptor(new ErrorCode("error.array.upgrade.fail", 1538, ErrorCodeType.WARNING), arrayParams, "Exception in array upgrade"));
            }
        }
    }

    class ThreadAnalyzer
    extends Thread {
        ArrayRegDetail arrayReg = null;

        ThreadAnalyzer(ArrayRegDetail ard) {
            this.arrayReg = ard;
        }

        public void run() {
            String[] arrayParams = null;
            try {
                CSMArray csmArray = CSMProxy.getCSMArray(this.arrayReg, null, null);
                String[] components = CSMProxy.analyzeArray(csmArray);
                int len = components.length;
                arrayParams = new String[len + 1];
                for (int i = 0; i < len; ++i) {
                    arrayParams[i] = components[i];
                }
                if (components.length > 0) {
                    this.arrayReg.setUpgradeInfo(components);
                }
                arrayParams[len] = this.arrayReg.getResourceName() != null ? this.arrayReg.getResourceName() + " (" + this.arrayReg.getDirectIps()[0] + ") " : this.arrayReg.getDirectIps()[0];
                if (len > 0) {
                    String msg = "error.array.components.need.upgrade." + len;
                    this.arrayReg.setErrDescriptor(new ErrorDescriptor(new ErrorCode(msg, 1524 + len, ErrorCodeType.WARNING), arrayParams, "Firmware upgrade required for the array"));
                } else {
                    this.arrayReg.setErrDescriptor(new ErrorDescriptor(ErrorCode.ARRAY_COMPONENTS_NO_UPGRADE, arrayParams, "No Firmware upgrade required for the array"));
                }
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "run()", "Error analyzing the array");
                Trace.error((Object)this, "run()", "registration data:" + this.arrayReg);
                Trace.error((Object)this, "run()", cme);
                this.arrayReg.setErrDescriptor(new ErrorDescriptor(new ErrorCode("error.array.analyze.fail", 1537, ErrorCodeType.WARNING), arrayParams, "Exception in array analyze"));
            }
        }
    }

    public static interface SearchType {
        public static final String REPLICATION_SET_IS_ACTIVATED = "replicationSetIsActivated";
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String ARRAY_NAME = "array_name";
    }

    public static interface ModifyProperties {
        public static final String ARRAY_DEFAULT_HOST_TYPE = "defaultHostType";
        public static final String ARRAY_MEDIA_SCAN = "mediaScanPeriod";
        public static final String ARRAY_FAIL_OVER_ALERT_DELAY = "failOverAlertDelay";
        public static final String ARRAY_CACHE_THRESHOLD = "cacheFlushThreshold";
        public static final String ARRAY_CACHE_AMOUNT = "cacheFlushAmount";
        public static final String ARRAY_CACHE_BLOCK_SIZE = "cacheBlockSize";
        public static final String ARRAY_NUM_HOT_SPARES = "numHotSpares";
        public static final String ARRAY_OLD_PASSWORD = "oldPassword";
        public static final String ARRAY_NEW_PASSWORD = "newPassword";
        public static final String ARRAY_NEW_LOCAL_PASSWORD = "newLocalPassword";
        public static final String ARRAY_MGMT_PATH = "arrayMgmtPath";
        public static final String ARRAY_NAME = "name";
        public static final String ARRAY_TIME = "TIME";
        public static final String RESET_ARRAY_CONFIGURATION = "clearSAConfiguration";
        public static final String REDISTRIBUTE_VOLUMES = "redistributeVolumes";
    }
}

