/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ControllerPerfCounterData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfErrorCode;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VolPerfCounterData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VolPerfData;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

class ControllerPerfData
extends PerfData {
    private boolean blockSizeStatsValid = true;
    protected static final double LAZILY_PROCESS = -2.0;
    protected ControllerPerfCounterData currentPerfData = null;
    protected Hashtable hashtable;
    protected boolean volumeDeletedAfterStart = false;
    private boolean volumeDeletedDuringLastPoll = false;
    protected boolean volumeCreatedAfterStart = false;
    protected boolean controllerResetAfterStart = false;
    protected long bootTime = 0L;

    public ControllerPerfData(String objectName, Map keyMap, Hashtable hashtable) {
        super(objectName, keyMap);
        this.hashtable = hashtable;
    }

    public Double getRunAverageTotalIOPs() {
        if (this.averageTotalIOPs == -2.0) {
            this.computeRunAverageStats();
        }
        return super.getRunAverageTotalIOPs();
    }

    public Double getRunAverageReadsPerSec() {
        if (this.averageBytesReadPerSec == -2.0) {
            this.computeRunAverageStats();
        }
        return super.getRunAverageReadsPerSec();
    }

    public Double getRunAverageWritesPerSec() {
        if (this.averageBytesWrittenPerSec == -2.0) {
            this.computeRunAverageStats();
        }
        return super.getRunAverageWritesPerSec();
    }

    public Double getCacheReadHitPercentage() {
        if (this.cacheReadHitPercentage == -2.0) {
            if (this.currentPerfData.totalCacheReadChecks == 0L || this.currentPerfData.totalCacheReadCheckHits == 0L) {
                this.setCacheReadHitPercentage(0.0);
            } else {
                this.setCacheReadHitPercentage((double)this.currentPerfData.totalCacheReadCheckHits / (double)this.currentPerfData.totalCacheReadChecks * 100.0);
            }
        }
        return super.getCacheReadHitPercentage();
    }

    public Double getReadPercentage() {
        if (this.readPercentage == -2.0) {
            if (this.currentPerfData.totalReadRequests == 0.0) {
                this.setReadPercentage(0.0);
            } else {
                this.setReadPercentage(this.currentPerfData.totalReadRequests / this.currentPerfData.totalIOs * 100.0);
            }
        }
        return super.getReadPercentage();
    }

    public Date getStorageStatsLastPollTime() {
        if (this.currentPerfData == null) {
            return null;
        }
        return new Date(this.currentPerfData.time);
    }

    public Double getWritePercentage() {
        if (this.writePercentage == -2.0) {
            if (this.currentPerfData.totalWriteRequests == 0.0) {
                this.setWritePercentage(0.0);
            } else {
                this.setWritePercentage(this.currentPerfData.totalWriteRequests / this.currentPerfData.totalIOs * 100.0);
            }
        }
        return super.getWritePercentage();
    }

    public List getPerfStatsErrorCodes() {
        Double data = this.getRunAverageTotalIOPs();
        return super.getPerfStatsErrorCodes();
    }

    public void setVolumeDeletedAfterStart() {
        this.volumeDeletedAfterStart = true;
        this.volumeDeletedDuringLastPoll = true;
    }

    public boolean volumeDeletedAfterStart() {
        return this.volumeDeletedAfterStart;
    }

    public void setVolumeCreatedAfterStart() {
        this.volumeCreatedAfterStart = true;
    }

    public boolean volumeCreatedAfterStart() {
        return this.volumeCreatedAfterStart;
    }

    public boolean controllerResetAfterStart() {
        return this.controllerResetAfterStart;
    }

    public void setControllerResetAfterStart() {
        this.controllerResetAfterStart = true;
        this.currentPerfData = new ControllerPerfCounterData();
        this.currentPerfData.setDataValid(false);
        this.currentPerfData.addErrorCode(PerfErrorCode.CONTROLLER_RESET);
        this.markDataAsNotAvailable();
        this.addErrorCode(PerfErrorCode.CONTROLLER_RESET);
    }

    public long getBootTime() {
        return this.bootTime;
    }

    public void setBootTime(long bootTime) {
        this.bootTime = bootTime;
    }

    protected void markInvalidDueToBlockSize() {
        this.blockSizeStatsValid = false;
        this.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        this.setRunAverageReadsPerSec(-1.0);
        this.setRunAverageWritesPerSec(-1.0);
        this.setAverageReadSize(-1.0);
        this.setAverageWriteSize(-1.0);
        this.setReadsPerSec(-1.0);
        this.setWritesPerSec(-1.0);
    }

    protected void computeRunAverageStats() {
        VolPerfData[] volPerfData = this.hashtable.values().toArray(new VolPerfData[this.hashtable.size()]);
        int objectHashCode = this.getName().hashCode();
        double runAverageTotalIOPs = 0.0;
        double runAverageReadsPerSec = 0.0;
        double runAverageWritesPerSec = 0.0;
        boolean runAverageStatsAvailable = true;
        for (int i = 0; i < volPerfData.length && runAverageStatsAvailable; ++i) {
            VolPerfCounterData volData = volPerfData[i].getFirstCurrentDiffData();
            if (volData.ref.hashCode() != objectHashCode) continue;
            if (!volData.isDataValid()) {
                runAverageStatsAvailable = false;
                this.addErrorCodes(volData.getErrorCodes());
                continue;
            }
            double value = volPerfData[i].getRunAverageTotalIOPs();
            if (value == -1.0) {
                runAverageStatsAvailable = false;
                this.addErrorCodes(volPerfData[i].getPerfStatsErrorCodes());
                continue;
            }
            runAverageTotalIOPs += volPerfData[i].getRunAverageTotalIOPs().doubleValue();
            runAverageReadsPerSec += volPerfData[i].getRunAverageReadsPerSec().doubleValue();
            runAverageWritesPerSec += volPerfData[i].getRunAverageWritesPerSec().doubleValue();
        }
        if (runAverageStatsAvailable) {
            this.setRunAverageTotalIOPs(runAverageTotalIOPs);
            this.setRunAverageReadsPerSec(runAverageReadsPerSec);
            this.setRunAverageWritesPerSec(runAverageWritesPerSec);
        } else {
            this.setRunAverageReadsPerSec(-1.0);
            this.setRunAverageWritesPerSec(-1.0);
            this.setRunAverageTotalIOPs(-1.0);
        }
    }

    ControllerPerfCounterData getPerfData() {
        return this.currentPerfData;
    }

    void setPerfData(Object[] perfData) {
        String METHOD_NAME = "setPerfData";
        VolPerfData[] volData = (VolPerfData[])perfData;
        ControllerPerfCounterData data = new ControllerPerfCounterData();
        VolPerfCounterData diff = null;
        int processed = 0;
        this.clearAllErrors();
        if (this.volumeDeletedDuringLastPoll) {
            this.volumeDeletedDuringLastPoll = false;
            this.addErrorCode(PerfErrorCode.VOLUME_DELETED);
            data.setDataValid(false);
        }
        for (int i = 0; i < volData.length && data.isDataValid(); ++i) {
            diff = volData[i].getDiffData();
            if (diff != null) {
                ++processed;
                if (!diff.isDataValid()) {
                    data.setDataValid(false);
                    data.addErrorCodes(diff.getErrorCodes());
                    continue;
                }
                if (processed == 1) {
                    data.time = diff.time;
                }
                data.totalIOs += (double)diff.totalRequestsServiced;
                data.totalReadRequests += (double)diff.totalReadRequests;
                data.totalWriteRequests += (double)diff.totalWriteRequests;
                data.totalCacheReadChecks += diff.totalCacheReadChecks;
                data.totalCacheReadCheckHits += diff.totalCacheReadCheckHits;
                data.totalIOPs += volData[i].getTotalIOPs().doubleValue();
                if (data.isBlockSizeValid() && diff.isBlockSizeValid()) {
                    data.totalBytesReadPerSec += volData[i].getReadsPerSec().doubleValue();
                    data.totalBytesWrittenPerSec += volData[i].getWritesPerSec().doubleValue();
                    data.totalAverageReadSize += volData[i].getAverageReadSize().doubleValue();
                    data.totalAverageWriteSize += volData[i].getAverageWriteSize().doubleValue();
                    continue;
                }
                data.setBlockSizeValid(false);
                continue;
            }
            VolPerfCounterData currentVolPerfData = volData[i].getPerfData();
            if (currentVolPerfData == null) {
                Trace.verbose((Object)this, "setPerfData", "Didn't get any data for volume " + volData[i].getName());
            } else {
                if (!currentVolPerfData.isDataValid()) {
                    data.addErrorCodes(currentVolPerfData.getErrorCodes());
                    data.setDataValid(false);
                }
                if (processed == 1) {
                    data.time = currentVolPerfData.time;
                }
                ++processed;
            }
            if (!volData[i].volumeCreatedAfterStart()) continue;
            this.setVolumeCreatedAfterStart();
            if (volData[i].firstPerfData != currentVolPerfData) continue;
            data.setDataValid(false);
            data.addErrorCode(PerfErrorCode.NEW_VOL_FOUND);
        }
        if (processed > 0 && processed != volData.length && data.isDataValid()) {
            data.setDataValid(false);
            Trace.error((Object)this, "setPerfData", "Didn't process all the volume stats for " + this.getKeyAsString() + " processed=" + processed + " volData.length=" + volData.length);
            data.addErrorCode(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION);
        }
        if (data.isDataValid()) {
            this.setCacheReadHitPercentage(-2.0);
            this.setReadPercentage(-2.0);
            this.setWritePercentage(-2.0);
            if (this.volumeCreatedAfterStart() || this.volumeDeletedAfterStart()) {
                if (this.volumeCreatedAfterStart()) {
                    data.addErrorCode(PerfErrorCode.NEW_VOL_FOUND);
                }
                if (this.volumeDeletedAfterStart()) {
                    data.addErrorCode(PerfErrorCode.VOLUME_DELETED);
                }
                this.setRunAverageReadsPerSec(-1.0);
                this.setRunAverageTotalIOPs(-1.0);
                this.setRunAverageWritesPerSec(-1.0);
            } else {
                this.setRunAverageReadsPerSec(-2.0);
                this.setRunAverageTotalIOPs(-2.0);
                this.setRunAverageWritesPerSec(-2.0);
            }
            this.setTotalIOPs(data.totalIOPs);
            if (data.isBlockSizeValid()) {
                this.setAverageReadSize(data.totalAverageReadSize);
                this.setAverageWriteSize(data.totalAverageWriteSize);
                this.setReadsPerSec(data.totalBytesReadPerSec);
                this.setWritesPerSec(data.totalBytesWrittenPerSec);
            } else {
                this.markInvalidDueToBlockSize();
            }
        } else {
            this.markDataAsNotAvailable();
        }
        this.currentPerfData = data;
        this.addErrorCodes(data.getErrorCodes());
    }
}

