/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ArrayImportExport;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageArrays;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.HashMap;

public class ArrayImportManager {
    private static ArrayImportManager _manager = null;
    private HashMap _threadMap = new HashMap();
    private final int TF_PRIORITY_HIGHEST = 0;
    private final int TF_PRIORITY_HIGH = 1;
    private final int TF_PRIORITY_MEDIUM = 2;
    private final int TF_PRIORITY_LOW = 3;
    private final int TF_PRIORITY_LOWEST = 4;

    public static synchronized ArrayImportManager getInstance() {
        if (_manager == null) {
            _manager = new ArrayImportManager();
        }
        return _manager;
    }

    private ArrayImportManager() {
    }

    public synchronized MethodCallStatus importConfigToArray(String arrayWwn, ManageArrays arrayMgr, ConfigContext cc, StringBuffer config, boolean checkOnly) throws UnsupportedOperationException, ConfigMgmtException {
        String METHOD_NAME = "importConfigToArray";
        Trace.methodBegin(this, "importConfigToArray");
        MethodCallStatus mcs = new MethodCallStatus();
        ImportThread thread = (ImportThread)this._threadMap.get(arrayWwn);
        if (thread != null) {
            if (thread.isAlive()) {
                this.addError(mcs, null, "import already running", ErrorCode.ERROR_IMPORT_ALREADY_RUNNING);
                return mcs;
            }
            this._threadMap.remove(arrayWwn);
        }
        thread = new ImportThread(arrayWwn, arrayMgr, cc, config, checkOnly);
        boolean valid = thread.initAndValidateConfig(mcs);
        if (checkOnly || !valid) {
            return mcs;
        }
        this._threadMap.put(arrayWwn, thread);
        thread.start();
        this.addError(mcs, null, "Import Job started", ErrorCode.IMPORT_STARTED);
        return mcs;
    }

    private void addError(MethodCallStatus mcs, String object, String msg, ErrorCode error) {
        ErrorDescriptor ed = new ErrorDescriptor(error);
        String[] p = new String[]{object};
        ed.setI18nParams(p);
        ed.setMsg(msg);
        mcs.addErrorDescriptor(ed);
    }

    public synchronized boolean isImporting(String arrayWwn) {
        ImportThread thread = (ImportThread)this._threadMap.get(arrayWwn);
        if (thread != null) {
            if (thread.isAlive()) {
                return true;
            }
            this._threadMap.remove(arrayWwn);
        }
        return false;
    }

    public synchronized int getPercentComplete(String arrayWwn) {
        ImportThread thread = (ImportThread)this._threadMap.get(arrayWwn);
        if (thread != null) {
            if (thread.isAlive()) {
                return thread.getPercentComplete();
            }
            this._threadMap.remove(arrayWwn);
            return 100;
        }
        return 100;
    }

    public synchronized boolean killImport(String arrayWwn) {
        ImportThread thread = (ImportThread)this._threadMap.get(arrayWwn);
        if (thread != null && thread.isAlive()) {
            Trace.verbose((Object)this, "killImport", "Killing import " + thread);
            thread.setStop();
            this._threadMap.remove(arrayWwn);
            return true;
        }
        return false;
    }

    public synchronized void setPriority(String arrayWwn, String priority) {
        Trace.verbose((Object)this, "setPriority", priority);
        ImportThread thread = (ImportThread)this._threadMap.get(arrayWwn);
        if (thread != null && thread.isAlive()) {
            int tfPriority = Integer.parseInt(priority);
            int threadPriority = 5;
            switch (tfPriority) {
                case 4: {
                    threadPriority = 1;
                    break;
                }
                case 3: {
                    threadPriority = 3;
                    break;
                }
                case 1: {
                    threadPriority = 7;
                    break;
                }
                case 0: {
                    threadPriority = 10;
                }
            }
            thread.setPriority(threadPriority);
        }
    }

    public synchronized int getPriority(String arrayWwn) {
        ImportThread thread = (ImportThread)this._threadMap.get(arrayWwn);
        if (thread != null) {
            if (thread.isAlive()) {
                int priority = thread.getPriority();
                switch (priority) {
                    case 5: {
                        return 2;
                    }
                    case 10: {
                        return 0;
                    }
                    case 1: {
                        return 4;
                    }
                }
                if (priority < 10 && priority > 5) {
                    return 1;
                }
                return 3;
            }
            this._threadMap.remove(arrayWwn);
            return -1;
        }
        return -1;
    }

    private class ImportThread
    extends Thread {
        private ArrayImportExport _aie = null;
        private String _wwn = null;
        private StringBuffer _xml = null;
        private boolean _checkOnly = true;

        public ImportThread(String arrayWwn, ManageArrays arrayMgr, ConfigContext cc, StringBuffer config, boolean checkOnly) throws ConfigMgmtException {
            this._wwn = arrayWwn;
            this._checkOnly = checkOnly;
            this._xml = config;
            this._aie = new ArrayImportExport(arrayWwn, arrayMgr, cc);
        }

        public int getPercentComplete() {
            if (this._aie == null) {
                return 100;
            }
            return this._aie.getPercentComplete();
        }

        public boolean initAndValidateConfig(MethodCallStatus mcs) throws ConfigMgmtException {
            if (this._aie == null) {
                return false;
            }
            boolean rc = this._aie.initAndValidateConfig(this._wwn, this._xml, mcs);
            if (rc && !this._checkOnly) {
                try {
                    rc = this._aie.resetArray(this._wwn, mcs);
                }
                catch (Exception e) {
                    rc = false;
                }
            }
            return rc;
        }

        public void setStop() {
            if (this._aie != null) {
                this._aie.setStop();
            }
        }

        public void run() {
            MethodCallStatus mcs = new MethodCallStatus();
            String arrayName = this._aie.getOriginalArrayName();
            try {
                LogAPI.staticLog((String)"ARRAY_IMPORT_START", (String[])new String[]{arrayName}, (String[])new String[0]);
                this._aie.doImport(this._wwn, this._xml, mcs);
                LogAPI.staticLog((String)"ARRAY_IMPORT_SUCCESS", (String[])new String[]{arrayName}, (String[])new String[0]);
            }
            catch (Exception e) {
                Trace.verbose((Object)this, "run", (Throwable)e);
                LogAPI.staticLog((String)"ARRAY_IMPORT_FAILURE", (String[])new String[]{arrayName}, (String[])new String[0]);
            }
            this._aie = null;
        }
    }
}

