/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.Host;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.HostGroup;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.HostPort;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.ManageHostGroups;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.ManageHostPorts;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.ManageHosts;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.ManageMappings;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.Mapping;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageArrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageArrays;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManagePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManagePremiumFeatures;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Pool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PremiumFeatures;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Volume;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.VolumeGroup;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ArrayImportExport
implements Constants.StorageSize,
Constants.T4 {
    private ConfigContext _cc = null;
    private ManageArrays _arrayMgr = null;
    private ManagePremiumFeatures _premMgr = null;
    private ManageMappings _mapMgr = null;
    private ManageVolumes _volMgr = null;
    private ManageHostGroups _hostGroupMgr = null;
    private ManageHosts _hostMgr = null;
    private ManageHostPorts _hostPortMgr = null;
    private ManageProfiles _profileMgr = null;
    private ManagePools _poolMgr = null;
    private ManageDisks _diskMgr = null;
    private boolean _stop = false;
    private String _originalName = null;
    private StorageArray _sa = null;
    private List _profileElements = null;
    private List _poolElements = null;
    private int _totalItemsToBeCreated = 0;
    private int _totalItemsCreated = 0;
    private static final String XML_NVSRAM = "nvsram_version";
    private static final String XML_NVSRAM_B = "<nvsram_version>";
    private static final String XML_NVSRAM_E = "</nvsram_version>\n";
    private static final String XML_CACHE_FLUSH_THRESHOLD = "cache_flush_threshold";
    private static final String XML_CACHE_FLUSH_THRESHOLD_B = "<cache_flush_threshold>";
    private static final String XML_CACHE_FLUSH_THRESHOLD_E = "</cache_flush_threshold>\n";
    private static final String XML_CACHE_FLUSH_AMOUNT = "cache_flush_amount";
    private static final String XML_CACHE_FLUSH_AMOUNT_B = "<cache_flush_amount>";
    private static final String XML_CACHE_FLUSH_AMOUNT_E = "</cache_flush_amount>\n";
    private static final String XML_IP1 = "ip1";
    private static final String XML_IP1_B = "<ip1>";
    private static final String XML_IP1_E = "</ip1>\n";
    private static final String XML_IP2 = "ip2";
    private static final String XML_IP2_B = "<ip2>";
    private static final String XML_IP2_E = "</ip2>\n";
    private static final String XML_GATEWAY1 = "gateway1";
    private static final String XML_GATEWAY1_B = "<gateway1>";
    private static final String XML_GATEWAY1_E = "</gateway1>\n";
    private static final String XML_GATEWAY2 = "gateway2";
    private static final String XML_GATEWAY2_B = "<gateway2>";
    private static final String XML_GATEWAY2_E = "</gateway2>\n";
    private static final String XML_NETMASK1 = "netmask1";
    private static final String XML_NETMASK1_B = "<netmask1>";
    private static final String XML_NETMASK1_E = "</netmask1>\n";
    private static final String XML_NETMASK2 = "netmask2";
    private static final String XML_NETMASK2_B = "<netmask2>";
    private static final String XML_NETMASK2_E = "</netmask2>\n";
    private static final String XML_DEF_HOST_PORT_TYPE = "default_host_port_type";
    private static final String XML_DEF_HOST_PORT_TYPE_B = "<default_host_port_type>";
    private static final String XML_DEF_HOST_PORT_TYPE_E = "</default_host_port_type>\n";
    private static final String XML_MEDIA_SCAN = "default_media_scan";
    private static final String XML_MEDIA_SCAN_B = "<default_media_scan>";
    private static final String XML_MEDIA_SCAN_E = "</default_media_scan>\n";
    private static final String XML_FAILOVER_ALERT_DELAY = "default_failover_alert_delay";
    private static final String XML_FAILOVER_ALERT_DELAY_B = "<default_failover_alert_delay>";
    private static final String XML_FAILOVER_ALERT_DELAY_E = "</default_failover_alert_delay>\n";
    private static final String XML_PREMIUM_FEATURES = "premium_features";
    private static final String XML_PREMIUM_FEATURES_B = "<premium_features>\n";
    private static final String XML_PREMIUM_FEATURES_E = "</premium_features>\n";
    private static final String XML_PREMIUM_NAME = "premium_name";
    private static final String XML_PREMIUM_NAME_B = "<premium_name>";
    private static final String XML_PREMIUM_NAME_E = "</premium_name>\n";
    private static final String XML_DATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String XML_RAIDBASEVIEW = "raidbaseview";
    private static final String XML_RAIDBASEVIEW_B = "<raidbaseview>\n";
    private static final String XML_RAIDBASEVIEW_E = "</raidbaseview>\n";
    private static final String XML_RAIDSYSTEM = "raidsystem";
    private static final String XML_RAIDSYSTEM_B = "<raidsystem>\n";
    private static final String XML_RAIDSYSTEM_E = "</raidsystem>\n";
    private static final String XML_NAME = "name";
    private static final String XML_NAME_B = "<name>";
    private static final String XML_NAME_E = "</name>\n";
    private static final String XML_UNIQUE_ID = "unique_id";
    private static final String XML_UNIQUE_ID_B = "<unique_id>";
    private static final String XML_UNIQUE_ID_E = "</unique_id>\n";
    private static final String XML_STATUS = "status";
    private static final String XML_STATUS_B = "<status>";
    private static final String XML_STATUS_E = "</status>\n";
    private static final String XML_MANUFACTURER = "manufacturer";
    private static final String XML_MANUFACTURER_B = "<manufacturer>";
    private static final String XML_MANUFACTURER_E = "</manufacturer>\n";
    private static final String XML_MODEL = "model";
    private static final String XML_MODEL_B = "<model>";
    private static final String XML_MODEL_E = "</model>\n";
    private static final String XML_FIRMWARE = "firmware_version";
    private static final String XML_FIRMWARE_B = "<firmware_version>";
    private static final String XML_FIRMWARE_E = "</firmware_version>\n";
    private static final String XML_CACHE_SIZE = "cache_size";
    private static final String XML_CACHE_SIZE_B = "<cache_size>";
    private static final String XML_CACHE_SIZE_E = "</cache_size>\n";
    private static final String XML_NETWORK = "network";
    private static final String XML_NETWORK_B = "<network>\n";
    private static final String XML_NETWORK_E = "</network>\n";
    private static final String XML_IP = "ip";
    private static final String XML_GATEWAY = "gateway";
    private static final String XML_NETMASK = "netmask";
    private static final String XML_ARRAY_PARAM = "array_param";
    private static final String XML_ARRAY_PARAM_B = "<array_param>\n";
    private static final String XML_ARRAY_PARAM_E = "</array_param>\n";
    private static final String XML_CACHE_BLOCK_SIZE = "cache_block_size";
    private static final String XML_CACHE_BLOCK_SIZE_B = "<cache_block_size>";
    private static final String XML_CACHE_BLOCK_SIZE_E = "</cache_block_size>\n";
    private static final String XML_PROFILES = "profiles";
    private static final String XML_PROFILES_B = "<profiles>\n";
    private static final String XML_PROFILES_E = "</profiles>\n";
    private static final String XML_PROFILE = "profile";
    private static final String XML_PROFILE_B = "<profile>\n";
    private static final String XML_PROFILE_E = "</profile>\n";
    private static final String XML_PROFILE_NAME = "profile_name";
    private static final String XML_PROFILE_NAME_B = "<profile_name>";
    private static final String XML_PROFILE_NAME_E = "</profile_name>\n";
    private static final String XML_PROFILE_DESC = "profile_desc";
    private static final String XML_PROFILE_DESC_B = "<profile_desc>";
    private static final String XML_PROFILE_DESC_E = "</profile_desc>\n";
    private static final String XML_OPTIMAL_NUM_DRIVES = "optimal_num_drives";
    private static final String XML_OPTIMAL_NUM_DRIVES_B = "<optimal_num_drives>";
    private static final String XML_OPTIMAL_NUM_DRIVES_E = "</optimal_num_drives>\n";
    private static final String XML_SEGMENT_SIZE = "segment_size";
    private static final String XML_SEGMENT_SIZE_B = "<segment_size>";
    private static final String XML_SEGMENT_SIZE_E = "</segment_size>\n";
    private static final String XML_READ_AHEAD = "read_ahead";
    private static final String XML_READ_AHEAD_B = "<read_ahead>";
    private static final String XML_READ_AHEAD_E = "</read_ahead>\n";
    private static final String XML_ARRAY_TYPE = "array_type";
    private static final String XML_ARRAY_TYPE_B = "<array_type>";
    private static final String XML_ARRAY_TYPE_E = "</array_type>\n";
    private static final String XML_DRIVE_TYPE = "drive_type";
    private static final String XML_DRIVE_TYPE_B = "<drive_type>";
    private static final String XML_DRIVE_TYPE_E = "</drive_type>\n";
    private static final String XML_FACTORY_PROFILE = "factory_profile";
    private static final String XML_FACTORY_PROFILE_B = "<factory_profile>";
    private static final String XML_FACTORY_PROFILE_E = "</factory_profile>\n";
    private static final String XML_POOL_ID = "pool_id";
    private static final String XML_POOL_ID_B = "<pool_id>";
    private static final String XML_POOL_ID_E = "</pool_id>\n";
    private static final String XML_POOL_NAME = "pool_name";
    private static final String XML_POOL_NAME_B = "<pool_name>";
    private static final String XML_POOL_NAME_E = "</pool_name>\n";
    private static final String XML_POOL_DESC = "pool_desc";
    private static final String XML_POOL_DESC_B = "<pool_desc>";
    private static final String XML_POOL_DESC_E = "</pool_desc>\n";
    private static final String XML_POOL_PROFILE_NAME = "pool_profile_name";
    private static final String XML_POOL_PROFILE_NAME_B = "<pool_profile_name>";
    private static final String XML_POOL_PROFILE_NAME_E = "</pool_profile_name>\n";
    private static final String XML_POOLS = "pools";
    private static final String XML_POOLS_B = "<pools>\n";
    private static final String XML_POOLS_E = "</pools>\n";
    private static final String XML_POOL = "pool";
    private static final String XML_POOL_B = "<pool>\n";
    private static final String XML_POOL_E = "</pool>\n";
    private static final String XML_POOL_TOTAL_CAPACITY = "pool_total_capacity";
    private static final String XML_POOL_TOTAL_CAPACITY_B = "<pool_total_capacity>";
    private static final String XML_POOL_TOTAL_CAPACITY_E = "</pool_total_capacity>\n";
    private static final String XML_POOL_AVAIL_CAPACITY = "pool_avail_capacity";
    private static final String XML_POOL_AVAIL_CAPACITY_B = "<pool_avail_capacity>";
    private static final String XML_POOL_AVAIL_CAPACITY_E = "</pool_avail_capacity>\n";
    private static final String XML_CACHE_PARAM = "cache_param";
    private static final String XML_CACHE_PARAM_B = "<cache_param>";
    private static final String XML_CACHE_PARAM_E = "</cache_param>\n";
    private static final String XML_IDX = "idx";
    private static final String XML_IDX_B = "<idx>";
    private static final String XML_IDX_E = "</idx>\n";
    private static final String XML_TYPE = "type";
    private static final String XML_TYPE_B = "<type>";
    private static final String XML_TYPE_E = "</type>\n";
    private static final String XML_TOTAL_TRAYS = "total_trays";
    private static final String XML_TOTAL_TRAYS_B = "<total_trays>";
    private static final String XML_TOTAL_TRAYS_E = "</total_trays>\n";
    private static final String XML_TRAY = "tray";
    private static final String XML_TRAY_B = "<tray>\n";
    private static final String XML_TRAY_E = "</tray>\n";
    private static final String XML_NUM_DRIVE_SLOTS = "num_drive_slots";
    private static final String XML_NUM_DRIVE_SLOTS_B = "<num_drive_slots>";
    private static final String XML_NUM_DRIVE_SLOTS_E = "</num_drive_slots>\n";
    private static final String XML_DISK_CAPACITY = "disk_capacity";
    private static final String XML_DISK_CAPACITY_B = "<disk_capacity>";
    private static final String XML_DISK_CAPACITY_E = "</disk_capacity>\n";
    private static final String XML_ACTIVE_DRIVES = "active_drives";
    private static final String XML_ACTIVE_DRIVES_B = "<active_drives>";
    private static final String XML_ACTIVE_DRIVES_E = "</active_drives>\n";
    private static final String XML_VDISK = "vdisk";
    private static final String XML_VDISK_B = "<vdisk>\n";
    private static final String XML_VDISK_E = "</vdisk>\n";
    private static final String XML_VDISK_ID = "vdisk_id";
    private static final String XML_VDISK_ID_B = "<vdisk_id>";
    private static final String XML_VDISK_ID_E = "</vdisk_id>\n";
    private static final String XML_VDISK_IDX = "vdisk_idx";
    private static final String XML_VDISK_IDX_B = "<vdisk_idx>";
    private static final String XML_VDISK_IDX_E = "</vdisk_idx>\n";
    private static final String XML_VDISK_STATUS = "vdisk_status";
    private static final String XML_VDISK_STATUS_B = "<vdisk_status>";
    private static final String XML_VDISK_STATUS_E = "</vdisk_status>\n";
    private static final String XML_RAID_LEVEL = "raid_level";
    private static final String XML_RAID_LEVEL_B = "<raid_level>";
    private static final String XML_RAID_LEVEL_E = "</raid_level>\n";
    private static final String XML_PHYDRV = "physical_drives";
    private static final String XML_PHYDRV_B = "<physical_drives>\n";
    private static final String XML_PHYDRV_E = "</physical_drives>\n";
    private static final String XML_NUMDRIVES = "number_of_drives";
    private static final String XML_NUMDRIVES_B = "<number_of_drives>";
    private static final String XML_NUMDRIVES_E = "</number_of_drives>\n";
    private static final String XML_HOT_SPARE_DRIVES = "hot_spare_drives";
    private static final String XML_HOT_SPARE_DRIVES_B = "<hot_spare_drives>";
    private static final String XML_HOT_SPARE_DRIVES_E = "</hot_spare_drives>\n";
    private static final String XML_VDISK_SIZE = "vdisk_size";
    private static final String XML_VDISK_SIZE_B = "<vdisk_size>";
    private static final String XML_VDISK_SIZE_E = "</vdisk_size>\n";
    private static final String XML_TOTAL_VOLUMES = "total_volumes";
    private static final String XML_TOTAL_VOLUMES_B = "<total_volumes>";
    private static final String XML_TOTAL_VOLUMES_E = "</total_volumes>\n";
    private static final String XML_VOLUME = "volume";
    private static final String XML_VOLUME_B = "<volume>\n";
    private static final String XML_VOLUME_E = "</volume>\n";
    private static final String XML_VOLUME_NAME = "volume_name";
    private static final String XML_VOLUME_NAME_B = "<volume_name>";
    private static final String XML_VOLUME_NAME_E = "</volume_name>\n";
    private static final String XML_VOLUME_ID = "volume_id";
    private static final String XML_VOLUME_ID_B = "<volume_id>";
    private static final String XML_VOLUME_ID_E = "</volume_id>\n";
    private static final String XML_VOLUME_SIZE = "volume_size";
    private static final String XML_VOLUME_SIZE_B = "<volume_size>";
    private static final String XML_VOLUME_SIZE_E = "</volume_size>\n";
    private static final String XML_VOLUME_TYPE = "volume_type";
    private static final String XML_VOLUME_TYPE_B = "<volume_type>";
    private static final String XML_VOLUME_TYPE_E = "</volume_type>\n";
    private static final String XML_ASSIGNMENT = "assignment";
    private static final String XML_ASSIGNMENT_B = "<assignment>";
    private static final String XML_ASSIGNMENT_E = "</assignment>\n";
    private static final String XML_MAPPING = "mapping";
    private static final String XML_MAPPING_B = "<mapping>\n";
    private static final String XML_MAPPING_E = "</mapping>\n";
    private static final String XML_LUN = "lun";
    private static final String XML_LUN_B = "<lun>";
    private static final String XML_LUN_E = "</lun>\n";
    private static final String XML_SNAPSHOTS = "snapshots";
    private static final String XML_SNAPSHOTS_B = "<snapshots>\n";
    private static final String XML_SNAPSHOTS_E = "</snapshots>\n";
    private static final String XML_SNAPSHOT = "snapshot";
    private static final String XML_SNAPSHOT_B = "<snapshot>\n";
    private static final String XML_SNAPSHOT_E = "</snapshot>\n";
    private static final String XML_SNAPSHOT_NAME = "snapshot_name";
    private static final String XML_SNAPSHOT_NAME_B = "<snapshot_name>";
    private static final String XML_SNAPSHOT_NAME_E = "</snapshot_name>\n";
    private static final String XML_SNAPSHOT_ID = "snapshot_id";
    private static final String XML_SNAPSHOT_ID_B = "<snapshot_id>";
    private static final String XML_SNAPSHOT_ID_E = "</snapshot_id>\n";
    private static final String XML_SNAPSHOT_REPOSITORY_NAME = "snapshot_repository_name";
    private static final String XML_SNAPSHOT_REPOSITORY_NAME_B = "<snapshot_repository_name>";
    private static final String XML_SNAPSHOT_REPOSITORY_NAME_E = "</snapshot_repository_name>\n";
    private static final String XML_PARTITIONS = "partitions";
    private static final String XML_PARTITIONS_B = "<partitions>\n";
    private static final String XML_PARTITIONS_E = "</partitions>\n";
    private static final String XML_PARTITION = "partition";
    private static final String XML_PARTITION_B = "<partition>\n";
    private static final String XML_PARTITION_E = "</partition>\n";
    private static final String XML_PARTITION_NAME = "partition_name";
    private static final String XML_PARTITION_NAME_B = "<partition_name>";
    private static final String XML_PARTITION_NAME_E = "</partition_name>\n";
    private static final String XML_MAPPED_VIA_TYPE = "mapped_via_type";
    private static final String XML_MAPPED_VIA_TYPE_B = "<mapped_via_type>";
    private static final String XML_MAPPED_VIA_TYPE_E = "</mapped_via_type>\n";
    private static final String XML_HOST_GROUP = "host_group";
    private static final String XML_HOST_GROUP_B = "<host_group>\n";
    private static final String XML_HOST_GROUP_E = "</host_group>\n";
    private static final String XML_HOST_GROUP_NAME = "host_group_name";
    private static final String XML_HOST_GROUP_NAME_B = "<host_group_name>";
    private static final String XML_HOST_GROUP_NAME_E = "</host_group_name>\n";
    private static final String XML_HOST = "host";
    private static final String XML_HOST_B = "<host>\n";
    private static final String XML_HOST_E = "</host>\n";
    private static final String XML_HOST_NAME = "host_name";
    private static final String XML_HOST_NAME_B = "<host_name>";
    private static final String XML_HOST_NAME_E = "</host_name>\n";
    private static final String XML_INITIATOR = "initiator";
    private static final String XML_INITIATOR_B = "<initiator>\n";
    private static final String XML_INITIATOR_E = "</initiator>\n";
    private static final String XML_INITIATOR_WWN = "initiator_wwn";
    private static final String XML_INITIATOR_WWN_B = "<initiator_wwn>";
    private static final String XML_INITIATOR_WWN_E = "</initiator_wwn>\n";
    private static final String XML_INITIATOR_NAME = "initiator_name";
    private static final String XML_INITIATOR_NAME_B = "<initiator_name>";
    private static final String XML_INITIATOR_NAME_E = "</initiator_name>\n";
    private static final String XML_HOST_TYPE = "host_type";
    private static final String XML_HOST_TYPE_B = "<host_type>";
    private static final String XML_HOST_TYPE_E = "</host_type>\n";
    private static final String XML_VOL_WRITE_CACHE = "vol_write_cache";
    private static final String XML_VOL_WRITE_CACHE_B = "<vol_write_cache>";
    private static final String XML_VOL_WRITE_CACHE_E = "</vol_write_cache>\n";
    private static final String XML_VOL_WRITE_CACHE_MIRROR = "vol_write_cache_with_mirroring";
    private static final String XML_VOL_WRITE_CACHE_MIRROR_B = "<vol_write_cache_with_mirroring>";
    private static final String XML_VOL_WRITE_CACHE_MIRROR_E = "</vol_write_cache_with_mirroring>\n";
    private static final String XML_VOL_WRITE_CACHE_BATTERY = "vol_write_cache_without_batteries";
    private static final String XML_VOL_WRITE_CACHE_BATTERY_B = "<vol_write_cache_without_batteries>";
    private static final String XML_VOL_WRITE_CACHE_BATTERY_E = "</vol_write_cache_without_batteries>\n";
    private static final String XML_VOL_DISK_SCRUBBING = "vol_disk_scrubbing";
    private static final String XML_VOL_DISK_SCRUBBING_B = "<vol_disk_scrubbing>";
    private static final String XML_VOL_DISK_SCRUBBING_E = "</vol_disk_scrubbing>\n";
    private static final String XML_VOL_DISK_SCRUBBING_REDUNDANCY = "vol_disk_scrubbing_with_redundancy";
    private static final String XML_VOL_DISK_SCRUBBING_REDUNDANCY_B = "<vol_disk_scrubbing_with_redundancy>";
    private static final String XML_VOL_DISK_SCRUBBING_REDUNDANCY_E = "</vol_disk_scrubbing_with_redundancy>\n";
    private static final String XML_VOL_MOD_PRIORITY = "vol_mod_priority";
    private static final String XML_VOL_MOD_PRIORITY_B = "<vol_mod_priority>";
    private static final String XML_VOL_MOD_PRIORITY_E = "</vol_mod_priority>\n";

    public ArrayImportExport(String arrayWwn, ManageArrays arrayMgr, ConfigContext cc) throws ConfigMgmtException {
        String METHOD = "constructor";
        Trace.methodBegin(this, "constructor");
        this._arrayMgr = arrayMgr;
        this._cc = cc;
        Scope scope = new Scope();
        scope.setAttribute("array", arrayWwn);
        try {
            this._premMgr = new ManagePremiumFeatures();
            this._premMgr.init(this._cc, scope, null);
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "constructor", e);
            throw e;
        }
        try {
            this._hostMgr = new ManageHosts();
            this._hostMgr.init(this._cc, scope, null);
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "constructor", e);
            throw e;
        }
        try {
            this._hostGroupMgr = new ManageHostGroups();
            this._hostGroupMgr.init(this._cc, scope, null);
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "constructor", e);
            throw e;
        }
        try {
            this._hostPortMgr = new ManageHostPorts();
            this._hostPortMgr.init(this._cc, scope, null);
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "constructor", e);
            throw e;
        }
        try {
            this._profileMgr = new ManageProfiles();
            this._profileMgr.init(this._cc, scope, null);
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "constructor", e);
            throw e;
        }
        try {
            this._poolMgr = new ManagePools();
            this._poolMgr.init(this._cc, scope, null);
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "constructor", e);
            throw e;
        }
        try {
            this._diskMgr = new ManageDisks();
            this._diskMgr.init(this._cc, scope, null);
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "constructor", e);
            throw e;
        }
        this._mapMgr = new ManageMappings();
        this._mapMgr.init(this._cc, scope, null);
        this._volMgr = new ManageVolumes();
        this._volMgr.init(this._cc, scope, null);
    }

    public String getOriginalArrayName() {
        return this._originalName;
    }

    public boolean initAndValidateConfig(String arrayWwn, StringBuffer config, MethodCallStatus mcs) throws UnsupportedOperationException, ConfigMgmtException {
        String METHOD_NAME = "initAndValidateConfig";
        Trace.methodBegin(this, "initAndValidateConfig");
        if (config == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null or empty xml passed to importConfigToArray()");
        }
        Document xmldocument = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            xmldocument = db.parse(new InputSource(new StringReader(config.toString())));
        }
        catch (Exception e) {
            Trace.error((Object)this, "initAndValidateConfig", (Throwable)e);
            throw new ConfigMgmtException("incorrect.method.parameter", "Error processing XML passed to importConfigToArray");
        }
        List arrays = null;
        try {
            arrays = XMLUtils.listNamedChildElements(xmldocument.getDocumentElement(), XML_RAIDSYSTEM);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (arrays == null || arrays.size() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "No raidsystem in XML passed to importConfigToArray");
        }
        if (arrays.size() != 1) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Only 1 raidsystem is allowed in import xml");
        }
        Element array = (Element)arrays.get(0);
        String model = null;
        try {
            Element prop = XMLUtils.findElement(array, XML_MODEL);
            model = XMLUtils.getElementValue(prop);
        }
        catch (Exception e) {
            Trace.error((Object)this, "initAndValidateConfig", (Throwable)e);
        }
        if (model == null || model.indexOf("6130") == -1) {
            this.addError(mcs, arrayWwn, "Invalid model type", ErrorCode.ERROR_IMPORT_INVALID_MODEL);
            return false;
        }
        Element target = null;
        List arrayList = ObjectBundleManager.getInstance().getAllArraysData();
        ArrayList<String> al = new ArrayList<String>(1);
        StorageArray sa = null;
        Iterator iter = arrayList.iterator();
        while (iter.hasNext()) {
            sa = (StorageArray)iter.next();
            if (!sa.getKey().get("array").equals(arrayWwn)) continue;
            this._arrayMgr.setCustomData(sa);
            al.add(sa.getKeyAsString());
            break;
        }
        StringBuffer sb = this.exportConfigToXml(arrayWwn, false);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            xmldocument = db.parse(new InputSource(new StringReader(sb.toString())));
            List targets = XMLUtils.listNamedChildElements(xmldocument.getDocumentElement(), XML_RAIDSYSTEM);
            target = (Element)targets.get(0);
        }
        catch (Exception e) {
            Trace.error((Object)this, (Throwable)e);
            this.addError(mcs, arrayWwn, "Failed to get target array config", ErrorCode.ERROR_IMPORT_TARGET_CONFIG);
            return false;
        }
        if (!this.validatePremiums(array, mcs)) {
            return false;
        }
        if (!this.validatePhysical(array, target, mcs)) {
            return false;
        }
        this._sa = sa;
        this._originalName = sa.getName();
        if (!this.validateAndCountProfiles(array, mcs)) {
            return false;
        }
        if (!this.validateAndCountPools(array, mcs)) {
            return false;
        }
        if (!this.validateAndCountVolumesAndMappings(array, mcs)) {
            return false;
        }
        return this.validateAndCountPartitions(array, mcs);
    }

    public boolean resetArray(String arrayWwn, MethodCallStatus mcs) throws Exception {
        String METHOD = "resetArray";
        try {
            CommandProcessor command = new CommandProcessor(arrayWwn);
            this._arrayMgr.clearArrayConfiguration(command, arrayWwn);
            this._arrayMgr.setArrayPassword(command, arrayWwn, "", "", true);
        }
        catch (Exception e) {
            Trace.error((Object)this, "resetArray", e.toString());
            this.addError(mcs, arrayWwn, "Failures during clear array", ErrorCode.ERROR_IMPORT_CLEAR_ARRAY);
            return false;
        }
        return this.restoreArrayName(this._sa, this._originalName, mcs);
    }

    public synchronized void setStop() {
        this._stop = true;
    }

    private synchronized boolean getStop() {
        return this._stop;
    }

    private synchronized void checkStop() throws Exception {
        if (this.getStop()) {
            throw new Exception();
        }
    }

    public synchronized int getPercentComplete() {
        if (this._totalItemsToBeCreated < 1 || this._totalItemsCreated > this._totalItemsToBeCreated || this._totalItemsToBeCreated < 1) {
            return 100;
        }
        int rc = (this._totalItemsCreated - 1) * 100 / this._totalItemsToBeCreated;
        if (rc < 1) {
            return 0;
        }
        if (rc > 99) {
            return 100;
        }
        return rc;
    }

    private boolean validateAndCountPools(Element array, MethodCallStatus mcs) {
        String METHOD = "validateAndCountPools";
        try {
            List pools = XMLUtils.listNamedChildElements(array, XML_POOLS);
            if (pools == null || pools.size() != 1) {
                this.addError(mcs, null, "Malformed Pool XML", ErrorCode.ERROR_IMPORT_POOL_MALFORMED_XML);
                return false;
            }
            this._poolElements = XMLUtils.listNamedChildElements((Element)pools.get(0), XML_POOL);
            if (this._poolElements == null || this._poolElements.size() < 1) {
                this.addError(mcs, null, "Malformed Pool XML", ErrorCode.ERROR_IMPORT_POOL_MALFORMED_XML);
                return false;
            }
            this._totalItemsToBeCreated += this._poolElements.size();
            return true;
        }
        catch (Exception ex) {
            Trace.error((Object)this, "validateAndCountPools", (Throwable)ex);
            this.addError(mcs, null, "Exception during pool validation", ErrorCode.ERROR_IMPORT_POOL);
            return false;
        }
    }

    private boolean validateAndCountPartitions(Element array, MethodCallStatus mcs) {
        String METHOD_NAME = "validateAndCountPartitions";
        try {
            List top = XMLUtils.listNamedChildElements(array, XML_PARTITIONS);
            if (top == null || top.size() != 1) {
                this.addError(mcs, null, "Malformed Partition XML", ErrorCode.ERROR_IMPORT_PARTITION_MALFORMED_XML);
                return false;
            }
            List partitions = XMLUtils.listNamedChildElements((Element)top.get(0), XML_PARTITION);
            if (partitions == null || partitions.size() < 1) {
                this.addError(mcs, null, "Malformed Partition XML", ErrorCode.ERROR_IMPORT_PARTITION_MALFORMED_XML);
                return false;
            }
            for (int i = 0; i < partitions.size(); ++i) {
                int j;
                Element partition = (Element)partitions.get(i);
                Element prop = XMLUtils.findElement(partition, XML_MAPPED_VIA_TYPE);
                String value = XMLUtils.getElementValue(prop);
                if ("Default_Group".equals(value) || "Host_Group".equals(value)) {
                    List groups = XMLUtils.listNamedChildElements(partition, XML_HOST_GROUP);
                    this._totalItemsToBeCreated += groups.size();
                    for (j = 0; j < groups.size(); ++j) {
                        List hosts = XMLUtils.listNamedChildElements((Element)groups.get(j), XML_HOST);
                        if (hosts == null || hosts.size() < 1) continue;
                        this._totalItemsToBeCreated += hosts.size();
                        for (int k = 0; k < hosts.size(); ++k) {
                            List ports = XMLUtils.listNamedChildElements((Element)hosts.get(k), XML_INITIATOR);
                            this._totalItemsToBeCreated += ports.size();
                        }
                    }
                }
                if (!"Default_Group".equals(value) && !"Host".equals(value)) continue;
                List hosts = XMLUtils.listNamedChildElements(partition, XML_HOST);
                this._totalItemsToBeCreated += hosts.size();
                for (j = 0; j < hosts.size(); ++j) {
                    List ports = XMLUtils.listNamedChildElements((Element)hosts.get(j), XML_INITIATOR);
                    this._totalItemsToBeCreated += ports.size();
                }
            }
        }
        catch (Exception ex) {
            Trace.error((Object)this, "validateAndCountPartitions", (Throwable)ex);
            this.addError(mcs, null, "Exception during parition restoration", ErrorCode.ERROR_IMPORT_PARTITION_FAILURE);
            return false;
        }
        return true;
    }

    private boolean validateAndCountVolumesAndMappings(Element array, MethodCallStatus mcs) {
        String METHOD = "validateAndCountVolumes";
        try {
            List vdisks = XMLUtils.listNamedChildElements(array, XML_VDISK);
            if (vdisks == null || vdisks.size() == 0) {
                return true;
            }
            Object prop = null;
            Object vdiskKey = null;
            for (int i = 0; i < vdisks.size(); ++i) {
                vdiskKey = null;
                Element vdisk = (Element)vdisks.get(i);
                List vols = XMLUtils.listNamedChildElements(vdisk, XML_VOLUME);
                if (vols == null || vols.size() == 0) continue;
                this._totalItemsToBeCreated += vols.size();
                for (int j = 0; j < vols.size(); ++j) {
                    Element vol = (Element)vols.get(j);
                    List mappings = XMLUtils.listNamedChildElements(vol, XML_MAPPING);
                    this._totalItemsToBeCreated += mappings.size();
                }
            }
            return true;
        }
        catch (Exception ex) {
            Trace.error((Object)this, "validateAndCountVolumes", (Throwable)ex);
            this.addError(mcs, null, "Exception during volume validation", ErrorCode.ERROR_IMPORT_VOLUME);
            return false;
        }
    }

    private boolean validateAndCountProfiles(Element array, MethodCallStatus mcs) {
        String METHOD = "validateAndCountProfiles";
        try {
            List profiles = XMLUtils.listNamedChildElements(array, XML_PROFILES);
            if (profiles == null || profiles.size() != 1) {
                this.addError(mcs, null, "Malformed Profile XML", ErrorCode.ERROR_IMPORT_PROFILE_MALFORMED_XML);
                return false;
            }
            this._profileElements = XMLUtils.listNamedChildElements((Element)profiles.get(0), XML_PROFILE);
            if (this._profileElements == null) {
                this._profileElements = new ArrayList();
            }
            this._totalItemsToBeCreated += this._profileElements.size();
            return true;
        }
        catch (Exception ex) {
            Trace.error((Object)this, "validateAndCountProfiles", (Throwable)ex);
            this.addError(mcs, null, "Exception during profile validation", ErrorCode.ERROR_IMPORT_PROFILE);
            return false;
        }
    }

    public void doImport(String arrayWwn, StringBuffer config, MethodCallStatus mcs) throws ConfigMgmtException, Exception {
        String METHOD_NAME = "doImport";
        Trace.methodBegin(this, "doImport");
        if (this._sa == null || this._originalName == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "initAndValidateConfig must be called prior to doImport");
        }
        Document xmldocument = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            xmldocument = db.parse(new InputSource(new StringReader(config.toString())));
        }
        catch (Exception e) {
            Trace.error((Object)this, "doImport", (Throwable)e);
            throw new ConfigMgmtException("incorrect.method.parameter", "Error processing XML passed to importConfigToArray");
        }
        List arrays = null;
        try {
            arrays = XMLUtils.listNamedChildElements(xmldocument.getDocumentElement(), XML_RAIDSYSTEM);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (arrays == null || arrays.size() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "No raidsystem in XML passed to importConfigToArray");
        }
        if (arrays.size() != 1) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Only 1 raidsystem is allowed in import xml");
        }
        Element array = (Element)arrays.get(0);
        this.restoreProfiles(array, arrayWwn, mcs);
        this.restorePools(array, arrayWwn, mcs);
        this.restoreVolumes(array, arrayWwn, mcs);
        this.restorePartitions(array, arrayWwn, mcs);
        this.restoreMappings(array, arrayWwn, mcs);
        this.restoreArrayInfo(array, this._sa, mcs);
    }

    private String getEncoded(BigInteger value) {
        return this.getEncoded(value.toString());
    }

    private String getEncoded(boolean value) {
        return this.getEncoded(Boolean.toString(value));
    }

    private String getEncoded(int value) {
        return this.getEncoded(Integer.toString(value));
    }

    private String getEncoded(String value) {
        String rc = null;
        try {
            rc = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Trace.error((Object)this, "getEncoded", (Throwable)e);
            rc = value;
        }
        return rc;
    }

    private String getDecodedElementValue(Element e) {
        String rc = XMLUtils.getElementValue(e);
        if (rc != null) {
            try {
                rc = URLDecoder.decode(rc, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                Trace.error((Object)this, "getDecodedElementValue", (Throwable)ex);
            }
        }
        return rc;
    }

    private void backupVolumeInfo(ObjectBundle ob, StringBuffer sb, String arrayWWN, MethodCallStatus mcs, boolean logErrors) throws ConfigMgmtException {
        String METHOD = "backupVolumeInfo";
        Trace.methodBegin(this, "backupVolumeInfo");
        VolumeGroup[] ozVolumeGroups = ob.getVolumeGroup();
        if (ozVolumeGroups == null || ozVolumeGroups.length == 0) {
            return;
        }
        HashMap disks = this.getDiskMap(ob.getDrive());
        Mapping map = null;
        String volName = null;
        String name = null;
        List vols = this._volMgr.getItemList();
        List mappings = this._mapMgr.getItemList();
        List pools = this._poolMgr.getItemList();
        for (int i = 0; i < ozVolumeGroups.length; ++i) {
            Volume vol;
            int j;
            String ozVolumeGroupRef = Convert.bytesToStringRaw(ozVolumeGroups[i].getVolumeGroupRef().getRefToken());
            sb.append(XML_VDISK_B);
            sb.append(XML_VDISK_IDX_B);
            sb.append(this.getEncoded(ozVolumeGroups[i].getSequenceNum()));
            sb.append(XML_VDISK_IDX_E);
            sb.append(XML_VDISK_ID_B);
            sb.append(this.getEncoded(Convert.bytesToString(ozVolumeGroups[i].getWorldWideName())));
            sb.append(XML_VDISK_ID_E);
            sb.append(XML_VDISK_STATUS_B);
            sb.append(this.getEncoded(ozVolumeGroups[i].getOffline() ? "Offline" : "Good"));
            sb.append(XML_VDISK_STATUS_E);
            sb.append(XML_RAID_LEVEL_B);
            sb.append(this.getEncoded("RAID " + ozVolumeGroups[i].getRaidLevel().getValue()));
            sb.append(XML_RAID_LEVEL_E);
            sb.append(XML_PHYDRV_B);
            Tray[] ozTrays = ob.getTray();
            int count = 0;
            for (int j2 = 0; j2 < ozTrays.length; ++j2) {
                String tok = Convert.bytesToStringRaw(ozTrays[j2].getTrayRef().getRefToken());
                sb.append(XML_TRAY_B);
                sb.append(XML_IDX_B).append(this.getEncoded(ozTrays[j2].getTrayId())).append(XML_IDX_E);
                List td = (List)disks.get(tok);
                Iterator itr = td.iterator();
                while (itr.hasNext()) {
                    Drive drv = (Drive)itr.next();
                    String ozRef = Convert.bytesToStringRaw(drv.getCurrentVolumeGroupRef().getRefToken());
                    if (!ozVolumeGroupRef.equals(ozRef)) continue;
                    String slot = String.valueOf(drv.getPhysicalLocation().getSlot());
                    sb.append(XML_ACTIVE_DRIVES_B).append(this.getEncoded(slot)).append(XML_ACTIVE_DRIVES_E);
                    ++count;
                }
                sb.append(XML_TRAY_E);
            }
            sb.append(XML_PHYDRV_E);
            sb.append(XML_NUMDRIVES_B);
            sb.append(this.getEncoded(count)).append(XML_NUMDRIVES_E);
            if (vols == null || vols.size() == 0) continue;
            ArrayList<Volume> vdiskVols = new ArrayList<Volume>();
            VolumeInterface v = null;
            for (j = 0; j < vols.size(); ++j) {
                v = (VolumeInterface)vols.get(j);
                if (!(v instanceof Volume) || !ozVolumeGroupRef.equals((vol = (Volume)v).getVDiskReference())) continue;
                vdiskVols.add(vol);
            }
            sb.append(XML_TOTAL_VOLUMES_B);
            sb.append(this.getEncoded(vdiskVols.size())).append(XML_TOTAL_VOLUMES_E);
            for (j = 0; j < vdiskVols.size(); ++j) {
                v = (VolumeInterface)vdiskVols.get(j);
                if (!(v instanceof Volume)) continue;
                vol = (Volume)v;
                String volType = null;
                if (vol.getType() == 1) {
                    volType = "Standard";
                } else if (vol.getType() == 4) {
                    volType = "Source";
                } else if (vol.getType() == 5) {
                    volType = "Target";
                } else if (vol.getType() == 6) {
                    volType = "SourceTarget";
                } else {
                    Trace.verbose((Object)this, "backupVol", "skipping vol type: " + vol.getType());
                    continue;
                }
                sb.append(XML_VOLUME_B);
                sb.append(XML_VOLUME_NAME_B);
                sb.append(this.getEncoded(v.getName())).append(XML_VOLUME_NAME_E);
                sb.append(XML_VOLUME_ID_B);
                sb.append(this.getEncoded(v.getWwn())).append(XML_VOLUME_ID_E);
                sb.append(XML_VOLUME_SIZE_B);
                sb.append(this.getEncoded(v.getSize())).append(XML_VOLUME_SIZE_E);
                sb.append(XML_VOLUME_TYPE_B);
                sb.append(this.getEncoded(volType));
                sb.append(XML_VOLUME_TYPE_E);
                sb.append(XML_ASSIGNMENT_B);
                sb.append(this.getEncoded(vol.getController())).append(XML_ASSIGNMENT_E);
                sb.append(XML_VOL_WRITE_CACHE_B);
                sb.append(this.getEncoded(vol.isWriteCache()));
                sb.append(XML_VOL_WRITE_CACHE_E);
                sb.append(XML_VOL_WRITE_CACHE_MIRROR_B);
                sb.append(this.getEncoded(vol.isWriteCacheWithMirroring()));
                sb.append(XML_VOL_WRITE_CACHE_MIRROR_E);
                sb.append(XML_VOL_WRITE_CACHE_BATTERY_B);
                sb.append(this.getEncoded(vol.isWriteCacheWithoutBatteries()));
                sb.append(XML_VOL_WRITE_CACHE_BATTERY_E);
                sb.append(XML_VOL_DISK_SCRUBBING_B);
                sb.append(this.getEncoded(vol.isDiskScrubbing()));
                sb.append(XML_VOL_DISK_SCRUBBING_E);
                sb.append(XML_VOL_DISK_SCRUBBING_REDUNDANCY_B);
                sb.append(this.getEncoded(vol.isDiskScrubbingWithRedundancy()));
                sb.append(XML_VOL_DISK_SCRUBBING_REDUNDANCY_E);
                sb.append(XML_VOL_MOD_PRIORITY_B);
                sb.append(this.getEncoded(vol.getModificationPriority()));
                sb.append(XML_VOL_MOD_PRIORITY_E);
                String poolName = vol.getPoolName();
                if (poolName == null) {
                    if (logErrors) {
                        LogAPI.staticLog((String)"ARRAY_EXPORT_VOL_NO_POOL", (String[])new String[]{vol.getName()}, (String[])new String[0]);
                    }
                    poolName = "-";
                } else {
                    Pool thePool = null;
                    boolean found = false;
                    for (int p = 0; p < pools.size(); ++p) {
                        thePool = (Pool)pools.get(p);
                        if (!thePool.getName().equals(poolName)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        if (logErrors) {
                            LogAPI.staticLog((String)"ARRAY_EXPORT_VOL_NO_POOL", (String[])new String[]{vol.getName()}, (String[])new String[0]);
                        }
                        poolName = "-";
                    } else {
                        try {
                            this._poolMgr.validateVolumeForProfile(thePool.getProfile(), vol);
                        }
                        catch (ConfigMgmtException e) {
                            if (logErrors) {
                                LogAPI.staticLog((String)"ARRAY_EXPORT_VOL_BAD_POOL", (String[])new String[]{vol.getName(), poolName}, (String[])new String[0]);
                            }
                            poolName = "-";
                        }
                    }
                }
                sb.append(XML_POOL_NAME_B).append(this.getEncoded(poolName)).append(XML_POOL_NAME_E);
                for (int k = 0; k < mappings.size(); ++k) {
                    map = (Mapping)mappings.get(k);
                    volName = map.getVolumeName();
                    if (!vol.getName().equals(volName)) continue;
                    sb.append(XML_MAPPING_B);
                    name = map.getHostGroupName();
                    if (map.getHostName() != null) {
                        name = map.getHostName();
                    }
                    if (name == null) {
                        name = "Default_Group";
                    }
                    sb.append(XML_PARTITION_NAME_B);
                    sb.append(this.getEncoded(name)).append(XML_PARTITION_NAME_E);
                    sb.append(XML_LUN_B);
                    sb.append(this.getEncoded(map.getLun())).append(XML_LUN_E);
                    sb.append(XML_MAPPING_E);
                }
                sb.append(XML_VOLUME_E);
            }
            sb.append(XML_VDISK_E);
        }
    }

    private void getPartitions(HashMap grouphm, HashMap hosthm, String type) {
        List al;
        int i;
        String METHOD_NAME = "getPartitions";
        Trace.methodBegin(this, "getPartitions");
        List hosts = null;
        List groups = null;
        Host host = null;
        HostGroup hg = null;
        String groupName = null;
        try {
            ManageHosts mgr = this._hostMgr;
            hosts = mgr.getItemList();
            ManageHostGroups hgmgr = this._hostGroupMgr;
            groups = hgmgr.getItemList();
        }
        catch (ConfigMgmtException ce) {
            Trace.verbose((Object)this, "getPartitions", (Throwable)ce);
            return;
        }
        boolean add = false;
        for (i = 0; i < hosts.size(); ++i) {
            host = (Host)hosts.get(i);
            groupName = host.getGroupName();
            if (groupName != null) {
                block20: {
                    al = !grouphm.containsKey(groupName) ? new ArrayList() : (List)grouphm.get(groupName);
                    al.add(host.getName());
                    add = false;
                    if ("default".equals(type) || "other".equals(type)) {
                        for (int j = 0; j < groups.size(); ++j) {
                            hg = (HostGroup)groups.get(j);
                            if (!hg.getName().equals(groupName)) continue;
                            switch (hg.getAccessControl()) {
                                case 0: {
                                    if ("default".equals(type)) {
                                        add = true;
                                        break;
                                    }
                                    break block20;
                                }
                                case 1: {
                                    if ("other".equals(type)) {
                                        add = true;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                    } else {
                        add = true;
                    }
                }
                if (!add) continue;
                grouphm.put(groupName, al);
                continue;
            }
            if ("other".equals(type)) continue;
            al = new ArrayList();
            hosthm.put(host.getName(), al);
        }
        for (i = 0; i < groups.size(); ++i) {
            block22: {
                block21: {
                    hg = (HostGroup)groups.get(i);
                    if (grouphm.containsKey(hg.getName())) continue;
                    al = new ArrayList();
                    add = false;
                    if (!"default".equals(type) && !"other".equals(type)) break block21;
                    switch (hg.getAccessControl()) {
                        case 0: {
                            if ("default".equals(type)) {
                                add = true;
                                break;
                            }
                            break block22;
                        }
                        case 1: {
                            if ("other".equals(type)) {
                                add = true;
                            } else {
                                break;
                            }
                        }
                    }
                    break block22;
                }
                add = true;
            }
            if (!add) continue;
            grouphm.put(hg.getName(), al);
        }
    }

    private void backupPartitionInfo(StringBuffer sb, String arrayWWN, MethodCallStatus mcs) throws ConfigMgmtException {
        String METHOD = "backupPartitionInfo";
        Trace.methodBegin(this, "backupPartitionInfo");
        sb.append(XML_PARTITIONS_B);
        List hosts = null;
        List ports = null;
        HostPort port = null;
        String type = null;
        List hostPorts = this._hostPortMgr.getItemList();
        boolean useDefault = true;
        for (int loop = 0; loop < 2; ++loop) {
            int j;
            HashMap grouphm = new HashMap();
            HashMap hosthm = new HashMap();
            type = useDefault ? "default" : "other";
            this.getPartitions(grouphm, hosthm, type);
            if (useDefault) {
                sb.append(XML_PARTITION_B);
                sb.append(XML_MAPPED_VIA_TYPE_B);
                sb.append(this.getEncoded("Default_Group"));
                sb.append(XML_MAPPED_VIA_TYPE_E);
            }
            String key = null;
            Object name = null;
            Iterator i = grouphm.keySet().iterator();
            while (i.hasNext()) {
                if (!useDefault) {
                    sb.append(XML_PARTITION_B);
                    sb.append(XML_MAPPED_VIA_TYPE_B);
                    sb.append(this.getEncoded("Host_Group"));
                    sb.append(XML_MAPPED_VIA_TYPE_E);
                }
                key = (String)i.next();
                sb.append(XML_HOST_GROUP_B);
                sb.append(XML_HOST_GROUP_NAME_B);
                sb.append(this.getEncoded(key)).append(XML_HOST_GROUP_NAME_E);
                hosts = (List)grouphm.get(key);
                for (j = 0; j < hosts.size(); ++j) {
                    sb.append(XML_HOST_B);
                    sb.append(XML_HOST_NAME_B);
                    sb.append(this.getEncoded((String)hosts.get(j))).append(XML_HOST_NAME_E);
                    ports = this.getHostPorts(hostPorts, (String)hosts.get(j));
                    for (int k = 0; k < ports.size(); ++k) {
                        port = (HostPort)ports.get(k);
                        sb.append(XML_INITIATOR_B);
                        sb.append(XML_INITIATOR_WWN_B);
                        sb.append(this.getEncoded(port.getWwn())).append(XML_INITIATOR_WWN_E);
                        sb.append(XML_INITIATOR_NAME_B);
                        sb.append(this.getEncoded(port.getName())).append(XML_INITIATOR_NAME_E);
                        sb.append(XML_HOST_TYPE_B);
                        sb.append(this.getEncoded(port.getHostOSType())).append(XML_HOST_TYPE_E);
                        sb.append(XML_INITIATOR_E);
                    }
                    sb.append(XML_HOST_E);
                }
                sb.append(XML_HOST_GROUP_E);
                if (useDefault) continue;
                sb.append(XML_PARTITION_E);
            }
            i = hosthm.keySet().iterator();
            while (i.hasNext()) {
                if (!useDefault) {
                    sb.append(XML_PARTITION_B);
                    sb.append(XML_MAPPED_VIA_TYPE_B);
                    sb.append(this.getEncoded("Host")).append(XML_MAPPED_VIA_TYPE_E);
                }
                key = (String)i.next();
                sb.append(XML_HOST_B);
                sb.append(XML_HOST_NAME_B);
                sb.append(this.getEncoded(key)).append(XML_HOST_NAME_E);
                ports = this.getHostPorts(hostPorts, key);
                for (j = 0; j < ports.size(); ++j) {
                    port = (HostPort)ports.get(j);
                    sb.append(XML_INITIATOR_B);
                    sb.append(XML_INITIATOR_WWN_B);
                    sb.append(this.getEncoded(port.getWwn())).append(XML_INITIATOR_WWN_E);
                    sb.append(XML_INITIATOR_NAME_B);
                    sb.append(this.getEncoded(port.getName())).append(XML_INITIATOR_NAME_E);
                    sb.append(XML_HOST_TYPE_B);
                    sb.append(this.getEncoded(port.getHostOSType())).append(XML_HOST_TYPE_E);
                    sb.append(XML_INITIATOR_E);
                }
                sb.append(XML_HOST_E);
                if (useDefault) continue;
                sb.append(XML_PARTITION_E);
            }
            if (useDefault) {
                sb.append(XML_PARTITION_E);
            }
            useDefault = false;
        }
        sb.append(XML_PARTITIONS_E);
    }

    private List getHostPorts(List hostPorts, String hostName) {
        ArrayList<HostPort> retList = new ArrayList<HostPort>();
        if (hostPorts == null || hostName == null) {
            return retList;
        }
        HostPort port = null;
        for (int i = 0; i < hostPorts.size(); ++i) {
            port = (HostPort)hostPorts.get(i);
            if (!hostName.equals(port.getHostName())) continue;
            retList.add(port);
        }
        return retList;
    }

    private void backupProfileInfo(StringBuffer sb, String arrayWWN, MethodCallStatus mcs) throws ConfigMgmtException {
        String METHOD = "backupProfileInfo";
        Trace.methodBegin(this, "backupProfileInfo");
        sb.append(XML_PROFILES_B);
        List profiles = this._profileMgr.getItemList();
        for (int i = 0; i < profiles.size(); ++i) {
            Profile p = (Profile)profiles.get(i);
            Trace.verbose((Object)this, "backupProfileInfo", "save " + p.getName());
            sb.append(XML_PROFILE_B);
            sb.append(XML_PROFILE_NAME_B);
            sb.append(this.getEncoded(p.getName())).append(XML_PROFILE_NAME_E);
            sb.append(XML_PROFILE_DESC_B);
            sb.append(this.getEncoded(p.getDescription())).append(XML_PROFILE_DESC_E);
            sb.append(XML_RAID_LEVEL_B);
            sb.append(this.getEncoded("RAID " + p.getRaidLevel())).append(XML_RAID_LEVEL_E);
            sb.append(XML_OPTIMAL_NUM_DRIVES_B);
            sb.append(this.getEncoded(p.getNumberOfDisks())).append(XML_OPTIMAL_NUM_DRIVES_E);
            String segmentSize = null;
            sb.append(XML_SEGMENT_SIZE_B);
            switch (p.getSegmentSize()) {
                case 0: {
                    segmentSize = "4K";
                    break;
                }
                case 1: {
                    segmentSize = "8K";
                    break;
                }
                case 2: {
                    segmentSize = "16K";
                    break;
                }
                case 3: {
                    segmentSize = "32K";
                    break;
                }
                case 4: {
                    segmentSize = "64K";
                    break;
                }
                case 5: {
                    segmentSize = "128K";
                    break;
                }
                case 6: {
                    segmentSize = "256K";
                    break;
                }
                case 7: {
                    segmentSize = "512K";
                    break;
                }
            }
            sb.append(this.getEncoded(segmentSize));
            sb.append(XML_SEGMENT_SIZE_E);
            sb.append(XML_READ_AHEAD_B);
            sb.append(this.getEncoded(p.isReadAheadEnabled() ? "On" : "Off"));
            sb.append(XML_READ_AHEAD_E);
            sb.append(XML_DRIVE_TYPE_B);
            sb.append(this.getEncoded(ProfileDataManager.getDriveTypeString(p.getDriveType())));
            sb.append(XML_DRIVE_TYPE_E);
            sb.append(XML_FACTORY_PROFILE_B);
            sb.append(this.getEncoded(p.isFactoryProfile() ? "yes" : "no"));
            sb.append(XML_FACTORY_PROFILE_E);
            sb.append(XML_PROFILE_E);
        }
        sb.append(XML_PROFILES_E);
    }

    public StringBuffer exportConfigToXml(String arrayWwn) throws UnsupportedOperationException, ConfigMgmtException {
        return this.exportConfigToXml(arrayWwn, true);
    }

    public StringBuffer exportConfigToXml(String arrayWwn, boolean logErrors) throws UnsupportedOperationException, ConfigMgmtException {
        String METHOD_NAME = "exportConfigToXml";
        Trace.methodBegin(this, "exportConfigToXml");
        MethodCallStatus mcs = new MethodCallStatus();
        Object errorDesc = null;
        List arrayList = ObjectBundleManager.getInstance().getAllArraysData();
        StringBuffer sb = new StringBuffer(XML_DATA);
        sb.append(XML_RAIDBASEVIEW_B);
        StorageArrayInterface sa = null;
        boolean found = false;
        Iterator iter = arrayList.iterator();
        while (iter.hasNext()) {
            sa = (StorageArrayInterface)iter.next();
            if (!sa.getKey().get("array").equals(arrayWwn)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new SEItemNotFoundException(arrayWwn);
        }
        this._arrayMgr.setCustomData((StorageArray)sa);
        sb.append(XML_RAIDSYSTEM_B);
        String name = sa.getName();
        sb.append(XML_NAME_B);
        sb.append(this.getEncoded(name)).append(XML_NAME_E);
        sb.append(XML_UNIQUE_ID_B);
        sb.append(this.getEncoded(arrayWwn)).append(XML_UNIQUE_ID_E);
        sb.append(XML_STATUS_B);
        sb.append(this.getEncoded("ok")).append(XML_STATUS_E);
        ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        this.backupCustomData((StorageArray)sa, sb, mcs);
        this.backupPremiums(sb, arrayWwn, mcs);
        this.backupPoolInfo(sb, arrayWwn, mcs);
        this.backupPhysicalInfo(ob, sb, mcs);
        this.backupVolumeInfo(ob, sb, arrayWwn, mcs, logErrors);
        this.backupPartitionInfo(sb, arrayWwn, mcs);
        this.backupProfileInfo(sb, arrayWwn, mcs);
        sb.append(XML_RAIDSYSTEM_E);
        sb.append(XML_RAIDBASEVIEW_E);
        Trace.verbose((Object)this, "exportConfigToXml", "done");
        return sb;
    }

    private void backupCustomData(StorageArray sa, StringBuffer sb, MethodCallStatus mcs) {
        String METHOD = "backupCustomData";
        Trace.methodBegin(this, "backupCustomData");
        sb.append(XML_MANUFACTURER_B);
        sb.append(this.getEncoded("SUN")).append(XML_MANUFACTURER_E);
        sb.append(XML_MODEL_B);
        sb.append(this.getEncoded(sa.getArrayType())).append(XML_MODEL_E);
        sb.append(XML_FIRMWARE_B);
        sb.append(this.getEncoded(sa.getFirmwareVersion())).append(XML_FIRMWARE_E);
        sb.append(XML_NVSRAM_B);
        String nvs = sa.getNVSRamVersion() == null ? "" : sa.getNVSRamVersion();
        sb.append(this.getEncoded(nvs)).append(XML_NVSRAM_E);
        sb.append(XML_CACHE_SIZE_B);
        sb.append("").append(XML_CACHE_SIZE_E);
        sb.append(XML_NETWORK_B);
        sb.append(XML_IP1_B);
        sb.append(this.getEncoded(sa.getIpAddress1())).append(XML_IP1_E);
        sb.append(XML_IP2_B);
        sb.append(this.getEncoded(sa.getIpAddress2())).append(XML_IP2_E);
        sb.append(XML_GATEWAY1_B);
        sb.append(this.getEncoded(sa.getGatewayAddress1())).append(XML_GATEWAY1_E);
        sb.append(XML_GATEWAY2_B);
        sb.append(this.getEncoded(sa.getGatewayAddress2())).append(XML_GATEWAY2_E);
        sb.append(XML_NETMASK1_B);
        sb.append(this.getEncoded(sa.getNetMask1())).append(XML_NETMASK1_E);
        sb.append(XML_NETMASK2_B);
        sb.append(this.getEncoded(sa.getNetMask2())).append(XML_NETMASK2_E);
        sb.append(XML_NETWORK_E);
        sb.append(XML_ARRAY_PARAM_B);
        String bs = Integer.toString(sa.getCacheBlockSize() / 1024) + "KB";
        sb.append(XML_CACHE_BLOCK_SIZE_B);
        sb.append(this.getEncoded(bs)).append(XML_CACHE_BLOCK_SIZE_E);
        sb.append(XML_CACHE_FLUSH_THRESHOLD_B);
        sb.append(this.getEncoded(sa.getCacheFlushThreshold())).append(XML_CACHE_FLUSH_THRESHOLD_E);
        sb.append(XML_CACHE_FLUSH_AMOUNT_B);
        sb.append(this.getEncoded(sa.getCacheFlushAmount())).append(XML_CACHE_FLUSH_AMOUNT_E);
        sb.append(XML_DEF_HOST_PORT_TYPE_B);
        sb.append(this.getEncoded(sa.getDefaultHostPortType())).append(XML_DEF_HOST_PORT_TYPE_E);
        sb.append(XML_MEDIA_SCAN_B);
        sb.append(this.getEncoded(sa.getMediaScanPeriod())).append(XML_MEDIA_SCAN_E);
        sb.append(XML_FAILOVER_ALERT_DELAY_B);
        sb.append(this.getEncoded(sa.getFailOverAlertDelay())).append(XML_FAILOVER_ALERT_DELAY_E);
        sb.append(XML_ARRAY_PARAM_E);
    }

    private void backupPremiums(StringBuffer sb, String arrayWWN, MethodCallStatus mcs) throws ConfigMgmtException {
        String METHOD = "backupPremiums";
        Trace.methodBegin(this, "backupPremiums");
        List premiums = null;
        premiums = this._premMgr.getItemList();
        sb.append(XML_PREMIUM_FEATURES_B);
        for (int i = 0; i < premiums.size(); ++i) {
            PremiumFeatures prem = (PremiumFeatures)premiums.get(i);
            sb.append(XML_PREMIUM_NAME_B);
            sb.append(this.getEncoded(prem.getName())).append(XML_PREMIUM_NAME_E);
        }
        sb.append(XML_PREMIUM_FEATURES_E);
    }

    private void backupPoolInfo(StringBuffer sb, String arrayWWN, MethodCallStatus mcs) throws ConfigMgmtException {
        String METHOD = "backupPoolInfo";
        Trace.methodBegin(this, "backupPoolInfo");
        sb.append(XML_POOLS_B);
        List pools = this._poolMgr.getItemList();
        for (int i = 0; i < pools.size(); ++i) {
            Pool pool = (Pool)pools.get(i);
            sb.append(XML_POOL_B);
            sb.append(XML_POOL_NAME_B);
            sb.append(this.getEncoded(pool.getName())).append(XML_POOL_NAME_E);
            sb.append(XML_POOL_DESC_B);
            sb.append(this.getEncoded(pool.getDescription())).append(XML_POOL_DESC_E);
            sb.append(XML_POOL_PROFILE_NAME_B);
            sb.append(this.getEncoded(pool.getProfileName())).append(XML_POOL_PROFILE_NAME_E);
            sb.append(XML_POOL_TOTAL_CAPACITY_B);
            double d = pool.getTotalCapacity().doubleValue() / 1.073741824E9;
            DecimalFormat df = new DecimalFormat("##0.000");
            sb.append(this.getEncoded(df.format(d))).append(this.getEncoded("GB")).append(XML_POOL_TOTAL_CAPACITY_E);
            sb.append(XML_POOL_AVAIL_CAPACITY_B);
            d = pool.getAvailableCapacity().doubleValue() / 1.073741824E9;
            sb.append(this.getEncoded(df.format(d)) + this.getEncoded("GB")).append(XML_POOL_AVAIL_CAPACITY_E);
            sb.append(XML_POOL_E);
        }
        sb.append(XML_POOLS_E);
    }

    private void backupPhysicalInfo(ObjectBundle ob, StringBuffer sb, MethodCallStatus mcs) {
        String METHOD = "backupPhysicalInfo";
        Trace.methodBegin(this, "backupPhysicalInfo");
        Tray[] ozTrays = ob.getTray();
        HashMap disks = this.getDiskMap(ob.getDrive());
        int count = ozTrays == null ? 0 : ozTrays.length;
        sb.append(XML_TOTAL_TRAYS_B);
        sb.append(this.getEncoded(count)).append(XML_TOTAL_TRAYS_E);
        for (int k = 0; k < count; ++k) {
            sb.append(XML_TRAY_B);
            sb.append(XML_IDX_B);
            sb.append(this.getEncoded(ozTrays[k].getTrayId())).append(XML_IDX_E);
            sb.append(XML_TYPE_B);
            String sType = ozTrays[k].getType().getValue() == 8 ? "FC" : "Unknown";
            sb.append(this.getEncoded(sType)).append(XML_TYPE_E);
            sb.append(XML_NUM_DRIVE_SLOTS_B);
            sb.append(this.getEncoded(ozTrays[k].getNumDriveSlots()));
            sb.append(XML_NUM_DRIVE_SLOTS_E);
            StringBuffer spares = new StringBuffer();
            String dCapacity = null;
            sb.append(XML_ACTIVE_DRIVES_B);
            String tok = Convert.bytesToStringRaw(ozTrays[k].getTrayRef().getRefToken());
            List td = (List)disks.get(tok);
            Iterator itr = td.iterator();
            while (itr.hasNext()) {
                Drive drv = (Drive)itr.next();
                String slot = new String(Integer.toString(ozTrays[k].getTrayId()) + "." + drv.getPhysicalLocation().getSlot());
                sb.append(this.getEncoded(slot));
                sb.append(" ");
                if (dCapacity == null) {
                    BigInteger capacity = BigInteger.valueOf(drv.getRawCapacity());
                    double d = capacity.doubleValue() / 1.073741824E9;
                    DecimalFormat df = new DecimalFormat("##0.000");
                    dCapacity = df.format(d) + "GB";
                }
                if (!drv.getHotSpare()) continue;
                spares.append(ozTrays[k].getTrayId()).append(".").append(drv.getPhysicalLocation().getSlot()).append(" ");
            }
            sb.append(XML_ACTIVE_DRIVES_E);
            sb.append(XML_DISK_CAPACITY_B);
            sb.append(this.getEncoded(dCapacity)).append(XML_DISK_CAPACITY_E);
            sb.append(XML_HOT_SPARE_DRIVES_B);
            sb.append(this.getEncoded(spares.toString())).append(XML_HOT_SPARE_DRIVES_E);
            sb.append(XML_TRAY_E);
        }
    }

    private HashMap getDiskMap(Drive[] drive) {
        HashMap<String, ArrayList<Drive>> disks = new HashMap<String, ArrayList<Drive>>();
        int dsize = drive == null ? 0 : drive.length;
        for (int i = 0; i < dsize; ++i) {
            if (drive[i].getStatus().getValue() == 6 || drive[i].getOffline()) continue;
            String tok = Convert.bytesToStringRaw(drive[i].getPhysicalLocation().getTrayRef().getRefToken());
            ArrayList<Drive> td = (ArrayList<Drive>)disks.get(tok);
            if (td == null) {
                td = new ArrayList<Drive>();
            }
            td.add(drive[i]);
            disks.put(tok, td);
        }
        return disks;
    }

    private boolean restorePools(Element array, String arrayWWN, MethodCallStatus mcs) throws Exception {
        String METHOD_NAME = "restorePools";
        Trace.methodBegin(this, "restorePools");
        boolean rc = true;
        Object ed = null;
        try {
            for (int i = 0; i < this._poolElements.size(); ++i) {
                String value;
                this.checkStop();
                ++this._totalItemsCreated;
                Element poolProp = (Element)this._poolElements.get(i);
                Properties props = new Properties();
                Element prop = XMLUtils.findElement(poolProp, XML_POOL_NAME);
                String poolName = this.getDecodedElementValue(prop);
                if ("Default".equals(poolName)) continue;
                props.setProperty(XML_NAME, poolName);
                prop = XMLUtils.findElement(poolProp, XML_POOL_DESC);
                if (prop != null && (value = this.getDecodedElementValue(prop)) != null) {
                    props.setProperty("description", value);
                }
                prop = XMLUtils.findElement(poolProp, XML_POOL_PROFILE_NAME);
                props.setProperty("profileName", this.getDecodedElementValue(prop));
                try {
                    this._poolMgr.create(props);
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, "restorePools", cme);
                    String msg = "failed to create pool " + poolName;
                    this.addError(mcs, poolName, msg, ErrorCode.ERROR_IMPORT_POOL_CREATE);
                    rc = false;
                }
            }
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)this, "restorePools", ex);
            this.addError(mcs, null, "Exception during pool restoration", ErrorCode.ERROR_IMPORT_POOL);
            return false;
        }
        return rc;
    }

    private boolean restoreProfiles(Element array, String arrayWWN, MethodCallStatus mcs) throws Exception {
        String METHOD_NAME = "restoreProfiles";
        Trace.methodBegin(this, "restoreProfiles");
        boolean rc = true;
        Element prop = null;
        List factoryProfiles = null;
        try {
            factoryProfiles = this._profileMgr.getItemList();
        }
        catch (ConfigMgmtException ce) {
            Trace.verbose((Object)this, "restoreProfiles", (Throwable)ce);
            this.addError(mcs, null, "Failed to get list of factory profiles", ErrorCode.ERROR_IMPORT_PROFILE);
            return false;
        }
        try {
            block18: for (int i = 0; i < this._profileElements.size(); ++i) {
                String name;
                this.checkStop();
                ++this._totalItemsCreated;
                Element prof = (Element)this._profileElements.get(i);
                prop = XMLUtils.findElement(prof, XML_FACTORY_PROFILE);
                String value = this.getDecodedElementValue(prop);
                if (!"no".equalsIgnoreCase(value)) {
                    boolean found = false;
                    prop = XMLUtils.findElement(prof, XML_PROFILE_NAME);
                    name = this.getDecodedElementValue(prop);
                    for (int p = 0; p < factoryProfiles.size(); ++p) {
                        ProfileInterface pi = (ProfileInterface)factoryProfiles.get(p);
                        if (!name.equalsIgnoreCase(pi.getName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                Properties props = new Properties();
                prop = XMLUtils.findElement(prof, XML_PROFILE_NAME);
                name = this.getDecodedElementValue(prop);
                props.setProperty(XML_NAME, name);
                prop = XMLUtils.findElement(prof, XML_PROFILE_DESC);
                String desc = this.getDecodedElementValue(prop);
                props.setProperty("description", desc);
                prop = XMLUtils.findElement(prof, XML_SEGMENT_SIZE);
                int segment = -1;
                value = this.getDecodedElementValue(prop).toUpperCase();
                if (value != null) {
                    try {
                        if (value.indexOf("K") != -1) {
                            value = value.substring(0, value.indexOf("K"));
                        }
                        segment = Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        String msg = "profile " + name + " has invalid segment size";
                        Trace.verbose((Object)this, "restoreProfiles", msg);
                        this.addError(mcs, name, msg, ErrorCode.ERROR_IMPORT_PROFILE_INVALID_SEG_SIZE);
                        rc = false;
                        continue;
                    }
                    switch (segment) {
                        case 4: {
                            segment = 0;
                            break;
                        }
                        case 8: {
                            segment = 1;
                            break;
                        }
                        case 16: {
                            segment = 2;
                            break;
                        }
                        case 32: {
                            segment = 3;
                            break;
                        }
                        case 64: {
                            segment = 4;
                            break;
                        }
                        case 128: {
                            segment = 5;
                            break;
                        }
                        case 256: {
                            segment = 6;
                            break;
                        }
                        case 512: {
                            segment = 7;
                            break;
                        }
                        default: {
                            String msg = "profile " + name + " has invalid segment size";
                            Trace.verbose((Object)this, "restoreProfiles", msg);
                            this.addError(mcs, name, msg, ErrorCode.ERROR_IMPORT_PROFILE_INVALID_SEG_SIZE);
                            rc = false;
                            continue block18;
                        }
                    }
                }
                props.setProperty("segmentSize", Integer.toString(segment));
                prop = XMLUtils.findElement(prof, XML_RAID_LEVEL);
                value = this.getDecodedElementValue(prop);
                value = value.substring(value.indexOf("RAID") + 5);
                props.setProperty("raidLevel", value);
                prop = XMLUtils.findElement(prof, XML_READ_AHEAD);
                value = this.getDecodedElementValue(prop);
                value = value.equals("on") ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                props.setProperty("readAheadEnabled", value);
                prop = XMLUtils.findElement(prof, XML_DRIVE_TYPE);
                int iDriveType = ProfileDataManager.getDriveTypeInt(this.getDecodedElementValue(prop));
                props.setProperty("driveType", Integer.toString(iDriveType));
                prop = XMLUtils.findElement(prof, XML_OPTIMAL_NUM_DRIVES);
                props.setProperty("numberOfDisks", this.getDecodedElementValue(prop));
                try {
                    this._profileMgr.create(props);
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, "restoreProfiles", cme);
                    String msg = "failed to create profile " + name;
                    this.addError(mcs, name, msg, ErrorCode.ERROR_IMPORT_PROFILE_CREATE);
                    rc = false;
                }
            }
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)this, "restoreProfiles", ex);
            this.addError(mcs, null, "Exception during profile restore", ErrorCode.ERROR_IMPORT_PROFILE);
            return false;
        }
        return rc;
    }

    private boolean setDrivesToDataRole(String arrayWWN, Drive[] ozDrives, MethodCallStatus mcs) {
        String METHOD_NAME = "setDrivesToDataRole";
        boolean retVal = false;
        String diskRef = null;
        try {
            for (int i = 0; i < ozDrives.length; ++i) {
                Drive drv = ozDrives[i];
                if (!drv.getHotSpare() || drv.getOffline() || drv.getStatus().getValue() != 1) continue;
                diskRef = Convert.bytesToStringRaw(drv.getDriveRef().getRefToken());
                Object vdiskRef = null;
                HashMap<String, String> refKey = new HashMap<String, String>(3);
                refKey.put("array", arrayWWN);
                refKey.put("diskRef", diskRef);
                refKey.put("volGroupRef", (String)vdiskRef);
                Properties props = new Properties();
                props.setProperty("role", Integer.toString(1));
                try {
                    this._diskMgr.modify(refKey, props);
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, "setDrivesToDataRole", cme);
                    this.addError(mcs, diskRef, "Failed to set disk role", ErrorCode.ERROR_IMPORT_VOLUME_DISK_ROLE);
                    retVal = false;
                }
            }
        }
        catch (Exception ex) {
            Trace.error((Object)this, "setDrivesToDataRole", (Throwable)ex);
            this.addError(mcs, diskRef, "Failed to set disk role", ErrorCode.ERROR_IMPORT_VOLUME_DISK_ROLE);
            retVal = false;
        }
        return retVal;
    }

    private boolean restoreSpares(String arrayWWN, Element array, Drive[] ozDrives, ObjectBundle ob, MethodCallStatus mcs) {
        String METHOD_NAME = "restoreSpares";
        String diskRef = null;
        boolean retVal = true;
        try {
            List trays = XMLUtils.listNamedChildElements(array, XML_TRAY);
            if (trays == null || trays.size() == 0) {
                this.addError(mcs, null, "Malformed tray xml", ErrorCode.ERROR_IMPORT_TRAY_MALFORMED_XML);
                retVal = false;
            }
            String slots = null;
            block6: for (int i = 0; i < trays.size(); ++i) {
                this.checkStop();
                Element tray = (Element)trays.get(i);
                Element prop = XMLUtils.findElement(tray, XML_HOT_SPARE_DRIVES);
                if (prop == null || (slots = this.getDecodedElementValue(prop)) == null || slots.length() < 3 || slots.indexOf(".") == -1) continue;
                int slotIdx = -1;
                Tray[] ozTrays = ob.getTray();
                HashMap disks = this.getDiskMap(ozDrives);
                slots = slots.trim();
                while (slots.indexOf(".") != -1) {
                    int dotIdx = slots.indexOf(".");
                    int trayIdx = Integer.parseInt(slots.substring(0, dotIdx));
                    if ((slots = slots.substring(dotIdx + 1)) == null || slots.length() == 0) continue block6;
                    int spaceIdx = slots.indexOf(" ");
                    if (spaceIdx == -1) {
                        slotIdx = Integer.parseInt(slots);
                    } else {
                        slotIdx = Integer.parseInt(slots.substring(0, spaceIdx));
                        slots = slots.substring(spaceIdx).trim();
                    }
                    String tok = null;
                    List td = null;
                    for (int j = 0; j < ozTrays.length; ++j) {
                        if (trayIdx != ozTrays[j].getTrayId()) continue;
                        tok = Convert.bytesToStringRaw(ozTrays[j].getTrayRef().getRefToken());
                        td = (List)disks.get(tok);
                        Iterator itr = td.iterator();
                        while (itr.hasNext()) {
                            Drive drv = (Drive)itr.next();
                            if (slotIdx != drv.getPhysicalLocation().getSlot()) continue;
                            if (drv.getHotSpare()) {
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException e) {
                                    break;
                                }
                            }
                            if (drv.getOffline() || drv.getStatus().getValue() != 1) break;
                            diskRef = Convert.bytesToStringRaw(drv.getDriveRef().getRefToken());
                            break;
                        }
                        if (diskRef != null) break;
                    }
                    if (diskRef == null) {
                        Trace.verbose((Object)this, "restoreSpares", "Unable to obtain the disk reference for the specified spare.");
                        continue;
                    }
                    Object vdiskRef = null;
                    HashMap<String, String> refKey = new HashMap<String, String>(3);
                    refKey.put("array", arrayWWN);
                    refKey.put("diskRef", diskRef);
                    refKey.put("volGroupRef", (String)vdiskRef);
                    Properties props = new Properties();
                    props.setProperty("role", Integer.toString(0));
                    try {
                        this._diskMgr.modify(refKey, props);
                    }
                    catch (ConfigMgmtException cme) {
                        Trace.error((Object)this, "restoreSpares", cme);
                        this.addError(mcs, diskRef, "Failed to modify disk", ErrorCode.ERROR_IMPORT_DISK_MODIFY);
                    }
                    diskRef = null;
                }
            }
        }
        catch (Exception e) {
            Trace.error((Object)this, "restoreSpares", (Throwable)e);
            this.addError(mcs, diskRef, "Failed to set disk role", ErrorCode.ERROR_IMPORT_VOLUME_DISK_ROLE);
            retVal = false;
        }
        return retVal;
    }

    private String getDiskRef(Tray[] ozTrays, Drive[] ozDrives, String tray, String disk) {
        HashMap disks = this.getDiskMap(ozDrives);
        int trayId = Integer.parseInt(tray);
        int diskId = Integer.parseInt(disk);
        String diskRef = null;
        block0: for (int j = 0; j < ozTrays.length; ++j) {
            if (trayId != ozTrays[j].getTrayId()) continue;
            String tok = Convert.bytesToStringRaw(ozTrays[j].getTrayRef().getRefToken());
            List td = (List)disks.get(tok);
            Iterator itr = td.iterator();
            while (itr.hasNext()) {
                Drive drv = (Drive)itr.next();
                if (diskId != drv.getPhysicalLocation().getSlot()) continue;
                if (drv.getHotSpare() || drv.getOffline() || !drv.getAvailable() || drv.getStatus().getValue() != 1) continue block0;
                diskRef = Convert.bytesToStringRaw(drv.getDriveRef().getRefToken());
                return diskRef;
            }
        }
        return diskRef;
    }

    private boolean restoreVolumes(Element array, String arrayWWN, MethodCallStatus mcs) throws Exception {
        String METHOD_NAME = "restoreVolumes";
        Trace.methodBegin(this, "restoreVolumes");
        boolean retVal = true;
        try {
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWWN);
            Drive[] ozDrives = ob.getDrive();
            Tray[] ozTrays = ob.getTray();
            retVal = this.setDrivesToDataRole(arrayWWN, ozDrives, mcs);
            retVal = this.restoreSpares(arrayWWN, array, ozDrives, ob, mcs);
            List vdisks = XMLUtils.listNamedChildElements(array, XML_VDISK);
            if (vdisks == null || vdisks.size() == 0) {
                return true;
            }
            HashMap<String, Map> poolMap = new HashMap<String, Map>();
            List pools = this._poolMgr.getItemList();
            for (int j = 0; j < pools.size(); ++j) {
                Pool pool = (Pool)pools.get(j);
                poolMap.put(pool.getName(), pool.getKey());
            }
            Element prop = null;
            String vdiskKey = null;
            for (int i = 0; i < vdisks.size(); ++i) {
                vdiskKey = null;
                Element vdisk = (Element)vdisks.get(i);
                List vols = XMLUtils.listNamedChildElements(vdisk, XML_VOLUME);
                if (vols == null || vols.size() == 0) continue;
                int numDisks = -1;
                prop = XMLUtils.findElement(vdisk, XML_NUMDRIVES);
                try {
                    numDisks = Integer.parseInt(this.getDecodedElementValue(prop));
                }
                catch (Exception e) {
                    this.addError(mcs, null, "Malformed VDisk XML", ErrorCode.ERROR_IMPORT_VDISK_MALFORMED_XML);
                    retVal = false;
                    continue;
                }
                prop = XMLUtils.findElement(vdisk, XML_PHYDRV);
                List trays = XMLUtils.listNamedChildElements(prop, XML_TRAY);
                StringBuffer listOfDiskKeys = null;
                for (int t = 0; t < trays.size(); ++t) {
                    Element tray = (Element)trays.get(t);
                    prop = XMLUtils.findElement(tray, XML_IDX);
                    String trayId = this.getDecodedElementValue(prop);
                    List disks = XMLUtils.listNamedChildElements(tray, XML_ACTIVE_DRIVES);
                    if (disks == null) continue;
                    for (int d = 0; d < disks.size(); ++d) {
                        Element disk = (Element)disks.get(d);
                        String diskId = this.getDecodedElementValue(disk);
                        String diskRef = this.getDiskRef(ozTrays, ozDrives, trayId, diskId);
                        if (diskRef == null) {
                            this.addError(mcs, null, "Unable to find disk", ErrorCode.ERROR_IMPORT_VOLUME_CREATE);
                            retVal = false;
                            continue;
                        }
                        HashMap<String, String> refKey = new HashMap<String, String>(3);
                        refKey.put("array", arrayWWN);
                        refKey.put("diskRef", diskRef);
                        if (listOfDiskKeys == null) {
                            listOfDiskKeys = new StringBuffer();
                        } else {
                            listOfDiskKeys.append(",");
                        }
                        listOfDiskKeys.append(Convert.keyToString(refKey));
                    }
                }
                for (int j = 0; j < vols.size(); ++j) {
                    this.checkStop();
                    Element vol = (Element)vols.get(j);
                    ++this._totalItemsCreated;
                    prop = XMLUtils.findElement(vol, XML_VOLUME_NAME);
                    String vName = this.getDecodedElementValue(prop);
                    prop = XMLUtils.findElement(vol, XML_VOLUME_TYPE);
                    String type = this.getDecodedElementValue(prop);
                    if (type != null && (type.equals("Snapshot") || type.equals("Repository"))) continue;
                    Properties props = new Properties();
                    boolean found = false;
                    prop = XMLUtils.findElement(vol, XML_POOL_NAME);
                    String poolName = this.getDecodedElementValue(prop);
                    if (poolName != null && poolMap.containsKey(poolName)) {
                        found = true;
                        props.setProperty("poolKey", Convert.keyToString((Map)poolMap.get(poolName)));
                    }
                    if (!found) {
                        this.addError(mcs, poolName, "No pool for volume " + vName, ErrorCode.ERROR_IMPORT_VOLUME_NO_POOL);
                    }
                    try {
                        prop = XMLUtils.findElement(vol, XML_VOLUME_SIZE);
                        String size = this.getDecodedElementValue(prop).toUpperCase();
                        if (size == null) {
                            retVal = false;
                            this.addError(mcs, vName, "malformed size xml", ErrorCode.ERROR_IMPORT_VOLUME_MALFORMED_XML);
                            continue;
                        }
                        BigInteger biSize = new BigInteger(size);
                        props.put("volumeSize", biSize);
                    }
                    catch (Exception ex) {
                        Trace.error((Object)this, "restoreVolumes", (Throwable)ex);
                        retVal = false;
                        this.addError(mcs, vName, "malformed size xml", ErrorCode.ERROR_IMPORT_VOLUME_MALFORMED_XML);
                        continue;
                    }
                    props.setProperty("volumeName", vName);
                    if (vdiskKey != null) {
                        props.setProperty("vdiskKey", vdiskKey);
                    } else if (listOfDiskKeys != null) {
                        props.setProperty("listOfDiskKeys", listOfDiskKeys.toString());
                    } else {
                        props.setProperty("numberOfDisks", Integer.toString(numDisks));
                    }
                    try {
                        this._volMgr.create(props);
                    }
                    catch (ConfigMgmtException cme) {
                        Trace.error((Object)this, "restoreVolumes", cme);
                        this.addError(mcs, vName, "failed to create volume", ErrorCode.ERROR_IMPORT_VOLUME_CREATE);
                        retVal = false;
                        continue;
                    }
                    List list = this._volMgr.getItemList();
                    if (list == null || list.size() == 0) {
                        Trace.error((Object)this, "restoreVolumes", "Unable to obtain the vdisk reference from the 1st volume.");
                        this.addError(mcs, vName, "failed to get volume", ErrorCode.ERROR_IMPORT_VOLUME_CREATE);
                        continue;
                    }
                    Volume v = null;
                    for (int k = 0; k < list.size(); ++k) {
                        v = (Volume)list.get(k);
                        if (!vName.equals(v.getName())) continue;
                        HashMap<String, String> key = new HashMap<String, String>(2);
                        key.put("array", arrayWWN);
                        key.put("vdiskRef", v.getVDiskReference());
                        key.put("vdiskName", v.getVdiskName());
                        vdiskKey = Convert.keyToString(key);
                        break;
                    }
                    Properties modProps = new Properties();
                    prop = XMLUtils.findElement(vol, XML_VOL_MOD_PRIORITY);
                    modProps.setProperty("modificationPriority", this.getDecodedElementValue(prop));
                    prop = XMLUtils.findElement(vol, XML_VOL_WRITE_CACHE);
                    modProps.setProperty("writeCache", this.getDecodedElementValue(prop));
                    prop = XMLUtils.findElement(vol, XML_VOL_WRITE_CACHE_MIRROR);
                    modProps.setProperty("writeCacheWithMirroring", this.getDecodedElementValue(prop));
                    prop = XMLUtils.findElement(vol, XML_VOL_WRITE_CACHE_BATTERY);
                    modProps.setProperty("writeCacheWithoutBatteries", this.getDecodedElementValue(prop));
                    prop = XMLUtils.findElement(vol, XML_VOL_DISK_SCRUBBING);
                    modProps.setProperty("diskScrubbing", this.getDecodedElementValue(prop));
                    prop = XMLUtils.findElement(vol, XML_VOL_DISK_SCRUBBING_REDUNDANCY);
                    modProps.setProperty("diskScrubbingWithRedundancy", this.getDecodedElementValue(prop));
                    prop = XMLUtils.findElement(vol, XML_ASSIGNMENT);
                    modProps.setProperty("controller", this.getDecodedElementValue(prop));
                    try {
                        Trace.verbose((Object)this, "restoreVolumes", "Modifying " + v.getKey());
                        this._volMgr.modify(v.getKey(), modProps);
                        continue;
                    }
                    catch (ConfigMgmtException cme) {
                        Trace.error((Object)this, "restoreVolumes", cme);
                        this.addError(mcs, v.getName(), "failed to modify vol", ErrorCode.ERROR_IMPORT_VOLUME_MODIFY);
                        retVal = false;
                    }
                }
            }
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "restoreVolumes", e);
            this.addError(mcs, null, "Errors while restoring volumes", ErrorCode.ERROR_IMPORT_VOLUME);
            retVal = false;
        }
        return retVal;
    }

    private boolean restorePartitions(Element array, String arrayWWN, MethodCallStatus mcs) throws Exception {
        String METHOD_NAME = "restorePartitions";
        Trace.methodBegin(this, "restorePartitions");
        boolean retVal = true;
        List ports = null;
        Element partition = null;
        Element prop = null;
        String value = null;
        Properties props = null;
        Object key = null;
        try {
            List top = XMLUtils.listNamedChildElements(array, XML_PARTITIONS);
            if (top == null || top.size() != 1) {
                this.addError(mcs, null, "Malformed Partition XML", ErrorCode.ERROR_IMPORT_PARTITION_MALFORMED_XML);
                return false;
            }
            List partitions = XMLUtils.listNamedChildElements((Element)top.get(0), XML_PARTITION);
            if (partitions == null || partitions.size() < 1) {
                this.addError(mcs, null, "Malformed Partition XML", ErrorCode.ERROR_IMPORT_PARTITION_MALFORMED_XML);
                return false;
            }
            block8: for (int i = 0; i < partitions.size(); ++i) {
                Element name;
                int j;
                partition = (Element)partitions.get(i);
                prop = XMLUtils.findElement(partition, XML_MAPPED_VIA_TYPE);
                value = this.getDecodedElementValue(prop);
                if ("Default_Group".equals(value) || "Host_Group".equals(value)) {
                    List groups = XMLUtils.listNamedChildElements(partition, XML_HOST_GROUP);
                    block9: for (j = 0; j < groups.size(); ++j) {
                        this.checkStop();
                        ++this._totalItemsCreated;
                        name = XMLUtils.findElement((Element)groups.get(j), XML_HOST_GROUP_NAME);
                        String hgName = this.getDecodedElementValue(name);
                        props = new Properties();
                        props.setProperty(XML_NAME, hgName);
                        try {
                            this._hostGroupMgr.create(props);
                        }
                        catch (ConfigMgmtException cme) {
                            Trace.error((Object)this, "restorePartitions", cme);
                            this.addError(mcs, hgName, "Failed to create host group", ErrorCode.ERROR_IMPORT_HOSTGROUP_CREATE);
                            retVal = false;
                            continue;
                        }
                        List hosts = XMLUtils.listNamedChildElements((Element)groups.get(j), XML_HOST);
                        if (hosts == null || hosts.size() < 1) continue;
                        String hostName = null;
                        for (int k = 0; k < hosts.size(); ++k) {
                            this.checkStop();
                            ++this._totalItemsCreated;
                            props = new Properties();
                            name = XMLUtils.findElement((Element)hosts.get(k), XML_HOST_NAME);
                            hostName = this.getDecodedElementValue(name);
                            if (hostName == null || hostName.length() == 0) continue;
                            props.setProperty(XML_NAME, hostName);
                            props.setProperty("hostGroupName", hgName);
                            try {
                                this._hostMgr.create(props);
                            }
                            catch (ConfigMgmtException cme) {
                                Trace.error((Object)this, "restorePartitions", cme);
                                this.addError(mcs, hostName, "Failed to create host", ErrorCode.ERROR_IMPORT_HOST_CREATE);
                                retVal = false;
                                continue;
                            }
                            ports = XMLUtils.listNamedChildElements((Element)hosts.get(k), XML_INITIATOR);
                            if (this.restoreInitiators(ports, hostName, mcs)) continue;
                            retVal = false;
                            continue block9;
                        }
                    }
                }
                if (!"Default_Group".equals(value) && !"Host".equals(value)) continue;
                List hosts = XMLUtils.listNamedChildElements(partition, XML_HOST);
                for (j = 0; j < hosts.size(); ++j) {
                    this.checkStop();
                    name = XMLUtils.findElement((Element)hosts.get(j), XML_HOST_NAME);
                    String hostName = this.getDecodedElementValue(name);
                    props = new Properties();
                    props.setProperty(XML_NAME, hostName);
                    try {
                        this._hostMgr.create(props);
                    }
                    catch (ConfigMgmtException cme) {
                        Trace.error((Object)this, "restorePartitions", cme);
                        this.addError(mcs, hostName, "Failed to create host", ErrorCode.ERROR_IMPORT_HOST_CREATE);
                        retVal = false;
                        continue;
                    }
                    ports = XMLUtils.listNamedChildElements((Element)hosts.get(j), XML_INITIATOR);
                    if (this.restoreInitiators(ports, hostName, mcs)) continue;
                    retVal = false;
                    continue block8;
                }
            }
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)this, "restorePartitions", ex);
            this.addError(mcs, null, "Exception during parition restoration", ErrorCode.ERROR_IMPORT_PARTITION_FAILURE);
            return false;
        }
        return retVal;
    }

    private boolean restoreInitiators(List ports, String hostName, MethodCallStatus mcs) throws Exception {
        boolean rc = true;
        if (ports == null || ports.size() < 1) {
            return true;
        }
        try {
            for (int i = 0; i < ports.size(); ++i) {
                this.checkStop();
                ++this._totalItemsCreated;
                Properties props = new Properties();
                Element name = XMLUtils.findElement((Element)ports.get(i), XML_INITIATOR_NAME);
                Element wwn = XMLUtils.findElement((Element)ports.get(i), XML_INITIATOR_WWN);
                Element hType = XMLUtils.findElement((Element)ports.get(i), XML_HOST_TYPE);
                props.setProperty(XML_NAME, this.getDecodedElementValue(name));
                props.setProperty("wwn", this.getDecodedElementValue(wwn));
                props.setProperty("hostName", hostName);
                props.setProperty("hostOSType", this.getDecodedElementValue(hType));
                try {
                    this._hostPortMgr.create(props);
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, "restoreInitiators", cme);
                    this.addError(mcs, hostName, "Failed to create host port", ErrorCode.ERROR_IMPORT_HOST_PORT_CREATE);
                    rc = false;
                }
            }
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)this, "restoreInitiators", ex);
            this.addError(mcs, null, "Exception during initiator restoration", ErrorCode.ERROR_IMPORT_PARTITION_FAILURE);
            return false;
        }
        return rc;
    }

    private boolean restoreMappings(Element array, String arrayWWN, MethodCallStatus mcs) throws Exception {
        String METHOD_NAME = "restoreMappings";
        Trace.methodBegin(this, "restoreMappings");
        boolean retVal = true;
        String volName = null;
        Element prop = null;
        String value = null;
        Properties props = null;
        try {
            List vdisks = XMLUtils.listNamedChildElements(array, XML_VDISK);
            if (vdisks == null || vdisks.size() == 0) {
                return true;
            }
            List volumes = this._volMgr.getItemList();
            List hosts = this._hostMgr.getItemList();
            List groups = this._hostGroupMgr.getItemList();
            for (int i = 0; i < vdisks.size(); ++i) {
                Element vdisk = (Element)vdisks.get(i);
                List vols = XMLUtils.listNamedChildElements(vdisk, XML_VOLUME);
                if (vols == null || vols.size() == 0) continue;
                for (int j = 0; j < vols.size(); ++j) {
                    Element vol = (Element)vols.get(j);
                    List mappings = XMLUtils.listNamedChildElements(vol, XML_MAPPING);
                    if (mappings == null || mappings.size() == 0) continue;
                    prop = XMLUtils.findElement(vol, XML_VOLUME_NAME);
                    volName = this.getDecodedElementValue(prop);
                    for (int k = 0; k < mappings.size(); ++k) {
                        this.checkStop();
                        ++this._totalItemsCreated;
                        try {
                            int l;
                            Element map = (Element)mappings.get(k);
                            prop = XMLUtils.findElement(map, XML_PARTITION_NAME);
                            value = this.getDecodedElementValue(prop);
                            prop = XMLUtils.findElement(map, XML_LUN);
                            int lun = Integer.parseInt(this.getDecodedElementValue(prop));
                            Host h = null;
                            HostGroup hg = null;
                            VolumeInterface v = null;
                            String hkey = null;
                            for (l = 0; l < hosts.size(); ++l) {
                                h = (Host)hosts.get(l);
                                if (!h.getName().equals(value)) continue;
                                hkey = h.getKeyAsString();
                                break;
                            }
                            if (hkey == null) {
                                for (l = 0; l < groups.size(); ++l) {
                                    hg = (HostGroup)groups.get(l);
                                    if (!hg.getName().equals(value)) continue;
                                    hkey = hg.getKeyAsString();
                                    break;
                                }
                            }
                            String volkey = null;
                            for (int l2 = 0; l2 < volumes.size(); ++l2) {
                                v = (VolumeInterface)volumes.get(l2);
                                if (!v.getName().equals(volName)) continue;
                                volkey = v.getKeyAsString();
                                break;
                            }
                            if (volkey == null) {
                                this.addError(mcs, volName, "missing mapped volume", ErrorCode.ERROR_IMPORT_MAPPING_MISSING_VOL);
                                retVal = false;
                                continue;
                            }
                            props = new Properties();
                            props.setProperty("volumeKey", volkey);
                            if (hkey != null) {
                                props.setProperty("hostOrHostGroupKey", hkey);
                            }
                            props.setProperty(XML_LUN, Integer.toString(lun));
                            try {
                                this._mapMgr.create(props);
                            }
                            catch (ConfigMgmtException e) {
                                this.addError(mcs, volName, "Failed to create map", ErrorCode.ERROR_IMPORT_MAPPING_CREATE);
                                retVal = false;
                            }
                            continue;
                        }
                        catch (ConfigMgmtException ex) {
                            Trace.error((Object)this, "restoreMappings", ex);
                            this.addError(mcs, volName, "Exception during mapping restore", ErrorCode.ERROR_IMPORT_MAPPING_FAILURE);
                            retVal = false;
                        }
                    }
                }
            }
        }
        catch (ConfigMgmtException ex) {
            this.addError(mcs, volName, "Exception during mapping restore", ErrorCode.ERROR_IMPORT_MAPPING_FAILURE);
            Trace.error((Object)this, "restoreMappings", ex);
            return false;
        }
        return retVal;
    }

    private boolean restoreArrayInfo(Element array, StorageArray sa, MethodCallStatus mcs) throws Exception {
        String METHOD_NAME = "restoreArrayInfo";
        Trace.methodBegin(this, "restoreArrayInfo");
        boolean retVal = true;
        List params = null;
        Properties props = null;
        Element prop = null;
        String value = null;
        try {
            int ms;
            int days;
            int cfa;
            params = XMLUtils.listNamedChildElements(array, XML_ARRAY_PARAM);
            if (params == null || params.size() != 1) {
                this.addError(mcs, null, "No array params", ErrorCode.ERROR_IMPORT_ARRAY_MALFORMED_XML);
                return false;
            }
            prop = XMLUtils.findElement((Element)params.get(0), XML_CACHE_BLOCK_SIZE);
            value = this.getDecodedElementValue(prop).toUpperCase();
            if (value != null) {
                try {
                    int bs;
                    if (value.indexOf("K") != -1) {
                        value = value.substring(0, value.indexOf("K"));
                    }
                    if ((bs = Integer.parseInt(value)) <= 16) {
                        bs *= 1024;
                    }
                    if ((bs == 4096 || bs == 16384) && bs != sa.getCacheBlockSize()) {
                        props = new Properties();
                        props.setProperty("cacheFlushThreshold", Integer.toString(sa.getCacheFlushThreshold()));
                        props.setProperty("cacheFlushAmount", Integer.toString(sa.getCacheFlushAmount()));
                        props.setProperty("cacheBlockSize", Integer.toString(bs));
                    }
                }
                catch (NumberFormatException nfe) {
                    Trace.error((Object)this, "restoreArrayInfo", "Bad Cache Block Size: " + value);
                }
            }
            if ((value = this.getDecodedElementValue(prop = XMLUtils.findElement((Element)params.get(0), XML_CACHE_FLUSH_THRESHOLD))) != null) {
                try {
                    int cft = Integer.parseInt(value);
                    if (cft >= 0 && cft <= 100 && cft != sa.getCacheFlushThreshold()) {
                        if (props == null) {
                            props = new Properties();
                            props.setProperty("cacheBlockSize", Integer.toString(sa.getCacheBlockSize()));
                            props.setProperty("cacheFlushAmount", Integer.toString(sa.getCacheFlushAmount()));
                        }
                        props.setProperty("cacheFlushThreshold", Integer.toString(cft));
                    }
                }
                catch (NumberFormatException nfe) {
                    Trace.error((Object)this, "restoreArrayInfo", "Bad Cache Block Size: " + value);
                }
            }
            if ((value = this.getDecodedElementValue(prop = XMLUtils.findElement((Element)params.get(0), XML_CACHE_FLUSH_AMOUNT))) != null && (cfa = Integer.parseInt(value)) >= 0 && cfa <= 100 && cfa != sa.getCacheFlushAmount()) {
                if (props == null) {
                    props = new Properties();
                    props.setProperty("cacheBlockSize", Integer.toString(sa.getCacheBlockSize()));
                    props.setProperty("cacheFlushThreshold", Integer.toString(sa.getCacheFlushThreshold()));
                }
                props.setProperty("cacheFlushAmount", Integer.toString(cfa));
            }
            if (props == null) {
                props = new Properties();
            }
            prop = XMLUtils.findElement((Element)params.get(0), XML_DEF_HOST_PORT_TYPE);
            props.setProperty("defaultHostType", this.getDecodedElementValue(prop));
            prop = XMLUtils.findElement((Element)params.get(0), XML_MEDIA_SCAN);
            value = this.getDecodedElementValue(prop);
            if (value != null && (days = Integer.parseInt(value)) >= 0 && days != sa.getMediaScanPeriod()) {
                props.setProperty("mediaScanPeriod", Integer.toString(days));
            }
            if ((value = this.getDecodedElementValue(prop = XMLUtils.findElement((Element)params.get(0), XML_FAILOVER_ALERT_DELAY))) != null && (ms = Integer.parseInt(value)) >= 0 && ms != sa.getFailOverAlertDelay()) {
                props.setProperty("failOverAlertDelay", Integer.toString(ms));
            }
            this.checkStop();
            this._arrayMgr.modify(sa.getKey(), props);
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)this, "restoreArrayInfo", ex);
            this.addError(mcs, this._originalName, "Failed to restore array settings", ErrorCode.ERROR_IMPORT_ARRAY_FAILURE);
            retVal = false;
        }
        return retVal;
    }

    private boolean restoreArrayName(StorageArray sa, String originalName, MethodCallStatus mcs) throws Exception {
        String METHOD_NAME = "restoreArrayName";
        Trace.methodBegin(this, "restoreArrayName");
        try {
            Properties props = new Properties();
            props.setProperty(XML_NAME, originalName);
            this._arrayMgr.modify(sa.getKey(), props);
        }
        catch (ConfigMgmtException ex) {
            Trace.error((Object)this, "restoreArrayName", ex);
            this.addError(mcs, originalName, "Failed to restore array name", ErrorCode.ERROR_IMPORT_ARRAY_FAILURE);
            return false;
        }
        return true;
    }

    private boolean validatePremiums(Element importarray, MethodCallStatus mcs) {
        boolean rc = true;
        try {
            String xmlPremium = null;
            List features = XMLUtils.listNamedChildElements(importarray, XML_PREMIUM_FEATURES);
            if (features == null || features.size() != 1) {
                this.addError(mcs, null, "Malformed premium XML", ErrorCode.ERROR_IMPORT_PREMIUM_MALFORMED_XML);
                return false;
            }
            List targetFeatures = this._premMgr.getItemList();
            List premiums = XMLUtils.listNamedChildElements((Element)features.get(0), XML_PREMIUM_NAME);
            for (int i = 0; i < premiums.size(); ++i) {
                Element prop = (Element)premiums.get(i);
                String value = this.getDecodedElementValue(prop);
                if (value == null || value.indexOf("StorageDomain") == -1) continue;
                xmlPremium = value.trim();
                boolean found = false;
                for (int j = 0; j < targetFeatures.size(); ++j) {
                    PremiumFeatures prem = (PremiumFeatures)targetFeatures.get(j);
                    if (!prem.getName().equals(xmlPremium)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                rc = false;
                this.addError(mcs, xmlPremium, "Unsupported premium feature", ErrorCode.ERROR_IMPORT_VALIDATE_PREMIUM_FAILED);
            }
        }
        catch (Exception e) {
            Trace.error((Object)this, "validatePremiums", (Throwable)e);
            this.addError(mcs, null, "Exception while validating premium features", ErrorCode.ERROR_IMPORT_VALIDATE_PREMIUM);
            return false;
        }
        return rc;
    }

    private boolean validatePhysical(Element array, Element target, MethodCallStatus mcs) {
        try {
            int xmlTrayCount = 0;
            int arrayTrayCount = 0;
            Element prop = XMLUtils.findElement(array, XML_TOTAL_TRAYS);
            if (prop == null) {
                this.addError(mcs, null, "Malformed Tray XML", ErrorCode.ERROR_IMPORT_TRAY_MALFORMED_XML);
                return false;
            }
            xmlTrayCount = Integer.parseInt(this.getDecodedElementValue(prop));
            prop = XMLUtils.findElement(target, XML_TOTAL_TRAYS);
            if (prop == null) {
                this.addError(mcs, null, "Misconfigured Target trays", ErrorCode.ERROR_IMPORT_TARGET_TRAY_MISCONFIGURED);
                return false;
            }
            arrayTrayCount = Integer.parseInt(this.getDecodedElementValue(prop));
            if (xmlTrayCount > arrayTrayCount) {
                this.addError(mcs, null, "Target has fewer trays than XML", ErrorCode.ERROR_IMPORT_TRAYS_INCOMPATIBLE);
                return false;
            }
            List xmlTrays = XMLUtils.listNamedChildElements(array, XML_TRAY);
            if (xmlTrays == null || xmlTrays.size() == 0) {
                this.addError(mcs, null, "Malformed Tray XML", ErrorCode.ERROR_IMPORT_TRAY_MALFORMED_XML);
                return false;
            }
            List arrTrays = XMLUtils.listNamedChildElements(target, XML_TRAY);
            if (arrTrays == null || arrTrays.size() == 0) {
                this.addError(mcs, null, "Misconfigured Target trays", ErrorCode.ERROR_IMPORT_TARGET_TRAY_MISCONFIGURED);
                return false;
            }
            boolean found = false;
            for (int i = 0; i < xmlTrays.size(); ++i) {
                float f2;
                String value2;
                String value1;
                Element prop2;
                found = false;
                Element arrTray = null;
                Element xmlTray = (Element)xmlTrays.get(i);
                prop = XMLUtils.findElement(xmlTray, XML_IDX);
                int xmlIdx = Integer.parseInt(this.getDecodedElementValue(prop));
                for (int j = 0; j < arrTrays.size(); ++j) {
                    arrTray = (Element)arrTrays.get(j);
                    prop = XMLUtils.findElement(arrTray, XML_IDX);
                    int arrIdx = Integer.parseInt(this.getDecodedElementValue(prop));
                    if (xmlIdx != arrIdx) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.addError(mcs, null, "Target has fewer trays than XML", ErrorCode.ERROR_IMPORT_TRAYS_INCOMPATIBLE);
                    return false;
                }
                Element prop1 = XMLUtils.findElement(xmlTray, XML_TYPE);
                if (!this.isEqual(prop1, prop2 = XMLUtils.findElement(arrTray, XML_TYPE))) {
                    this.addError(mcs, null, "Invalid target tray type", ErrorCode.ERROR_IMPORT_TRAYS_INCOMPATIBLE);
                    return false;
                }
                prop1 = XMLUtils.findElement(xmlTray, XML_ACTIVE_DRIVES);
                if (!this.isEqual(prop1, prop2 = XMLUtils.findElement(arrTray, XML_ACTIVE_DRIVES))) {
                    value1 = this.getDecodedElementValue(prop1);
                    value2 = this.getDecodedElementValue(prop2);
                    if (!value2.startsWith(value1)) {
                        String drive = null;
                        found = true;
                        value1 = value1.trim();
                        while (value1.indexOf(".") != -1) {
                            int end = value1.indexOf(" ");
                            drive = end == -1 ? value1 : value1.substring(0, end);
                            if (value2.indexOf(drive) == -1) {
                                found = false;
                                break;
                            }
                            int start = value1.indexOf(drive) + drive.length() + 1;
                            if (value1.length() <= start) break;
                            value1 = value1.substring(start);
                        }
                        if (!found) {
                            this.addError(mcs, null, "Invalid active drives", ErrorCode.ERROR_IMPORT_TRAYS_INCOMPATIBLE);
                            return false;
                        }
                    }
                }
                if (this.isEqual(prop1 = XMLUtils.findElement(xmlTray, XML_DISK_CAPACITY), prop2 = XMLUtils.findElement(arrTray, XML_DISK_CAPACITY))) continue;
                value1 = this.getDecodedElementValue(prop1);
                value2 = this.getDecodedElementValue(prop2);
                if (value1.indexOf("GB") == -1 || value2.indexOf("GB") == -1) {
                    this.addError(mcs, null, "Incompatible drive sizes", ErrorCode.ERROR_IMPORT_TRAYS_INCOMPATIBLE);
                    return false;
                }
                value1 = value1.substring(0, value1.indexOf("GB"));
                value2 = value2.substring(0, value2.indexOf("GB"));
                float f1 = new Float(value1).floatValue();
                if (!(f1 > (f2 = new Float(value2).floatValue()))) continue;
                this.addError(mcs, null, "Incompatible drive sizes", ErrorCode.ERROR_IMPORT_TRAYS_INCOMPATIBLE);
                return false;
            }
        }
        catch (Exception e) {
            Trace.error((Object)this, "validatePhysical", (Throwable)e);
            this.addError(mcs, null, "Exception while validating physical", ErrorCode.ERROR_IMPORT_VALIDATE_PHYSICAL_FAILED);
            return false;
        }
        return true;
    }

    private boolean isEqual(Element prop1, Element prop2) {
        String value1 = this.getDecodedElementValue(prop1);
        String value2 = this.getDecodedElementValue(prop2);
        return value1 == null || value2 == null || value1.trim().equals(value2.trim());
    }

    private void addError(MethodCallStatus mcs, String object, String msg, ErrorCode error) {
        ErrorDescriptor ed = new ErrorDescriptor(error);
        String[] p = new String[]{object};
        ed.setI18nParams(p);
        ed.setMsg(msg);
        mcs.addErrorDescriptor(ed);
    }

    private static interface PartitionTypes {
        public static final String DEFAULT = "default";
        public static final String OTHER = "other";
        public static final String ALL = "all";
    }

    private static interface MappedProps {
        public static final String DEFAULT_GROUP = "Default_Group";
        public static final String HOST_GROUP = "Host_Group";
        public static final String HOST = "Host";
    }
}

