/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3.RemoteServiceAccessPoint;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.FeatureNotSupportedException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.TooManyCIMInstanceException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapUint8ToInt;
import com.sun.netstorage.array.mgmt.cfg.core.impl.mr3.InvocationHelper;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobLink;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.QueuedPoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.m1m2.ManageT4sM1M2;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.CloneT4JobCompletion;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.FiberChannelPort;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.HandleResetLabelsWorker;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageArraySpares;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.RaidGroup;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray;
import com.sun.netstorage.array.mgmt.cfg.util.ArrayFeatures;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;

public class T4
implements T4Interface,
Constants.Exceptions,
Constants.ClusterSettingPropertyValues,
Constants.OperationalStatusValues {
    private ConfigContext context;
    private CIMOMHandleWrapper cimClient;
    private ArrayList trays;
    private ArrayList raidGroups;
    private String name;
    private String clusterName;
    private String clusterSerialNum;
    private String description;
    private int healthStatus;
    private int readaheadMode = -1;
    private int blockSize = -1;
    private int diskReconRate = -1;
    private String cacheMode = null;
    private String failoverMode = null;
    private String ondg = null;
    private CIMInstance t4CimInstance;
    private CIMObjectPath t4CimObjPath;
    private CIMInstance clusterSettingCim;
    private int connectivityStatus = 2;
    private boolean connectivityStatusLoaded = false;
    private Collection mapClusterElementList;
    private Collection mapClusterSettingElementList;
    private boolean isClusterSettingLoaded = false;
    private FiberChannelPort fiberChannelPort;
    private QueuedPoolData m_queuedPoolData;
    private ManageArraySpares manageArraySpares = null;
    private static final String[] clusterSettingProplist = new String[]{"SystemName", "SystemCreationClassName", "CreationClassName", "SettingID", "SegmentSize", "ReadAheadMode", "ReconRate", "CacheMode", "FailoverMode", "DiskScrubber", "ONDGMode"};
    private int arrayConfigurationType = -1;
    private String diskScrubber;
    private String firmwareVersion;
    private int major;
    private int minor;
    private int patch;
    private int maxDisksAvailWithRedun = 0;
    private int maxDisksAvailNoRedun = 0;
    private boolean hasConfiguredStorage = true;
    private int enabledState = 0;
    private int numControllerTrays = 0;
    private int numExpansionTrays = 0;
    int maxVolumes = -1;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$T4;

    public String getOndgMode() {
        return this.ondg;
    }

    public void setOndgMode(String argOndg) throws FeatureNotSupportedException {
        if (argOndg != null && "befit".equals(argOndg) && !this.isFeatureSupported(5)) {
            String message = "Cannot set ondg mode to befit in array firmware version " + this.getFirmwareVersion();
            Trace.verbose((Object)this, "setOndgMode", message);
            throw new FeatureNotSupportedException("FEATURE_NOT_SUPPORTED", message);
        }
        this.ondg = argOndg;
    }

    public T4() {
        Trace.constructor(this);
    }

    public void setConfigContext(ConfigContext ctx) throws ConfigMgmtException {
        Trace.methodBegin(this, "setConfigContext");
        this.init(ctx);
    }

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.cimClient = context.getClient();
        if (this.cimClient == null) {
            Trace.verbose((Object)this, "init", "Config context returned a NULL CIMOMHandleWrapper in T4 object!!!");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null CIMOMHandleWrapper error.");
        }
    }

    public ConfigContext getConfigContext() {
        return this.context;
    }

    public void powerUp() throws ConfigMgmtException {
        Trace.methodBegin(this, "powerUp");
        this.power(8);
    }

    public void shutdown() throws ConfigMgmtException {
        Trace.methodBegin(this, "shutdown");
        this.power(15);
    }

    public void power(int powerLevel) throws ConfigMgmtException {
        Trace.methodBegin(this, "power called with powerLevel " + powerLevel);
        try {
            Vector<UnsignedInt16> values = new Vector<UnsignedInt16>(1);
            values.addElement(new UnsignedInt16(powerLevel));
            this.getInstance().setProperty("OperationalStatus", new CIMValue(values, new CIMDataType(16)));
            String[] proplist = new String[]{"OperationalStatus"};
            Trace.verbose((Object)this, "power", "T4: " + this.name + " being powered to level " + powerLevel);
            this.cimClient.setInstance(this.t4CimObjPath, this.getInstance(), false, proplist);
            Trace.verbose((Object)this, "power", "T4:  set instance" + this.getInstance());
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "power", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (CIMException ce) {
            Trace.verbose((Object)this, "shutdown", "Set Property Failed.");
            throw new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "Set Property Failed.", (Exception)((Object)ce));
        }
    }

    public void reboot() throws ConfigMgmtException {
        Trace.methodBegin(this, "reboot");
        try {
            this.updateClusterStatus(1, "Rebooting");
            Trace.verbose((Object)this, "reboot", "Array: " + this.name + " is about to be reset!");
        }
        catch (IllegalArgumentException iae) {
            Trace.verbose((Object)this, "reboot", (Throwable)iae);
            new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "Exception while rebooting the array.", iae);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "reboot", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public void resetLabels(boolean waitUntilFinished) throws ConfigMgmtException {
        block7: {
            Trace.methodBegin(this, "resetLabels");
            try {
                String oldGateway = null;
                if (!this.isFeatureSupported(6) && Repository.getRepository().getConfigInteger() < 3) {
                    oldGateway = this.getCurrentGateway();
                    Trace.verbose((Object)this, "resetLabels", "Have old gateway: " + oldGateway);
                }
                this.updateClusterStatus(1, "Resetting Labels");
                Trace.verbose((Object)this, "resetLabels", "On the array: " + this.name + " we will run 'boot -w'!");
                if (this.isFeatureSupported(6)) break block7;
                HandleResetLabelsWorker w = new HandleResetLabelsWorker(this.context, this.getClusterName(), this.getName(), oldGateway);
                w.start();
                if (!waitUntilFinished) break block7;
                try {
                    Trace.verbose((Object)this, "resetLabels", "Waiting until account is cleaned up after reboot.");
                    w.join();
                    Trace.verbose((Object)this, "resetLabels", "Account cleanup is finished.");
                }
                catch (InterruptedException ie) {
                    Trace.verbose((Object)this, "resetLabels", "Got interrupted waiting for account cleanup.");
                }
                if (w.getRuntimeException() != null) {
                    Trace.verbose((Object)this, "resetLabels", "Encountered exception while fixing account.");
                    throw w.getRuntimeException();
                }
            }
            catch (IllegalArgumentException iae) {
                Trace.verbose((Object)this, "resetLabels", (Throwable)iae);
                throw new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "Exception when resetting the labels on the array.", iae);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "resetLabels", "Failed: " + cme.getMessage());
                throw cme;
            }
        }
    }

    public void refreshProviderCache() throws ConfigMgmtException {
        Trace.methodBegin(this, "refreshProviderCache");
        this.updateClusterStatus(1, "Refresh");
        Trace.verbose((Object)this, "refreshProviderCache", "We will refresh cache for the array: " + this.name);
        this.reload();
    }

    private void updateClusterStatus(int operationalStatus, String otherStatuDescriptions) throws ConfigMgmtException {
        Trace.methodBegin(this, "updateClusterStatus");
        Vector<UnsignedInt16> statusValues = new Vector<UnsignedInt16>(1);
        statusValues.addElement(new UnsignedInt16(operationalStatus));
        Vector<String> otherStatusValues = new Vector<String>(1);
        otherStatusValues.addElement(otherStatuDescriptions);
        try {
            this.t4CimInstance.setProperty("OperationalStatus", new CIMValue(statusValues));
            this.t4CimInstance.setProperty("StatusDescriptions", new CIMValue(otherStatusValues));
        }
        catch (CIMException ce) {
            Trace.verbose((Object)this, "updateClusterStatus", "Set Property Failed.");
            throw new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "Set Property Failed.", (Exception)((Object)ce));
        }
        this.cimClient.setInstance(this.t4CimObjPath, this.t4CimInstance);
    }

    public synchronized void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        Trace.verbose((Object)this, "reload", "Resetting instance variables to initial state!!");
        this.trays = null;
        this.raidGroups = null;
        this.name = null;
        this.clusterName = null;
        this.clusterSerialNum = null;
        this.description = null;
        this.healthStatus = 0;
        this.readaheadMode = -1;
        this.blockSize = -1;
        this.diskReconRate = -1;
        this.cacheMode = null;
        this.failoverMode = null;
        this.clusterSettingCim = null;
        this.mapClusterSettingElementList = null;
        this.isClusterSettingLoaded = false;
        this.arrayConfigurationType = -1;
        this.diskScrubber = null;
        this.manageArraySpares = null;
        this.m_queuedPoolData = null;
        this.maxVolumes = -1;
        this.connectivityStatusLoaded = false;
        this.ondg = null;
        this.enabledState = 0;
        this.numControllerTrays = 0;
        this.numExpansionTrays = 0;
        this.maxDisksAvailWithRedun = 0;
        this.maxDisksAvailNoRedun = 0;
        this.hasConfiguredStorage = true;
        this.reloadCluster();
        this.fiberChannelPort = null;
    }

    public MethodCallStatus cloneFrom(T4Interface sourceT4) throws ConfigMgmtException {
        Trace.methodBegin(this, "cloneFrom");
        if (sourceT4 == null) {
            Trace.verbose((Object)this, "cloneFrom", "Source T4 is null!!!");
            throw new ConfigMgmtException("ARRAY_DUPLICATE_FROM_SOURCE_ERROR", "NULL PARAMETER.");
        }
        Trace.verbose((Object)this, "cloneFrom", "Will attempt duplicate array IP: " + sourceT4.getClusterName() + " onto array at IP: " + this.clusterName);
        if (!this.isDuplicateCandidate(sourceT4)) {
            Trace.error((Object)this, "cloneFrom", "Source and Target T4s are not compatible!");
            throw new ConfigMgmtException("ARRAY_DUPLICATE_FROM_SOURCE_ERROR", "Duplicate array received incompatible source and destination arrays.");
        }
        String sourceT4Name = this.copyAndSaveT4Properties(sourceT4);
        this.reload();
        Trace.verbose((Object)this, "cloneFrom", "Looping through each Tray in this T4 and calling its cloneFrom() to clone them!!");
        MethodCallStatus returnStatus = new MethodCallStatus();
        ArrayList completeTasks = new ArrayList();
        try {
            int i;
            ArrayList sourceTrays = (ArrayList)sourceT4.getTrays();
            List myTrays = this.getTrays();
            boolean isErrorReturnCode = false;
            ArrayList jobLinks = new ArrayList();
            int myTraysSize = myTrays.size();
            for (i = 0; i < myTraysSize; ++i) {
                Trace.verbose((Object)this, "cloneFrom", "Cloning Tray number " + i + " in T4!!");
                returnStatus = ((Tray)myTrays.get(i)).cloneFrom((Tray)sourceTrays.get(i), jobLinks, sourceT4Name);
                completeTasks.addAll(returnStatus.getCompletionTasks());
                int returnCode = returnStatus.getReturnCode();
                Trace.verbose((Object)this, "cloneFrom", "Return code from Tray's cloneFrom(): " + returnCode);
            }
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "cloneFrom", "Calling InvocationHelper scheduleTasks() with: " + jobLinks.size() + " job Links");
                for (i = 0; i < jobLinks.size(); ++i) {
                    JobLink jl = (JobLink)jobLinks.get(i);
                    Trace.verbose((Object)this, "cloneFrom", "have JobLink has embedded Job: " + jl.getObjectPath());
                }
            }
            CloneT4JobCompletion cloneT4JobCompletion = new CloneT4JobCompletion(sourceT4.getName(), this.getName());
            cloneT4JobCompletion.addPrerequisiteTasks(completeTasks);
            InvocationHelper.scheduleTasks(this.context, jobLinks, cloneT4JobCompletion);
        }
        catch (ConfigMgmtException ce) {
            Trace.verbose((Object)this, "cloneFrom", "Error occurred while creating RaidGroups in Trays");
            throw new ConfigMgmtException("ARRAY_DUPLICATE_FROM_SOURCE_ERROR", "An error occurred while duplicating array.");
        }
        return returnStatus;
    }

    private String copyAndSaveT4Properties(T4Interface sourceT4) throws ConfigMgmtException {
        Trace.verbose((Object)this, "copyAndSaveT4Properties", "In Target T4: Setting T4 properties from Source T4!!");
        this.description = sourceT4.getDescription();
        this.blockSize = sourceT4.getBlockSize();
        this.readaheadMode = sourceT4.getReadaheadMode();
        this.failoverMode = sourceT4.getFailoverMode();
        this.cacheMode = sourceT4.getCacheMode();
        this.diskReconRate = sourceT4.getDiskReconRate();
        String sourceT4Name = sourceT4.getName();
        if (this.isFeatureSupported(1)) {
            this.setDiskScrubbing(sourceT4.isDiskScrubbing());
        }
        if (this.isFeatureSupported(3)) {
            this.setAhsPoolSize(0);
        }
        this.save();
        return sourceT4Name;
    }

    public void save() throws ConfigMgmtException {
        MethodCallStatus mcs;
        Trace.methodBegin(this, "save");
        Trace.verbose((Object)this, "save", "T4 properties are now being saved....");
        if (this.clusterSettingCim == null) {
            this.getCIMClusterSetting();
        }
        if (this.mapClusterSettingElementList == null) {
            this.generateT4ClusterSettingMapElements();
        }
        if (Trace.isTraceEnabled(this)) {
            this.traceT4Props();
        }
        if (this.manageArraySpares != null && (mcs = this.manageArraySpares.save()).getReturnCode() != 0) {
            ConfigMgmtException cme = new ConfigMgmtException("arrayhotsparepool.save.error", "Original error was:" + mcs.getReturnCode());
            throw cme;
        }
        CIMObjectWrapper.save(this, this.mapClusterSettingElementList, this.clusterSettingCim, this.cimClient);
        CIMObjectWrapper.save(this, this.mapClusterElementList, this.t4CimInstance, this.cimClient);
        Trace.verbose((Object)this, "save", "Saving T4 properties is done!!");
    }

    public synchronized String getName() {
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            Trace.verbose((Object)this, "getName", "Trying to resolve IP address....");
            this.name = IPUtil.lookUpHostName(this.clusterName);
            Repository.getRepository().storeIPAddress(this.name, this.clusterName);
        }
        return this.name;
    }

    public String getClusterName() {
        Trace.methodBegin(this, "getName");
        return this.clusterName;
    }

    public String getClusterSerialNum() {
        Trace.methodBegin(this, "getClusterSerialNum");
        return this.clusterSerialNum;
    }

    public String getDescription() {
        Trace.methodBegin(this, "getDescription");
        return this.description;
    }

    public synchronized int getHealthStatus() throws ConfigMgmtException {
        Trace.methodBegin(this, "getHealthStatus");
        Trace.verbose((Object)this, "getHealthStatus", "T4 Health Status = " + this.healthStatus);
        if (this.healthStatus == 1) {
            Trace.verbose((Object)this, "getHealthStatus", "OperationalStatus value is Other");
            CIMValue otherStatusValue = this.t4CimInstance.getProperty("StatusDescriptions").getValue();
            if (otherStatusValue != null && otherStatusValue.getValue() != null) {
                String otherStatus = (String)((Vector)otherStatusValue.getValue()).get(0);
                Trace.verbose((Object)this, "getHealthStatus", "OtherStatusDescription value is: " + otherStatus);
                if ("Rebooting".equals(otherStatus)) {
                    this.healthStatus = 101;
                } else if ("Resetting Labels".equals(otherStatus)) {
                    this.healthStatus = 102;
                } else if ("Invalid Configuration".equals(otherStatus)) {
                    this.healthStatus = 103;
                }
            }
        }
        return this.healthStatus;
    }

    public synchronized int getDiskReconRate() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getDiskReconRate");
        if (this.diskReconRate == -1) {
            Trace.verbose((Object)this, "getDiskReconRate", "Calling loadClusterSettingProperties() to check if settings are loaded: if not, load them!");
            this.loadClusterSettingProperties();
        }
        return this.diskReconRate;
    }

    public synchronized String getFailoverMode() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getFailOverMode");
        if (this.failoverMode == null) {
            Trace.verbose((Object)this, "getFailoverMode", "Calling loadClusterSettingProperties() to check if settings are loaded: if not, load them!");
            this.loadClusterSettingProperties();
        }
        return this.failoverMode;
    }

    public synchronized int getBlockSize() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getBlockSize");
        if (this.blockSize == -1) {
            Trace.verbose((Object)this, "getBlockSize", "Calling loadClusterSettingProperties() to check if settings are loaded: if not, load them!");
            this.loadClusterSettingProperties();
        }
        return this.blockSize;
    }

    public synchronized int getReadaheadMode() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getReadaheadMode");
        if (this.readaheadMode == -1) {
            Trace.verbose((Object)this, "getReadaheadMode", "Calling loadClusterSettingProperties() to check if settings are loaded: if not, load them!");
            this.loadClusterSettingProperties();
        }
        return this.readaheadMode;
    }

    public synchronized String getCacheMode() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getCacheMode");
        if (this.cacheMode == null) {
            Trace.verbose((Object)this, "getCacheMode", "Calling loadClusterSettingProperties() to check if settings are loaded: if not, load them!");
            this.loadClusterSettingProperties();
        }
        return this.cacheMode;
    }

    public synchronized int getConnectivity() {
        if (!this.connectivityStatusLoaded) {
            try {
                ManageT4sInterface t4Manager = ManageT4sFactory.getManager();
                if (t4Manager instanceof ManageT4sM1M2) {
                    t4Manager.init(this.context, null);
                    this.connectivityStatus = ((ManageT4sM1M2)t4Manager).getConnectivityStatus(this.context, this.getClusterName());
                }
                this.connectivityStatusLoaded = true;
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, cme);
            }
        }
        return this.connectivityStatus;
    }

    public synchronized List getTrays() throws ConfigMgmtException {
        Trace.methodBegin(this, "getTrays");
        if (this.trays == null) {
            Trace.verbose((Object)this, "getTrays", "trays list is not cached!  Need to get data from CIMOM via TrayFactory and TrayManager!");
            this.trays = new ArrayList();
            Trace.verbose((Object)this, "getTrays", "Getting Tray Manager via Factory to get Trays!!");
            ManageTraysInterface manageTrays = ManageTraysFactory.getManager();
            manageTrays.setScope(this);
            manageTrays.init(this.context, null);
            this.trays = (ArrayList)manageTrays.getItemList();
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "getTrays", "done getting trays in T4: number of trays in this T4: " + this.trays.size());
            for (int i = 0; i < this.trays.size(); ++i) {
                Trace.verbose((Object)this, "getTrays", "tray " + i + ": id = " + ((Tray)this.trays.get(i)).getId());
                Trace.verbose((Object)this, "getTrays", "tray " + i + ": trayType = " + ((Tray)this.trays.get(i)).getTrayType());
                Trace.verbose((Object)this, "getTrays", "********************");
            }
        }
        return (List)this.trays.clone();
    }

    public synchronized List getRaidGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "getRaidGroups");
        if (this.raidGroups == null) {
            Trace.verbose((Object)this, "getRaidGroups", "RaidGroup list is not loaded yet....calling findRaidGroups() to load it");
            this.findRaidGroups();
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "getRaidGroups", "Done getting raid groups in T4: number of raid groups in this T4: " + this.raidGroups.size());
            for (int i = 0; i < this.raidGroups.size(); ++i) {
                Trace.verbose((Object)this, "getRaidGroups", "raid group " + i + ": name = " + ((RaidGroup)this.raidGroups.get(i)).getName());
                Trace.verbose((Object)this, "getRaidGroups", "tray " + i + ": instance id = " + ((RaidGroup)this.raidGroups.get(i)).getInstanceId());
                Trace.verbose((Object)this, "getRaidGroups", "********************");
            }
        }
        return (List)this.raidGroups.clone();
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.t4CimInstance;
    }

    public synchronized int getMaxNumberOfVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getMaxNumberOfVolumes");
        if (this.maxVolumes == -1) {
            try {
                CIMInstance portController = T4.getPortSCSIController(this.cimClient, this.clusterName);
                this.maxVolumes = ((UnsignedInt32)portController.getProperty("MaxNumberControlled").getValue().getValue()).intValue();
                Trace.verbose((Object)this, "getMaxNumberOfVolumes", "The MaxNumberOfVolumes for " + this.getName() + " Cluster is: " + this.maxVolumes);
            }
            catch (NullPointerException npe) {
                Trace.verbose((Object)this, "getMaxNumberOfVolumes", "NullPointerException - Null returned when trying to get the maximum number of volumes.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems getting the maximum number of volumes.", npe);
            }
        }
        return this.maxVolumes;
    }

    public static CIMInstance getPortSCSIController(CIMOMHandleWrapper client, String ipAddr) throws ConfigMgmtException {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$T4 == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$T4 = T4.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.T4")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$T4, "getPortSCSIController");
        CIMInstance ci = null;
        try {
            Enumeration conEnum = CIMObjectWrapper.execQuery(client, "Select * from SunStorEdge_6120PortSCSIController where SystemName = '" + ipAddr + "'");
            if (conEnum == null || !conEnum.hasMoreElements()) {
                throw new ConfigMgmtException("Zero CIM Instances Returned for ", "ZERO_CIM_INSTANCE_RETURNED");
            }
            ci = (CIMInstance)conEnum.nextElement();
        }
        catch (ConfigMgmtException cme) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$T4 == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$T4 = T4.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.T4")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$T4, "getPortSCSIController", "Failed: " + cme.getMessage());
            throw cme;
        }
        return ci;
    }

    public synchronized int getAhsPoolSize() throws ConfigMgmtException, FeatureNotSupportedException {
        String methodName = "getAhsPoolSize";
        Trace.methodBegin(this, methodName);
        if (!this.isFeatureSupported(3)) {
            String message = "Array hot spares are not supported in array firmware version " + this.getFirmwareVersion();
            Trace.verbose((Object)this, methodName, message);
            throw new FeatureNotSupportedException("FEATURE_NOT_SUPPORTED", message);
        }
        if (this.manageArraySpares == null) {
            this.manageArraySpares = new ManageArraySpares();
            this.manageArraySpares.init(this.context, this);
        }
        return this.manageArraySpares.getAhsPoolSize();
    }

    public synchronized int getMaxAhsPoolSizeAllowed() throws ConfigMgmtException, FeatureNotSupportedException {
        String methodName = "getMaxAhsPoolSizeAllowed";
        Trace.methodBegin(this, methodName);
        if (!this.isFeatureSupported(3)) {
            String message = "Array hot spares are not supported in array firmware version " + this.getFirmwareVersion();
            Trace.verbose((Object)this, methodName, message);
            throw new FeatureNotSupportedException("FEATURE_NOT_SUPPORTED", message);
        }
        if (this.manageArraySpares == null) {
            this.manageArraySpares = new ManageArraySpares();
            this.manageArraySpares.init(this.context, this);
        }
        return this.manageArraySpares.getMaxAhsPoolSizeAllowed();
    }

    public boolean isDiskScrubbing() throws ConfigMgmtException, FeatureNotSupportedException {
        Trace.methodBegin(this, "isDiskScrubbing");
        if (!this.isFeatureSupported(1)) {
            String message = "Disk scrubbing is not supported for array firmware version " + this.getFirmwareVersion();
            Trace.verbose((Object)this, "isDiskScrubbing", message);
            throw new FeatureNotSupportedException("FEATURE_NOT_SUPPORTED", message);
        }
        return "on".equalsIgnoreCase(this.getDiskScrubber());
    }

    public String getDiskScrubber() throws ConfigMgmtException {
        Trace.methodBegin(this, "getDiskScrubbing");
        if (this.diskScrubber == null) {
            Trace.verbose((Object)this, "getDiskScrubber", "Loading SystemSetting properties.");
            this.loadClusterSettingProperties();
        }
        return this.diskScrubber;
    }

    public synchronized int getArrayConfigurationType() throws ConfigMgmtException {
        String methodName = "getArrayConfigurationType";
        Trace.methodBegin(this, methodName);
        if (this.arrayConfigurationType == -1) {
            int numberOfTrays = this.numExpansionTrays + this.numControllerTrays;
            Trace.verbose((Object)this, methodName, "have numberOfTrays: " + numberOfTrays + " and numExpansionTrays: " + this.numExpansionTrays + " and numControllerTrays: " + this.numControllerTrays);
            if (this.numControllerTrays == 1 && numberOfTrays == 1) {
                this.arrayConfigurationType = 1;
            } else if (this.numControllerTrays == 1 && numberOfTrays == 2) {
                this.arrayConfigurationType = 2;
            } else if (this.numControllerTrays == 1 && numberOfTrays == 3) {
                this.arrayConfigurationType = 3;
            } else if (this.numControllerTrays == 2 && numberOfTrays == 2) {
                this.arrayConfigurationType = 4;
            } else if (this.numControllerTrays == 2 && numberOfTrays == 4) {
                this.arrayConfigurationType = 8;
            } else if (this.numControllerTrays == 2 && numberOfTrays == 6) {
                this.arrayConfigurationType = 12;
            } else {
                ConfigMgmtException cme = new ConfigMgmtException("UNSUPPORTED_CONFIGURATION_ERROR", "Configuration " + this.numControllerTrays + "X" + numberOfTrays + " is not supported.");
                Trace.error((Object)this, cme);
                throw cme;
            }
        }
        return this.arrayConfigurationType;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean isFeatureSupported(int feature) {
        Trace.methodBegin(this, "isFeatureSupported");
        return ArrayFeatures.isFeatureSupported(feature, this.major, this.minor, this.patch);
    }

    public void setDescription(String description) {
        Trace.methodBegin(this, "setDescription");
        this.description = description;
    }

    public void setBlockSize(int blockSize) {
        Trace.methodBegin(this, "setBlockSize");
        this.blockSize = blockSize;
    }

    public void setDiskReconRate(int diskReconRate) {
        Trace.methodBegin(this, "setDiskReconRate");
        this.diskReconRate = diskReconRate;
    }

    public void setReadaheadMode(int readaheadMode) throws ConfigMgmtException {
        Trace.methodBegin(this, "setReadaheadMode");
        if (readaheadMode == 0) {
            this.readaheadMode = readaheadMode;
        } else if (readaheadMode > 0) {
            this.readaheadMode = 2;
        } else {
            String message = "Invalid readaheadMode value passed: " + readaheadMode;
            Trace.verbose((Object)this, "setReadaheadMode", message);
            throw new ConfigMgmtException("NO_SUCH_READAHEAD_MODE", message);
        }
    }

    public void setFailoverMode(String failoverMode) {
        Trace.methodBegin(this, "setFailoverMode");
        this.failoverMode = failoverMode;
    }

    public void setCacheMode(String cacheMode) {
        Trace.methodBegin(this, "setCacheMode");
        this.cacheMode = cacheMode;
    }

    public void setConnectivity(int status) {
        this.connectivityStatus = status;
    }

    public void setClusterName(String clusterName) {
        Trace.methodBegin(this, "setClusterName");
        this.clusterName = clusterName;
    }

    public void setClusterSerialNum(String clusterSerialNum) {
        Trace.methodBegin(this, "setClusterSerialNum");
        this.clusterSerialNum = clusterSerialNum;
    }

    public void setHealthStatus(int healthStatus) {
        Trace.methodBegin(this, "setHealthStatus");
        this.healthStatus = healthStatus;
    }

    public void setCIMInstance(CIMInstance t4CimInstance) {
        Trace.methodBegin(this, "setCIMInstance");
        this.t4CimInstance = t4CimInstance;
        this.t4CimObjPath = t4CimInstance.getObjectPath();
    }

    public void setClusterMapElementList(Collection mapClusterElementList) {
        Trace.methodBegin(this, "setClusterMapElementList");
        this.mapClusterElementList = mapClusterElementList;
    }

    private synchronized void reloadCluster() throws ConfigMgmtException {
        Trace.methodBegin(this, "reloadCluster");
        try {
            Trace.verbose((Object)this, "reloadCluster", "Getting a new Cluster CIMInstance!!");
            CIMInstance newT4CimInstance = this.cimClient.getInstance(this.t4CimObjPath, false, true, false, Constants.ClusterProperties.CLUSTER_PROP_LIST);
            CIMObjectWrapper.populate(this, this.mapClusterElementList, newT4CimInstance);
            this.t4CimInstance = newT4CimInstance;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "reloadCluster", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private void findRaidGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "findRaidGroups");
        this.raidGroups = new ArrayList();
        Trace.verbose((Object)this, "findRaidGroups", "Getting RaidGroup Manager via Factory to get RaidGroups!!");
        ManageRaidGroupsInterface manageRaidGroups = ManageRaidGroupsFactory.getManager();
        manageRaidGroups.setScope(this);
        manageRaidGroups.init(this.context, null);
        this.raidGroups = (ArrayList)manageRaidGroups.getItemList();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "findRaidGroups", "done getting RaidGroups on T4; number of RaidGroup on T4: " + this.raidGroups.size());
            for (int j = 0; j < this.raidGroups.size(); ++j) {
                RaidGroup raidGroup = (RaidGroup)this.raidGroups.get(j);
                Trace.verbose((Object)this, "findRaidGroups", "RaidGroup " + j + ": \nname: " + raidGroup.getName() + "\ntotalCapacity: " + raidGroup.getTotalCapacity() + "\nstatus: " + raidGroup.getStatus() + "\nstate: " + raidGroup.getState());
            }
        }
    }

    private void generateT4ClusterSettingMapElements() {
        Trace.methodBegin(this, "generateT4ClusterSettingMapElements");
        this.mapClusterSettingElementList = new ArrayList();
        Trace.verbose((Object)this, "generateT4ClusterSettingMapElements", "adding CIM ClusterSetting and T4 prop names mapping to MapElement list!");
        this.mapClusterSettingElementList.add(new MapElement("blockSize", "SegmentSize", false, false));
        this.mapClusterSettingElementList.add(new MapUint8ToInt("readaheadMode", "ReadAheadMode", false, false));
        this.mapClusterSettingElementList.add(new MapElement("diskReconRate", "ReconRate", false, false));
        this.mapClusterSettingElementList.add(new MapElement("cacheMode", "CacheMode", false, false));
        this.mapClusterSettingElementList.add(new MapElement("failoverMode", "FailoverMode", false, false));
        this.mapClusterSettingElementList.add(new MapElement("ondgMode", "ONDGMode", false, false));
        if (this.isFeatureSupported(1)) {
            this.mapClusterSettingElementList.add(new MapElement("diskScrubber", "DiskScrubber", false, false));
        }
    }

    private void loadClusterSettingProperties() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "loadClusterSettingProperties");
        if (!this.isClusterSettingLoaded && this.healthStatus == 2) {
            Trace.verbose((Object)this, "loadClusterSettingProperties", "ClusterSetting has not been loaded yet...load it now!!");
            if (this.mapClusterSettingElementList == null) {
                Trace.verbose((Object)this, "loadClusterSettingProperties", "MapElement list for ClusterSetting is null....get it now!");
                this.generateT4ClusterSettingMapElements();
            }
            if (this.clusterSettingCim == null) {
                this.getCIMClusterSetting();
            }
            Trace.verbose((Object)this, "loadClusterSettingProperties", "calling populate method to load up the T4 (this) object from SystemSetting");
            CIMObjectWrapper.populate(this, this.mapClusterSettingElementList, this.clusterSettingCim);
            if (Trace.isTraceEnabled(this)) {
                this.traceT4Props();
            }
            this.isClusterSettingLoaded = true;
            Trace.verbose((Object)this, "loadClusterSettingProperties", "done loading ClusterSetting properties into T4");
            if (this.isBlockSizeOutOfRange()) {
                Trace.verbose((Object)this, "loadT4Property", "Segment size from CIM is Out Of Range: " + this.blockSize);
                throw new ConfigMgmtException("CIM_VALUE_OUT_OF_RANGE", "Segment size returned from CIM is out of range.");
            }
            if (this.readaheadMode < 0) {
                Trace.verbose((Object)this, "loadT4Property", "Readahead mode from CIM is Out Of Range: " + this.readaheadMode);
                throw new ConfigMgmtException("CIM_VALUE_OUT_OF_RANGE", "Readahead Mode returned from CIM is out of range.");
            }
            if (this.isDiskReconRateOutOfRange()) {
                Trace.verbose((Object)this, "loadT4Property", "Disk Recon Rate from CIM is Out Of Range: " + this.diskReconRate);
                throw new ConfigMgmtException("CIM_VALUE_OUT_OF_RANGE", "Disk Recon Rate returned from CIM is out of range.");
            }
            if (this.isCacheModeOutOfRange()) {
                Trace.verbose((Object)this, "loadT4Property", "Cache Mode from CIM is Out Of Range: " + this.cacheMode);
                throw new ConfigMgmtException("CIM_VALUE_OUT_OF_RANGE", "Cache Mode returned from CIM is out of range.");
            }
            if (this.isFailoverModeOutOfRange()) {
                Trace.verbose((Object)this, "loadT4Property", "Failover Mode from CIM is Out Of Range: " + this.failoverMode);
                throw new ConfigMgmtException("CIM_VALUE_OUT_OF_RANGE", "Failover mode returned from CIM is out of range.");
            }
        }
    }

    private void traceT4Props() {
        StringBuffer buf = new StringBuffer("Properties for array");
        buf.append(this.name);
        buf.append("\n\tBlock size:").append(this.blockSize);
        buf.append("\n\tRead ahead mode:").append(this.readaheadMode);
        buf.append("\n\tDisk recon rate:").append(this.diskReconRate);
        buf.append("\n\tcache mode:").append(this.cacheMode);
        buf.append("\n\tfailover Mode:").append(this.failoverMode);
        buf.append("\n\tondg Mode:").append(this.ondg);
        buf.append("\n\thasConfiguredStorage:").append(this.hasConfiguredStorage);
        buf.append("\n\tmaxDisksAvailNoRedun ").append(this.maxDisksAvailNoRedun);
        buf.append("\n\tmaxDisksAvailWithRedun ").append(this.maxDisksAvailWithRedun);
        buf.append("\n\tnumControllerTrays").append(this.numControllerTrays);
        buf.append("\n\tnumExpansionTrays").append(this.numExpansionTrays);
        if (this.isFeatureSupported(1)) {
            buf.append("\n\tdisk scrubbing:").append(this.diskScrubber);
        }
        if (this.isFeatureSupported(3)) {
            try {
                if (this.manageArraySpares != null) {
                    buf.append("\n\tarray spares:").append(this.getAhsPoolSize());
                } else {
                    buf.append("\n\tarray spares: not yet loaded");
                }
            }
            catch (FeatureNotSupportedException e) {
            }
            catch (ConfigMgmtException configMgmtException) {
                // empty catch block
            }
        }
        Trace.verbose((Object)this, "traceT4Props", buf.toString());
    }

    private boolean isBlockSizeOutOfRange() {
        return this.blockSize != 4096 && this.blockSize != 8192 && this.blockSize != 16384 && this.blockSize != 32768 && this.blockSize != 65536;
    }

    private boolean isDiskReconRateOutOfRange() {
        return this.diskReconRate != 1 && this.diskReconRate != 8 && this.diskReconRate != 16;
    }

    private boolean isCacheModeOutOfRange() {
        return !this.cacheMode.equals("auto") && !this.cacheMode.equals("writeBehind") && !this.cacheMode.equals("writeThrough") && !this.cacheMode.equals("disabled");
    }

    private boolean isFailoverModeOutOfRange() {
        return !this.failoverMode.equals("mpxio") && !this.failoverMode.equals("readWrite") && !this.failoverMode.equals("none") && !this.failoverMode.equals("std");
    }

    private void getCIMClusterSetting() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        String METHOD = "getCIMClusterSetting";
        Trace.methodBegin(this, "getCIMClusterSetting");
        if (this.healthStatus != 2) {
            Trace.verbose((Object)this, "getCIMClusterSetting", "Cluster not OK, so not exploring properties.");
            return;
        }
        try {
            Trace.verbose((Object)this, "getCIMClusterSetting", "going to walk the association to SystemSetting");
            Enumeration enumClusterSetting = this.cimClient.associators(this.t4CimObjPath, "SunStorEdge_6120SettingForSystem", "SunStorEdge_6120SystemSetting", "Antecedent", "Dependent", true, true, clusterSettingProplist);
            int j = 1;
            while (enumClusterSetting.hasMoreElements()) {
                if (j > 1) {
                    this.clusterSettingCim = (CIMInstance)enumClusterSetting.nextElement();
                    Trace.verbose((Object)this, "getCIMClusterSetting", "Extra SystemSetting: " + this.clusterSettingCim + "\n with object path: " + this.clusterSettingCim.getObjectPath());
                    Trace.verbose((Object)this, "getCIMClusterSetting", "More than 1 instance of SystemSetting object returned from walking from Chassis to SystemSetting!");
                    throw new TooManyCIMInstanceException("TOOMANY_CIM_INSTANCE_RETURNED", "More than 1 instance of SystemSetting object returned from the association chain: Cluster to SystemSetting.");
                }
                this.clusterSettingCim = (CIMInstance)enumClusterSetting.nextElement();
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "getCIMClusterSetting", "SystemSetting with object path:" + this.clusterSettingCim.getObjectPath());
                }
                ++j;
            }
            if (this.clusterSettingCim == null) {
                Trace.verbose((Object)this, "getCIMClusterSetting", "Zero instance of SystemSetting object exists from walking from Cluster to SystemSetting!");
                throw new ZeroCIMInstanceReturnedException("ZERO_CIM_INSTANCE_RETURNED", "No SystemSetting object found for this Cluster.");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getCIMClusterSetting", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public synchronized FiberChannelPortInterface getFiberChannelPort() throws ConfigMgmtException {
        if (null == this.fiberChannelPort) {
            this.fiberChannelPort = new FiberChannelPort(this.context, this.t4CimObjPath, this.clusterName);
            this.fiberChannelPort.init(this.context);
        }
        return this.fiberChannelPort;
    }

    private String getCurrentGateway() throws ConfigMgmtException {
        RemoteServiceAccessPoint ap = new RemoteServiceAccessPoint(this.context, this.t4CimObjPath);
        return ap.getGateway();
    }

    public void setAhsPoolSize(int ahsPoolSize) throws FeatureNotSupportedException, ConfigMgmtException {
        String methodName = "setAhsPoolSize";
        Trace.methodBegin(this, methodName);
        if (!this.isFeatureSupported(3)) {
            String message = "Array hot spares are not supported in array firmware version " + this.getFirmwareVersion();
            Trace.verbose((Object)this, methodName, message);
            throw new FeatureNotSupportedException("FEATURE_NOT_SUPPORTED", message);
        }
        if (this.manageArraySpares == null) {
            this.manageArraySpares = new ManageArraySpares();
            this.manageArraySpares.init(this.context, this);
        }
        this.manageArraySpares.setAhsPoolSize(ahsPoolSize);
    }

    public void setDiskScrubbing(boolean diskScrubbing) throws FeatureNotSupportedException {
        Trace.methodBegin(this, "setDiskScrubbing");
        if (!this.isFeatureSupported(1)) {
            String message = "Disk scrubbing is not supported for array firmware version " + this.getFirmwareVersion();
            Trace.verbose((Object)this, "setDiskScrubbing", message);
            throw new FeatureNotSupportedException("FEATURE_NOT_SUPPORTED", message);
        }
        this.diskScrubber = diskScrubbing ? "on" : "off";
        Trace.verbose((Object)this, "setDiskScrubbing", "diskScrubber set to: " + this.diskScrubber);
    }

    public void setDiskScrubber(String diskScrubber) {
        this.diskScrubber = diskScrubber;
    }

    public void setFirmwareVersion(String firmwareVersion) throws ConfigMgmtException {
        String methodName = "setFirmwareVersion";
        Trace.methodBegin(this, methodName);
        if (firmwareVersion == null) {
            this.firmwareVersion = "-";
            Trace.verbose((Object)this, methodName, "Firmware version not set yet.");
        } else {
            try {
                this.major = Integer.parseInt(firmwareVersion.substring(0, 2));
                this.minor = Integer.parseInt(firmwareVersion.substring(2, 4));
                this.patch = Integer.parseInt(firmwareVersion.substring(4, 6));
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, methodName, "M " + this.major);
                    Trace.verbose((Object)this, methodName, "m " + this.minor);
                    Trace.verbose((Object)this, methodName, "r " + this.patch);
                }
            }
            catch (Exception ex) {
                ConfigMgmtException cme = new ConfigMgmtException("error.applicationError", "Could not parse firmware version for firmware version: " + firmwareVersion, ex);
                Trace.error((Object)this, cme);
            }
            this.firmwareVersion = this.major + "." + this.minor + "." + this.patch;
        }
    }

    public synchronized QueuedPoolData getQueuedPoolData() throws ConfigMgmtException {
        if (this.m_queuedPoolData == null) {
            this.m_queuedPoolData = new QueuedPoolData(this.context, this);
        }
        return this.m_queuedPoolData;
    }

    public boolean isDuplicateCandidate(T4Interface cand) throws ConfigMgmtException {
        String METHOD = "isDuplicateCandidate";
        Trace.methodBegin(this, "isDuplicateCandidate");
        List srcTrays = this.getTrays();
        if (cand.getClusterName().equals(this.getClusterName())) {
            Trace.verbose((Object)this, "isDuplicateCandidate", "Same array is not a candidate: " + cand.getName());
            return false;
        }
        if (cand.getHealthStatus() != 2) {
            Trace.verbose((Object)this, "isDuplicateCandidate", "Skipping unhealthy array: " + cand.getName());
            return false;
        }
        if (this.isFeatureSupported(3) != cand.isFeatureSupported(3) || this.isFeatureSupported(4) != cand.isFeatureSupported(4)) {
            Trace.verbose((Object)this, "isDuplicateCandidate", "Skipping array with different firmware version: " + cand.getName());
            return false;
        }
        List destTrays = cand.getTrays();
        if (destTrays.size() != srcTrays.size()) {
            Trace.verbose((Object)this, "isDuplicateCandidate", "Different number of trays: " + cand.getName());
            return false;
        }
        for (int j = 0; j < srcTrays.size(); ++j) {
            TrayInterface sTray = (TrayInterface)srcTrays.get(j);
            TrayInterface dTray = (TrayInterface)destTrays.get(j);
            if (sTray.getTrayType() != dTray.getTrayType()) {
                Trace.verbose((Object)this, "isDuplicateCandidate", "Different types of trays: " + cand.getName());
                return false;
            }
            if (sTray.areDisksCompatible(dTray)) continue;
            Trace.verbose((Object)this, "isDuplicateCandidate", "Incompatible disks: " + cand.getName());
            return false;
        }
        return true;
    }

    public int getMaxDisksAvailWithRedun() {
        return this.maxDisksAvailWithRedun;
    }

    public void setMaxDisksAvailWithRedun(int x) {
        this.maxDisksAvailWithRedun = x;
    }

    public int getMaxDisksAvailNoRedun() {
        return this.maxDisksAvailNoRedun;
    }

    public void setMaxDisksAvailNoRedun(int x) {
        this.maxDisksAvailNoRedun = x;
    }

    public boolean hasConfiguredStorage() {
        return this.hasConfiguredStorage;
    }

    public void setEnabledState(int newState) {
        this.enabledState = newState;
        this.hasConfiguredStorage = newState == 2;
    }

    public int getEnabledState() {
        return this.enabledState;
    }

    public void setNumControllerTrays(int newVal) {
        Trace.verbose((Object)this, "setNumControllerTrays", "called with val: " + newVal);
        this.numControllerTrays = newVal;
    }

    public int getNumControllerTrays() {
        return this.numControllerTrays;
    }

    public void setNumExpansionTrays(int newVal) {
        Trace.verbose((Object)this, "setNumExpansionTrays", "called with val: " + newVal);
        this.numExpansionTrays = newVal;
    }

    public int getNumExpansionTrays() {
        return this.numExpansionTrays;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

