/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Binding;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.VolumeGroup;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageRaidGroups;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.RaidGroup;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StorageConfigurationServiceBuilder;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;

public class StorageVolume
implements StorageVolumeInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private String name;
    private String trayId;
    private String raidGroupName;
    private BigInteger blockSize;
    private BigInteger consumableBlocks;
    private String status;
    private String volumePermissions;
    private int lun;
    private String deviceNumber;
    private String deviceID;
    private List volumeGroups;
    private String t4Name;
    private CIMObjectPath t4ObjectPath;
    private ArrayList fieldMap;
    private CIMInstance instance;
    private CIMObjectPath volumePath;
    private CIMObjectPath poolPath;
    private String profileName;
    public static final String[] PROPERTY_NAMES = new String[]{"OtherIdentifyingInfo", "DeviceID", "BlockSize", "ConsumableBlocks", "CreationClassName", "SystemCreationClassName", "DeviceNumber", "AccessType", "SystemName", "OtherIdentifyingInfo"};
    public static final String[] LUN_PROPERTIES = new String[]{"DeviceNumber"};

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.handle = context.getClient();
        this.volumeGroups = new ArrayList();
        this.lun = -1;
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
    }

    public MethodCallStatus delete() throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        if (this.instance != null) {
            ArrayList<JobInterface> jobs = new ArrayList<JobInterface>();
            try {
                CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Element", new CIMValue((Object)this.instance.getObjectPath())), new CIMArgument("Description", new CIMValue((Object)("job.description.deletevolume + " + this.getName())))};
                CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null))};
                CIMObjectPath confServiceObjectPath = StorageConfigurationServiceBuilder.getInstance(this.handle, this.t4PathLookup());
                CIMValue returnValue = this.handle.invokeMethod(confServiceObjectPath, "ReturnToStoragePool", inArgs, outArgs);
                Trace.verbose((Object)this, "delete", "Return code is: " + returnValue);
                int result = ((UnsignedInt32)returnValue.getValue()).intValue();
                if (outArgs[0] != null && outArgs[0].getValue() != null) {
                    JobManager managerInterface = new JobManager();
                    managerInterface.init(this.context, null);
                    JobInterface job = managerInterface.get((CIMObjectPath)outArgs[0].getValue().getValue(), this.name);
                    jobs.add(job);
                }
                if (result != 0 && result != 4096) {
                    Trace.verbose((Object)this, "delete", "Return code for ReturnToStoragePool is not success, it is " + result);
                    return new MethodCallStatus(2, jobs);
                }
                return new MethodCallStatus(0, jobs);
            }
            catch (NullPointerException npe) {
                Trace.verbose((Object)this, "delete", "Returned value from ReturnToPoolMethod is null. " + npe);
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Returned value from ReturnToPoolMethod is null.", npe);
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "delete", "Failed delete--current state: " + this.toString());
                throw cme;
            }
            catch (Exception e) {
                Trace.verbose((Object)this, "delete", (Throwable)e);
                throw new ConfigMgmtException("CIM_UNKNOWN_ERROR", "General exception when deleting the StorageVolume ." + this.toString(), e);
            }
        }
        Trace.verbose((Object)this, "delete", "CIMInstance instance member variable not initialized.");
        throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.volumePath, false, true, false, PROPERTY_NAMES);
        Trace.verbose((Object)this, "reload", "Object path of the fresh CIMInstance: " + ci.getObjectPath());
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.status = null;
        this.trayId = null;
        this.profileName = null;
        this.lun = -1;
        this.volumeGroups = new ArrayList();
        this.t4Name = null;
        this.t4ObjectPath = null;
        Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() throws ConfigMgmtException {
        Trace.methodBegin(this, "getStatus");
        if (this.status == null) {
            this.raidGroupPropertiesLookup();
        }
        return this.status;
    }

    public String getTrayId() throws ConfigMgmtException {
        Trace.methodBegin(this, "getTrayId");
        if (this.trayId == null) {
            this.raidGroupPropertiesLookup();
        }
        return this.trayId;
    }

    private CIMObjectPath getFirstAssociatorPath(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws ConfigMgmtException {
        Trace.methodBegin(this, "getFirstAssociatorPath");
        try {
            Enumeration enumeration = this.handle.associatorNames(objectName, assocClass, resultClass, role, resultRole);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getFirstAssociatorPath", "We have got some instances.");
                return (CIMObjectPath)enumeration.nextElement();
            }
            Trace.verbose((Object)this, "getFirstAssociatorPath", "No instances returned.");
            throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "No instances returned in getFirstAssociatorPath() method.");
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "getFirstAssociatorPath", "Failed--current state: " + this.toString());
            throw cme;
        }
    }

    public String getRaidGroupName() throws ConfigMgmtException {
        return this.raidGroupName;
    }

    public BigInteger getSize() {
        BigInteger size = this.consumableBlocks.multiply(this.blockSize);
        Trace.verbose((Object)this, "getSize", "Calculated size in bytes is: " + size);
        return size;
    }

    public String getVolumePermissions() throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumePermissions");
        return StorageVolume.mapToAccessType(this.volumePermissions);
    }

    private static String mapToAccessType(String value) {
        String access = null;
        if (value != null) {
            access = value.equals("rw") ? "Read/Write" : (value.equals("ro") ? "Read-only" : (value.equals("none") ? "None" : value));
        }
        return access;
    }

    public void setLUN(int lun) {
        this.deviceNumber = "" + lun;
    }

    public int getLUN() throws ConfigMgmtException {
        Trace.methodBegin(this, "getLUN");
        if (this.lun == -1 && this.deviceNumber != null) {
            try {
                this.lun = Integer.parseInt(this.deviceNumber, 10);
                Trace.verbose((Object)this, "getLUN", "Lun number looked up is: " + this.lun);
            }
            catch (NullPointerException npe) {
                Trace.verbose((Object)this, "getLUN", "NullPointerException - when trying to obtain default lun number.");
                new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - when trying to obtain default lun number.", npe);
            }
            catch (NumberFormatException nfe) {
                Trace.verbose((Object)this, "getLUN", (Throwable)nfe);
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems getting the lun number (parseInt method failed).", nfe);
            }
        }
        return this.lun;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public String getDeviceNumber() {
        return this.deviceNumber;
    }

    public String getVolumeGroup() throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumeGroup");
        ManageVolumeGroupsInterface mvg = ManageVolumeGroupsFactory.getManager();
        mvg.setScope(this);
        mvg.init(this.context, null);
        List volumeGroups = mvg.getItemList();
        Trace.verbose((Object)this, "getVolumeGroup", "All VolumeGroups that volume belongs to:\n" + volumeGroups);
        String volumeGroupName = null;
        if (volumeGroups != null && volumeGroups.size() > 0) {
            volumeGroupName = ((VolumeGroupInterface)volumeGroups.get(0)).getName();
        }
        return volumeGroupName;
    }

    public String getT4Name() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Name");
        if (this.t4Name == null) {
            this.t4PropertiesLookup();
        }
        return this.t4Name;
    }

    private void t4PropertiesLookup() throws ConfigMgmtException {
        Trace.methodBegin(this, "t4PropertiesLookup");
        if (this.instance != null) {
            try {
                Trace.verbose((Object)this, "t4PropertiesLookup", "The StorageVolume object path is: " + this.instance.getObjectPath());
                Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_6120VolumeSystemDevice", "SunStorEdge_6120Cluster", "PartComponent", "GroupComponent", true, false, null);
                Trace.verbose((Object)this, "t4PropertiesLookup", "We are back from enumerating T4 instance.");
                if (enumeration == null || !enumeration.hasMoreElements()) {
                    String message = "No CIM instance returned when trying to lookup T4 for the StorageVolume: " + this.name;
                    Trace.verbose((Object)this, "t4PropertiesLookup", message);
                    throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", message);
                }
                CIMInstance t4Instance = (CIMInstance)enumeration.nextElement();
                Trace.verbose((Object)this, "t4PropertiesLookup", "The instance we got is: " + t4Instance);
                String t4IPAddess = (String)t4Instance.getProperty("Name").getValue().getValue();
                this.t4Name = IPUtil.lookUpHostName(t4IPAddess);
                Trace.verbose((Object)this, "t4PropertiesLookup", "The T4 name we looked up: " + this.t4Name);
                this.t4ObjectPath = t4Instance.getObjectPath();
                Trace.verbose((Object)this, "t4PropertiesLookup", "The T4 CIMObjectPath we looked up: " + this.t4ObjectPath);
            }
            catch (NullPointerException npe) {
                String message = "Null returned when trying to lookup T4 for the StorageVolume: " + this.name;
                Trace.verbose((Object)this, "t4PropertiesLookup", message);
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", message);
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "t4PropertiesLookup", "Failed--current state: " + this.toString());
                throw cme;
            }
        } else {
            Trace.verbose((Object)this, "t4PropertiesLookup", "CIMInstance instance member variable not initialized.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
        }
    }

    public CIMInstance getInstance() {
        return this.instance;
    }

    public String getProfileName() throws ConfigMgmtException {
        Trace.methodBegin(this, "getProfileName");
        if (this.profileName == null) {
            this.raidGroupPropertiesLookup();
        }
        return this.profileName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVolumePermissions(String volumePermissions) {
        this.volumePermissions = volumePermissions;
    }

    public void setInstance(CIMInstance instance) {
        this.instance = instance;
        this.volumePath = instance.getObjectPath();
    }

    public void setBlockSize(BigInteger blockSize) {
        this.blockSize = blockSize;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public void setDeviceNumber(String deviceNumber) {
        this.deviceNumber = deviceNumber;
    }

    public void setConsumableBlocks(BigInteger consumableBlocks) {
        this.consumableBlocks = consumableBlocks;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public void setRaidGroupName(String raidGroupName) {
        this.raidGroupName = raidGroupName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTrayId(String trayId) {
        this.trayId = trayId;
    }

    protected void setDefaultLUN(int lun) throws ConfigMgmtException {
        Trace.methodBegin(this, "setDefaultLUN");
        this.deviceNumber = Integer.toString(lun, 10).toUpperCase();
    }

    private CIMInstance mappedSCSILUNLookup() throws ConfigMgmtException {
        Trace.methodBegin(this, "mappedSCSILUNLookup");
        if (this.instance != null) {
            try {
                CIMInstance scsiLUNInstance = null;
                Enumeration lunEnum = this.handle.references(this.instance.getObjectPath(), "SunStorEdge_6120MappedProtocolControllerForUnit", "Dependent", false, false, null);
                if (lunEnum == null || !lunEnum.hasMoreElements()) {
                    Trace.verbose((Object)this, "mappedSCSILUNLookup", "MappedSCSILUN instance missing.");
                    throw new ConfigMgmtException("CIM_INSTANCE_NOT_FOUND", "MappedSCSILUN instance missing.");
                }
                scsiLUNInstance = (CIMInstance)lunEnum.nextElement();
                return scsiLUNInstance;
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "mappedSCSILUNLookup", "Failed--current state: " + this.toString());
                throw cme;
            }
        }
        Trace.verbose((Object)this, "mappedSCSILUNLookup", "CIMInstance instance member variable not initialized.");
        throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
    }

    private CIMInstance defaultACILookup() throws ConfigMgmtException {
        Trace.methodBegin(this, "defaultACILookup");
        if (this.instance != null) {
            try {
                Trace.verbose((Object)this, "defaultACILookup", "Trying to get AuthorizationViewSCSIController instance.");
                Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_6120MappedProtocolControllerForUnit", "SunStorEdge_6120AuthorizationViewSCSIController", "Dependent", "Antecedent", true, false, VolumeGroup.PROPERTY_NAMES);
                while (enumeration.hasMoreElements()) {
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    Trace.verbose((Object)this, "defaultACILookup", "Controller instance: " + ci.getObjectPath());
                    if (!((Boolean)ci.getProperty("DefaultGlobalAccess").getValue().getValue()).booleanValue()) continue;
                    Trace.verbose((Object)this, "defaultACILookup", "We found instance with DefaultGlobalAccess=true.");
                    enumeration = this.handle.associators(ci.getObjectPath(), "SunStorEdge_6120AuthorizationTarget", "SunStorEdge_6120AccessControlInformation", "Dependent", "Antecedent", true, false, Binding.PROPERTY_NAMES);
                    while (enumeration.hasMoreElements()) {
                        ci = (CIMInstance)enumeration.nextElement();
                        Trace.verbose((Object)this, "defaultACILookup", "AccessControlInfo instance: " + ci.getObjectPath());
                        enumeration = this.handle.referenceNames(ci.getObjectPath(), "SunStorEdge_6120AuthorizationSubject", "Antecedent");
                        if (enumeration != null && enumeration.hasMoreElements()) continue;
                        return ci;
                    }
                }
                Trace.verbose((Object)this, "defaultACILookup", "None of the instances was not appropriate.");
                throw new ConfigMgmtException("CIM_INSTANCE_NOT_FOUND", "Problems getting the default AccessControlInfo.");
            }
            catch (NullPointerException npe) {
                Trace.verbose((Object)this, "defaultACILookup", "NullPointerException - When trying to get default AccessControlInfo.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems trying to get default AccessControlInfo.", npe);
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "defaultACILookup", "Failed-current state: " + this.toString());
                throw cme;
            }
        }
        Trace.verbose((Object)this, "defaultACILookup", "CIMInstance instance member variable not initialized.");
        throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
    }

    private CIMObjectPath t4PathLookup() throws ConfigMgmtException {
        Trace.methodBegin(this, "t4PathLookup");
        if (this.t4ObjectPath == null) {
            this.t4PropertiesLookup();
        }
        return this.t4ObjectPath;
    }

    public void removeFromAllGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "removeFromAllGroups");
        if (this.instance != null) {
            try {
                Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_6120MappedProtocolControllerForUnit", "SunStorEdge_6120AuthorizationViewSCSIController", "Dependent", "Antecedent", true, false, VolumeGroup.PROPERTY_NAMES);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        CIMInstance ci = (CIMInstance)enumeration.nextElement();
                        Trace.verbose((Object)this, "removeFromAllGroups", "Controller instance: " + ci);
                        if (((Boolean)ci.getProperty("DefaultGlobalAccess").getValue().getValue()).booleanValue()) continue;
                        VolumeGroup volumeGroup = new VolumeGroup();
                        volumeGroup.setInstance(ci);
                        volumeGroup.init(this.context);
                        CIMObjectWrapper.populate(volumeGroup, volumeGroup.getFieldMap(), ci);
                        volumeGroup.deleteVolumeFromGroup(this);
                    }
                } else {
                    Trace.verbose((Object)this, "removeFromAllGroups", "No instance returned when trying to remove StorageVolume from all groups.");
                    return;
                }
                Trace.verbose((Object)this, "removeFromAllGroups", "Successfully removed volume from all groups.");
            }
            catch (NullPointerException npe) {
                Trace.verbose((Object)this, "removeFromAllGroups", "NullPointerException - Returned value is null in removeFromAllGroups method.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Returned value is  null in removeFromAllGroups method.", npe);
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "removeFromAllGroups", "Failed--current state: " + this.toString());
                throw cme;
            }
        } else {
            Trace.verbose((Object)this, "removeFromAllGroups", "CIMInstance instance member variable not initialized.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void raidGroupPropertiesLookup() throws ConfigMgmtException {
        Trace.methodBegin(this, "raidGroupPropertiesLookup");
        try {
            CIMInstance ci;
            block8: {
                block7: {
                    ci = null;
                    if (this.poolPath != null) break block7;
                    Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_6120AllocatedFromStoragePool", "SunStorEdge_6120StoragePool", "Dependent", "Antecedent", true, false, null);
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        ci = (CIMInstance)enumeration.nextElement();
                        this.poolPath = ci.getObjectPath();
                        if (Trace.isTraceEnabled(this)) {
                            Trace.verbose((Object)this, "raidGroupPropertiesLookup", "Instance we got: " + ci);
                        }
                        break block8;
                    } else {
                        Trace.verbose((Object)this, "raidGroupPropertiesLookup", "No instance returned when trying to get raidGroupProperties.");
                        throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "Problems getting the raidGroupProperties.");
                    }
                }
                ci = this.handle.getInstance(this.poolPath, false, true, false, null);
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "raidGroupPropertiesLookup", "Fresh StoragePool CIMInstance we've got: " + ci);
                }
            }
            RaidGroup raidGroup = this.loadRaidGroup(ci);
            this.status = raidGroup.getStatus();
            this.profileName = raidGroup.getProfileName();
            this.trayId = raidGroup.getTrayId();
            if (!Trace.isTraceEnabled(this)) return;
            Trace.verbose((Object)this, "raidGroupPropertiesLookup", "RaidGroup we looked up has:\n status <" + this.status + "> \n profile name <" + this.profileName + "> \n tray id <" + this.trayId + ">.");
            return;
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "raidGroupPropertiesLookup", "Null returned when trying to get raidGroupProperties.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems getting the raidGroupProperties.", npe);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "raidGroupPropertiesLookup", "Failed--current state: " + this.toString());
            throw cme;
        }
    }

    private RaidGroup loadRaidGroup(CIMInstance cimInstance) throws ConfigMgmtException {
        String methodName = "loadRaidGroup";
        Trace.methodBegin(this, methodName);
        RaidGroup raidGroup = new RaidGroup();
        raidGroup.init(this.context);
        raidGroup.setCIMInstance(cimInstance);
        ArrayList propMapList = ManageRaidGroups.generateRaidGroupMapElements();
        CIMObjectWrapper.populate(raidGroup, propMapList, cimInstance);
        raidGroup.setMapElementList(propMapList);
        Trace.verbose((Object)this, methodName, "Loaded raid group: " + raidGroup.getName());
        return raidGroup;
    }

    public boolean isAlreadyMember() throws ConfigMgmtException {
        String methodName = "isAlreadyMember";
        boolean result = false;
        Trace.methodBegin(this, methodName);
        if (this.instance != null) {
            try {
                Enumeration lunEnum = this.handle.references(this.instance.getObjectPath(), "SunStorEdge_6120MappedProtocolControllerForUnit", "Dependent", false, false, null);
                if (lunEnum != null && lunEnum.hasMoreElements()) {
                    lunEnum.nextElement();
                    if (lunEnum.hasMoreElements()) {
                        result = true;
                    }
                } else {
                    Trace.verbose((Object)this, methodName, "Default MappedSCSILUN instance missing.");
                    throw new ConfigMgmtException("CIM_INSTANCE_NOT_FOUND", "Default MappedSCSILUN instance missing.");
                }
                return result;
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, methodName, "Failed--current state: " + this.toString());
                throw cme;
            }
        }
        Trace.verbose((Object)this, methodName, "CIMInstance instance member variable not initialized.");
        throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
    }

    public Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapStringArrayToString("name", "OtherIdentifyingInfo", true, false, 0));
            this.fieldMap.add(new MapElement("deviceID", "DeviceID", true, false));
            this.fieldMap.add(new MapElement("blockSize", "BlockSize", true, false));
            this.fieldMap.add(new MapElement("consumableBlocks", "ConsumableBlocks", true, false));
            this.fieldMap.add(new MapElement("deviceNumber", "DeviceNumber", false, true));
            this.fieldMap.add(new MapElement("volumePermissions", "AccessType", false, false, 0));
            this.fieldMap.add(new MapElement("raidGroupName", "OtherIdentifyingInfo", true, false, 1));
        }
        return this.fieldMap;
    }

    public String toString() {
        return "StorageVolume with:\n CIMObjectPath: " + this.volumePath + "\n name: " + this.name + "\n status: " + this.status + "\n volumePermissions: " + this.volumePermissions + "\n raidGroupName: " + this.raidGroupName + "\n trayId: " + this.trayId + "\n deviceID: " + this.deviceID + "\n LUN: " + this.lun + "\n deviceNumber: " + this.deviceNumber + "\n blockSize: " + this.blockSize + "\n consumableBlocks: " + this.consumableBlocks + "\n number of volumeGroups: " + this.volumeGroups.size() + "\n t4Name: " + this.t4Name;
    }

    public String getDescription() {
        return null;
    }

    public String getStoragePoolName() {
        return null;
    }

    public String getStorageDomainName() {
        return null;
    }

    public String getVolumeGroupName() {
        return null;
    }

    public int getState() {
        return 0;
    }

    public int getCondition() {
        return 0;
    }

    public String getWwn() {
        return null;
    }

    public String getType() {
        return null;
    }

    public BigInteger getCapacity() {
        return null;
    }

    public Date getCreationDate() {
        return null;
    }

    public int getSnapshotPoolSize() {
        return 0;
    }

    public int getSnapshotPoolPercentFull() {
        return 0;
    }

    public int getNumberOfSnapshots() throws ConfigMgmtException {
        return 0;
    }

    public Collection getKey() {
        return null;
    }

    public ArrayList getAssociatedVDisks() throws ConfigMgmtException {
        return null;
    }

    public ArrayList getAssociatedSnapShots() throws ConfigMgmtException {
        return null;
    }

    public ArrayList getInitiatorMappings() throws ConfigMgmtException {
        return null;
    }

    public InitiatorVolumeMappingInterface getInitiatorMapping(String initiatorName) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public void setDescription(String description) throws BadParameterException {
    }

    public void setVolumeGroupName(String volumeGroupName) throws BadParameterException {
    }

    public MethodCallStatus createMapping(InitiatorVolumeMappingInterface mapping) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus createMapping(int lun, Set permissions, InitiatorInterface initiator) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus createMapping(Set permissions, InitiatorInterface initiator) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus removeMapping(InitiatorInterface initiator) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public MethodCallStatus extend(BigInteger size) throws ConfigMgmtException, BadParameterException {
        return null;
    }

    public MethodCallStatus createSnapshot(String name, int snapNum, int snapChange) throws ConfigMgmtException, BadParameterException {
        return null;
    }

    public MethodCallStatus deleteSnapshot(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public MethodCallStatus resetSnapshot() throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus removeSnapshotPool() throws ConfigMgmtException {
        return null;
    }

    public boolean isSnapshot() {
        return false;
    }

    public int getRedundancyType() {
        return 0;
    }

    public boolean isMirrorComponent() {
        return false;
    }
}

