/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.QueuedPoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.RaidSetGroup;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.StoragePoolCommon;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageRaidGroups;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.RaidGroup;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;

public class StoragePool
extends StoragePoolCommon {
    private String sourceProfileKey;
    private CIMObjectPath domainObjectPath;
    private StorageProfileInterface profile;
    private T4Interface t4;

    public void getAssociatedStorageCapabilities() throws ConfigMgmtException {
        String METHOD = "getAssociatedStorageCapabilities";
        Trace.methodBegin(this, METHOD);
        if (this.capObjectPath != null) {
            Trace.verbose((Object)this, METHOD, "Associated Storage Capacilities already loaded.");
            return;
        }
        try {
            Trace.verbose((Object)this, METHOD, "Querying CIM for associated StorageCapabilities.");
            Enumeration enumeration = this.handle.associators(this.objectPath, this.getElementCapabilitiesCIMClassName(), this.getStorageCapabilitiesCIMClassName(), "ManagedElement", "Capabilities", true, false, ConstantsEnt.StorageCapabilitiesProperties.PROP_LIST);
            Trace.verbose((Object)this, METHOD, "Returned from querying CIM for associated StorageCapabilities.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, METHOD, "StorageCapabilities instance found.");
                while (enumeration.hasMoreElements()) {
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    this.capObjectPath = ci.getObjectPath();
                    Trace.verbose((Object)this, METHOD, "Set capObjectPath to: " + this.capObjectPath);
                }
            } else {
                Trace.verbose((Object)this, METHOD, "No StorageProfile found.");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting associated StorageProfile name.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, (Throwable)e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting associated StorageProfile name.", e);
        }
    }

    public ArrayList getAssociatedVDisks() throws ConfigMgmtException {
        String methodName = "getAssociatedVDisks";
        Trace.methodBegin(this, methodName);
        ArrayList<RaidGroup> raidGroups = new ArrayList<RaidGroup>();
        try {
            Trace.verbose((Object)this, methodName, "Querying CIM for associated RaidGroups.");
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_6120StoragePool where SourceProfilePoolKey = '" + this.getInstanceID() + "'");
            Trace.verbose((Object)this, methodName, "Returned from querying CIM for RaidGroups.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, methodName, "RaidGroups Instances found.");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, methodName, "Creating RaidGroups Java Objects.");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    RaidGroup rg = new RaidGroup();
                    rg.init(this.context);
                    rg.setCIMInstance(ci);
                    ArrayList propMapList = ManageRaidGroups.generateRaidGroupMapElements();
                    CIMObjectWrapper.populate(rg, propMapList, ci);
                    rg.setMapElementList(propMapList);
                    raidGroups.add(rg);
                    Trace.verbose((Object)this, methodName, "The instance added to the list: " + rg.getName());
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, methodName, "NullPointerException - Null returned when trying to obtain all the RaidGroup instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the RaidGroup instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, methodName, "Exception - Exception thrown when trying to obtain all the RaidGroup instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the RaidGroup instances.", e);
        }
        return raidGroups;
    }

    public MethodCallStatus addStorageToPool(String wwn) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = "addStorageToPool(String)";
        Trace.methodBegin(this, "addStorageToPool(String)");
        return null;
    }

    public String getElementCapabilitiesCIMClassName() {
        return "SunStorEdge_6120ProfileElementCapabilities";
    }

    public String getHostedStoragePoolCIMClassName() {
        return "SunStorEdge_6120HostedProfilePool";
    }

    public String getStorageCapabilitiesCIMClassName() {
        return "SunStorEdge_6120ProfileStorageCapabilities";
    }

    public String getStorageDomainCIMClassName() {
        return "SunStorEdge_6120Cluster";
    }

    public String[] getStorageDomainCIMPropertyNames() {
        return Constants.ClusterProperties.CLUSTER_PROP_LIST;
    }

    public String getStorageDomainCIMPropNameForName() {
        return "Name";
    }

    public String getCIMObjectName() {
        return "SunStorEdge_6120ProfilePool";
    }

    public void addImplementationSpecificElements() {
        this.fieldMap.add(new MapElement("sourceProfileKey", "SourceProfileKey", true, false));
    }

    public String getProfileName() {
        Trace.methodBegin(this, "getProfileName");
        if (this.profileName == null) {
            try {
                this.loadProfile();
            }
            catch (ConfigMgmtException cme) {
                Trace.verbose((Object)this, "getProfileName", "Exception when trying to obtain profile name.");
            }
        }
        return this.profileName;
    }

    private void loadProfile() throws ConfigMgmtException {
        Trace.methodBegin(this, "loadProfile");
        ArrayList<CIMProperty> keyList = new ArrayList<CIMProperty>();
        keyList.add(new CIMProperty("InstanceID", new CIMValue((Object)this.getSourceProfileKey())));
        ManageStorageProfilesInterface msp = ManageStorageProfilesFactory.getManager();
        msp.init(this.context, null);
        this.profile = msp.getByKey(keyList);
        this.profileName = this.profile.getName();
    }

    public String getSourceProfileKey() {
        return this.sourceProfileKey;
    }

    public void setSourceProfileKey(String sourceProfileKey) {
        this.sourceProfileKey = sourceProfileKey;
    }

    public String[] getCIMObjectPropertyNames() {
        return Constants.StoragePoolProperties.PROP_LIST;
    }

    protected String getCIMPropNameForName() {
        return "ElementName";
    }

    protected void getAssociatedDomain() throws ConfigMgmtException {
        String methodName = "getAssociatedDomain";
        Trace.methodBegin(this, methodName);
        StringTokenizer st = new StringTokenizer(this.instanceID, ":");
        String t4IpAddress = null;
        if (st.hasMoreElements()) {
            st.nextElement();
            if (st.hasMoreElements()) {
                t4IpAddress = (String)st.nextElement();
            }
        }
        if (this.t4 == null) {
            this.loadT4(t4IpAddress);
        }
        if (this.t4 != null) {
            this.domainObjectPath = this.t4.getInstance().getObjectPath();
            this.domainName = this.t4.getName();
            Trace.verbose((Object)this, methodName, "domainObjectPath: " + this.domainObjectPath + "domainName: " + this.domainName);
        } else {
            ConfigMgmtException cme = new ConfigMgmtException("error.objectNotFound", "Could not lookup T4 instance with ipAddress: " + t4IpAddress);
            Trace.error((Object)this, cme);
        }
    }

    public boolean isDeletable() {
        return false;
    }

    protected CIMArgument[] buildInArgsForAddStorage(CIMObjectPath storageSettingOP, List raidSetGroups, BigInteger requestedSize) throws ConfigMgmtException {
        String METHOD = "buildInArgsForAddStorage";
        Trace.methodBegin(this, "buildInArgsForAddStorage");
        if (raidSetGroups == null || raidSetGroups.size() != 1 || ((RaidSetGroup)raidSetGroups.get(0)).getBreakdowns() == null || ((RaidSetGroup)raidSetGroups.get(0)).getBreakdowns().size() != 1) {
            Trace.verbose((Object)this, "buildInArgsForAddStorage", " Midrange provider support one VDisk creation at the time.");
            throw new ConfigMgmtException("ACTION_NOT_SUPPORTED", "Midrange provider support one VDisk creation at the time.");
        }
        RaidSetGroup.RaidSetBreakdown raidSetBreakdown = (RaidSetGroup.RaidSetBreakdown)((RaidSetGroup)raidSetGroups.get(0)).getBreakdowns().get(0);
        PoolBreakdownForTray poolBreakdown = raidSetBreakdown.getBreakdown();
        int poolIndex = raidSetBreakdown.getIndex();
        String poolName = poolBreakdown.getSuggestedName(poolIndex);
        boolean useSize = false;
        if (raidSetGroups == null || raidSetGroups.size() == 0) {
            useSize = true;
            Trace.verbose((Object)this, "buildInArgsForAddStorage", "will create args for size not extents.");
        }
        int cnt = 0;
        CIMArgument[] cimInArguments = new CIMArgument[7];
        CIMArgument ca = new CIMArgument("ElementName", new CIMValue((Object)poolName));
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("Goal", new CIMValue((Object)storageSettingOP));
        cimInArguments[cnt++] = ca;
        if (this.t4 == null) {
            this.loadT4(IPUtil.lookUpIP(this.getStorageDomainName()));
        }
        Vector<String> inPools = new Vector<String>();
        inPools.add(this.getInstance().getObjectPath().toString());
        ca = new CIMArgument("InPools", new CIMValue(inPools, new CIMDataType(22)));
        cimInArguments[cnt++] = ca;
        if (!useSize) {
            Vector<String> v = new Vector<String>();
            List disks = poolBreakdown.getDisksForPool(poolIndex);
            int disksSize = disks.size();
            for (int l = 0; l < disksSize; ++l) {
                v.add(((DiskInterface)disks.get(l)).getStorageExtentObjectPath().toString());
            }
            ca = new CIMArgument("InExtents", new CIMValue(v, new CIMDataType(22)));
        } else {
            ca = new CIMArgument("InExtents", new CIMValue(null));
        }
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("Pool", null);
        cimInArguments[cnt++] = ca;
        ca = useSize ? new CIMArgument("Size", new CIMValue((Object)new UnsignedInt64(requestedSize))) : new CIMArgument("Size", new CIMValue((Object)new UnsignedInt64(poolBreakdown.getPoolCapacity(poolIndex))));
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("JobDescription", new CIMValue((Object)("job.description.createpool + " + poolName)));
        cimInArguments[cnt++] = ca;
        if (Trace.isTraceEnabled(this)) {
            for (int i = 0; i < cimInArguments.length; ++i) {
                if (cimInArguments[i] != null) {
                    CIMValue val = cimInArguments[i].getValue();
                    if (val != null) {
                        Trace.verbose((Object)this, "buildInArgsForAddStorage", "Index: " + i + " have value: " + val.getValue());
                        continue;
                    }
                    Trace.verbose((Object)this, "buildInArgsForAddStorage", "Index: " + i + " have null CIMValue.");
                    continue;
                }
                Trace.verbose((Object)this, "buildInArgsForAddStorage", "index: " + i + " is null.");
            }
        }
        return cimInArguments;
    }

    public MethodCallStatus addStorageToPool(BigInteger storageAmount, int numDisks) throws ConfigMgmtException {
        String methodName = "addStorageToPool";
        Trace.methodBegin(this, methodName);
        MethodCallStatus mcs = null;
        if (this.profile == null) {
            this.loadProfile();
        }
        if (this.t4 == null) {
            this.loadT4(IPUtil.lookUpIP(this.getStorageDomainName()));
        }
        ArrayList<T4Interface> arraysToConsider = new ArrayList<T4Interface>();
        arraysToConsider.add(this.t4);
        CIMObjectPath setting = this.getNewSetting(numDisks);
        AvailableSpaceForRaidSets asfrs = new AvailableSpaceForRaidSets(this.context, this.profile.getArrayType(), this.profile.getSegmentSize(), this.profile.isReadAheadEnabled(), numDisks, this.profile.getRAIDLevel(), this.profile.dedicatedSpareExists(), arraysToConsider);
        RaidSetGroup raidSetGroup = asfrs.getRaidSetGroupForSize(storageAmount);
        if (raidSetGroup != null && raidSetGroup.getBreakdowns() != null) {
            List breakdowns = raidSetGroup.getBreakdowns();
            Iterator iter = breakdowns.iterator();
            while (iter.hasNext()) {
                RaidSetGroup.RaidSetBreakdown raidSetBreakdown = (RaidSetGroup.RaidSetBreakdown)iter.next();
                if (raidSetBreakdown == null) continue;
                RaidSetGroup newRaidSetGroup = new RaidSetGroup(raidSetBreakdown.getBreakdown(), raidSetBreakdown.getIndex(), this.profile.getArrayType());
                ArrayList<RaidSetGroup> raidSetGroups = new ArrayList<RaidSetGroup>();
                raidSetGroups.add(newRaidSetGroup);
                CIMArgument[] inArgs = this.buildInArgsForAddStorage(setting, raidSetGroups, null);
                mcs = this.makeCallToAddStorage(inArgs);
                Trace.verbose((Object)this, methodName, "Extrinsic method returned with code: " + mcs.getReturnCode());
            }
        } else {
            Trace.verbose((Object)this, methodName, "Storage amount " + storageAmount + " is not supported.");
            throw new ConfigMgmtException("se6x20ui.wizards.pool.error.sizenotsupported", "Storage amount  " + storageAmount + " is not supported.");
        }
        return mcs;
    }

    private void loadT4(String t4IpAddress) throws ConfigMgmtException {
        Trace.methodBegin(this, "loadT4");
        ManageT4sInterface mt4s = ManageT4sFactory.getManager();
        mt4s.init(this.context, null);
        this.t4 = mt4s.getT4ByIP(t4IpAddress);
    }

    public boolean isInUse() {
        boolean isInUse;
        String methodName = "sssisInUse";
        Trace.methodBegin(this, methodName);
        boolean bl = isInUse = !BigInteger.ZERO.equals(this.getStorageCapacity());
        if (isInUse) {
            return isInUse;
        }
        boolean isInUsePending = false;
        try {
            isInUsePending = this.isInUsePending();
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, methodName, (Throwable)cme);
        }
        return isInUsePending;
    }

    private boolean isInUsePending() throws ConfigMgmtException {
        String methodName = "isInUsePending";
        Trace.methodBegin(this, methodName);
        boolean isInUsePending = false;
        String t4IpAddress = IPUtil.lookUpIP(this.getStorageDomainName());
        if (this.t4 == null) {
            this.loadT4(t4IpAddress);
        }
        if (this.t4 != null) {
            QueuedPoolData qpd = this.t4.getQueuedPoolData();
            int numQueuedPools = qpd.getNumQueuedPools();
            for (int i = 0; i < numQueuedPools; ++i) {
                if (!this.getName().equals(qpd.getProfilePoolName(i))) continue;
                isInUsePending = true;
                break;
            }
        } else {
            ConfigMgmtException cme = new ConfigMgmtException("error.objectNotFound", "Could not lookup T4 instance with ipAddress: " + t4IpAddress);
            Trace.error((Object)this, cme);
            throw cme;
        }
        return isInUsePending;
    }

    public List getArrayControllers() throws ConfigMgmtException {
        String METHOD = "getArrayControllerNames";
        Trace.methodBegin(this, "getArrayControllerNames");
        return this.getAssociatedVDisks();
    }
}

