/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageRaidGroups;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStorageDomains;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.wbem.cim.CIMInstance;

public class StorageDomain
implements StorageDomainInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private String name;
    private String description;
    private BigInteger storageCapacity = BigInteger.ZERO;
    private BigInteger allocatedCapacity = BigInteger.ZERO;
    private BigInteger unallocatedCapacity = BigInteger.ZERO;
    private T4Interface t4;

    public StorageDomain(T4Interface t4) throws ConfigMgmtException {
        Trace.constructor(this);
        if (t4 == null) {
            Trace.error((Object)this, "StorageDomain(T4Interface)", "T4Interface object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "T4Interface object is null.");
        }
        this.t4 = t4;
    }

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        if (this.getDescription() != null && !this.getDescription().equals(this.t4.getDescription())) {
            this.t4.setDescription(this.description);
            this.t4.save();
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        this.name = null;
        this.description = null;
        this.storageCapacity = BigInteger.ZERO;
        this.allocatedCapacity = BigInteger.ZERO;
        this.unallocatedCapacity = BigInteger.ZERO;
        this.t4.reload();
    }

    public String getName() {
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            this.name = this.t4.getName();
        }
        return this.name;
    }

    public String getDescription() {
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            this.description = this.t4.getDescription();
        }
        return this.description;
    }

    public Collection getKeys() {
        return null;
    }

    public CIMInstance getCIMInstance() {
        return this.t4.getInstance();
    }

    public ConfigContext getConfigContext() {
        return this.context;
    }

    public boolean isDeletable() {
        Trace.verbose((Object)this, "isDeletable", "Method not implemented.");
        return false;
    }

    public BigInteger getStorageCapacity() throws ConfigMgmtException {
        Trace.methodBegin(this, "getStorageCapacity");
        return this.storageCapacity;
    }

    public BigInteger getAllocatedCapacity() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAllocatedCapacity");
        if (this.allocatedCapacity == BigInteger.ZERO) {
            this.allocatedCapacity = this.getStorageCapacity().subtract(this.getUnAllocatedCapacity());
            Trace.verbose((Object)this, "getAllocatedCapacity", "value: " + this.allocatedCapacity);
        }
        return this.allocatedCapacity;
    }

    public BigInteger getUnAllocatedCapacity() throws ConfigMgmtException {
        Trace.methodBegin(this, "getUnAllocatedCapacity");
        return this.unallocatedCapacity;
    }

    public List getAssocPools() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocPools");
        ManageStoragePools manager = new ManageStoragePools();
        manager.init(this.context, null);
        ArrayList assocPools = null;
        try {
            assocPools = manager.getItemsByStorageDomain(this.getName());
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getAssocPools", (Throwable)infe);
            throw new ConfigMgmtException("error.objectNotFound", "Problems getting associated StoragePools.", infe);
        }
        return assocPools;
    }

    public List getAssocVDisks() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocVDisks");
        ManageRaidGroups manager = new ManageRaidGroups();
        manager.init(this.context, null);
        manager.setScope(this.t4);
        return manager.getItemList();
    }

    public List getAssocVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocVolumes");
        ManageStorageVolumes manager = new ManageStorageVolumes();
        manager.init(this.context, null);
        manager.setScope(this.t4);
        return manager.getItemList();
    }

    public List getAssocVolumeGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocVolumeGroups");
        ManageVolumeGroupsInterface manager = ManageVolumeGroupsFactory.getManager();
        manager.init(this.context, null);
        manager.setScope(this.t4);
        return manager.getItemList();
    }

    public List getAssocArrays() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocArrays");
        ArrayList<T4Interface> assocArrays = new ArrayList<T4Interface>();
        assocArrays.add(this.t4);
        return assocArrays;
    }

    public List getAssocInitiators() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocInitiators");
        return new ArrayList();
    }

    public MethodCallStatus addInitiators(Collection initiators) throws ConfigMgmtException {
        Trace.methodBegin(this, "addInitiators");
        Trace.verbose((Object)this, "addInitiators", "Method not implemented.");
        return null;
    }

    public void setDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "setDescription");
        Trace.verbose((Object)this, "setDescription", "Validating description: " + description);
        ManageStorageDomains msd = new ManageStorageDomains();
        msd.validateDescription(description);
        this.description = description;
    }
}

