/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.T4;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ManageTrays
implements ManageTraysInterface {
    private ArrayList trayList;
    private ConfigContext context;
    private SearchFilter filter;
    private InstanceWrapper scope;

    public ManageTrays() {
        Trace.constructor(this);
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
        this.scope = scope;
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        this.trayList = new ArrayList();
        try {
            CIMOMHandleWrapper cimClient = context.getClient();
            Trace.verbose((Object)this, "init", "calling getCIMChassisEnum() to get Chassis objects from CIMOM!!");
            Enumeration enumChassis = this.getCIMChassisEnum(cimClient);
            Trace.verbose((Object)this, "init", "Chassis Enumeration is NULL: " + (enumChassis == null));
            while (enumChassis.hasMoreElements()) {
                CIMInstance trayCimInstance = (CIMInstance)enumChassis.nextElement();
                Trace.verbose((Object)this, "init", "Got the CIM Chassis instance!!");
                if (filter == null || filter.isEmpty() || filter.passesFilter(trayCimInstance)) {
                    Trace.verbose((Object)this, "init", "Either search filter is not null or CIM Chassis instance passes filter: loading Tray object with properties!!");
                    this.loadTrayProperty(trayCimInstance);
                    continue;
                }
                Trace.verbose((Object)this, "init", "Tray CIM Instance did not pass filter: Tray object is NOT being created!!");
            }
        }
        catch (NullPointerException ne) {
            Trace.verbose((Object)this, "Null value returned while loading up Tray objects!!", (Throwable)ne);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null value returned error.", ne);
        }
        if (this.trayList != null) {
            Collections.sort(this.trayList);
        }
        Trace.verbose((Object)this, "init", "finished init Tray: number of Tray in list: " + this.trayList.size());
        for (int j = 0; j < this.trayList.size(); ++j) {
            Trace.verbose((Object)this, "init", "Tray " + j + ": name: " + ((Tray)this.trayList.get(j)).getId());
            Trace.verbose((Object)this, "init", "Tray " + j + ": tray type: " + ((Tray)this.trayList.get(j)).getTrayType());
            Trace.verbose((Object)this, "init", "*************************");
        }
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return this.trayList;
    }

    public void deleteItem(int index) throws ConfigMgmtException, IndexOutOfBoundsException {
        Trace.methodBegin(this, "deleteItem");
    }

    public void deleteItems(int[] indices) throws ConfigMgmtException, IndexOutOfBoundsException {
        Trace.methodBegin(this, "deleteItems");
    }

    private Enumeration getCIMChassisEnum(CIMOMHandleWrapper cimClient) throws ConfigMgmtException {
        Trace.methodBegin(this, "getCIMChassisEnum");
        Enumeration enumChassis = null;
        if (cimClient != null) {
            String[] chassisPropList = new String[]{"Tag", "ChassisTypes", "CreationClassName", "OtherIdentifyingInfo"};
            try {
                if (this.scope instanceof T4Interface) {
                    Trace.verbose((Object)this, "getCIMChassisEnum", "Getting CIM Chassis is scoped to a particular T4: only Trays within a T4 will be returned!! !");
                    enumChassis = CIMObjectWrapper.execQuery(cimClient, "select * from SunStorEdge_6120Chassis where Tag like '" + ((T4)this.scope).getClusterName() + ":%'");
                }
                Trace.verbose((Object)this, "getCIMChassisEnum", "No scope is defined to get CIM Chassis: getting all Chassis (Trays) across all T4s");
                CIMObjectPath chassisOP = new CIMObjectPath("SunStorEdge_6120Chassis");
                Trace.verbose((Object)this, "getCIMChassisEnum", "CIM Chassis ObjectPath is null: " + (chassisOP == null));
                enumChassis = cimClient.enumerateInstances(chassisOP, false, false, true, false, chassisPropList);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getCIMChassisEnum", "Failed: " + cme.getMessage());
                throw cme;
            }
        } else {
            Trace.verbose((Object)this, "getCIMChassisEnum", "CIMOMHandleWrapper is not null: cannot walk the association!!");
        }
        return enumChassis;
    }

    private ArrayList generateTrayMapElements() {
        Trace.methodBegin(this, "generateTrayMapElements");
        ArrayList<MapElement> cimJavaMapElementList = new ArrayList<MapElement>();
        Trace.verbose((Object)this, "generateTrayMapElements", "adding CIM Chassis and Tray prop names mapping to MapElement list!");
        cimJavaMapElementList.add(new MapElement("chassisTag", "Tag", true, false));
        cimJavaMapElementList.add(new MapElement("trayType", "ChassisTypes", true, false, 0));
        cimJavaMapElementList.add(new MapElement("unitId", "OtherIdentifyingInfo", true, true));
        Trace.verbose((Object)this, "generateTrayMapElements", "Tray map element list contains " + cimJavaMapElementList.size() + " properties");
        for (int j = 0; j < cimJavaMapElementList.size(); ++j) {
            Trace.verbose((Object)this, "generateTrayMapElements", "Java property: " + ((MapElement)cimJavaMapElementList.get(j)).getJavaField());
            Trace.verbose((Object)this, "generateTrayMapElements", "cim property: " + ((MapElement)cimJavaMapElementList.get(j)).getCimProperty());
            Trace.verbose((Object)this, "generateTrayMapElements", "************************");
        }
        return cimJavaMapElementList;
    }

    private void loadTrayProperty(CIMInstance trayCimInstance) throws ConfigMgmtException {
        Trace.methodBegin(this, "loadTrayProperty");
        Tray theTray = new Tray();
        theTray.init(this.context);
        theTray.setCIMInstance(trayCimInstance);
        ArrayList propMapList = this.generateTrayMapElements();
        Trace.verbose((Object)this, "loadTrayProperty", "calling populate method to load up the Tray object");
        CIMObjectWrapper.populate(theTray, propMapList, trayCimInstance);
        theTray.setMapElementList(propMapList);
        Trace.verbose((Object)this, "loadTrayProperty", "Tray prop: id= " + theTray.getId());
        Trace.verbose((Object)this, "loadTrayProperty", "Tray prop: trayType= " + theTray.getTrayType());
        Trace.verbose((Object)this, "loadTrayProperty", "Tray prop: unitId= " + theTray.getUnitId());
        if (this.scope instanceof T4Interface) {
            Trace.verbose((Object)this, "loadTrayProperty", "Scope is T4: setting t4CIMObjectPath and t4Interface properties in Tray!!");
            theTray.setT4CimObjectPath(((T4)this.scope).getInstance().getObjectPath());
            theTray.setT4Interface((T4Interface)this.scope);
        }
        this.trayList.add(theTray);
        Trace.verbose((Object)this, "loadTrayProperty", "A Tray just added to list");
    }

    public int getItemCount() throws ConfigMgmtException {
        return 0;
    }

    public void init(ConfigContext context, Object scope, SearchFilter filter) throws ConfigMgmtException {
    }

    public boolean isOperationSupported(String operation) {
        return false;
    }

    public void modify(Object key, Properties props) {
    }

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
    }
}

