/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.T4;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.UnsignedInt16;

public class ManageT4s
implements ManageT4sInterface {
    private ArrayList t4List;
    private ConfigContext context;
    private SearchFilter filter;
    private boolean havePerformedLookup = false;

    public ManageT4s() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.havePerformedLookup = false;
        this.context = context;
        this.filter = filter;
        this.t4List = new ArrayList();
    }

    private void doLookup() throws ConfigMgmtException {
        Trace.methodBegin(this, "doLookup");
        try {
            CIMOMHandleWrapper cimClient = this.context.getClient();
            Trace.verbose((Object)this, "doLookup", "Going to CIMOM to get Cluster Class ObjectPath!");
            CIMObjectPath clusterOP = new CIMObjectPath("SunStorEdge_6120Cluster");
            Trace.verbose((Object)this, "doLookup", "CIMCluster Object Path from CIMOM is NULL: " + (clusterOP == null));
            Trace.verbose((Object)this, "doLookup", "Getting an enumeration of Cluster CIM Instance objects!!");
            Enumeration clusterEnum = cimClient.enumerateInstances(clusterOP, false, false, true, false, Constants.ClusterProperties.CLUSTER_PROP_LIST);
            Trace.verbose((Object)this, "doLookup", "Cluster Enumeration is NULL: " + (clusterEnum == null));
            if (this.filter != null) {
                Object searchNameInIP = null;
                if (this.filter.getSearchField().equals("Name")) {
                    Trace.verbose((Object)this, "doLookup", "Search is on T4 Name: set conversion method to convert hostname into IP address");
                    this.filter.setConversionMethod("com.sun.netstorage.array.mgmt.cfg.util.IPUtil", "lookUpHostName");
                }
            }
            while (clusterEnum.hasMoreElements()) {
                CIMInstance t4CimInstance = (CIMInstance)clusterEnum.nextElement();
                Trace.verbose((Object)this, "doLookup", "Got the CIM Cluster instance!!");
                if (this.filter == null || this.filter.isEmpty() || this.filter.passesFilter(t4CimInstance)) {
                    Trace.verbose((Object)this, "doLookup", "Either search filter is not null or CIM Cluster instance passes filter: loading T4 object with properties!!");
                    this.loadT4Property(t4CimInstance);
                    continue;
                }
                Trace.verbose((Object)this, "doLookup", "Cluster CIMInstance did not pass filter: T4 object is NOT being created!!");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "doLookup", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException ne) {
            Trace.verbose((Object)this, "Null value returned while loading up T4 objects", (Throwable)ne);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null value returned error.", ne);
        }
        finally {
            this.havePerformedLookup = true;
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "init", "finished init T4: number of T4 in list: " + this.t4List.size());
            for (int j = 0; j < this.t4List.size(); ++j) {
                Trace.verbose((Object)this, "init", "T4 " + j + ": name: " + ((T4)this.t4List.get(j)).getName());
                Trace.verbose((Object)this, "init", "T4 " + j + ": description: " + ((T4)this.t4List.get(j)).getDescription());
            }
        }
    }

    public int getConnectivityStatus(ConfigContext context, String ipAddress) {
        Trace.methodBegin(this, "getConnectivityStatus");
        return 2;
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        if (!this.havePerformedLookup) {
            Trace.verbose((Object)this, "getItemList", "Performing lookup.");
            this.doLookup();
        }
        if (this.t4List != null) {
            Trace.verbose((Object)this, "getItemList", "Performing sort");
            Collections.sort(this.t4List, new T4Comparator(this.context.getLocale()));
        }
        Trace.verbose((Object)this, "getItemList", "Returning list of size: " + this.t4List.size());
        return this.t4List;
    }

    public T4Interface getT4ByName(String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4ByName");
        String ip = Repository.getRepository().getIpAddress(name);
        return this.getT4ByIP(ip);
    }

    public T4Interface getT4ByIP(String ip) throws ConfigMgmtException {
        String METHOD = "getT4ByIP";
        Trace.methodBegin(this, "getT4ByIP");
        try {
            Enumeration e = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_6120Cluster where Name = '" + ip + "'");
            if (e == null || !e.hasMoreElements()) {
                Trace.verbose((Object)this, "getT4ByIP", "No T4 object found for IP address: " + ip);
                throw new ZeroCIMInstanceReturnedException("ZERO_CIM_INSTANCE_RETURNED", "No T4 object found for IP address: " + ip);
            }
            CIMInstance ci = (CIMInstance)e.nextElement();
            this.loadT4Property(ci);
            this.havePerformedLookup = true;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getT4ByIP", "Failed: " + cme.getMessage());
            throw cme;
        }
        return (T4Interface)this.t4List.get(0);
    }

    private void loadT4Property(CIMInstance t4CimInstance) throws ConfigMgmtException {
        String METHOD = "loadT4Property";
        Trace.methodBegin(this, "loadT4Property");
        T4 tee4 = new T4();
        tee4.init(this.context);
        tee4.setCIMInstance(t4CimInstance);
        Trace.verbose((Object)this, "loadT4Property", "calling methods to load up map elements from Cluster and ClusterSetting");
        ArrayList clusterPropMapList = (ArrayList)this.generateT4ClusterMapElements();
        Trace.verbose((Object)this, "loadT4Property", "calling populate method to load up the T4 object from Cluster");
        CIMObjectWrapper.populate(tee4, clusterPropMapList, t4CimInstance);
        tee4.setClusterMapElementList(clusterPropMapList);
        Trace.verbose((Object)this, "loadT4Property", "T4 prop: name= " + tee4.getName());
        Trace.verbose((Object)this, "loadT4Property", "T4 prop: description= " + tee4.getDescription());
        boolean found = false;
        for (int j = 0; j < this.t4List.size(); ++j) {
            T4 tempT4 = (T4)this.t4List.get(j);
            if (!tempT4.getName().equals(tee4.getName())) continue;
            Trace.verbose((Object)this, "loadT4Property", "Found duplicate T4, ignoring.");
            found = true;
            break;
        }
        if (!found) {
            this.t4List.add(tee4);
        }
        Trace.verbose((Object)this, "loadT4Property", "A T4 just added to list");
    }

    private Collection generateT4ClusterMapElements() {
        Trace.methodBegin(this, "generateT4ClusterMapElements");
        ArrayList<MapElement> cimJavaMapElementList = new ArrayList<MapElement>();
        Trace.verbose((Object)this, "generateT4ClusterMapElements", "adding CIM Cluster and T4 prop names mapping to MapElement list!");
        cimJavaMapElementList.add(new MapElement("clusterName", "Name", true, false));
        cimJavaMapElementList.add(new MapElement("description", "Caption", false, true));
        cimJavaMapElementList.add(new MapElement("healthStatus", "OperationalStatus", true, false, 0));
        cimJavaMapElementList.add(new MapStringArrayToString("firmwareVersion", "OtherIdentifyingInfo", true, true, 1));
        cimJavaMapElementList.add(new MapElement("maxDisksAvailWithRedun", "MaxDisksAvailableForUseWithRedundancy", true, true));
        cimJavaMapElementList.add(new MapElement("maxDisksAvailNoRedun", "MaxDisksAvailableForUseNoRedundancy", true, true));
        cimJavaMapElementList.add(new MapElement("enabledState", "EnabledState", true, true));
        cimJavaMapElementList.add(new MapElement("numControllerTrays", "NumberOfControllerChassis", true, true));
        cimJavaMapElementList.add(new MapElement("numExpansionTrays", "NumberOfExpansionChassis", true, true));
        Trace.verbose((Object)this, "generateT4ClusterMapElements", "T4 map element list from Cluster contains " + cimJavaMapElementList.size() + " properties");
        for (int j = 0; j < cimJavaMapElementList.size(); ++j) {
            Trace.verbose((Object)this, "generateT4ClusterMapElements", "Java property: " + ((MapElement)cimJavaMapElementList.get(j)).getJavaField());
            Trace.verbose((Object)this, "generateT4ClusterMapElements", "cim property: " + ((MapElement)cimJavaMapElementList.get(j)).getCimProperty());
            Trace.verbose((Object)this, "generateT4ClusterMapElements", "isReadOnly? " + ((MapElement)cimJavaMapElementList.get(j)).isReadOnly());
            Trace.verbose((Object)this, "generateT4ClusterMapElements", "************************");
        }
        return cimJavaMapElementList;
    }

    public boolean areAllArraysHealthy() throws ConfigMgmtException {
        String methodName = "areAllArraysHealthy";
        Trace.methodBegin(this, methodName);
        boolean result = true;
        Enumeration allClusters = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_6120Cluster");
        if (allClusters != null) {
            while (allClusters.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)allClusters.nextElement();
                try {
                    Vector operationalStatus = (Vector)ci.getProperty("OperationalStatus").getValue().getValue();
                    int arrayHealth = ((UnsignedInt16)operationalStatus.get(0)).intValue();
                    if (arrayHealth == 2) continue;
                    result = false;
                    break;
                }
                catch (Exception e) {
                    ConfigMgmtException cme = new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems extracting OperationalStatus for object path: " + ci.getObjectPath(), e);
                    Trace.error((Object)this, cme);
                    throw cme;
                }
            }
        }
        Trace.verbose((Object)this, methodName, "All arrays are healthy. = " + result);
        return result;
    }

    public List getPossibleDuplicateArrays(T4Interface srcT4, List possibleDestinations) throws ConfigMgmtException {
        String METHOD = "getPossibleDuplicateArrays";
        Trace.methodBegin(this, "getPossibleDuplicateArrays");
        ArrayList<T4Interface> possibles = new ArrayList<T4Interface>();
        if (srcT4 == null || possibleDestinations == null) {
            Trace.verbose((Object)this, "getPossibleDuplicateArrays", "Received null arguments, returning.");
            return possibles;
        }
        Iterator i = possibleDestinations.iterator();
        while (i.hasNext()) {
            T4Interface cand = (T4Interface)i.next();
            if (srcT4.getClusterName().equals(cand.getClusterName()) || !srcT4.isDuplicateCandidate(cand)) continue;
            Trace.verbose((Object)this, "getPossibleDuplicateArrays", "Found candidate for destination: " + cand.getName());
            possibles.add(cand);
        }
        return possibles;
    }

    private class T4Comparator
    implements Comparator {
        Collator collator = null;

        T4Comparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof T4 && element2 instanceof T4) {
                key1 = this.collator.getCollationKey(((T4)element1).getName());
                key2 = this.collator.getCollationKey(((T4)element2).getName());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

