/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageDomainsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StorageDomain;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class ManageStorageDomains
implements ManageStorageDomainsInterface {
    private ArrayList sdList;
    private ConfigContext context;
    private SearchFilter filter;
    private ManageT4sInterface t4Manager;

    public ManageStorageDomains() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.verbose((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.filter = filter;
        this.sdList = new ArrayList();
    }

    public List getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        this.sdList = new ArrayList();
        List t4s = this.getT4Manager().getItemList();
        Iterator iter = t4s.iterator();
        while (iter.hasNext()) {
            T4Interface t4 = (T4Interface)iter.next();
            StorageDomain domain = new StorageDomain(t4);
            domain.init(this.context);
            this.sdList.add(domain);
        }
        return this.sdList;
    }

    public StorageDomainInterface getItemByName(String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByName");
        T4Interface t4 = this.getT4Manager().getT4ByName(name);
        StorageDomain domain = new StorageDomain(t4);
        domain.init(this.context);
        return domain;
    }

    public StorageDomainInterface getByKey(Collection props) throws ConfigMgmtException {
        Trace.methodBegin(this, "getByKey");
        return null;
    }

    private ManageT4sInterface getT4Manager() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Manager");
        if (this.t4Manager == null) {
            this.t4Manager = ManageT4sFactory.getManager();
            this.t4Manager.init(this.context, this.filter);
        }
        return this.t4Manager;
    }

    public MethodCallStatus create(String name, String description) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "create");
        Trace.verbose((Object)this, "create", "Method not implemented.");
        throw new ConfigMgmtException("METHOD_NOT_SUPPORTED", "create method not implemented.");
    }

    public MethodCallStatus delete(String name) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "delete(String)");
        Trace.verbose((Object)this, "delete(String)", "Method not implemented.");
        throw new ConfigMgmtException("METHOD_NOT_SUPPORTED", "create method not implemented.");
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "delete(Collection)");
        Trace.verbose((Object)this, "delete(Collection)", "Method not implemented.");
        throw new ConfigMgmtException("METHOD_NOT_SUPPORTED", "create method not implemented.");
    }

    public MethodCallStatus delete(StorageDomainInterface storageDomain) throws ConfigMgmtException {
        Trace.methodBegin(this, "delete(StorageDomainInterface)");
        Trace.verbose((Object)this, "delete(StorageDomainInterface)", "Method not implemented.");
        throw new ConfigMgmtException("METHOD_NOT_SUPPORTED", "create method not implemented.");
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        Trace.methodBegin(this, "getNextAvailableName");
        Trace.verbose((Object)this, "getNextAvailableName", "Method not implemented.");
        throw new ConfigMgmtException("METHOD_NOT_SUPPORTED", "create method not implemented.");
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "validateName");
        Trace.verbose((Object)this, "validateName", "Method not implemented.");
    }

    public void validateDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "validateDescription");
        if (description != null) {
            if (description.length() > 64) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " is too long.");
                throw new BadParameterException(description, "error.bizobj.descriptionTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", description)) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " contains invalid characters.");
                throw new BadParameterException(description, "error.bizobj.invalidDescCharacter");
            }
        }
    }
}

