/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.RaidGroup;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.T4;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ManageRaidGroups
implements ManageRaidGroupsInterface,
Constants.StorageCapabilitiesProperties {
    private static final int HOT_SPARE_SLOT_INDEX = 14;
    private ArrayList raidGroupList;
    private ConfigContext context;
    private SearchFilter filter;
    private InstanceWrapper scope;
    private static ArrayList mapElements = null;
    public static final String[] STORAGE_POOL_PROP_LIST = new String[]{"ElementName", "InstanceID", "TotalManagedSpace", "MaxVolumeSizeAvailable", "OperationalStatus", "ChassisID", "SystemName", "StatusDescriptions"};
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$ManageRaidGroups;

    public ManageRaidGroups() {
        Trace.constructor(this);
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
        this.scope = scope;
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        this.raidGroupList = new ArrayList();
        try {
            if (filter != null && "Description".equals(filter.getSearchField())) {
                if ("".equals(filter.getSearchString().trim())) {
                    if (filter.isExactSearch()) {
                        Trace.verbose((Object)this, "init", "Empty search string - exact search.");
                        return;
                    }
                    filter = null;
                    Trace.verbose((Object)this, "init", "Empty search string - contains search.");
                } else {
                    Trace.verbose((Object)this, "init", "Search string is: " + filter.getSearchString());
                    List instanceIds = this.getAllInstanceIdsForProfile(filter);
                    if (instanceIds.size() == 0) {
                        Trace.verbose((Object)this, "init", "Profile <" + filter.getSearchString() + "> is not used.");
                        return;
                    }
                    StringBuffer regex = new StringBuffer("(");
                    Iterator iter = instanceIds.iterator();
                    while (iter.hasNext()) {
                        regex.append("^" + (String)iter.next() + "$");
                        if (!iter.hasNext()) continue;
                        regex.append("|");
                    }
                    regex.append(")");
                    filter = new SearchFilter("InstanceID", Pattern.compile(regex.toString()));
                }
            }
            CIMOMHandleWrapper cimClient = context.getClient();
            Trace.verbose((Object)this, "init", "calling getCIMStoragePoolEnum() to get StoragePool objects from CIMOM!!");
            Enumeration enumSPool = this.getCIMStoragePoolEnum(cimClient);
            Trace.verbose((Object)this, "init", "StoragePool Enumeration is NULL: " + (enumSPool == null));
            while (enumSPool.hasMoreElements()) {
                CIMInstance raidGroupCimInstance = (CIMInstance)enumSPool.nextElement();
                Trace.verbose((Object)this, "init", "Got the CIM StoragePool instance!!");
                if (filter == null || filter.isEmpty() || filter.passesFilter(raidGroupCimInstance)) {
                    Trace.verbose((Object)this, "init", "Either search filter is not null or CIM StoragePool instance passes filter: loading RaidGroup object with properties!!");
                    this.loadRaidGroupProperty(raidGroupCimInstance);
                    continue;
                }
                Trace.verbose((Object)this, "init", "RaidGroup CIM Instance did not pass filter: RaidGroup object is NOT being created!!");
            }
            if (this.raidGroupList.size() > 1) {
                Trace.verbose((Object)this, "init", "Performing sort");
                Collections.sort(this.raidGroupList, new RaidGroupComparator(context.getLocale()));
            }
        }
        catch (NullPointerException ne) {
            Trace.verbose((Object)this, "Null value returned while loading up RaidGroup objects!!", (Throwable)ne);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null value returned error.", ne);
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "init", "finished init RaidGroup: number of RaidGroup in list: " + this.raidGroupList.size());
            for (int j = 0; j < this.raidGroupList.size(); ++j) {
                RaidGroup raidGroup = (RaidGroup)this.raidGroupList.get(j);
                Trace.verbose((Object)this, "init", "RaidGroup " + j + ": \nname: " + raidGroup.getName() + "\ntotalCapacity: " + raidGroup.getTotalCapacity() + "\nstatus: " + raidGroup.getStatus() + "\nstate: " + raidGroup.getState());
            }
        }
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return this.raidGroupList;
    }

    private List getAllInstanceIdsForProfile(SearchFilter profileFilter) throws ConfigMgmtException {
        String methodName = "getAllInstanceIDsForProfile";
        Trace.methodBegin(this, methodName);
        ArrayList<String> instanceIds = new ArrayList<String>();
        Pattern profilePattern = null;
        String profileName = profileFilter.getSearchString();
        profilePattern = profileFilter.isExactSearch() ? Pattern.compile("^" + profileName + "$", 66) : Pattern.compile(profileName, 66);
        Enumeration poolCapabilities = CIMObjectWrapper.execQuery(this.context.getClient(), "Select Description, InstanceID from SunStorEdge_6120PoolStorageCapabilities");
        if (poolCapabilities != null) {
            while (poolCapabilities.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)poolCapabilities.nextElement();
                String instanceId = null;
                String description = null;
                try {
                    description = (String)ci.getProperty("Description").getValue().getValue();
                    if (!profilePattern.matcher(description).find()) continue;
                    instanceId = (String)ci.getProperty("InstanceID").getValue().getValue();
                    instanceIds.add(instanceId);
                }
                catch (NullPointerException npe) {
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, methodName, "Found null 'InstanceID' for object path: " + ci.getObjectPath());
                }
            }
        }
        Trace.verbose((Object)this, methodName, "Number of pools with the same profile is " + instanceIds.size());
        return instanceIds;
    }

    private Enumeration getCIMStoragePoolEnum(CIMOMHandleWrapper cimClient) throws ConfigMgmtException {
        Trace.methodBegin(this, "getCIMStoragePoolEnum");
        Enumeration enumSPool = null;
        if (cimClient != null) {
            try {
                if (this.scope instanceof T4Interface) {
                    Trace.verbose((Object)this, "getCIMStoragePoolEnum", "Scoped by T4. execQuery with SystemName property.");
                    enumSPool = CIMObjectWrapper.execQuery(cimClient, "Select * from SunStorEdge_6120StoragePool where SystemName = '" + ((T4Interface)this.scope).getClusterName() + "'");
                }
                if (this.scope instanceof TrayInterface) {
                    Trace.verbose((Object)this, "getCIMStoragePoolEnum", "scoped to Tray: using StorageExtent ObjectPath from Disk object inside Tray to shorten the walk to StoragePool!");
                    enumSPool = this.getStoragePoolFromDisks(cimClient);
                }
                Trace.verbose((Object)this, "getCIMStoragePoolEnum", "no scope: getting all the StoragePool across all T4s!!");
                CIMObjectPath storagePoolOP = new CIMObjectPath("SunStorEdge_6120StoragePool");
                enumSPool = cimClient.enumerateInstances(storagePoolOP, false, false, true, false, STORAGE_POOL_PROP_LIST);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getCIMStoragePoolEnum", "Failed: " + cme.getMessage());
                throw cme;
            }
        } else {
            Trace.verbose((Object)this, "getCIMStoragePoolEnum", "CIMClient handle is not null: cannot walk the association!!");
        }
        return enumSPool;
    }

    private Enumeration getStoragePoolFromDisks(CIMOMHandleWrapper cimClient) throws ConfigMgmtException {
        Trace.methodBegin(this, "getStoragePoolFromDisks");
        Trace.verbose((Object)this, "getStoragePoolFromDisks", "Getting all the Disks in the Tray in which this RaidGroup Manager is scoped at!");
        ManageDisks diskManager = ((Tray)this.scope).getDisks();
        Trace.verbose((Object)this, "getStoragePoolFromDisks", "Number of Disk in the Tray: " + diskManager.getNumberOfDisk());
        HashSet<String> namesOfPools = new HashSet<String>();
        Enumeration enumPools = null;
        try {
            List disks = diskManager.getItemList();
            Iterator iDisks = disks.iterator();
            while (iDisks.hasNext()) {
                DiskInterface d = (DiskInterface)iDisks.next();
                if (!d.getRole().equals("dataDisk")) continue;
                namesOfPools.add(d.getRaidGroupName());
                Trace.verbose((Object)this, "getStoragePoolFromDisks", "Found pool name: " + d.getRaidGroupName() + " on tray.");
            }
            if (namesOfPools.size() > 0) {
                Trace.verbose((Object)this, "getStoragePoolFromDisks", "Will get pools from disks.");
                StringBuffer query = new StringBuffer("Select * from SunStorEdge_6120StoragePool where SystemName = '" + ((Tray)this.scope).getT4IPAddress() + "' AND (");
                Iterator iNames = namesOfPools.iterator();
                boolean firstTime = true;
                while (iNames.hasNext()) {
                    if (!firstTime) {
                        query.append(" OR ");
                    }
                    firstTime = false;
                    query.append("ElementName= '" + (String)iNames.next() + "'");
                }
                query.append(")");
                Trace.verbose((Object)this, "getStoragePoolFromDisks", "Query: " + query);
                enumPools = CIMObjectWrapper.execQuery(cimClient, query.toString());
            } else {
                Trace.verbose((Object)this, "getStoragePoolFromDisks", "No pools on this tray, returning empty enumeration.");
                enumPools = Collections.enumeration(namesOfPools);
            }
            return enumPools;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getStoragePoolFromDisks", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException ne) {
            Trace.verbose((Object)this, "Null found when finding pools from disks.", (Throwable)ne);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null value returned error.", ne);
        }
    }

    public static ArrayList generateRaidGroupMapElements() {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$ManageRaidGroups == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$ManageRaidGroups = ManageRaidGroups.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageRaidGroups")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$ManageRaidGroups, "generateRaidGroupMapElements");
        if (mapElements == null) {
            ArrayList<MapElement> cimJavaMapElementList = new ArrayList<MapElement>();
            cimJavaMapElementList.add(new MapElement("name", "ElementName", true, false));
            cimJavaMapElementList.add(new MapElement("instanceId", "InstanceID", true, false));
            cimJavaMapElementList.add(new MapElement("totalCapacity", "TotalManagedSpace", true, false));
            cimJavaMapElementList.add(new MapElement("cimStatus", "OperationalStatus", false, true, 0));
            cimJavaMapElementList.add(new MapElement("status", "StatusDescriptions", true, true, 1));
            cimJavaMapElementList.add(new MapElement("state", "StatusDescriptions", true, true, 2));
            cimJavaMapElementList.add(new MapElement("maxVolumeSizeAvailable", "MaxVolumeSizeAvailable", true, false));
            cimJavaMapElementList.add(new MapElement("trayIdInt", "ChassisID", true, false));
            cimJavaMapElementList.add(new MapElement("t4IpAddress", "SystemName", true, false));
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$ManageRaidGroups == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$ManageRaidGroups = ManageRaidGroups.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageRaidGroups")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$ManageRaidGroups, "generateRaidGroupMapElements", "RaidGroup map element list contains " + cimJavaMapElementList.size() + " properties");
            mapElements = cimJavaMapElementList;
        }
        return mapElements;
    }

    private void loadRaidGroupProperty(CIMInstance raidGroupCimInstance) throws ConfigMgmtException {
        Trace.methodBegin(this, "loadRaidGroupProperty");
        RaidGroup theRaidGroup = new RaidGroup();
        theRaidGroup.init(this.context);
        theRaidGroup.setCIMInstance(raidGroupCimInstance);
        ArrayList propMapList = ManageRaidGroups.generateRaidGroupMapElements();
        Trace.verbose((Object)this, "loadRaidGroupProperty", "populating the RaidGroup object");
        CIMObjectWrapper.populate(theRaidGroup, propMapList, raidGroupCimInstance);
        theRaidGroup.setMapElementList(propMapList);
        Trace.verbose((Object)this, "loadRaidGroupProperty", "\n\tRaidGroup prop: name= " + theRaidGroup.getName() + "\n\tRaidGroup prop: instanceId= " + theRaidGroup.getInstanceId() + "\n\tRaidGroup prop: totalCapacity= " + theRaidGroup.getTotalCapacity() + "\n\tRaidGroup prop: status= " + theRaidGroup.getStatus());
        if (this.scope instanceof TrayInterface) {
            Trace.verbose((Object)this, "loadRaidGroupProperty", "Scope is Tray: setting number of drives property in RaidGroup!!");
            ManageDisks diskManager = ((Tray)this.scope).getDisks();
            int numberOfDrives = 0;
            Iterator iDisks = diskManager.getItemList().iterator();
            while (iDisks.hasNext()) {
                DiskInterface disk = (DiskInterface)iDisks.next();
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "loadRaidGroupProperty", "\n\tExamining disk: " + disk.getName() + "\n\tDisk belongs to pools: " + disk.getRaidGroupName() + "\n\tRaidGroup Name: " + theRaidGroup.getName());
                }
                if (!theRaidGroup.getName().equals(disk.getRaidGroupName()) || !"dataDisk".equals(disk.getRole())) continue;
                Trace.verbose((Object)this, "loadRaidGroupProperty", "Found a disk that is associated with the RaidGroup being created!");
                theRaidGroup.addDiskNumber(disk.getSlotNumber());
                ++numberOfDrives;
            }
            Trace.verbose((Object)this, "loadRaidGroupProperty", "number of drives in RaidGroup: " + numberOfDrives);
            theRaidGroup.setNumberOfDrives(numberOfDrives);
            Trace.verbose((Object)this, "loadRaidGroupProperty", "Scope is Tray: setting t4CIMObjectPath and t4Interface properties in RaidGroup.");
            theRaidGroup.setT4CIMObjectPath(((Tray)this.scope).getT4CimObjectPath());
            theRaidGroup.setT4Interface(((Tray)this.scope).getT4Interface());
        }
        if (this.scope instanceof T4Interface) {
            Trace.verbose((Object)this, "loadRaidGroupProperty", "Scope is T4: setting t4CIMObjectPath and t4Interfaceproperties in RaidGroup.");
            theRaidGroup.setT4CIMObjectPath(((T4)this.scope).getInstance().getObjectPath());
            theRaidGroup.setT4Interface((T4Interface)this.scope);
        }
        this.raidGroupList.add(theRaidGroup);
        Trace.verbose((Object)this, "loadRaidGroupProperty", "A RaidGroup has just been added to list");
    }

    public RaidGroupComparator getRaidGroupComparator(Locale l) {
        return new RaidGroupComparator(l);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class RaidGroupComparator
    implements Comparator {
        Collator collator = null;

        RaidGroupComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof RaidGroup && element2 instanceof RaidGroup) {
                key1 = this.collator.getCollationKey(((RaidGroup)element1).getName());
                key2 = this.collator.getCollationKey(((RaidGroup)element2).getName());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

