/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Disk;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.wbem.cim.CIMInstance;

public class ManageDisks
implements ManageDisksInterface {
    private Disk disk;
    private ArrayList diskList;
    private int numOfHotSpare = -1;
    private ConfigContext context;
    private InstanceWrapper scope;
    private T4Interface scopingT4;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        String METHOD = "init";
        Trace.methodBegin(this, "init");
        this.context = context;
        this.diskList = new ArrayList();
        CIMOMHandleWrapper cimClient = context.getClient();
        Enumeration disksEnum = this.getDisksEnum(cimClient);
        while (disksEnum != null && disksEnum.hasMoreElements()) {
            CIMInstance diskInstance = (CIMInstance)disksEnum.nextElement();
            Trace.verbose((Object)this, "init", "Have disk instance.");
            if (filter == null || filter.isEmpty()) {
                Trace.verbose((Object)this, "init", "Passes filter.");
                Disk d = new Disk(context, diskInstance);
                if (this.scopingT4 != null) {
                    d.setScopingT4(this.scopingT4);
                }
                this.diskList.add(d);
                continue;
            }
            Trace.verbose((Object)this, "init", "Rejected by filter.");
        }
        Trace.verbose((Object)this, "init", "Loaded " + this.diskList.size() + " disks into list.");
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
        this.scope = scope;
    }

    public List getItemList() throws ConfigMgmtException {
        return this.diskList;
    }

    private Enumeration getDisksEnum(CIMOMHandleWrapper cimClient) throws ConfigMgmtException {
        String METHOD = "getDisksEnum";
        Trace.methodBegin(this, "getDisksEnum");
        Enumeration disksEnum = null;
        if (cimClient != null) {
            try {
                if (this.scope instanceof T4Interface) {
                    Trace.verbose((Object)this, "getDisksEnum", "scope is Array, getting disks on whole array.");
                    this.scopingT4 = (T4Interface)this.scope;
                    disksEnum = CIMObjectWrapper.execQuery(cimClient, "select * from SunStorEdge_6120StorageExtent where SystemName = '" + ((T4Interface)this.scope).getClusterName() + "'");
                } else if (this.scope instanceof TrayInterface) {
                    Trace.verbose((Object)this, "getDisksEnum", "scope is Tray, getting disks on tray only.");
                    this.scopingT4 = ((TrayInterface)this.scope).getT4Interface();
                    disksEnum = CIMObjectWrapper.execQuery(cimClient, "select * from SunStorEdge_6120StorageExtent where SystemName = '" + ((TrayInterface)this.scope).getT4IPAddress() + "' AND " + "DeviceID" + " LIKE 'u" + ((TrayInterface)this.scope).getIdOneBased() + "d%'");
                } else {
                    Trace.verbose((Object)this, "getDisksEnum", "No scope, getting all disks on all arrays.");
                    disksEnum = CIMObjectWrapper.execQuery(cimClient, "select * from SunStorEdge_6120StorageExtent");
                }
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getDisksEnum", "Failed: " + cme.getMessage());
                throw cme;
            }
        }
        return disksEnum;
    }

    public Disk getDisk(int diskNumber) {
        Trace.methodBegin(this, "getDisk");
        return (Disk)this.diskList.get(diskNumber);
    }

    public int getNumberOfHotSpare() {
        if (this.numOfHotSpare < 0) {
            Trace.verbose((Object)this, "getNumberOfHotSpare", "loading number of hot spare");
            for (int i = 0; i < this.diskList.size(); ++i) {
                DiskInterface disk = (DiskInterface)this.diskList.get(i);
                if (disk.getSlotNumber() <= 1 || !disk.getRole().equals("unassigned")) continue;
                ++this.numOfHotSpare;
            }
        }
        return this.numOfHotSpare;
    }

    public int getNumberOfDisk() {
        Trace.methodBegin(this, "getNumberOfDisk");
        return this.diskList.size();
    }

    public List getContiguousDiskChunks() throws ConfigMgmtException {
        String METHOD = "getContiguousDiskChunks";
        Trace.methodBegin(this, "getContiguousDiskChunks");
        return this.getContiguousDiskChunks(null);
    }

    public List getContiguousDiskChunks(List excludeStorageExtentList) throws ConfigMgmtException {
        String METHOD = "getContiguousDiskChunks";
        Trace.methodBegin(this, "getContiguousDiskChunks");
        ArrayList<Disk> chunkPositionList = new ArrayList<Disk>();
        boolean isContigChunkOpen = false;
        int chunkPositionIndex = 0;
        int prevSlot = -1;
        int diskCnt = this.diskList.size();
        int currentSlot = 0;
        Disk disk = null;
        Disk prevDisk = null;
        for (int i = 0; i < diskCnt; ++i) {
            disk = (Disk)this.diskList.get(i);
            currentSlot = disk.getSlotNumber();
            Trace.verbose((Object)this, "getContiguousDiskChunks", "have slot: " + currentSlot);
            if (disk.getRole().equals("unassigned") && !excludeStorageExtentList.contains(disk.getStorageExtentObjectPath().toString())) {
                Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + currentSlot + " is NOT allocated.");
                if (currentSlot == 1) {
                    Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + currentSlot + " is first to be added to chunk.");
                    chunkPositionList.add(chunkPositionIndex, disk);
                    isContigChunkOpen = true;
                    ++chunkPositionIndex;
                    prevSlot = currentSlot;
                    prevDisk = disk;
                    continue;
                }
                Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + currentSlot + " is being checked for gaps.");
                if (currentSlot - prevSlot == 1) {
                    Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + currentSlot + " is has no gaps.");
                    prevSlot = currentSlot;
                    prevDisk = disk;
                    continue;
                }
                Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + currentSlot + " slot has gaps.");
                if (chunkPositionList.size() == 0) {
                    Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + currentSlot + " adding as first disk.");
                    chunkPositionList.add(chunkPositionIndex, disk);
                    isContigChunkOpen = true;
                    ++chunkPositionIndex;
                    prevSlot = currentSlot;
                    prevDisk = disk;
                    continue;
                }
                Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + prevDisk.getSlotNumber() + " adding as last disk of chunk.");
                chunkPositionList.add(chunkPositionIndex, prevDisk);
                Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + currentSlot + " adding as first disk of chunk.");
                chunkPositionList.add(++chunkPositionIndex, disk);
                ++chunkPositionIndex;
                isContigChunkOpen = true;
                prevSlot = currentSlot;
                prevDisk = disk;
                continue;
            }
            if (!Trace.isTraceEnabled(this)) continue;
            Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + currentSlot + " is allocated or on the exclude list.");
        }
        if (isContigChunkOpen) {
            Trace.verbose((Object)this, "getContiguousDiskChunks", "slot : " + prevDisk.getSlotNumber() + " adding at end.");
            chunkPositionList.add(chunkPositionIndex, prevDisk);
            ++chunkPositionIndex;
        }
        if (chunkPositionList.size() % 2 != 0) {
            Trace.verbose((Object)this, "getContiguousDiskChunks", "Error occurred in contiguous drive computation: contiguous drive sequence is  not an even number!");
            throw new ConfigMgmtException("error.computationError", "Error from computing contiguous drives.");
        }
        if (Trace.isTraceEnabled(this)) {
            this.dumpList(this, chunkPositionList);
        }
        return chunkPositionList;
    }

    private void dumpList(Object obj, ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            Trace.verbose(obj, "dumpList", "Index: " + i + " contents: " + list.get(i));
        }
    }

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        this.init(context, filter);
    }

    public int getItemCount() throws ConfigMgmtException {
        return 0;
    }

    public boolean isOperationSupported(String operation) {
        return false;
    }

    public void modify(Object key, Properties props) {
    }
}

