/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.admin.business.ArrayRegistration;
import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3.ManageArrayRegistrations;
import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3.RemoteServiceAccessPoint;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConnectionFactory;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import java.util.List;
import java.util.Locale;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class HandleResetLabelsWorker
extends Thread {
    private static final long MAX_REBOOT_TIME = 1800000L;
    private ConfigMgmtException myEx = null;
    private UserPrincipal user;
    private PasswordCredential password;
    private Locale locale;
    private String t4Name;
    private String t4IPAddr;
    private String gateway;
    private CIMObjectPath arrayObjPath = null;

    public HandleResetLabelsWorker(ConfigContext context, String t4IPAddr, String t4Name, String gateway) {
        Trace.constructor(this);
        this.user = context.getUserPrincipal();
        this.password = context.getPasswordCredential();
        this.locale = context.getLocale();
        this.t4IPAddr = t4IPAddr;
        this.t4Name = t4Name;
        this.gateway = gateway;
    }

    public void run() {
        String METHOD = "run";
        Trace.methodBegin(this, "run");
        try {
            this.waitUntilArrayIsHealthy();
            this.fixPasswordInAccount();
            if (this.gateway != null) {
                this.fixGateway();
            }
        }
        catch (ConfigMgmtException cfe) {
            Trace.error((Object)this, cfe);
            this.myEx = cfe;
        }
    }

    public ConfigMgmtException getRuntimeException() {
        Trace.methodBegin(this, "getRuntimeException");
        return this.myEx;
    }

    private ConfigContext getCIMConnection() throws ConfigMgmtException {
        Trace.methodBegin(this, "getCIMConnection");
        return ConnectionFactory.getConfigContext(this.user.getName(), this.password.getUserPassword(), this.locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilArrayIsHealthy() throws ConfigMgmtException {
        String METHOD = "waitUntilArrayIsHealthy";
        long localRetryDelay = 60000L;
        long maxAttempts = 1800000L / localRetryDelay + 1L;
        int numAttempts = 0;
        int weirdSituationCount = 0;
        boolean allIsGood = false;
        while (!allIsGood && (long)numAttempts++ < maxAttempts) {
            Object var16_14;
            ConfigContext handle = null;
            try {
                handle = this.getCIMConnection();
                SearchFilter sf = new SearchFilter("Name", this.t4Name);
                ManageT4sInterface mt4 = ManageT4sFactory.getManager();
                mt4.init(handle, sf);
                List list = mt4.getItemList();
                if (list != null && list.size() == 1) {
                    T4Interface t4 = (T4Interface)list.get(0);
                    this.arrayObjPath = t4.getInstance().getObjectPath();
                    weirdSituationCount = 0;
                    int health = t4.getHealthStatus();
                    if (health == 2) {
                        Trace.verbose((Object)this, "waitUntilArrayIsHealthy", "Have healthy array.");
                        allIsGood = true;
                    } else if (Trace.isTraceEnabled(this)) {
                        Trace.verbose((Object)this, "waitUntilArrayIsHealthy", "Array not healthy yet. Current health: " + health);
                    }
                } else {
                    Trace.verbose((Object)this, "waitUntilArrayIsHealthy", "Didn't find exactly one array. weirdCount: " + ++weirdSituationCount);
                    if (weirdSituationCount > 4) {
                        Trace.error((Object)this, "waitUntilArrayIsHealthy", "Unable to find array after resetting labels.");
                        throw new ConfigMgmtException("CIM_INSTANCE_NOT_FOUND", "Unable to find array after resetting labels.");
                    }
                }
                try {
                    if (!allIsGood) {
                        Trace.verbose((Object)this, "waitUntilArrayIsHealthy", "Sleeping until time to try again.");
                        HandleResetLabelsWorker.sleep(localRetryDelay);
                    }
                }
                catch (InterruptedException ie) {
                }
                var16_14 = null;
                if (handle == null || handle.getClient() == null) continue;
                handle.getClient().close();
            }
            catch (Throwable throwable) {
                var16_14 = null;
                if (handle != null && handle.getClient() != null) {
                    handle.getClient().close();
                }
                throw throwable;
            }
        }
        if (!allIsGood) {
            throw new ConfigMgmtException("T4_NOT_HEALTHY_EXCEPTION", "HandleResetLabelsWorker timed out waiting for the array to become healthy.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixPasswordInAccount() throws ConfigMgmtException {
        String METHOD = "fixPasswordInAccount";
        Trace.methodBegin(this, "fixPasswordInAccount");
        ConfigContext handle = null;
        try {
            handle = this.getCIMConnection();
            SearchFilter sf = new SearchFilter("Name", this.t4IPAddr);
            ManageArrayRegistrations manageArrayRegistrations = new ManageArrayRegistrations();
            manageArrayRegistrations.init(handle, sf);
            List list = manageArrayRegistrations.getItemList();
            if (list != null && list.size() == 1) {
                ArrayRegistration acct = (ArrayRegistration)list.get(0);
                Trace.verbose((Object)this, "fixPasswordInAccount", "Have account object.");
                String origPassword = acct.getPassword();
                acct.setPassword("");
                Trace.verbose((Object)this, "fixPasswordInAccount", "Saving default password to acct.");
                manageArrayRegistrations.save(handle, acct);
                Trace.verbose((Object)this, "fixPasswordInAccount", "Reloading acct.");
                manageArrayRegistrations.reload(acct);
                Trace.verbose((Object)this, "fixPasswordInAccount", "changing password.");
                int result = manageArrayRegistrations.changePassword(handle, acct, origPassword);
                if (result != 0) {
                    String msg = "change password failed with return code: " + result;
                    Trace.verbose((Object)this, "fixPasswordInAccount", msg);
                    throw new ConfigMgmtException("EXTRINSIC_CIM_METHOD_EXCEPTION", msg);
                }
            } else {
                String msg = "Unable to find account class for name: " + this.t4IPAddr;
                Trace.verbose((Object)this, "fixPasswordInAccount", msg);
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", msg);
            }
            Trace.verbose((Object)this, "fixPasswordInAccount", "change password successful.");
            Object var11_11 = null;
            if (handle != null && handle.getClient() != null) {
                handle.getClient().close();
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (handle != null && handle.getClient() != null) {
                handle.getClient().close();
            }
            throw throwable;
        }
    }

    private void fixGateway() throws ConfigMgmtException {
        String METHOD = "fixGateway";
        Trace.methodBegin(this, "fixGateway");
        if (this.arrayObjPath == null) {
            String msg = "No array object path found to change gateway.";
            Trace.verbose((Object)this, "fixGateway", msg);
            throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", msg);
        }
        ConfigContext handle = null;
        try {
            try {
                handle = this.getCIMConnection();
                RemoteServiceAccessPoint ap = new RemoteServiceAccessPoint(handle, this.arrayObjPath);
                CIMInstance ci = ap.getCIMInstance();
                CIMObjectPath cop = ci.getObjectPath();
                ci.setProperty("GatewayAddress", new CIMValue((Object)this.gateway));
                Trace.verbose((Object)this, "fixGateway", "Setting gateway back to old value.");
                handle.getClient().setInstance(cop, ci, false, new String[]{"GatewayAddress"});
                Trace.verbose((Object)this, "fixGateway", "Finished setting gateway back to old value.");
            }
            catch (Exception e) {
                throw new ConfigMgmtException(e);
            }
            Object var7_8 = null;
            if (handle != null && handle.getClient() != null) {
                handle.getClient().close();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (handle != null && handle.getClient() != null) {
                handle.getClient().close();
            }
            throw throwable;
        }
    }
}

