/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageT4s;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;

public class Disk
implements DiskInterface {
    private CIMObjectPath storageExtObjPath;
    private CIMInstance storageExtInstance;
    private String cimName;
    private String name;
    private int status = 0;
    private String state;
    private String role;
    private String raidGroupName;
    private BigInteger capacity;
    private int trayId = -1;
    private ConfigContext context;
    private int slotNumber = -1;
    private String substitutedBy;
    private T4Interface scopingT4;
    private String arrayName;
    private String t4IPAddr;
    private boolean knowAboutSharedSpares = false;
    private ArrayList allSupportedPools;

    public Disk(ConfigContext context, CIMInstance storageExtent) throws ConfigMgmtException {
        Trace.constructor(this);
        this.context = context;
        this.storageExtInstance = storageExtent;
        this.setStorageExtentObjectPath(storageExtent.getObjectPath());
        CIMObjectWrapper.populate(this, this.getFieldMap(), this.storageExtInstance);
    }

    public void init(ConfigContext ctx) {
        this.context = ctx;
    }

    public synchronized void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        this.slotNumber = -1;
        this.trayId = -1;
        this.role = null;
        this.state = null;
        this.status = 0;
        this.capacity = null;
        this.raidGroupName = null;
        this.storageExtInstance = null;
        this.knowAboutSharedSpares = false;
        this.allSupportedPools = null;
        CIMObjectWrapper.populate(this, this.getFieldMap(), this.reloadInstance());
    }

    public void save() throws ConfigMgmtException {
        throw new ConfigMgmtException("ACTION_NOT_SUPPORTED", "save() not supported on Disk objects.");
    }

    public CIMObjectPath getStorageExtentObjectPath() {
        Trace.methodBegin(this, "getStorageExtentObjectPath");
        return this.storageExtObjPath;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public String getName() {
        return this.name;
    }

    public BigInteger getCapacity() {
        return this.capacity;
    }

    public int getStatus() {
        return this.status;
    }

    public String getState() {
        return this.state;
    }

    public synchronized String getRole() {
        if ("standbyDisk".equals(this.role)) {
            if (!this.knowAboutSharedSpares) {
                try {
                    this.examineForSharedSpares();
                }
                catch (ConfigMgmtException cme) {
                    Trace.error((Object)this, cme);
                }
            }
            if (this.allSupportedPools != null && this.allSupportedPools.size() > 1) {
                this.role = "standbyDiskShared";
            }
        }
        return this.role;
    }

    public synchronized String getRaidGroupName() throws ConfigMgmtException {
        if ("unassigned".equals(this.role) || "globalStandbyDisk".equals(this.role)) {
            return null;
        }
        if ("standbyDisk".equals(this.role)) {
            if (this.scopingT4 == null) {
                Trace.verbose((Object)this, "getRaidGroupName", "Must load the T4 for this disk.");
                this.findScopingT4();
            }
            if (!this.scopingT4.isFeatureSupported(4)) {
                this.raidGroupName = this.findRaidGroupName();
            }
        }
        return this.raidGroupName;
    }

    public String getSubstitutedBy() {
        return this.substitutedBy;
    }

    public CIMInstance getInstance() {
        return this.storageExtInstance;
    }

    public int getTrayId() {
        return this.trayId;
    }

    public String getT4IPAddr() {
        return this.t4IPAddr;
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setCimName(String cimName) throws ConfigMgmtException {
        Trace.methodBegin(this, "setCimName");
        this.cimName = cimName;
        this.name = this.createDiskName(cimName);
    }

    private String createDiskName(String cimName) throws ConfigMgmtException {
        String locName = "cimName";
        try {
            int d_index = cimName.indexOf("d");
            this.trayId = Integer.parseInt(cimName.substring(1, d_index)) - 1;
            this.slotNumber = Integer.parseInt(cimName.substring(d_index + 1));
            locName = "t" + this.trayId + "d" + this.slotNumber;
        }
        catch (Exception e) {
            Trace.error((Object)this, "setCimName", "Found invalid disk name: " + cimName);
            throw new ConfigMgmtException("DATA_INCONSISTENCY", "Found invalid disk name: " + cimName);
        }
        return locName;
    }

    public void setStorageExtentObjectPath(CIMObjectPath storageExtObjPath) {
        Trace.methodBegin(this, "setStorageExtentObjectPath");
        this.storageExtObjPath = storageExtObjPath;
    }

    public void setCapacity(BigInteger capacity) {
        this.capacity = capacity;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setSubstitutedBy(String cimName) {
        if (cimName == null || cimName.equalsIgnoreCase(" ")) {
            this.substitutedBy = null;
        } else {
            try {
                this.substitutedBy = this.createDiskName(cimName);
            }
            catch (ConfigMgmtException e) {
                Trace.error((Object)this, e);
            }
        }
    }

    public void setRaidGroupName(String raidGroupName) {
        this.raidGroupName = raidGroupName;
    }

    public void setT4IPAddr(String t4IPAddr) {
        this.t4IPAddr = t4IPAddr;
    }

    public void setArrayName(String aname) {
        this.arrayName = aname;
    }

    public void setScopingT4(T4Interface t4Interface) {
        this.scopingT4 = t4Interface;
        if (this.scopingT4 != null) {
            this.arrayName = this.scopingT4.getName();
        }
    }

    private CIMInstance reloadInstance() throws ConfigMgmtException {
        Trace.methodBegin(this, "reloadInstance");
        if (this.storageExtInstance == null) {
            if (this.storageExtObjPath == null) {
                Trace.verbose((Object)this, "reloadInstance", "calling reloadInstance when the object path has not been set.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Disk.reloadInstance called when no object path has been set.");
            }
            Trace.verbose((Object)this, "reloadInstance", "Getting CIM instance from object path.");
            this.storageExtInstance = this.context.getClient().getInstance(this.storageExtObjPath, false, true, false, null);
        }
        return this.storageExtInstance;
    }

    private Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        ArrayList<MapElement> myMap = new ArrayList<MapElement>();
        myMap.add(new MapElement("raidGroupName", "OtherIdentifyingInfo", true, true, 1));
        myMap.add(new MapElement("state", "OtherIdentifyingInfo", true, false, 2));
        myMap.add(new MapElement("role", "OtherIdentifyingInfo", true, false, 3));
        myMap.add(new MapElement("substitutedBy", "OtherIdentifyingInfo", true, true, 4));
        myMap.add(new MapElement("status", "OperationalStatus", true, false, 0));
        myMap.add(new MapElement("cimName", "DeviceID", true, false));
        myMap.add(new MapElement("capacity", "NumberOfBlocks", true, false));
        myMap.add(new MapElement("t4IPAddr", "SystemName", true, false));
        return myMap;
    }

    private void findScopingT4() throws ConfigMgmtException {
        Trace.methodBegin(this, "findScopingT4");
        ManageT4s mt4 = new ManageT4s();
        mt4.init(this.context, null);
        this.scopingT4 = mt4.getT4ByIP(this.t4IPAddr);
    }

    private String findRaidGroupName() throws ConfigMgmtException {
        String METHOD = "findRaidGroupName";
        Trace.methodBegin(this, "findRaidGroupName");
        if (!this.knowAboutSharedSpares) {
            this.examineForSharedSpares();
        }
        if (this.allSupportedPools != null && this.allSupportedPools.size() > 0) {
            return (String)this.allSupportedPools.get(0);
        }
        return null;
    }

    private void examineForSharedSpares() throws ConfigMgmtException {
        String METHOD = "examineForSharedSpares";
        Trace.methodBegin(this, "examineForSharedSpares");
        long begin = -1L;
        if (Trace.isTraceEnabled(this)) {
            begin = System.currentTimeMillis();
        }
        Enumeration enumeration = this.context.getClient().associators(this.storageExtObjPath, "SunStorEdge_6120IsPoolSpare", "SunStorEdge_6120PoolSparedSet", "Antecedent", "Dependent", true, false, null);
        while (enumeration != null && enumeration.hasMoreElements()) {
            CIMInstance sparedPool = (CIMInstance)enumeration.nextElement();
            CIMProperty poolNameProp = sparedPool.getProperty("ElementName");
            if (poolNameProp == null || poolNameProp.getValue() == null) continue;
            String poolName = (String)poolNameProp.getValue().getValue();
            if (this.allSupportedPools == null) {
                this.allSupportedPools = new ArrayList();
            }
            this.allSupportedPools.add(poolName);
            Trace.verbose((Object)this, "examineForSharedSpares", "For disk: " + this.name + " on " + this.t4IPAddr + " found a raid group: " + poolName);
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "examineForSharedSpares", "Duration in millis to lookup pools for this spare: " + (System.currentTimeMillis() - begin));
        }
        this.knowAboutSharedSpares = true;
    }

    public Map getCustomObjectProperties() {
        return null;
    }

    public Map getKey() {
        return null;
    }

    public String getKeyAsString() {
        return null;
    }

    public String getObjectItemType() {
        return null;
    }

    public String getWwn() {
        return null;
    }

    public String toString() {
        return this.arrayName + ":" + this.name;
    }
}

