/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageArrayEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;

public class StorageArray
extends com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.common.StorageArray
implements StorageArrayEnt1Interface {
    private boolean external;
    private String name;
    private VDisk vdisk;
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private CIMInstance instance;
    private BigInteger rawTotalCapInSystem;
    private BigInteger rawAvailableCapInSystem;
    private ArrayList vdisksInArray;

    public StorageArray(ConfigContext context, CIMInstance instance, VDisk vdisk, String name) {
        Trace.constructor(this);
        this.context = context;
        this.instance = instance;
        this.vdisk = vdisk;
        this.name = name;
        this.handle = this.context.getClient();
    }

    public boolean isExternal() {
        String METHOD = "isExternal";
        Trace.methodBegin(this, "isExternal");
        boolean val = false;
        try {
            val = this.vdisk.isExternal();
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "isExternal", cme);
        }
        Trace.methodEnd(this, "isExternal");
        return val;
    }

    public String getName() {
        return this.name;
    }

    public String getArrayType() {
        String METHOD = "getArrayType";
        Trace.methodBegin(this, "getArrayType");
        Trace.methodEnd(this, "getArrayType");
        return this.vdisk.getVendor();
    }

    public BigInteger getRawTotalCapacity() {
        String METHOD = "getRawTotalCapacity";
        Trace.methodBegin(this, "getRawTotalCapacity");
        if (super.getRawTotalCapacity() == null || super.getRawAvailableCapacity() == null) {
            BigInteger total = BigInteger.ZERO;
            BigInteger consCap = BigInteger.ZERO;
            try {
                Trace.verbose((Object)this, "getRawTotalCapacity", "Querying CIM for associated StorageExtent Instance");
                Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPExtentArraySettingData", "SunStorEdge_DSPStorageExtent", "SettingData", "ManagedElement", true, false, ConstantsEnt.StorageExtentProperties.PROP_LIST);
                Trace.verbose((Object)this, "getRawTotalCapacity", "Returned from querying CIM for associated StorageExtent Instance");
                if (enumeration != null && enumeration.hasMoreElements()) {
                    this.vdisksInArray = new ArrayList();
                }
                BigInteger numberOfBlocks = BigInteger.ZERO;
                BigInteger blockSize = BigInteger.ZERO;
                BigInteger consBlocks = BigInteger.ZERO;
                while (enumeration.hasMoreElements()) {
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    CIMValue c_numBlocks = ci.getProperty("NumberOfBlocks").getValue();
                    CIMValue c_blockSize = ci.getProperty("BlockSize").getValue();
                    CIMValue c_consBlocks = ci.getProperty("ConsumableBlocks").getValue();
                    CIMValue c_elemName = ci.getProperty("ElementName").getValue();
                    numberOfBlocks = ((UnsignedInt64)c_numBlocks.getValue()).bigIntValue();
                    blockSize = ((UnsignedInt64)c_blockSize.getValue()).bigIntValue();
                    consBlocks = ((UnsignedInt64)c_consBlocks.getValue()).bigIntValue();
                    String elemName = (String)c_elemName.getValue();
                    total = total.add(numberOfBlocks.multiply(blockSize));
                    consCap = consCap.add(consBlocks.multiply(blockSize));
                    this.vdisksInArray.add(elemName);
                }
                super.setRawTotalCapacity(total);
                super.setRawAvailableCapacity(consCap);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getRawTotalCapacity", cme);
                super.setRawTotalCapacity(BigInteger.ZERO);
                super.setRawAvailableCapacity(BigInteger.ZERO);
            }
        }
        Trace.methodEnd(this, "getRawTotalCapacity");
        return super.getRawTotalCapacity();
    }

    public BigInteger getRawAvailableCapacity() {
        String METHOD = "getRawAvailableCapacity";
        Trace.methodBegin(this, "getRawAvailableCapacity");
        Trace.methodEnd(this, "getRawAvailableCapacity");
        return super.getRawAvailableCapacity();
    }

    public BigInteger getRawTotalCapacity(StoragePoolInterface pool) {
        String METHOD = "getRawTotalCapacity(StoragePoolInterface)";
        Trace.methodBegin(this, "getRawTotalCapacity(StoragePoolInterface)");
        try {
            if (this.vdisksInArray == null) {
                this.getRawTotalCapacity();
            }
            if (this.rawTotalCapInSystem == null || this.rawAvailableCapInSystem == null) {
                this.rawTotalCapInSystem = BigInteger.ZERO;
                this.rawAvailableCapInSystem = BigInteger.ZERO;
                ArrayList vdisks = pool.getAssociatedVDisks();
                if (vdisks != null) {
                    int size = vdisks.size();
                    for (int i = 0; i < size; ++i) {
                        VDisk v = (VDisk)vdisks.get(i);
                        if (!this.vdisksInArray.contains(v.getName())) continue;
                        this.rawTotalCapInSystem = this.rawTotalCapInSystem.add(v.getTotalCapacity());
                        this.rawAvailableCapInSystem = this.rawAvailableCapInSystem.add(v.getAvailableCapacity());
                    }
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getRawTotalCapacity(StoragePoolInterface)", cme);
            this.rawTotalCapInSystem = BigInteger.ZERO;
            this.rawAvailableCapInSystem = BigInteger.ZERO;
        }
        Trace.methodEnd(this, "getRawTotalCapacity(StoragePoolInterface)");
        return this.rawTotalCapInSystem;
    }

    public BigInteger getRawAvailableCapacity(StoragePoolInterface pool) {
        String METHOD = "getRawAvailableCapacity(StoragePoolInterface)";
        Trace.methodBegin(this, "getRawAvailableCapacity(StoragePoolInterface)");
        this.getRawTotalCapacity(pool);
        Trace.methodEnd(this, "getRawAvailableCapacity(StoragePoolInterface)");
        return this.rawAvailableCapInSystem;
    }

    public BigInteger getRawConfiguredCapacity(StoragePoolInterface pool) {
        String METHOD = "getRawConfiguredCapacity(StoragePoolInterface)";
        Trace.methodBegin(this, "getRawConfiguredCapacity(StoragePoolInterface)");
        BigInteger val = this.getRawTotalCapacity(pool).subtract(this.getRawAvailableCapacity(pool));
        Trace.methodEnd(this, "getRawConfiguredCapacity(StoragePoolInterface)");
        return val;
    }

    public String getArrayID() {
        return this.vdisk.getDspArrayID();
    }
}

