/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.EthernetPortEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManagePortsEnt1;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim.EthernetPortCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim.FiberChannelPortCIM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class ManagePortsCIM
extends ManagePortsEnt1 {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private Scope scope;
    private SearchFilter filter;
    private ArrayList managedPorts = null;

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        String METHOD = "init";
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "ConfigContext object is null.", null, 100);
        }
        this.context = context;
        this.handle = context.getClient();
        this.scope = scope;
        this.filter = filter;
        if (this.handle == null) {
            Trace.error((Object)this, "init", "Client object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Client object is null.", null, 100);
        }
        Trace.methodEnd(this, "init");
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD = "modify";
        Trace.methodBegin(this, "modify");
        Trace.methodEnd(this, "modify");
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD = "getItemList";
        Trace.methodBegin(this, "getItemList");
        if (this.managedPorts == null) {
            this.managedPorts = new ArrayList();
            this.managedPorts.addAll(this.getFiberChannelPortList());
            this.managedPorts.addAll(this.getEthernetPortList());
        }
        Trace.methodEnd(this, "getItemList");
        return this.managedPorts;
    }

    public int getItemCount() throws ConfigMgmtException {
        String METHOD = "getItemCount";
        Trace.methodBegin(this, "getItemCount");
        if (this.managedPorts == null) {
            this.getItemList();
        }
        if (this.managedPorts == null) {
            Trace.methodEnd(this, "getItemCount");
            return 0;
        }
        Trace.methodEnd(this, "getItemCount");
        return this.managedPorts.size();
    }

    public List getFiberChannelPortList() throws ConfigMgmtException {
        String METHOD = "getFiberChannelPortList";
        Trace.methodBegin(this, "getFiberChannelPortList");
        ArrayList<FiberChannelPortCIM> fiberChannelPorts = new ArrayList<FiberChannelPortCIM>();
        Trace.verbose((Object)this, "getFiberChannelPortList", "Querying the CIM for SunStorEdge_DSPFCPort Instances");
        Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPFCPort"), false, false, true, false, ConstantsEnt.FCPortProperties.PROP_LIST);
        Trace.verbose((Object)this, "getFiberChannelPortList", "Returned from querying the CIM for SunStorEdge_DSPFCPort Instances");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getFiberChannelPortList", "SunStorEdge_DSPFCPort Instances Found");
            while (enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getFiberChannelPortList", "Creating FiberChannelPortCIM Java Object");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                FiberChannelPortCIM fcp = new FiberChannelPortCIM();
                fcp.setInstance(ci);
                fcp.init(this.context);
                CIMObjectWrapper.populate(fcp, fcp.getFieldMap(), ci);
                fcp.loadKeys();
                fiberChannelPorts.add(fcp);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "getFiberChannelPortList", "The instance added to the list: " + fcp);
            }
        }
        Trace.methodEnd(this, "getFiberChannelPortList");
        return fiberChannelPorts;
    }

    public List getEthernetPortList() throws ConfigMgmtException {
        String METHOD = "getEthernetPortList";
        Trace.methodBegin(this, "getEthernetPortList");
        ArrayList<EthernetPortCIM> ethernetPorts = new ArrayList<EthernetPortCIM>();
        Trace.verbose((Object)this, "getEthernetPortList", "Querying the CIM for SunStorEdge_DSPEthernetPort Instances");
        Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPEthernetPort"), false, false, true, false, ConstantsEnt.EthernetPortProperties.PROP_LIST);
        Trace.verbose((Object)this, "getEthernetPortList", "Returned from querying the CIM for SunStorEdge_DSPEthernetPort Instances");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getEthernetPortList", "SunStorEdge_DSPEthernetPort Instances Found");
            while (enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getEthernetPortList", "Creating EthernetPortCIM Java Object");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                EthernetPortCIM ep = new EthernetPortCIM();
                ep.setInstance(ci);
                ep.init(this.context);
                CIMObjectWrapper.populate(ep, ep.getFieldMap(), ci);
                ep.loadKeys();
                ethernetPorts.add(ep);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "getEthernetPortList", "The instance added to the list: " + ep);
            }
        }
        Trace.methodEnd(this, "getEthernetPortList");
        return ethernetPorts;
    }

    public FiberChannelPortEnt1Interface getFiberChannelPortByName(String name) throws ConfigMgmtException {
        String METHOD = "getFiberChannelPortByName";
        Trace.methodBegin(this, "getFiberChannelPortByName");
        FiberChannelPortCIM fcPort = null;
        Trace.verbose((Object)this, "getFiberChannelPortByName", "Querying CIM for SunStorEdge_DSPFCPort Instance: " + name);
        Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPFCPort where ElementName = '" + name + "'");
        Trace.verbose((Object)this, "getFiberChannelPortByName", "Returned from querying CIM for SunStorEdge_DSPFCPort Instance: " + name);
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getFiberChannelPortByName", "SunStorEdge_DSPFCPort Instance: " + name + " Found.");
            while (enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getFiberChannelPortByName", "Creating FiberChannelPortCIM Java object.");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                fcPort = new FiberChannelPortCIM();
                fcPort.setInstance(ci);
                fcPort.init(this.context);
                CIMObjectWrapper.populate(fcPort, fcPort.getFieldMap(), ci);
                fcPort.loadKeys();
                Trace.verbose((Object)this, "getFiberChannelPortByName", "Finished creating FiberChannelPortCIM Java object.");
            }
        }
        if (fcPort == null) {
            Trace.verbose((Object)this, "getFiberChannelPortByName", "No instance returned when trying to obtain the fiberchannel: " + name);
            return null;
        }
        Trace.methodEnd(this, "getFiberChannelPortByName");
        return fcPort;
    }

    public FiberChannelPortEnt1Interface getFiberChannelPortByKey(Collection key) throws ConfigMgmtException {
        CIMInstance ci;
        String METHOD = "getFiberChannelPortByKey";
        Trace.methodBegin(this, "getFiberChannelPortByKey");
        FiberChannelPortCIM fcPort = null;
        if (key != null) {
            CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPFCPort", new Vector(key));
            Trace.verbose((Object)this, "getFiberChannelPortByKey", "Querying CIM for a SunStorEdge_DSPFCPort Instance matching key(s)");
            ci = null;
            try {
                ci = this.handle.getInstance(objPath, false, true, false, null);
            }
            catch (Exception ce) {
                Trace.verbose((Object)this, "getFiberChannelPortByKey", "Port not found.");
                return null;
            }
            Trace.verbose((Object)this, "getFiberChannelPortByKey", "Returned from querying CIM for SunStorEdge_DSPFCPort Instance matching key(s)");
            if (ci == null) {
                Trace.error((Object)this, "getFiberChannelPortByKey", "Could not retrieve CIMInstance.");
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Could not retrieve CIMInstance.", null, 100);
            }
        } else {
            Trace.error((Object)this, "getFiberChannelPortByKey", "Key object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Key object is null.", null, 100);
        }
        Trace.verbose((Object)this, "getFiberChannelPortByKey", "Creating FiberChannelPortCIM Java Object");
        fcPort = new FiberChannelPortCIM();
        fcPort.init(this.context);
        fcPort.setInstance(ci);
        CIMObjectWrapper.populate(fcPort, fcPort.getFieldMap(), ci);
        fcPort.loadKeys();
        if (fcPort == null) {
            Trace.verbose((Object)this, "getFiberChannelPortByKey", "No instance returned when trying to obtain the fiberchannel port");
            Trace.methodEnd(this, "getFiberChannelPortByKey");
            return null;
        }
        Trace.methodEnd(this, "getFiberChannelPortByKey");
        return fcPort;
    }

    public EthernetPortEnt1Interface getEthernetPortByName(String name) throws ConfigMgmtException {
        String METHOD = "getEthernetPortByName";
        Trace.methodBegin(this, "getEthernetPortByName");
        EthernetPortCIM ethernetPort = null;
        Trace.verbose((Object)this, "getEthernetPortByName", "Querying CIM for SunStorEdge_DSPEthernetPort Instance: " + name);
        Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPEthernetPort where ElementName = '" + name + "'");
        Trace.verbose((Object)this, "getEthernetPortByName", "Returned from querying CIM for SunStorEdge_DSPEthernetPort Instance: " + name);
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getEthernetPortByName", "SunStorEdge_DSPEthernetPort Instance: " + name + " Found.");
            while (enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getEthernetPortByName", "Creating EthernetPortCIM Java object.");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                ethernetPort = new EthernetPortCIM();
                ethernetPort.setInstance(ci);
                ethernetPort.init(this.context);
                CIMObjectWrapper.populate(ethernetPort, ethernetPort.getFieldMap(), ci);
                ethernetPort.loadKeys();
                Trace.verbose((Object)this, "getEthernetPortByName", "Finished creating EthernetPortCIM Java object.");
            }
        }
        if (ethernetPort == null) {
            Trace.verbose((Object)this, "getEthernetPortByName", "No instance returned when trying to obtain the ethernet port: " + name);
            return null;
        }
        Trace.methodEnd(this, "getEthernetPortByName");
        return ethernetPort;
    }

    public EthernetPortEnt1Interface getEthernetPortByKey(Collection key) throws ConfigMgmtException {
        CIMInstance ci;
        String METHOD = "getEthernetPortByKey";
        Trace.methodBegin(this, "getEthernetPortByKey");
        EthernetPortCIM ethernetPort = null;
        if (key != null) {
            CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPEthernetPort", new Vector(key));
            Trace.verbose((Object)this, "getEthernetPortByKey", "Querying CIM for a SunStorEdge_DSPEthernetPort Instance matching key(s)");
            ci = null;
            try {
                ci = this.handle.getInstance(objPath, false, true, false, null);
            }
            catch (Exception ce) {
                Trace.verbose((Object)this, "getEthernetPortByKey", "Port not found.");
                return null;
            }
            Trace.verbose((Object)this, "getEthernetPortByKey", "Returned from querying CIM for SunStorEdge_DSPEthernetPortInstance matching key(s)");
            if (ci == null) {
                Trace.error((Object)this, "getEthernetPortByKey", "Could not retrieve CIMInstance.");
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Could not retrieve CIMInstance.", null, 100);
            }
        } else {
            Trace.error((Object)this, "getEthernetPortByKey", "Key object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Key object is null.", null, 100);
        }
        Trace.verbose((Object)this, "getEthernetPortByKey", "Creating EthernetPortCIM Java Object");
        ethernetPort = new EthernetPortCIM();
        ethernetPort.init(this.context);
        ethernetPort.setInstance(ci);
        CIMObjectWrapper.populate(ethernetPort, ethernetPort.getFieldMap(), ci);
        ethernetPort.loadKeys();
        if (ethernetPort == null) {
            Trace.verbose((Object)this, "getEthernetPortByKey", "No instance returned when trying to obtain the ethernet port");
            Trace.methodEnd(this, "getEthernetPortByKey");
            return null;
        }
        Trace.methodEnd(this, "getEthernetPortByKey");
        return ethernetPort;
    }
}

