/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1.ManageInitiators;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapArrayToSet;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapUint64ToBigInteger;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.FiberChannelPortEnt1;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;

public class FiberChannelPortCIM
extends FiberChannelPortEnt1 {
    private Collection fieldMap;
    private ConfigContext context;
    private CIMInstance instance;
    private CIMOMHandleWrapper handle;
    private boolean autoSpeedSense;
    private String systemCreationClassName;
    private String systemName;
    private String creationClassName;
    private String deviceID;
    private String popNodeWwn;

    protected void initImpl(ConfigContext context) throws ConfigMgmtException {
        String METHOD = "initImpl";
        Trace.methodBegin(this, "initImpl");
        if (context == null) {
            Trace.error((Object)this, "initImpl", "ConfigContext object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "ConfigContext object is null.", null, 100);
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "initImpl", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "CIMOMHandleWrapper object is null.", null, 100);
        }
        Trace.methodEnd(this, "initImpl");
    }

    public void save() throws ConfigMgmtException {
        String METHOD = "save";
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
        }
        Trace.methodEnd(this, "save");
    }

    public void reload() throws ConfigMgmtException {
        String METHOD = "reload";
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.instance.getObjectPath(), false, true, false, ConstantsEnt.FCPortProperties.PROP_LIST);
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.loadKeys();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
        }
        Trace.methodEnd(this, "reload");
    }

    protected ArrayList getAssociatedInitiatorsImpl() throws ConfigMgmtException {
        String METHOD = "getAssociatedInitiatorsImpl";
        Trace.methodBegin(this, "getAssociatedInitiatorsImpl");
        ArrayList initiators = new ArrayList();
        try {
            Trace.verbose((Object)this, "getAssociatedInitiatorsImpl", "Getting associated Initiators via ManageInitiatorsInterface.");
            ManageInitiators mi = new ManageInitiators();
            mi.init(this.context, null);
            initiators = mi.getItemsByFCPort(this.getPortName());
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getAssociatedInitiatorsImpl", "FCPort: " + this.getPortName() + " not found.");
        }
        return initiators;
    }

    protected void getAssociatedStatisticsImpl() {
        String METHOD = "getAssociatedStatisticsImpl";
        Trace.methodBegin(this, "getAssociatedStatisticsImpl");
        try {
            Trace.verbose((Object)this, "getAssociatedStatisticsImpl", "Querying CIM for associated FCPortStatistics instance.");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementStatisticalData", "SunStorEdge_DSPFCPortStatistics", "ManagedElement", "Stats", true, false, null);
            Trace.verbose((Object)this, "getAssociatedStatisticsImpl", "Returned from querying CIM for associated FCPortStatistics instances.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                CIMValue cv = ci.getProperty("ErrorFrames").getValue();
                if (cv != null) {
                    this.errorCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'ErrorFrames'.");
                    this.errorCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("PacketsTransmitted").getValue();
                if (cv != null) {
                    this.writeCommands = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'PacketsTransmitted'.");
                    this.writeCommands = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("PacketsReceived").getValue();
                if (cv != null) {
                    this.readCommands = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'PacketsReceived'.");
                    this.readCommands = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("BytesReceived").getValue();
                if (cv != null) {
                    this.bytesRead = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'BytesReceived'.");
                    this.bytesRead = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("BytesTransmitted").getValue();
                if (cv != null) {
                    this.bytesWritten = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'BytesTransmitted'.");
                    this.bytesWritten = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("InvalidTransmissionWords").getValue();
                if (cv != null) {
                    this.invalidTransWords = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'InvalidTransmissionWords'.");
                    this.invalidTransWords = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("LinkResetsReceived").getValue();
                if (cv != null) {
                    this.loopResetEvents = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'LinkResetsReceived'.");
                    this.loopResetEvents = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("LinkFailures").getValue();
                if (cv != null) {
                    this.linkFailureCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'LinkFailures'.");
                    this.linkFailureCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("LossOfSyncCounter").getValue();
                if (cv != null) {
                    this.linkSyncLossCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'LossOfSyncCounter'.");
                    this.linkSyncLossCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("LossOfSignalCounter").getValue();
                if (cv != null) {
                    this.linkDownCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'LossOfSignalCounter'.");
                    this.linkDownCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("PrimitiveSeqProtocolErrCount").getValue();
                if (cv != null) {
                    this.primSeqProtoErrorCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'PrimitiveSeqProtocolErrCount'.");
                    this.primSeqProtoErrorCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("CRCErrors").getValue();
                if (cv != null) {
                    this.crcErrors = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving FCPortStatistics 'CRCErrors'.");
                    this.crcErrors = new BigInteger("0");
                }
            } else {
                Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving associated FCPortStatistics using defaults.");
                this.errorCount = new BigInteger("0");
                this.writeCommands = new BigInteger("0");
                this.readCommands = new BigInteger("0");
                this.bytesRead = new BigInteger("0");
                this.bytesWritten = new BigInteger("0");
                this.invalidTransWords = new BigInteger("0");
                this.loopResetEvents = new BigInteger("0");
                this.linkFailureCount = new BigInteger("0");
                this.linkSyncLossCount = new BigInteger("0");
                this.linkDownCount = new BigInteger("0");
                this.primSeqProtoErrorCount = new BigInteger("0");
                this.crcErrors = new BigInteger("0");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving associated FCPortStatistics using defaults.");
            this.errorCount = new BigInteger("0");
            this.writeCommands = new BigInteger("0");
            this.readCommands = new BigInteger("0");
            this.bytesRead = new BigInteger("0");
            this.bytesWritten = new BigInteger("0");
            this.invalidTransWords = new BigInteger("0");
            this.loopResetEvents = new BigInteger("0");
            this.linkFailureCount = new BigInteger("0");
            this.linkSyncLossCount = new BigInteger("0");
            this.linkDownCount = new BigInteger("0");
            this.primSeqProtoErrorCount = new BigInteger("0");
            this.crcErrors = new BigInteger("0");
        }
    }

    public void setReplicationEnabled(boolean replicationEnabled) {
        String METHOD = "setReplicationEnabled";
        Trace.methodBegin(this, "setReplicationEnabled");
        this.replicationEnabled = replicationEnabled;
        Trace.methodEnd(this, "setReplicationEnabled");
    }

    public String getConfigSpeed() {
        String METHOD = "getConfigSpeed";
        Trace.methodBegin(this, "getConfigSpeed");
        Trace.methodEnd(this, "getConfigSpeed");
        return this.configSpeed;
    }

    public String getHwState() {
        String METHOD = "getHwState";
        Trace.methodBegin(this, "getHwState");
        Trace.methodEnd(this, "getHwState");
        return this.hwState;
    }

    public CIMInstance getInstance() {
        String METHOD = "getInstance";
        Trace.methodBegin(this, "getInstance");
        Trace.methodEnd(this, "getInstance");
        return this.instance;
    }

    public String getSystemCreationClassName() {
        String METHOD = "getSystemCreationClassName";
        Trace.methodBegin(this, "getSystemCreationClassName");
        Trace.methodEnd(this, "getSystemCreationClassName");
        return this.systemCreationClassName;
    }

    public String getSystemName() {
        String METHOD = "getSystemName";
        Trace.methodBegin(this, "getSystemName");
        Trace.methodEnd(this, "getSystemName");
        return this.systemName;
    }

    public String getCreationClassName() {
        String METHOD = "getCreationClassName";
        Trace.methodBegin(this, "getCreationClassName");
        Trace.methodEnd(this, "getCreationClassName");
        return this.creationClassName;
    }

    public String getDeviceID() {
        String METHOD = "getDeviceID";
        Trace.methodBegin(this, "getDeviceID");
        Trace.methodEnd(this, "getDeviceID");
        return this.deviceID;
    }

    public String getPopNodeWwn() {
        String METHOD = "getPopNodeWwn";
        Trace.methodBegin(this, "getPopNodeWwn");
        Trace.methodEnd(this, "getPopNodeWwn");
        return this.nodeWwn;
    }

    public BigInteger getSpeed() {
        String METHOD = "getSpeed";
        Trace.methodBegin(this, "getSpeed");
        Trace.methodEnd(this, "getSpeed");
        return this.speed;
    }

    public boolean getAutoSpeedSense() {
        String METHOD = "getSpeedSense";
        Trace.methodBegin(this, "getSpeedSense");
        Trace.methodEnd(this, "getSpeedSense");
        return this.autoSpeedSense;
    }

    public boolean getReplicationEnabled() {
        String METHOD = "getReplicationEnabled";
        Trace.methodBegin(this, "getReplicationEnabled");
        Trace.methodEnd(this, "getReplicationEnabled");
        return this.replicationEnabled;
    }

    public void setSpeedConfigured(int speed) {
        String METHOD = "setSpeedConfigured";
        Trace.methodBegin(this, "setSpeedConfigured");
        Trace.verbose((Object)this, "setSpeedConfigured", "Determining Configured Speed");
        switch (speed) {
            case 0: {
                this.setAutoSpeedSense(true);
                return;
            }
            case 1: {
                this.setAutoSpeedSense(false);
                this.setSpeed(Constants.FiberChannelProperties.ONE_GIGABYTE);
                return;
            }
            case 2: {
                this.setAutoSpeedSense(false);
                this.setSpeed(Constants.FiberChannelProperties.TWO_GIGABYTE);
                return;
            }
        }
        Trace.error((Object)this, "setSpeedConfigured", "Invalid Parameter: " + speed);
    }

    public void setInstance(CIMInstance instance) {
        String METHOD = "setInstance";
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
        Trace.methodEnd(this, "setInstance");
    }

    public void setPortName(String portName) {
        String METHOD = "setPortName";
        Trace.methodBegin(this, "setPortName");
        this.portName = portName;
        Trace.methodEnd(this, "setPortName");
    }

    public void setWwn(String wwn) {
        String METHOD = "setWwn";
        Trace.methodBegin(this, "setWwn");
        this.wwn = wwn;
        Trace.methodEnd(this, "setWwn");
    }

    public void setPortID(String portID) {
        String METHOD = "setPortID";
        Trace.methodBegin(this, "setPortID");
        this.portID = portID;
        Trace.methodEnd(this, "setPortID");
    }

    public void setLinkState(int linkState) {
        String METHOD = "setLinkState";
        Trace.methodBegin(this, "setLinkState");
        this.linkState = linkState;
        Trace.methodEnd(this, "setLinkState");
    }

    public void setHwState(String hwState) {
        String METHOD = "setHwState";
        Trace.methodBegin(this, "setHwState");
        this.hwState = hwState;
        Trace.methodEnd(this, "setHwState");
    }

    public void setPortType(int portType) {
        String METHOD = "setPortType";
        Trace.methodBegin(this, "setPortType");
        this.portType = portType;
        Trace.methodEnd(this, "setPortType");
    }

    public void setPortStyle(int portStyle) {
        String METHOD = "setPortStyle";
        Trace.methodBegin(this, "setPortStyle");
        this.portStyle = portStyle;
        Trace.methodEnd(this, "setPortStyle");
    }

    public void setSpeed(BigInteger speed) {
        String METHOD = "setSpeed";
        Trace.methodBegin(this, "setSpeed");
        this.speed = speed;
        Trace.methodEnd(this, "setSpeed");
    }

    public void setAutoSpeedSense(boolean autoSpeedSense) {
        String METHOD = "setAutoSpeedSense";
        Trace.methodBegin(this, "setAutoSpeedSense");
        this.autoSpeedSense = autoSpeedSense;
        Trace.methodEnd(this, "setAutoSpeedSense");
    }

    public void setCapableClass(Set capableClass) {
        String METHOD = "setCapableClass";
        Trace.methodBegin(this, "setCapableClass");
        this.capableClass = capableClass;
        Trace.methodEnd(this, "setCapableClass");
    }

    public void setOperClass(Set operClass) {
        String METHOD = "setOperClass";
        Trace.methodBegin(this, "setOperClass");
        this.operClass = operClass;
        Trace.methodEnd(this, "setOperClass");
    }

    public void setCapableProtocol(Set capableProtocol) {
        String METHOD = "setCapableProtocol";
        Trace.methodBegin(this, "setCapableProtocol");
        this.capableProtocol = capableProtocol;
        Trace.methodEnd(this, "setCapableProtocol");
    }

    public void setOperProtocol(Set operProtocol) {
        String METHOD = "setOperProtocol";
        Trace.methodBegin(this, "setOperProtocol");
        this.operProtocol = operProtocol;
        Trace.methodEnd(this, "setOperProtocol");
    }

    public void setModuleType(String moduleType) {
        String METHOD = "setModuleType";
        Trace.methodBegin(this, "setModuleType");
        this.moduleType = moduleType;
        Trace.methodEnd(this, "setModuleType");
    }

    public void setFcUnitType(String fcUnitType) {
        String METHOD = "setFcUnitType";
        Trace.methodBegin(this, "setFcUnitType");
        this.fcUnitType = fcUnitType;
        Trace.methodEnd(this, "setFcUnitType");
    }

    public void setConfigSpeed(String configSpeed) {
        String METHOD = "setConfigSpeed";
        Trace.methodBegin(this, "setConfigSpeed");
        this.configSpeed = configSpeed;
        Trace.methodEnd(this, "setConfigSpeed");
    }

    public void setSystemCreationClassName(String sccn) {
        String METHOD = "setSystemCreationClassName";
        Trace.methodBegin(this, "setSystemCreationClassName");
        this.systemCreationClassName = sccn;
        Trace.methodEnd(this, "setSystemCreationClassName");
    }

    public void setSystemName(String sn) {
        String METHOD = "setSystemName";
        Trace.methodBegin(this, "setSystemName");
        this.systemName = sn;
        this.nodeWwn = sn;
        Trace.methodEnd(this, "setSystemName");
    }

    public void setCreationClassName(String ccn) {
        String METHOD = "setCreationClassName";
        Trace.methodBegin(this, "setCreationClassName");
        this.creationClassName = ccn;
        Trace.methodEnd(this, "setCreationClassName");
    }

    public void setDeviceID(String deviceID) {
        String METHOD = "setDeviceID";
        Trace.methodBegin(this, "setDeviceID");
        this.deviceID = deviceID;
        Trace.methodEnd(this, "setDeviceID");
    }

    public void setPopNodeWwn(String nodeWwn) {
        String METHOD = "setPopNodeWwn";
        Trace.methodBegin(this, "setPopNodeWwn");
        this.nodeWwn = nodeWwn;
        Trace.methodEnd(this, "setPopNodeWwn");
    }

    public void setKey(Collection props) {
        String METHOD = "setKey";
        Trace.methodBegin(this, "setKey");
        this.keyProperties = props;
        Trace.methodEnd(this, "setKey");
    }

    public Collection getFieldMap() {
        String METHOD = "getFieldMap";
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("portName", "ElementName", true, false));
            this.fieldMap.add(new MapElement("linkState", "OperationalStatus", true, false, 0));
            this.fieldMap.add(new MapStringArrayToString("hwState", "OtherIdentifyingInfo", true, false, 3));
            this.fieldMap.add(new MapElement("portID", "NetworkAddresses", true, true, 0));
            this.fieldMap.add(new MapElement("wwn", "PermanentAddress", true, false));
            this.fieldMap.add(new MapElement("portType", "PortType", true, true));
            this.fieldMap.add(new MapElement("portStyle", "LinkTechnology", true, true));
            this.fieldMap.add(new MapUint64ToBigInteger("speed", "Speed", false, false));
            this.fieldMap.add(new MapElement("autoSpeedSense", "AutoSense", false, false));
            this.fieldMap.add(new MapElement("replicationEnabled", "ReplicationCapable", false, false));
            this.fieldMap.add(new MapArrayToSet("capableClass", "SupportedCOS", true, true));
            this.fieldMap.add(new MapArrayToSet("operClass", "ActiveCOS", true, true));
            this.fieldMap.add(new MapArrayToSet("capableProtocol", "SupportedFC4Types", true, true));
            this.fieldMap.add(new MapArrayToSet("operProtocol", "ActiveFC4Types", true, true));
            this.fieldMap.add(new MapStringArrayToString("moduleType", "OtherIdentifyingInfo", true, true, 0));
            this.fieldMap.add(new MapStringArrayToString("fcUnitType", "OtherIdentifyingInfo", true, true, 1));
            this.fieldMap.add(new MapStringArrayToString("configSpeed", "OtherIdentifyingInfo", true, false, 2));
            this.fieldMap.add(new MapElement("systemCreationClassName", "SystemCreationClassName", true, false));
            this.fieldMap.add(new MapElement("systemName", "SystemName", true, false));
            this.fieldMap.add(new MapElement("creationClassName", "CreationClassName", true, false));
            this.fieldMap.add(new MapElement("deviceID", "DeviceID", true, false));
            this.fieldMap.add(new MapElement("popNodeWwn", "NodeWwn", true, false));
        }
        Trace.methodEnd(this, "getFieldMap");
        return this.fieldMap;
    }

    public void loadKeys() {
        String METHOD = "loadKeys";
        Trace.methodBegin(this, "loadKeys");
        ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
        prop.add(new CIMProperty("SystemCreationClassName", new CIMValue((Object)this.getSystemCreationClassName())));
        prop.add(new CIMProperty("SystemName", new CIMValue((Object)this.getSystemName())));
        prop.add(new CIMProperty("CreationClassName", new CIMValue((Object)this.getCreationClassName())));
        prop.add(new CIMProperty("DeviceID", new CIMValue((Object)this.getDeviceID())));
        this.setKey(prop);
        Trace.methodEnd(this, "loadKeys");
    }

    public String toString() {
        String METHOD = "toString";
        Trace.methodBegin(this, "toString");
        if (Trace.isTraceEnabled(this)) {
            Trace.methodEnd(this, "toString");
            return "\nFiberChannelPort with:\n   PortName: " + this.getPortName() + "\n   Link State: " + this.getLinkState() + "\n   Hardware State: " + this.getHardwareState() + "\n   Port ID: " + this.getPortID() + "\n   WWN: " + this.getPortWWN() + "\n   Port Type: " + this.getPortType() + "\n   Config Speed: " + this.getSpeedConfigured() + "\n   Oper Speed: " + this.getSpeedOperational() + "\n   Classes Capable: " + this.capableClass + "\n   Classes Oper: " + this.operClass + "\n   Protocols Capable: " + this.capableProtocol + "\n   Protocols Oper: " + this.operProtocol;
        }
        Trace.methodEnd(this, "toString");
        return "";
    }
}

