/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapUint64ToBigInteger;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationLinkCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.EthernetPortEnt1;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;

public class EthernetPortCIM
extends EthernetPortEnt1 {
    private Collection fieldMap;
    private ConfigContext context;
    private CIMInstance instance;
    private CIMOMHandleWrapper handle;
    private boolean autoSpeedSense;
    private String systemCreationClassName;
    private String systemName;
    private String creationClassName;
    private String deviceID;
    private BigInteger supportedMaximumTransmissionUnit;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$cim$EthernetPortCIM;

    protected void initImpl(ConfigContext context) throws ConfigMgmtException {
        String METHOD = "initImpl";
        Trace.methodBegin(this, "initImpl");
        if (context == null) {
            Trace.error((Object)this, "initImpl", "ConfigContext object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "ConfigContext object is null.", null, 100);
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "initImpl", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "CIMOMHandleWrapper object is null.", null, 100);
        }
        Trace.methodEnd(this, "initImpl");
    }

    public void save() throws ConfigMgmtException {
        String METHOD = "save";
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
        }
        Trace.methodEnd(this, "save");
    }

    public void reload() throws ConfigMgmtException {
        String METHOD = "reload";
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.instance.getObjectPath(), false, true, false, ConstantsEnt.FCPortProperties.PROP_LIST);
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.loadKeys();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
        }
        Trace.methodEnd(this, "reload");
    }

    protected void getAssociatedStatisticsImpl() {
        String METHOD = "getAssociatedStatisticsImpl";
        Trace.methodBegin(this, "getAssociatedStatisticsImpl");
        try {
            Trace.verbose((Object)this, "getAssociatedStatisticsImpl", "Querying CIM for associated EthernetPortStatistics instance.");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementStatisticalData", "SunStorEdge_DSPEthernetPortStatistics", "ManagedElement", "Stats", true, false, null);
            Trace.verbose((Object)this, "getAssociatedStatisticsImpl", "Returned from querying CIM for associated EthernetPortStatistics instances.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                CIMValue cv = null;
                cv = ci.getProperty("PacketsTransmitted").getValue();
                if (cv != null) {
                    this.writeCommands = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving EthernetPortStatistics 'PacketsTransmitted'.");
                    this.writeCommands = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("PacketsReceived").getValue();
                if (cv != null) {
                    this.readCommands = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving EthernetPortStatistics 'PacketsReceived'.");
                    this.readCommands = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("BytesReceived").getValue();
                if (cv != null) {
                    this.bytesRead = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving EthernetPortStatistics 'BytesReceived'.");
                    this.bytesRead = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("BytesTransmitted").getValue();
                if (cv != null) {
                    this.bytesWritten = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving EthernetPortStatistics 'BytesTransmitted'.");
                    this.bytesWritten = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("InternalMACTransmitErrors").getValue();
                if (cv != null) {
                    this.writeErrors = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving EthernetPortStatistics 'InternalMACTransmitErrors'.");
                    this.writeErrors = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("InternalMACReceiveErrors").getValue();
                if (cv != null) {
                    this.readErrors = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving EthernetPortStatistics 'InternalMACReceiveErrors'.");
                    this.readErrors = new BigInteger("0");
                }
            } else {
                Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving associated EthernetPortStatistics using defaults.");
                this.writeCommands = new BigInteger("0");
                this.readCommands = new BigInteger("0");
                this.bytesRead = new BigInteger("0");
                this.bytesWritten = new BigInteger("0");
                this.readErrors = new BigInteger("0");
                this.writeErrors = new BigInteger("0");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedStatisticsImpl", "Errors retrieving associated EthernetPortStatistics using defaults.");
            this.writeCommands = new BigInteger("0");
            this.readCommands = new BigInteger("0");
            this.bytesRead = new BigInteger("0");
            this.bytesWritten = new BigInteger("0");
            this.readErrors = new BigInteger("0");
            this.writeErrors = new BigInteger("0");
        }
    }

    protected void getAssociatedRepInfoImpl() throws ConfigMgmtException {
        String METHOD = "getAssociatedRepInfoImpl";
        Trace.methodBegin(this, "getAssociatedRepInfoImpl");
        Trace.verbose((Object)this, "getAssociatedRepInfoImpl", "Querying CIM for associated ReplicationPort instance.");
        Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementSettingData", "SunStorEdge_DSPReplicationPort", "ManagedElement", "SettingData", true, false, null);
        Trace.verbose((Object)this, "getAssociatedRepInfoImpl", "Returned from querying CIM for associated ReplicationPort instances.");
        if (enumeration != null && enumeration.hasMoreElements()) {
            CIMInstance ci = (CIMInstance)enumeration.nextElement();
            CIMValue cv = ci.getProperty("DefaultGateway").getValue();
            if (cv != null) {
                this.defaultGateway = (String)cv.getValue();
            } else {
                Trace.error((Object)this, "getAssociatedRepInfoImpl", "Errors retrieving ReplicationPort 'DefaultGateway'.");
                this.defaultGateway = "";
            }
            cv = ci.getProperty("NetworkMask").getValue();
            if (cv != null) {
                this.networkMask = (String)cv.getValue();
            } else {
                Trace.error((Object)this, "getAssociatedRepInfoImpl", "Errors retrieving ReplicationPort 'NetworkMask'.");
                this.networkMask = "";
            }
            cv = ci.getProperty("LocalAddress").getValue();
            if (cv != null) {
                this.localAddress = (String)cv.getValue();
            } else {
                Trace.error((Object)this, "getAssociatedRepInfoImpl", "Errors retrieving ReplicationPort 'LocalAddress'.");
                this.localAddress = "";
            }
            cv = ci.getProperty("TCPWindowSize").getValue();
            if (cv != null) {
                this.wndSize = ((UnsignedInt32)cv.getValue()).intValue();
            } else {
                Trace.error((Object)this, "getAssociatedRepInfoImpl", "Errors retrieving ReplicationPort 'WindowSize'.");
            }
            Trace.verbose((Object)this, "getAssociatedRepInfoImpl", "Querying CIM for associated ReplicationLink instances.");
            Enumeration enumLinks = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementSettingData", "SunStorEdge_DSPReplicationLink", "ManagedElement", "SettingData", true, false, null);
            Trace.verbose((Object)this, "getAssociatedRepInfoImpl", "Returned from querying CIM for associated ReplicationLink instances.");
            if (enumLinks != null && enumLinks.hasMoreElements()) {
                this.links = new ArrayList();
                while (enumLinks.hasMoreElements()) {
                    CIMInstance ciLink = (CIMInstance)enumLinks.nextElement();
                    ReplicationLinkCIM repLink = new ReplicationLinkCIM(ciLink);
                    this.links.add(repLink);
                }
            } else {
                Trace.verbose((Object)this, "getAssociatedRepInfoImpl", "No Replication Links found.");
                this.links = new ArrayList();
            }
        } else {
            Trace.verbose((Object)this, "getAssociatedRepInfoImpl", "No instances of ReplicationPort found, using defaults.");
            this.defaultGateway = "";
            this.networkMask = "";
            this.localAddress = "";
            this.links = new ArrayList();
        }
        Trace.methodEnd(this, "getAssociatedRepInfoImpl");
    }

    public void setReplicationEnabled(boolean replicationEnabled) {
        String METHOD = "setReplicationEnabled";
        Trace.methodBegin(this, "setReplicationEnabled");
        this.replicationEnabled = replicationEnabled;
        Trace.methodEnd(this, "setReplicationEnabled");
    }

    public String getHwState() {
        String METHOD = "getHwState";
        Trace.methodBegin(this, "getHwState");
        Trace.methodEnd(this, "getHwState");
        return this.hwState;
    }

    public CIMInstance getInstance() {
        String METHOD = "getInstance";
        Trace.methodBegin(this, "getInstance");
        Trace.methodEnd(this, "getInstance");
        return this.instance;
    }

    public String getSystemCreationClassName() {
        String METHOD = "getSystemCreationClassName";
        Trace.methodBegin(this, "getSystemCreationClassName");
        Trace.methodEnd(this, "getSystemCreationClassName");
        return this.systemCreationClassName;
    }

    public String getSystemName() {
        String METHOD = "getSystemName";
        Trace.methodBegin(this, "getSystemName");
        Trace.methodEnd(this, "getSystemName");
        return this.systemName;
    }

    public String getCreationClassName() {
        String METHOD = "getCreationClassName";
        Trace.methodBegin(this, "getCreationClassName");
        Trace.methodEnd(this, "getCreationClassName");
        return this.creationClassName;
    }

    public String getDeviceID() {
        String METHOD = "getDeviceID";
        Trace.methodBegin(this, "getDeviceID");
        Trace.methodEnd(this, "getDeviceID");
        return this.deviceID;
    }

    public BigInteger getSpeed() {
        String METHOD = "getSpeed";
        Trace.methodBegin(this, "getSpeed");
        Trace.methodEnd(this, "getSpeed");
        return this.speed;
    }

    public String getMacAddr() {
        String METHOD = "getMacAddr";
        Trace.methodBegin(this, "getMacAddr");
        Trace.methodEnd(this, "getMacAddr");
        return this.macAddr;
    }

    public boolean getReplicationEnabled() {
        String METHOD = "getReplicationEnabled";
        Trace.methodBegin(this, "getReplicationEnabled");
        Trace.methodEnd(this, "getReplicationEnabled");
        return this.replicationEnabled;
    }

    public void setInstance(CIMInstance instance) {
        String METHOD = "setInstance";
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
        Trace.methodEnd(this, "setInstance");
    }

    public void setPortName(String portName) {
        String METHOD = "setPortName";
        Trace.methodBegin(this, "setPortName");
        this.portName = portName;
        Trace.methodEnd(this, "setPortName");
    }

    public void setLinkState(int linkState) {
        String METHOD = "setLinkState";
        Trace.methodBegin(this, "setLinkState");
        this.linkState = linkState;
        Trace.methodEnd(this, "setLinkState");
    }

    public void setHwState(String hwState) {
        String METHOD = "setHwState";
        Trace.methodBegin(this, "setHwState");
        this.hwState = hwState;
        Trace.methodEnd(this, "setHwState");
    }

    public void setPortType(int portType) {
        String METHOD = "setPortType";
        Trace.methodBegin(this, "setPortType");
        this.portType = portType;
        Trace.methodEnd(this, "setPortType");
    }

    public void setPortStyle(int portStyle) {
        String METHOD = "setPortStyle";
        Trace.methodBegin(this, "setPortStyle");
        this.portStyle = portStyle;
        Trace.methodEnd(this, "setPortStyle");
    }

    public void setSpeed(BigInteger speed) {
        String METHOD = "setSpeed";
        Trace.methodBegin(this, "setSpeed");
        this.speed = speed;
        Trace.methodEnd(this, "setSpeed");
    }

    public void setMacAddr(String macAddr) {
        String METHOD = "getMacAddr";
        Trace.methodBegin(this, "getMacAddr");
        this.macAddr = macAddr;
        Trace.methodEnd(this, "getMacAddr");
    }

    public void setSystemCreationClassName(String sccn) {
        String METHOD = "setSystemCreationClassName";
        Trace.methodBegin(this, "setSystemCreationClassName");
        this.systemCreationClassName = sccn;
        Trace.methodEnd(this, "setSystemCreationClassName");
    }

    public void setSystemName(String sn) {
        String METHOD = "setSystemName";
        Trace.methodBegin(this, "setSystemName");
        this.systemName = sn;
        Trace.methodEnd(this, "setSystemName");
    }

    public void setCreationClassName(String ccn) {
        String METHOD = "setCreationClassName";
        Trace.methodBegin(this, "setCreationClassName");
        this.creationClassName = ccn;
        Trace.methodEnd(this, "setCreationClassName");
    }

    public void setDeviceID(String deviceID) {
        String METHOD = "setDeviceID";
        Trace.methodBegin(this, "setDeviceID");
        this.deviceID = deviceID;
        Trace.methodEnd(this, "setDeviceID");
    }

    public void setKey(Collection props) {
        String METHOD = "setKey";
        Trace.methodBegin(this, "setKey");
        this.keyProperties = props;
        Trace.methodEnd(this, "setKey");
    }

    public BigInteger getSupportedMaximumTransmissionUnit() {
        return this.supportedMaximumTransmissionUnit;
    }

    public void setSupportedMaximumTransmissionUnit(BigInteger val) {
        this.supportedMaximumTransmissionUnit = val;
        if (this.supportedMaximumTransmissionUnit != null) {
            this.defWndSize = this.supportedMaximumTransmissionUnit.intValue();
        }
    }

    public Collection getFieldMap() {
        String METHOD = "getFieldMap";
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("portName", "ElementName", true, false));
            this.fieldMap.add(new MapElement("linkState", "OperationalStatus", true, false, 0));
            this.fieldMap.add(new MapStringArrayToString("hwState", "OtherIdentifyingInfo", true, false, 3));
            this.fieldMap.add(new MapElement("portType", "PortType", true, true));
            this.fieldMap.add(new MapElement("macAddr", "PermanentAddress", true, true));
            this.fieldMap.add(new MapElement("portStyle", "LinkTechnology", true, true));
            this.fieldMap.add(new MapUint64ToBigInteger("speed", "Speed", false, false));
            this.fieldMap.add(new MapElement("replicationEnabled", "ReplicationCapable", false, false));
            this.fieldMap.add(new MapElement("systemCreationClassName", "SystemCreationClassName", true, false));
            this.fieldMap.add(new MapElement("systemName", "SystemName", true, false));
            this.fieldMap.add(new MapElement("creationClassName", "CreationClassName", true, false));
            this.fieldMap.add(new MapElement("deviceID", "DeviceID", true, false));
            this.fieldMap.add(new MapUint64ToBigInteger("supportedMaximumTransmissionUnit", "SupportedMaximumTransmissionUnit", true, true));
        }
        Trace.methodEnd(this, "getFieldMap");
        return this.fieldMap;
    }

    public void loadKeys() {
        String METHOD = "loadKeys";
        Trace.methodBegin(this, "loadKeys");
        ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
        prop.add(new CIMProperty("SystemCreationClassName", new CIMValue((Object)this.getSystemCreationClassName())));
        prop.add(new CIMProperty("SystemName", new CIMValue((Object)this.getSystemName())));
        prop.add(new CIMProperty("CreationClassName", new CIMValue((Object)this.getCreationClassName())));
        prop.add(new CIMProperty("DeviceID", new CIMValue((Object)this.getDeviceID())));
        this.setKey(prop);
        Trace.methodEnd(this, "loadKeys");
    }

    public String toString() {
        String METHOD = "toString";
        Trace.methodBegin(this, "toString");
        if (Trace.isTraceEnabled(this)) {
            Trace.methodEnd(this, "toString");
            return "\nEthernetPort with:\n   PortName: " + this.getPortName() + "\n   Link State: " + this.getLinkState() + "\n   Hardware State: " + this.getHardwareState() + "\n   Port Type: " + this.getPortType() + "\n   Oper Speed: " + this.getSpeedOperational();
        }
        Trace.methodEnd(this, "toString");
        return "";
    }

    public static void validate(int property, Object newValue, Object oldValue) throws ConfigMgmtException {
        String METHOD = "validate";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$cim$EthernetPortCIM == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$cim$EthernetPortCIM = EthernetPortCIM.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim.EthernetPortCIM")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$cim$EthernetPortCIM, "validate");
        switch (property) {
            case 0: {
                if (oldValue != null) break;
                if (newValue == null) {
                    throw new ConfigMgmtException(ErrorCode.INVALID_LOCAL_ADDRESS.getKey(), null, "Local Address is null.", null, 300);
                }
                String localAddress = (String)newValue;
                if (Pattern.matches("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b", localAddress)) break;
                throw new ConfigMgmtException(ErrorCode.INVALID_LOCAL_ADDRESS.getKey(), null, "Local Address is invalid.", null, 300);
            }
            case 1: {
                if (oldValue != null) break;
                if (newValue == null) {
                    throw new ConfigMgmtException(ErrorCode.INVALID_NETWORK_MASK.getKey(), null, "Network Mask is null.", null, 300);
                }
                String networkMask = (String)newValue;
                if (Pattern.matches("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b", networkMask)) break;
                throw new ConfigMgmtException(ErrorCode.INVALID_NETWORK_MASK.getKey(), null, "Network Mask is invalid.", null, 300);
            }
            case 2: {
                if (oldValue != null) break;
                if (newValue == null) {
                    throw new ConfigMgmtException(ErrorCode.INVALID_DEFAULT_GATEWAY.getKey(), null, "Default Gateway is null.", null, 300);
                }
                String defaultGateway = (String)newValue;
                if (Pattern.matches("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b", defaultGateway)) break;
                throw new ConfigMgmtException(ErrorCode.INVALID_DEFAULT_GATEWAY.getKey(), null, "Default Gateway is invalid.", null, 300);
            }
            case 3: {
                if (oldValue != null) break;
                if (newValue == null) {
                    throw new ConfigMgmtException(ErrorCode.INVALID_WND_SIZE.getKey(), null, "Windows Size is null.", null, 300);
                }
                Integer wndSize = (Integer)newValue;
                if (wndSize >= 1024 && wndSize <= 0x100000) break;
                throw new ConfigMgmtException(ErrorCode.INVALID_WND_SIZE.getKey(), null, "Windows Size out of range.", null, 300);
            }
        }
        Trace.methodEnd(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$cim$EthernetPortCIM == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$cim$EthernetPortCIM = EthernetPortCIM.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim.EthernetPortCIM")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$cim$EthernetPortCIM, "validate");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

