/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.RaidSetGroup;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageDomains;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageDomain;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim.StorageArray;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;

public class StoragePool
implements StoragePoolInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private ArrayList fieldMap;
    private CIMInstance instance;
    private CIMObjectPath objectPath;
    private CIMObjectPath capObjectPath;
    private CIMObjectPath domainObjectPath;
    private String name;
    private String description;
    private String profileName = null;
    private StorageProfile profile = null;
    private String domainName = null;
    private StorageDomain domain;
    private BigInteger totalCapacity;
    private BigInteger allocatedCapacity;
    private BigInteger unallocatedCapacity;
    private String instanceID;
    private Collection keyProperties;
    private boolean deletable = true;
    private ArrayList vdisks;

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.objectPath, false, true, false, ConstantsEnt.StoragePoolProperties.PROP_LIST);
        this.domainName = null;
        this.profileName = null;
        this.domain = null;
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.loadKeys();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
        }
    }

    public String getName() {
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getDescription() {
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public String getProfileName() {
        String METHOD = "getProfileName";
        Trace.methodBegin(this, "getProfileName");
        if (this.profileName == null) {
            try {
                this.getStorageWithHints();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getProfileName", "Error retrieving StorageProfile Name.");
                this.profileName = "";
            }
        }
        Trace.methodEnd(this, "getProfileName");
        return this.profileName;
    }

    public String getStorageDomainName() {
        Trace.methodBegin(this, "getStorageDomainName");
        if (this.domainName == null) {
            try {
                this.getAssociatedDomain();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStorageDomainName", "Error retrieving StorageDomain Name.");
                this.domainName = "";
            }
        }
        return this.domainName;
    }

    public StorageDomainInterface getStorageDomain() {
        String METHOD = "getStorageDomain";
        Trace.methodBegin(this, "getStorageDomain");
        if (this.domain == null) {
            try {
                this.getAssociatedDomain();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStorageDomain", "Error retrieving StorageDomain instance.");
            }
        }
        Trace.methodEnd(this, "getStorageDomain");
        return this.domain;
    }

    public BigInteger getStorageCapacity() {
        Trace.methodBegin(this, "getStorageCapacity");
        return this.totalCapacity;
    }

    public BigInteger getAllocatedCapacity() {
        Trace.methodBegin(this, "getAllocatedCapacity");
        return this.totalCapacity.subtract(this.unallocatedCapacity);
    }

    public BigInteger getUnAllocatedCapacity() {
        Trace.methodBegin(this, "getUnAllocatedCapacity");
        return this.unallocatedCapacity;
    }

    public boolean isInUse() {
        Trace.methodBegin(this, "isInUse");
        BigInteger zero = new BigInteger("0");
        Trace.verbose((Object)this, "isInUse", "Checking if StoragePool is in use based on AllocatedCapacity.");
        return !this.getAllocatedCapacity().equals(zero);
    }

    public Collection getKey() {
        Trace.methodBegin(this, "getKey");
        return this.keyProperties;
    }

    public ArrayList getAssociatedVDisks() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssociatedVDisks");
        if (this.vdisks != null) {
            Trace.methodEnd(this, "getAssociatedVDisks");
            return this.vdisks;
        }
        try {
            Trace.verbose((Object)this, "getAssociatedVDisks", "Querying CIM for associated VDisks.");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPConcreteComponent", "SunStorEdge_DSPStorageExtent", "GroupComponent", "PartComponent", true, false, ConstantsEnt.StorageExtentProperties.PROP_LIST);
            Trace.verbose((Object)this, "getAssociatedVDisks", "Returned from querying CIM for VDisks.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getAssociatedVDisks", "VDisk Instances Found.");
                this.vdisks = new ArrayList();
                while (enumeration.hasMoreElements()) {
                    UnsignedInt16 extStatus;
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    CIMProperty cimProp = ci.getProperty("ExtentStatus");
                    CIMValue cVal = cimProp.getValue();
                    Vector vals = (Vector)cVal.getValue();
                    if (vals == null || vals.size() <= 0 || (extStatus = (UnsignedInt16)vals.get(0)).intValue() != 2) continue;
                    Trace.verbose((Object)this, "getAssociatedVDisks", "Creating VDisk Java object.");
                    VDisk vd = new VDisk();
                    vd.setInstance(ci);
                    vd.init(this.context);
                    CIMObjectWrapper.populate(vd, vd.getFieldMap(), ci);
                    vd.loadKeys();
                    this.vdisks.add(vd);
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, "getAssociatedVDisks", "The instance added to the list: " + vd);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedVDisks", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssociatedVDisks", "NullPointerException - Null returned when trying to obtain all the VDisk instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the VDisk instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssociatedVDisks", "Exception - Exception thrown when trying to obtain all the VDisk instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the VDisk instances.", e);
        }
        if (this.vdisks == null) {
            Trace.methodEnd(this, "getAssociatedVDisks");
            return new ArrayList();
        }
        Trace.methodEnd(this, "getAssociatedVDisks");
        return this.vdisks;
    }

    public List getArrayControllers() throws ConfigMgmtException {
        String METHOD = "getArrayControllers";
        Trace.methodBegin(this, "getArrayControllers");
        ArrayList<StorageArray> acInstances = null;
        if (this.vdisks == null) {
            this.getAssociatedVDisks();
        }
        if (this.vdisks != null) {
            int size = this.vdisks.size();
            Trace.verbose((Object)this, "getArrayControllers", "Num of vdisks: " + size);
            acInstances = new ArrayList<StorageArray>();
            ArrayList<String> acIds = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                VDisk vdisk = (VDisk)this.vdisks.get(i);
                StorageArray storArray = (StorageArray)vdisk.getArrayController();
                if (storArray == null) {
                    Trace.verbose((Object)this, "getArrayControllers", "StorageArray is null: ");
                    continue;
                }
                Trace.verbose((Object)this, "getArrayControllers", "StorageArray id:" + storArray.getArrayID());
                if (acIds.contains(storArray.getArrayID())) continue;
                acInstances.add(storArray);
                acIds.add(storArray.getArrayID());
            }
        }
        Trace.methodEnd(this, "getArrayControllers");
        return acInstances;
    }

    public ArrayList getAssociatedVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssociatedVolumes");
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        ArrayList items = new ArrayList();
        items = msv.getItemsByStoragePool(this);
        return items;
    }

    public String getPopname() {
        Trace.methodBegin(this, "getPopname");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getInstanceID() {
        Trace.methodBegin(this, "getInstanceID");
        return this.instanceID;
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.instance;
    }

    private void getAssociatedStorageCapabilities() throws ConfigMgmtException {
        String METHOD = "getAssociatedStorageCapabilities";
        Trace.methodBegin(this, "getAssociatedStorageCapabilities");
        if (this.capObjectPath != null && this.profileName != null) {
            Trace.verbose((Object)this, "getAssociatedStorageCapabilities", "Associated Storage Capacilities already loaded.");
            return;
        }
        try {
            Trace.verbose((Object)this, "getAssociatedStorageCapabilities", "Querying CIM for associated StorageCapabilities.");
            Enumeration enumeration = this.handle.associators(this.objectPath, "SunStorEdge_DSPElementCapabilities", "SunStorEdge_DSPStorageCapabilities", "ManagedElement", "Capabilities", true, false, ConstantsEnt.StorageCapabilitiesProperties.PROP_LIST);
            Trace.verbose((Object)this, "getAssociatedStorageCapabilities", "Returned from querying CIM for associated StorageCapabilities.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getAssociatedStorageCapabilities", "StorageCapabilities Instance Found.");
                while (enumeration.hasMoreElements()) {
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    this.capObjectPath = ci.getObjectPath();
                }
            } else {
                Trace.verbose((Object)this, "getAssociatedStorageCapabilities", "No StorageCapabilities Found");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedStorageCapabilities", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssociatedStorageCapabilities", "NullPointerException - Null returned when trying to obtain associated StorageCapabilities: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting associated StorageCapabilities.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssociatedStorageCapabilities", "Exception - Exception thrown when trying to obtain associated StorageCapabilities: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting associated StorageCapabilities.", e);
        }
    }

    private void getAssociatedDomain() throws ConfigMgmtException {
        String METHOD = "getAssociatedDomain()";
        Trace.methodBegin(this, "getAssociatedDomain()");
        if (this.domainObjectPath != null && this.domainName != null) {
            Trace.verbose((Object)this, "getAssociatedDomain()", "Already retrieved domain object path.");
            return;
        }
        try {
            if ((this.domainName == null || this.domainName.length() == 0) && this.domainObjectPath != null) {
                Trace.verbose((Object)this, "getAssociatedDomain()", "Getting domain name from existing object path.");
                CIMInstance domainInst = this.handle.getInstance(this.domainObjectPath, false, true, false, ConstantsEnt.SDProperties.SD_PROP_LIST);
                CIMProperty cp = domainInst.getProperty("ElementName");
                this.domainName = (String)cp.getValue().getValue();
                Trace.verbose((Object)this, "getAssociatedDomain()", "Reloaded domainName as: " + this.domainName);
                return;
            }
            Trace.verbose((Object)this, "getAssociatedDomain()", "Querying CIM for associated StorageDomain.");
            Enumeration enumeration = this.handle.associators(this.objectPath, "SunStorEdge_DSPHostedStoragePool", "SunStorEdge_DSPStorageDomain", "PartComponent", "GroupComponent", true, false, ConstantsEnt.SDProperties.SD_PROP_LIST);
            Trace.verbose((Object)this, "getAssociatedDomain()", "Returned from querying CIM for associated StorageDomain.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getAssociatedDomain()", "StorageDomain Instance Found.");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                this.domainObjectPath = ci.getObjectPath();
                ManageStorageDomains mgmtDomain = new ManageStorageDomains();
                mgmtDomain.init(this.context, null);
                this.domain = mgmtDomain.loadSDProperties(ci);
                this.domainName = this.domain.getName();
            } else {
                Trace.verbose((Object)this, "getAssociatedDomain()", "No StorageDomain Found");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedDomain()", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssociatedDomain()", "NullPointerException - Null returned when trying to obtain associated StorageDomain name: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting associated StorageDomain name.", npe);
        }
    }

    private StorageProfile getStorageWithHints() throws ConfigMgmtException {
        block5: {
            String METHOD = "getStorageWithHints";
            Trace.methodBegin(this, "getStorageWithHints");
            if (this.profile != null) {
                return this.profile;
            }
            try {
                Trace.verbose((Object)this, "getStorageWithHints", "Querying CIM for associated StorageWithHints.");
                Enumeration enumeration = this.handle.associators(this.objectPath, "SunStorEdge_DSPElementSettingData", "SunStorEdge_StorageSettingWithHints", "ManagedElement", "SettingData", true, false, null);
                Trace.verbose((Object)this, "getStorageWithHints", "Returned from querying CIM for associated StorageWithHints.");
                if (enumeration != null && enumeration.hasMoreElements()) {
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    if (ci != null) {
                        Trace.verbose((Object)this, "getStorageWithHints", "Creating StorageProfile Java object");
                        ManageStorageProfiles mgmtProfile = new ManageStorageProfiles();
                        mgmtProfile.init(this.context, null);
                        this.profile = (StorageProfile)mgmtProfile.getChildClassInstance();
                        this.profile.setInstance(ci);
                        this.profile.init(this.context);
                        CIMObjectWrapper.populate(this.profile, this.profile.getFieldMap(), ci);
                        this.profile.loadKeys();
                        this.profileName = this.profile.getName();
                    }
                    break block5;
                }
                Trace.error((Object)this, "getByKey", "Key object is null.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Key object is null.");
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getStorageWithHints", "Failed: " + cme);
                throw cme;
            }
        }
        Trace.methodEnd(this, "getStorageWithHints");
        return this.profile;
    }

    public void setName(String name) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "setName");
        Trace.verbose((Object)this, "setName", "Validating name: " + name);
        ManageStoragePools msp = new ManageStoragePools();
        msp.init(this.context, null);
        msp.validateNameChange(this);
        try {
            msp.validateName(name, this.getStorageDomainName());
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "setName", "StorageDomain:" + this.getStorageDomainName() + " not found.");
            throw new ConfigMgmtException("error.systemError", "StorageDomain: " + this.getStorageDomainName() + " not found.", infe);
        }
        Trace.verbose((Object)this, "setName", "Name Successfully Validated, Setting Name...");
        this.name = name;
    }

    public void setDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "setDescription");
        Trace.verbose((Object)this, "setName", "Validating description: " + this.name);
        ManageStoragePools msp = new ManageStoragePools();
        msp.validateDescription(description);
        Trace.verbose((Object)this, "setName", "Description Successfully Validated, Setting Description...");
        this.description = description;
    }

    public void setPopname(String popname) {
        Trace.methodBegin(this, "setPopname");
        this.name = popname;
    }

    public void setInstanceID(String instanceID) {
        Trace.methodBegin(this, "setInstanceID");
        this.instanceID = instanceID;
    }

    public void setInstance(CIMInstance instance) {
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
        if (this.objectPath == null) {
            Trace.verbose((Object)this, "setInstance", "setting object path");
            this.objectPath = instance.getObjectPath();
        }
    }

    public void setTotalCapacity(BigInteger totalCapacity) {
        Trace.methodBegin(this, "setTotalCapacity");
        this.totalCapacity = totalCapacity;
    }

    public void setUnallocatedCapacity(BigInteger unallocatedCapacity) {
        Trace.methodBegin(this, "setUnallocatedCapacity");
        this.unallocatedCapacity = unallocatedCapacity;
    }

    public void setKey(Collection props) {
        Trace.methodBegin(this, "setKey");
        this.keyProperties = props;
    }

    public Collection getFieldMap() throws ConfigMgmtException {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("popname", "ElementName", false, false));
            this.fieldMap.add(new MapElement("description", "Description", false, true));
            this.fieldMap.add(new MapElement("totalCapacity", "TotalManagedSpace", true, false));
            this.fieldMap.add(new MapElement("unallocatedCapacity", "RemainingManagedSpace", true, false));
            this.fieldMap.add(new MapElement("instanceID", "InstanceID", true, false));
        }
        return this.fieldMap;
    }

    public MethodCallStatus addStorageToPool(String wwn) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = "addStorageToPool(String)";
        Trace.methodBegin(this, "addStorageToPool(String)");
        MethodCallStatus callStatus = new MethodCallStatus();
        try {
            Vector<String> disks = new Vector<String>();
            Trace.verbose((Object)this, "addStorageToPool(String)", "Obtaining the correct disk to add to this StoragePool.");
            ManageVDisks mvd = new ManageVDisks();
            mvd.init(this.context, null);
            VDisk disk = (VDisk)mvd.getItemByWwn(wwn);
            if (disk == null) {
                Trace.error((Object)this, "addStorageToPool(String)", "No storage matching wwn: " + wwn + " was found.");
                throw new ItemNotFoundException(wwn);
            }
            disks.add(disk.getInstance().getObjectPath().toString());
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue(null)), new CIMArgument("Goal", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("InPools", new CIMValue(null)), new CIMArgument("InExtents", new CIMValue(disks, new CIMDataType(22))), new CIMArgument("Pool", new CIMValue((Object)this.getInstance().getObjectPath()))};
            CIMArgument[] outArgs = this.buildOutArgsForAddStorage();
            if (this.domainObjectPath == null) {
                Trace.verbose((Object)this, "addStorageToPool(String)", "Need to load the associated storage domain.");
                this.getAssociatedDomain();
            }
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, this.getStorageDomainName(), 0);
            Trace.verbose((Object)this, "addStorageToPool(String)", "Configuration service object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "addStorageToPool(String)", "Trying to add :  " + wwn + " to this StoragePool.");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyStoragePool", inArgs, outArgs);
            int retVal = (Integer)returnCodeValue.getValue();
            Trace.verbose((Object)this, "addStorageToPool(String)", "Returned from trying to add storage to this StoragePool with return code: " + retVal);
            callStatus.setReturnCode(retVal);
            return callStatus;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "addStorageToPool(String)", "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "addStorageToPool(String)", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "addStorageToPool(String)", "NullPointerException - Null returned when trying to add storage to this StoragePool instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems adding storage to this StoragePool instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "addStorageToPool(String)", "Exception - Exception thrown when trying to add storage to this StoragePool: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems adding storage to this StoragePool.", e);
        }
    }

    public MethodCallStatus addStorageToPool(List raidSetGroups, int numDisks) throws ConfigMgmtException {
        String METHOD = "addStorageToPool(List)";
        Trace.methodBegin(this, "addStorageToPool(List)");
        CIMObjectPath setting = this.getNewSetting(numDisks);
        CIMArgument[] inArgs = this.buildInArgsForAddStorage(setting, raidSetGroups, null);
        return this.makeCallToAddStorage(inArgs);
    }

    public MethodCallStatus addStorageToPool(BigInteger storageAmount, int numDisks) throws ConfigMgmtException {
        String METHOD = "addStorageToPool(BigInteger)";
        Trace.methodBegin(this, "addStorageToPool(BigInteger)");
        CIMObjectPath setting = this.getNewSetting(numDisks);
        CIMArgument[] inArgs = this.buildInArgsForAddStorage(setting, null, storageAmount);
        return this.makeCallToAddStorage(inArgs);
    }

    public List findVDisksForStealing(boolean requireSameDomain) throws ConfigMgmtException {
        String METHOD = "findVDisksForStealing";
        Trace.methodBegin(this, "findVDisksForStealing");
        ArrayList<VDisk> canBeStolen = new ArrayList<VDisk>();
        ManageStorageProfiles profileMgr = new ManageStorageProfiles();
        profileMgr.init(this.context, null);
        StorageProfileInterface myProfile = profileMgr.getItemByName(this.getProfileName());
        if (myProfile == null) {
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "findVDisksForStealing", "Unable to find profile for pool: " + this.getName());
            }
            return canBeStolen;
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "findVDisksForStealing", "Found myProfile: " + myProfile.getName());
        }
        ManageStoragePools msp = new ManageStoragePools();
        msp.init(this.context, null);
        ManageVDisks mvds = new ManageVDisks();
        mvds.init(this.context, null);
        ArrayList availLuns = mvds.getItemsBySystem();
        for (int i_lun = 0; availLuns != null && i_lun < availLuns.size(); ++i_lun) {
            VDisk vdisk = (VDisk)availLuns.get(i_lun);
            if ("".equals(vdisk.getStoragePoolName())) {
                Trace.verbose((Object)this, "findVDisksForStealing", "found LUN with no pool, automatic candidate");
                canBeStolen.add(vdisk);
                continue;
            }
            try {
                ArrayList vols;
                StoragePoolInterface curPool = msp.getItemByName(vdisk.getStoragePoolName(), vdisk.getStorageDomainName());
                if (this.getName().equals(curPool.getName()) && this.getStorageDomainName().equals(curPool.getStorageDomainName())) {
                    Trace.verbose((Object)this, "findVDisksForStealing", "skipping myself");
                    continue;
                }
                if (requireSameDomain && !this.getStorageDomainName().equals(curPool.getStorageDomainName())) {
                    Trace.verbose((Object)this, "findVDisksForStealing", "skipping pool in different domain per request");
                    continue;
                }
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "findVDisksForStealing", "analyzing pool with name: " + curPool.getName() + " and profile name: " + curPool.getProfileName());
                }
                StorageProfileInterface curProfile = profileMgr.getItemByName(curPool.getProfileName());
                if (!vdisk.isExternal() && (curProfile == null || !ManageStoragePools.areProfilesCompatible(curProfile, myProfile))) continue;
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "findVDisksForStealing", "Found compatible profiles: " + curProfile.getName() + " and " + myProfile.getName());
                }
                if ((vols = vdisk.getAssociatedVolumes()) != null && vols.size() != 0) continue;
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "findVDisksForStealing", " will add Visk to list: " + vdisk.getWWN());
                }
                canBeStolen.add(vdisk);
                continue;
            }
            catch (ItemNotFoundException infe) {
                Trace.error((Object)this, "findVDisksForStealing", "Unable to find StoragePool for Vdisk with pool name: " + vdisk.getStoragePoolName() + " and domain name: " + vdisk.getStorageDomainName());
            }
        }
        return canBeStolen;
    }

    private MethodCallStatus makeCallToAddStorage(CIMArgument[] inArgs) throws ConfigMgmtException {
        String METHOD = "makeCallToAddStorage(CIMArgument[])";
        Trace.methodBegin(this, "makeCallToAddStorage(CIMArgument[])");
        CIMArgument[] outArgs = this.buildOutArgsForAddStorage();
        MethodCallStatus methodCallStatus = null;
        if (this.domainObjectPath == null) {
            Trace.verbose((Object)this, "makeCallToAddStorage(CIMArgument[])", "Need to load the associated storage domain.");
            this.getAssociatedDomain();
        }
        CIMObjectPath storageConfigServiceObjPath = ServiceFinder.getService(this.handle, this.getStorageDomainName(), 0);
        Trace.verbose((Object)this, "makeCallToAddStorage(CIMArgument[])", "invoking method.");
        CIMValue returnCodeValue = this.handle.invokeMethod(storageConfigServiceObjPath, "CreateOrModifyStoragePool", inArgs, outArgs);
        int cimReturnCode = ((UnsignedInt32)returnCodeValue.getValue()).intValue();
        Trace.verbose((Object)this, "makeCallToAddStorage(CIMArgument[])", "Extrinsic method return code: " + cimReturnCode);
        if (cimReturnCode == 4096) {
            Trace.verbose((Object)this, "makeCallToAddStorage(CIMArgument[])", "Job created from CIM Extrinsic call.");
            CIMObjectPath jobPath = null;
            for (int i = 0; jobPath == null && i < outArgs.length; ++i) {
                if (!outArgs[i].getName().equalsIgnoreCase("Job") || outArgs[i].getValue() == null) continue;
                jobPath = (CIMObjectPath)outArgs[i].getValue().getValue();
            }
            if (jobPath == null) {
                String msg = "Extrinsic method reported job should be present, but none could be found.";
                Trace.error((Object)this, "makeCallToAddStorage(CIMArgument[])", msg);
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", msg);
            }
            JobManagerInterface jobMgr = JobManagerFactory.create();
            jobMgr.init(this.context, null);
            ArrayList<JobInterface> jobs = new ArrayList<JobInterface>();
            jobs.add(jobMgr.get(jobPath, null));
            methodCallStatus = new MethodCallStatus(cimReturnCode, jobs);
        } else {
            methodCallStatus = new MethodCallStatus(cimReturnCode, new ArrayList());
        }
        return methodCallStatus;
    }

    private CIMObjectPath getNewSetting(int numDisks) throws ConfigMgmtException {
        String METHOD = "getNewSetting(int)";
        Trace.methodBegin(this, "getNewSetting(int)");
        if (this.capObjectPath == null) {
            Trace.verbose((Object)this, "getNewSetting(int)", "StorageCap not yet loaded.");
            this.getAssociatedStorageCapabilities();
        }
        CIMArgument[] createSettingOutArgs = new CIMArgument[1];
        CIMArgument[] createSettingInArgs = new CIMArgument[]{new CIMArgument("SettingType", new CIMValue((Object)new UnsignedInt16(2)))};
        Trace.verbose((Object)this, "getNewSetting(int)", "Calling CreateSetting");
        CIMValue settingCodeValue = this.handle.invokeMethod(this.capObjectPath, "CreateSetting", createSettingInArgs, createSettingOutArgs);
        CIMObjectPath settingPath = null;
        if (createSettingOutArgs[0] != null && createSettingOutArgs[0].getValue() != null && createSettingOutArgs[0].getValue().getValue() != null) {
            settingPath = (CIMObjectPath)createSettingOutArgs[0].getValue().getValue();
        }
        if (settingPath == null) {
            String msg = "Unable to create new setting for adding storage to pool.";
            Trace.error((Object)this, "getNewSetting(int)", msg);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", msg);
        }
        CIMInstance setting = this.handle.getInstance(settingPath, false, true, true);
        Trace.verbose((Object)this, "getNewSetting(int)", "Have original setting instance: " + setting);
        try {
            setting.setProperty("NumberOfDisks", new CIMValue((Object)new UnsignedInt16(numDisks)));
        }
        catch (CIMException ce) {
            Trace.verbose((Object)this, "getNewSetting", "Set Property Failed.");
            throw new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "Set Property Failed.", (Exception)((Object)ce));
        }
        Trace.verbose((Object)this, "getNewSetting(int)", "Changing number of disks in goal to: " + numDisks);
        this.handle.setInstance(settingPath, setting);
        Trace.verbose((Object)this, "getNewSetting(int)", "Returning with path: " + settingPath);
        return settingPath;
    }

    private CIMArgument[] buildInArgsForAddStorage(CIMObjectPath storageSettingOP, List raidSetGroups, BigInteger requestedSize) {
        String METHOD = "buildInArgsForAddStorage";
        Trace.methodBegin(this, "buildInArgsForAddStorage");
        boolean useSize = false;
        if (raidSetGroups == null || raidSetGroups.size() == 0) {
            useSize = true;
            Trace.verbose((Object)this, "buildInArgsForAddStorage", "will create args for size not extents.");
        }
        int cnt = 0;
        CIMArgument[] cimInArguments = new CIMArgument[6];
        CIMArgument ca = new CIMArgument("InstanceName", new CIMValue(null));
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("Goal", new CIMValue((Object)storageSettingOP));
        cimInArguments[cnt++] = ca;
        ca = useSize ? new CIMArgument("Size", new CIMValue((Object)new UnsignedInt64(requestedSize))) : new CIMArgument("Size", new CIMValue(null));
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("InPool", new CIMValue(null));
        cimInArguments[cnt++] = ca;
        if (!useSize) {
            Vector<String> v = new Vector<String>();
            int rsSize = raidSetGroups.size();
            for (int j = 0; j < rsSize; ++j) {
                RaidSetGroup rsg = (RaidSetGroup)raidSetGroups.get(j);
                List breakdowns = rsg.getBreakdowns();
                int bdSize = breakdowns.size();
                for (int k = 0; k < bdSize; ++k) {
                    RaidSetGroup.RaidSetBreakdown bd = (RaidSetGroup.RaidSetBreakdown)breakdowns.get(k);
                    List disks = bd.getBreakdown().getDisksForPool(bd.getIndex());
                    int disksSize = disks.size();
                    for (int l = 0; l < disksSize; ++l) {
                        v.add(((DiskInterface)disks.get(l)).getStorageExtentObjectPath().toString());
                    }
                }
            }
            ca = new CIMArgument("InExtents", new CIMValue(v, new CIMDataType(22)));
        } else {
            ca = new CIMArgument("InExtents", new CIMValue(null));
        }
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("Pool", new CIMValue((Object)this.objectPath));
        cimInArguments[cnt++] = ca;
        if (Trace.isTraceEnabled(this)) {
            for (int i = 0; i < cimInArguments.length; ++i) {
                if (cimInArguments[i] != null) {
                    CIMValue val = cimInArguments[i].getValue();
                    if (val != null) {
                        Trace.verbose((Object)this, "buildInArgsForAddStorage", "index: " + i + " have value: " + val.getValue());
                        continue;
                    }
                    Trace.verbose((Object)this, "buildInArgsForAddStorage", "index: " + i + " have null CIMValue");
                    continue;
                }
                Trace.verbose((Object)this, "buildInArgsForAddStorage", "index: " + i + " is null.");
            }
        }
        return cimInArguments;
    }

    private CIMArgument[] buildOutArgsForAddStorage() {
        CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("Pool", new CIMValue(null))};
        return outArgs;
    }

    public void loadKeys() {
        Trace.methodBegin(this, "loadKeys");
        ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
        prop.add(new CIMProperty("InstanceID", new CIMValue((Object)this.getInstanceID())));
        this.setKey(prop);
    }

    public String toString() {
        if (Trace.isTraceEnabled(this)) {
            return "\nStoragePool with:\n \tCIMObjectPath: " + this.objectPath + "\n \tname: " + this.getName() + "\n\tkey(s): " + this.getInstanceID() + "\n \tdescription: " + this.getDescription() + "\n \tprofile name: " + this.getProfileName() + "\n\tdomain name: " + this.getStorageDomainName() + "\n \ttotal capacity: " + this.getStorageCapacity().toString() + "\n\tallocated capacity: " + this.getAllocatedCapacity().toString() + "\n\tunallocated capacity: " + this.getUnAllocatedCapacity().toString();
        }
        return "";
    }

    public boolean isDeletable() {
        Trace.methodBegin(this, "isDeletable");
        this.deletable = !StoragePool.isProtectedName(this.name);
        return this.deletable;
    }

    public StorageProfile getStorageProfile() {
        String METHOD = "getProfile";
        Trace.methodBegin(this, "getProfile");
        if (this.profile == null) {
            try {
                this.getStorageWithHints();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getProfile", "Error retrieving StorageProfile: " + cme);
                this.profile = null;
            }
        }
        Trace.methodEnd(this, "getProfile");
        return this.profile;
    }

    static boolean isProtectedName(String name) {
        return "Default".equalsIgnoreCase(name) || "Legacy".equalsIgnoreCase(name);
    }
}

