/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1.Initiator;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1.ManageInitiators;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.TooManyCIMInstanceException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageDomains;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class StorageDomain
implements StorageDomainInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private CIMInstance sdCimInstance;
    private CIMObjectPath sdCimObjPath;
    private String systemName;
    private String creationClzName;
    private Collection keyProperties;
    private String name;
    private String description;
    private BigInteger storageCapacity = BigInteger.ZERO;
    private BigInteger allocatedCapacity = BigInteger.ZERO;
    private BigInteger unallocatedCapacity = BigInteger.ZERO;
    private boolean deletable = true;

    public StorageDomain() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        Trace.verbose((Object)this, "save", "Storage Domain properties are now being saved....");
        try {
            this.sdCimInstance.setProperty("Description", new CIMValue((Object)this.description));
        }
        catch (CIMException ce) {
            Trace.error((Object)this, "save", "Set Property Failed.");
            throw new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "Set Property Failed.", (Exception)((Object)ce));
        }
        this.sdCimObjPath = this.sdCimInstance.getObjectPath();
        this.handle.setInstance(this.sdCimObjPath, this.sdCimInstance);
        Trace.verbose((Object)this, "save", "Storage Domain properties saved");
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        Trace.verbose((Object)this, "reload", "Resetting instance variables to initial state!!");
        this.name = null;
        this.description = null;
        this.storageCapacity = BigInteger.ZERO;
        this.allocatedCapacity = BigInteger.ZERO;
        this.unallocatedCapacity = BigInteger.ZERO;
        this.deletable = true;
    }

    public ConfigContext getConfigContext() {
        Trace.methodBegin(this, "getConfigContext");
        return this.context;
    }

    public String getName() {
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getDescription() {
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public BigInteger getStorageCapacity() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getStorageCapacity");
        this.storageCapacity = BigInteger.ZERO;
        List list = this.getAssocPools();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            StoragePool pool = (StoragePool)it.next();
            BigInteger val = pool.getStorageCapacity();
            this.storageCapacity = this.storageCapacity.add(val);
        }
        Trace.verbose((Object)this, "getStorageCapacity", "value: " + this.storageCapacity);
        return this.storageCapacity;
    }

    public BigInteger getAllocatedCapacity() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getAllocatedCapacity");
        this.allocatedCapacity = BigInteger.ZERO;
        List list = this.getAssocPools();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            StoragePool pool = (StoragePool)it.next();
            BigInteger val = pool.getAllocatedCapacity();
            this.allocatedCapacity = this.allocatedCapacity.add(val);
        }
        Trace.verbose((Object)this, "getAllocatedCapacity", "value: " + this.allocatedCapacity);
        return this.allocatedCapacity;
    }

    public BigInteger getUnAllocatedCapacity() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getUnAllocatedCapacity");
        this.unallocatedCapacity = BigInteger.ZERO;
        BigInteger totalCap = this.getStorageCapacity();
        BigInteger allocCap = this.getAllocatedCapacity();
        this.unallocatedCapacity = totalCap.subtract(allocCap);
        Trace.verbose((Object)this, "getUnAllocatedCapacity", "value: " + this.unallocatedCapacity);
        return this.unallocatedCapacity;
    }

    public boolean isDeletable() {
        Trace.methodBegin(this, "isDeletable");
        boolean bHasAssocPools = false;
        List assocPools = null;
        try {
            assocPools = this.getAssocPools();
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "isDeletable(): getAssocPools)", "Failed: " + cme.getMessage());
        }
        if (assocPools != null && assocPools.size() > 0) {
            bHasAssocPools = true;
        }
        if (this.name.equals("DEFAULT") || this.name.equals("INTERNAL") || bHasAssocPools) {
            this.deletable = false;
        }
        return this.deletable;
    }

    public List getAssocPools() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocPools");
        ManageStoragePools mgmtPool = new ManageStoragePools();
        mgmtPool.init(this.context, null);
        List<Object> list = new ArrayList();
        try {
            list = mgmtPool.getItemsByStorageDomain(this.name);
        }
        catch (ItemNotFoundException itex) {
            Trace.error((Object)this, "getAssocPools", itex.getMessage());
            list = Arrays.asList(new Object[1]);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssocPools", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssocPools", "NullPointerException - Null returned when trying to get associated StoragePools: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting associated StoragePools.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssocPools", "Exception - Exception thrown when trying to get associated StoragePools: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting associated StoragePools.", e);
        }
        return list;
    }

    public List getAssocVDisks() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocVDisks");
        ManageStoragePools mgmtPool = new ManageStoragePools();
        mgmtPool.init(this.context, null);
        List<Object> list = new ArrayList();
        ArrayList vdisks = new ArrayList();
        try {
            list = mgmtPool.getItemsByStorageDomain(this.name);
            if (list.size() != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    StoragePool pool = (StoragePool)list.get(i);
                    if (Trace.isTraceEnabled(this)) {
                        Trace.verbose((Object)this, "getAssocVDisks", "Getting VDisks in StoragePool: " + pool.getName());
                    }
                    vdisks.addAll(pool.getAssociatedVDisks());
                }
            } else {
                Trace.verbose((Object)this, "getAssocVDisks", "No StoragePools found");
            }
        }
        catch (ItemNotFoundException itex) {
            Trace.error((Object)this, "getAssocVDisks", itex.getMessage());
            list = Arrays.asList(new Object[1]);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssocVDisks", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssocVDisks", "NullPointerException - Null returned when trying to get associated VDisks: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting associated VDisks.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssocVDisks", "Exception - Exception thrown when trying to get associated VDisks: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting associated VDisks.", e);
        }
        return vdisks;
    }

    public List getAssocVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocVolumes");
        ManageStorageVolumes mgmtVol = new ManageStorageVolumes();
        mgmtVol.init(this.context, null);
        List<Object> list = new ArrayList();
        try {
            list = mgmtVol.getItemsByStorageDomain(this.name);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssocVolumes", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (ItemNotFoundException itex) {
            Trace.error((Object)this, "getAssocVolumes", itex.getMessage());
            list = Arrays.asList(new Object[1]);
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssocVolumes", "NullPointerException - Null returned when trying to get associated StorageVolumes: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting associated StorageVolumes.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssocVolumes", "Exception - Exception thrown when trying to get associated StorageVolumes: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting associated StorageVolumes.", e);
        }
        return list;
    }

    public List getAssocVolumeGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocVolumeGroups");
        return Arrays.asList(new Object[0]);
    }

    public List getAssocArrays() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocArrays");
        return Arrays.asList(new Object[0]);
    }

    public Collection getKeys() {
        Trace.methodBegin(this, "getKeys");
        return this.keyProperties;
    }

    public void setDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "setDescription");
        Trace.verbose((Object)this, "setDescription", "Validating description: " + description);
        ManageStorageDomains msd = new ManageStorageDomains();
        msd.validateDescription(description);
        Trace.verbose((Object)this, "setDescription", "Description: " + description + " validated, setting...");
        this.description = description;
    }

    public MethodCallStatus addInitiators(Collection initiators) throws ConfigMgmtException {
        Trace.methodBegin(this, "addInitiators");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Vector<String> initObjPath = new Vector<String>();
            int i = 0;
            Iterator it = initiators.iterator();
            while (it.hasNext()) {
                Initiator ini = (Initiator)it.next();
                initObjPath.add(ini.getInstance().getObjectPath().toString());
                ++i;
            }
            CIMObjectPath dspDomainInitiatorCollection = this.getDSPDomainInitiatorCollection();
            CIMArgument[] cimInArguments = new CIMArgument[]{new CIMArgument("HardwareIDs", new CIMValue(initObjPath, new CIMDataType(22))), new CIMArgument("Collection", new CIMValue((Object)dspDomainInitiatorCollection))};
            Trace.verbose((Object)this, "addInitiators", "Getting StorageHardwareIDManagementService");
            CIMObjectPath storageHardwareIDManagementServiceObjPath = ServiceFinder.getService(this.handle, this.getName(), 3);
            Trace.verbose((Object)this, "addInitiators", "Calling AddHardwareIDsToCollection");
            CIMValue returnCodeValue = this.handle.invokeMethod(storageHardwareIDManagementServiceObjPath, "AddHardwareIDsToCollection", cimInArguments, null);
            int retVal = (Integer)returnCodeValue.getValue();
            Trace.verbose((Object)this, "addInitiators", "Returned from calling AddHardwareIDsToCollection with return code: " + retVal);
            methodCallStatus.setReturnCode(retVal);
            return methodCallStatus;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "addInitiators", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "addInitiators", "NullPointerException - Null returned when trying to add Initiator to StorageDomain: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems adding Initiator to StorageDomain.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "addInitiators", "Exception - Exception thrown when trying to add Initiator to StorageDomain: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems adding Initiator to StorageDomain.", e);
        }
    }

    public List getAssocInitiators() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocInitiators");
        ArrayList l = Arrays.asList(new Object[0]);
        try {
            ManageInitiators manager = new ManageInitiators();
            manager.init(this.context, null);
            l = manager.getItemsByStorageDomain(this.name);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getAssocInitiators", "ItemNotFound: " + infe.getMessage());
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ItemNotFoundException - Could not find StorageDomain.", infe);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssocInitiators", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssocInitiators", "NullPointerException - Null returned when trying to get associated Initiators: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting associated Initiators.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssocInitiators", "Exception - Exception thrown when trying to get associated Initiators: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting associated Initiators.", e);
        }
        return l;
    }

    public CIMInstance getCIMInstance() {
        Trace.methodBegin(this, "getCIMInstance");
        return this.sdCimInstance;
    }

    protected String getSystemName() {
        Trace.methodBegin(this, "getSystemName");
        return this.systemName;
    }

    protected String getCreationClzName() {
        Trace.methodBegin(this, "getCreationClzName");
        return this.creationClzName;
    }

    protected void setCIMInstance(CIMInstance sdCimInstance) {
        Trace.methodBegin(this, "setCIMInstance");
        this.sdCimInstance = sdCimInstance;
        this.sdCimObjPath = sdCimInstance.getObjectPath();
    }

    public void setName(String name) {
        Trace.methodBegin(this, "setName");
        this.name = name;
    }

    public void setSystemName(String systemName) {
        Trace.methodBegin(this, "setSystemName");
        this.systemName = systemName;
    }

    public void setCreationClzName(String crtClzName) {
        Trace.methodBegin(this, "setCreationClzName");
        this.creationClzName = crtClzName;
    }

    protected void setKey(Collection keyProperties) {
        Trace.methodBegin(this, "setKey");
        this.keyProperties = keyProperties;
    }

    private CIMObjectPath getDSPDomainInitiatorCollection() throws ConfigMgmtException {
        Trace.methodBegin(this, "getDomainInitiatorCollection");
        CIMObjectPath dspDomainInitiatorCollectionObjPath = null;
        try {
            Trace.verbose((Object)this, "getDomainInitiatorCollection", "walking the association to from StorageDomain to DSPDomainInitiatorCollection");
            Enumeration enumInitiatorCollection = this.handle.associatorNames(this.sdCimObjPath, "SunStorEdge_DSPHostedCollection", "SunStorEdge_DSPDomainInitiatorCollection", "Antecedent", "Dependent");
            Trace.verbose((Object)this, "getDomainInitiatorCollection", "enumInitiatorCollection is null? " + (enumInitiatorCollection == null));
            int initiatorCollectionCount = 0;
            while (enumInitiatorCollection.hasMoreElements()) {
                Trace.verbose((Object)this, "getDomainInitiatorCollection", "inside enumStorHardwareServ element number " + initiatorCollectionCount + " in enumeration!!");
                if (initiatorCollectionCount > 0) {
                    Trace.error((Object)this, "getDomainInitiatorCollection", "More than 1 instance of DSPDomainInitiatorCollection object exists from StorageDomain!");
                    throw new TooManyCIMInstanceException("TOOMANY_CIM_INSTANCE_RETURNED", "More than 1 instance of DSPDomainInitiatorCollection object returned from StorageDomain.");
                }
                dspDomainInitiatorCollectionObjPath = (CIMObjectPath)enumInitiatorCollection.nextElement();
                ++initiatorCollectionCount;
            }
            if (initiatorCollectionCount == 0) {
                Trace.error((Object)this, "getDomainInitiatorCollection", "Zero StorageConfiguationService CIM object found from association call!");
                throw new ZeroCIMInstanceReturnedException("ZERO_CIM_INSTANCE_RETURNED", "Zero DSPDomainInitiatorCollection CIMInstance found from StorageDomain");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getDomainInitiatorCollection", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getDomainInitiatorCollection", "NullPointerException - Null returned when trying to get DomainInitiatorCollection: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting DomainInitiatorCollection.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getDomainInitiatorCollection", "Exception - Exception thrown when trying to get DomainInitiatorCollection: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting DomainInitiatorCollection.", e);
        }
        return dspDomainInitiatorCollectionObjPath;
    }
}

