/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageDomains;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageDomain;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageRaidGroups;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageT4s;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageTrays;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class ManageVDisks
implements ManageVDisksEnt1Interface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    public static int IGNORE_DIGITS = 8;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    private ArrayList objectsToList(Vector list, boolean isExt) throws ConfigMgmtException {
        String METHOD = "objectsToList";
        Trace.methodBegin(this, "objectsToList");
        ArrayList<VDisk> objectsToList = new ArrayList<VDisk>();
        for (int i = 0; i < list.size(); ++i) {
            CIMInstance ci = (CIMInstance)list.get(i);
            CIMProperty cimProp = ci.getProperty("ExtentStatus");
            if (cimProp == null) {
                Trace.error((Object)this, "objectsToList", "Status property is null, invalid instance, skipping instance..");
                continue;
            }
            CIMValue cVal = cimProp.getValue();
            Vector vals = (Vector)cVal.getValue();
            if (vals == null || vals.size() <= 0) continue;
            UnsignedInt16 extStatus = (UnsignedInt16)vals.get(0);
            if ((isExt || extStatus.intValue() != 2) && !isExt && extStatus.intValue() != 3) continue;
            Trace.verbose((Object)this, "objectsToList", "Creating VDisk Java object.");
            VDisk vd = new VDisk();
            vd.setInstance(ci);
            vd.init(this.context);
            CIMObjectWrapper.populate(vd, vd.getFieldMap(), ci);
            vd.loadKeys();
            if (extStatus.intValue() == 3 && vd.getStoragePoolName().equals("")) {
                Trace.verbose((Object)this, "objectsToList", "VDisk is offline with no StoragePool, excluding...");
                continue;
            }
            objectsToList.add(vd);
            if (!Trace.isTraceEnabled(this)) continue;
            Trace.verbose((Object)this, "objectsToList", "The instance added to the list: " + vd);
        }
        return objectsToList;
    }

    public ArrayList getUnassignedVDisks() throws ConfigMgmtException {
        Trace.methodBegin(this, "getUnassignedVDisks");
        Vector<CIMInstance> filteredList = new Vector<CIMInstance>();
        ArrayList vdisks = new ArrayList();
        try {
            Trace.verbose((Object)this, "getUnassignedVDisks", "Querying CIM for StorageExtent Instances");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStorageExtent"), false, false, true, false, ConstantsEnt.StorageExtentProperties.PROP_LIST);
            Trace.verbose((Object)this, "getUnassignedVDisks", "Returned from querying CIM for StorageExtent Instances");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getUnassignedVDisks", "StorageExtent Instances Found");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getUnassignedVDisks", "Checking if VDisk is unassigned");
                    CIMInstance instance = (CIMInstance)enumeration.nextElement();
                    Trace.verbose((Object)this, "getUnassignedVDisks", "Querying CIM for StoragePool Instances");
                    Enumeration enum2 = this.handle.associators(instance.getObjectPath(), "SunStorEdge_DSPConcreteComponent", "SunStorEdge_DSPStoragePool", "PartComponent", "GroupComponent", true, false, ConstantsEnt.StoragePoolProperties.PROP_LIST);
                    Trace.verbose((Object)this, "getUnassignedVDisks", "Returned from querying CIM for StoragePool Instances");
                    if (enum2 != null && enum2.hasMoreElements()) continue;
                    Trace.verbose((Object)this, "getUnassignedVDisks", "StoragePool not found, VDisk unassigned");
                    filteredList.add(instance);
                }
            }
            vdisks = this.objectsToList(filteredList, false);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getUnassignedVDisks", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getUnassignedVDisks", "NullPointerException - Null returned when trying to obtain all the VDisk instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the VDisk instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getUnassignedVDisks", "Exception - Exception thrown when trying to obtain all the VDisk instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the VDisk instances.", e);
        }
        Trace.verbose((Object)this, "getUnassignedVDisks", "Returning Unassigned VDisks");
        return vdisks;
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        Vector<CIMInstance> allVDisks = new Vector<CIMInstance>();
        ArrayList vdisks = new ArrayList();
        try {
            Trace.verbose((Object)this, "getItemsBySystem", "Querying CIM for StorageExtent Instances");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStorageExtent"), false, false, true, false, ConstantsEnt.StorageExtentProperties.PROP_LIST);
            Trace.verbose((Object)this, "getItemsBySystem", "Returned from querying CIM for StorageExtent Instances");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemsBySystem", "StorageExtent Instances Found");
                while (enumeration.hasMoreElements()) {
                    CIMInstance instance = (CIMInstance)enumeration.nextElement();
                    allVDisks.add(instance);
                }
            }
            vdisks = this.objectsToList(allVDisks, false);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsBySystem", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsBySystem", "NullPointerException - Null returned when trying to obtain all the VDisk instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the VDisk instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsBySystem", "Exception - Exception thrown when trying to obtain all the VDisk instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the VDisk instances.", e);
        }
        Trace.verbose((Object)this, "getItemsBySystem", "Returning all VDisks");
        return vdisks;
    }

    public ArrayList getExternalItemsBySystem() throws ConfigMgmtException {
        String METHOD = new String("getExternalItemsBySystem");
        Trace.methodBegin(this, METHOD);
        Vector<CIMInstance> allVDisks = new Vector<CIMInstance>();
        ArrayList vdisks = new ArrayList();
        try {
            Trace.verbose((Object)this, METHOD, "ExternalCollection Instance");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPExternalCollection"), false, false, true, false, null);
            Trace.verbose((Object)this, METHOD, "Returned from querying CIM for ExternalCollection Instances");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, METHOD, "ExternalCollection Instance Found");
                while (enumeration.hasMoreElements()) {
                    CIMInstance instance = (CIMInstance)enumeration.nextElement();
                    Trace.verbose((Object)this, METHOD, "Querying CIM for associated VDisk Instances");
                    Enumeration enum2 = this.handle.associators(instance.getObjectPath(), "SunStorEdge_DSPExternalExtent", "SunStorEdge_DSPStorageExtent", "Collection", "Member", true, false, ConstantsEnt.StorageExtentProperties.PROP_LIST);
                    Trace.verbose((Object)this, METHOD, "Returned from querying CIM for VDisk Instances");
                    while (enum2.hasMoreElements()) {
                        instance = (CIMInstance)enum2.nextElement();
                        allVDisks.add(instance);
                    }
                }
            }
            vdisks = this.objectsToList(allVDisks, true);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to obtain external VDisk instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting external VDisk instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain external VDisk instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting external VDisk instances.", e);
        }
        return vdisks;
    }

    public ArrayList getItemsByStorageDomain(String domainName) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByStorageDomain");
        ArrayList vdisks = new ArrayList();
        try {
            ManageStorageDomains msd = new ManageStorageDomains();
            msd.init(this.context, null);
            Trace.verbose((Object)this, "getItemsByStorageDomain", "Getting StorageDomain: " + domainName);
            StorageDomain domain = new StorageDomain();
            try {
                domain = (StorageDomain)msd.getItemByName(domainName);
            }
            catch (ZeroCIMInstanceReturnedException zcir) {
                Trace.error((Object)this, "getItemsByStorageDomain", "StorageDomain: " + domainName + " not found.");
                throw new ItemNotFoundException(domainName);
            }
            Trace.verbose((Object)this, "getItemsByStorageDomain", "Getting associated VDisks");
            vdisks = new ArrayList(domain.getAssocVDisks());
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemsByStorageDomain", "StorageDomain not found: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsByStorageDomain", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsByStorageDomain", "NullPointerException - Null returned when trying to obtain all the VDisk instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the VDisk instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsByStorageDomain", "Exception - Exception thrown when trying to obtain all the VDisk instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the VDisk instances.", e);
        }
        return vdisks;
    }

    public ArrayList getItemsByStoragePool(String poolName, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByStoragePool");
        ArrayList vdisks = new ArrayList();
        try {
            ManageStoragePools msp = new ManageStoragePools();
            msp.init(this.context, null);
            Trace.verbose((Object)this, "getItemsByStoragePool", "Getting StoragePool: " + poolName);
            StoragePool pool = (StoragePool)msp.getItemByName(poolName, domainName);
            if (pool == null) {
                Trace.error((Object)this, "getItemsByStoragePool", "StoragePool: " + poolName + " not found");
                throw new ItemNotFoundException(poolName);
            }
            Trace.verbose((Object)this, "getItemsByStoragePool", "Getting associated VDisks");
            vdisks = pool.getAssociatedVDisks();
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemsByStoragePool", "StorageDomain or StoragePool not found: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsByStoragePool", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsByStoragePool", "NullPointerException - Null returned when trying to obtain all the VDisk instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the VDisk instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsByStoragePool", "Exception - Exception thrown when trying to obtain all the VDisk instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the VDisk instances.", e);
        }
        return vdisks;
    }

    public ArrayList getItemsByVolume(String name) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByVolume");
        ArrayList vdisks = new ArrayList();
        try {
            ManageStorageVolumes msv = new ManageStorageVolumes();
            msv.init(this.context, null);
            Trace.verbose((Object)this, "getItemsByVolume", "Getting StorageVolume: " + name);
            StorageVolume volume = (StorageVolume)msv.getItemByName(name);
            if (volume == null) {
                Trace.error((Object)this, "getItemsByVolume", "StorageVolume: " + name + " not found");
                throw new ItemNotFoundException(name);
            }
            Trace.verbose((Object)this, "getItemsByVolume", "Getting associated VDisks");
            vdisks = volume.getAssociatedVDisks();
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemsByVolume", "StorageVolume not found: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsByVolume", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsByVolume", "NullPointerException - Null returned when trying to obtain all the VDisk instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the VDisk instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsByVolume", "Exception - Exception thrown when trying to obtain all the VDisk instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the VDisk instances.", e);
        }
        return vdisks;
    }

    public VDiskInterface getItemByName(String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByName");
        VDisk vd = null;
        try {
            Trace.verbose((Object)this, "getItemByName", "Querying CIM for StorageExtent: " + name);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageExtent where ElementName = '" + name + "'");
            Trace.verbose((Object)this, "getItemByName", "Returned from querying CIM for StorageExtent Instance: " + name);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemByName", "StorageExtent Instance: " + name + " Found.");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemByName", "Creating VDisk Java Object.");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    vd = new VDisk();
                    vd.setInstance(ci);
                    vd.init(this.context);
                    CIMObjectWrapper.populate(vd, vd.getFieldMap(), ci);
                    vd.loadKeys();
                    Trace.verbose((Object)this, "getItemByName", "Finished creating VDisk Java Object.");
                }
            }
            if (vd == null) {
                Trace.verbose((Object)this, "getItemByName", "No instances returned when trying to obtain the VDisk: " + name);
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemByName", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemByName", "NullPointerException - Null returned when trying to obtain the VDisk instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the VDisk instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemByName", "Exception - Exception thrown when trying to obtain the VDisk instance: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the VDisk instance.", e);
        }
        return vd;
    }

    public VDiskInterface getItemByWwn(String wwn) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByWwn");
        VDisk vd = null;
        try {
            Trace.verbose((Object)this, "getItemByWwn", "Querying CIM for StorageExtent: " + wwn);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageExtent where DeviceID = '" + wwn + "'");
            Trace.verbose((Object)this, "getItemByWwn", "Returned from querying CIM for StorageExtent Instance: " + wwn);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemByWwn", "StorageExtent Instance: " + wwn + " Found.");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemByWwn", "Creating VDisk Java Object.");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    vd = new VDisk();
                    vd.setInstance(ci);
                    vd.init(this.context);
                    CIMObjectWrapper.populate(vd, vd.getFieldMap(), ci);
                    vd.loadKeys();
                    Trace.verbose((Object)this, "getItemByWwn", "Finished creating VDisk Java Object.");
                }
            }
            if (vd == null) {
                Trace.verbose((Object)this, "getItemByWwn", "No instances returned when trying to obtain the VDisk: " + wwn);
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemByWwn", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemByWwn", "NullPointerException - Null returned when trying to obtain the VDisk instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the VDisk instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemByWwn", "Exception - Exception thrown when trying to obtain the VDisk instance: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the VDisk instance.", e);
        }
        return vd;
    }

    public ArrayList getItemsByArray(String t4Name) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByArray");
        return this.getItemsByTray(t4Name, null);
    }

    public ArrayList getItemsByTray(String t4Name, String trayId) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByTray");
        ArrayList<VDiskInterface> vdisks = new ArrayList<VDiskInterface>();
        try {
            ManageT4s mt = new ManageT4s();
            mt.init(this.context, null);
            T4Interface t4 = mt.getT4ByName(t4Name);
            if (t4 == null) {
                Trace.error((Object)this, "getItemsByTray", "T4 " + t4Name + " not found.");
                throw new ItemNotFoundException(t4Name);
            }
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "getItemsByDisk", "T4 Name: " + t4.getName());
            }
            if (t4.getHealthStatus() == 2) {
                com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStorageVolumes mv = new com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStorageVolumes();
                mv.setScope(t4);
                mv.init(this.context, null);
                List list = mv.getItemList();
                int size = list.size();
                boolean found = false;
                for (int i = 0; i < size; ++i) {
                    StorageVolumeInterface sv = (StorageVolumeInterface)list.get(i);
                    if ((trayId == null || !sv.getTrayId().equals(trayId)) && trayId != null) continue;
                    found = true;
                    String devId = sv.getDeviceID();
                    String wwn = devId.substring(IGNORE_DIGITS);
                    VDiskInterface vdisk = this.getItemByWwn(wwn);
                    if (vdisk == null) continue;
                    vdisks.add(vdisk);
                }
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "getItemsByTray", "Total in Array: " + list.size());
                    Trace.verbose((Object)this, "getItemsByTray", "Total of vdisks found: " + vdisks.size());
                }
            } else if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "getItemsByTray", "Skipping unhealthy array: " + t4.getClusterName() + " with health code: " + t4.getHealthStatus());
            }
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemsByTray", "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsByTray", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsByTray", "NullPointerException - Null returned when trying to obtain the VDisk instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the VDisk instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsByTray", "Exception - Exception thrown when trying to obtain the VDisk instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the VDisk instances.", e);
        }
        return vdisks;
    }

    public ArrayList getItemsByDisk(String t4Name, String trayId, int diskId) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByDisk");
        ArrayList<VDiskInterface> vdisks = new ArrayList<VDiskInterface>();
        try {
            ManageT4s mt4 = new ManageT4s();
            mt4.init(this.context, null);
            T4Interface t4 = mt4.getT4ByName(t4Name);
            if (t4 == null) {
                Trace.error((Object)this, "getItemsByDisk", "T4: " + t4Name + " not found.");
                throw new ItemNotFoundException(t4Name);
            }
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "getItemsByDisk", "T4 Name: " + t4.getName());
            }
            if (t4.getHealthStatus() == 2) {
                if (trayId == null) {
                    Trace.error((Object)this, "getItemsByDisk", "TrayId is null.");
                    throw new ItemNotFoundException(trayId);
                }
                T4Interface scope = t4;
                ManageTrays mtr = new ManageTrays();
                mtr.setScope(scope);
                mtr.init(this.context, null);
                boolean found = false;
                List trays = mtr.getItemList();
                int size = trays.size();
                TrayInterface tray = null;
                for (int i = 0; i < size && !found; ++i) {
                    tray = (TrayInterface)trays.get(i);
                    if (!tray.getId().equals(trayId)) continue;
                    found = true;
                }
                if (!found) {
                    Trace.error((Object)this, "getItemsByDisk", "TrayId: " + trayId + " not found.");
                    throw new ItemNotFoundException(trayId);
                }
                scope = tray;
                ManageRaidGroups mr = new ManageRaidGroups();
                mr.setScope(scope);
                mr.init(this.context, null);
                List raidgrps = mr.getItemList();
                size = raidgrps.size();
                found = false;
                for (int i = 0; i < size; ++i) {
                    RaidGroupInterface raidgrp = (RaidGroupInterface)raidgrps.get(i);
                    if (diskId < raidgrp.getBeginDiskNumber() || diskId > raidgrp.getEndDiskNumber()) continue;
                    found = true;
                    List volumes = raidgrp.getVolumes();
                    int vsize = volumes.size();
                    for (int j = 0; j < vsize; ++j) {
                        StorageVolumeInterface vol = (StorageVolumeInterface)volumes.get(j);
                        String devId = vol.getDeviceID();
                        String wwn = devId.substring(IGNORE_DIGITS);
                        VDiskInterface vdisk = this.getItemByWwn(wwn);
                        if (vdisk == null) continue;
                        vdisks.add(vdisk);
                    }
                }
                if (!found) {
                    Trace.error((Object)this, "getItemsByDisk", "diskId: " + diskId + " not found.");
                    throw new ItemNotFoundException(Integer.toString(diskId));
                }
            } else if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "getItemsByDisk", "Skipping unhealthy array: " + t4.getClusterName() + " with health code: " + t4.getHealthStatus());
            }
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemsByDisk", "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsByDisk", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsByDisk", "NullPointerException - Null returned when trying to obtain the VDisk instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the VDisk instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsByDisk", "Exception - Exception thrown when trying to obtain the VDisk instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the VDisk instances.", e);
        }
        return vdisks;
    }

    public VDiskInterface getByKey(Collection key) throws ConfigMgmtException {
        Trace.methodBegin(this, "getByKey");
        VDisk vd = null;
        try {
            if (key != null) {
                CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPStorageExtent", new Vector(key));
                Trace.verbose((Object)this, "getByKey", "Querying CIM for StorageExtent matching key(s).");
                CIMInstance ci = this.handle.getInstance(objPath, false, true, false, ConstantsEnt.StorageExtentProperties.PROP_LIST);
                Trace.verbose((Object)this, "getByKey", "Returned from uerying CIM for StorageExtent matching key(s).");
                if (ci != null) {
                    Trace.verbose((Object)this, "getByKey", "StorageExtent matching key(s) found.");
                    Trace.verbose((Object)this, "getByKey", "Creating VDisk Java object");
                    vd = new VDisk();
                    vd.setInstance(ci);
                    vd.init(this.context);
                    CIMObjectWrapper.populate(vd, vd.getFieldMap(), ci);
                    vd.loadKeys();
                    Trace.verbose((Object)this, "getByKey", "Finished creating VDisk object.");
                }
            } else {
                Trace.error((Object)this, "getByKey", "Key object is null.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Key object is null.");
            }
            if (vd == null) {
                Trace.verbose((Object)this, "getByKey", "No instance returned when trying to obtain the VDisk");
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Object[] params;
            Object p_val;
            Trace.error((Object)this, "getByKey", "Failed: " + cme);
            CIMException cime = (CIMException)((Object)cme.getEmbededException());
            if (cime != null && (p_val = (params = cime.getParams())[0]) instanceof String && cime.getID().equals("CIM_ERR_NOT_FOUND")) {
                return null;
            }
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getByKey", "NullPointerException - Null returned when trying to obtain the VDisk instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the VDisk instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getByKey", "Exception - Exception thrown when trying to obtain the VDisk instance: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the VDisk instance.", e);
        }
        return vd;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "delete");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "delete", "Getting the specified VDisk");
            VDisk disk = (VDisk)this.getByKey(key);
            if (disk == null) {
                Trace.error((Object)this, "delete", "Specified VDisk not found.");
                throw new ItemNotFoundException("VDisk");
            }
            Trace.verbose((Object)this, "delete", "VDisk found attempting deletion...");
            this.handle.deleteInstance(disk.getInstance().getObjectPath());
            Trace.verbose((Object)this, "delete", "Delete returned successfully");
            methodCallStatus.setReturnCode(0);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "delete", "Failed: VDisk Not Found" + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Integer retVal;
            int val;
            Object p_val;
            Object[] params;
            CIMException cime = (CIMException)((Object)cme.getEmbededException());
            if (cime != null && (params = cime.getParams()) != null && (p_val = params[0]) != null && p_val instanceof Integer && ((val = (retVal = (Integer)p_val).intValue()) >= 32768 && val <= 65535 || val >= 0 && val <= 6)) {
                methodCallStatus.setReturnCode(val);
                return methodCallStatus;
            }
            Trace.error((Object)this, "delete", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "delete", "NullPointerException - Null returned when trying to obtain the VDisk instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the VDisk instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "delete", "Exception - Exception thrown when trying to obtain the VDisk instance: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the VDisk instance.", e);
        }
        return methodCallStatus;
    }

    public void rescanStorage() throws ConfigMgmtException {
        String METHOD = "rescanStorage";
        Trace.methodBegin(this, "rescanStorage");
        CIMArgument[] inArgs = new CIMArgument[6];
        CIMArgument[] outArgs = new CIMArgument[1];
        inArgs[0] = new CIMArgument("Job", new CIMValue(null));
        inArgs[1] = new CIMArgument("ConnectionType", new CIMValue(null));
        inArgs[2] = new CIMArgument("OtherConnectionType", new CIMValue(null));
        inArgs[3] = new CIMArgument("Initiators", new CIMValue(null));
        inArgs[4] = new CIMArgument("Targets", new CIMValue(null));
        inArgs[5] = new CIMArgument("LogicalUnits", new CIMValue(null));
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, "DEFAULT", 0);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "rescanStorage", "Configuration service object path is: " + confServiceObjectPath);
        }
        Trace.verbose((Object)this, "rescanStorage", "Calling ScsiScan");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "ScsiScan", inArgs, outArgs);
        Trace.verbose((Object)this, "rescanStorage", "Returned from calling ScsiScan");
        int retVal = (Integer)returnCodeValue.getValue();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "rescanStorage", "Return code: " + retVal);
        }
        if (retVal != 0) {
            Trace.verbose((Object)this, "rescanStorage", "Error code returned: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "rescanStorage");
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return null;
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
    }

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
    }

    public int getItemCount() throws ConfigMgmtException {
        return -1;
    }

    public boolean isOperationSupported(String operation) {
        return false;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
    }

    public MethodCallStatus online(List list) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus offline(List list) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus initialize(List list) throws ConfigMgmtException {
        return null;
    }
}

