/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageDomainInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageDomains;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageDomain;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class ManageStoragePools
implements ManageStoragePoolsInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$ManageStoragePools;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    private ArrayList enumToList(Enumeration enumeration) throws ConfigMgmtException {
        Trace.methodBegin(this, "enumToList");
        ArrayList<StoragePool> enumToList = new ArrayList<StoragePool>();
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "enumToList", "Creating StoragePool Java objects");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                Boolean primordial = (Boolean)ci.getProperty("Primordial").getValue().getValue();
                if (primordial.booleanValue()) continue;
                StoragePool sp = new StoragePool();
                sp.setInstance(ci);
                sp.init(this.context);
                CIMObjectWrapper.populate(sp, sp.getFieldMap(), ci);
                sp.loadKeys();
                enumToList.add(sp);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "enumToList", "The instance added to the list: " + sp);
            }
        }
        return enumToList;
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        ArrayList pools = new ArrayList();
        try {
            Trace.verbose((Object)this, "getItemsBySystem", "Querying CIM for StoragePool Instances");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStoragePool"), false, false, true, false, ConstantsEnt.StoragePoolProperties.PROP_LIST);
            Trace.verbose((Object)this, "getItemsBySystem", "Returned from querying CIM for StoragePool Instances");
            pools = this.enumToList(enumeration);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsBySystem", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsBySystem", "NullPointerException - Null returned when trying to obtain all the StoragePool instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StoragePool instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsBySystem", "Exception - Exception thrown when trying to obtain all the StoragePool instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StoragePool instances.", e);
        }
        return pools;
    }

    public ArrayList getVLVItemsBySystem() throws ConfigMgmtException {
        String METHOD = new String("getVLVItemsBySystem");
        Trace.methodBegin(this, METHOD);
        ArrayList pools = new ArrayList();
        ArrayList<StoragePool> vlvPools = new ArrayList<StoragePool>();
        try {
            pools = this.getItemsBySystem();
            ManageStorageProfiles msp = new ManageStorageProfiles();
            msp.init(this.context, null);
            for (int i = 0; i < pools.size(); ++i) {
                StoragePool pool = (StoragePool)pools.get(i);
                StorageProfile profile = (StorageProfile)msp.getItemByName(pool.getProfileName());
                if (profile == null) continue;
                Trace.verbose((Object)this, METHOD, "StoragePool: " + pool.getName() + " with virt type: " + profile.getVirtualizationStrategy());
                if (profile.getVirtualizationStrategy() != 2) continue;
                Trace.verbose((Object)this, METHOD, "Adding StoragePool: " + pool.getName());
                vlvPools.add(pool);
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to obtain all the VLV StoragePool instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the VLV StoragePool instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain all the VLV StoragePool instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the VLV StoragePool instances.", e);
        }
        return vlvPools;
    }

    public ArrayList getNonVLVItemsBySystem() throws ConfigMgmtException {
        String METHOD = new String("getNonVLVItemsBySystem");
        Trace.methodBegin(this, METHOD);
        ArrayList pools = new ArrayList();
        ArrayList<StoragePool> nonVLVPools = new ArrayList<StoragePool>();
        try {
            pools = this.getItemsBySystem();
            ManageStorageProfiles msp = new ManageStorageProfiles();
            msp.init(this.context, null);
            for (int i = 0; i < pools.size(); ++i) {
                StoragePool pool = (StoragePool)pools.get(i);
                StorageProfile profile = (StorageProfile)msp.getItemByName(pool.getProfileName());
                if (profile == null || profile.getVirtualizationStrategy() == 2) continue;
                nonVLVPools.add(pool);
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, METHOD, "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, METHOD, "NullPointerException - Null returned when trying to obtain all the Non VLV StoragePool instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the Non VLV StoragePool instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, METHOD, "Exception - Exception thrown when trying to obtain all the Non VLV StoragePool instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the Non VLV StoragePool instances.", e);
        }
        return nonVLVPools;
    }

    public ArrayList getItemsByStorageProfile(String name) throws ConfigMgmtException, ItemNotFoundException {
        ArrayList pools;
        block8: {
            Trace.methodBegin(this, "getItemsByStorageProfile");
            pools = new ArrayList();
            try {
                Trace.verbose((Object)this, "getItemsByStorageProfile", "Getting StorageProfile");
                ManageStorageProfiles msp = new ManageStorageProfiles();
                msp.init(this.context, null);
                StorageProfile profile = (StorageProfile)msp.getItemByName(name);
                if (profile != null) {
                    Trace.verbose((Object)this, "getItemsByStorageProfile", "Querying CIM for associated StoragePools.");
                    Enumeration enumeration = this.handle.associators(profile.getInstance().getObjectPath(), "SunStorEdge_DSPElementSettingData", "SunStorEdge_DSPStoragePool", "SettingData", "ManagedElement", true, false, ConstantsEnt.StoragePoolProperties.PROP_LIST);
                    Trace.verbose((Object)this, "getItemsByStorageProfile", "Returned from querying CIM for associated StoragePools.");
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        Trace.verbose((Object)this, "getItemsByStorageProfile", "StoragePool Instances Found.");
                        pools = this.enumToList(enumeration);
                    } else {
                        Trace.verbose((Object)this, "getItemsByStorageProfile", "No StoragePools Found");
                    }
                    break block8;
                }
                Trace.error((Object)this, "getItemsByStorageProfile", "StorageProfile: " + name + " not found.");
                throw new ItemNotFoundException(name);
            }
            catch (ItemNotFoundException infe) {
                Trace.error((Object)this, "getItemsByStorageProfile", "StorageProfile not found: " + infe);
                throw infe;
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getItemsByStorageProfile", "Failed: " + cme);
                throw cme;
            }
            catch (NullPointerException npe) {
                Trace.error((Object)this, "getItemsByStorageProfile", "NullPointerException - Null returned when trying to obtain StoragePool instances: " + npe);
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting StoragePool instances.", npe);
            }
            catch (Exception e) {
                Trace.error((Object)this, "getItemsByStorageProfile", "Exception - Exception thrown when trying to obtain StoragePool instances: " + e);
                throw new ConfigMgmtException("error.systemError", "Exception - Problems getting StoragePool instances.", e);
            }
        }
        return pools;
    }

    public ArrayList getItemsByStorageDomain(String name) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByStorageDomain");
        ArrayList<StoragePool> pools = new ArrayList<StoragePool>();
        try {
            Trace.verbose((Object)this, "getItemsByStorageDomain", "Getting StorageDomain: " + name);
            ManageStorageDomains msd = new ManageStorageDomains();
            msd.init(this.context, null);
            StorageDomain sd = new StorageDomain();
            try {
                sd = (StorageDomain)msd.getItemByName(name);
            }
            catch (ZeroCIMInstanceReturnedException zcie) {
                Trace.error((Object)this, "getItemsByStorageDomain", "StorageDomain: " + name + " not found.");
                throw new ItemNotFoundException(name);
            }
            Trace.verbose((Object)this, "getItemsByStorageDomain", "Querying CIM for the associated StoragePool Instances");
            Enumeration enumeration = this.handle.associators(sd.getCIMInstance().getObjectPath(), "SunStorEdge_DSPHostedStoragePool", "SunStorEdge_DSPStoragePool", "GroupComponent", "PartComponent", true, false, ConstantsEnt.StoragePoolProperties.PROP_LIST);
            Trace.verbose((Object)this, "getItemsByStorageDomain", "Returned from querying CIM for the associated StoragePool Instances");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemsByStorageDomain", " StoragePool Instances Found.");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemsByStorageDomain", " Creating StoragePool Java Objects");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    Boolean primordial = (Boolean)ci.getProperty("Primordial").getValue().getValue();
                    if (primordial.booleanValue()) continue;
                    StoragePool sp = new StoragePool();
                    sp.setInstance(ci);
                    sp.init(this.context);
                    CIMObjectWrapper.populate(sp, sp.getFieldMap(), ci);
                    sp.loadKeys();
                    pools.add(sp);
                }
            } else {
                Trace.verbose((Object)this, "getItemsByStorageDomain", "No instance returned when trying to obtain the list of StoragePools");
            }
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemsByStorageDomain", "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsByStorageDomain", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsByStorageDomain", "NullPointerException - Null returned when trying to obtain all the StoragePool instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StoragePool instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsByStorageDomain", "Exception - Exception thrown when trying to obtain all the StoragePool instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StoragePool instances.", e);
        }
        return pools;
    }

    public StoragePoolInterface getItemByName(String name, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemByName");
        try {
            Trace.verbose((Object)this, "getItemByName", "Getting StoragePools By Domain");
            ArrayList items = this.getItemsByStorageDomain(domainName);
            Trace.verbose((Object)this, "getItemByName", "Searching for the specified StoragePool");
            for (int i = 0; i < items.size(); ++i) {
                StoragePoolInterface spi = (StoragePoolInterface)items.get(i);
                if (!spi.getName().equals(name)) continue;
                return spi;
            }
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemByName", "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemByName", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemByName", "NullPointerException - Null returned when trying to obtain the StoragePool instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the StoragePool instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemByName", "Exception - Exception thrown when trying to obtain the StoragePool instance: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the StoragePool instance.", e);
        }
        return null;
    }

    public StoragePoolInterface getByKey(Collection key) throws ConfigMgmtException {
        Trace.methodBegin(this, "getByKey");
        StoragePool sp = null;
        try {
            if (key != null) {
                CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPStoragePool", new Vector(key));
                Trace.verbose((Object)this, "getByKey", "Querying CIM for StoragePool matching key(s)");
                CIMInstance ci = this.handle.getInstance(objPath, false, true, false, ConstantsEnt.StoragePoolProperties.PROP_LIST);
                Trace.verbose((Object)this, "getByKey", "Returned from querying CIM for StoragePool matching key(s)");
                if (ci != null) {
                    Trace.verbose((Object)this, "getByKey", "Creating StoragePool Java Object");
                    sp = new StoragePool();
                    sp.setInstance(ci);
                    sp.init(this.context);
                    CIMObjectWrapper.populate(sp, sp.getFieldMap(), ci);
                    sp.loadKeys();
                }
            } else {
                Trace.error((Object)this, "getByKey", "Key object is null.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Key object is null.");
            }
            if (sp == null) {
                Trace.verbose((Object)this, "getByKey", "No instance returned when trying to obtain the StoragePool");
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getByKey", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getByKey", "NullPointerException - Null returned when trying to obtain the StoragePool instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the StoragePool instance.", npe);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, "getByKey", "Exception - Exception thrown when trying to obtain the StoragePool instance: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the StoragePool instance.", e);
        }
        return sp;
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        Trace.methodBegin(this, "getNextAvailableName");
        String nextAvailableName = "pool1";
        try {
            for (int i = 2; i < 100; ++i) {
                Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStoragePool where ElementName = '" + nextAvailableName + "'");
                if (!enumeration.hasMoreElements()) {
                    return nextAvailableName;
                }
                Integer num = new Integer(i);
                nextAvailableName = "pool" + num.toString();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getNextAvailableName", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "getNextAvailableName", "NullPointerException - Null returned when trying to obtain the next available StoragePool name.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the next available StoragePool name.", npe);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, "getNextAvailableName", "Exception - Exception thrown when trying to obtain the next available creation name.");
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the next available creation name.", e);
        }
        return null;
    }

    public MethodCallStatus createStoragePool(String name, String description, String storageProfileName, String storageDomainName) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        Trace.methodBegin(this, "createStoragePool");
        try {
            Trace.verbose((Object)this, "createStoragePool", "Validating Parameters");
            this.validateName(name, storageDomainName);
            this.validateDescription(description);
            MethodCallStatus callStatus = new MethodCallStatus();
            Trace.verbose((Object)this, "createStoragePool", "Retrieving specified StorageProfile");
            ManageStorageProfiles msp = new ManageStorageProfiles();
            msp.init(this.context, null);
            StorageProfileInterface spi = msp.getItemByName(storageProfileName);
            if (spi == null) {
                Trace.error((Object)this, "createStoragePool", "StorageProfile: " + storageProfileName + " not found.");
                throw new ItemNotFoundException(storageProfileName);
            }
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)name)), new CIMArgument("Goal", new CIMValue((Object)spi.getInstance().getObjectPath())), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("InPools", new CIMValue(null)), new CIMArgument("InExtents", new CIMValue(null)), new CIMArgument("Pool", new CIMValue(null))};
            CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("Pool", new CIMValue(null))};
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, storageDomainName, 0);
            Trace.verbose((Object)this, "createStoragePool", "Configuration service object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "createStoragePool", "Calling CreateOrModifyStoragePool");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyStoragePool", inArgs, outArgs);
            Trace.verbose((Object)this, "createStoragePool", "Returned from calling CreateOrModifyStoragePool");
            callStatus.setReturnCode((Integer)returnCodeValue.getValue());
            if (callStatus.getReturnCode() == 0) {
                StoragePool pool = (StoragePool)this.getItemByName(name, storageDomainName);
                if (pool != null) {
                    Trace.verbose((Object)this, "createStoragePool", "Setting description");
                    pool.setDescription(description);
                    pool.save();
                } else {
                    Trace.verbose((Object)this, "createStoragePool", "Could not set description, StoragePool could not be found");
                }
            }
            return callStatus;
        }
        catch (BadParameterException bpe) {
            Trace.error((Object)this, "createStoragePool", "Invalid Parameter: " + bpe);
            throw bpe;
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "createStoragePool", "ItemNotFoundException: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createStoragePool", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "createStoragePool", "NullPointerException - Null returned when trying to create the StoragePool instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems creating the StoragePool instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "createStoragePool", "Exception - Exception thrown when trying to create StoragePool: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems creating StoragePool.", e);
        }
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "delete");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "delete", "Getting StoragePool to delete");
            StoragePool pool = (StoragePool)this.getByKey(key);
            if (pool == null) {
                Trace.error((Object)this, "delete", "StoragePool not found.");
                throw new ItemNotFoundException("StoragePool");
            }
            if (!pool.isDeletable()) {
                Trace.error((Object)this, "delete", "StoragePool is not deletable.");
                throw new BadParameterException(pool.getName(), "error.bizobj.poolProtectedInvalid");
            }
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Pool", new CIMValue((Object)pool.getInstance().getObjectPath()))};
            CIMArgument[] outArgs = new CIMArgument[2];
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, pool.getStorageDomainName(), 0);
            Trace.verbose((Object)this, "delete", "Configuration service object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "delete", "Calling DeleteStoragePool");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "DeleteStoragePool", inArgs, outArgs);
            Trace.verbose((Object)this, "delete", "Returned from calling DeleteStoragePool");
            methodCallStatus.setReturnCode((Integer)returnCodeValue.getValue());
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "delete", "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "delete", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "delete", "NullPointerException - Null returned when trying to delete the StoragePool instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems deleting the StoragePool instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "delete", "Exception - Exception thrown when trying to delete StoragePool: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems deleting StoragePool.", e);
        }
        return methodCallStatus;
    }

    public void validateName(String name, String domainName) throws ConfigMgmtException, ItemNotFoundException, BadParameterException {
        Trace.methodBegin(this, "validateName");
        if (name != null) {
            if (name.length() > 16) {
                Trace.error((Object)this, "validateName", "Name: " + name + " is too long.");
                throw new BadParameterException(name, "error.bizobj.nameTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-]+", name)) {
                Trace.error((Object)this, "validateName", "Name: " + name + " contains invalid characters.");
                throw new BadParameterException(name, "error.bizobj.invalidCharacter");
            }
            if (StoragePool.isProtectedName(name)) {
                Trace.error((Object)this, "validateName", "Name: " + name + " is a protected name.");
                throw new BadParameterException(name, "error.bizobj.poolProtectedInvalid");
            }
            StoragePool pool = null;
            try {
                if (domainName != null) {
                    pool = (StoragePool)this.getItemByName(name, domainName);
                }
            }
            catch (ItemNotFoundException infe) {
                Trace.error((Object)this, "validateName", "StorageDomain: " + domainName + "  not found");
                throw new ItemNotFoundException(domainName);
            }
            if (pool != null) {
                Trace.error((Object)this, "validateName", "Name: " + name + " already exists.");
                throw new BadParameterException(name, "error.objectAlreadyExists");
            }
        } else {
            Trace.error((Object)this, "validateName", "Name is null.");
            throw new BadParameterException(name, "error.bizobj.noName");
        }
    }

    public void validateNameChange(StoragePoolInterface pool) throws BadParameterException {
        Trace.methodBegin(this, "validateNameChange");
        if (null != pool && !pool.isDeletable()) {
            Trace.error((Object)this, "validateNameChange", "Name: " + pool.getName() + " is a protected StoragePool name.");
            throw new BadParameterException(pool.getName(), "error.bizobj.poolProtectedRename");
        }
    }

    public void validateDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "validateDescription");
        if (description != null) {
            if (description.length() > 64) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " is too long.");
                throw new BadParameterException(description, "error.bizobj.descriptionTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", description)) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " contains invalid characters.");
                throw new BadParameterException(description, "error.bizobj.invalidDescCharacter");
            }
        }
    }

    public List findVDisksForStealing(boolean requireSameDomain, String destStorageProfileName, String destStorageDomainName) throws ConfigMgmtException {
        String METHOD = "findVDisksForStealing";
        Trace.methodBegin(this, "findVDisksForStealing");
        ArrayList<VDisk> canBeStolen = new ArrayList<VDisk>();
        StorageDomainInterface destStorageDomain = null;
        if (requireSameDomain) {
            ManageStorageDomains msd = new ManageStorageDomains();
            msd.init(this.context, null);
            destStorageDomain = msd.getItemByName(destStorageDomainName);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "findVDisksForStealing", "Found dest Storage domain: " + destStorageDomain.getName());
            }
        }
        ManageStorageProfiles profileMgr = new ManageStorageProfiles();
        profileMgr.init(this.context, null);
        StorageProfileInterface myProfile = profileMgr.getItemByName(destStorageProfileName);
        if (myProfile == null) {
            Trace.verbose((Object)this, "findVDisksForStealing", "Unable to find requested profile: " + destStorageProfileName);
            return canBeStolen;
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "findVDisksForStealing", "Found myProfile: " + myProfile.getName());
        }
        ManageStoragePools msp = new ManageStoragePools();
        msp.init(this.context, null);
        ManageVDisks mvds = new ManageVDisks();
        mvds.init(this.context, null);
        ArrayList availLuns = mvds.getItemsBySystem();
        for (int i_lun = 0; availLuns != null && i_lun < availLuns.size(); ++i_lun) {
            VDisk vdisk = (VDisk)availLuns.get(i_lun);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "findVDisksForStealing", "Examining Vdisk: " + vdisk.getWWN());
            }
            if (vdisk.getAvailableCapacity().equals(BigInteger.ZERO)) {
                Trace.verbose((Object)this, "findVDisksForStealing", "VDisk with 0 capacity not included");
                continue;
            }
            if ("".equals(vdisk.getStoragePoolName())) {
                Trace.verbose((Object)this, "findVDisksForStealing", "found LUN with no pool, automatic candidate");
                canBeStolen.add(vdisk);
                continue;
            }
            try {
                StoragePoolInterface curPool = msp.getItemByName(vdisk.getStoragePoolName(), vdisk.getStorageDomainName());
                if (requireSameDomain && destStorageDomain != null && !destStorageDomain.getName().equals(curPool.getStorageDomainName())) {
                    Trace.verbose((Object)this, "findVDisksForStealing", "skipping pool in different domain per request");
                    continue;
                }
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "findVDisksForStealing", "analyzing pool with name: " + curPool.getName() + " and profile name: " + curPool.getProfileName());
                }
                StorageProfileInterface curProfile = profileMgr.getItemByName(curPool.getProfileName());
                if (vdisk.isExternal() || curProfile != null && ManageStoragePools.areProfilesCompatible(curProfile, myProfile)) {
                    ArrayList vols;
                    if (Trace.isTraceEnabled(this)) {
                        Trace.verbose((Object)this, "findVDisksForStealing", "Found compatible profiles: " + curProfile.getName() + " and " + myProfile.getName());
                    }
                    if ((vols = vdisk.getAssociatedVolumes()) != null && vols.size() != 0) continue;
                    if (Trace.isTraceEnabled(this)) {
                        Trace.verbose((Object)this, "findVDisksForStealing", " will add Visk to list: " + vdisk.getWWN());
                    }
                    canBeStolen.add(vdisk);
                    continue;
                }
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "findVDisksForStealing", "profiles not compatible for: " + vdisk.getWWN());
                continue;
            }
            catch (ItemNotFoundException infe) {
                Trace.error((Object)this, "findVDisksForStealing", "Unable to find StoragePool for Vdisk with pool name: " + vdisk.getStoragePoolName() + " and domain name: " + vdisk.getStorageDomainName());
            }
        }
        return canBeStolen;
    }

    public static boolean areProfilesCompatible(StorageProfileInterface fromP, StorageProfileInterface toP) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$ManageStoragePools == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$ManageStoragePools = ManageStoragePools.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$ent1$ManageStoragePools, "areProfilesCompatible");
        return fromP.getRAIDLevel() == toP.getRAIDLevel() && fromP.getSegmentSize() == toP.getSegmentSize() && (fromP.isReadAheadEnabled() && toP.isReadAheadEnabled() || !fromP.isReadAheadEnabled() && !toP.isReadAheadEnabled()) && (fromP.dedicatedSpareExists() && toP.dedicatedSpareExists() || !fromP.dedicatedSpareExists() && !toP.dedicatedSpareExists()) && fromP.getNumberOfDisks() == toP.getNumberOfDisks() && (fromP.getArrayType() == toP.getArrayType() || toP.getArrayType() == 5 || toP.getArrayType() == 4 || toP.getArrayType() == 3);
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return null;
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
    }

    public ArrayList getItemsForSnapshotSpace(String domainName) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = "getItemsForSnapshotSpace";
        Trace.methodBegin(this, "getItemsForSnapshotSpace");
        ArrayList pools = this.getItemsByStorageDomain(domainName);
        for (int i = pools.size() - 1; i >= 0; --i) {
            StoragePool pool = (StoragePool)pools.get(i);
            StorageProfile profile = pool.getStorageProfile();
            if (profile != null && profile.getVirtualizationStrategy() == 2) {
                pools.remove(i);
                continue;
            }
            if (pool.getUnAllocatedCapacity().compareTo(BigInteger.ZERO) != 0) continue;
            pools.remove(i);
        }
        return pools;
    }

    public ArrayList getItemsForVolumeSpace(String domainName) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD = "getItemsForSnapshotSpace";
        Trace.methodBegin(this, "getItemsForSnapshotSpace");
        ArrayList pools = this.getItemsByStorageDomain(domainName);
        for (int i = pools.size() - 1; i >= 0; --i) {
            StoragePool pool = (StoragePool)pools.get(i);
            StorageProfile profile = pool.getStorageProfile();
            if (profile != null && profile.getVirtualizationStrategy() == 2) {
                pools.remove(i);
                continue;
            }
            if (pool.getUnAllocatedCapacity().compareTo(BigInteger.ZERO) != 0) continue;
            pools.remove(i);
        }
        return pools;
    }

    public ArrayList getItemsForMirroring(String domainName, int virtStrategy) throws ConfigMgmtException {
        String METHOD = "getItemsForMirroring";
        Trace.methodBegin(this, "getItemsForMirroring");
        ArrayList allPools = new ArrayList();
        ArrayList<StoragePool> mirrorPools = new ArrayList<StoragePool>();
        try {
            allPools = this.getItemsByStorageDomain(domainName);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemsForMirroring", "StorageDomain: " + domainName + " not found.");
        }
        ManageStorageProfiles mgrProfiles = new ManageStorageProfiles();
        mgrProfiles.init(this.context, null);
        for (int i = 0; i < allPools.size(); ++i) {
            StorageProfile profile;
            StoragePool pool = (StoragePool)allPools.get(i);
            if (pool.getUnAllocatedCapacity().compareTo(BigInteger.ZERO) != 1 || (profile = (StorageProfile)mgrProfiles.getItemByName(pool.getProfileName())).getVirtualizationStrategy() != virtStrategy) continue;
            mirrorPools.add(pool);
        }
        return mirrorPools;
    }

    public ArrayList getItemsForRemoteReplication() throws ConfigMgmtException {
        String METHOD = "getItemsForRemoteReplication";
        Trace.methodBegin(this, "getItemsForRemoteReplication");
        ArrayList rrPools = new ArrayList();
        rrPools = this.getItemsBySystem();
        ManageStorageProfiles mgrProfiles = new ManageStorageProfiles();
        mgrProfiles.init(this.context, null);
        int size = rrPools.size();
        for (int i = size - 1; i >= 0; --i) {
            StoragePool pool = (StoragePool)rrPools.get(i);
            StorageProfile profile = pool.getStorageProfile();
            if (profile == null || profile.getVirtualizationStrategy() != 2 && pool.getUnAllocatedCapacity().compareTo(BigInteger.ZERO) > 0) continue;
            rrPools.remove(i);
        }
        return rrPools;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

