/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1.ManageInitiators;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapArrayToSet;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapUint64ToBigInteger;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortInterface;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;

public class FiberChannelPort
implements FiberChannelPortInterface {
    private Collection fieldMap;
    private ConfigContext context;
    private CIMInstance instance;
    private CIMOMHandleWrapper handle;
    private String portName;
    private String wwn;
    private String portID;
    private int linkState;
    private String hwState;
    private int portType;
    private String configSpeed;
    private BigInteger speed;
    private boolean autoSpeedSense;
    private String moduleType;
    private String fcUnitType;
    private Set capableClass;
    private Set operClass;
    private Set capableProtocol;
    private Set operProtocol;
    private boolean replicationEnabled;
    private BigInteger errorCount = null;
    private BigInteger writeCommands = null;
    private BigInteger readCommands = null;
    private BigInteger bytesWritten = null;
    private BigInteger bytesRead = null;
    private BigInteger loopDownEvents = null;
    private BigInteger loopResetEvents = null;
    private BigInteger linkFailureCount = null;
    private BigInteger linkSyncLossCount = null;
    private BigInteger linkDownCount = null;
    private BigInteger primSeqProtoErrorCount = null;
    private BigInteger invalidTransWords = null;
    private BigInteger crcErrors = null;
    private Collection keyProperties;
    private String systemCreationClassName;
    private String systemName;
    private String creationClassName;
    private String deviceID;

    public FiberChannelPort() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.instance.getObjectPath(), false, true, false, ConstantsEnt.FCPortProperties.PROP_LIST);
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.loadKeys();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
        }
    }

    public String getPortName() {
        Trace.methodBegin(this, "getPortName");
        if (this.portName == null) {
            return "";
        }
        return this.portName;
    }

    public int getLinkState() {
        Trace.methodBegin(this, "getLinkState");
        return this.linkState;
    }

    public int getHardwareState() {
        Trace.methodBegin(this, "getHardwareState");
        if (this.hwState.equals("Active")) {
            return 0;
        }
        if (this.hwState.equals("Link Down")) {
            return 1;
        }
        if (this.hwState.equals("Unknown")) {
            return 2;
        }
        if (this.hwState.equals("Failed")) {
            return 3;
        }
        if (this.hwState.equals("Loopback")) {
            return 4;
        }
        if (this.hwState.equals("No Media")) {
            return 5;
        }
        if (this.hwState.equals("Bypassed")) {
            return 6;
        }
        if (this.hwState.equals("TX Fault")) {
            return 7;
        }
        return 2;
    }

    public String getPortID() {
        Trace.methodBegin(this, "getPortID");
        if (this.portID == null) {
            return "";
        }
        return this.portID;
    }

    public String getPortWWN() {
        Trace.methodBegin(this, "getPortWWN");
        if (this.wwn == null) {
            return "";
        }
        return this.wwn;
    }

    public String getNodeWWN() {
        Trace.methodBegin(this, "getNodeWWN");
        if (this.systemName == null) {
            return "";
        }
        return this.systemName;
    }

    public int getPortType() {
        Trace.methodBegin(this, "getPortType");
        return this.portType;
    }

    public String getUptime() {
        Trace.methodBegin(this, "getUptime");
        return "5 days 10 hrs 43 mins 13 secs";
    }

    public int getIDConfigured() {
        Trace.methodBegin(this, "getIDConfigured");
        return 3;
    }

    public int getIDOperational() {
        Trace.methodBegin(this, "getIDOperational");
        return 3;
    }

    public int getSpeedConfigured() {
        Trace.methodBegin(this, "getSpeedConfigured");
        if (this.configSpeed.equals("AUTO")) {
            return 0;
        }
        if (this.configSpeed.equals("1G")) {
            return 1;
        }
        if (this.configSpeed.equals("2G")) {
            return 2;
        }
        return -1;
    }

    public int getSpeedOperational() {
        Trace.methodBegin(this, "getSpeedOperational");
        if (this.speed.equals(ConstantsEnt.FCPortProperties.ONE_GIGABYTE)) {
            return 1;
        }
        if (this.speed.equals(ConstantsEnt.FCPortProperties.TWO_GIGABYTE)) {
            return 2;
        }
        return -1;
    }

    public Set getClassesCapable() {
        Trace.methodBegin(this, "getClassesCapable");
        return this.capableClass;
    }

    public Set getClassesOperational() {
        Trace.methodBegin(this, "getClassesOperational");
        return this.operClass;
    }

    public Set getProtocolsCapable() {
        Trace.methodBegin(this, "getProtocolsCapable");
        return this.capableProtocol;
    }

    public Set getProtocolsOperational() {
        Trace.methodBegin(this, "getProtocolsOperational");
        return this.operProtocol;
    }

    public String getModuleType() {
        Trace.methodBegin(this, "getModuleType");
        if (this.moduleType == null) {
            return "";
        }
        return this.moduleType;
    }

    public String getFcUnitType() {
        Trace.methodBegin(this, "getFcUnitType");
        if (this.fcUnitType == null) {
            return "";
        }
        return this.fcUnitType;
    }

    public BigInteger getErrorCount() {
        Trace.methodBegin(this, "getErrorCount");
        try {
            if (this.errorCount == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getErrorCount", "Errors retrieving errorCount.");
            this.errorCount = new BigInteger("0");
        }
        return this.errorCount;
    }

    public BigInteger getWriteCommands() {
        Trace.methodBegin(this, "getWriteCommands");
        try {
            if (this.writeCommands == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getWriteCommands", "Errors retrieving writeCommands.");
            this.writeCommands = new BigInteger("0");
        }
        return this.writeCommands;
    }

    public BigInteger getReadCommands() {
        Trace.methodBegin(this, "getReadCommands");
        try {
            if (this.readCommands == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getReadCommands", "Errors retrieving readCommands.");
            this.readCommands = new BigInteger("0");
        }
        return this.readCommands;
    }

    public BigInteger getBytesWritten() {
        Trace.methodBegin(this, "getBytesWritten");
        try {
            if (this.bytesWritten == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getBytesWritten", "Errors retrieving bytesWritten.");
            this.bytesWritten = new BigInteger("0");
        }
        return this.bytesWritten;
    }

    public BigInteger getBytesRead() {
        Trace.methodBegin(this, "getBytesRead");
        try {
            if (this.bytesRead == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getBytesRead", "Errors retrieving bytesRead.");
            this.bytesRead = new BigInteger("0");
        }
        return this.bytesRead;
    }

    public BigInteger getLoopResetEvents() {
        Trace.methodBegin(this, "getLoopResetEvents");
        try {
            if (this.loopResetEvents == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getLoopResetEvents", "Errors retrieving loopResetEvents.");
            this.loopResetEvents = new BigInteger("0");
        }
        return this.loopResetEvents;
    }

    public BigInteger getLoopDownEvents() {
        Trace.methodBegin(this, "getLoopDownEvents");
        this.loopDownEvents = new BigInteger("0");
        return this.loopDownEvents;
    }

    public BigInteger getLinkSyncLossCount() {
        Trace.methodBegin(this, "getLinkSyncLossCount");
        try {
            if (this.linkSyncLossCount == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getLinkSyncLossCount", "Errors retrieving linkSyncLossCount.");
            this.linkSyncLossCount = new BigInteger("0");
        }
        return this.linkSyncLossCount;
    }

    public BigInteger getLinkFailureCount() {
        Trace.methodBegin(this, "getLinkFailureCount");
        try {
            if (this.linkFailureCount == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getLinkFailureCount", "Errors retrieving linkFailureCount.");
            this.linkFailureCount = new BigInteger("0");
        }
        return this.linkFailureCount;
    }

    public BigInteger getLinkDownCount() {
        Trace.methodBegin(this, "getLinkDownCount");
        try {
            if (this.linkDownCount == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getLinkDownCount", "Errors retrieving linkDownCount.");
            this.linkDownCount = new BigInteger("0");
        }
        return this.linkDownCount;
    }

    public BigInteger getPrimSeqProtoErrorCount() {
        Trace.methodBegin(this, "getPrimSeqProtoErrorCount");
        try {
            if (this.primSeqProtoErrorCount == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getPrimSeqProtoErrorCount", "Errors retrieving primSeqProtoErrorCount.");
            this.primSeqProtoErrorCount = new BigInteger("0");
        }
        return this.primSeqProtoErrorCount;
    }

    public BigInteger getCRCErrors() {
        Trace.methodBegin(this, "getCRCErrors");
        try {
            if (this.crcErrors == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getCRCErrors", "Errors retrieving crcErrors.");
            this.crcErrors = new BigInteger("0");
        }
        return this.crcErrors;
    }

    public BigInteger getInvalidTransWords() {
        Trace.methodBegin(this, "getInvalidTransWords");
        try {
            if (this.invalidTransWords == null) {
                this.getAssociatedStatistics();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getInvalidTransWords", "Errors retrieving invalidTransWords.");
            this.invalidTransWords = new BigInteger("0");
        }
        return this.invalidTransWords;
    }

    public ArrayList getAssociatedInitiators() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssociatedInitiators");
        ArrayList initiators = new ArrayList();
        try {
            Trace.verbose((Object)this, "getAssociatedInitiators", "Getting associated Initiators via ManageInitiatorsInterface.");
            ManageInitiators mi = new ManageInitiators();
            mi.init(this.context, null);
            initiators = mi.getItemsByFCPort(this.getPortName());
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedInitiators", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssociatedInitiators", "NullPointerException - Null returned when trying to obtain all the associated Initiator instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the associated Initiator instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssociatedInitiators", "Exception - Exception thrown when trying to obtain all the associated Initiator instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the associated Initiator instances.", e);
        }
        return initiators;
    }

    private void getAssociatedStatistics() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssociatedStatistics");
        try {
            Trace.verbose((Object)this, "getAssociatedStatistics", "Querying CIM for associated FCPortStatistics instance.");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementStatisticalData", "SunStorEdge_DSPFCPortStatistics", "ManagedElement", "Stats", true, false, null);
            Trace.verbose((Object)this, "getAssociatedStatistics", "Returned from querying CIM for associated FCPortStatistics instances.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                CIMValue cv = ci.getProperty("ErrorFrames").getValue();
                if (cv != null) {
                    this.errorCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'ErrorFrames'.");
                    this.errorCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("PacketsTransmitted").getValue();
                if (cv != null) {
                    this.writeCommands = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'PacketsTransmitted'.");
                    this.writeCommands = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("PacketsReceived").getValue();
                if (cv != null) {
                    this.readCommands = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'PacketsReceived'.");
                    this.readCommands = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("BytesReceived").getValue();
                if (cv != null) {
                    this.bytesRead = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'BytesReceived'.");
                    this.bytesRead = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("BytesTransmitted").getValue();
                if (cv != null) {
                    this.bytesWritten = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'BytesTransmitted'.");
                    this.bytesWritten = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("InvalidTransmissionWords").getValue();
                if (cv != null) {
                    this.invalidTransWords = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'InvalidTransmissionWords'.");
                    this.invalidTransWords = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("LinkResetsReceived").getValue();
                if (cv != null) {
                    this.loopResetEvents = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'LinkResetsReceived'.");
                    this.loopResetEvents = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("LinkFailures").getValue();
                if (cv != null) {
                    this.linkFailureCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'LinkFailures'.");
                    this.linkFailureCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("LossOfSyncCounter").getValue();
                if (cv != null) {
                    this.linkSyncLossCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'LossOfSyncCounter'.");
                    this.linkSyncLossCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("LossOfSignalCounter").getValue();
                if (cv != null) {
                    this.linkDownCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'LossOfSignalCounter'.");
                    this.linkDownCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("PrimitiveSeqProtocolErrCount").getValue();
                if (cv != null) {
                    this.primSeqProtoErrorCount = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'PrimitiveSeqProtocolErrCount'.");
                    this.primSeqProtoErrorCount = new BigInteger("0");
                }
                cv = null;
                cv = ci.getProperty("CRCErrors").getValue();
                if (cv != null) {
                    this.crcErrors = ((UnsignedInt64)cv.getValue()).bigIntValue();
                } else {
                    Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving FCPortStatistics 'CRCErrors'.");
                    this.crcErrors = new BigInteger("0");
                }
            } else {
                Trace.error((Object)this, "getAssociatedStatistics", "Errors retrieving associated FCPort statistics.");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssociatedStatistics", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssociatedStatistics", "NullPointerException - Null returned when trying to obtain all the associated statistics: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the associated statistics.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssociatedStatistics", "Exception - Exception thrown when trying to obtain all the associated statistics: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the associated statistics.", e);
        }
    }

    public Collection getKey() {
        Trace.methodBegin(this, "getKey");
        return this.keyProperties;
    }

    public boolean isReplicationEnabled() {
        Trace.methodBegin(this, "isReplicationEnabled");
        return this.replicationEnabled;
    }

    public void setReplicationEnabled(boolean replicationEnabled) {
        Trace.methodBegin(this, "setReplicationEnabled");
        this.replicationEnabled = replicationEnabled;
    }

    public int getPortStyle() {
        return 1;
    }

    public String getConfigSpeed() {
        Trace.methodBegin(this, "getConfigSpeed");
        return this.configSpeed;
    }

    public String getHwState() {
        Trace.methodBegin(this, "getHwState");
        return this.hwState;
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.instance;
    }

    public String getSystemCreationClassName() {
        Trace.methodBegin(this, "getSystemCreationClassName");
        return this.systemCreationClassName;
    }

    public String getSystemName() {
        Trace.methodBegin(this, "getSystemName");
        return this.systemName;
    }

    public String getCreationClassName() {
        Trace.methodBegin(this, "getCreationClassName");
        return this.creationClassName;
    }

    public String getDeviceID() {
        Trace.methodBegin(this, "getDeviceID");
        return this.deviceID;
    }

    public BigInteger getSpeed() {
        Trace.methodBegin(this, "getSpeed");
        return this.speed;
    }

    public boolean getAutoSpeedSense() {
        Trace.methodBegin(this, "getSpeedSense");
        return this.autoSpeedSense;
    }

    public boolean getReplicationEnabled() {
        Trace.methodBegin(this, "getReplicationEnabled");
        return this.replicationEnabled;
    }

    public void setIDConfigured(int fcID) throws BadParameterException {
        Trace.methodBegin(this, "setIDConfigured");
    }

    public void setSpeedConfigured(int speed) throws BadParameterException {
        Trace.methodBegin(this, "setSpeedConfigured");
        Trace.verbose((Object)this, "setSpeedConfigured", "Determining Configured Speed");
        switch (speed) {
            case 0: {
                this.setAutoSpeedSense(true);
                return;
            }
            case 1: {
                this.setAutoSpeedSense(false);
                this.setSpeed(ConstantsEnt.FCPortProperties.ONE_GIGABYTE);
                return;
            }
            case 2: {
                this.setAutoSpeedSense(false);
                this.setSpeed(ConstantsEnt.FCPortProperties.TWO_GIGABYTE);
                return;
            }
        }
        Trace.error((Object)this, "setSpeedConfigured", "Invalid Parameter: " + speed);
        throw new BadParameterException(new Integer(speed).toString(), "error.illegalArgument");
    }

    public void setInstance(CIMInstance instance) {
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
    }

    public void setPortName(String portName) {
        Trace.methodBegin(this, "setPortName");
        this.portName = portName;
    }

    public void setWwn(String wwn) {
        Trace.methodBegin(this, "setWwn");
        this.wwn = wwn;
    }

    public void setPortID(String portID) {
        Trace.methodBegin(this, "setPortID");
        this.portID = portID;
    }

    public void setLinkState(int linkState) {
        Trace.methodBegin(this, "setLinkState");
        this.linkState = linkState;
    }

    public void setHwState(String hwState) {
        Trace.methodBegin(this, "setHwState");
        this.hwState = hwState;
    }

    public void setPortType(int portType) {
        Trace.methodBegin(this, "setPortType");
        this.portType = portType;
    }

    public void setSpeed(BigInteger speed) {
        Trace.methodBegin(this, "setSpeed");
        this.speed = speed;
    }

    public void setAutoSpeedSense(boolean autoSpeedSense) {
        Trace.methodBegin(this, "setAutoSpeedSense");
        this.autoSpeedSense = autoSpeedSense;
    }

    public void setCapableClass(Set capableClass) {
        Trace.methodBegin(this, "setCapableClass");
        this.capableClass = capableClass;
    }

    public void setOperClass(Set operClass) {
        Trace.methodBegin(this, "setOperClass");
        this.operClass = operClass;
    }

    public void setCapableProtocol(Set capableProtocol) {
        Trace.methodBegin(this, "setCapableProtocol");
        this.capableProtocol = capableProtocol;
    }

    public void setOperProtocol(Set operProtocol) {
        Trace.methodBegin(this, "setOperProtocol");
        this.operProtocol = operProtocol;
    }

    public void setModuleType(String moduleType) {
        Trace.methodBegin(this, "setModuleType");
        this.moduleType = moduleType;
    }

    public void setFcUnitType(String fcUnitType) {
        Trace.methodBegin(this, "setFcUnitType");
        this.fcUnitType = fcUnitType;
    }

    public void setConfigSpeed(String configSpeed) {
        Trace.methodBegin(this, "setConfigSpeed");
        this.configSpeed = configSpeed;
    }

    public void setSystemCreationClassName(String sccn) {
        Trace.methodBegin(this, "setSystemCreationClassName");
        this.systemCreationClassName = sccn;
    }

    public void setSystemName(String sn) {
        Trace.methodBegin(this, "setSystemName");
        this.systemName = sn;
    }

    public void setCreationClassName(String ccn) {
        Trace.methodBegin(this, "setCreationClassName");
        this.creationClassName = ccn;
    }

    public void setDeviceID(String deviceID) {
        Trace.methodBegin(this, "setDeviceID");
        this.deviceID = deviceID;
    }

    public void setKey(Collection props) {
        Trace.methodBegin(this, "setKey");
        this.keyProperties = props;
    }

    public Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("portName", "ElementName", true, false));
            this.fieldMap.add(new MapElement("linkState", "OperationalStatus", true, false, 0));
            this.fieldMap.add(new MapStringArrayToString("hwState", "OtherIdentifyingInfo", true, false, 3));
            this.fieldMap.add(new MapElement("portID", "NetworkAddresses", true, true, 0));
            this.fieldMap.add(new MapElement("wwn", "PermanentAddress", true, false));
            this.fieldMap.add(new MapElement("portType", "PortType", true, true));
            this.fieldMap.add(new MapUint64ToBigInteger("speed", "Speed", false, false));
            this.fieldMap.add(new MapElement("autoSpeedSense", "AutoSense", false, false));
            this.fieldMap.add(new MapElement("replicationEnabled", "ReplicationCapable", false, false));
            this.fieldMap.add(new MapArrayToSet("capableClass", "SupportedCOS", true, true));
            this.fieldMap.add(new MapArrayToSet("operClass", "ActiveCOS", true, true));
            this.fieldMap.add(new MapArrayToSet("capableProtocol", "SupportedFC4Types", true, true));
            this.fieldMap.add(new MapArrayToSet("operProtocol", "ActiveFC4Types", true, true));
            this.fieldMap.add(new MapStringArrayToString("moduleType", "OtherIdentifyingInfo", true, true, 0));
            this.fieldMap.add(new MapStringArrayToString("fcUnitType", "OtherIdentifyingInfo", true, true, 1));
            this.fieldMap.add(new MapStringArrayToString("configSpeed", "OtherIdentifyingInfo", true, false, 2));
            this.fieldMap.add(new MapElement("systemCreationClassName", "SystemCreationClassName", true, false));
            this.fieldMap.add(new MapElement("systemName", "SystemName", true, false));
            this.fieldMap.add(new MapElement("creationClassName", "CreationClassName", true, false));
            this.fieldMap.add(new MapElement("deviceID", "DeviceID", true, false));
        }
        return this.fieldMap;
    }

    public void loadKeys() {
        Trace.methodBegin(this, "loadKeys");
        ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
        prop.add(new CIMProperty("SystemCreationClassName", new CIMValue((Object)this.getSystemCreationClassName())));
        prop.add(new CIMProperty("SystemName", new CIMValue((Object)this.getSystemName())));
        prop.add(new CIMProperty("CreationClassName", new CIMValue((Object)this.getCreationClassName())));
        prop.add(new CIMProperty("DeviceID", new CIMValue((Object)this.getDeviceID())));
        this.setKey(prop);
    }

    public String toString() {
        if (Trace.isTraceEnabled(this)) {
            return "\nFiberChannelPort with:\n \tPortName: " + this.getPortName() + "\n\tLink State: " + this.getLinkState() + "\n     Hardware State: " + this.getHardwareState() + "\n\tPort ID: " + this.getPortID() + "\n\tWWN: " + this.getPortWWN() + "\n \tPort Type: " + this.getPortType() + "\n \tConfig Speed: " + this.getSpeedConfigured() + "\n \tOper Speed: " + this.getSpeedOperational() + "\n \tClasses Capable: " + this.capableClass + "\n \tClasses Oper: " + this.operClass + "\n \tProtocols Capable: " + this.capableProtocol + "\n \tProtocols Oper: " + this.operProtocol;
        }
        return "";
    }

    public int getPreferredSpeed() {
        return 0;
    }

    public int getTopology() {
        return 0;
    }

    public void setTopology(int topolgy) throws IllegalArgumentException {
    }

    public BigInteger getActualSpeed() {
        return null;
    }

    public void setActualSpeed(BigInteger actualSpeed) {
    }

    public void setPreferredSpeed(int preferredSpeed) {
    }

    public boolean isAutoSense() {
        return false;
    }

    public void setAutoSense(boolean autoSense) {
    }
}

