/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStoragePoolsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class QueuedPoolData {
    private ConfigContext context;
    private T4Interface t4;
    private List pools;
    private List allDisks;

    public QueuedPoolData(ConfigContext ctx, T4Interface t4i) throws ConfigMgmtException {
        Trace.constructor(this);
        this.t4 = t4i;
        this.context = ctx;
        this.process();
    }

    private void process() throws ConfigMgmtException {
        String METHOD = "process";
        Trace.methodBegin(this, "process");
        this.pools = new ArrayList();
        this.allDisks = new ArrayList();
        try {
            SearchFilter onlyMyJobs = new SearchFilter("InstanceID", Pattern.compile("^" + this.t4.getClusterName() + ":"));
            JobManager jm = new JobManager();
            jm.setJobTypeName("SunStorEdge_6120CreateStoragePoolJob");
            jm.init(this.context, onlyMyJobs);
            List allJobs = jm.getItemList();
            Iterator jobIter = allJobs.iterator();
            Trace.verbose((Object)this, "process", "Parse list of Create Pool jobs to find reserved extents");
            while (jobIter.hasNext()) {
                JobInterface jobObj = (JobInterface)jobIter.next();
                CIMInstance job = jobObj.getInstance();
                Trace.verbose((Object)this, "process", "Found job [" + jobObj.getId() + "] " + "with status [" + jobObj.getStatusKey() + "]");
                if (jobObj.isActive()) {
                    ArrayList result = new ArrayList();
                    CIMProperty prop = job.getProperty("StorageExtents");
                    if (prop != null) {
                        int trayId;
                        CIMValue val = prop.getValue();
                        if (val != null) {
                            Vector vals = (Vector)val.getValue();
                            if (vals != null) {
                                Trace.verbose((Object)this, "process", "Job [" + jobObj.getId() + "] has reserved [" + vals.size() + "] storage extents");
                                result.addAll(vals);
                            } else {
                                Trace.verbose((Object)this, "process", "StorageExtents property has null value");
                            }
                        } else {
                            Trace.verbose((Object)this, "process", "had null val");
                        }
                        String poolName = (String)job.getProperty("StoragePoolName").getValue().getValue();
                        if (result.size() <= 0 || (trayId = this.getTrayId(result)) <= -1) continue;
                        String profilePoolName = "";
                        if (Repository.getRepository().getConfigInteger() < 4) {
                            try {
                                String profilePoolKey = (String)job.getProperty("SourceProfilePoolKey").getValue().getValue();
                                if (profilePoolKey != null) {
                                    Vector<CIMProperty> key = new Vector<CIMProperty>();
                                    key.add(new CIMProperty("InstanceID", new CIMValue((Object)profilePoolKey)));
                                    ManageStoragePoolsInterface msp = ManageStoragePoolsFactory.getManager();
                                    msp.init(this.context, null);
                                    StoragePoolInterface pool = msp.getByKey(key);
                                    profilePoolName = pool.getName();
                                }
                            }
                            catch (NullPointerException npe) {
                                Trace.verbose((Object)this, "process", "SourceProfilePoolKey value not set.");
                            }
                            catch (ConfigMgmtException cme) {
                                Trace.verbose((Object)this, "process", (Throwable)cme);
                                profilePoolName = "";
                            }
                        }
                        Trace.verbose((Object)this, "process", "profilePoolName = " + profilePoolName);
                        QueuedPool qp = new QueuedPool(poolName, profilePoolName, result, trayId);
                        this.pools.add(qp);
                        this.allDisks.addAll(result);
                        continue;
                    }
                    Trace.verbose((Object)this, "process", "had null prop");
                    continue;
                }
                Trace.verbose((Object)this, "process", "Skip completed or aborted job [" + jobObj.getId() + "]");
            }
        }
        catch (NullPointerException ne) {
            Trace.verbose((Object)this, "CreateStoragePoolJob object returned from StorageConfigService! association is null!!", (Throwable)ne);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null value returned error.", ne);
        }
    }

    private int getTrayId(List disks) {
        int forReturn = -1;
        if (disks != null && disks.size() > 0) {
            String disk = (String)disks.get(0);
            Pattern patt = Pattern.compile("DeviceID=\\W+u(\\d+)d");
            Matcher match = patt.matcher(disk);
            if (match.find()) {
                try {
                    forReturn = Integer.parseInt(match.group(1)) - 1;
                }
                catch (NumberFormatException nfe) {
                    Trace.verbose((Object)this, "Failed to parse tray number.", (Throwable)nfe);
                }
            }
        }
        Trace.verbose((Object)this, "getTrayId", "Will return trayid: " + forReturn);
        return forReturn;
    }

    public int getTrayId(int poolIndex) throws IndexOutOfBoundsException {
        return ((QueuedPool)this.pools.get((int)poolIndex)).trayId;
    }

    public int getNumQueuedPools() {
        if (this.pools != null) {
            return this.pools.size();
        }
        return 0;
    }

    public int getNumDisks(int poolIndex) throws IndexOutOfBoundsException {
        return ((QueuedPool)this.pools.get((int)poolIndex)).pooldisks.size();
    }

    public String getPoolName(int poolIndex) throws IndexOutOfBoundsException {
        return ((QueuedPool)this.pools.get((int)poolIndex)).poolName;
    }

    public String getProfilePoolName(int poolIndex) throws IndexOutOfBoundsException {
        return ((QueuedPool)this.pools.get((int)poolIndex)).profilePoolName;
    }

    public List getStorageExtents(int poolIndex) throws IndexOutOfBoundsException {
        return ((QueuedPool)this.pools.get((int)poolIndex)).pooldisks;
    }

    public List getAllStorageExtents() {
        return this.allDisks;
    }

    private class QueuedPool {
        String poolName;
        String profilePoolName;
        List pooldisks;
        int trayId;

        public QueuedPool(String name, String profilePool, List disks, int trayId) {
            Trace.constructor(this);
            this.poolName = name;
            this.profilePoolName = profilePool;
            this.pooldisks = disks;
            this.trayId = trayId;
        }
    }
}

