/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.NoSuchRaidLevelException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.QueuedPoolData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PoolBreakdownForTray {
    private boolean canBeSupported = false;
    private int numPools = -1;
    private int raidLevel = -1;
    private int numDataDisks = -1;
    private int numWastedDisks = 0;
    private boolean useSpare = false;
    private TrayInterface tray;
    private Pool[] pools;
    private int failureReason = 1;
    public static final int SUCCESS = 0;
    public static final int UNINITIALIZED = 1;
    public static final int TOO_MANY_POOLS = 2;
    public static final int NOT_ENOUGH_DISKS = 3;
    public static final int NO_HOT_SPARE_AVAILABLE = 4;
    public static final int NOT_ENOUGH_DISKS_FOR_RAID = 5;

    public PoolBreakdownForTray(TrayInterface tray, int numPools, int numDataDisks, int raidLevel, boolean useSpare) throws ConfigMgmtException {
        Trace.constructor(this);
        this.tray = tray;
        this.numPools = numPools;
        this.numDataDisks = numDataDisks;
        this.raidLevel = raidLevel;
        this.useSpare = useSpare;
        this.process();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void process() throws ConfigMgmtException {
        Trace.methodBegin(this, "process");
        int numRaidGroups = this.tray.getNumRequestedAndExistingRaidGroups();
        if (this.numPools + numRaidGroups > 2) {
            this.failureReason = 2;
            Trace.verbose((Object)this, "process", "Too many pools to create. Existing: " + numRaidGroups + " plus requested: " + this.numPools + " is larger than 2.");
            return;
        }
        if (this.numDataDisks < 2) {
            Trace.verbose((Object)this, "process", "No available disks on this tray.");
            this.failureReason = 3;
            return;
        }
        List firstPoolAvail = this.tray.getDisksAvailableForPool(this.useSpare);
        List allDisks = this.tray.getDiskList();
        Trace.verbose((Object)this, "process", "With useSpare: " + this.useSpare + ", we found number of data disks: " + firstPoolAvail.size());
        if (firstPoolAvail.size() == 0 || firstPoolAvail.size() < this.numDataDisks) {
            Trace.verbose((Object)this, "process", "Not enough available disks on this tray. Found: " + firstPoolAvail.size() + " but requested: " + this.numDataDisks);
            this.failureReason = 3;
            return;
        }
        if (this.numPools == 1) {
            Trace.verbose((Object)this, "process", "Processing for 1 pool creation.");
            if (this.raidLevel == 5 && (this.numDataDisks < 3 || firstPoolAvail.size() < 3)) {
                Trace.verbose((Object)this, "process", "Not enough disks for this RAID level.");
                this.failureReason = 5;
                return;
            }
            if (firstPoolAvail.size() < this.numDataDisks) {
                Trace.verbose((Object)this, "process", "Not enough available disks on this tray.");
                this.pools = new Pool[0];
                this.failureReason = 3;
                return;
            }
            ArrayList<DiskInterface> disksForPool = new ArrayList<DiskInterface>();
            for (int i = 0; i < this.numDataDisks; ++i) {
                disksForPool.add((DiskInterface)firstPoolAvail.get(i));
            }
            int potentialWasted = firstPoolAvail.size() - disksForPool.size();
            if (this.numPools + numRaidGroups == 2 || potentialWasted < 3) {
                Trace.verbose((Object)this, "process", "wasted disks detected: " + potentialWasted);
                this.numWastedDisks = potentialWasted;
            }
            this.pools = new Pool[1];
            String suggestedName = this.findSuggestedName(this.tray, this.getTrayId());
            this.pools[0] = new Pool(suggestedName, this.raidLevel, disksForPool);
        } else {
            int disksForFirstPool = this.numDataDisks / 2;
            int disksForSecondPool = this.numDataDisks - disksForFirstPool;
            Trace.verbose((Object)this, "process", "will need " + disksForFirstPool + " disks for pool1 and " + disksForSecondPool + " for pool2");
            if (disksForFirstPool < 2 || disksForSecondPool < 2) {
                Trace.verbose((Object)this, "process", "No available disks on this tray.");
                this.failureReason = 3;
                return;
            }
            if (this.raidLevel == 5 && (disksForFirstPool < 3 || disksForSecondPool < 3)) {
                Trace.verbose((Object)this, "process", "Not enough disks for this RAID level.");
                this.failureReason = 5;
                return;
            }
            this.pools = new Pool[2];
            ArrayList<DiskInterface> disksForPool1 = new ArrayList<DiskInterface>();
            for (int i = 0; i < disksForFirstPool; ++i) {
                disksForPool1.add((DiskInterface)firstPoolAvail.get(i));
            }
            this.pools[0] = new Pool("tray" + this.getTrayId() + "_pool1", this.raidLevel, disksForPool1);
            int spareSlotForPool1 = -1;
            if (this.useSpare) {
                DiskInterface d = (DiskInterface)disksForPool1.get(disksForPool1.size() - 1);
                spareSlotForPool1 = this.findHotSpare(allDisks, this.getEffectiveDiskSize(0), d.getSlotNumber() + 1, new ArrayList());
                if (spareSlotForPool1 < 0) {
                    Trace.verbose((Object)this, "process", "No hot spare available for pool1.");
                    this.pools = new Pool[0];
                    this.failureReason = 4;
                    return;
                }
            }
            int lastSlotPool1 = ((DiskInterface)disksForPool1.get(disksForPool1.size() - 1)).getSlotNumber();
            ArrayList<DiskInterface> disksForPool2 = new ArrayList<DiskInterface>();
            int lastSlotForPool2 = -1;
            boolean done = false;
            for (int i = 0; !done && i < allDisks.size(); ++i) {
                DiskInterface disk = (DiskInterface)allDisks.get(i);
                int slot = disk.getSlotNumber();
                if (slot > lastSlotPool1 && slot != spareSlotForPool1 && "unassigned".equals(disk.getRole())) {
                    Trace.verbose((Object)this, "process", "Disk in slot: " + slot + " might be usable in pool2");
                    if (disksForPool2.size() > 0 && slot == lastSlotForPool2 + 1) {
                        Trace.verbose((Object)this, "process", "Continuing list for pool 2 at slot: " + slot);
                        disksForPool2.add(disk);
                    } else {
                        disksForPool2 = new ArrayList();
                        Trace.verbose((Object)this, "process", "Beginning list for pool 2 at slot: " + slot);
                        disksForPool2.add(disk);
                    }
                    lastSlotForPool2 = slot;
                }
                if (disksForPool2.size() != disksForSecondPool) continue;
                done = true;
                Trace.verbose((Object)this, "process", "Found enough data disks for pool 2.");
            }
            if (!done) {
                this.pools = new Pool[0];
                this.failureReason = 3;
                return;
            }
            this.pools[1] = new Pool("tray" + this.getTrayId() + "_pool2", this.raidLevel, disksForPool2);
            int spareSlotForPool2 = -1;
            if (this.useSpare) {
                DiskInterface d = (DiskInterface)disksForPool2.get(disksForPool2.size() - 1);
                ArrayList<Integer> avoid = new ArrayList<Integer>();
                avoid.add(new Integer(spareSlotForPool1));
                spareSlotForPool2 = this.findHotSpare(allDisks, this.getEffectiveDiskSize(1), d.getSlotNumber() + 1, avoid);
                if (spareSlotForPool2 < 0) {
                    Trace.verbose((Object)this, "process", "No hot spare available for pool2.");
                    this.pools = new Pool[0];
                    this.failureReason = 4;
                    return;
                }
            }
            done = false;
            int lastContigSlot = lastSlotForPool2;
            for (int i = 0; !done && i < allDisks.size(); ++i) {
                DiskInterface disk = (DiskInterface)allDisks.get(i);
                int curSlot = disk.getSlotNumber();
                if (curSlot <= lastSlotForPool2) continue;
                if (curSlot == lastContigSlot + 1 && "unassigned".equals(disk.getRole()) && curSlot != spareSlotForPool1 && curSlot != spareSlotForPool2) {
                    ++this.numWastedDisks;
                } else if (this.numWastedDisks > 0) {
                    done = true;
                }
                lastContigSlot = curSlot;
            }
            Trace.verbose((Object)this, "process", "Will waste number of disks: " + this.numWastedDisks);
        }
        Trace.verbose((Object)this, "process", "requested scenario can be supported.");
        this.canBeSupported = true;
        this.failureReason = 0;
    }

    public boolean canBeSupported() {
        return this.canBeSupported;
    }

    public String getTrayId() {
        return this.tray.getId();
    }

    public int getFailureReason() {
        return this.failureReason;
    }

    public boolean getUseSpare() {
        return this.useSpare;
    }

    public int getNumWastedDisks() {
        return this.numWastedDisks;
    }

    public TrayInterface getTray() {
        return this.tray;
    }

    public int getNumPools() {
        return this.numPools;
    }

    public int getRaidLevel() {
        return this.raidLevel;
    }

    public int getNumDisks(int poolIndex) throws IndexOutOfBoundsException {
        return this.pools[poolIndex].getDisks().size();
    }

    public List getDisksForPool(int poolIndex) throws IndexOutOfBoundsException {
        return this.pools[poolIndex].getDisks();
    }

    public String getSuggestedName(int poolIndex) throws IndexOutOfBoundsException {
        return this.pools[poolIndex].getSuggestedName();
    }

    public BigInteger getEffectiveDiskSize(int poolIndex) throws IndexOutOfBoundsException {
        return this.pools[poolIndex].getEffectiveDiskSize();
    }

    public BigInteger getPoolCapacity(int poolIndex) throws IndexOutOfBoundsException {
        return this.pools[poolIndex].getPoolCapacity();
    }

    public void setSuggestedName(int poolIndex, String name) throws IndexOutOfBoundsException {
        this.pools[poolIndex].setSuggestedName(name);
    }

    private int findHotSpare(List allDisks, BigInteger spareCapacity, int minSpareSlot, List avoidList) throws ConfigMgmtException {
        if (!this.tray.getT4Interface().isFeatureSupported(4)) {
            if (minSpareSlot > 14) {
                Trace.verbose((Object)this, "findHotSpare", "Pool is using slot 14 as a data disk, so no spare  available on firmware 3.0");
                return -1;
            }
            return this.findHotSpareInSlot14(allDisks);
        }
        return this.findHotSpareWhenDedicatedSupported(allDisks, spareCapacity, minSpareSlot, avoidList);
    }

    private int findHotSpareInSlot14(List allDisks) {
        Trace.methodBegin(this, "findHotSpareInSlot14");
        int spareSlot = -1;
        boolean foundSlot14 = false;
        for (int i = allDisks.size() - 1; !foundSlot14 && i >= 0; --i) {
            DiskInterface disk = (DiskInterface)allDisks.get(i);
            int curSlot = disk.getSlotNumber();
            if (curSlot != 14) continue;
            foundSlot14 = true;
            if (!"unassigned".equals(disk.getRole()) && !"standbyDisk".equals(disk.getRole())) continue;
            Trace.verbose((Object)this, "findHotSpareInSlot14", "Slot 14 is available for hot spare.");
            spareSlot = 14;
        }
        return spareSlot;
    }

    private int findHotSpareWhenDedicatedSupported(List allDisks, BigInteger spareCapacity, int minSpareSlot, List avoidList) {
        int spareSlot = -1;
        int spareCandidateSlot = -1;
        Trace.verbose((Object)this, "findHotSpareWhenDedicatedSupported", "Pool needs spare of size: " + spareCapacity);
        boolean restInUse = false;
        for (int i = allDisks.size() - 1; spareSlot < 0 && !restInUse && i >= 0; --i) {
            DiskInterface disk = (DiskInterface)allDisks.get(i);
            int curSlot = disk.getSlotNumber();
            if (curSlot >= minSpareSlot) {
                Trace.verbose((Object)this, "findHotSpareWhenDedicatedSupported", "examining slot num: " + curSlot);
                if ("unassigned".equals(disk.getRole()) && !avoidList.contains(new Integer(curSlot))) {
                    int comp = spareCapacity.compareTo(disk.getCapacity());
                    if (comp == 0) {
                        spareSlot = disk.getSlotNumber();
                        Trace.verbose((Object)this, "findHotSpareWhenDedicatedSupported", "Will use slot number: " + spareSlot + " for the spare for this pool.");
                        continue;
                    }
                    if (spareCandidateSlot >= 0 || comp >= 0) continue;
                    spareCandidateSlot = disk.getSlotNumber();
                    Trace.verbose((Object)this, "findHotSpareWhenDedicatedSupported", "found first spare candidate in slot: " + spareCandidateSlot);
                    continue;
                }
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "findHotSpareWhenDedicatedSupported", "not suitable slot: " + curSlot + " has role: " + disk.getRole() + ". In avoid list: " + avoidList.contains(new Integer(curSlot)));
                continue;
            }
            Trace.verbose((Object)this, "findHotSpareWhenDedicatedSupported", "Done looking for hot spares, since the rest of drives are in use.");
            restInUse = true;
        }
        if (spareSlot < 0 && spareCandidateSlot > 0) {
            Trace.verbose((Object)this, "findHotSpareWhenDedicatedSupported", "Will use spare candidate from slot: " + spareCandidateSlot);
            spareSlot = spareCandidateSlot;
        }
        return spareSlot;
    }

    private String findSuggestedName(TrayInterface tray, String trayId) throws ConfigMgmtException {
        String METHOD = "findSuggestedName";
        Trace.methodBegin(this, "findSuggestedName");
        List rgs = tray.getRaidGroups();
        QueuedPoolData qpd = tray.getT4Interface().getQueuedPoolData();
        int poolNum = 1;
        String toUse = null;
        boolean keepLooking = true;
        while (keepLooking) {
            int i;
            toUse = "tray" + trayId + "_pool" + poolNum;
            boolean inUse = false;
            for (i = 0; rgs != null && i < rgs.size(); ++i) {
                RaidGroupInterface rg = (RaidGroupInterface)rgs.get(i);
                if (!toUse.equals(rg.getName())) continue;
                Trace.verbose((Object)this, "findSuggestedName", "existing raid group already using: " + toUse);
                inUse = true;
            }
            for (i = 0; !inUse && i < qpd.getNumQueuedPools(); ++i) {
                if (!toUse.equals(qpd.getPoolName(i))) continue;
                Trace.verbose((Object)this, "findSuggestedName", "queued raid group already using: " + toUse);
                inUse = true;
            }
            if (!inUse) {
                keepLooking = false;
            }
            ++poolNum;
        }
        return toUse;
    }

    private class Pool {
        private String suggestedName;
        private List disks;
        private BigInteger capacity;
        private BigInteger effCap;

        public Pool(String suggestedName, int raidLevel, List disks) throws ConfigMgmtException {
            this.suggestedName = suggestedName;
            this.disks = disks;
            this.capacity = this.calculatePoolCapacity(disks, raidLevel);
        }

        public String getSuggestedName() {
            return this.suggestedName;
        }

        public void setSuggestedName(String name) {
            this.suggestedName = name;
        }

        public List getDisks() {
            return this.disks;
        }

        public void setDisks(List disks) {
            this.disks = disks;
        }

        private BigInteger calculatePoolCapacity(List disks, int raidLevel) throws ConfigMgmtException {
            BigInteger pCap = null;
            BigInteger dCap = this.getEffectiveDiskSize();
            if (raidLevel == 5) {
                pCap = dCap.multiply(new BigInteger("" + (disks.size() - 1)));
            } else if (raidLevel == 1) {
                pCap = dCap.multiply(new BigInteger("" + disks.size())).divide(new BigInteger("2"));
            } else if (raidLevel == 0) {
                pCap = dCap.multiply(new BigInteger("" + disks.size()));
            } else {
                throw new NoSuchRaidLevelException("NO_SUCH_RAID_LEVEL", "RAID level " + raidLevel + " is not valid.");
            }
            return pCap;
        }

        public BigInteger getPoolCapacity() {
            return this.capacity;
        }

        public BigInteger getEffectiveDiskSize() {
            if (this.effCap == null) {
                Iterator iDisks = this.disks.iterator();
                while (iDisks.hasNext()) {
                    DiskInterface disk = (DiskInterface)iDisks.next();
                    if (this.effCap == null) {
                        this.effCap = disk.getCapacity();
                        continue;
                    }
                    this.effCap = this.effCap.min(disk.getCapacity());
                }
            }
            return this.effCap;
        }
    }
}

