/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.AvailableSpaceForRaidSets;
import java.util.List;

public class NewStorageFilter {
    private List arraysToConsider;
    private ConfigContext context;

    public NewStorageFilter(ConfigContext context, List loadedArrays) throws ConfigMgmtException {
        Trace.constructor(this);
        this.context = context;
        this.arraysToConsider = loadedArrays;
        if (this.arraysToConsider == null) {
            ManageT4sInterface mt4 = ManageT4sFactory.getManager();
            mt4.init(context, null);
            this.arraysToConsider = mt4.getItemList();
        }
        Trace.verbose((Object)this, "Constructor", "have num t4s: " + (this.arraysToConsider == null ? 0 : this.arraysToConsider.size()));
    }

    public int getMaxDisksForProfile(StorageProfileInterface profile) {
        String METHOD = "getMaxDisksForProfile";
        Trace.methodBegin(this, "getMaxDisksForProfile");
        int numArrays = this.arraysToConsider == null ? 0 : this.arraysToConsider.size();
        int maxDisks = 0;
        boolean profileIsVariable = 0 == profile.getNumberOfDisks();
        boolean done = false;
        for (int i = 0; i < numArrays && !done; ++i) {
            T4Interface t4 = (T4Interface)this.arraysToConsider.get(i);
            if (0 != AvailableSpaceForRaidSets.isSuitableArray(t4, profile.getArrayType(), profile.getSegmentSize(), profile.isReadAheadEnabled())) continue;
            if (profile.dedicatedSpareExists()) {
                int maxWithRedun = t4.getMaxDisksAvailWithRedun();
                if (maxWithRedun > maxDisks && maxWithRedun >= profile.getNumberOfDisks()) {
                    maxDisks = maxWithRedun;
                }
            } else {
                int maxNoRedun = t4.getMaxDisksAvailNoRedun();
                if (maxNoRedun > maxDisks && maxNoRedun >= profile.getNumberOfDisks()) {
                    maxDisks = maxNoRedun;
                }
            }
            if (profileIsVariable || maxDisks < profile.getNumberOfDisks()) continue;
            done = true;
            maxDisks = profile.getNumberOfDisks();
        }
        return maxDisks;
    }

    public List getLoadedArrays() {
        return this.arraysToConsider;
    }
}

