/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Volume;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ManageVolumesFactory {
    public static ManageVolumesInterface getManager(ConfigContext cfgctx, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        int config = (Integer)cfgctx.getAttribute("config-type");
        int arrayType = (Integer)cfgctx.getAttribute("array-type");
        ManageVolumes manager = null;
        switch (arrayType) {
            case 1: {
                break;
            }
            case 0: {
                manager = new ManageVolumes();
                break;
            }
            default: {
                throw new ConfigMgmtException("unsupported.configuration.request", "Array:" + arrayType + " is not supported");
            }
        }
        manager.init(cfgctx, scope, filter);
        return manager;
    }

    public static ManageVolumesInterface getManager(ConfigContext cfgctx) throws ConfigMgmtException {
        return ManageVolumesFactory.getManager(cfgctx, null, null);
    }

    public static void main(String[] args) {
        ConfigContext cfgctx = new ConfigContext();
        cfgctx.setAttribute("config-type", new Integer(0));
        cfgctx.setAttribute("array-type", new Integer(0));
        String wwn = "array==60.0a.0b.80.00.13.95.bb.00.00.00.00.40.64.1e.6b<NL>";
        try {
            Scope scope = new Scope();
            scope.setAttribute("array", wwn);
            ManageVolumesInterface mgr = ManageVolumesFactory.getManager(cfgctx, scope, null);
            List volumes = mgr.getItemList();
            for (int i = 0; i < volumes.size(); ++i) {
                VolumeInterface v = (VolumeInterface)volumes.get(i);
                System.out.println("Volume:" + v.getName());
                System.out.println("Key as string:" + v.getKeyAsString());
                System.out.println("Size:" + v.getSize());
                System.out.println("Status:" + v.getStatus());
                System.out.println("wwn:" + v.getWwn());
                if (!(v instanceof Volume)) continue;
                System.out.println("Array name: " + ((Volume)v).getArrayName());
                System.out.println("Pool name: " + ((Volume)v).getPoolName());
                System.out.println("Profile name: " + ((Volume)v).getProfileName());
                System.out.println("Segment size: " + ((Volume)v).getSegmentSize());
                System.out.println("Read cache: " + ((Volume)v).isReadCache());
                System.out.println("Write cache: " + ((Volume)v).isWriteCache());
                System.out.println("Volume type: " + ((Volume)v).getType());
                System.out.println("Read-only: " + ((Volume)v).isReadOnly());
                System.out.println("Controller name: " + ((Volume)v).getController());
                System.out.println("VDisk name:  " + v.getVdiskName());
            }
            System.out.println("Number of volumes: " + mgr.getItemCount());
            ArrayList<String> forDelete = new ArrayList<String>();
            for (int i = 0; i < volumes.size(); ++i) {
                VolumeInterface v = (VolumeInterface)volumes.get(i);
                if (!v.getName().startsWith("Marija")) continue;
                forDelete.add(v.getKeyAsString());
                System.out.println("Volume for delete: " + v.getName());
            }
            MethodCallStatus mcs = mgr.delete(forDelete);
            List eds = mcs.getErrorDescList();
            Iterator iter = eds.iterator();
            while (iter.hasNext()) {
                ErrorDescriptor element = (ErrorDescriptor)iter.next();
                System.out.println(element.getErrorCode());
                System.out.println(element.getI18nkey());
                System.out.println(element.getI18nParams());
                System.out.println(element.getMsg());
            }
            Properties props = new Properties();
            props.setProperty("poolKey", "poolKey");
            props.setProperty("volumeName", "Marija1");
            props.setProperty("volumeSize", "1 GB");
            mgr.create(props);
            props.setProperty("volumeName", "Marija2");
            props.setProperty("numberOfDisks", "3");
            mgr.create(props);
            ManageDisksInterface diskManager = ManageDisksFactory.getManager(cfgctx, scope, null);
            List disks = diskManager.getItemList();
            ArrayList<String> diskKeysList = new ArrayList<String>();
            Iterator iter2 = disks.iterator();
            while (iter2.hasNext()) {
                DiskInterface element = (DiskInterface)iter2.next();
                if (!"unassigned".equals(element.getRole())) continue;
                diskKeysList.add(element.getKeyAsString());
                System.out.println("Disk added = " + element.getName());
            }
            props.setProperty("volumeName", "Marija3");
            props.remove("numberOfDisks");
            props.setProperty("listOfDiskKeys", Convert.arrayToCommaString(diskKeysList.toArray(new String[0])));
            ((ManageVolumes)mgr).create(props);
            ManageVDisksInterface manager = ManageVDisksFactory.getManager(cfgctx, scope, null);
            List list = manager.getItemList();
            VDiskInterface vdisk = (VDiskInterface)list.get(list.size() - 1);
            String vdiskKey = vdisk.getKeyAsString();
            props.setProperty("vdiskKey", vdiskKey);
            props.setProperty("volumeName", "Marija4");
            mgr.create(props);
        }
        catch (ConfigMgmtException e) {
            e.printStackTrace();
        }
    }
}

