/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VDisk;
import java.util.List;

public class ManageVDisksFactory {
    public static ManageVDisksInterface getManager(ConfigContext cfgctx, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        int config = (Integer)cfgctx.getAttribute("config-type");
        int arrayType = (Integer)cfgctx.getAttribute("array-type");
        ManageVDisksInterface manager = null;
        switch (arrayType) {
            case 0: {
                manager = new ManageVDisks();
                break;
            }
            case 4: {
                manager = new com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks();
                break;
            }
            default: {
                throw new ConfigMgmtException("unsupported.configuration.request", "Array:" + arrayType + " is not supported");
            }
        }
        manager.init(cfgctx, scope, filter);
        return manager;
    }

    public static ManageVDisksInterface getManager(ConfigContext cfgctx) throws ConfigMgmtException {
        return ManageVDisksFactory.getManager(cfgctx, null, null);
    }

    public static ManageVDisksInterface getManager() {
        if (Repository.getRepository().getConfigInteger() == 4 || Repository.getRepository().getConfigInteger() == 5) {
            com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks mgr = new com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks();
            return mgr;
        }
        return null;
    }

    public static void main(String[] args) {
        ConfigContext cfgctx = new ConfigContext();
        cfgctx.setAttribute("config-type", new Integer(0));
        cfgctx.setAttribute("array-type", new Integer(0));
        String wwn = "60.0a.0b.80.00.13.95.bb.00.00.00.00.40.64.1e.6b";
        try {
            Scope scope = new Scope();
            scope.setAttribute("array", wwn);
            ManageVDisksInterface mgr = ManageVDisksFactory.getManager(cfgctx, scope, null);
            List vdisks = mgr.getItemList();
            for (int i = 0; i < vdisks.size(); ++i) {
                VDiskInterface v = (VDiskInterface)vdisks.get(i);
                System.out.println("VDisk name:" + v.getName());
                System.out.println("Key as a string:" + v.getKeyAsString());
                System.out.println("State:" + v.getState());
                System.out.println("Status:" + v.getStatus());
                System.out.println("wwn:" + v.getWWN());
                System.out.println("Configured capacity: " + v.getConfiguredCapacity());
                System.out.println("Total capacity: " + v.getTotalCapacity());
                System.out.println("Number of disks: " + v.getNumberOfDisks());
                System.out.println("Number of volumes: " + v.getNumberOfVolumes());
                System.out.println("Raid level: " + v.getRaidLevel());
                if (!(v instanceof VDisk)) continue;
                System.out.println("Max volume size: " + ((VDisk)v).getMaxVolumeSize());
                System.out.println("Type of disks: " + ((VDisk)v).getTypeOfDisks());
            }
            System.out.println("Number of vdisks: " + mgr.getItemCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

