/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.Job;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.RaidGroup;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.util.ParseException;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.text.CollationKey;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ManageStorageProfiles
implements Constants.ProfileFilterTypes,
Constants.ArrayType,
Constants.T4,
Constants.ProfileProperties,
Constants.SupportedFeature {
    private static ManageStorageProfiles singleton;
    private static final String DEFAULT_PROFILE_FILE_PATH = "/opt/se6x20/resources/StorageProfiles.xml";
    private static final String DEFAULT_PROFILE_XSD_PATH = "/opt/se6x20/resources/StorageProfiles.xsd";
    private static final String PROFILE_FILE_PATH_KEY = "profile-file-path";
    private static final String PROFILE_XSD_PATH_KEY = "profile-xsd-path";
    private static final String BACKUP_SUFFIX = ".bkup";
    private static String profileFilePath;
    private static String profileFileBackupPath;
    private static String profileXsdPath;
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String XML_ROOT_B = "<sscs_storage_profiles xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
    private static final String XML_ROOT_E = "</sscs_storage_profiles>";
    private static final int CUSTOM_PROFILE_NAME_MAX = 1000;
    private List allProfiles = new ArrayList();
    private static final int SYMBOL_TABLE_SIZE = 2039;
    private static final String PROPERTY_SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String PROPERTY_GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String FEATURE_NAMESPACE = "http://xml.org/sax/features/namespaces";
    private static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String FEATURE_SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    private static final String FEATURE_SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private ArrayList parseErrors = null;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$ManageStorageProfiles;

    public static synchronized ManageStorageProfiles getInstance() throws ConfigMgmtException {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$ManageStorageProfiles == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$ManageStorageProfiles = ManageStorageProfiles.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfiles")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$ManageStorageProfiles, "getInstance");
        if (singleton == null) {
            singleton = new ManageStorageProfiles();
        }
        return singleton;
    }

    private ManageStorageProfiles() throws ConfigMgmtException {
        Trace.constructor(this);
        profileFilePath = (String)Repository.getRepository().getProperty(PROFILE_FILE_PATH_KEY);
        if (profileFilePath == null) {
            profileFilePath = DEFAULT_PROFILE_FILE_PATH;
        }
        profileFileBackupPath = profileFilePath + BACKUP_SUFFIX;
        profileXsdPath = (String)Repository.getRepository().getProperty(PROFILE_XSD_PATH_KEY);
        if (profileXsdPath == null) {
            profileXsdPath = DEFAULT_PROFILE_XSD_PATH;
        }
        this.loadAllProfilesFromXml();
    }

    private synchronized List buildListFromDoc(Element root) throws Exception {
        String methodName = "buildListFromDoc";
        Vector<StorageProfile> theList = new Vector<StorageProfile>();
        List profiles = XMLUtils.listNamedChildElements(root, "sscs_storage_profile");
        for (int i = 0; i < profiles.size(); ++i) {
            Element profile = (Element)profiles.get(i);
            StorageProfile newProfile = new StorageProfile(profile);
            theList.add(newProfile);
        }
        return theList;
    }

    private synchronized void loadAllProfilesFromXml() throws ConfigMgmtException {
        String methodName = "loadAllProfilesFromXml()";
        Trace.methodBegin(this, methodName);
        try {
            this.loadAllProfilesFromXml(profileFilePath);
            String theXml = this.getExportXml(null);
            this.validateXml(theXml);
            return;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed to load " + profileFilePath);
            Trace.error((Object)this, cme);
        }
        catch (ParseException pe) {
            List parseErrors = pe.getParseErrors();
            StringBuffer errorMsg = new StringBuffer();
            for (int i = 0; i < parseErrors.size(); ++i) {
                errorMsg.append((String)parseErrors.get(i) + "\n");
            }
            Trace.error((Object)this, methodName, "Failed to validate " + profileFilePath);
            Trace.error((Object)this, methodName, errorMsg.toString());
        }
        catch (Exception e) {
            Trace.error((Object)this, methodName, "Failed to validate and load " + profileFilePath);
            Trace.error((Object)this, methodName, e.getMessage());
        }
        String cmd = null;
        try {
            Date now = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmssSSS");
            cmd = "cp -f " + profileFileBackupPath + " " + profileFileBackupPath + "." + formatter.format(now);
            Trace.verbose((Object)this, methodName, "backing up: " + cmd);
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ioe) {
            Trace.verbose((Object)this, methodName, "Failed to backup backup via " + cmd);
        }
        try {
            this.loadAllProfilesFromXml(profileFileBackupPath);
            String theXml = this.getExportXml(null);
            this.validateXml(theXml);
        }
        catch (ConfigMgmtException cme) {
            this.allProfiles = new ArrayList();
            Trace.error((Object)this, methodName, "Failed to load " + profileFileBackupPath);
            Trace.error((Object)this, cme);
        }
        catch (ParseException pe) {
            this.allProfiles = new ArrayList();
            List parseErrors = pe.getParseErrors();
            StringBuffer errorMsg = new StringBuffer();
            for (int i = 0; i < parseErrors.size(); ++i) {
                errorMsg.append((String)parseErrors.get(i) + "\n");
            }
            Trace.error((Object)this, methodName, "Failed to validate " + profileFileBackupPath);
            Trace.error((Object)this, methodName, errorMsg.toString());
        }
        catch (Exception e) {
            this.allProfiles = new ArrayList();
            Trace.error((Object)this, methodName, "Failed to load and validate " + profileFileBackupPath);
            Trace.error((Object)this, methodName, e.getMessage());
        }
        this.storeAllProfilesToXml();
    }

    /*
     * Loose catch block
     */
    private synchronized void loadAllProfilesFromXml(String filename) throws ConfigMgmtException {
        block9: {
            String methodName = "loadAllProfilesFromXml(filename)";
            Trace.methodBegin(this, methodName);
            FileInputStream fis = null;
            fis = new FileInputStream(filename);
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document document = builder.parse(fis);
            this.allProfiles = this.buildListFromDoc(document.getDocumentElement());
            Object var8_9 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                break block9;
            }
            catch (IOException ioe) {
                Trace.verbose((Object)this, methodName, "IOException closing the file input stream.");
            }
            break block9;
            {
                catch (Exception e) {
                    Trace.verbose((Object)this, methodName, (Throwable)e);
                    ConfigMgmtException cme = new ConfigMgmtException("LOAD_PROFILES_ERROR", "Problems loading the list of all profiles.", e);
                    Trace.error((Object)this, cme);
                    Trace.verbose((Object)this, methodName, "Re-initialize list of all profiles.");
                    this.allProfiles = new ArrayList();
                    throw cme;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ioe) {
                    Trace.verbose((Object)this, methodName, "IOException closing the file input stream.");
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void storeAllProfilesToXml() throws ConfigMgmtException {
        block14: {
            String methodName = "storeAllProfilesToXml";
            Trace.methodBegin(this, methodName);
            int BACKUP_INTERVAL = 86400000;
            String cmd = null;
            boolean do_backup = false;
            try {
                File f = new File(profileFileBackupPath);
                if (!f.exists()) {
                    Trace.verbose((Object)this, methodName, "creating new backup");
                    do_backup = true;
                }
                if (System.currentTimeMillis() - f.lastModified() > 86400000L) {
                    Trace.verbose((Object)this, methodName, "updating backup");
                    do_backup = true;
                }
                if (do_backup) {
                    cmd = "cp -f " + profileFilePath + " " + profileFileBackupPath;
                    Runtime.getRuntime().exec(cmd);
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, methodName, "unable to create backup via " + cmd);
            }
            FileOutputStream fos = null;
            fos = new FileOutputStream(profileFilePath);
            String theXml = this.getExportXml(null);
            fos.write(theXml.getBytes());
            Object var9_9 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
                break block14;
            }
            catch (IOException ioe) {
                Trace.verbose((Object)this, methodName, "IOException closing the object output stream.");
            }
            break block14;
            {
                catch (Exception e) {
                    ConfigMgmtException cme = new ConfigMgmtException("PERSIST_PROFILES_ERROR", "Problems persisting the list of all profiles.", e);
                    Trace.error((Object)this, cme);
                    throw cme;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ioe) {
                    Trace.verbose((Object)this, methodName, "IOException closing the object output stream.");
                }
                throw throwable;
            }
        }
    }

    public synchronized List getItemList(ConfigContext context, int profileFilterType) throws ConfigMgmtException {
        String methodName = "getItemList";
        Trace.methodBegin(this, methodName);
        if (context == null || context.getClient() == null) {
            Trace.verbose((Object)this, methodName, "ConfigContext or CIMOMHandleWrapper is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext or CIMOMHandleWrapper is null.");
        }
        CIMOMHandleWrapper handle = context.getClient();
        List itemList = new ArrayList();
        if (profileFilterType == 1) {
            Trace.verbose((Object)this, methodName, "Returning profiles in use.");
            itemList = this.getAllProfilesInUse(context);
        } else if (profileFilterType == 2) {
            Trace.verbose((Object)this, methodName, "Returning profiles not in use.");
            itemList.addAll(this.allProfiles);
            itemList.removeAll(this.getAllProfilesInUse(context));
        } else {
            itemList.addAll(this.allProfiles);
            Trace.verbose((Object)this, methodName, "Returning all <" + itemList.size() + "> profiles.");
        }
        Collections.sort(itemList, new ProfileComparator(context.getLocale()));
        return itemList;
    }

    private List getAllProfilesInUse(ConfigContext context) throws ConfigMgmtException {
        String methodName = "getAllProfilesInUse";
        Trace.methodBegin(this, methodName);
        List profilesInUse = this.getProfilesInUse(context);
        List profilesInUsePending = this.getProfilesInUsePending(context);
        Iterator iter = profilesInUsePending.iterator();
        while (iter.hasNext()) {
            StorageProfile element = (StorageProfile)iter.next();
            if (profilesInUse.contains(element)) continue;
            profilesInUse.add(element);
        }
        return profilesInUse;
    }

    private List getProfilesInUse(ConfigContext context) throws ConfigMgmtException {
        String methodName = "getProfilesInUse";
        Trace.methodBegin(this, methodName);
        ArrayList<StorageProfile> profilesInUse = new ArrayList<StorageProfile>();
        Enumeration poolCapabilities = CIMObjectWrapper.execQuery(context.getClient(), "Select * from SunStorEdge_6120PoolStorageCapabilities");
        if (poolCapabilities != null) {
            while (poolCapabilities.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)poolCapabilities.nextElement();
                String profileName = null;
                StorageProfile profile = null;
                try {
                    profileName = (String)ci.getProperty("Description").getValue().getValue();
                    try {
                        profile = this.getProfile(profileName);
                        if (profilesInUse.contains(profile)) continue;
                        profilesInUse.add(profile);
                    }
                    catch (ItemNotFoundException infe) {
                        if (!Trace.isTraceEnabled(this)) continue;
                        Trace.verbose((Object)this, methodName, "There is no profile with name: " + profileName);
                    }
                }
                catch (NullPointerException npe) {
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, methodName, "Found null 'Description' for object path: " + ci.getObjectPath());
                }
            }
        }
        return profilesInUse;
    }

    private List getProfilesInUsePending(ConfigContext context) throws ConfigMgmtException {
        String methodName = "getProfilesInUsePending";
        Trace.methodBegin(this, methodName);
        ArrayList<StorageProfile> profilesInUsePending = new ArrayList<StorageProfile>();
        Enumeration jobs = CIMObjectWrapper.execQuery(context.getClient(), "Select * from SunStorEdge_6120CreateStoragePoolJob");
        while (jobs.hasMoreElements()) {
            CIMInstance ci = (CIMInstance)jobs.nextElement();
            String ipAddr = null;
            try {
                ipAddr = (String)ci.getProperty("SystemName").getValue().getValue();
            }
            catch (NullPointerException npe) {
                ConfigMgmtException cme = new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems extracting SystemName ConcreteJob property.");
                Trace.error((Object)this, cme);
                throw cme;
            }
            Job j = new Job(ci, context, ipAddr);
            if (!j.isActive()) continue;
            CIMProperty profileName = ci.getProperty("Profile");
            if (profileName != null && profileName.getValue() != null && profileName.getValue().getValue() != null) {
                try {
                    StorageProfile profile = this.getProfile((String)profileName.getValue().getValue());
                    if (profilesInUsePending.contains(profile)) continue;
                    profilesInUsePending.add(profile);
                }
                catch (ItemNotFoundException infe) {
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, methodName, "There is no profile with name: " + profileName);
                }
                continue;
            }
            if (!Trace.isTraceEnabled(this)) continue;
            Trace.verbose((Object)this, methodName, "Found null Profile value for object path: " + ci.getObjectPath());
        }
        return profilesInUsePending;
    }

    public synchronized StorageProfile getProfile(String profileName) throws ItemNotFoundException {
        Trace.methodBegin(this, "getProfile");
        Iterator iter = this.allProfiles.iterator();
        while (iter.hasNext()) {
            StorageProfile profile = (StorageProfile)iter.next();
            if (!profile.getName().equals(profileName)) continue;
            StorageProfile copyProfile = null;
            try {
                copyProfile = (StorageProfile)profile.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new ItemNotFoundException(profileName);
            }
            return copyProfile;
        }
        throw new ItemNotFoundException(profileName);
    }

    public synchronized List getEligibleProfilesForTrays(List trays, T4Interface t4) throws ConfigMgmtException {
        String methodName = "getEligibleProfilesForTrays";
        Trace.methodBegin(this, methodName);
        ArrayList<StorageProfile> allEligibleProfiles = new ArrayList<StorageProfile>();
        int bestMatchArrayType = this.getBestMatchArrayTypeForArray(t4.getArrayConfigurationType());
        boolean arrayHasPools = false;
        int requiredReadaheadMode = -1;
        int requiredSegmentSize = -1;
        if (!t4.getRaidGroups().isEmpty() || t4.getQueuedPoolData().getNumQueuedPools() > 0) {
            requiredReadaheadMode = t4.getReadaheadMode() > 0 ? 1 : 0;
            requiredSegmentSize = t4.getBlockSize();
            arrayHasPools = true;
        }
        boolean isDHSSupported = t4.isFeatureSupported(4);
        Iterator iter = this.allProfiles.iterator();
        while (iter.hasNext()) {
            StorageProfile profile = (StorageProfile)iter.next();
            if (!isDHSSupported && profile.getDedicatedHotSpare() == 1) {
                Trace.verbose((Object)this, methodName, "Dedicated hot spare of the profile <" + profile.getName() + "> is not valid for pool creation on " + "the array with firmware version <" + t4.getFirmwareVersion());
                continue;
            }
            if (!this.isProfileValidForPoolCreation(profile, trays, arrayHasPools, requiredReadaheadMode, requiredSegmentSize, bestMatchArrayType, isDHSSupported)) continue;
            allEligibleProfiles.add(profile);
        }
        Collections.sort(allEligibleProfiles, new ProfileComparator(t4.getConfigContext().getLocale()));
        Trace.verbose((Object)this, methodName, "Number of all eligible profiles is: " + allEligibleProfiles.size());
        return allEligibleProfiles;
    }

    public boolean isProfileValidForPoolCreation(StorageProfile profile, TrayInterface tray, T4Interface t4) throws ConfigMgmtException {
        String methodName = "isProfileValidForPoolCreation";
        Trace.methodBegin(this, methodName);
        if (!t4.isFeatureSupported(4) && profile.getDedicatedHotSpare() == 1) {
            Trace.verbose((Object)this, methodName, "Dedicated hot spare of the profile <" + profile.getName() + "> is not valid for pool creation on " + "the array with firmware version <" + t4.getFirmwareVersion());
            return false;
        }
        boolean arrayHasPools = false;
        int requiredReadaheadMode = -1;
        int requiredSegmentSize = -1;
        if (!t4.getRaidGroups().isEmpty() || t4.getQueuedPoolData().getNumQueuedPools() > 0) {
            requiredReadaheadMode = t4.getReadaheadMode() > 0 ? 1 : 0;
            requiredSegmentSize = t4.getBlockSize();
            arrayHasPools = true;
        }
        ArrayList<TrayInterface> trays = new ArrayList<TrayInterface>();
        trays.add(tray);
        return this.isProfileValidForPoolCreation(profile, trays, arrayHasPools, requiredReadaheadMode, requiredSegmentSize, this.getBestMatchArrayTypeForArray(t4.getArrayConfigurationType()), t4.isFeatureSupported(4));
    }

    private boolean isProfileValidForPoolCreation(StorageProfile profile, List trays, boolean arrayHasPools, int requiredReadaheadMode, int requiredSegmentSize, int bestMatchArrayType, boolean isDHSSupported) throws ConfigMgmtException {
        String methodName = "isProfileValidForPoolCreation";
        Trace.methodBegin(this, methodName);
        if (arrayHasPools && (requiredReadaheadMode != profile.getReadaheadMode() || requiredSegmentSize != profile.getSegmentSize())) {
            Trace.verbose((Object)this, methodName, "Segment size or readahead mode of the profile <" + profile.getName() + "> is not valid for pool creation.");
            return false;
        }
        if (!profile.meetTheArrayType(bestMatchArrayType)) {
            Trace.verbose((Object)this, methodName, "Array type of the profile <" + profile.getName() + "> is not valid for pool creation");
            return false;
        }
        Iterator iterator = trays.iterator();
        while (iterator.hasNext()) {
            TrayInterface tray = (TrayInterface)iterator.next();
            PoolBreakdownForTray pbft = tray.getPoolBreakdownForTray(1, profile.getMinNeededDataDrives(), profile.getRaidLevel(), isDHSSupported ? profile.getDedicatedHotSpare() == 1 : false);
            if (pbft.canBeSupported()) continue;
            Trace.verbose((Object)this, methodName, "Tray " + tray.getId() + " can not support pool creation with profile " + profile.getName());
            return false;
        }
        Trace.verbose((Object)this, methodName, "Profile <" + profile.getName() + "> is eligible for pool creation.");
        return true;
    }

    public synchronized List getMatchingProfilesForReadaheadChange(StorageProfile oldProfile, T4Interface t4) {
        String methodName = "getMatchingProfilesForReadaheadChange";
        Trace.methodBegin(this, methodName);
        ArrayList<StorageProfile> matchingProfiles = new ArrayList<StorageProfile>();
        Iterator iter = this.allProfiles.iterator();
        while (iter.hasNext()) {
            StorageProfile profile = (StorageProfile)iter.next();
            if (oldProfile.getSegmentSize() != profile.getSegmentSize()) {
                Trace.verbose((Object)this, methodName, "Segment size of the profile <" + profile.getName() + "> is not valid for Readahead change.");
                continue;
            }
            if (oldProfile.getReadaheadMode() == profile.getReadaheadMode()) {
                Trace.verbose((Object)this, methodName, "Readahead mode of the profile <" + profile.getName() + "> is not valid for Readahead change.");
                continue;
            }
            if (oldProfile.getRaidLevel() != profile.getRaidLevel()) {
                Trace.verbose((Object)this, methodName, "RAID level of the profile <" + profile.getName() + "> is not valid for Readahead change.");
                continue;
            }
            if (!"variable".equals(profile.getNumberOfDrives()) && profile.getNumberOfDrives() != null && !profile.getNumberOfDrives().equals(oldProfile.getNumberOfDrives())) {
                Trace.verbose((Object)this, methodName, "Number of drives of the profile <" + profile.getName() + "> is not valid for Readahead change.");
                continue;
            }
            if (oldProfile.getArrayType() != profile.getArrayType()) {
                Trace.verbose((Object)this, methodName, "Array type of the profile <" + profile.getName() + "> is not valid for Readahead change.");
                continue;
            }
            if (t4.isFeatureSupported(4)) {
                if (oldProfile.getDedicatedHotSpare() != profile.getDedicatedHotSpare()) {
                    Trace.verbose((Object)this, methodName, "Dedicated hot spare of the profile <" + profile.getName() + "> is not valid for Readahead change.");
                    continue;
                }
            } else if (profile.getDedicatedHotSpare() == 1) {
                Trace.verbose((Object)this, methodName, "Dedicated hot spare of the profile <" + profile.getName() + "> is not valid for Readahead change.");
                continue;
            }
            matchingProfiles.add(profile);
            Trace.verbose((Object)this, methodName, "Profile <" + profile.getName() + "> matches for readahead change.");
        }
        Collections.sort(matchingProfiles, new ProfileComparator(t4.getConfigContext().getLocale()));
        Trace.verbose((Object)this, methodName, "Number of all matching profiles is: " + matchingProfiles.size());
        return matchingProfiles;
    }

    public synchronized List getNonDestructiveProfilesForPool(RaidGroupInterface raidGroup, T4Interface t4) throws ConfigMgmtException {
        String methodName = "getNonDestructiveProfilesForPool";
        Trace.methodBegin(this, methodName);
        ArrayList<StorageProfile> nonDestructiveProfiles = new ArrayList<StorageProfile>();
        int bestMatchArrayType = this.getBestMatchArrayTypeForArray(t4.getArrayConfigurationType());
        boolean moreThenOnePoolOnArray = false;
        int requiredReadaheadMode = -1;
        if (t4.getRaidGroups().size() > 1 || t4.getQueuedPoolData().getNumQueuedPools() > 0) {
            requiredReadaheadMode = t4.getReadaheadMode() > 0 ? 1 : 0;
            moreThenOnePoolOnArray = true;
        }
        boolean isDHSAvailable = this.isDHSAvailable(raidGroup, t4);
        boolean isDHSSupported = t4.isFeatureSupported(4);
        Iterator iter = this.allProfiles.iterator();
        while (iter.hasNext()) {
            StorageProfile profile = (StorageProfile)iter.next();
            if (!isDHSSupported && profile.getDedicatedHotSpare() == 1) {
                Trace.verbose((Object)this, methodName, "Dedicated hot spare of the profile <" + profile.getName() + "> is not valid for pool creation on " + "the array with firmware version <" + t4.getFirmwareVersion());
                continue;
            }
            if (!this.isProfileNonDestructiveForPool(profile, raidGroup, moreThenOnePoolOnArray, requiredReadaheadMode, t4.getBlockSize(), bestMatchArrayType, isDHSAvailable, isDHSSupported)) continue;
            nonDestructiveProfiles.add(profile);
        }
        Collections.sort(nonDestructiveProfiles, new ProfileComparator(t4.getConfigContext().getLocale()));
        Trace.verbose((Object)this, methodName, "Number of all non-destructive profiles for the pool <" + raidGroup.getName() + "> is: " + nonDestructiveProfiles.size());
        return nonDestructiveProfiles;
    }

    public boolean isProfileNonDestructiveForPool(StorageProfile profile, RaidGroupInterface raidGroup, T4Interface t4) throws ConfigMgmtException {
        String methodName = "isProfileNonDestructiveForPool";
        Trace.methodBegin(this, methodName);
        if (!t4.isFeatureSupported(4) && profile.getDedicatedHotSpare() == 1) {
            Trace.verbose((Object)this, methodName, "Dedicated hot spare of the profile <" + profile.getName() + "> is not valid for pool creation on " + "the array with firmware version <" + t4.getFirmwareVersion());
            return false;
        }
        boolean moreThenOnePoolOnArray = false;
        int requiredReadaheadMode = -1;
        if (t4.getRaidGroups().size() > 1 || t4.getQueuedPoolData().getNumQueuedPools() > 0) {
            requiredReadaheadMode = t4.getReadaheadMode() > 0 ? 1 : 0;
            moreThenOnePoolOnArray = true;
        }
        return this.isProfileNonDestructiveForPool(profile, raidGroup, moreThenOnePoolOnArray, requiredReadaheadMode, t4.getBlockSize(), this.getBestMatchArrayTypeForArray(t4.getArrayConfigurationType()), this.isDHSAvailable(raidGroup, t4), t4.isFeatureSupported(4));
    }

    private boolean isDHSAvailable(RaidGroupInterface raidGroup, T4Interface t4) throws ConfigMgmtException {
        String methodName = "isDHSAvailable";
        Trace.methodBegin(this, methodName);
        boolean isDHSAvailable = false;
        if (t4.isFeatureSupported(4) && raidGroup instanceof RaidGroup) {
            List allTrays = t4.getTrays();
            Iterator iter = allTrays.iterator();
            while (iter.hasNext()) {
                TrayInterface tray = (TrayInterface)iter.next();
                if (!tray.getId().equals(((RaidGroup)raidGroup).getTrayId())) continue;
                isDHSAvailable = tray.isDedicatedHotSpareAvailable(raidGroup.getEffectiveDiskSize());
                Trace.verbose((Object)this, methodName, "Dedicated hot spare change allowed. = " + isDHSAvailable);
                break;
            }
        }
        return isDHSAvailable;
    }

    private boolean isProfileNonDestructiveForPool(StorageProfile profile, RaidGroupInterface raidGroup, boolean moreThenOnePoolOnArray, int requiredReadaheadMode, int requiredSegmentSize, int bestMatchArrayType, boolean isDHSAvailable, boolean isDHSSupported) throws ConfigMgmtException {
        String methodName = "isProfileNonDestructiveForPool";
        Trace.methodBegin(this, methodName);
        if (raidGroup.getProfileName().equals(profile.getName())) {
            Trace.verbose((Object)this, methodName, "Pool already using profile with name: " + profile.getName());
            return false;
        }
        if (requiredSegmentSize != profile.getSegmentSize()) {
            Trace.verbose((Object)this, methodName, "Segment size of the profile <" + profile.getName() + "> not valid for pool modification.");
            return false;
        }
        if (moreThenOnePoolOnArray && requiredReadaheadMode != profile.getReadaheadMode()) {
            Trace.verbose((Object)this, methodName, "Readahead mode of the profile <" + profile.getName() + "> not valid for pool modification.");
            return false;
        }
        if (raidGroup.getRaidLevel() != profile.getRaidLevel()) {
            Trace.verbose((Object)this, methodName, "Raid level of the profile <" + profile.getName() + "> not valid for pool modification.");
            return false;
        }
        if (!"variable".equals(profile.getNumberOfDrives()) && profile.getNumberOfDrives() != null && !profile.getNumberOfDrives().equals(raidGroup.getNumberOfDrives() + "")) {
            Trace.verbose((Object)this, methodName, "Number of drives of the profile <" + profile.getName() + "> not valid for pool modification.");
            return false;
        }
        if (!profile.meetTheArrayType(bestMatchArrayType)) {
            Trace.verbose((Object)this, methodName, "Array type of the profile <" + profile.getName() + "> not valid for pool modification.");
            return false;
        }
        if (isDHSSupported && !isDHSAvailable && raidGroup instanceof RaidGroup && ((RaidGroup)raidGroup).getUseHotSpare() == 0 && profile.getDedicatedHotSpare() == 1) {
            Trace.verbose((Object)this, methodName, "Hot spare usage of the profile <" + profile.getName() + "> not valid for pool modification.");
            return false;
        }
        Trace.verbose((Object)this, methodName, "Profile <" + profile.getName() + "> is non-destructive for the pool <" + raidGroup.getName() + ">.");
        return true;
    }

    public synchronized StorageProfile getOrCreateMatchingProfile(int raidLevel, int numberOfDrives, int usesDedicatedHotSpare, String arrayName, ConfigContext context) throws ConfigMgmtException {
        String methodName = "getOrCreateMatchingProfile";
        Trace.methodBegin(this, methodName);
        T4Interface t4 = null;
        List allExistingProfiles = this.getItemList(context, 0);
        HashMap<String, StorageProfile> doNotMatch = new HashMap<String, StorageProfile>();
        HashMap<String, StorageProfile> doMatchInUseOnSystem = new HashMap<String, StorageProfile>();
        ManageT4sInterface mT4s = ManageT4sFactory.getManager();
        mT4s.init(context, null);
        t4 = mT4s.getT4ByName(arrayName);
        String newProfileName = this.createNewProfileName(raidLevel);
        StorageProfile resultProfile = new StorageProfile(newProfileName, "", raidLevel, t4.getBlockSize(), t4.getReadaheadMode() > 0 ? 1 : 0, numberOfDrives + "", t4.isFeatureSupported(4) ? usesDedicatedHotSpare : 0, this.getBestMatchArrayTypeForArray(t4.getArrayConfigurationType()));
        Enumeration poolCapabilities = CIMObjectWrapper.execQuery(context.getClient(), "Select * from SunStorEdge_6120PoolStorageCapabilities");
        if (poolCapabilities != null && poolCapabilities.hasMoreElements()) {
            Collection col;
            Iterator iter;
            while (poolCapabilities.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)poolCapabilities.nextElement();
                String tmpProfileName = null;
                String tmpIpAddress = null;
                StorageProfile tmpProfile = null;
                boolean tmpProfileExists = false;
                try {
                    tmpProfileName = (String)ci.getProperty("Description").getValue().getValue();
                    tmpIpAddress = (String)ci.getProperty("Caption").getValue().getValue();
                }
                catch (NullPointerException npe) {
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, methodName, "Description or IP address null for object path: " + ci.getObjectPath());
                    continue;
                }
                try {
                    if (doNotMatch.containsKey(tmpProfileName) || doMatchInUseOnSystem.containsKey(tmpProfileName)) continue;
                    tmpProfile = this.getProfile(tmpProfileName);
                    tmpProfileExists = true;
                }
                catch (ItemNotFoundException infe) {
                    // empty catch block
                }
                if (!tmpProfileExists) continue;
                if (tmpProfile.meetTheSettings(resultProfile)) {
                    if (t4.getClusterName().equals(tmpIpAddress)) {
                        return tmpProfile;
                    }
                    doMatchInUseOnSystem.put(tmpProfile.getName(), tmpProfile);
                    continue;
                }
                doNotMatch.put(tmpProfile.getName(), tmpProfile);
            }
            Trace.verbose((Object)this, methodName, "No matches used on same array.");
            if (doMatchInUseOnSystem.size() > 0 && (iter = (col = doMatchInUseOnSystem.values()).iterator()).hasNext()) {
                return (StorageProfile)iter.next();
            }
            Trace.verbose((Object)this, methodName, "No matches used on the system.");
        }
        Iterator iter = allExistingProfiles.iterator();
        while (iter.hasNext()) {
            StorageProfile element = (StorageProfile)iter.next();
            if (doNotMatch.containsValue(element) || !element.meetTheSettings(resultProfile)) continue;
            return element;
        }
        Trace.verbose((Object)this, methodName, "No matches at all.");
        if ("storage".equals(context.getUser())) {
            resultProfile.setNumberOfDrives("variable");
            resultProfile.save(context);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, methodName, "Created new <" + resultProfile.getName() + "> profile");
            }
        }
        return resultProfile;
    }

    public synchronized String createNewProfileName(int raidLevel) throws ConfigMgmtException {
        String methodName = "createNewProfileName";
        Trace.methodBegin(this, methodName);
        String newProfileName = null;
        boolean newNameCreated = false;
        for (int n = 1; n < 1000; ++n) {
            newProfileName = "Profile " + n + " for RAID " + raidLevel;
            try {
                this.getProfile(newProfileName);
                continue;
            }
            catch (ItemNotFoundException infe) {
                newNameCreated = true;
                break;
            }
        }
        if (!newNameCreated) {
            ConfigMgmtException cme = new ConfigMgmtException("CREATE_PROFILE_NAME_ERROR", "Unable to create unique profile name.");
            Trace.error((Object)this, cme);
            throw cme;
        }
        Trace.verbose((Object)this, methodName, "Created new unique tmp name is: " + newProfileName);
        return newProfileName;
    }

    protected synchronized void addProfileToList(StorageProfile profile) throws ConfigMgmtException {
        Trace.methodBegin(this, "addProfileToList");
        this.allProfiles.add(profile);
        this.storeAllProfilesToXml();
    }

    protected synchronized void updateProfileInList(StorageProfile oldProfile, StorageProfile newProfile) throws ConfigMgmtException {
        Trace.methodBegin(this, "updateProfileInList");
        this.allProfiles.remove(oldProfile);
        this.allProfiles.add(newProfile);
        this.storeAllProfilesToXml();
    }

    protected synchronized void deleteProfileFromList(StorageProfile profile) throws ConfigMgmtException {
        Trace.methodBegin(this, "deleteProfileFromList");
        this.allProfiles.remove(profile);
        this.storeAllProfilesToXml();
    }

    public int[] getPossibleArrayTypesForArray(int arrayConfiguration) throws ConfigMgmtException {
        String methodName = "getPossibleArrayTypesForArray";
        Trace.methodBegin(this, methodName);
        int[] arrayTypes = new int[]{4, 5, 3, -1};
        switch (arrayConfiguration) {
            case 2: 
            case 8: {
                arrayTypes[3] = 0;
                return arrayTypes;
            }
            case 1: 
            case 4: {
                arrayTypes[3] = 1;
                return arrayTypes;
            }
            case 3: 
            case 12: {
                arrayTypes[3] = 2;
                return arrayTypes;
            }
        }
        ConfigMgmtException cme = new ConfigMgmtException("UNSUPPORTED_CONFIGURATION_ERROR", "Unable to obtain possible array types for configuration: " + arrayConfiguration);
        Trace.error((Object)this, cme);
        throw cme;
    }

    public int getBestMatchArrayTypeForArray(int arrayConfiguration) throws ConfigMgmtException {
        String methodName = "getBestMatchArrayTypeForArray";
        Trace.methodBegin(this, methodName);
        switch (arrayConfiguration) {
            case 2: 
            case 8: {
                return 3;
            }
            case 1: 
            case 4: {
                return 4;
            }
            case 3: 
            case 12: {
                return 5;
            }
        }
        ConfigMgmtException cme = new ConfigMgmtException("UNSUPPORTED_CONFIGURATION_ERROR", "Unable to obtain best match array type for configuration: " + arrayConfiguration);
        Trace.error((Object)this, cme);
        throw cme;
    }

    public String getExportXml(List profileList) throws ItemNotFoundException, ConfigMgmtException {
        List profiles = profileList;
        if (profileList == null) {
            profiles = this.allProfiles;
        }
        StringBuffer theXml = new StringBuffer();
        theXml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        theXml.append("<sscs_storage_profiles xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        for (int i = 0; i < profiles.size(); ++i) {
            StorageProfile thisProfile = (StorageProfile)profiles.get(i);
            theXml.append(thisProfile.toXml());
        }
        theXml.append(XML_ROOT_E);
        return theXml.toString();
    }

    public List getXmlContentsForImport(ConfigContext context, String xml) throws ConfigMgmtException, ParseException, Exception {
        this.validateXml(xml);
        StringReader reader = new StringReader(xml);
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(reader));
        List theProfiles = this.buildListFromDoc(document.getDocumentElement());
        for (int i = 0; i < theProfiles.size(); ++i) {
            StorageProfile newProfile = (StorageProfile)theProfiles.get(i);
            StorageProfile systemProfile = null;
            try {
                systemProfile = this.getProfile(newProfile.getName());
            }
            catch (ItemNotFoundException infe) {
                List dups = newProfile.getProfilesWithDuplicateSettings(context);
                if (dups.size() == 0) {
                    newProfile.setImportStatus(0);
                    continue;
                }
                newProfile.setImportStatus(2);
                continue;
            }
            if (systemProfile.inUse(context)) {
                newProfile.setImportStatus(1);
                continue;
            }
            if (systemProfile.equalSettings(newProfile)) {
                newProfile.setImportStatus(4);
                continue;
            }
            newProfile.setImportStatus(3);
        }
        return theProfiles;
    }

    public ProfileComparator getProfileComparator(Locale l) {
        return new ProfileComparator(l);
    }

    private void validateXml(String theXml) throws ParseException, Exception {
        String METHOD_NAME = "validateXml";
        Trace.methodBegin(this, "validateXml");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        profileFilePath = DEFAULT_PROFILE_FILE_PATH;
        profileFileBackupPath = "/opt/se6x20/resources/StorageProfiles.xml.bkup";
        profileXsdPath = DEFAULT_PROFILE_XSD_PATH;
    }

    private class ParseHandler
    extends DefaultHandler {
        private ParseHandler() {
        }

        public void error(SAXParseException e) {
            ManageStorageProfiles.this.parseErrors.add("Line " + e.getLineNumber() + ": " + e.getMessage());
        }

        public void fatalError(SAXParseException e) {
            ManageStorageProfiles.this.parseErrors.add("Line " + e.getLineNumber() + ": " + e.getMessage());
        }
    }

    public class ProfileComparator
    implements Comparator {
        Collator collator = null;

        ProfileComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof StorageProfile && element2 instanceof StorageProfile) {
                key1 = this.collator.getCollationKey(((StorageProfile)element1).getName());
                key2 = this.collator.getCollationKey(((StorageProfile)element2).getName());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

