/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.license.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.license.License;
import com.sun.netstorage.array.mgmt.cfg.license.LicenseManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.license.Summary;
import com.sun.netstorage.array.mgmt.cfg.license.impl.ent1.LicenseImpl;
import com.sun.netstorage.array.mgmt.cfg.license.impl.ent1.SummaryImpl;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt64;

public class LicenseManager
implements LicenseManagerInterface {
    static HashMap f2c = new HashMap();
    static String[] featureNames;
    private ConfigContext configContext;

    public void init(ConfigContext cfgctx) {
        this.configContext = cfgctx;
    }

    public Summary[] getSummary() {
        String METHOD = "getSummary";
        Trace.methodBegin(this, "getSummary");
        Vector<SummaryImpl> l = new Vector<SummaryImpl>();
        try {
            CIMOMHandleWrapper cimClient = this.configContext.getClient();
            f2c = new HashMap();
            if (f2c.size() == 0) {
                Enumeration f2cEnum = cimClient.enumerateInstances(new CIMObjectPath("SunStorEdge_6x20Feature2Class"), false, false, true, false, null);
                if (f2cEnum == null) {
                    Trace.verbose((Object)this, "getSummary", "No Feature2Class instances found.");
                    return new Summary[0];
                }
                while (f2cEnum.hasMoreElements()) {
                    Trace.verbose((Object)this, "getSummary", "Feature2Class found.");
                    CIMInstance ci = (CIMInstance)f2cEnum.nextElement();
                    f2c.put(this.extractStr(ci, "ClassName"), this.extractStr(ci, "FeatureName"));
                }
            }
            HashMap x = f2c;
            CIMObjectPath licenseOP = new CIMObjectPath("SunStorEdge_LicensedSoftwareFeature");
            Enumeration licenseEnum = cimClient.enumerateInstances(licenseOP, false, false, true, false, null);
            if (licenseEnum == null) {
                Trace.verbose((Object)this, "getSummary", "No licenses found.");
                return new Summary[0];
            }
            while (licenseEnum.hasMoreElements()) {
                Trace.verbose((Object)this, "getSummary", "License found.");
                CIMInstance ci = (CIMInstance)licenseEnum.nextElement();
                SummaryImpl sl = new SummaryImpl();
                if (!f2c.containsKey(ci.getClassName())) continue;
                sl.featureName = (String)f2c.get(ci.getClassName());
                sl.amountLicensed = this.extractLong(ci, "AmountLicensed");
                sl.amountInUse = this.extractLong(ci, "AmountInUse");
                l.add(sl);
            }
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "getSummary", e);
        }
        Object[] many = new Summary[l.size()];
        l.copyInto(many);
        return many;
    }

    public License[] getLicenses() {
        String METHOD = "getLicenses";
        CIMOMHandleWrapper cimClient = this.configContext.getClient();
        CIMObjectPath licenseOP = new CIMObjectPath("SunStorEdge_6x20LicenseKey");
        Enumeration licenseEnum = null;
        try {
            licenseEnum = cimClient.enumerateInstances(licenseOP, false, false, true, false, null);
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "getLicenses", e);
        }
        if (licenseEnum == null) {
            Trace.verbose((Object)this, "getLicenses", "No license keys found.");
            return new License[0];
        }
        Vector<LicenseImpl> l = new Vector<LicenseImpl>();
        while (licenseEnum.hasMoreElements()) {
            Trace.verbose((Object)this, "getLicenses", "License keys found.");
            CIMInstance ci = (CIMInstance)licenseEnum.nextElement();
            LicenseImpl sl = new LicenseImpl(this.extractStr(ci, "FeatureName"), this.extractLong(ci, "Amount"), this.extractLong(ci, "LicenseId"), this.extractStr(ci, "SystemId"), this.extractDate(ci, "Expiration"), this.extractStr(ci, "LicenseKey"));
            l.add(sl);
        }
        Object[] many = new License[l.size()];
        l.copyInto(many);
        return many;
    }

    private Date extractDate(CIMInstance ci, String string) {
        CIMProperty cp = ci.getProperty(string);
        CIMValue cv = cp.getValue();
        if (cv == null) {
            return null;
        }
        CIMDateTime o = (CIMDateTime)cv.getValue();
        return o.getCalendar().getTime();
    }

    private long extractLong(CIMInstance ci, String string) {
        String METHOD = "extractLong";
        Trace.verbose((Object)this, "extractLong", "Extracting " + string);
        UnsignedInt64 o = (UnsignedInt64)ci.getProperty(string).getValue().getValue();
        return o.longValue();
    }

    private String extractStr(CIMInstance ci, String string) {
        return ci.getProperty(string).getValue().getValue().toString();
    }

    public boolean add(String key) {
        String METHOD = "add";
        Trace.methodBegin(this, "add");
        return this.cimDo("Add", key);
    }

    public void remove(String key) {
        this.cimDo("Remove", key);
    }

    private boolean cimDo(String cmd, String key) {
        String METHOD = "cimDo";
        try {
            CIMOMHandleWrapper cimClient = this.configContext.getClient();
            CIMObjectPath licenseOP = new CIMObjectPath("SunStorEdge_6x20LicenseService");
            CIMInstance ci = (CIMInstance)cimClient.enumerateInstances(licenseOP, false, false, true, false, null).nextElement();
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("licenseKey", new CIMValue((Object)key))};
            Trace.verbose((Object)this, "cimDo", "Calling add method...");
            CIMValue returnCodeValue = cimClient.invokeMethod(ci.getObjectPath(), cmd, inArgs, null);
            if (returnCodeValue.equals((Object)CIMValue.TRUE)) {
                Trace.verbose((Object)this, "cimDo", "Add call returned true.");
                return true;
            }
            Trace.verbose((Object)this, "cimDo", "Add call returned false.");
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, "cimDo", e);
        }
        return false;
    }
}

