/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageVolumeCopy;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.VolumeCopyMO;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.StorageJobElement;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.StorageJobStatus;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.StorageJobType;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.common.ManageStorageJobsCommon;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.oz.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.oz.OZStorageJobType;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.oz.StorageJob;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ArrayImportManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeAction;
import devmgr.versioned.symbol.VolumeActionProgress;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManageStorageJobs
extends ManageStorageJobsCommon {
    private static final long SHOW_JOBS_WITHIN_TIME_PERIOD = 8640000L;
    public static final String VOLUME_JOBID_PREFIX = "VOL:";
    public static final String ARRAY_IMPORT_JOBID = "IMPORT";
    public static final String VOLUME_COPY_JOBID_PREFIX = "VC:";
    public static final int MAX_PRIORITY = 4;
    VolumeCopyMO[] volumeCopyMOs = null;
    HashMap volumeCopyJobsMap = null;
    HashMap volumeJobsMap = null;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$Volume;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$VolumeCopyMO;

    public List getItemList() throws ConfigMgmtException {
        if (this.filter != null) {
            return this.getJobs(this.filter);
        }
        return this.getAllJobs();
    }

    public int getMaxObjects() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodCallStatus kill(List list) throws ConfigMgmtException {
        String METHOD_NAME = "kill";
        Trace.methodBegin(this, "kill");
        if (list == null || list.size() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "error.Job.details.nonexistent");
        }
        Object[] keys = list.toArray(new Object[list.size()]);
        MethodCallStatus mcs = new MethodCallStatus();
        String arrayID = Convert.scopeToArrayKey(this.scope);
        ArrayList<String> jobsToKill = new ArrayList<String>();
        for (int i = 0; i < keys.length; ++i) {
            ErrorDescriptor errorDesc;
            String keyMap = null;
            Map map = null;
            if (keys[i] instanceof Map) {
                map = (Map)keys[i];
                keyMap = Convert.keyToString((Map)keys[i]);
            } else if (keys[i] instanceof String) {
                keyMap = (String)keys[i];
                map = Convert.keyAsStringToMap(keyMap);
            } else {
                errorDesc = new ErrorDescriptor(ErrorCode.ERROR_ILLEGAL_ARGUMENT);
                String object = null;
                object = keys[i] != null ? keys[i].toString() : "null";
                errorDesc.setI18nParams(new String[]{object});
                mcs.addErrorDescriptor(errorDesc);
                mcs.setReturnCode(2);
                continue;
            }
            if (!arrayID.equals((String)map.get("array"))) {
                errorDesc = new ErrorDescriptor(ErrorCode.ERROR_ILLEGAL_ARGUMENT);
                errorDesc.setI18nParams(new String[]{keys[i].toString()});
                errorDesc.setMsg("ARRAY key and scope ARRAY key don't agree.");
                mcs.addErrorDescriptor(errorDesc);
                mcs.setReturnCode(2);
                continue;
            }
            jobsToKill.add((String)map.get("id"));
        }
        if (jobsToKill.size() > 0) {
            List jobList = this.getItemList();
            JobInterface[] storageJob = jobList.toArray(new JobInterface[jobList.size()]);
            try {
                for (int i = 0; i < storageJob.length; ++i) {
                    ErrorDescriptor errorDesc;
                    JobInterface job = storageJob[i];
                    Map map = job.getKey();
                    String jobID = (String)map.get("id");
                    if (!jobsToKill.contains(jobID)) continue;
                    if (!job.isKillable()) {
                        errorDesc = new ErrorDescriptor(ErrorCode.JOB_CAN_NOT_BE_KILLED);
                        errorDesc.setI18nParams(new String[]{(String)job.getKey().get("id")});
                        mcs.addErrorDescriptor(errorDesc);
                        mcs.setReturnCode(2);
                    } else {
                        errorDesc = this.killJob((StorageJob)job);
                        if (!errorDesc.getErrCode().equals(ErrorCode.JOB_KILL_SUCCESSFULL) && !errorDesc.getErrCode().equals(ErrorCode.SUCCESS)) {
                            mcs.setReturnCode(2);
                        }
                        mcs.addErrorDescriptor(errorDesc);
                    }
                    int index = jobsToKill.indexOf(jobID);
                    if (index == -1) continue;
                    jobsToKill.remove(index);
                }
            }
            finally {
                this.flushCachedData();
            }
            if (jobsToKill.size() > 0) {
                String[] id = jobsToKill.toArray(new String[jobsToKill.size()]);
                for (int i = 0; i < id.length; ++i) {
                    ErrorDescriptor errorDesc = new ErrorDescriptor(ErrorCode.JOB_KILL_JOB_NOT_FOUND);
                    errorDesc.setI18nParams(new String[]{id[i]});
                    mcs.addErrorDescriptor(errorDesc);
                }
                mcs.setReturnCode(2);
            }
        }
        return mcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        if (key == null || props == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply non-null key and Properties object for modify.");
        }
        Map keyMap = null;
        if (key instanceof Map) {
            keyMap = (Map)key;
        } else if (key instanceof String) {
            keyMap = Convert.keyAsStringToMap((String)key);
        }
        if (keyMap == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_ILLEGAL_ARGUMENT.getKey(), "Key must be of type java.util.Map or java.lang.String");
        }
        String jobID = (String)keyMap.get("id");
        JobInterface job = this.getJob(jobID);
        if (job == null) {
            throw new SEItemNotFoundException(jobID);
        }
        try {
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propName = (String)enumeration.nextElement();
                Trace.verbose((Object)this, "modify", "Processing request: " + propName);
                String propValue = props.getProperty(propName);
                if (propValue == null) {
                    throw new ConfigMgmtException("incorrect.method.parameter", "Must supply non-null property value for modify.");
                }
                if (propName.equals("priority")) {
                    this.modifyJobPriority((StorageJob)job, propValue);
                    continue;
                }
                throw new ConfigMgmtException("incorrect.method.parameter", "Unknown modify request: " + propName);
            }
        }
        finally {
            this.flushCachedData();
        }
    }

    private void flushCachedData() {
        this.volumeJobsMap = null;
        this.volumeCopyJobsMap = null;
        this.volumeCopyMOs = null;
    }

    private List getJobs(SearchFilter filter) throws ConfigMgmtException {
        String searchField;
        String METHOD_NAME = "getJobs";
        ArrayList<JobInterface> jobList = new ArrayList<JobInterface>();
        if (filter != null && !filter.isEmpty() && (searchField = filter.getSearchField()) != null) {
            JobInterface job = null;
            if (searchField.equals("id")) {
                String jobID = filter.getSearchString();
                if (jobID != null) {
                    job = this.getJob(jobID);
                    if (job != null) {
                        jobList.add(job);
                    }
                } else {
                    List list = this.getAllJobs();
                    JobInterface[] canidate = list.toArray(new JobInterface[list.size()]);
                    for (int i = 0; i < canidate.length; ++i) {
                        if (!filter.passesFilter(canidate[i].getName())) continue;
                        jobList.add(canidate[i]);
                    }
                }
            } else if (filter.getSearchField().equals("keyAsString")) {
                Map map;
                String jobID;
                String keyAsString = filter.getSearchString();
                if (keyAsString != null && (jobID = (String)(map = Convert.keyAsStringToMap(keyAsString)).get("id")) != null && (job = this.getJob(jobID)) != null) {
                    jobList.add(job);
                }
            } else {
                Trace.verbose((Object)this, "getJobs", "Search field not supported: " + filter.getSearchField());
                throw new ConfigMgmtException("error.search.field.not.supported", "error.search.field.not.supported: " + filter.getSearchField());
            }
        }
        return jobList;
    }

    private JobInterface getJob(String jobID) throws ConfigMgmtException {
        HashMap lookupMap = null;
        if (jobID.startsWith(VOLUME_JOBID_PREFIX)) {
            lookupMap = this.getVolumeJobs();
        } else if (jobID.startsWith(VOLUME_COPY_JOBID_PREFIX)) {
            lookupMap = this.getVolumeCopyJobs();
        } else if (jobID.startsWith(ARRAY_IMPORT_JOBID)) {
            lookupMap = this.getArrayImportJobs();
        } else {
            return null;
        }
        JobInterface job = (JobInterface)lookupMap.get(jobID);
        return job;
    }

    private List getAllJobs() throws ConfigMgmtException {
        ArrayList jobList = new ArrayList();
        jobList.addAll(this.getVolumeCopyJobs().values());
        jobList.addAll(this.getVolumeJobs().values());
        jobList.addAll(this.getArrayImportJobs().values());
        return jobList;
    }

    private HashMap getVolumeJobs() throws ConfigMgmtException {
        String METHOD_NAME = "getVolumeJobs";
        Trace.methodBegin(this, "getVolumeJobs");
        if (this.volumeJobsMap != null) {
            Trace.verbose((Object)this, "getVolumeJobs", "Using cached volume job map");
            return this.volumeJobsMap;
        }
        this.volumeJobsMap = new HashMap();
        String arrayID = Convert.scopeToArrayKey(this.scope);
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        ObjectBundle objectBundle = manager.getObjectBundle(arrayID);
        try {
            List volList;
            int i;
            HashMap map = new HashMap();
            Controller[] controllers = objectBundle.getController();
            for (int i2 = 0; i2 < controllers.length; ++i2) {
                map.put(Convert.bytesToString(controllers[i2].getControllerRef().getRefToken()), new ArrayList());
            }
            Volume[] volumes = objectBundle.getVolume();
            for (i = 0; i < volumes.length; ++i) {
                VolumeAction action = volumes[i].getAction();
                if (Trace.isTraceEnabled(this)) {
                    String volumeName = this.getVolumeName(volumes[i]);
                    if (volumeName.length() == 0) {
                        volumeName = Convert.bytesToString(volumes[i].getWorldWideName());
                    }
                    Trace.verbose((Object)this, "getVolumeJobs", "Volume " + volumeName + " action=" + action.getValue());
                }
                if (action == null || action.getValue() == 1) continue;
                volList = (List)map.get(Convert.bytesToString(volumes[i].getPreferredManager().getRefToken()));
                if (volList == null) {
                    Trace.error((Object)this, "getVolumeJobs", "Lookup of volume list failed for volume " + this.getVolumeName(volumes[i]));
                    continue;
                }
                volList.add(volumes[i]);
            }
            for (i = 0; i < controllers.length; ++i) {
                String contRef = Convert.bytesToString(controllers[i].getControllerRef().getRefToken());
                volList = (List)map.get(contRef);
                volumes = volList.toArray(new Volume[volList.size()]);
                if (volumes.length <= 0) continue;
                CommandProcessor command = this.getCommandProcessor(arrayID);
                command.setPreferredController(contRef);
                for (int v = 0; v < volumes.length; ++v) {
                    StorageJob job = new StorageJob();
                    String volWWN = Convert.bytesToString(volumes[v].getWorldWideName());
                    String jobID = VOLUME_JOBID_PREFIX + ManageVolumes.getVolumeID(volumes[v].getWorldWideName());
                    HashMap<String, String> keyMap = new HashMap<String, String>(2);
                    keyMap.put("array", arrayID);
                    keyMap.put("id", jobID);
                    job.setName(jobID);
                    job.setKey(keyMap);
                    Map volKeyMap = ManageVolumes.getVolumeKeyMap(arrayID, Convert.bytesToStringRaw(volumes[v].getVolumeRef().getRefToken()), UnicodeTranslator.getString((byte[])volumes[v].getLabel().getValue()), Convert.bytesToString(volumes[v].getWorldWideName()));
                    StorageJobElement jobElement = new StorageJobElement(volWWN, class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$Volume == null ? ManageStorageJobs.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Volume") : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$Volume, volKeyMap, UnicodeTranslator.getString((byte[])volumes[v].getLabel().getValue()));
                    job.setOwningJobElement(jobElement);
                    job.addEffectedJobElement(jobElement);
                    job.setPriority(new Integer(volumes[v].getReconPriority()));
                    job.setType(this.getStorageJobType(volumes[v].getAction()));
                    VolumeActionProgress vap = new VolumeActionProgress();
                    command.execute(41, (XDRType)volumes[v].getVolumeRef(), (XDRType)vap, false);
                    int percentComplete = vap.getPercentComplete();
                    StorageJobStatus status = StorageJobStatus.UNKNOWN;
                    switch (percentComplete) {
                        case 0: {
                            status = StorageJobStatus.PENDING;
                            break;
                        }
                        case 100: {
                            status = StorageJobStatus.COMPLETED_OK;
                            break;
                        }
                        default: {
                            if (percentComplete <= 0 || percentComplete >= 100) break;
                            status = StorageJobStatus.RUNNING;
                        }
                    }
                    if (percentComplete < 0) {
                        job.setPercentComplete(null);
                    } else {
                        job.setPercentComplete(new Integer(percentComplete));
                    }
                    long timeToCompletion = vap.getTimeToCompletion();
                    if (timeToCompletion == -1L) {
                        job.setTimeToCompletion(null);
                    } else {
                        job.setTimeToCompletion(new Long(timeToCompletion));
                    }
                    job.setStatus(status);
                    this.volumeJobsMap.put(jobID, job);
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, "getVolumeJobs", "Adding Volume JOB: " + job.toString());
                }
            }
        }
        catch (ConfigMgmtException cme) {
            this.volumeJobsMap = null;
            throw cme;
        }
        catch (Exception e) {
            this.volumeJobsMap = null;
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), "Caught unexpected exception", e);
        }
        return this.volumeJobsMap;
    }

    private CommandProcessor getCommandProcessor(String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "getCommandProcessor";
        Trace.methodBegin(this, "getCommandProcessor");
        try {
            return new CommandProcessor(arrayWwn);
        }
        catch (RPCError e) {
            Trace.error((Object)this, "getCommandProcessor", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPCError trying to instantiate CommandProcessor.", (Exception)((Object)e));
        }
        catch (IOException e) {
            Trace.error((Object)this, "getCommandProcessor", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IOException trying to instantiate CommandProcessor.", e);
        }
    }

    private HashMap getArrayImportJobs() throws ConfigMgmtException {
        String METHOD_NAME = "getArrayImportJobs";
        HashMap<String, StorageJob> jobMap = new HashMap<String, StorageJob>();
        String arrayID = Convert.scopeToArrayKey(this.scope);
        ArrayImportManager aim = ArrayImportManager.getInstance();
        if (aim.isImporting(arrayID)) {
            StorageJob job = new StorageJob();
            String jobId = ARRAY_IMPORT_JOBID;
            job.setName(jobId);
            HashMap<String, String> keyMap = new HashMap<String, String>(2);
            keyMap.put("array", arrayID);
            keyMap.put("id", jobId);
            job.setKey(keyMap);
            int percentComplete = aim.getPercentComplete(arrayID);
            job.setPercentComplete(new Integer(percentComplete));
            StorageJobStatus status = StorageJobStatus.UNKNOWN;
            Trace.verbose((Object)this, "getArrayImportJobs", "%: " + percentComplete);
            switch (percentComplete) {
                case 0: {
                    status = StorageJobStatus.PENDING;
                    break;
                }
                case 100: {
                    status = StorageJobStatus.COMPLETED_OK;
                    break;
                }
                default: {
                    if (percentComplete <= 0 || percentComplete >= 100) break;
                    status = StorageJobStatus.RUNNING;
                }
            }
            job.setStatus(status);
            job.setTimeToCompletion(null);
            job.setPriority(new Integer(aim.getPriority(arrayID)));
            job.setType(StorageJobType.ARRAY_IMPORT);
            job.setKillable(true);
            jobMap.put(jobId, job);
        }
        return jobMap;
    }

    private HashMap getVolumeCopyJobs() throws ConfigMgmtException {
        String METHOD_NAME = "getCopyJobs";
        if (this.volumeCopyJobsMap != null) {
            Trace.verbose((Object)this, "getCopyJobs", "Using cached volume copy map");
            return this.volumeCopyJobsMap;
        }
        String arrayID = Convert.scopeToArrayKey(this.scope);
        this.volumeCopyJobsMap = new HashMap();
        VolumeCopyMO[] vc = this.getVolumeCopyMOs();
        long timeNow = new Date().getTime();
        block10: for (int i = 0; i < vc.length; ++i) {
            switch (vc[i].getStatus()) {
                case 2: {
                    continue block10;
                }
                case 3: 
                case 4: {
                    long endTime = vc[i].getCopyCompleteTime();
                    if (timeNow > endTime + 8640000L) continue block10;
                }
                default: {
                    StorageJob job = new StorageJob();
                    String jobID = vc[i].getName();
                    HashMap<String, String> keyMap = new HashMap<String, String>(2);
                    keyMap.put("array", arrayID);
                    keyMap.put("id", jobID);
                    job.setName(jobID);
                    job.setKey(keyMap);
                    StorageJobElement jobElement = new StorageJobElement(vc[i].getName(), class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$VolumeCopyMO == null ? ManageStorageJobs.class$("com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.VolumeCopyMO") : class$com$sun$netstorage$array$mgmt$cfg$dataservices$business$impl$oz$VolumeCopyMO, vc[i].getKey(), "");
                    job.setOwningJobElement(jobElement);
                    Map volKeyMap = ManageVolumes.getVolumeKeyMap(arrayID, vc[i].getSourceVolumeRef(), vc[i].getSourceVolumeName(), vc[i].getSourceVolumeWwn());
                    jobElement = new StorageJobElement(vc[i].getSourceVolumeWwn(), class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$Volume == null ? ManageStorageJobs.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Volume") : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$Volume, volKeyMap, vc[i].getSourceVolumeName());
                    job.addEffectedJobElement(jobElement);
                    volKeyMap = ManageVolumes.getVolumeKeyMap(arrayID, vc[i].getTargetVolumeRef(), vc[i].getTargetVolumeName(), vc[i].getTargetVolumeWwn());
                    jobElement = new StorageJobElement(vc[i].getTargetVolumeWwn(), class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$Volume == null ? ManageStorageJobs.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Volume") : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$Volume, volKeyMap, vc[i].getTargetVolumeName());
                    job.addEffectedJobElement(jobElement);
                    StorageJobStatus status = StorageJobStatus.UNKNOWN;
                    switch (vc[i].getStatus()) {
                        case 4: {
                            status = StorageJobStatus.COMPLETED_ERROR;
                            break;
                        }
                        case 3: {
                            status = StorageJobStatus.STOPPED;
                            break;
                        }
                        case 1: {
                            status = StorageJobStatus.RUNNING;
                            job.setKillable(true);
                            break;
                        }
                        case 5: {
                            status = StorageJobStatus.PENDING;
                            job.setKillable(true);
                        }
                    }
                    job.setType(StorageJobType.VOLUME_COPY);
                    job.setStatus(status);
                    job.setPercentComplete(new Integer((int)vc[i].getPercentComplete()));
                    long timeToCompletion = vc[i].getTimeToCompletion();
                    if (timeToCompletion == -1L) {
                        job.setTimeToCompletion(null);
                    } else {
                        job.setTimeToCompletion(new Long(timeToCompletion));
                    }
                    int jobPriority = 4 - vc[i].getPriority();
                    job.setPriority(new Integer(jobPriority));
                    this.volumeCopyJobsMap.put(jobID, job);
                    if (!Trace.isTraceEnabled(this)) continue block10;
                    Trace.verbose((Object)this, "getCopyJobs", "Add VC JOB: " + job.toString());
                }
            }
        }
        return this.volumeCopyJobsMap;
    }

    private VolumeCopyMO[] getVolumeCopyMOs() throws ConfigMgmtException {
        if (this.volumeCopyMOs == null) {
            ManageVolumeCopy mvc = new ManageVolumeCopy();
            mvc.init(this.context, this.scope, null);
            List volumeCopyMoList = mvc.getItemList();
            this.volumeCopyMOs = volumeCopyMoList.toArray(new VolumeCopyMO[volumeCopyMoList.size()]);
        }
        return this.volumeCopyMOs;
    }

    private VolumeCopyMO getVolumeCopyMO(JobInterface job) throws ConfigMgmtException {
        VolumeCopyMO[] vc = this.getVolumeCopyMOs();
        String jobID = job.getName();
        for (int i = 0; i < vc.length; ++i) {
            if (!jobID.equals(vc[i].getName())) continue;
            return vc[i];
        }
        throw new SEItemNotFoundException(jobID);
    }

    private StorageJobType getStorageJobType(VolumeAction volumeAction) {
        StorageJobType type = null;
        int action = volumeAction.getValue();
        switch (action) {
            case 1: {
                type = StorageJobType.NONE;
                break;
            }
            case 13: {
                type = StorageJobType.VOLUME_FORMAT;
                break;
            }
            case 3: {
                type = StorageJobType.VOLUME_INIT;
                break;
            }
            case 4: {
                type = StorageJobType.VOLUME_COPY_TO_STANDBY;
                break;
            }
            case 2: {
                type = StorageJobType.VOLUME_COPY_FROM_STANDBY;
                break;
            }
            case 9: {
                type = StorageJobType.VOLUME_CAPACITY_EXPANSION;
                break;
            }
            case 5: {
                type = StorageJobType.VDISK_CAPACITY_EXPANSION;
                break;
            }
            case 6: {
                type = StorageJobType.VOLUME_RAID_MIGRATION;
                break;
            }
            case 7: {
                type = OZStorageJobType.VOLUME_REMAPPING_DCEDRM;
                break;
            }
            case 8: {
                type = StorageJobType.VOLUME_SEGMENT_SIZE_CHANGE;
                break;
            }
            case 12: {
                type = StorageJobType.VDISK_DEFRAG;
                break;
            }
            case 11: {
                type = OZStorageJobType.VOLUME_REMAPPING_INTERNAL;
                break;
            }
            case 14: {
                type = OZStorageJobType.VOLUME_MIRROR_SYNCH;
                break;
            }
            default: {
                type = StorageJobType.UNKNOWN;
            }
        }
        return type;
    }

    private String getVolumeName(Volume volume) {
        byte[] label = volume.getLabel().getValue();
        if (label != null) {
            return UnicodeTranslator.getString((byte[])label);
        }
        return "";
    }

    private ErrorDescriptor killJob(StorageJob job) throws ConfigMgmtException {
        String METHOD_NAME = "killJob";
        ErrorDescriptor errorDesc = null;
        String jobID = job.getName();
        if (jobID.startsWith(VOLUME_JOBID_PREFIX)) {
            errorDesc = new ErrorDescriptor(ErrorCode.JOB_CAN_NOT_BE_KILLED);
            errorDesc.setI18nParams(new String[]{jobID});
        } else if (jobID.startsWith(VOLUME_COPY_JOBID_PREFIX)) {
            ManageVolumeCopy volumeCopyManager = new ManageVolumeCopy();
            volumeCopyManager.init(this.context, this.scope, null);
            volumeCopyManager.stop(job.getOwningJobElement().getKey(), null);
            errorDesc = new ErrorDescriptor(ErrorCode.SUCCESS);
            errorDesc.setI18nParams(new String[]{jobID});
        } else if (jobID.startsWith(ARRAY_IMPORT_JOBID)) {
            ArrayImportManager aim = ArrayImportManager.getInstance();
            boolean rc = aim.killImport((String)job.getKey().get("array"));
            if (rc) {
                errorDesc = new ErrorDescriptor(ErrorCode.SUCCESS);
                errorDesc.setI18nParams(new String[]{jobID});
            } else {
                errorDesc = new ErrorDescriptor(ErrorCode.JOB_CAN_NOT_BE_KILLED);
                errorDesc.setI18nParams(new String[]{jobID});
            }
        }
        return errorDesc;
    }

    private void modifyJobPriority(StorageJob job, String priority) throws ConfigMgmtException {
        String jobID = job.getName();
        Properties prop = new Properties();
        if (jobID.startsWith(VOLUME_JOBID_PREFIX)) {
            prop.put("modificationPriority", priority);
            ManageVolumes volumeManager = new ManageVolumes();
            volumeManager.init(this.context, this.scope, null);
            volumeManager.modify(job.getOwningJobElement().getKey(), prop);
        } else if (jobID.startsWith(VOLUME_COPY_JOBID_PREFIX)) {
            VolumeCopyMO vc = this.getVolumeCopyMO(job);
            int copyPriority = 4 - Integer.parseInt(priority);
            prop.put("protect", Boolean.toString(vc.isIdleTargetWriteProt()));
            prop.put("priority", Integer.toString(copyPriority));
            ManageVolumeCopy volumeCopyManager = new ManageVolumeCopy();
            volumeCopyManager.init(this.context, this.scope, null);
            volumeCopyManager.modify(job.getOwningJobElement().getKey(), prop);
        } else if (jobID.startsWith(ARRAY_IMPORT_JOBID)) {
            ArrayImportManager aim = ArrayImportManager.getInstance();
            aim.setPriority((String)job.getKey().get("array"), priority);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            List list = this.getItemList();
            JobInterface[] jobs = list.toArray(new JobInterface[list.size()]);
            buf.append("Array ID: ");
            buf.append(Convert.scopeToArrayKey(this.scope));
            buf.append("\n");
            if (jobs.length == 0) {
                buf.append("No Jobs Present");
            } else {
                for (int i = 0; i < jobs.length; ++i) {
                    buf.append("Job #" + i);
                    buf.append(": ");
                    buf.append(jobs[i].toString());
                    buf.append("\n");
                }
            }
        }
        catch (Exception e) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bs));
            buf.append("Caught unexpected exception: ");
            buf.append(bs.toString());
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ModifyProps {
        public static final String JOB_PRIORITY = "priority";
    }

    public static interface KeyMap {
        public static final String ID = "id";
        public static final String ARRAY = "array";
    }

    public static interface SearchType {
        public static final String ID = "id";
        public static final String KEY_AS_STRING = "keyAsString";
    }
}

