/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConnectionFactory;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.InvalidCredentials;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobCompletionInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobLink;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobManager;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class JobTimerTask
extends TimerTask
implements Cloneable {
    private static final String TIMER_INTERVAL = "timer-interval";
    private String nameSpace;
    private ConfigContext configContext;
    private Timer timer;
    private int count;
    private Integer interval;
    private static final Integer DEFAULT_INTERVAL = new Integer(300000);
    private ArrayList jobLinks = new ArrayList();
    private JobCompletionInterface jobCompletion;
    private UserPrincipal user;
    private PasswordCredential password;
    private Locale locale;

    public JobTimerTask(ConfigContext argConfigContext, ArrayList jobLinks, JobCompletionInterface completion) {
        Trace.constructor(this);
        this.jobLinks = (ArrayList)jobLinks.clone();
        this.jobCompletion = completion;
        this.user = argConfigContext.getUserPrincipal();
        this.password = argConfigContext.getPasswordCredential();
        this.locale = argConfigContext.getLocale();
    }

    public JobTimerTask(ConfigContext argConfigContext, ArrayList jobLinks, JobCompletionInterface completion, int count) {
        Trace.constructor(this);
        this.jobLinks = (ArrayList)jobLinks.clone();
        this.jobCompletion = completion;
        this.count = count;
        this.locale = argConfigContext.getLocale();
        this.user = argConfigContext.getUserPrincipal();
        this.password = argConfigContext.getPasswordCredential();
    }

    private JobTimerTask(Locale locale, UserPrincipal user, PasswordCredential password, ArrayList jobLinks, JobCompletionInterface completion, int count) {
        Trace.constructor(this);
        this.jobLinks = (ArrayList)jobLinks.clone();
        this.jobCompletion = completion;
        this.count = count;
        this.locale = locale;
        this.user = user;
        this.password = password;
    }

    private CIMOMHandleWrapper getHandle() throws ConfigMgmtException {
        Trace.methodBegin(this, "getHandle");
        if (this.configContext == null) {
            try {
                this.configContext = ConnectionFactory.getConfigContext(this.user.getName(), this.password.getUserPassword(), this.locale);
            }
            catch (InvalidCredentials ice) {
                ConfigMgmtException cme = new ConfigMgmtException();
                Trace.error((Object)this, cme);
                throw cme;
            }
        }
        return this.configContext.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block27: {
            Trace.methodBegin(this, "run");
            try {
                block28: {
                    ++this.count;
                    Trace.verbose((Object)this, "run", "run for completion: " + (this.jobCompletion == null ? "null" : this.jobCompletion.toString()));
                    try {
                        this.configContext = ConnectionFactory.getConfigContext(this.user.getName(), this.password.getUserPassword(), this.locale);
                    }
                    catch (ConfigMgmtException e) {
                        Trace.verbose((Object)this, "Failed connecting to CIMOM for execute task. ", (Throwable)e);
                        if (this.jobCompletion != null) {
                            if (this.count <= 30) {
                                Trace.verbose((Object)this, "run", "Will re-try to execute, only tried: " + this.count + " times so far for task: " + this.jobCompletion);
                                this.reschedule(this.jobLinks);
                            } else {
                                Trace.verbose((Object)this, "run", "Will not attempt to exeucte this task again.");
                                this.jobCompletion.cleanup();
                                LogAPI.staticLog((String)this.jobCompletion.getErrorKey(), (String[])this.jobCompletion.getErrorSubstitutions(), (String[])new String[0]);
                            }
                        }
                        this.closeConnection(this.configContext);
                        return;
                    }
                    ArrayList<JobLink> runningJobs = new ArrayList<JobLink>();
                    if (Trace.isTraceEnabled(this)) {
                        Trace.verbose((Object)this, "run", "Try to find job completion and executefor JobCompletion: " + (this.jobCompletion == null ? "null" : this.jobCompletion.toString()));
                        for (int i = 0; this.jobLinks != null && i < this.jobLinks.size(); ++i) {
                            Trace.verbose((Object)this, "run", "waiting on job: " + ((JobLink)this.jobLinks.get(i)).getObjectPath());
                        }
                    }
                    boolean allPreqsDone = true;
                    if (this.jobCompletion != null) {
                        allPreqsDone = this.areAllPreqsDone(this.jobCompletion);
                    }
                    boolean completionReady = true;
                    if (allPreqsDone && this.jobCompletion != null) {
                        completionReady = this.jobCompletion.isReadyToRun(this.configContext);
                    }
                    if (allPreqsDone && completionReady && this.jobLinks != null && this.jobLinks.size() == 0) {
                        if (this.jobCompletion != null && !this.jobCompletion.isDone()) {
                            Trace.verbose((Object)this, "run", "No jobs left--calling execute for this task");
                            JobLink[] followOnLinks = this.jobCompletion.execute(this.configContext);
                            for (int i = 0; i < followOnLinks.length; ++i) {
                                runningJobs.add(followOnLinks[i]);
                            }
                        } else {
                            Trace.verbose((Object)this, "run", "Not executing this task, either null or already done: " + this.jobCompletion);
                        }
                    } else {
                        Iterator iterator = this.jobLinks.iterator();
                        while (iterator.hasNext()) {
                            JobLink link = (JobLink)iterator.next();
                            Trace.verbose((Object)this, "run", "Have Context:" + (null != this.configContext));
                            boolean jobIsActive = false;
                            try {
                                jobIsActive = link.fetchJob(this.configContext).isActive();
                            }
                            catch (ConfigMgmtException e) {
                                Trace.error((Object)this, e);
                            }
                            if (!jobIsActive) continue;
                            runningJobs.add(link);
                        }
                    }
                    if (!allPreqsDone || runningJobs.size() > 0 || !completionReady) {
                        Trace.verbose((Object)this, "run", "There are more pending Jobs - reschedule");
                        this.reschedule(runningJobs);
                        break block27;
                    }
                    if (null != this.jobCompletion) break block28;
                    return;
                }
                try {
                    if (!this.jobCompletion.isDone()) {
                        this.jobCompletion.execute(this.configContext);
                        break block27;
                    }
                    Trace.verbose((Object)this, "run", "already executed this task: " + this.jobCompletion);
                }
                catch (Exception e) {
                    Trace.verbose((Object)this, "run", (Throwable)e);
                    LogAPI.staticLog((String)this.jobCompletion.getErrorKey(), (String[])this.jobCompletion.getErrorSubstitutions(), (String[])new String[0]);
                }
            }
            finally {
                this.closeConnection(this.configContext);
            }
        }
    }

    private void reschedule(ArrayList runningJobs) {
        Trace.methodBegin(this, "reschedule");
        JobTimerTask task = new JobTimerTask(this.locale, this.user, this.password, runningJobs, this.jobCompletion, this.count);
        task.setInterval(this.getInterval());
        task.setTimer(this.timer);
        Trace.verbose((Object)this, "run", "Interval = " + task.getInterval());
        task.timer.schedule((TimerTask)task, task.getInterval());
    }

    private void completeTask(JobLink link, ArrayList runningJobs) throws ConfigMgmtException {
        Trace.methodBegin(this, "completeTask");
        try {
            this.configContext = new ConfigContext(this.getHandle(), this.configContext);
            JobManager jobManagerInterface = new JobManager();
            jobManagerInterface.init(this.configContext, null);
            JobInterface job = jobManagerInterface.get(link.getObjectPath(), "");
            if (job.getStatus().equals(Constants.JobProperties.JOB_STATUS_OK_DONE)) {
                Trace.verbose((Object)this, "completeTask", "execute");
                JobLink[] followOnLinks = this.jobCompletion.execute(this.configContext);
                for (int i = 0; i < followOnLinks.length; ++i) {
                    runningJobs.add(followOnLinks[i]);
                }
            } else {
                Trace.verbose((Object)this, "completeTask", "Task completed, but not successfully");
                LogAPI.staticLog((String)this.jobCompletion.getErrorKey(), (String[])this.jobCompletion.getErrorSubstitutions(), (String[])new String[0]);
            }
        }
        catch (ConfigMgmtException e) {
            Trace.error((Object)this, e);
            LogAPI.staticLog((String)this.jobCompletion.getErrorKey(), (String[])this.jobCompletion.getErrorSubstitutions(), (String[])new String[0]);
            throw e;
        }
        finally {
            this.closeConnection(this.configContext);
        }
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public int getInterval() {
        if (null == this.interval) {
            String repositoryInterval = (String)Repository.getRepository().getProperty(TIMER_INTERVAL);
            this.interval = null == repositoryInterval ? DEFAULT_INTERVAL : new Integer(repositoryInterval);
        }
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = new Integer(interval);
    }

    private boolean areAllPreqsDone(JobCompletionInterface job) {
        Trace.methodBegin(this, "areAllPreqsDone");
        boolean isDone = true;
        ArrayList allPreReqs = job.getPrerequisiteTasks();
        Iterator iterator = allPreReqs.iterator();
        while (iterator.hasNext()) {
            JobCompletionInterface pjob = (JobCompletionInterface)iterator.next();
            Trace.verbose((Object)this, "areAllPreqsDone", "examining interface: " + pjob + " which has isDone(): " + pjob.isDone());
            isDone = isDone && pjob.isDone();
        }
        return isDone;
    }

    private void closeConnection(ConfigContext cc) {
        Trace.methodBegin(this, "closeConnection");
        try {
            CIMOMHandleWrapper cClient;
            if (cc != null && (cClient = cc.getClient()) != null) {
                cClient.close();
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)this, "closeConnection", (Throwable)e);
        }
    }
}

