/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapArrayToSet;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class Job
implements JobInterface,
Constants.JobProperties,
Constants.OperationalStatusValues {
    private Set statusSet;
    private String array;
    private String id;
    private String sortKey;
    private String description;
    private Date startTime;
    private Date endTime;
    private int percentComplete;
    private String notifyEmail;
    private ConfigContext configContext;
    private CIMInstance instance;
    private CIMObjectPath path;
    private int errorCode;
    private String errorDescription;
    private String jobStatus;
    static HashMap keys;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$jobs$business$impl$mr3$Job;

    public Job(CIMInstance instance, ConfigContext configContext, String array) throws ConfigMgmtException {
        Trace.constructor(this);
        this.init(configContext, instance);
        this.array = array;
    }

    public Job(CIMObjectPath path, ConfigContext configContext, String array) throws ConfigMgmtException {
        Trace.constructor(this);
        try {
            String methodName = "constructor";
            Trace.verbose((Object)this, methodName, "Have Context: " + (configContext != null));
            Trace.verbose((Object)this, methodName, "Have Path: " + (path != null));
            Trace.verbose((Object)this, methodName, "Have Client: " + (configContext.getClient() != null));
            CIMInstance instance = configContext.getClient().getInstance(path, false, true, false, this.getPropertyNames());
            this.init(configContext, instance);
            this.array = array;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "constructor", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public void init(ConfigContext configContext, CIMInstance instance) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.configContext = configContext;
        this.instance = instance;
        this.path = instance.getObjectPath();
        CIMObjectWrapper.populate(this, this.getFieldMap(), instance);
    }

    private Collection getFieldMap() {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$jobs$business$impl$mr3$Job == null ? (class$com$sun$netstorage$array$mgmt$cfg$jobs$business$impl$mr3$Job = Job.class$("com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.Job")) : class$com$sun$netstorage$array$mgmt$cfg$jobs$business$impl$mr3$Job, "getFieldMap");
        ArrayList<MapElement> fieldMap = new ArrayList<MapElement>();
        fieldMap.add(new MapElement("id", "InstanceID", true, false));
        fieldMap.add(new MapElement("startTime", "StartTime", true, true));
        fieldMap.add(new MapElement("endTime", "ElapsedTime", true, true));
        fieldMap.add(new MapElement("notifyEmail", "Notify", false, true));
        fieldMap.add(new MapElement("percentComplete", "PercentComplete", true, false));
        fieldMap.add(new MapElement("description", "Description", false, true));
        fieldMap.add(new MapElement("errorCode", "ErrorCode", true, false));
        fieldMap.add(new MapElement("errorDescription", "ErrorDescription", true, true));
        fieldMap.add(new MapArrayToSet("statusSet", "OperationalStatus", true, false));
        fieldMap.add(new MapElement("jobStatus", "JobStatus", true, true));
        return fieldMap;
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.configContext.getClient());
    }

    public void delete() throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        try {
            this.configContext.getClient().deleteInstance(this.instance.getObjectPath());
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "delete", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return "";
    }

    public String getSortKey() {
        StringBuffer l_key = null;
        if (this.sortKey == null) {
            DecimalFormat nf = new DecimalFormat("00000");
            StringTokenizer st = new StringTokenizer(this.getId(), ":");
            l_key = new StringBuffer(st.nextToken());
            String tok = null;
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
            }
            l_key.append(nf.format(new Integer(tok)));
            Trace.verbose((Object)this, "getSortKey", "Sort key for job " + this.getId() + " is " + l_key);
        }
        if (l_key != null) {
            this.sortKey = l_key.toString();
        }
        return this.sortKey;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return new String("N/A");
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        if (this.endTime == null || this.isActive()) {
            return null;
        }
        long end = this.startTime.getTime() + this.endTime.getTime();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(end);
        return cal.getTime();
    }

    public String getNotifyEmail() {
        return this.notifyEmail;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setNotifyEmail(String notifyEmail) {
        this.notifyEmail = notifyEmail;
    }

    public void setPercentComplete(int percentComplete) {
        this.percentComplete = percentComplete;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void kill() throws ConfigMgmtException {
        Trace.methodBegin(this, "kill");
        CIMArgument[] cimInArguments = new CIMArgument[]{new CIMArgument("DeleteOnKill", CIMValue.FALSE)};
        CIMArgument[] cimOutArguments = new CIMArgument[]{};
        try {
            CIMValue returnCodeValue = this.configContext.getClient().invokeMethod(this.path, "KillJob", cimInArguments, cimOutArguments);
            Trace.verbose((Object)this, "kill", "Obtained return value: " + returnCodeValue);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "kill", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public String getArray() {
        return this.array;
    }

    protected final String[] getPropertyNames() {
        Trace.methodBegin(this, "getPropertyNames");
        String[] names = new String[this.getFieldMap().size()];
        int i = 0;
        Iterator iterator = this.getFieldMap().iterator();
        while (iterator.hasNext()) {
            MapElement element = (MapElement)iterator.next();
            names[i] = element.getCimProperty();
            ++i;
        }
        return names;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public boolean isActive() {
        return !(this.getStatusSet().contains(new Integer(17)) | this.getStatusSet().contains(new Integer(6)) | this.getStatusSet().contains(new Integer(14)));
    }

    public CIMObjectPath getObjectPath() {
        return this.instance.getObjectPath();
    }

    public CIMInstance getInstance() {
        return this.instance;
    }

    public Set getStatusSet() {
        return this.statusSet;
    }

    public void setStatusSet(Set statusSet) {
        this.statusSet = statusSet;
    }

    public Integer getStatus() {
        Integer status = null;
        if (this.getStatusSet().contains(new Integer(17))) {
            if (this.getStatusSet().contains(new Integer(2))) {
                status = Constants.JobProperties.JOB_STATUS_OK_DONE;
            } else if (this.getStatusSet().contains(new Integer(6))) {
                status = Constants.JobProperties.JOB_STATUS_ERROR_DONE;
            } else if (this.getStatusSet().contains(new Integer(14))) {
                status = Constants.JobProperties.JOB_STATUS_ABORTED_DONE;
            }
        } else if (this.getStatusSet().contains(new Integer(2))) {
            status = Constants.JobProperties.JOB_STATUS_RUNNING;
        } else if (this.getStatusSet().contains(new Integer(6))) {
            status = Constants.JobProperties.JOB_STATUS_ERROR_DONE;
        } else if (this.getStatusSet().contains(new Integer(15))) {
            status = Constants.JobProperties.JOB_STATUS_DORMANT;
        }
        return status;
    }

    static HashMap getKeys() {
        if (null == keys) {
            keys = new HashMap();
            keys.put(Constants.JobProperties.JOB_STATUS_ABORTED_DONE, "job.status.aborted.done");
            keys.put(Constants.JobProperties.JOB_STATUS_DORMANT, "job.status.dormant");
            keys.put(Constants.JobProperties.JOB_STATUS_ERROR_DONE, "job.status.error.done");
            keys.put(Constants.JobProperties.JOB_STATUS_OK_DONE, "job.status.ok.done");
            keys.put(Constants.JobProperties.JOB_STATUS_RUNNING, "job.status.running");
        }
        return keys;
    }

    public String getStatusKey() {
        return (String)Job.getKeys().get(this.getStatus());
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        try {
            this.instance = this.configContext.getClient().getInstance(this.path, false, true, false, this.getPropertyNames());
            this.init(this.configContext, this.instance);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "reload", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public void setConfigContext(ConfigContext argCC) {
        this.configContext = argCC;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("==========Job Details:\n");
        sb.append("\tArray:");
        sb.append(this.array);
        sb.append("\n\t");
        sb.append("\n\t");
        sb.append("Description:");
        sb.append(this.description);
        sb.append("\n\t");
        sb.append("End Time:");
        sb.append(this.endTime);
        sb.append("\n\t");
        sb.append("Error Code:");
        sb.append(this.errorCode);
        sb.append("\n\t");
        sb.append("Error Description:");
        sb.append(this.errorDescription);
        sb.append("\n\t");
        sb.append("ID:");
        sb.append(this.id);
        sb.append("\n\t");
        sb.append("Notify Email:");
        sb.append(this.notifyEmail);
        sb.append("\n\t");
        sb.append("Percent Complete:");
        sb.append(this.percentComplete);
        sb.append("\n\t");
        sb.append("Start Time:");
        sb.append(this.startTime);
        sb.append("\n\t");
        sb.append("Job Status:");
        sb.append(this.jobStatus);
        sb.append("\n\t");
        sb.append("Status Set:");
        sb.append(this.statusSet);
        sb.append("\n========================\n");
        return sb.toString();
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public void setTaskResult(int taskIndex, String result, boolean success) {
    }

    public String getTaskResult(int taskIndex) {
        return "";
    }

    public int getTaskFailureCount() {
        return 0;
    }

    public Vector getTaskResults() {
        return new Vector();
    }

    public String getTask(int taskIndex) {
        return "";
    }

    public Vector getTasks() {
        return new Vector();
    }

    public boolean isResultTypeSuccess(int taskIndex) {
        return false;
    }

    public Vector getTaskResultTypes() {
        return new Vector();
    }

    public boolean isUIJob() {
        return false;
    }

    public String getUIJobStatus(String successStr, String pendingStr, String sepStr, String delimitStr) {
        String status = new String();
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

