/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.common;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CoreManagedObject;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.StorageJobElement;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.StorageJobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.StorageJobStatus;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.StorageJobType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StorageJobCommon
extends CoreManagedObject
implements StorageJobInterface {
    protected static final Integer PERCENT_COMPLETED_ZERO = new Integer(0);
    protected Integer percentCompleted = PERCENT_COMPLETED_ZERO;
    protected StorageJobStatus status = StorageJobStatus.PENDING;
    protected StorageJobType type = StorageJobType.UNKNOWN;
    protected List errorCodeList = new ArrayList();
    protected List effectedElements = new ArrayList();
    protected StorageJobElement owningJobElement;

    public StorageJobCommon() {
    }

    public StorageJobCommon(String name, Map key) {
        this.setName(name);
        this.setKey(key);
    }

    public List getErrorCodes() {
        return this.errorCodeList;
    }

    public void addErrorCode(ErrorCode errorCode) {
        if (errorCode == null) {
            throw new IllegalArgumentException("Invalid errorCode, null errorCode not allowed");
        }
        this.errorCodeList.add(errorCode);
    }

    public StorageJobElement getOwningJobElement() {
        return this.owningJobElement;
    }

    public void setOwningJobElement(StorageJobElement owner) {
        this.owningJobElement = owner;
    }

    public List getEffectedJobElements() {
        return this.effectedElements;
    }

    public void addEffectedJobElement(StorageJobElement element) {
        this.effectedElements.add(element);
    }

    public Integer getPercentComplete() {
        return this.percentCompleted;
    }

    public void setPercentComplete(Integer percentCompleted) {
        this.percentCompleted = percentCompleted;
    }

    public StorageJobStatus getStatus() {
        return this.status;
    }

    public void setStatus(StorageJobStatus status) {
        this.status = status;
    }

    public StorageJobType getType() {
        return this.type;
    }

    public void setType(StorageJobType type) {
        this.type = type;
    }

    public String getTypeAsString() {
        if (this.type != null) {
            return this.type.toString();
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Name: ");
        buf.append(this.getName());
        buf.append(", Status: ");
        buf.append(this.getStatus().toString());
        buf.append(", Type: ");
        buf.append(this.getType().toString());
        buf.append(", Owner: ");
        buf.append(this.getOwningJobElement().getName());
        buf.append(", Effected Elements: ");
        List list = this.getEffectedJobElements();
        StorageJobElement[] elements = list.toArray(new StorageJobElement[list.size()]);
        for (int i = 0; i < elements.length; ++i) {
            buf.append(elements[i].getName());
            if (i >= elements.length) continue;
            buf.append(",");
        }
        buf.append(" PercentComplete: ");
        buf.append(this.getPercentComplete());
        buf.append(", ErrorCodes: ");
        list = this.getErrorCodes();
        ErrorCode[] codes = list.toArray(new ErrorCode[list.size()]);
        for (int i = 0; i < codes.length; ++i) {
            buf.append(codes[i]);
            if (i >= codes.length) continue;
            buf.append(",");
        }
        return buf.toString();
    }
}

