/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayReg;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayRegManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesInterface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ReplicationSetMO;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageArrays;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.ConsistencyGroup;
import devmgr.versioned.symbol.ConsistencyGroupRef;
import devmgr.versioned.symbol.HLVolumeBundle;
import devmgr.versioned.symbol.MirrorAutoResyncDescriptor;
import devmgr.versioned.symbol.MirrorCreationDescriptor;
import devmgr.versioned.symbol.MirrorProxyRef;
import devmgr.versioned.symbol.MirrorProxyRole;
import devmgr.versioned.symbol.MirrorProxyVolume;
import devmgr.versioned.symbol.MirrorProxyWriteMode;
import devmgr.versioned.symbol.MirrorRoleChangeDescriptor;
import devmgr.versioned.symbol.MirrorSyncPriority;
import devmgr.versioned.symbol.MirrorSyncPriorityDescriptor;
import devmgr.versioned.symbol.MirrorWriteModeDescriptor;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PremiumFeature;
import devmgr.versioned.symbol.RemoteCommunicationCheckDescriptor;
import devmgr.versioned.symbol.RemoteCommunicationCheckSampleList;
import devmgr.versioned.symbol.RemoteVolRef;
import devmgr.versioned.symbol.RemoteVolume;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolRVMAuthGen;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Volume;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ManageReplicationServices
implements ManageReplicationServicesInterface {
    static final String MASKED_STATUS_REPSETS = "mask-status-repsets";
    static final String MAX_MASK_TIME = "max-repset-mask-time";
    static final Long DEFAULT_REPSET_STATUS_MASK_TIME = new Long(10000L);
    ConfigContext cfgctx;
    Scope scope;
    SearchFilter filter;
    public static final String REP_SET_NAME_SUFFIX = "/1";
    private static final String sccs_id = "@(#)ManageReplicationServices.java 1.35 05/07/20 SMI";

    private boolean isReplicationSetLicensed(StorageArray sa, int capNum) {
        String METHOD_NAME = "isReplicationSetLicensed";
        Trace.methodBegin(this, "isReplicationSetLicensed");
        PremiumFeature[] pfa = sa.getPremiumFeatures();
        if (pfa != null) {
            for (int i = 0; i < pfa.length; ++i) {
                int myCapNum = pfa[i].getCapability().getValue();
                if (capNum != myCapNum) continue;
                return pfa[i].getIsEnabled();
            }
        }
        Trace.methodEnd(this, "isReplicationSetLicensed");
        return false;
    }

    public void init(ConfigContext context, Scope s, SearchFilter f) throws ConfigMgmtException {
        String METHOD_NAME = "init";
        Trace.methodBegin(this, "init");
        this.cfgctx = context;
        this.scope = s;
        this.filter = f;
    }

    private Volume getVolume(ObjectBundle bundle, String volName) {
        Volume[] localVols = bundle.getVolume();
        if (localVols == null || localVols.length == 0) {
            return null;
        }
        Volume baseVolume = null;
        for (int i = 0; i < localVols.length; ++i) {
            String myVol;
            String string = myVol = localVols[i].getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])localVols[i].getLabel().getValue()) : "";
            if (!volName.equals(myVol)) continue;
            baseVolume = localVols[i];
            break;
        }
        return baseVolume;
    }

    public void create(Properties Prop) throws ConfigMgmtException {
        boolean enforceSecondarySize;
        ObjectBundle bundle;
        StorageArray sa;
        String METHOD_NAME = "create";
        Trace.methodBegin(this, "create");
        String myWwn = Prop.getProperty("array");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
            } else {
                Trace.error((Object)this, "create", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
        }
        if (!this.isReplicationSetLicensed(sa = (bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn)).getSa(), 13)) {
            Trace.error((Object)this, "create", "license disabled");
            throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
        }
        if (!sa.getRemoteMirroringActive()) {
            Trace.error((Object)this, "create", "repset license not activated.");
            throw new ConfigMgmtException(ErrorCode.ERROR_REPSET_LICENSE_NOT_ACTIVATED.getKey(), "repset license not activated");
        }
        MirrorCreationDescriptor mirrorCreationDescriptor = new MirrorCreationDescriptor();
        Volume baseVolume = this.createSetBaseVolume(Prop, bundle, mirrorCreationDescriptor);
        String remotePeerWwn = this.createSetRemoteNodeWWN(Prop, mirrorCreationDescriptor);
        if (myWwn.equals(remotePeerWwn)) {
            String msg = "LOCAL ARRAY WWN and PEER ARRAY WWN are identical";
            Trace.error((Object)this, "create", msg);
            throw new ConfigMgmtException(ErrorCode.INVALID_REMOTE_ADDRESS.getKey(), msg);
        }
        Volume remoteVol = this.createSetRemoteVolWWN(Prop, mirrorCreationDescriptor, remotePeerWwn);
        this.createSetSyncPriority(Prop, mirrorCreationDescriptor);
        this.createSetWriteMode(Prop, bundle, mirrorCreationDescriptor);
        this.createSetAutoResync(Prop, mirrorCreationDescriptor);
        boolean bl = enforceSecondarySize = Repository.getRepository().getProperty("ENFORCE_LARGER_SECONDARY") == null ? false : Boolean.valueOf((String)Repository.getRepository().getProperty("ENFORCE_LARGER_SECONDARY"));
        if (enforceSecondarySize && baseVolume.getCapacity() > remoteVol.getCapacity()) {
            String msg = "PEER volume is smaller than base volume.";
            Trace.error((Object)this, "create", msg);
            throw new ConfigMgmtException(ErrorCode.VOLUME_SIZE_TOO_SMALL.getKey(), msg);
        }
        try {
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            ReturnCode rc = new ReturnCode();
            CommandProcessor command = new CommandProcessor(myWwn);
            int MAX_ATTEMPTS = 5;
            for (int attempt = 0; attempt < 5; ++attempt) {
                this.createSetRemotePassword(sa, mirrorCreationDescriptor, remotePeerWwn, remoteVol);
                command.execute(110, (XDRType)mirrorCreationDescriptor, (XDRType)rc, true);
                String localVolumeName = (String)Prop.get("localVolume");
                String repSetName = localVolumeName.concat(REP_SET_NAME_SUFFIX);
                int retstat = rc.getValue();
                if (retstat == 1) {
                    this.addNewRepSetToRepository(repSetName);
                    try {
                        LogAPI.staticLog((String)"REPLICATION_SET_CREATE", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    }
                    catch (RuntimeException e) {}
                    break;
                }
                if (retstat == 173) {
                    if (attempt != 4) continue;
                    LogAPI.staticLog((String)"REPLICATION_SET_CREATE_ERROR", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    Trace.error((Object)this, "create", "Retry count reached, still REMOTE_INVALID_CFG_GEN.");
                    throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + retstat), "create error");
                }
                LogAPI.staticLog((String)"REPLICATION_SET_CREATE_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                String message = "Code " + retstat + " returned for replication set createMirror.";
                Trace.error((Object)this, "create", message);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + retstat), "create error");
            }
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "create", "RPC error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "create", "IO error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
        Trace.methodEnd(this, "create");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRepsetsInRepository(boolean removeMap) {
        Long maxMaskStatusTime;
        Map maskedStatusMap = (Map)Repository.getRepository().getProperty(MASKED_STATUS_REPSETS);
        String mmt = (String)Repository.getRepository().getProperty(MAX_MASK_TIME);
        Long l = maxMaskStatusTime = mmt == null ? DEFAULT_REPSET_STATUS_MASK_TIME : new Long(mmt);
        if (maskedStatusMap != null) {
            Map map = maskedStatusMap;
            synchronized (map) {
                Set keys = maskedStatusMap.keySet();
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String repSetName = (String)it.next();
                    Long creationTime = (Long)maskedStatusMap.get(repSetName);
                    if (creationTime != null && System.currentTimeMillis() - creationTime <= maxMaskStatusTime) continue;
                    maskedStatusMap.remove(repSetName);
                }
                if (removeMap && maskedStatusMap.isEmpty()) {
                    Repository.getRepository().removeProperty(MASKED_STATUS_REPSETS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewRepSetToRepository(String repSetName) {
        Trace.methodBegin(this, "addNewRepSetToRepository");
        this.clearRepsetsInRepository(false);
        HashMap<String, Long> maskedStatusMap = (HashMap<String, Long>)Repository.getRepository().getProperty(MASKED_STATUS_REPSETS);
        if (maskedStatusMap == null) {
            maskedStatusMap = new HashMap<String, Long>();
        }
        HashMap<String, Long> hashMap = maskedStatusMap;
        synchronized (hashMap) {
            maskedStatusMap.put(repSetName, new Long(System.currentTimeMillis()));
            Repository.getRepository().setProperty(MASKED_STATUS_REPSETS, maskedStatusMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRepSetStatus(String repSetName, int status) {
        String methodName = "getRepSetStatus";
        Trace.methodBegin(this, "getRepSetStatus");
        int newStatus = status;
        Map m = (Map)Repository.getRepository().getProperty(MASKED_STATUS_REPSETS);
        if (m != null && m.get(repSetName) != null) {
            Trace.verbose((Object)this, "getRepSetStatus", "Repset:" + repSetName + " is in the list");
            if (status != 5) {
                Trace.verbose((Object)this, "getRepSetStatus", "Status is not failed, it is:" + status);
                Map map = m;
                synchronized (map) {
                    m.remove(repSetName);
                    if (m.isEmpty()) {
                        Repository.getRepository().removeProperty(MASKED_STATUS_REPSETS);
                    }
                }
            } else {
                Trace.verbose((Object)this, "getRepSetStatus", "Return status synchronizing");
                newStatus = 2;
            }
        }
        return newStatus;
    }

    private void createSetRemotePassword(StorageArray sa, MirrorCreationDescriptor mirrorCreationDescriptor, String remotePeerWwn, Volume remoteVol) throws ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "createSetRemotePassword";
        Trace.methodBegin(this, "createSetRemotePassword");
        ArrayReg arrayReg = ArrayRegManager.getInstance().getArrayRegistration(remotePeerWwn);
        if (arrayReg == null) {
            Trace.error((Object)this, "createSetRemotePassword", "remote ArrayReg not found");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Remote ArrayReg not found.", null, 100);
        }
        try {
            ObjectBundle remoteBundle = ObjectBundleManager.getInstance().getObjectBundle(remotePeerWwn);
            CommandProcessor rcommand = new CommandProcessor(remotePeerWwn);
            long lastConfigGen = rcommand.getCurrentConfigNumber();
            SAIdentifier said = new SAIdentifier();
            said.setWorldWideName(remoteBundle.getSa().getSaData().getSaId().getWorldWideName());
            mirrorCreationDescriptor.getRemotePassword().setDigest(SYMbolRVMAuthGen.encodeRemoteAuthenticator((SAIdentifier)said, (String)arrayReg.getPassword(), (long)lastConfigGen, (byte[])remoteVol.getWorldWideName()));
            mirrorCreationDescriptor.getRemotePassword().setCfgGen(lastConfigGen);
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "createSetRemotePassword", "RPC error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "createSetRemotePassword", "IO error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        Trace.methodEnd(this, "createSetRemotePassword");
    }

    private void createSetAutoResync(Properties Prop, MirrorCreationDescriptor mirrorCreationDescriptor) throws ConfigMgmtException {
        String METHOD_NAME = "createSetAutoResync";
        Trace.methodBegin(this, "createSetAutoResync");
        Object autoSyncProp = Prop.get("autoSynchronize");
        int autoSync = 0;
        if (autoSyncProp != null) {
            autoSync = (Integer)autoSyncProp;
        }
        if (autoSync == 1) {
            mirrorCreationDescriptor.setAutoResyncFlag(true);
        } else if (autoSync == 0) {
            mirrorCreationDescriptor.setAutoResyncFlag(false);
        } else {
            Trace.error((Object)this, "createSetAutoResync", "unknown AUTO_SYNC value: " + autoSync);
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "unknown AUTO_SYNC value.", null, 100);
        }
        Trace.methodEnd(this, "createSetAutoResync");
    }

    private void createSetWriteMode(Properties Prop, ObjectBundle bundle, MirrorCreationDescriptor mirrorCreationDescriptor) throws ConfigMgmtException {
        String METHOD_NAME = "createSetWriteMode";
        Trace.methodBegin(this, "createSetWriteMode");
        Object modeProp = Prop.get("mode");
        if (modeProp == null) {
            Trace.error((Object)this, "createSetWriteMode", "Missing REPLICATION_MODE property");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "MODE property not populated.", null, 100);
        }
        MirrorProxyWriteMode writeMode = new MirrorProxyWriteMode();
        Object consistencyGroupProp = Prop.get("consistencyGroup");
        ConsistencyGroupRef cgr = this.handleWriteMode(bundle, writeMode, modeProp, consistencyGroupProp);
        mirrorCreationDescriptor.setConsistencyGroupRef(cgr);
        mirrorCreationDescriptor.setWriteMode(writeMode);
        Trace.methodEnd(this, "createSetWriteMode");
    }

    private ConsistencyGroupRef handleWriteMode(ObjectBundle bundle, MirrorProxyWriteMode writeMode, Object modeProp, Object consistencyGroupProp) throws ConfigMgmtException {
        int cg;
        String METHOD_NAME = "handleConsistencyGroupRef";
        Trace.methodBegin(this, "handleConsistencyGroupRef");
        if (modeProp != null) {
            int replicationMode = (Integer)modeProp;
            if (replicationMode == 0 || replicationMode == 1) {
                writeMode.setValue(replicationMode);
            } else {
                Trace.error((Object)this, "handleConsistencyGroupRef", "unknown MODE value: " + replicationMode);
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "unknown MODE value.", null, 100);
            }
        }
        if (0 == writeMode.getValue() && consistencyGroupProp != null) {
            throw new BadParameterException("", "repset.constgroup.error");
        }
        ConsistencyGroupRef cgr = null;
        int n = cg = consistencyGroupProp == null ? 0 : (Integer)consistencyGroupProp;
        if (cg == 0) {
            if (2 == writeMode.getValue()) {
                writeMode.setValue(1);
            }
            cgr = new ConsistencyGroupRef();
            cgr.setRefToken(new byte[20]);
        } else if (cg == 1) {
            if (1 == writeMode.getValue()) {
                writeMode.setValue(2);
            }
            ConsistencyGroup[] consistencyGroup = bundle.getConsistencyGroupBundle().getConsistencyGroup();
            cgr = consistencyGroup[0].getGroupRef();
        } else {
            Trace.error((Object)this, "handleConsistencyGroupRef", "unknown CONSISTENCY_GROUP value: " + cg);
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "unknown CONSISTENCY_GROUP value.", null, 100);
        }
        return cgr;
    }

    private void createSetSyncPriority(Properties Prop, MirrorCreationDescriptor mirrorCreationDescriptor) throws ConfigMgmtException {
        String METHOD_NAME = "createSetSyncPriority";
        Trace.methodBegin(this, "createSetSyncPriority");
        Object replicationPriorityProp = Prop.get("replicationPriority");
        int replicationPriority = 2;
        MirrorSyncPriority mirrorSyncPriority = new MirrorSyncPriority();
        if (replicationPriorityProp != null && ((replicationPriority = ((Integer)replicationPriorityProp).intValue()) < 0 || replicationPriority > 5)) {
            Trace.error((Object)this, "createSetSyncPriority", "Invalid REPLICATION_PRIORITY property");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "REPLICATION_PRIORITY property out of range.", null, 100);
        }
        mirrorSyncPriority.setValue(replicationPriority);
        mirrorCreationDescriptor.setSyncPriority(mirrorSyncPriority);
        Trace.methodEnd(this, "createSetSyncPriority");
    }

    private Volume createSetRemoteVolWWN(Properties Prop, MirrorCreationDescriptor mirrorCreationDescriptor, String remotePeerWwn) throws ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "createSetRemoteVolWWN";
        Trace.methodBegin(this, "createSetRemoteVolWWN");
        Volume remoteVol = null;
        Object remoteVolumeProp = Prop.get("remoteVolumeName");
        if (remoteVolumeProp == null) {
            Trace.error((Object)this, "createSetRemoteVolWWN", "Missing REMOTE_VOLUME_NAME property");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "REMOTE_VOLUME_NAME property not populated.", null, 100);
        }
        String remoteVolumeName = (String)remoteVolumeProp;
        Trace.verbose((Object)this, "createSetRemoteVolWWN", "REMOTE_VOLUME_NAME: " + remoteVolumeName);
        ObjectBundle remoteBundle = ObjectBundleManager.getInstance().getObjectBundle(remotePeerWwn);
        remoteVol = this.getVolume(remoteBundle, remoteVolumeName);
        if (remoteVol == null) {
            Trace.error((Object)this, "createSetRemoteVolWWN", "remote volume not found");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), new String[]{remoteVolumeName}, "Remote volume not found.", null, 100);
        }
        mirrorCreationDescriptor.setRemoteVolWWN(remoteVol.getWorldWideName());
        Trace.methodEnd(this, "createSetRemoteVolWWN");
        return remoteVol;
    }

    private String createSetRemoteNodeWWN(Properties Prop, MirrorCreationDescriptor mirrorCreationDescriptor) throws SEItemNotFoundException, ConfigMgmtException {
        String METHOD_NAME = "createSetRemoteNodeWWN";
        Trace.methodBegin(this, "createSetRemoteNodeWWN");
        Object peerWwnProp = Prop.get("peerWwn");
        String remotePeerWwn = null;
        if (peerWwnProp == null) {
            Object remoteArrayProp = Prop.get("remoteArrayName");
            if (remoteArrayProp != null) {
                String remoteArrayName = (String)remoteArrayProp;
                Trace.verbose((Object)this, "createSetRemoteNodeWWN", "FIXME-jim handle REMOTE_ARRAY_NAME: " + remoteArrayName);
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "PEER_WWN|REMOTE_ARRAY_NAME property not populated.", null, 100);
            }
            Trace.error((Object)this, "createSetRemoteNodeWWN", "Missing  PEER_WWN|REMOTE_ARRAY_NAME property");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "PEER_WWN|REMOTE_ARRAY_NAME property not populated.", null, 100);
        }
        remotePeerWwn = (String)peerWwnProp;
        Trace.verbose((Object)this, "createSetRemoteNodeWWN", "PEER_WWN: " + remotePeerWwn);
        ObjectBundle remoteBundle = ObjectBundleManager.getInstance().getObjectBundle(remotePeerWwn);
        mirrorCreationDescriptor.setRemoteNodeWWN(remoteBundle.getSa().getRemoteAccessID());
        Trace.methodEnd(this, "createSetRemoteNodeWWN");
        return remotePeerWwn;
    }

    private Volume createSetBaseVolume(Properties Prop, ObjectBundle bundle, MirrorCreationDescriptor mirrorCreationDescriptor) throws ConfigMgmtException {
        String METHOD_NAME = "createSetBaseVolume";
        Trace.methodBegin(this, "createSetBaseVolume");
        Volume baseVolume = null;
        Object localVolumeProp = Prop.get("localVolume");
        if (localVolumeProp == null) {
            Trace.error((Object)this, "createSetBaseVolume", "Missing LOCAL_VOLUME property");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "LOCAL_VOLUME property not populated.", null, 100);
        }
        String localVolume = (String)localVolumeProp;
        Trace.verbose((Object)this, "createSetBaseVolume", "LOCAL_VOLUME: " + localVolume);
        baseVolume = this.getVolume(bundle, localVolume);
        if (baseVolume == null) {
            Trace.error((Object)this, "createSetBaseVolume", "local volume not found");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), new String[]{localVolume}, "Local Volume not found.", null, 100);
        }
        mirrorCreationDescriptor.setBaseVolume((AbstractVolRef)baseVolume.getVolumeRef());
        Trace.methodEnd(this, "createSetBaseVolume");
        return baseVolume;
    }

    private MirrorProxyVolume getMirrorProxyVolume(ObjectBundle bundle, String volWWN, List baseVolumeList) {
        HLVolumeBundle hlvb = bundle.getHighLevelVolBundle();
        MirrorProxyVolume[] mpv = hlvb.getMirrorVol();
        Volume[] localVols = bundle.getVolume();
        if (mpv == null || mpv.length == 0 || localVols == null || localVols.length == 0) {
            return null;
        }
        Volume baseVolume = null;
        for (int i = 0; i < localVols.length; ++i) {
            String myVolWWN = Convert.bytesToString(localVols[i].getWorldWideName());
            if (!volWWN.equals(myVolWWN)) continue;
            baseVolume = localVols[i];
            baseVolumeList.add(baseVolume);
            break;
        }
        if (baseVolume == null) {
            return null;
        }
        Map mirrorVolumeMap = this.populateVolumeRefVolumeMap(mpv);
        return (MirrorProxyVolume)mirrorVolumeMap.get(Convert.bytesToString(baseVolume.getVolumeRef().getRefToken()));
    }

    private RemoteVolume getRemoteVolume(RemoteVolRef remoteVolRef, ObjectBundle bundle) {
        String rvrRefString = Convert.bytesToString(remoteVolRef.getRefToken());
        HLVolumeBundle hlvb = bundle.getHighLevelVolBundle();
        RemoteVolume[] remoteVols = hlvb.getRemoteVol();
        Map remoteVolumeMap = this.populateVolumeRefVolumeMap(remoteVols);
        return (RemoteVolume)remoteVolumeMap.get(rvrRefString);
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        ObjectBundle bundle;
        StorageArray sa;
        String METHOD_NAME = "delete";
        Trace.methodBegin(this, "delete");
        String myWwn = null;
        MethodCallStatus mcs = new MethodCallStatus();
        if (list == null || list.size() == 0) {
            Trace.error((Object)this, "delete", "null or empty list");
            throw new ConfigMgmtException(ErrorCode.EMPTY_LIST.getKey(), "null or empty list");
        }
        mcs.setReturnCode(0);
        List keys = Convert.listOfStringKeysToMap(list);
        Map key = (Map)keys.get(0);
        myWwn = (String)key.get("array");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
            } else {
                Trace.error((Object)this, "delete", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
        }
        if (!this.isReplicationSetLicensed(sa = (bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn)).getSa(), 13)) {
            Trace.error((Object)this, "delete", "license disabled");
            throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
        }
        try {
            int listSize = list.size();
            String repsetVolWWN = null;
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            ReturnCode rc = new ReturnCode();
            for (int i = 0; i < listSize; ++i) {
                repsetVolWWN = (String)((Map)keys.get(i)).get("volumeWwn");
                ArrayList baseVolumeList = new ArrayList(1);
                MirrorProxyVolume mirrorProxyVolume = this.getMirrorProxyVolume(bundle, repsetVolWWN, baseVolumeList);
                String repSetName = this.getRepSetName(baseVolumeList);
                if (mirrorProxyVolume == null) {
                    ErrorDescriptor ed = new ErrorDescriptor();
                    ed.setErrorCode(ErrorDescriptor.ERROR_ITEM_NOT_FOUND);
                    ed.setI18nkey(ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY);
                    String[] params = new String[]{repsetVolWWN};
                    ed.setI18nParams(params);
                    ed.setMsg("Failed to delete repset:" + params[0]);
                    mcs.addErrorDescriptor(ed);
                    continue;
                }
                MirrorProxyRef mirrorProxyRef = mirrorProxyVolume.getMirrorProxyRef();
                command.execute(112, (XDRType)mirrorProxyRef, (XDRType)rc, true);
                if (rc.getValue() != 1) {
                    LogAPI.staticLog((String)"REPLICATION_SET_DELETE_ERROR", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    String message = "Code " + rc.getValue() + " returned for replication set delete.";
                    Trace.error((Object)this, "delete", message);
                    ErrorDescriptor ed = new ErrorDescriptor(OZErrorCode.getErrorCode(ErrorCode.ERROR_DELETE_REP_SET.getKey(), rc.getValue()), new String[]{repSetName}, "Delete failed");
                    mcs.addErrorDescriptor(ed);
                    continue;
                }
                try {
                    LogAPI.staticLog((String)"REPLICATION_SET_DELETE", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    continue;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "delete", "RPC error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "delete", "IO error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
        Trace.methodEnd(this, "delete");
        return mcs;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        String myWwn = null;
        StorageArray sa = null;
        Map myKeys = null;
        if (key instanceof Map) {
            myKeys = (Map)key;
        } else if (key instanceof String) {
            myKeys = Convert.keyAsStringToMap((String)key);
        }
        if (myKeys == null) {
            Trace.error((Object)this, "modify", "missing key obj");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "missing key obj");
        }
        myWwn = (String)myKeys.get("array");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
            } else {
                Trace.error((Object)this, "modify", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
        }
        try {
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
            sa = bundle.getSa();
            if (!this.isReplicationSetLicensed(sa, 13)) {
                Trace.error((Object)this, "modify", "license disabled");
                throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
            }
            String volumeWWN = (String)myKeys.get("volumeWwn");
            if (volumeWWN == null) {
                Trace.error((Object)this, "modify", "Missing replication set key.");
                throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing REPLICATION_SET key");
            }
            ArrayList baseVolumeList = new ArrayList(1);
            MirrorProxyVolume mirrorProxyVolume = this.getMirrorProxyVolume(bundle, volumeWWN, baseVolumeList);
            String repSetName = this.getRepSetName(baseVolumeList);
            if (mirrorProxyVolume == null) {
                Trace.error((Object)this, "modify", "Cant get MirrorProxyVolume.");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "cant get MirrorProxyVolume");
            }
            MirrorProxyRef mirrorProxyRef = mirrorProxyVolume.getMirrorProxyRef();
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            ReturnCode rc = new ReturnCode();
            this.modifySetWriteMode(props, sa, bundle, mirrorProxyVolume, command, repSetName);
            this.modifySetAutoResync(props, sa, mirrorProxyVolume, command, bundle, repSetName);
            this.modifySetPriority(props, sa, mirrorProxyVolume, command, bundle, repSetName);
            this.modifySetRole(props, sa, mirrorProxyRef, command, repSetName);
            this.modifySetActivity(props, sa, mirrorProxyVolume, command, bundle, repSetName);
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "modify", "RPC error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "modify", "IO error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
        Trace.methodEnd(this, "modify");
    }

    private void modifySetActivity(Properties props, StorageArray sa, MirrorProxyVolume mirrorProxyVolume, CommandProcessor command, ObjectBundle bundle, String repSetName) throws ConfigMgmtException {
        String METHOD_NAME = "modifySetActivity";
        Trace.methodBegin(this, "modifySetActivity");
        ReturnCode rc = new ReturnCode();
        Object replicationActivityProp = props.get("replicationActivity");
        if (replicationActivityProp != null) {
            int replicationActivity = (Integer)replicationActivityProp;
            MirrorProxyRef mirrorProxyRef = mirrorProxyVolume.getMirrorProxyRef();
            if (replicationActivity == 1) {
                if (mirrorProxyVolume.getLocalWriteMode().getValue() == 2) {
                    ConsistencyGroup[] consistencyGroup = bundle.getConsistencyGroupBundle().getConsistencyGroup();
                    command.execute(156, (XDRType)consistencyGroup[0].getGroupRef(), (XDRType)rc, true);
                } else {
                    command.execute(133, (XDRType)mirrorProxyRef, (XDRType)rc, true);
                }
            } else if (replicationActivity == 0) {
                if (mirrorProxyVolume.getLocalWriteMode().getValue() == 2) {
                    ConsistencyGroup[] consistencyGroup = bundle.getConsistencyGroupBundle().getConsistencyGroup();
                    command.execute(155, (XDRType)consistencyGroup[0].getGroupRef(), (XDRType)rc, true);
                } else {
                    command.execute(132, (XDRType)mirrorProxyRef, (XDRType)rc, true);
                }
            } else {
                Trace.verbose((Object)this, "modifySetActivity", "unknown replication-activity: " + replicationActivity);
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "unknown REPLICATION_ACTIVITY property value.", null, 100);
            }
            if (rc.getValue() != 1) {
                Trace.verbose((Object)this, "modifySetActivity", "resume|suspend return code:" + rc.getValue());
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY_ERROR", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error");
            }
            try {
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        Trace.methodEnd(this, "modifySetActivity");
    }

    private void modifySetRole(Properties props, StorageArray sa, MirrorProxyRef mirrorProxyRef, CommandProcessor command, String repSetName) throws ConfigMgmtException {
        String METHOD_NAME = "modifySetRole";
        Trace.methodBegin(this, "modifySetRole");
        ReturnCode rc = new ReturnCode();
        Object reverseRoleProp = props.get("reverseRole");
        if (reverseRoleProp != null) {
            int reverseRole = (Integer)reverseRoleProp;
            MirrorRoleChangeDescriptor mirrorRoleChangeDescriptor = new MirrorRoleChangeDescriptor();
            mirrorRoleChangeDescriptor.setMirrorProxy(mirrorProxyRef);
            Boolean forceRole = new Boolean(false);
            String forceRoleProp = (String)props.get("forceRole");
            if (forceRoleProp != null) {
                forceRole = new Boolean(forceRoleProp);
            }
            mirrorRoleChangeDescriptor.setForced(forceRole.booleanValue());
            MirrorProxyRole mirrorProxyRole = new MirrorProxyRole();
            mirrorProxyRole.setValue(reverseRole);
            mirrorRoleChangeDescriptor.setToRole(mirrorProxyRole);
            command.execute(111, (XDRType)mirrorRoleChangeDescriptor, (XDRType)rc, true);
            int returnValue = rc.getValue();
            if (returnValue != 1) {
                if (forceRole.booleanValue() && returnValue == 166) {
                    Trace.verbose((Object)this, "modifySetRole", "force flag used, local role change successful.");
                } else {
                    Trace.error((Object)this, "modifySetRole", "roleChange() return code:" + returnValue);
                    LogAPI.staticLog((String)"REPLICATION_SET_MODIFY_ERROR", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + returnValue), "modify error");
                }
            }
            LogAPI.staticLog((String)"REPLICATION_SET_MODIFY", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
        }
        Trace.methodEnd(this, "modifySetRole");
    }

    private void modifySetPriority(Properties props, StorageArray sa, MirrorProxyVolume mirrorProxyVolume, CommandProcessor command, ObjectBundle bundle, String repSetName) throws ConfigMgmtException {
        String METHOD_NAME = "modifySetPriority";
        Trace.methodBegin(this, "modifySetPriority");
        ReturnCode rc = new ReturnCode();
        Object replicationPriorityProp = props.get("replicationPriority");
        if (replicationPriorityProp != null) {
            MirrorProxyRef mirrorProxyRef = mirrorProxyVolume.getMirrorProxyRef();
            int replicationPriority = (Integer)replicationPriorityProp;
            MirrorSyncPriorityDescriptor mirrorSyncPriorityDescriptor = new MirrorSyncPriorityDescriptor();
            mirrorSyncPriorityDescriptor.setMirrorProxy(mirrorProxyRef);
            MirrorSyncPriority mirrorSyncPriority = new MirrorSyncPriority();
            mirrorSyncPriority.setValue(replicationPriority);
            mirrorSyncPriorityDescriptor.setSyncPriority(mirrorSyncPriority);
            command.execute(108, (XDRType)mirrorSyncPriorityDescriptor, (XDRType)rc, true);
            Trace.verbose((Object)this, "modifySetPriority", "changeSynchronizationPriority() return code:" + rc.getValue());
            if (rc.getValue() != 1) {
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY_ERROR", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error");
            }
            try {
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            RemoteVolume remoteVolume = this.getRemoteVolume(mirrorProxyVolume.getRemoteVolRef(), bundle);
            String remotePeerWwn = Convert.bytesToString(remoteVolume.getRemoteArrayId().getWorldWideName());
            ObjectBundle remoteBundle = null;
            try {
                remoteBundle = ObjectBundleManager.getInstance().getObjectBundle(remotePeerWwn);
            }
            catch (ConfigMgmtException e) {
                Trace.error((Object)this, "modifySetPriority", "cant get object bundle for remote " + remotePeerWwn);
                throw new ConfigMgmtException(e.getExceptionKey(), "remote.array.not.registered");
            }
            MirrorProxyVolume rmpv = this.getMirrorProxyVolume(remoteBundle, Convert.bytesToString(remoteVolume.getRemoteVolWWN()), new ArrayList());
            mirrorSyncPriorityDescriptor.setMirrorProxy(rmpv.getMirrorProxyRef());
            try {
                CommandProcessor rcommand = new CommandProcessor(remotePeerWwn);
                rcommand.execute(108, (XDRType)mirrorSyncPriorityDescriptor, (XDRType)rc, true);
                if (rc.getValue() != 1) {
                    LogAPI.staticLog((String)"REPLICATION_SET_MODIFY_ERROR", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error");
                }
                try {
                    LogAPI.staticLog((String)"REPLICATION_SET_MODIFY", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            catch (RPCError rpc) {
                Trace.error((Object)this, "modifySetPriority", "RPC error");
                LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
            }
            catch (IOException io) {
                Trace.error((Object)this, "modifySetPriority", "IO error");
                LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
            }
            finally {
                ObjectBundleManager.getInstance().forceBundleReload(remotePeerWwn);
            }
        }
        Trace.methodEnd(this, "modifySetPriority");
    }

    private void modifySetAutoResync(Properties props, StorageArray sa, MirrorProxyVolume mirrorProxyVolume, CommandProcessor command, ObjectBundle bundle, String repSetName) throws ConfigMgmtException {
        String METHOD_NAME = "modifySetAutoResync";
        Trace.methodBegin(this, "modifySetAutoResync");
        Object autoSyncProp = props.get("autoSynchronize");
        if (autoSyncProp != null) {
            MirrorAutoResyncDescriptor mirrorAutoResyncDescriptor = new MirrorAutoResyncDescriptor();
            MirrorProxyRef mirrorProxyRef = mirrorProxyVolume.getMirrorProxyRef();
            mirrorAutoResyncDescriptor.setMirrorProxy(mirrorProxyRef);
            int autoSync = (Integer)autoSyncProp;
            if (autoSync == 1) {
                mirrorAutoResyncDescriptor.setAllowFlag(true);
            } else if (autoSync == 0) {
                mirrorAutoResyncDescriptor.setAllowFlag(false);
            } else {
                Trace.verbose((Object)this, "modifySetAutoResync", "unknown AUTO_SYNC value: " + autoSync);
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "unknown AUTO_SYNC value.", null, 100);
            }
            ReturnCode rc = new ReturnCode();
            command.execute(134, (XDRType)mirrorAutoResyncDescriptor, (XDRType)rc, true);
            if (rc.getValue() != 1) {
                Trace.verbose((Object)this, "modifySetAutoResync", "setAutoResync() return code:" + rc.getValue());
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY_ERROR", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error");
            }
            try {
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        Trace.methodEnd(this, "modifySetAutoResync");
    }

    private void modifySetWriteMode(Properties props, StorageArray sa, ObjectBundle bundle, MirrorProxyVolume mirrorProxyVol, CommandProcessor command, String repSetName) throws ConfigMgmtException {
        String METHOD_NAME = "modifySetReplicationMode";
        Trace.methodBegin(this, "modifySetReplicationMode");
        Object replicationModeProp = props.get("mode");
        Object constGroupProp = props.get("consistencyGroup");
        if (replicationModeProp != null || constGroupProp != null) {
            MirrorWriteModeDescriptor mirrorWriteModeDescriptor = new MirrorWriteModeDescriptor();
            mirrorWriteModeDescriptor.setMirrorProxy(mirrorProxyVol.getMirrorProxyRef());
            MirrorProxyWriteMode writeMode = new MirrorProxyWriteMode(mirrorProxyVol.getLocalWriteMode());
            ConsistencyGroupRef cgr = this.handleWriteMode(bundle, writeMode, replicationModeProp, constGroupProp);
            mirrorWriteModeDescriptor.setConsistencyGroupRef(cgr);
            mirrorWriteModeDescriptor.setWriteMode(writeMode);
            ReturnCode rc = new ReturnCode();
            command.execute(131, (XDRType)mirrorWriteModeDescriptor, (XDRType)rc, true);
            if (rc.getValue() != 1) {
                Trace.error((Object)this, "modifySetReplicationMode", "changeMirrorWriteMode() return code:" + rc.getValue());
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY_ERROR", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error");
            }
            try {
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
    }

    private Map populateVolumeRefVolumeMap(Volume[] volumes) {
        HashMap<String, Volume> volumeMap = new HashMap<String, Volume>();
        int length = volumes == null ? 0 : volumes.length;
        for (int i = 0; i < length; ++i) {
            volumeMap.put(Convert.bytesToString(volumes[i].getVolumeRef().getRefToken()), volumes[i]);
        }
        return volumeMap;
    }

    private Map populateVolumeRefVolumeMap(RemoteVolume[] volumes) {
        HashMap<String, RemoteVolume> volumeMap = new HashMap<String, RemoteVolume>();
        int length = volumes == null ? 0 : volumes.length;
        for (int i = 0; i < length; ++i) {
            volumeMap.put(Convert.bytesToString(volumes[i].getRemoteVolRef().getRefToken()), volumes[i]);
        }
        return volumeMap;
    }

    private Map populateVolumeRefVolumeMap(MirrorProxyVolume[] volumes) {
        HashMap<String, MirrorProxyVolume> volumeMap = new HashMap<String, MirrorProxyVolume>();
        int length = volumes == null ? 0 : volumes.length;
        for (int i = 0; i < length; ++i) {
            volumeMap.put(Convert.bytesToString(volumes[i].getBaseVolume().getRefToken()), volumes[i]);
        }
        return volumeMap;
    }

    static Map getReplicationSetKeyMap(String arrayWwn, String volumeWwn) {
        HashMap<String, String> key = new HashMap<String, String>(2);
        key.put("array", arrayWwn);
        key.put("volumeWwn", volumeWwn);
        return key;
    }

    private ReplicationSetMO populateReplicationSetMO(String arrayWWN, String baseVolume, String baseVolumeWWN, String remoteVolume, String remoteVolumeWWN, String replicationPeer, String replicationPeerWWN, int localRole, int mirrorProxyStatus, int localWriteMode, long usableCapacity, int localPriority, boolean autoResync) {
        String METHOD_NAME = "populateReplicationSetMO";
        Trace.methodBegin(this, "populateReplicationSetMO");
        ReplicationSetMO mo = new ReplicationSetMO();
        mo.setName(baseVolume.concat(REP_SET_NAME_SUFFIX));
        mo.setObjectItemType("repset");
        mo.setArrayWWN(arrayWWN);
        mo.setVolume(baseVolume);
        mo.setWwn(baseVolumeWWN);
        mo.setRemoteVolume(remoteVolume);
        mo.setRemoteVolumeWWN(remoteVolumeWWN);
        mo.setReplicationPeer(replicationPeer);
        mo.setReplicationPeerWWN(replicationPeerWWN);
        mo.setRole(localRole);
        mo.setMode(localWriteMode);
        mo.setUsableCapacity(usableCapacity);
        mo.setReplicationPriority(localPriority);
        if (mirrorProxyStatus == 7 || mirrorProxyStatus == 8) {
            Trace.verbose((Object)this, "populateReplicationSetMO", "DEGRADED status set to OPTIMAL");
            mo.setSynchronizationProgress(0);
        } else {
            mo.setSynchronizationProgress(this.getRepSetStatus(mo.getName(), mirrorProxyStatus));
        }
        if (localWriteMode == 2) {
            mo.setMode(1);
            mo.setConsistencyGroup(1);
        } else if (localWriteMode == 1) {
            mo.setMode(1);
            mo.setConsistencyGroup(0);
        } else {
            mo.setMode(0);
            mo.setConsistencyGroup(2);
        }
        if (autoResync) {
            mo.setAutoSynchronize(1);
        } else {
            mo.setAutoSynchronize(0);
        }
        Map key = ManageReplicationServices.getReplicationSetKeyMap(mo.getArrayWWN(), mo.getWwn());
        mo.setKey(key);
        Trace.methodEnd(this, "populateReplicationSetMO");
        return mo;
    }

    private void validateFilterContent(SearchFilter filter) throws ConfigMgmtException {
        String searchField;
        String METHOD_NAME = "validateFilterContent";
        if (!(filter == null || (searchField = filter.getSearchField()) != null && (searchField.equals("replicationSet") || searchField.equals("keyAsString") || searchField.equals("name")))) {
            Trace.verbose((Object)this, "validateFilterContent", "Search field not supported" + searchField);
            throw new ConfigMgmtException("error.search.field.not.supported", "error.search.field.not.supported: " + searchField);
        }
    }

    private boolean keyMatch(Map key, String arrayWwn, String VolumeWwn) {
        String keyArrayWwn = (String)key.get("array");
        String keyVolumeWwn = (String)key.get("volumeWwn");
        return keyArrayWwn.equals(arrayWwn) && keyVolumeWwn.equals(VolumeWwn);
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD_NAME = "getItemList";
        Trace.methodBegin(this, "getItemList");
        String myWwn = null;
        ArrayList<ReplicationSetMO> repsetList = new ArrayList<ReplicationSetMO>();
        if (this.scope == null) {
            Trace.error((Object)this, "getItemList", "missing wwn");
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
        }
        myWwn = Convert.scopeToArrayKey(this.scope);
        this.validateFilterContent(this.filter);
        try {
            this.clearRepsetsInRepository(true);
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
            HLVolumeBundle hlvb = bundle.getHighLevelVolBundle();
            MirrorProxyVolume[] mpv = hlvb.getMirrorVol();
            Volume[] localVols = bundle.getVolume();
            RemoteVolume[] remoteVols = hlvb.getRemoteVol();
            if (mpv == null || mpv.length == 0 || localVols == null || localVols.length == 0) {
                return repsetList;
            }
            Map localVolumeMap = this.populateVolumeRefVolumeMap(localVols);
            Map remoteVolumeMap = this.populateVolumeRefVolumeMap(remoteVols);
            Map missingVolumeMap = ManageVolumes.populateGhostVolumeRefVolumeMap(bundle.getGhostVolBundle().getGhostVol());
            int length = mpv == null ? 0 : mpv.length;
            for (int i = 0; i < length; ++i) {
                AbstractVolRef avr = mpv[i].getBaseVolume();
                String avrRefString = Convert.bytesToString(avr.getRefToken());
                Volume baseVolume = (Volume)localVolumeMap.get(avrRefString);
                String baseVolumeName = "";
                String baseVolumeWWN = "";
                if (baseVolume == null) {
                    Trace.verbose((Object)this, "getItemList", "Base volume is missing.");
                    continue;
                }
                baseVolumeName = baseVolume.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])baseVolume.getLabel().getValue()) : "";
                baseVolumeWWN = Convert.bytesToString(baseVolume.getWorldWideName());
                RemoteVolRef rvr = mpv[i].getRemoteVolRef();
                String rvrRefString = Convert.bytesToString(rvr.getRefToken());
                RemoteVolume remoteVolume = (RemoteVolume)remoteVolumeMap.get(rvrRefString);
                String remoteVolumeName = remoteVolume.getRemoteVolUserLabel().getValue() != null ? UnicodeTranslator.getString((byte[])remoteVolume.getRemoteVolUserLabel().getValue()) : "";
                String remoteVolumeWWN = Convert.bytesToString(remoteVolume.getRemoteVolWWN());
                String remoteVolumeStorageArrayWWN = Convert.bytesToString(remoteVolume.getRemoteArrayId().getWorldWideName());
                ObjectBundle remoteBundle = null;
                String remoteVolumeStorageArray = null;
                try {
                    remoteBundle = ObjectBundleManager.getInstance().getObjectBundle(remoteVolumeStorageArrayWWN);
                    remoteVolumeStorageArray = UnicodeTranslator.getString((byte[])remoteBundle.getSa().getSaData().getStorageArrayLabel().getValue());
                }
                catch (Exception e) {
                    remoteVolumeStorageArray = "remote.array.not.registered";
                }
                ReplicationSetMO mo = this.populateReplicationSetMO(myWwn, baseVolumeName, baseVolumeWWN, remoteVolumeName, remoteVolumeWWN, remoteVolumeStorageArray, remoteVolumeStorageArrayWWN, mpv[i].getLocalRole().getValue(), mpv[i].getLocalMirrorStatus().getValue(), mpv[i].getLocalWriteMode().getValue(), mpv[i].getUsableCapacity(), mpv[i].getLocalPriority().getValue(), mpv[i].getAutoResync());
                if (this.filter != null) {
                    if ("replicationSet".equals(this.filter.getSearchField()) && baseVolumeName.concat(REP_SET_NAME_SUFFIX).equals(this.filter.getSearchString())) {
                        repsetList.add(mo);
                        break;
                    }
                    if ("keyAsString".equals(this.filter.getSearchField()) && this.keyMatch(Convert.keyAsStringToMap(this.filter.getSearchString()), myWwn, baseVolumeWWN)) {
                        repsetList.add(mo);
                        break;
                    }
                    if (!this.filter.getSearchField().equals("name") || !this.filter.passesFilter(mo.getName())) continue;
                    repsetList.add(mo);
                    continue;
                }
                repsetList.add(mo);
            }
        }
        catch (ConfigMgmtException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), e.getMessage());
        }
        Trace.methodEnd(this, "getItemList");
        return repsetList;
    }

    public int getItemCount() throws ConfigMgmtException {
        int count;
        block10: {
            String METHOD_NAME = "getItemCount";
            Trace.methodBegin(this, "getItemCount");
            String myWwn = null;
            if (this.scope == null) {
                Trace.error((Object)this, "getItemCount", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
            myWwn = Convert.scopeToArrayKey(this.scope);
            this.validateFilterContent(this.filter);
            count = 0;
            try {
                ObjectBundleManager manager = ObjectBundleManager.getInstance();
                ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
                HLVolumeBundle hlvb = bundle.getHighLevelVolBundle();
                MirrorProxyVolume[] mirrorProxyVolume = hlvb.getMirrorVol();
                if (this.filter == null) {
                    if (mirrorProxyVolume != null) {
                        count = mirrorProxyVolume.length;
                    }
                    break block10;
                }
                Volume[] localVols = bundle.getVolume();
                if (mirrorProxyVolume == null || mirrorProxyVolume.length == 0 || localVols == null || localVols.length == 0) {
                    count = 0;
                    break block10;
                }
                Map localVolumeMap = this.populateVolumeRefVolumeMap(localVols);
                int length = mirrorProxyVolume.length;
                for (int i = 0; i < length; ++i) {
                    Volume baseVolume = (Volume)localVolumeMap.get(Convert.bytesToString(mirrorProxyVolume[i].getBaseVolume().getRefToken()));
                    String baseVolumeName = "";
                    if (baseVolume != null) {
                        String string = baseVolumeName = baseVolume.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])baseVolume.getLabel().getValue()) : "";
                    }
                    if ("replicationSet".equals(this.filter.getSearchField()) && baseVolumeName.concat(REP_SET_NAME_SUFFIX).equals(this.filter.getSearchString())) {
                        ++count;
                    } else {
                        if (!"keyAsString".equals(this.filter.getSearchField()) || baseVolume == null || !this.keyMatch(Convert.keyAsStringToMap(this.filter.getSearchString()), myWwn, Convert.bytesToString(baseVolume.getWorldWideName()))) continue;
                        ++count;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), e.getMessage());
            }
        }
        Trace.methodEnd(this, "getItemCount");
        return count;
    }

    public int getMaxObjects() {
        String METHOD_NAME = "getMaxObjects";
        Trace.methodBegin(this, "getMaxObjects");
        Trace.methodEnd(this, "getMaxObjects");
        return 32;
    }

    public int[] testCommunication(Object key) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        int[] result = new int[]{0};
        Map myKeys = null;
        if (key instanceof Map) {
            myKeys = (Map)key;
        } else if (key instanceof String) {
            myKeys = Convert.keyAsStringToMap((String)key);
        }
        if (myKeys == null) {
            Trace.error((Object)this, "modify", "missing key obj");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "missing key obj");
        }
        String arrayWwn = (String)myKeys.get("array");
        String volumeWwn = (String)myKeys.get("volumeWwn");
        StorageArray sa = null;
        try {
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
            sa = bundle.getSa();
            if (!this.isReplicationSetLicensed(sa, 13)) {
                Trace.error((Object)this, "modify", "license disabled");
                throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
            }
            if (volumeWwn == null) {
                Trace.error((Object)this, "modify", "Missing replication set key.");
                throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing REPLICATION_SET key");
            }
            ArrayList baseVolumeList = new ArrayList(1);
            MirrorProxyVolume mirrorProxyVolume = this.getMirrorProxyVolume(bundle, volumeWwn, baseVolumeList);
            String repSetName = this.getRepSetName(baseVolumeList);
            RemoteVolRef remoteVolRef = mirrorProxyVolume.getRemoteVolRef();
            RemoteCommunicationCheckSampleList remoteCommunicationCheckSampleList = new RemoteCommunicationCheckSampleList();
            RemoteCommunicationCheckDescriptor remoteCommunicationCheckDescriptor = new RemoteCommunicationCheckDescriptor();
            remoteCommunicationCheckDescriptor.setRemoteVolume(remoteVolRef);
            remoteCommunicationCheckDescriptor.setNumSamples(4);
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayWwn);
            CommandProcessor command = new CommandProcessor(arrayWwn);
            command.execute(145, (XDRType)remoteCommunicationCheckDescriptor, (XDRType)remoteCommunicationCheckSampleList, true);
            ReturnCode rc = remoteCommunicationCheckSampleList.getReturnCode();
            ReturnCode testStatus = remoteCommunicationCheckSampleList.getTestStatus();
            if (rc.getValue() != 1 || testStatus.getValue() != 1) {
                String message = "communicationCheck() return code:" + rc.getValue() + "communicationCheck() test status:" + testStatus.getValue();
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY_ERROR", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                if (rc.getValue() != 1) {
                    throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error: " + message);
                }
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + testStatus.getValue()), "modify error: " + message);
            }
            try {
                LogAPI.staticLog((String)"REPLICATION_SET_MODIFY", (String[])new String[]{repSetName, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            result = remoteCommunicationCheckSampleList.getRemoteCommunicationCheckSamples();
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "modify", "RPC error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "modify", "IO error");
            LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayWwn);
        }
        Trace.methodEnd(this, "modify");
        return result;
    }

    private String getRepSetName(List baseVolumeList) {
        Volume baseVolume;
        byte[] baseVolumeNameBytes;
        String repSetName = "";
        if (baseVolumeList.size() == 1 && (baseVolumeNameBytes = (baseVolume = (Volume)baseVolumeList.get(0)).getLabel().getValue()) != null) {
            repSetName = UnicodeTranslator.getString((byte[])baseVolume.getLabel().getValue()).concat(REP_SET_NAME_SUFFIX);
        }
        return repSetName;
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String VOLUME_WWN = "volumeWwn";
    }

    public static interface ReplicationSetProps {
        public static final String LOCAL_VOLUME = "localVolume";
        public static final String PEER_WWN = "peerWwn";
        public static final String REMOTE_ARRAY_NAME = "remoteArrayName";
        public static final String REMOTE_VOLUME_NAME = "remoteVolumeName";
        public static final String REPLICATION_MODE = "mode";
        public static final String CONSISTENCY_GROUP = "consistencyGroup";
        public static final String REPLICATION_PRIORITY = "replicationPriority";
        public static final String AUTO_SYNC = "autoSynchronize";
        public static final String REVERSE_ROLE = "reverseRole";
        public static final String FORCE_ROLE = "forceRole";
        public static final String REPLICATION_ACTIVITY = "replicationActivity";
        public static final String TEST_COMMUNICATION = "testCommunication";
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String REPLICATION_SET = "replicationSet";
    }
}

