/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationGroupEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationParametersEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationSetEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationGroupCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationParametersCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;

public class ReplicationSetCIM
implements ReplicationSetEnt1Interface {
    private String name;
    private String description;
    private int setIndex = 0;
    private String peerWwn;
    private String remoteVolumeWwn;
    private int syncPercent = -1;
    private int syncState = 0;
    private BigInteger bitmapSize;
    private int repErrorStatus;
    private String groupWwn;
    private String repWwn;
    private StorageVolumeInterface localVolume;
    private VDiskEnt1Interface bitmapVDisk;
    private ReplicationParametersCIM repParams;
    private ReplicationGroupCIM group;
    private VDiskEnt1Interface asyncQueue;
    private BigInteger queueSize;
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private CIMInstance instance;
    private String systemName;
    private String systemCreationClassName;
    private String creationClassName;
    private ArrayList keys;
    private Set usageByRepSet = new HashSet();

    public ReplicationSetCIM(CIMInstance ci, ConfigContext context) {
        CIMValue cvSysName;
        String METHOD = "ReplicationSet(CIMInstance, ConfigContext";
        Trace.methodBegin(this, "ReplicationSet(CIMInstance, ConfigContext");
        CIMValue cvName = ci.getProperty("ElementName").getValue();
        if (cvName != null) {
            this.setName((String)cvName.getValue());
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: name.");
        }
        CIMValue cvDesc = ci.getProperty("Description").getValue();
        if (cvDesc != null) {
            this.setDescription((String)cvDesc.getValue());
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: description.");
        }
        CIMValue cvSetIndex = ci.getProperty("SetIndex").getValue();
        if (cvSetIndex != null) {
            this.setSetIndex(((UnsignedInt16)cvSetIndex.getValue()).intValue());
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: setIndex.");
        }
        CIMValue cvDeviceID = ci.getProperty("DeviceID").getValue();
        if (cvDeviceID != null) {
            this.setRemoteVolumeWwn((String)cvDeviceID.getValue());
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: deviceID.");
        }
        CIMValue cvBitmapSize = ci.getProperty("BitmapSize").getValue();
        if (cvBitmapSize != null) {
            this.setBitmapSize(((UnsignedInt64)cvBitmapSize.getValue()).bigIntValue());
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: bitmapSize.");
        }
        CIMProperty pRepErrorStatus = ci.getProperty("ReplicationErrorStatus");
        if (pRepErrorStatus != null) {
            CIMValue cvRepErrorStatus = pRepErrorStatus.getValue();
            if (cvRepErrorStatus != null) {
                UnsignedInt32 val = (UnsignedInt32)cvRepErrorStatus.getValue();
                if (val != null) {
                    this.setErrorStatus(val.intValue());
                } else {
                    Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: repErrorStatus.");
                }
            }
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: repErrorStatus.");
        }
        CIMProperty pGroupWwn = ci.getProperty("GroupWWN");
        if (pGroupWwn != null) {
            String val;
            CIMValue cvGroupWwn = pGroupWwn.getValue();
            if (cvGroupWwn != null && (val = (String)cvGroupWwn.getValue()) != null) {
                this.groupWwn = val;
            }
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: repErrorStatus.");
        }
        CIMProperty otherId = ci.getProperty("OtherIdentifyingInfo");
        if (otherId != null) {
            CIMValue otherIdVal = otherId.getValue();
            if (otherIdVal != null) {
                Vector v = (Vector)otherIdVal.getValue();
                String val = null;
                if (v.size() > 1) {
                    val = (String)v.get(1);
                }
                if (val != null) {
                    this.repWwn = val;
                } else {
                    Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet WWN. Value is null.");
                }
            } else {
                Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet WWN. Property value doesn't exist.");
            }
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet WWN: Property doesn't exist.");
        }
        if (this.repWwn == null) {
            this.repWwn = "";
        }
        if ((cvSysName = ci.getProperty("SystemName").getValue()) != null) {
            this.setSystemName((String)cvSysName.getValue());
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: system name.");
        }
        CIMValue cvSysCrClass = ci.getProperty("SystemCreationClassName").getValue();
        if (cvSysCrClass != null) {
            this.setSystemCreationClassName((String)cvSysCrClass.getValue());
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: sysCreationClassName.");
        }
        CIMValue cvCreationClass = ci.getProperty("CreationClassName").getValue();
        if (cvCreationClass != null) {
            this.setCreationClassName((String)cvCreationClass.getValue());
        } else {
            Trace.error((Object)this, "ReplicationSet(CIMInstance, ConfigContext", "Could not populate ReplicationSet: creationClassName.");
        }
        this.queueSize = BigInteger.ZERO;
        this.setCIMInstance(ci);
        this.setConfigContext(context);
        Trace.methodEnd(this, "ReplicationSet(CIMInstance, ConfigContext");
    }

    public String getName() {
        String METHOD = "getName";
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            return "";
        }
        Trace.methodEnd(this, "getName");
        return this.name;
    }

    public String getDescription() {
        String METHOD = "getDescription";
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            return "";
        }
        Trace.methodEnd(this, "getDescription");
        return this.description;
    }

    public int getSetIndex() {
        String METHOD = "getSetIndex";
        Trace.methodBegin(this, "getSetIndex");
        Trace.methodEnd(this, "getSetIndex");
        return this.setIndex;
    }

    public int getState() throws ConfigMgmtException {
        String METHOD = "getState";
        Trace.methodBegin(this, "getState");
        if (this.syncState == 0) {
            this.loadStorageSynch();
        }
        if (this.syncState == 6) {
            this.syncState = 1;
        } else if (this.syncState == 13) {
            this.syncState = 3;
        } else if (this.syncState == 5) {
            this.syncState = 2;
        }
        Trace.methodEnd(this, "getState");
        return this.syncState;
    }

    public ReplicationGroupEnt1Interface getReplicationGroup() throws ConfigMgmtException {
        String METHOD = "getReplicationGroup";
        Trace.methodBegin(this, "getReplicationGroup");
        if (this.group == null) {
            Trace.verbose((Object)this, "getReplicationGroup", "Querying CIM for associated ReplicationGroup Instance");
            Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPMemberOfCollection", "SunStorEdge_DSPReplicationGroup", "Member", "Collection", true, false, null);
            Trace.verbose((Object)this, "getReplicationGroup", "Returned from querying CIM for associated  ReplicationGroup Instance");
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                this.group = new ReplicationGroupCIM(ci, this.context);
            }
        }
        Trace.methodEnd(this, "getReplicationGroup");
        return this.group;
    }

    public StorageVolumeInterface getLocalVolume() throws ConfigMgmtException {
        String METHOD = "getLocalVolume";
        Trace.methodBegin(this, "getLocalVolume");
        if (this.localVolume == null) {
            Trace.verbose((Object)this, "getLocalVolume", "Querying the CIM for a StorageVolume instance.");
            Enumeration enumVol = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPRemoteStorageSynchronized", "SunStorEdge_DSPStorageVolume", "SyncedElement", "SystemElement", true, false, null);
            Trace.verbose((Object)this, "getLocalVolume", "Returned from querying the CIM for a StorageVolume instance");
            if (enumVol != null && enumVol.hasMoreElements()) {
                Trace.verbose((Object)this, "getLocalVolume", "StorageVolume instance found.");
                CIMInstance ci = (CIMInstance)enumVol.nextElement();
                StorageVolume sv = new StorageVolume();
                sv.setInstance(ci);
                sv.init(this.context);
                CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                sv.loadKeys();
                this.localVolume = sv;
            } else {
                Trace.verbose((Object)this, "getLocalVolume", "LocalVolume could not be found");
            }
        }
        Trace.methodEnd(this, "getLocalVolume");
        return this.localVolume;
    }

    public String getPeerWwn() throws ConfigMgmtException {
        String METHOD = "getPeerWwn";
        Trace.methodBegin(this, "getPeerWwn");
        if (this.peerWwn == null) {
            this.getReplicationParameters();
        }
        Trace.methodEnd(this, "getPeerWwn");
        String tmpWwn = Convert.wwnToString(this.peerWwn);
        return Convert.toShortRemotePeerWWN(tmpWwn);
    }

    public String getRemoteVolumeWwn() {
        String METHOD = "getRemoteVolumeWwn";
        Trace.methodBegin(this, "getRemoteVolumeWwn");
        if (this.remoteVolumeWwn == null) {
            return "";
        }
        Trace.methodEnd(this, "getRemoteVolumeWwn");
        return Convert.wwnToString(this.remoteVolumeWwn);
    }

    public int getSyncProgress() throws ConfigMgmtException {
        String METHOD = "getSyncProgress";
        Trace.methodBegin(this, "getSyncProgress");
        if (this.syncPercent == -1) {
            this.loadStorageSynch();
        }
        Trace.methodEnd(this, "getSyncProgress");
        return this.syncPercent;
    }

    public BigInteger getBitmapSize() {
        String METHOD = "getBitmapSize";
        Trace.methodBegin(this, "getBitmapSize");
        Trace.methodEnd(this, "getBitmapSize");
        return this.bitmapSize;
    }

    public VDiskEnt1Interface getBitmapVDisk() throws ConfigMgmtException {
        String METHOD = "getBitmapVDisk";
        Trace.methodBegin(this, "getBitmapVDisk");
        if (this.bitmapVDisk == null) {
            Trace.verbose((Object)this, "getBitmapVDisk", "Querying the CIM for a StorageExtent instance.");
            Enumeration enumExtent = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPBasedOn", "SunStorEdge_DSPStorageExtent", "Dependent", "Antecedent", true, false, null);
            Trace.verbose((Object)this, "getBitmapVDisk", "Returned from querying the CIM for a StorageExtent instance");
            if (enumExtent != null && enumExtent.hasMoreElements()) {
                Trace.verbose((Object)this, "getBitmapVDisk", "StorageExtent instance found.");
                CIMInstance ci = (CIMInstance)enumExtent.nextElement();
                VDisk vd = new VDisk();
                vd.setInstance(ci);
                vd.init(this.context);
                CIMObjectWrapper.populate(vd, vd.getFieldMap(), ci);
                vd.loadKeys();
                this.bitmapVDisk = vd;
            } else {
                Trace.verbose((Object)this, "getBitmapVDisk", "Bitmap VDisk could not be found");
            }
        }
        Trace.methodEnd(this, "getBitmapVDisk");
        return this.bitmapVDisk;
    }

    public ReplicationParametersEnt1Interface getReplicationParameters() throws ConfigMgmtException {
        String METHOD = "getReplicationParameters";
        Trace.methodBegin(this, "getReplicationParameters");
        if (this.repParams == null) {
            Trace.verbose((Object)this, "getReplicationParameters", "Querying the CIM for associated ReplicationParameters");
            if (this.groupWwn == null) {
                Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPElementSettingData", "SunStorEdge_DSPReplicationParameters", "ManagedElement", "SettingData", true, false, null);
                Trace.verbose((Object)this, "getReplicationParameters", "Returned from querying the CIM for associated ReplicationParameters");
                if (enumeration != null && enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getReplicationParameters", "ReplicationParameters instance found.");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    this.repParams = new ReplicationParametersCIM(ci, this.context);
                    this.peerWwn = (String)ci.getProperty("Peer").getValue().getValue();
                } else {
                    Trace.error((Object)this, "getReplicationParameters", "No ReplicationParameters found");
                }
            } else {
                Trace.verbose((Object)this, "getReplicationParameters", "Looking for ReplicationParameters in RepGrp");
                Trace.verbose((Object)this, "getReplicationParameters", "Searching ReplicationGroup association");
                if (this.group == null) {
                    this.getReplicationGroup();
                }
                if (this.group != null) {
                    this.repParams = (ReplicationParametersCIM)this.group.getReplicationParameters();
                    this.peerWwn = this.group.getPeerWwn();
                } else {
                    Trace.error((Object)this, "getReplicationParameters", "Replication Parameters from Replication Group missing or from ReplicationSet");
                }
            }
            if (this.repParams != null) {
                this.queueSize = this.repParams.getAsyncQueueSize(this);
            } else {
                Trace.error((Object)this, "getReplicationParameters", "Replication Parameters missing for ReplicationSet");
            }
        }
        Trace.methodEnd(this, "getReplicationParameters");
        return this.repParams;
    }

    public Collection getKey() {
        String METHOD = "getKey";
        Trace.methodBegin(this, "getKey");
        if (this.keys == null) {
            this.keys = new ArrayList();
            this.keys.add(new CIMProperty("SystemCreationClassName", new CIMValue((Object)this.systemCreationClassName)));
            this.keys.add(new CIMProperty("SystemName", new CIMValue((Object)this.systemName)));
            this.keys.add(new CIMProperty("CreationClassName", new CIMValue((Object)this.creationClassName)));
            this.keys.add(new CIMProperty("DeviceID", new CIMValue((Object)this.remoteVolumeWwn)));
        }
        Trace.methodEnd(this, "getKey");
        return this.keys;
    }

    public VDiskEnt1Interface getAsyncQStorage() throws ConfigMgmtException {
        String METHOD = "getAsyncQStorage";
        Trace.methodBegin(this, "getAsyncQStorage");
        if (this.asyncQueue == null) {
            this.getReplicationParameters();
            if (this.group == null) {
                this.asyncQueue = (VDiskEnt1Interface)this.repParams.getAsyncQStorage(this);
            }
        }
        Trace.methodEnd(this, "getAsyncQStorage");
        return this.asyncQueue;
    }

    public BigInteger getAsyncQueueSize() {
        String METHOD = "getAsyncQueueSize";
        Trace.methodBegin(this, "getAsyncQueueSize");
        if (this.asyncQueue == null) {
            try {
                this.getReplicationParameters();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getAsyncQueueSize", "Error getting replication parameters for the ReplicationSet");
            }
        }
        Trace.methodEnd(this, "getAsyncQueueSize");
        return this.queueSize;
    }

    public BigInteger getVolumeCapacity() {
        String METHOD = "getVolumeCapacity";
        BigInteger cap = BigInteger.ZERO;
        Trace.methodBegin(this, "getVolumeCapacity");
        if (this.localVolume == null) {
            try {
                this.getLocalVolume();
            }
            catch (ConfigMgmtException cex) {
                Trace.error((Object)this, "getVolumeCapacity", "Error retreiving local volume");
            }
        }
        if (this.localVolume != null) {
            cap = this.localVolume.getCapacity();
        }
        Trace.methodEnd(this, "getVolumeCapacity");
        return cap;
    }

    public int getErrorStatus() {
        String METHOD = "getErrorStatus";
        Trace.methodBegin(this, "getErrorStatus");
        Trace.methodEnd(this, "getErrorStatus");
        return this.repErrorStatus;
    }

    public boolean isErrorStatusOn() {
        String METHOD = "isErrorStatusOn";
        Trace.methodBegin(this, "isErrorStatusOn");
        Trace.methodEnd(this, "isErrorStatusOn");
        return this.repErrorStatus != 0;
    }

    public String getSetWwn() {
        String METHOD = "getSetWwn";
        Trace.methodBegin(this, "getSetWwn");
        String tmpWwn = Convert.wwnToString(this.repWwn);
        Trace.methodEnd(this, "getSetWwn");
        return tmpWwn == null ? "" : tmpWwn;
    }

    public CIMInstance getCIMInstance() {
        String METHOD = "getCIMInstance";
        Trace.methodBegin(this, "getCIMInstance");
        Trace.methodEnd(this, "getCIMInstance");
        return this.instance;
    }

    public void setName(String name) {
        String METHOD = "setName";
        Trace.methodBegin(this, "setName");
        this.name = name;
        Trace.methodEnd(this, "setName");
    }

    public void setDescription(String description) {
        String METHOD = "setDescription";
        Trace.methodBegin(this, "setDescription");
        this.description = description;
        Trace.methodEnd(this, "setDescription");
    }

    public void setSetIndex(int setIndex) {
        String METHOD = "setSetIndex";
        Trace.methodBegin(this, "setSetIndex");
        this.setIndex = setIndex;
        Trace.methodEnd(this, "setSetIndex");
    }

    public void setRemoteVolumeWwn(String remoteVolumeWwn) {
        String METHOD = "setRemoteVolumeWwn";
        Trace.methodBegin(this, "setRemoteVolumeWwn");
        this.remoteVolumeWwn = remoteVolumeWwn;
        Trace.methodEnd(this, "setRemoteVolumeWwn");
    }

    public void setBitmapSize(BigInteger bitmapSize) {
        String METHOD = "setBitmapSize";
        Trace.methodBegin(this, "setBitmapSize");
        this.bitmapSize = bitmapSize;
        Trace.methodEnd(this, "setBitmapSize");
    }

    public void setErrorStatus(int repErrorStatus) {
        String METHOD = "setErrorStatus";
        Trace.methodBegin(this, "setErrorStatus");
        this.repErrorStatus = repErrorStatus;
        Trace.methodEnd(this, "setErrorStatus");
    }

    public void setSystemName(String systemName) {
        String METHOD = "setSystemName";
        Trace.methodBegin(this, "setSystemName");
        this.systemName = systemName;
        Trace.methodEnd(this, "setSystemName");
    }

    public void setSystemCreationClassName(String systemCreationClassName) {
        String METHOD = "setSystemCreationClassName";
        Trace.methodBegin(this, "setSystemCreationClassName");
        this.systemCreationClassName = systemCreationClassName;
        Trace.methodEnd(this, "setSystemCreationClassName");
    }

    public void setCreationClassName(String creationClassName) {
        String METHOD = "setCreationClassName";
        Trace.methodBegin(this, "setCreationClassName");
        this.creationClassName = creationClassName;
        Trace.methodEnd(this, "setCreationClassName");
    }

    public void setConfigContext(ConfigContext context) {
        String METHOD = "setConfigContext";
        Trace.methodBegin(this, "setConfigContext");
        this.context = context;
        this.handle = context.getClient();
        Trace.methodEnd(this, "setConfigContext");
    }

    public void setCIMInstance(CIMInstance instance) {
        String METHOD = "setCIMInstance";
        Trace.methodBegin(this, "setCIMInstance");
        this.instance = instance;
        Trace.methodEnd(this, "setCIMInstance");
    }

    public String toString() {
        String METHOD = "toString";
        Trace.methodBegin(this, "toString");
        if (Trace.isTraceEnabled(this)) {
            Trace.methodEnd(this, "toString");
            return "ReplicationSet with:\n   Name: " + this.getName() + "\n   Description: " + this.getDescription() + "\n   SetIndex: " + this.getSetIndex() + "\n   RemoteVolumeWwn: " + this.getRemoteVolumeWwn() + "\n   Bitmap Size: " + this.getBitmapSize();
        }
        Trace.methodEnd(this, "toString");
        return "";
    }

    private void loadStorageSynch() throws ConfigMgmtException {
        String METHOD = "loadStorageSynch";
        Trace.methodBegin(this, "loadStorageSynch");
        Trace.verbose((Object)this, "loadStorageSynch", "Querying the CIM for a  RemoteStorageSynchronized association.");
        Enumeration enumAssoc = this.handle.references(this.instance.getObjectPath(), "SunStorEdge_DSPRemoteStorageSynchronized", "SyncedElement", true, false, null);
        Trace.verbose((Object)this, "loadStorageSynch", "Returned from querying the CIM for a RemoteStorageSynchronized association");
        if (enumAssoc != null && enumAssoc.hasMoreElements()) {
            Trace.verbose((Object)this, "loadStorageSynch", "RemoteStorageSynchronized association instance found.");
            CIMInstance ci = (CIMInstance)enumAssoc.nextElement();
            this.syncPercent = ((UnsignedInt16)ci.getProperty("ResyncPercent").getValue().getValue()).intValue();
            this.syncState = ((UnsignedInt16)ci.getProperty("SyncState").getValue().getValue()).intValue();
        } else {
            Trace.verbose((Object)this, "loadStorageSynch", "RemoteStorageSynchronized association not found.");
            this.syncPercent = 100;
            this.syncState = 0;
        }
        Trace.methodEnd(this, "loadStorageSynch");
    }

    public Set getUsageByRepSet() {
        return this.usageByRepSet;
    }

    public void setUsageByRepSet(Set usageByRepSet) {
        this.usageByRepSet = usageByRepSet;
    }
}

