/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageSnapShotServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.SnapShotVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirrorComponentCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirroredVolumeCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.SnapShotVolumeCIM;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.ent1.Job;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class ManageSnapShotServicesCIM
implements ManageSnapShotServicesEnt1Interface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private SearchFilter filter;
    private Scope scope;

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        String METHOD = "init";
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ConfigContext object is null"), 100);
        }
        this.context = context;
        this.handle = context.getClient();
        this.scope = scope;
        this.filter = filter;
        if (this.handle == null) {
            Trace.error((Object)this, "init", "Client object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Client object is null."), 100);
        }
    }

    public void create(Properties prop) throws ConfigMgmtException {
        String METHOD = "create";
        Trace.methodBegin(this, "create");
        Trace.methodEnd(this, "create");
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String METHOD = "delete";
        Trace.methodBegin(this, "delete");
        Trace.methodEnd(this, "delete");
        return null;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD = "modify";
        Trace.methodBegin(this, "modify");
        Trace.methodEnd(this, "modify");
    }

    public int getItemCount() throws ConfigMgmtException {
        String METHOD = "getItemCount";
        Trace.methodBegin(this, "getItemCount");
        Trace.methodEnd(this, "getItemCount");
        return this.getItemList().size();
    }

    public int getMaxObjects() {
        String METHOD = "getMaxObjects";
        Trace.methodBegin(this, "getMaxObjects");
        Trace.methodEnd(this, "getMaxObjects");
        return -1;
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD = "getItemList";
        Trace.methodBegin(this, "getItemList");
        List snapshots = new ArrayList();
        if (this.scope == null) {
            snapshots = this.getItemsBySystem();
        }
        Trace.methodEnd(this, "getItemList");
        return snapshots;
    }

    public SnapShotVolumeEnt1Interface getByKey(Collection key) throws ConfigMgmtException {
        String METHOD = "getByKey";
        Trace.methodBegin(this, "getByKey");
        SnapShotVolumeCIM snap = null;
        if (key != null) {
            CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPStorageVolume", new Vector(key));
            Trace.verbose((Object)this, "getByKey", "Querying CIM for SnapShotVolume Instance matching key(s)");
            CIMInstance ci = this.handle.getInstance(objPath, false, true, false, ConstantsEnt.StorageVolumeProperties.PROPERTY_NAMES);
            Trace.verbose((Object)this, "getByKey", "Returned from querying CIM for SnapShotVolume Instance matching key(s)");
            if (ci != null) {
                Trace.verbose((Object)this, "getByKey", "Creating SnapShotVolume Java Object");
                snap = new SnapShotVolumeCIM();
                snap.setInstance(ci);
                snap.init(this.context);
                CIMObjectWrapper.populate(snap, snap.getFieldMap(), ci);
                snap.loadKeys();
            } else {
                Trace.error((Object)this, "getByKey", "Snapshot specified not found.");
            }
        } else {
            Trace.error((Object)this, "getByKey", "Key object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Key object is null"), 100);
        }
        Trace.methodEnd(this, "getByKey");
        return snap;
    }

    public SnapShotVolumeEnt1Interface getItemByName(String name) throws ConfigMgmtException {
        String METHOD = "getItemByName";
        Trace.methodBegin(this, "getItemByName");
        SnapShotVolumeCIM snap = null;
        Trace.verbose((Object)this, "getItemByName", "Querying CIM for SnapShotVolume: " + name);
        Enumeration enumeration = CIMObjectWrapper.execQuery(this.handle, "Select * from SunStorEdge_DSPStorageVolume where ElementName = '" + name + "'");
        Trace.verbose((Object)this, "getItemByName", "Returned from querying CIM for SnapShotVolume: " + name);
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getItemByName", "SnapShotVolume: " + name + " Found.");
            while (enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemByName", "Creating SnapShotVolume Java Object");
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                snap = new SnapShotVolumeCIM();
                snap.setInstance(ci);
                snap.init(this.context);
                CIMObjectWrapper.populate(snap, snap.getFieldMap(), ci);
                snap.loadKeys();
            }
        } else {
            Trace.verbose((Object)this, "getItemByName", "No instance returned when trying to obtain the SnapShotVolume: " + name);
        }
        Trace.methodEnd(this, "getItemByName");
        return snap;
    }

    public MethodCallStatus createSnapshot(StorageVolume parent, StoragePool snapPool, String name, String description, int snapNum, int snapChange, int snapPolicy) throws BadParameterException, ConfigMgmtException {
        String METHOD = "createSnapshot";
        Trace.methodBegin(this, "createSnapshot");
        MethodCallStatus mcs = null;
        mcs = parent.createSnapshotPool(snapPool, snapNum, snapChange, snapPolicy);
        if (mcs.getReturnCode() == 0) {
            parent.reload();
            mcs = this.createSnapshot(parent, name, description);
        }
        Trace.methodEnd(this, "createSnapshot");
        return mcs;
    }

    public MethodCallStatus createSnapshot(StorageVolume parent, String name, String description, int snapNum, int snapChange) throws BadParameterException, ConfigMgmtException {
        String METHOD = "createSnapshot";
        Trace.methodBegin(this, "createSnapshot");
        MethodCallStatus mcs = null;
        if (null != this.getItemByName(name)) {
            Trace.error((Object)this, "createSnapshot", "New snapshot name already in use");
            mcs = new MethodCallStatus();
            mcs.setReturnCode(33519);
        } else {
            mcs = parent.extendSnapshotPool(snapNum, snapChange);
            if (mcs.getReturnCode() == 0) {
                parent.reload();
                mcs = this.createSnapshot(parent, name, description);
            }
        }
        Trace.methodEnd(this, "createSnapshot");
        return mcs;
    }

    public MethodCallStatus createSnapshot(StorageVolume parent, String name, String description) throws BadParameterException, ConfigMgmtException {
        String METHOD = "createSnapshot";
        Trace.methodBegin(this, "createSnapshot");
        MethodCallStatus methodCallStatus = null;
        MirrorComponentCIM snapComp = null;
        ManageStoragePools msp = new ManageStoragePools();
        msp.init(this.context, null);
        String poolName = null;
        String sdomainName = null;
        if (parent instanceof MirroredVolumeCIM) {
            snapComp = (MirrorComponentCIM)((MirroredVolumeCIM)parent).getSnapshotComponent();
            if (snapComp == null) {
                Trace.error((Object)this, "createSnapshot", "Mirror does not have a snapshot reserve");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.SNAP_POOLRESERVED_MISSING, null, "Mirrored volume does not have snapshot reserve"), 300);
            }
            poolName = snapComp.getStoragePoolName();
            sdomainName = snapComp.getStorageDomainName();
        } else {
            poolName = parent.getStoragePoolName();
            sdomainName = parent.getStorageDomainName();
        }
        StoragePool poolObj = null;
        try {
            poolObj = (StoragePool)msp.getItemByName(poolName, sdomainName);
        }
        catch (ItemNotFoundException itex) {
            Trace.error((Object)this, "createSnapshot", "StorageDomain not found");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{sdomainName}, "StorageDomain specified not found."), 100);
        }
        if (poolObj == null) {
            Trace.error((Object)this, "createSnapshot", "StoragePool not found");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{poolName}, "StoragePool specified not found."), 100);
        }
        Trace.verbose((Object)this, "createSnapshot", "Querying CIM for associated StorageCapabilities Instance");
        Enumeration enumeration = this.handle.associators(poolObj.getInstance().getObjectPath(), "SunStorEdge_DSPElementCapabilities", "SunStorEdge_DSPStorageCapabilities", "ManagedElement", "Capabilities", true, false, ConstantsEnt.StorageCapabilitiesProperties.PROP_LIST);
        Trace.verbose((Object)this, "createSnapshot", "Returned from querying CIM for associated StorageCapabilities Instance");
        CIMArgument[] createSettingOutArgs = new CIMArgument[1];
        CIMArgument[] createSettingInArgs = new CIMArgument[1];
        CIMInstance setting = new CIMInstance();
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "createSnapshot", "StorageCapabilities Instance Found");
            CIMInstance profile = (CIMInstance)enumeration.nextElement();
            createSettingInArgs[0] = new CIMArgument("SettingType", new CIMValue((Object)new UnsignedInt16(2)));
            Trace.verbose((Object)this, "createSnapshot", "Calling CreateSetting");
            CIMValue settingCodeValue = this.handle.invokeMethod(profile.getObjectPath(), "CreateSetting", createSettingInArgs, createSettingOutArgs);
            Trace.verbose((Object)this, "createSnapshot", "Returned from calling CreateSetting");
            CIMObjectPath settingPath = (CIMObjectPath)createSettingOutArgs[0].getValue().getValue();
            setting = this.handle.getInstance(settingPath, false, true, true);
            int snapNum = parent.getNumAllocatedSnapshots();
            int snapChange = parent.getSnapshotWriteActivity();
            int snapShotPolicy = parent.getSnapshotPolicy();
            try {
                setting.setProperty("SnapshotCount", new CIMValue((Object)new UnsignedInt16(snapNum)));
                setting.setProperty("WriteActivity", new CIMValue((Object)new UnsignedInt16(snapChange)));
                setting.setProperty("SnapshotPoolPercent", new CIMValue((Object)new UnsignedInt16(snapNum * snapChange)));
                setting.setProperty("SnapshotPolicy", new CIMValue((Object)new UnsignedInt16(snapShotPolicy)));
            }
            catch (CIMException ce) {
                Trace.error((Object)this, "createSnapshot", "Errors setting snapshot properties");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Errors setting snapshot properties."), 100);
            }
            this.handle.setInstance(settingPath, setting);
            StoragePool targetPool = (StoragePool)parent.getSnapshotReserveStoragePool();
            if (targetPool == null) {
                Trace.error((Object)this, "createSnapshot", "Parent volume doesn't have a snapshotReservePool");
                ErrorDescriptor errDesc = new ErrorDescriptor(ErrorCode.SNAP_POOLRESERVED_MISSING, null, "Parent volume doesn't have a snapshotReservePool");
                throw new ConfigMgmtException(errDesc, 300);
            }
            CIMArgument[] inArgs = snapComp != null ? new CIMArgument[7] : new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)name)), new CIMArgument("Description", new CIMValue((Object)description)), new CIMArgument("SourceElement", new CIMValue((Object)parent.getInstance().getObjectPath())), new CIMArgument("TargetSettingGoal", new CIMValue((Object)setting.getObjectPath())), new CIMArgument("TargetPool", new CIMValue((Object)targetPool.getInstance().getObjectPath())), new CIMArgument("CopyType", new CIMValue((Object)new UnsignedInt16(4)))};
            if (snapComp != null) {
                inArgs[6] = new CIMArgument("snapComponent", new CIMValue((Object)snapComp.getInstance().getObjectPath()));
            }
            CIMArgument[] outArgs = new CIMArgument[2];
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, sdomainName, 0);
            Trace.verbose((Object)this, "createSnapshot", "Configuration service object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "createSnapshot", "Calling CreateReplica");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateReplica", inArgs, outArgs);
            Trace.verbose((Object)this, "createSnapshot", "Returned from calling CreateReplica");
            int retVal = (Integer)returnCodeValue.getValue();
            methodCallStatus = new MethodCallStatus();
            methodCallStatus.setReturnCode(retVal);
            Trace.verbose((Object)this, "createSnapshot", "Return code: " + retVal);
        }
        Trace.methodEnd(this, "createSnapshot");
        return methodCallStatus;
    }

    public MethodCallStatus createSnapshot(Collection key, String name, String description) throws BadParameterException, ConfigMgmtException {
        String METHOD = "createSnapshot";
        Trace.methodBegin(this, "createSnapshot");
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        StorageVolume volume = (StorageVolume)msv.getByKey(key);
        MethodCallStatus mcs = this.createSnapshot(volume, name, description);
        Trace.methodEnd(this, "createSnapshot");
        return mcs;
    }

    public MethodCallStatus deleteSnapshot(Collection key) throws ConfigMgmtException {
        String METHOD = "deleteSnapshot";
        Trace.methodBegin(this, "deleteSnapshot");
        MethodCallStatus mcs = null;
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        Trace.verbose((Object)this, "deleteSnapshot", "Calling ManageStorageVolumes.delete() with the StorageVolume(Replica)");
        try {
            mcs = msv.delete(key);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "deleteSnapshot", "Snapshot specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"Snapshot"}, "Snapshot specified not found."), 100);
        }
        Trace.methodEnd(this, "deleteSnapshot");
        return mcs;
    }

    public MethodCallStatus deleteSnapshot(SnapShotVolumeEnt1Interface snapshot) throws ConfigMgmtException {
        String METHOD = "deleteSnapshot";
        Trace.methodBegin(this, "deleteSnapshot");
        MethodCallStatus mcs = null;
        mcs = this.deleteSnapshot(snapshot.getKey());
        Trace.methodEnd(this, "deleteSnapshot");
        return mcs;
    }

    public MethodCallStatus resetSnapshot(SnapShotVolumeEnt1Interface snapshot) throws ConfigMgmtException {
        String METHOD = "resetSnapshot";
        Trace.methodBegin(this, "resetSnapshot");
        MethodCallStatus mcs = null;
        Trace.verbose((Object)this, "resetSnapshot", "Querying CIM for associated StorageSynchronized instance");
        Enumeration enumeration = this.handle.references(snapshot.getInstance().getObjectPath(), "SunStorEdge_DSPStorageSynchronized", "SyncedElement", true, false, null);
        Trace.verbose((Object)this, "resetSnapshot", "Returned from querying CIM for associated StorageSynchronized instance");
        CIMInstance syncInstance = null;
        if (enumeration == null || !enumeration.hasMoreElements()) {
            Trace.error((Object)this, "resetSnapshot", "StorageSynchronized instance not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "StorageSynchronized instance not found."), 100);
        }
        syncInstance = (CIMInstance)enumeration.nextElement();
        Trace.verbose((Object)this, "resetSnapshot", "StorageSynchronized instance found.");
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Operation", new CIMValue((Object)new UnsignedInt16(4))), new CIMArgument("Synchronization", new CIMValue((Object)syncInstance.getObjectPath()))};
        CIMArgument[] outArgs = new CIMArgument[1];
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, snapshot.getStorageDomainName(), 0);
        Trace.verbose((Object)this, "resetSnapshot", "Configuration service object path is: " + confServiceObjectPath);
        Trace.verbose((Object)this, "resetSnapshot", "Calling ModifySynchronization");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "ModifySynchronization", inArgs, outArgs);
        Trace.verbose((Object)this, "resetSnapshot", "Returned from calling ModifySynchronization");
        int retVal = (Integer)returnCodeValue.getValue();
        mcs.setReturnCode(retVal);
        Trace.verbose((Object)this, "resetSnapshot", "Return code: " + retVal);
        Trace.methodEnd(this, "resetSnapshot");
        return mcs;
    }

    public MethodCallStatus resetSnapShot(List list) throws ConfigMgmtException {
        String METHOD = "resetSnapShot";
        Trace.methodBegin(this, "resetSnapShot");
        Trace.methodEnd(this, "resetSnapShot");
        return null;
    }

    public MethodCallStatus disableSnapShot(List list) throws ConfigMgmtException {
        String METHOD = "disableSnapShot";
        Trace.methodBegin(this, "disableSnapShot");
        Trace.methodEnd(this, "disableSnapShot");
        return null;
    }

    public ArrayList getAssociatedSnapshot(Object parent) throws ConfigMgmtException {
        String METHOD = "getAssociatedSnapshot";
        Trace.methodBegin(this, "getAssociatedSnapshot");
        ArrayList snapVolumes = null;
        if (!(parent instanceof StorageVolume)) {
            Trace.error((Object)this, "getAssociatedSnapshot", "Parent volume is not a StorageVolume class");
            Trace.methodEnd(this, "getAssociatedSnapshot");
            return snapVolumes;
        }
        Trace.verbose((Object)this, "getAssociatedSnapshot", "Querying parent volume to get associated snapshots volumes");
        StorageVolume p_volume = (StorageVolume)parent;
        snapVolumes = p_volume.getAssociatedSnapShots();
        Trace.methodEnd(this, "getAssociatedSnapshot");
        return snapVolumes;
    }

    public MethodCallStatus rollbackSnapshot(StorageVolume snapshot) throws ConfigMgmtException {
        String METHOD = "rollbackSnapshot";
        Trace.methodBegin(this, "rollbackSnapshot");
        MethodCallStatus mcs = new MethodCallStatus();
        CIMInstance syncInst = null;
        Trace.verbose((Object)this, "rollbackSnapshot", "Querying the CIM for a StorageSynchronized association.");
        Enumeration enumAssoc = this.handle.references(snapshot.getInstance().getObjectPath(), "SunStorEdge_DSPStorageSynchronized", "SyncedElement", true, false, null);
        Trace.verbose((Object)this, "rollbackSnapshot", "Returned from querying the CIM for a StorageSynchronized association");
        if (enumAssoc == null || !enumAssoc.hasMoreElements()) {
            Trace.error((Object)this, "rollbackSnapshot", "StorageSynchronized not found.");
            Trace.methodEnd(this, "rollbackSnapshot");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.EMPTY_LIST, null, "StorageSynchronized association not found."), 100);
        }
        Trace.verbose((Object)this, "rollbackSnapshot", "StorageSynchronized association instance found.");
        syncInst = (CIMInstance)enumAssoc.nextElement();
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Operation", new CIMValue((Object)new UnsignedInt16("5"))), new CIMArgument("Synchronization", new CIMValue((Object)syncInst.getObjectPath()))};
        CIMArgument[] outArgs = new CIMArgument[1];
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, snapshot.getStorageDomainName(), 0);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "rollbackSnapshot", "Configuration service object path is: " + confServiceObjectPath);
        }
        Trace.verbose((Object)this, "rollbackSnapshot", "Calling ModifySynchronization");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "ModifySynchronization", inArgs, outArgs);
        Trace.verbose((Object)this, "rollbackSnapshot", "Returned from calling ModifySynchronization");
        int retVal = (Integer)returnCodeValue.getValue();
        Trace.verbose((Object)this, "rollbackSnapshot", "Return code: " + retVal);
        if (retVal != 0 && retVal != 4096) {
            Trace.verbose((Object)this, "rollbackSnapshot", "Returning error code: " + retVal + " in CME.");
        }
        if (retVal == 4096) {
            CIMObjectPath jobPath = null;
            for (int i = 0; jobPath == null && i < outArgs.length; ++i) {
                if (!outArgs[i].getName().equalsIgnoreCase("Job") || outArgs[i].getValue() == null) continue;
                jobPath = (CIMObjectPath)outArgs[i].getValue().getValue();
            }
            if (jobPath == null) {
                Trace.error((Object)this, "rollbackSnapshot", "Extrinsic method reported job should be present, but none could be found.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"Job"}, "Job not found."), 100);
            }
            JobManagerInterface jobMgr = JobManagerFactory.create();
            jobMgr.init(this.context, null);
            ArrayList<JobInterface> jobs = new ArrayList<JobInterface>();
            jobs.add(jobMgr.get(jobPath, null));
            mcs = new MethodCallStatus(retVal, jobs);
        } else {
            mcs = new MethodCallStatus(retVal, new ArrayList());
        }
        Trace.methodEnd(this, "rollbackSnapshot");
        return mcs;
    }

    public void abortRollback(Object key) throws ConfigMgmtException {
        String METHOD = "abortRollback";
        Trace.methodBegin(this, "abortRollback");
        if (key == null) {
            Trace.error((Object)this, "abortRollback", "Key object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Key object specified is null."), 100);
        }
        SnapShotVolumeCIM snap = (SnapShotVolumeCIM)this.getByKey((Collection)key);
        int retVal = 0;
        if (snap == null) {
            Trace.error((Object)this, "abortRollback", "StorageVolume specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"StorageVolume"}, "StorageVolume specified not found."), 100);
        }
        retVal = this.abortRollbackCIM(snap);
        if (retVal != 0) {
            Trace.verbose((Object)this, "abortRollback", "Error code returned: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "abortRollback");
    }

    private ArrayList enumToList(Enumeration enumeration) throws ConfigMgmtException {
        String METHOD = "enumToList";
        Trace.methodBegin(this, "enumToList");
        ArrayList<SnapShotVolumeCIM> enumToList = new ArrayList<SnapShotVolumeCIM>();
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "enumToList", "Getting StorageVolume type");
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                SnapShotVolumeCIM sv = new SnapShotVolumeCIM();
                sv.setInstance(ci);
                sv.init(this.context);
                CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                sv.loadKeys();
                enumToList.add(sv);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "enumToList", "The instance added to the list: " + sv);
            }
        }
        Trace.methodEnd(this, "enumToList");
        return enumToList;
    }

    private int abortRollbackCIM(SnapShotVolumeCIM snap) throws ConfigMgmtException {
        String METHOD = "abortRollbackCIM";
        Trace.methodBegin(this, "abortRollbackCIM");
        int retVal = 0;
        StorageVolume volume = (StorageVolume)snap.getParentVolume();
        Trace.verbose((Object)this, "abortRollbackCIM", "Querying CIM for AffectedJobElement instances.");
        CIMObjectPath volumePath = volume.getInstance().getObjectPath();
        Enumeration enumJobAssocs = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPAffectedJobElement"), false, false, true, false, null);
        Trace.verbose((Object)this, "abortRollbackCIM", "Returned from querying CIM for AffectedJobElement instances.");
        if (enumJobAssocs != null) {
            while (enumJobAssocs.hasMoreElements()) {
                CIMObjectPath jobPath;
                CIMInstance jobInst;
                Job job;
                Trace.verbose((Object)this, "abortRollbackCIM", "AffectedJobElement instances found.");
                CIMInstance jobAssoc = (CIMInstance)enumJobAssocs.nextElement();
                CIMObjectPath volPath = (CIMObjectPath)jobAssoc.getProperty("AffectedElement").getValue().getValue();
                CIMProperty volWwn = volumePath.getKey("DeviceID");
                CIMProperty jobVolWwn = volPath.getKey("DeviceID");
                if (!jobVolWwn.equals((Object)volWwn) || (job = new Job(jobInst = this.handle.getInstance(jobPath = (CIMObjectPath)jobAssoc.getProperty("AffectingElement").getValue().getValue(), false, true, false, null), this.context, null)).getPercentComplete() == 100) continue;
                Trace.verbose((Object)this, "abortRollbackCIM", "Attempting to kill the Job.");
                job.kill();
                Trace.verbose((Object)this, "abortRollbackCIM", "Job killed successfully.");
                break;
            }
        } else {
            Trace.error((Object)this, "abortRollbackCIM", "AffectedJobElement instances not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"AffectedJobElement"}, "AffectedJobElement instances not found."), 100);
        }
        Trace.methodEnd(this, "abortRollbackCIM");
        return retVal;
    }

    public List getItemsByStorageDomain(String name) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = new String("getItemsByStorageDomain");
        Trace.methodBegin(this, METHOD_NAME);
        ArrayList volumes = new ArrayList();
        Trace.verbose((Object)this, METHOD_NAME, "Check if storage domain with name passed exists.");
        Enumeration domains = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageDomain where ElementName = '" + name + "'");
        if (domains == null || !domains.hasMoreElements()) {
            Trace.error((Object)this, METHOD_NAME, "StorageDomain : " + name + " not found.");
            throw new ItemNotFoundException(name);
        }
        Trace.verbose((Object)this, METHOD_NAME, "Querying CIM for snapshots in storage domain: " + name);
        Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageVolume where StorageDomain = '" + name + "' and " + "ObjectType" + " = " + 1);
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, METHOD_NAME, "Snapshots found.");
            volumes = this.enumToList(enumeration);
        } else {
            Trace.verbose((Object)this, METHOD_NAME, "No snapshots found.");
        }
        return volumes;
    }

    public List getItemsBySystem() throws ConfigMgmtException {
        String METHOD_NAME = new String("getItemsBySystem");
        Trace.methodBegin(this, METHOD_NAME);
        ArrayList volumes = new ArrayList();
        Trace.verbose((Object)this, METHOD_NAME, "Querying CIM for all snapshots on the system.");
        Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageVolume where ObjectType = 1");
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, METHOD_NAME, "Snapshots found.");
            volumes = this.enumToList(enumeration);
        } else {
            Trace.verbose((Object)this, METHOD_NAME, "No snapshots found.");
        }
        return volumes;
    }

    public boolean snapshotNameUsed(String snapshotName) throws ConfigMgmtException {
        String METHOD = "snapshotNameUsed";
        Trace.methodBegin(this, "snapshotNameUsed");
        Trace.methodEnd(this, "snapshotNameUsed");
        return false;
    }
}

