/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.CoreInstanceInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageReplicationServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationGroupEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationLinkEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationParametersEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ReplicationSetEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationGroupCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationLinkCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationParametersCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.ReplicationSetCIM;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.VDisk;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim.EthernetPortCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim.FiberChannelPortCIM;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.cim.ManagePortsCIM;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;

public class ManageReplicationServicesCIM
implements ManageReplicationServicesEnt1Interface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;

    public void create(Properties props) throws ConfigMgmtException {
        String METHOD = "create";
        Trace.methodBegin(this, "create");
        StorageVolume localVolume = null;
        String remoteVolumeWwn = null;
        String remotePeerWwn = null;
        StoragePool bitmapPool = null;
        ReplicationGroupCIM replicationGroup = null;
        ReplicationParametersCIM replicationParams = null;
        Object asyncQueue = null;
        String groupName = null;
        String groupDescription = null;
        int mode = 3;
        BigInteger queueSize = BigInteger.ZERO;
        Trace.verbose((Object)this, "create", "Parsing creation parameters...");
        Object localProp = props.get("LOCALVOLUME");
        if (localProp == null) {
            Trace.error((Object)this, "create", "Invalid Parameter: LocalVolume");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "LocalVolume property not populated.", null, 100);
        }
        localVolume = (StorageVolume)localProp;
        String remoteWwnProp = props.getProperty("REMOVEVOLUMEWWN");
        if (remoteWwnProp == null) {
            Trace.error((Object)this, "create", "Invalid Parameter: RemoteVolumeWwn");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "RemoteVolumeWWN property not populated.", null, 100);
        }
        remoteVolumeWwn = remoteWwnProp;
        Object bitmapProp = props.get("BITMAPPOOL");
        if (bitmapProp == null) {
            Trace.error((Object)this, "create", "Invalid Parameter: BitmapPool");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "BitmapPool property not populated.", null, 100);
        }
        bitmapPool = (StoragePool)bitmapProp;
        Object groupProp = props.get("REPLICATIONGROUP");
        if (groupProp != null) {
            replicationGroup = (ReplicationGroupCIM)groupProp;
            replicationParams = (ReplicationParametersCIM)replicationGroup.getReplicationParameters();
            if (replicationParams != null) {
                mode = replicationParams.getSyncMode();
            } else {
                Trace.error((Object)this, "create", "Couldn't find ReplicationParameters for ReplicationGroup");
            }
        } else {
            groupName = (String)props.get("GROUPNAME");
            groupDescription = (String)props.get("GROUPDESCRIPTION");
        }
        if (replicationParams == null) {
            Object paramsProp = props.get("REPLICATIONPARAMS");
            if (paramsProp != null) {
                replicationParams = (ReplicationParametersCIM)paramsProp;
                mode = replicationParams.getSyncMode();
            } else {
                Trace.error((Object)this, "create", "ReplicationParamters property not populated.");
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "ReplicationParameters property not populated.", null, 100);
            }
        }
        if (replicationGroup == null) {
            String peerProp = props.getProperty("REMOTEPEERWWN");
            if (peerProp == null) {
                Trace.error((Object)this, "create", "Invalid Parameter: RemotePeerWwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "RemotePeerWWN property not populated.", null, 100);
            }
            remotePeerWwn = Convert.toLargeRemotePeerWWN(peerProp);
        } else {
            remotePeerWwn = Convert.toLargeRemotePeerWWN(replicationGroup.getPeerWwn());
        }
        if (mode == 2) {
            if (replicationGroup != null) {
                asyncQueue = replicationGroup.getAsyncQStorage();
                queueSize = replicationGroup.getAsyncQueueSize();
            } else {
                asyncQueue = props.get("ASYNCQUEUE");
                if (asyncQueue != null) {
                    queueSize = replicationParams.getAsyncQueueSize(null);
                    if (queueSize.equals(BigInteger.ZERO)) {
                        queueSize = localVolume.getSize().divide(new BigInteger("10"));
                        Trace.error((Object)this, "create", "QueueSize is 0. Setting Queue size as 10% of localvolume: " + queueSize.toString());
                    }
                } else {
                    Trace.error((Object)this, "create", "Invalid Parameter: AsyncQueue missing");
                    throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "AsyncQueue property not populated.", null, 100);
                }
            }
        }
        Trace.verbose((Object)this, "create", "Done parsing parameters...");
        this.createRepSetCIMOM(localVolume, remoteVolumeWwn, remotePeerWwn, bitmapPool, replicationGroup, replicationParams, asyncQueue, queueSize, groupName, groupDescription);
        Trace.methodEnd(this, "create");
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String METHOD = "delete";
        Trace.methodBegin(this, "delete");
        MethodCallStatus mcs = null;
        ArrayList<ErrorDescriptor> results = new ArrayList<ErrorDescriptor>();
        boolean errorOnce = false;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            ReplicationSetCIM repSet = null;
            if (obj != null && obj instanceof Collection) {
                repSet = (ReplicationSetCIM)this.getReplicationSetByKey((Collection)obj);
            } else if (obj != null && obj instanceof ReplicationSetCIM) {
                repSet = (ReplicationSetCIM)obj;
            }
            if (repSet == null) {
                Trace.error((Object)this, "delete", "ReplicationSet is null");
            } else {
                block8: {
                    try {
                        mcs = this.modifySyncCIMOM(repSet, "2");
                    }
                    catch (ConfigMgmtException cme) {
                        ErrorDescriptor errD = cme.getErrorDescriptor();
                        if (errD == null) break block8;
                        results.add(errD);
                        errorOnce = true;
                    }
                }
                results.add(new ErrorDescriptor(ErrorCode.SUCCESS, new String[]{repSet.getName()}, "Deleting RepSet success."));
            }
            if (!errorOnce) continue;
            throw new ConfigMgmtException(results, ErrorCode.SUCCESS.getKey(), "Results from RepSet deletion", 300);
        }
        Trace.methodEnd(this, "delete");
        return mcs;
    }

    public MethodCallStatus delete(Object key) throws ConfigMgmtException {
        String METHOD = "delete";
        Trace.methodBegin(this, "delete");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(key);
        MethodCallStatus mcs = this.delete(list);
        Trace.methodEnd(this, "delete");
        return mcs;
    }

    public int getMaxObjects() {
        String METHOD = "getMaxObjects";
        Trace.methodBegin(this, "getMaxObjects");
        Trace.methodEnd(this, "getMaxObjects");
        return 100;
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        String METHOD = "init";
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            Trace.methodEnd(this, "init");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "Client object is null.");
            Trace.methodEnd(this, "init");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Client object is null.");
        }
        Trace.methodEnd(this, "init");
    }

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        String METHOD = "init(ConfigContext, Scope, SearchFilter";
        Trace.methodBegin(this, "init(ConfigContext, Scope, SearchFilter");
        this.init(context, filter);
        Trace.methodEnd(this, "init(ConfigContext, Scope, SearchFilter");
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD = "getItemList";
        Trace.methodBegin(this, "getItemList");
        Trace.methodEnd(this, "getItemList");
        return new ArrayList();
    }

    public int getItemCount() throws ConfigMgmtException {
        String METHOD = "getItemCount";
        Trace.methodBegin(this, "getItemCount");
        Trace.methodEnd(this, "getItemCount");
        return 0;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        Object repGroupToAddObj;
        Object queueTimeObj;
        Object queueActionObj;
        Object queueSizeObj;
        Object priorityObj;
        Object autoSyncObj;
        Object snapSecObj;
        Object snapBResyncObj;
        String METHOD = "modify";
        Trace.methodBegin(this, "modify");
        String grpName = null;
        String grpDescription = null;
        String rPeer = null;
        int role = 0;
        int mode = 3;
        Boolean snapBResync = Boolean.FALSE;
        Boolean snapSecondary = Boolean.FALSE;
        Boolean autoSync = Boolean.FALSE;
        int priority = 128;
        CoreInstanceInterface queuePool = null;
        BigInteger queueSize = BigInteger.ZERO;
        int queueAction = 1;
        BigInteger queueBlkCount = BigInteger.ZERO;
        int queueTime = 0;
        int queueWrites = 0;
        ReplicationGroupEnt1Interface repGroupToChg = null;
        StorageVolumeInterface localVolume = null;
        ReplicationParametersEnt1Interface repParams = null;
        ReplicationSetEnt1Interface repSetToChg = null;
        boolean propHasChanged = false;
        boolean modeHasChanged = false;
        boolean toRemoveRepSet = false;
        if (key instanceof ReplicationSetEnt1Interface) {
            repSetToChg = (ReplicationSetEnt1Interface)key;
            repParams = repSetToChg.getReplicationParameters();
        } else if (key instanceof ReplicationGroupEnt1Interface) {
            repGroupToChg = (ReplicationGroupEnt1Interface)key;
            repParams = repGroupToChg.getReplicationParameters();
            List listRepSets = repGroupToChg.getReplicationSets();
            Object repSetToRemoveObj = props.get("REPSET");
            if (repSetToRemoveObj != null) {
                toRemoveRepSet = true;
                repSetToChg = (ReplicationSetEnt1Interface)repSetToRemoveObj;
                propHasChanged = true;
            } else {
                repSetToChg = (ReplicationSetEnt1Interface)listRepSets.get(0);
            }
        } else {
            Trace.error((Object)this, "modify", "Key object is not an instance of ReplicationSetEnt1Interface or ReplicationGroupEnt1Interface");
            throw new ConfigMgmtException("incorrect.method.parameter", "Key object is not an instance of ReplicationSetEnt1Interface or ReplicationGroupEnt1Interface");
        }
        rPeer = repSetToChg.getPeerWwn();
        localVolume = repSetToChg.getLocalVolume();
        Trace.verbose((Object)this, "modify", "Parsing modify parameters...");
        Object modeObj = props.get("MODE");
        if (modeObj != null) {
            int currMode;
            Integer val = (Integer)modeObj;
            mode = val;
            if (mode != (currMode = repParams.getSyncMode())) {
                propHasChanged = true;
            }
            if (currMode == 3 && mode == 2) {
                Trace.verbose((Object)this, "modify", "Changing from SYNC ---> ASYNC");
                Object queuePoolObj = props.get("ASYNCQUEUE");
                if (queuePoolObj == null) {
                    Trace.error((Object)this, "modify", "Async Queue missing from sync to async");
                    throw new ConfigMgmtException("incorrect.method.parameter", "Async Queue missing from sync to async modification");
                }
                queuePool = (StoragePool)queuePoolObj;
                Object queueSizeObj2 = props.get("QUEUESIZE");
                if (queueSizeObj2 != null) {
                    queueSize = (BigInteger)queueSizeObj2;
                } else {
                    queueSize = localVolume.getSize().divide(new BigInteger("10"));
                    Trace.error((Object)this, "modify", "QueueSize is 0. Setting Queue size as 10% of localvolume: " + queueSize.toString());
                }
                modeHasChanged = true;
            }
        } else {
            mode = repParams.getSyncMode();
        }
        Object roleObj = props.get("ROLE");
        if (roleObj != null) {
            role = (Integer)roleObj;
            if (repParams.getRole() != role) {
                Trace.verbose((Object)this, "modify", "Changing role: " + role);
                propHasChanged = true;
            }
        } else {
            role = repParams.getRole();
        }
        if ((snapBResyncObj = props.get("SNAPBEFORESYNC")) != null) {
            snapBResync = (Boolean)snapBResyncObj;
            if (repParams.isSnapBeforeSync() != snapBResync.booleanValue()) {
                Trace.verbose((Object)this, "modify", "Changing SnapBeforeResync: " + snapBResync);
                propHasChanged = true;
            }
        } else {
            snapBResync = repParams.isSnapBeforeSync();
        }
        if ((snapSecObj = props.get("SNAPSECONDARY")) != null) {
            snapSecondary = (Boolean)snapSecObj;
            if (repParams.isSnapWithPrimary() != snapSecondary.booleanValue()) {
                Trace.verbose((Object)this, "modify", "Changing SnapSecondary: " + snapSecondary);
                propHasChanged = true;
            }
        } else {
            snapSecondary = repParams.isSnapWithPrimary();
        }
        if ((autoSyncObj = props.get("AUTOSYNC")) != null) {
            autoSync = (Boolean)autoSyncObj;
            if (repParams.isAutoSync() != autoSync.booleanValue()) {
                Trace.verbose((Object)this, "modify", "Changing AutoSync: " + autoSync);
                propHasChanged = true;
            }
        } else {
            autoSync = repParams.isAutoSync();
        }
        if ((priorityObj = props.get("PRIORITY")) != null) {
            priority = (Integer)priorityObj;
            if (repParams.getPriority() != priority) {
                Trace.verbose((Object)this, "modify", "Changing priority: " + priority);
                propHasChanged = true;
            }
        } else {
            priority = repParams.getPriority();
        }
        if ((queueSizeObj = props.get("QUEUESIZE")) != null) {
            queueSize = (BigInteger)queueSizeObj;
            if (!repSetToChg.getAsyncQueueSize().equals(queueSize)) {
                Trace.verbose((Object)this, "modify", "Changing QueueSize: " + queueSize.toString());
                propHasChanged = true;
                if (queueSize.equals(BigInteger.ZERO)) {
                    Trace.verbose((Object)this, "modify", "QueueSize  is 0 changing mode to Sync");
                }
            }
        } else if (!modeHasChanged) {
            queueSize = repSetToChg.getAsyncQueueSize();
        }
        if ((queueActionObj = props.get("QUEUEACTION")) != null) {
            Integer val = (Integer)queueActionObj;
            queueAction = val;
            if (repParams.getAsyncQAction() != queueAction) {
                Trace.verbose((Object)this, "modify", "Changing QueueAction: " + queueAction);
                propHasChanged = true;
            }
        } else {
            queueAction = repParams.getAsyncQAction();
        }
        Object queueBlkObj = props.get("QUEUEBLOCKCOUNT");
        if (queueBlkObj != null) {
            queueBlkCount = (BigInteger)queueBlkObj;
            if (!repParams.getAsyncQBlockCount().equals(queueBlkCount)) {
                Trace.verbose((Object)this, "modify", "Changing QueueBlockCount: " + queueBlkCount.toString());
                propHasChanged = true;
            }
        } else {
            queueBlkCount = repParams.getAsyncQBlockCount();
        }
        if ((queueTimeObj = props.get("QUEUETIME")) != null) {
            Integer val = (Integer)queueTimeObj;
            queueTime = val;
            if (repParams.getAsyncQTimeCount() != queueTime) {
                Trace.verbose((Object)this, "modify", "Changing QueueTime: " + queueTime);
                propHasChanged = true;
            }
        } else {
            queueTime = repParams.getAsyncQTimeCount();
        }
        Object queueWritesObj = props.get("QUEUEWRITES");
        if (queueWritesObj != null) {
            Integer val = (Integer)queueWritesObj;
            queueWrites = val;
            if (repParams.getAsyncQWriteCount() != queueWrites) {
                Trace.verbose((Object)this, "modify", "Changing QueueWrites: " + queueWrites);
                propHasChanged = true;
            }
        } else {
            queueWrites = repParams.getAsyncQWriteCount();
        }
        if (repGroupToChg == null && (repGroupToAddObj = props.get("REPGROUP")) != null) {
            repGroupToChg = (ReplicationGroupEnt1Interface)repGroupToAddObj;
            Trace.verbose((Object)this, "modify", "Changing To RepGroup: " + repGroupToChg.getName());
            propHasChanged = true;
        }
        CIMObjectPath c_repGroupToChgOp = null;
        if (repGroupToChg != null) {
            Object descObj;
            Object nameObj = props.get("NAME");
            ReplicationGroupCIM c_repGroupToChg = (ReplicationGroupCIM)repGroupToChg;
            CIMInstance c_repGroupToChgInst = c_repGroupToChg.getCIMInstance();
            c_repGroupToChgOp = new CIMObjectPath();
            c_repGroupToChgOp.setKeys(c_repGroupToChgInst.getKeys());
            grpName = repGroupToChg.getName();
            grpDescription = repGroupToChg.getDescription();
            if (nameObj != null) {
                grpName = (String)nameObj;
                if (!repGroupToChg.getName().equals(grpName)) {
                    propHasChanged = true;
                }
            }
            if ((descObj = props.get("DESCRIPTION")) != null) {
                grpDescription = (String)descObj;
                if (!repGroupToChg.getDescription().equals(grpDescription)) {
                    propHasChanged = true;
                }
            }
            c_repGroupToChgOp.addKey("Name", new CIMValue((Object)grpName));
            c_repGroupToChgOp.addKey("Description", new CIMValue((Object)grpDescription));
            if (propHasChanged && c_repGroupToChg.getSyncMode() == 2 && (queuePool = c_repGroupToChg.getAsyncQStorage()) == null) {
                Trace.error((Object)this, "modify", "Error retreiving StorageVolume from ReplicationGroup Queue");
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "QueuePool not found for GAL", null, 100);
            }
        }
        Trace.verbose((Object)this, "modify", "End of parsing modify parameters...");
        if (!propHasChanged) {
            Trace.verbose((Object)this, "modify", "No properties to change");
            return;
        }
        if (queuePool == null && repSetToChg != null) {
            ReplicationGroupEnt1Interface rgrp = repSetToChg.getReplicationGroup();
            if (rgrp != null) {
                queuePool = rgrp.getAsyncQStorage();
            } else {
                VDiskEnt1Interface qvd = repSetToChg.getAsyncQStorage();
                if (qvd != null) {
                    queuePool = (StoragePool)qvd.getStoragePool();
                }
            }
        }
        ReplicationParametersCIM params = (ReplicationParametersCIM)repParams;
        CIMInstance repParamsInst = params.getCIMInstance();
        CIMObjectPath repParamsPath = repParamsInst.getObjectPath();
        try {
            repParamsInst.setProperty("Peer", new CIMValue((Object)rPeer));
            repParamsInst.setProperty("Role", new CIMValue((Object)new UnsignedInt16(role)));
            repParamsInst.setProperty("Mode", new CIMValue((Object)new UnsignedInt16(mode)));
            repParamsInst.setProperty("SnapBeforeResync", new CIMValue((Object)snapBResync));
            repParamsInst.setProperty("SnapSecondary", new CIMValue((Object)snapSecondary));
            repParamsInst.setProperty("AutoSynchronize", new CIMValue((Object)autoSync));
            repParamsInst.setProperty("ReplicationPriority", new CIMValue((Object)new UnsignedInt16(priority)));
            repParamsInst.setProperty("QueueSize", new CIMValue((Object)new UnsignedInt64(queueSize)));
            repParamsInst.setProperty("QueueAction", new CIMValue((Object)new UnsignedInt16(queueAction)));
            repParamsInst.setProperty("QueueBlockCount", new CIMValue((Object)new UnsignedInt64(queueBlkCount)));
            repParamsInst.setProperty("QueueTime", new CIMValue((Object)new UnsignedInt32((long)queueTime)));
            repParamsInst.setProperty("QueueWrites", new CIMValue((Object)new UnsignedInt32((long)queueWrites)));
            this.handle.setInstance(repParamsPath, repParamsInst);
        }
        catch (CIMException cex) {
            Trace.error((Object)this, "modify", "Error setting new properties to ReplicationParameters");
        }
        Trace.verbose((Object)this, "modify", "Creating inargs and outargs for AttachOrModify CIM method");
        CIMArgument[] inArgs = new CIMArgument[8];
        inArgs[0] = new CIMArgument("LocalElement", new CIMValue((Object)localVolume.getInstance().getObjectPath()));
        inArgs[1] = new CIMArgument("SetIndex", new CIMValue((Object)new UnsignedInt16(repSetToChg.getSetIndex())));
        inArgs[2] = new CIMArgument("RemoteElementName", new CIMValue(null));
        VDisk bp = (VDisk)repSetToChg.getBitmapVDisk();
        StoragePool bpPool = null;
        bpPool = (StoragePool)bp.getStoragePool();
        if (bpPool == null) {
            Trace.error((Object)this, "modify", "Error retreiving StoragePool for BitMap");
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting associated StoragePool for BitMap.");
        }
        inArgs[3] = new CIMArgument("Bitmap", new CIMValue((Object)bpPool.getInstance().getObjectPath()));
        inArgs[4] = c_repGroupToChgOp == null ? new CIMArgument("Group", new CIMValue(null)) : (toRemoveRepSet ? new CIMArgument("Group", new CIMValue(null)) : new CIMArgument("Group", new CIMValue((Object)c_repGroupToChgOp)));
        inArgs[5] = new CIMArgument("Parameters", new CIMValue((Object)repParamsInst.getObjectPath()));
        if (queuePool == null) {
            inArgs[6] = new CIMArgument("Queue", new CIMValue(null));
        } else {
            CIMInstance c_inst = null;
            if (queuePool instanceof StorageVolume) {
                c_inst = ((StorageVolume)queuePool).getInstance();
            } else if (queuePool instanceof StoragePool) {
                c_inst = ((StoragePool)queuePool).getInstance();
            }
            Trace.verbose((Object)this, "modify", "QUEUEPOOL: " + c_inst);
            inArgs[6] = c_inst != null ? new CIMArgument("Queue", new CIMValue((Object)c_inst.getObjectPath())) : new CIMArgument("Queue", new CIMValue(null));
        }
        ReplicationSetCIM c_repSet = (ReplicationSetCIM)repSetToChg;
        inArgs[7] = new CIMArgument("ReplicationSet", new CIMValue((Object)c_repSet.getCIMInstance().getObjectPath()));
        CIMArgument[] outArgs = new CIMArgument[3];
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, localVolume.getStorageDomainName(), 0);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "modify", "Configuration service object path is: " + confServiceObjectPath);
        }
        Trace.verbose((Object)this, "modify", "Calling AttachReplicationSet");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "AttachOrModifyReplicationSet", inArgs, outArgs);
        Trace.verbose((Object)this, "modify", "Returned from calling AttachReplicationSet");
        int retVal = (Integer)returnCodeValue.getValue();
        Trace.verbose((Object)this, "modify", "Return code: " + retVal);
        if (retVal != 0 && retVal != 4096) {
            Trace.error((Object)this, "modify", "Error modifying ReplicationSet: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "modify");
    }

    public MethodCallStatus resync(Object key) throws ConfigMgmtException {
        String METHOD = "resync";
        Trace.methodBegin(this, "resync");
        MethodCallStatus mcs = this.resync(key, false);
        Trace.methodEnd(this, "resync");
        return mcs;
    }

    public void scoreboard(Object key) throws ConfigMgmtException {
        String METHOD = "scoreboard";
        Trace.methodBegin(this, "scoreboard");
        this.scoreboard(key, false);
        Trace.methodEnd(this, "scoreboard");
    }

    public void roleReverse(Object key) throws ConfigMgmtException {
        ReplicationSetEnt1Interface repSet;
        String METHOD = "roleReverse";
        Trace.methodBegin(this, "roleReverse");
        if (key != null) {
            repSet = null;
            if (key instanceof Collection) {
                repSet = this.getReplicationSetByKey((Collection)key);
            } else if (key instanceof ReplicationSetEnt1Interface) {
                repSet = (ReplicationSetEnt1Interface)key;
            }
            if (repSet == null) {
                Trace.error((Object)this, "roleReverse", "Invalid Parameter: ReplicationSet not found");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), null, "ReplicationSet specified not found.", null, 300);
            }
        } else {
            Trace.error((Object)this, "roleReverse", "Key object is null");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "ReplicationSet key specified is null.", null, 100);
        }
        this.modifySyncCIMOM((ReplicationSetCIM)repSet, "32769");
        Trace.methodEnd(this, "roleReverse");
    }

    public List getReplicationSetList() throws ConfigMgmtException {
        String METHOD = "getReplicationSetList";
        Trace.methodBegin(this, "getReplicationSetList");
        ArrayList replicationSets = null;
        replicationSets = this.getReplicationSetsCIMOM();
        Trace.methodEnd(this, "getReplicationSetList");
        return replicationSets;
    }

    public ReplicationSetEnt1Interface getReplicationSetByKey(Collection key) throws ConfigMgmtException {
        String METHOD = "getReplicationSetByKey";
        Trace.methodBegin(this, "getReplicationSetByKey");
        ReplicationSetCIM rs = null;
        if (key != null) {
            CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPReplicationSet", new Vector(key));
            Trace.verbose((Object)this, "getReplicationSetByKey", "Querying CIM for ReplicationSet Instance matching key(s)");
            CIMInstance ci = this.handle.getInstance(objPath, false, true, false, null);
            Trace.verbose((Object)this, "getReplicationSetByKey", "Returned from querying CIM for ReplicationSet Instance matching key(s)");
            if (ci != null) {
                Trace.verbose((Object)this, "getReplicationSetByKey", "Creating ReplicationSet Java Object");
                rs = new ReplicationSetCIM(ci, this.context);
            }
        } else {
            Trace.error((Object)this, "getReplicationSetByKey", "Key object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "ReplicationSet key specified is null.", null, 100);
        }
        if (rs == null) {
            Trace.verbose((Object)this, "getReplicationSetByKey", "No instance returned when trying to obtain the ReplicationSet");
            Trace.methodEnd(this, "getReplicationSetByKey");
            return null;
        }
        Trace.methodEnd(this, "getReplicationSetByKey");
        return rs;
    }

    public ReplicationGroupEnt1Interface getReplicationGroupByKey(Collection key) throws ConfigMgmtException {
        String METHOD = "getReplicationGroupByKey";
        Trace.methodBegin(this, "getReplicationGroupByKey");
        ReplicationGroupCIM rg = null;
        if (key != null) {
            CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPReplicationGroup", new Vector(key));
            Trace.verbose((Object)this, "getReplicationGroupByKey", "Querying CIM for ReplicationGroup Instance matching key(s)");
            CIMInstance ci = this.handle.getInstance(objPath, false, true, false, null);
            Trace.verbose((Object)this, "getReplicationGroupByKey", "Returned from querying CIM for ReplicationGroup Instance matching key(s)");
            if (ci != null) {
                Trace.verbose((Object)this, "getReplicationGroupByKey", "Creating ReplicationGroup Java Object");
                rg = new ReplicationGroupCIM(ci, this.context);
            }
        } else {
            Trace.error((Object)this, "getReplicationGroupByKey", "Key object is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "ReplicationGroup key specified is null.", null, 100);
        }
        Trace.methodEnd(this, "getReplicationGroupByKey");
        return rg;
    }

    public List getReplicationGroupList() throws ConfigMgmtException {
        String METHOD = "getReplicationGroupList";
        Trace.methodBegin(this, "getReplicationGroupList");
        ArrayList<ReplicationGroupCIM> cimomList = null;
        Trace.verbose((Object)this, "getReplicationGroupList", "Querying CIM for all \u0016ReplicationGroup Instances");
        Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPReplicationGroup"), false, false, true, false, null);
        Trace.verbose((Object)this, "getReplicationGroupList", "Returned from querying CIM for all \u0016ReplicationGroup Instances");
        if (enumeration != null && enumeration.hasMoreElements()) {
            cimomList = new ArrayList<ReplicationGroupCIM>();
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                ReplicationGroupCIM rg = new ReplicationGroupCIM(ci, this.context);
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "getReplicationGroupList", "Adding \u0016ReplicationGroup object to object list: " + rg);
                }
                cimomList.add(rg);
            }
        }
        Trace.methodEnd(this, "getReplicationGroupList");
        return cimomList;
    }

    public List getReplicationSetListByVolume(Collection key) throws ConfigMgmtException {
        String METHOD = "getReplicationSetListByVolume";
        Trace.methodBegin(this, "getReplicationSetListByVolume");
        ArrayList<ReplicationSetCIM> list = null;
        Trace.verbose((Object)this, "getReplicationSetListByVolume", "Querying the CIM for a ReplicationSet instance.");
        CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPStorageVolume", new Vector(key));
        Enumeration enumRepSet = this.handle.associators(objPath, "SunStorEdge_DSPRemoteStorageSynchronized", "SunStorEdge_DSPReplicationSet", "SystemElement", "SyncedElement", true, false, null);
        Trace.verbose((Object)this, "getReplicationSetListByVolume", "Returned from querying the CIM for a ReplicationSet instance");
        if (enumRepSet != null) {
            list = new ArrayList<ReplicationSetCIM>();
            while (enumRepSet.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumRepSet.nextElement();
                ReplicationSetCIM rs = new ReplicationSetCIM(ci, this.context);
                list.add(rs);
            }
        } else {
            Trace.verbose((Object)this, "getReplicationSetListByVolume", "ReplicationSets not found");
        }
        Trace.methodEnd(this, "getReplicationSetListByVolume");
        return list;
    }

    public List getAvailableReplicationGroups(Collection volKey, String peerWwn) throws ConfigMgmtException {
        String METHOD = "getAvailableReplicationGroups(Collection, String)";
        Trace.methodBegin(this, "getAvailableReplicationGroups(Collection, String)");
        List list = null;
        ManageStorageVolumes volMgr = new ManageStorageVolumes();
        volMgr.init(this.context, null);
        StorageVolume volume = (StorageVolume)volMgr.getByKey(volKey);
        if (volume != null) {
            list = this.getAvailableReplicationGroups(volume, peerWwn);
        }
        Trace.methodEnd(this, "getAvailableReplicationGroups(Collection, String)");
        return list;
    }

    public List getAvailableReplicationGroups(StorageVolumeEnt1Interface volume, String peerWwn) throws ConfigMgmtException {
        String METHOD = "getAvailableReplicationGroups(StorageVolume, String)";
        Trace.methodBegin(this, "getAvailableReplicationGroups(StorageVolume, String)");
        List repGroups = this.getReplicationGroupList();
        if (repGroups != null) {
            int size = repGroups.size();
            for (int i = size - 1; i >= 0; --i) {
                ReplicationSetEnt1Interface repSet;
                StorageVolume l_volume;
                ReplicationGroupEnt1Interface repGrp = (ReplicationGroupEnt1Interface)repGroups.get(i);
                if (repGrp.getState() == 4) {
                    repGroups.remove(repGrp);
                    continue;
                }
                List repSets = repGrp.getReplicationSets();
                if (repSets == null || (l_volume = (StorageVolume)(repSet = (ReplicationSetEnt1Interface)repSets.get(0)).getLocalVolume()).getStorageDomainName().equals(volume.getStorageDomainName())) continue;
                repGroups.remove(repGrp);
            }
            if (repGroups.isEmpty()) {
                Trace.verbose((Object)this, "getAvailableReplicationGroups(StorageVolume, String)", "ReplicationGroups not found");
                repGroups = null;
            }
        }
        Trace.methodEnd(this, "getAvailableReplicationGroups(StorageVolume, String)");
        return repGroups;
    }

    public ReplicationParametersEnt1Interface createReplicationParameters(int role, int syncMode, boolean autoSync, boolean snapBeforeSync, boolean snapWithPrimary, int priority, int writeCount, BigInteger blockCount, int timeCount, BigInteger queueSize, int queueAction) {
        String METHOD = "createReplicationParameters";
        Trace.methodBegin(this, "createReplicationParameters");
        ReplicationParametersCIM params = new ReplicationParametersCIM(role, syncMode, snapBeforeSync, snapWithPrimary, autoSync, priority, queueSize, queueAction, blockCount, timeCount, writeCount);
        Trace.methodEnd(this, "createReplicationParameters");
        return params;
    }

    public ReplicationGroupEnt1Interface getReplicationGroupByName(String rgName, String sDomain) throws ConfigMgmtException {
        String METHOD = "getReplicationGroupByName";
        Trace.methodBegin(this, "getReplicationGroupByName");
        ReplicationGroupCIM repGrp = null;
        Trace.verbose((Object)this, "getReplicationGroupByName", "Querying CIM for ReplicationGroup Instance matching name and storage domain");
        Enumeration enumeration = CIMObjectWrapper.execQuery(this.handle, "Select * from SunStorEdge_DSPReplicationGroup where Name = '" + rgName + "'");
        Trace.verbose((Object)this, "getReplicationGroupByName", "Returned from querying CIM for ReplicationGroup Instance matching name and storage domain");
        if (enumeration != null && enumeration.hasMoreElements()) {
            List repsetList;
            ReplicationSetEnt1Interface repSet;
            StorageVolumeInterface l_volume;
            String rDomain;
            Trace.verbose((Object)this, "getReplicationGroupByName", "ReplicationSet instance found.");
            CIMInstance ci_grp = (CIMInstance)enumeration.nextElement();
            repGrp = new ReplicationGroupCIM(ci_grp, this.context);
            if (sDomain != null && !(rDomain = (l_volume = (repSet = (ReplicationSetEnt1Interface)(repsetList = repGrp.getReplicationSets()).get(0)).getLocalVolume()).getStorageDomainName()).equalsIgnoreCase(sDomain)) {
                Trace.verbose((Object)this, "getReplicationGroupByName", "StorageDomain(s) don't match");
                repGrp = null;
            }
        }
        Trace.methodEnd(this, "getReplicationGroupByName");
        return repGrp;
    }

    public ReplicationSetEnt1Interface getReplicationSetByName(String rsName, String sDomain) throws ConfigMgmtException {
        String METHOD = "getReplicationSetByName";
        Trace.methodBegin(this, "getReplicationSetByName");
        ReplicationSetCIM repSet = null;
        Trace.verbose((Object)this, "getReplicationSetByName", "Querying CIM for ReplicationSet Instance matching name and storage domain");
        Enumeration enumeration = CIMObjectWrapper.execQuery(this.handle, "Select * from SunStorEdge_DSPReplicationSet where ElementName = '" + rsName + "'");
        Trace.verbose((Object)this, "getReplicationSetByName", "Returned from querying CIM for ReplicationSet Instance matching name and storage domain");
        if (enumeration != null && enumeration.hasMoreElements()) {
            StorageVolumeInterface l_volume;
            String rDomain;
            Trace.verbose((Object)this, "getReplicationSetByName", "ReplicationSet instance found.");
            CIMInstance ci_rep = (CIMInstance)enumeration.nextElement();
            repSet = new ReplicationSetCIM(ci_rep, this.context);
            if (sDomain != null && !(rDomain = (l_volume = repSet.getLocalVolume()).getStorageDomainName()).equalsIgnoreCase(sDomain)) {
                Trace.verbose((Object)this, "getReplicationSetByName", "StorageDomain(s) don't match");
                repSet = null;
            }
        }
        Trace.methodEnd(this, "getReplicationSetByName");
        return repSet;
    }

    public MethodCallStatus resync(Object key, boolean fullSync) throws ConfigMgmtException {
        ReplicationSetCIM repSet;
        String METHOD = "resync";
        Trace.methodBegin(this, "resync");
        MethodCallStatus mcs = null;
        if (key != null) {
            repSet = null;
            if (key instanceof Collection) {
                repSet = (ReplicationSetCIM)this.getReplicationSetByKey((Collection)key);
            } else if (key instanceof ReplicationSetEnt1Interface) {
                repSet = (ReplicationSetCIM)key;
            }
            if (repSet == null) {
                Trace.error((Object)this, "resync", "Invalid Parameter: ReplicationSet");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), null, "ReplicationSet specified not found.", null, 300);
            }
        } else {
            Trace.error((Object)this, "resync", "Key object is null");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "ReplicationSet key specified is null.", null, 100);
        }
        int retVal = -1;
        String sync_type = null;
        sync_type = fullSync ? "32771" : "4";
        mcs = this.modifySyncCIMOM(repSet, sync_type);
        Trace.methodEnd(this, "resync");
        return mcs;
    }

    public void scoreboard(Object key, boolean fastStart) throws ConfigMgmtException {
        ReplicationSetCIM repSet;
        String METHOD = "scoreboard";
        Trace.methodBegin(this, "scoreboard");
        if (key != null) {
            repSet = null;
            if (key instanceof Collection) {
                repSet = (ReplicationSetCIM)this.getReplicationSetByKey((Collection)key);
            } else if (key instanceof ReplicationSetEnt1Interface) {
                repSet = (ReplicationSetCIM)key;
            }
            if (repSet == null) {
                Trace.error((Object)this, "scoreboard", "Invalid Parameter: ReplicationSet");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), null, "ReplicationSet specified not found.", null, 300);
            }
        } else {
            Trace.error((Object)this, "scoreboard", "Key object is null");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "ReplicationSet key specified is null.", null, 100);
        }
        String sync_type = null;
        sync_type = fastStart ? "32770" : "32768";
        this.modifySyncCIMOM(repSet, sync_type);
        Trace.methodEnd(this, "scoreboard");
    }

    public MethodCallStatus deleteReplicationGroup(Object key) throws ConfigMgmtException {
        String METHOD = "deleteReplicationGroup";
        Trace.methodBegin(this, "deleteReplicationGroup");
        List repSets = this.loadRepSets(key);
        MethodCallStatus mcs = null;
        mcs = repSets != null || !repSets.isEmpty() ? this.delete(repSets) : new MethodCallStatus();
        Trace.methodEnd(this, "deleteReplicationGroup");
        return mcs;
    }

    public MethodCallStatus resyncReplicationGroup(Object key) throws ConfigMgmtException {
        String METHOD = "resyncReplicationGroup";
        Trace.methodBegin(this, "resyncReplicationGroup");
        List repSets = this.loadRepSets(key);
        MethodCallStatus mcs = null;
        if (repSets != null || !repSets.isEmpty()) {
            ReplicationSetEnt1Interface repSet = (ReplicationSetEnt1Interface)repSets.get(0);
            if (repSet != null) {
                mcs = this.resync(repSet);
            }
        } else {
            mcs = new MethodCallStatus();
        }
        Trace.methodEnd(this, "resyncReplicationGroup");
        return mcs;
    }

    public MethodCallStatus resyncReplicationGroup(Object key, boolean fullSync) throws ConfigMgmtException {
        String METHOD = "resyncReplicationGroup";
        Trace.methodBegin(this, "resyncReplicationGroup");
        List repSets = this.loadRepSets(key);
        MethodCallStatus mcs = null;
        if (repSets != null || !repSets.isEmpty()) {
            ReplicationSetEnt1Interface repSet = (ReplicationSetEnt1Interface)repSets.get(0);
            if (repSet != null) {
                mcs = this.resync(repSet, fullSync);
            }
        } else {
            mcs = new MethodCallStatus();
        }
        Trace.methodEnd(this, "resyncReplicationGroup");
        return mcs;
    }

    public void roleReverseReplicationGroup(Object key) throws ConfigMgmtException {
        ReplicationSetEnt1Interface repSet;
        String METHOD = "roleReverseReplicationGroup";
        Trace.methodBegin(this, "roleReverseReplicationGroup");
        List repSets = this.loadRepSets(key);
        if (!(repSets == null && repSets.isEmpty() || (repSet = (ReplicationSetEnt1Interface)repSets.get(0)) == null)) {
            this.roleReverse(repSet);
        }
        Trace.methodEnd(this, "roleReverseReplicationGroup");
    }

    public void scoreboardReplicationGroup(Object key) throws ConfigMgmtException {
        ReplicationSetEnt1Interface repSet;
        String METHOD = "resyncReplicationGroup";
        Trace.methodBegin(this, "resyncReplicationGroup");
        List repSets = this.loadRepSets(key);
        if (!(repSets == null && repSets.isEmpty() || (repSet = (ReplicationSetEnt1Interface)repSets.get(0)) == null)) {
            this.scoreboard(repSet);
        }
        Trace.methodEnd(this, "resyncReplicationGroup");
    }

    public void scoreboardReplicationGroup(Object key, boolean fastStart) throws ConfigMgmtException {
        ReplicationSetEnt1Interface repSet;
        String METHOD = "resyncReplicationGroup";
        Trace.methodBegin(this, "resyncReplicationGroup");
        List repSets = this.loadRepSets(key);
        if (!(repSets == null && repSets.isEmpty() || (repSet = (ReplicationSetEnt1Interface)repSets.get(0)) == null)) {
            this.scoreboard(repSet, fastStart);
        }
        Trace.methodEnd(this, "resyncReplicationGroup");
    }

    public void enableReplicationPort(Object key, Properties props) throws ConfigMgmtException {
        String METHOD = "enableReplication";
        Trace.methodBegin(this, "enableReplication");
        String localAddress = null;
        String networkMask = null;
        String defaultGateway = null;
        int wndSize = 0;
        Vector links = null;
        if (key == null) {
            Trace.error((Object)this, "enableReplication", "Port key specified is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Port key specified is null.", null, 100);
        }
        ManagePortsCIM mgrPorts = new ManagePortsCIM();
        mgrPorts.init(this.context, null, null);
        FiberChannelPortCIM fcPort = (FiberChannelPortCIM)mgrPorts.getFiberChannelPortByKey((Collection)key);
        if (fcPort == null) {
            EthernetPortCIM etherPort = (EthernetPortCIM)mgrPorts.getEthernetPortByKey((Collection)key);
            if (etherPort == null) {
                Trace.error((Object)this, "enableReplication", "Port specified not found.");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), new String[]{"Port"}, "Port specified not found.", null, 100);
            }
            Object localAddrProp = props.get("LocalAddress");
            if (localAddrProp == null) {
                Trace.error((Object)this, "enableReplication", "Invalid Parameter: Local Address property not populated.");
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Local Address property not populated.", null, 100);
            }
            localAddress = (String)localAddrProp;
            EthernetPortCIM.validate(0, localAddress, null);
            Object networkMaskProp = props.get("NetworkMask");
            if (networkMaskProp == null) {
                Trace.error((Object)this, "enableReplication", "Invalid Parameter: Network Mask property not populated.");
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Network Mask property not populated.", null, 100);
            }
            networkMask = (String)networkMaskProp;
            EthernetPortCIM.validate(1, networkMask, null);
            Object defaultGateProp = props.get("DefaultGateway");
            if (defaultGateProp == null) {
                Trace.error((Object)this, "enableReplication", "Invalid Parameter: Default Gateway property not populated.");
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Default Gateway property not populated.", null, 100);
            }
            defaultGateway = (String)defaultGateProp;
            EthernetPortCIM.validate(2, defaultGateway, null);
            Object wndSizeProp = props.get("WindowSize");
            if (wndSizeProp == null) {
                Trace.error((Object)this, "enableReplication", "Invalid Parameter: Window Size property not populated.");
                wndSize = etherPort.getWindowSize();
                Trace.error((Object)this, "enableReplication", "Default Window Size: " + wndSize);
            } else {
                wndSize = (Integer)wndSizeProp;
                EthernetPortCIM.validate(3, wndSizeProp, null);
            }
            Object linksProp = props.get("Links");
            links = linksProp == null ? null : (Vector)linksProp;
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("LocalAddress", new CIMValue((Object)localAddress)), new CIMArgument("NetworkMask", new CIMValue((Object)networkMask)), new CIMArgument("DefaultGateway", new CIMValue((Object)defaultGateway)), new CIMArgument("TCPWindowSize", new CIMValue((Object)new UnsignedInt32((long)wndSize))), new CIMArgument("Port", new CIMValue((Object)etherPort.getInstance().getObjectPath()))};
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, "DEFAULT", 0);
            Trace.verbose((Object)this, "enableReplication", "Configuration service object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "enableReplication", "Calling CreateOrModifyReplicationPort");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyReplicationPort", inArgs, null);
            Trace.verbose((Object)this, "enableReplication", "Returned from calling CreateOrModifyReplicationPort");
            int retVal = (Integer)returnCodeValue.getValue();
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "enableReplication", "Return code: " + retVal);
            }
            if (retVal != 0) {
                Trace.error((Object)this, "enableReplication", "Error code returned: " + retVal);
                throw new ConfigMgmtException(ErrorCode.CIM_ERROR.getKey() + retVal, null, "Error code returned: " + retVal, null, 300);
            }
            if (links != null) {
                retVal = this.replicationLinkHelper(etherPort, links);
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "enableReplication", "Return code: " + retVal);
                }
                if (retVal != 0) {
                    Trace.error((Object)this, "enableReplication", "Error code returned: " + retVal);
                    throw new ConfigMgmtException(ErrorCode.CIM_ERROR.getKey() + retVal, null, "Error code returned: " + retVal, null, 300);
                }
            }
        } else {
            fcPort.setReplicationEnabled(true);
            fcPort.save();
        }
        Trace.methodEnd(this, "enableReplication");
    }

    public void disableReplicationPort(Object key) throws ConfigMgmtException {
        String METHOD = "disableReplicationPort";
        Trace.methodBegin(this, "disableReplicationPort");
        if (key == null) {
            Trace.error((Object)this, "disableReplicationPort", "Port key specified is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Port key specified is null.", null, 100);
        }
        ManagePortsCIM mgrPorts = new ManagePortsCIM();
        mgrPorts.init(this.context, null, null);
        FiberChannelPortCIM fcPort = (FiberChannelPortCIM)mgrPorts.getFiberChannelPortByKey((Collection)key);
        if (fcPort == null) {
            EthernetPortCIM etherPort = (EthernetPortCIM)mgrPorts.getEthernetPortByKey((Collection)key);
            if (etherPort == null) {
                Trace.error((Object)this, "disableReplicationPort", "Port specified not found.");
                throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), new String[]{"Port"}, "Port specified not found.", null, 100);
            }
            etherPort.setReplicationEnabled(false);
            etherPort.save();
        } else {
            fcPort.setReplicationEnabled(false);
            fcPort.save();
        }
        Trace.methodEnd(this, "disableReplicationPort");
    }

    public void addReplicationLinks(Object key, List links) throws ConfigMgmtException {
        String METHOD = "addReplicationLinks";
        Trace.methodBegin(this, "addReplicationLinks");
        if (key == null) {
            Trace.error((Object)this, "addReplicationLinks", "Port key specified is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Port key specified is null.", null, 100);
        }
        ManagePortsCIM mgrPorts = new ManagePortsCIM();
        mgrPorts.init(this.context, null, null);
        EthernetPortCIM etherPort = (EthernetPortCIM)mgrPorts.getEthernetPortByKey((Collection)key);
        if (etherPort == null) {
            Trace.error((Object)this, "addReplicationLinks", "Port specified not found.");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), new String[]{"Port"}, "Port specified not found.", null, 100);
        }
        ArrayList curLinks = (ArrayList)etherPort.getAssociatedReplicationLinks();
        curLinks.addAll(links);
        int retVal = 0;
        if (curLinks.size() != 0) {
            retVal = this.replicationLinkHelper(etherPort, curLinks);
        }
        if (retVal != 0) {
            Trace.error((Object)this, "addReplicationLinks", "Error code returned: " + retVal);
            throw new ConfigMgmtException(ErrorCode.CIM_ERROR.getKey() + retVal, null, "Error code returned: " + retVal, null, 300);
        }
        Trace.methodEnd(this, "addReplicationLinks");
    }

    public void removeReplicationLinks(Object key, List links) throws ConfigMgmtException {
        String METHOD = "removeReplicationLinks";
        Trace.methodBegin(this, "removeReplicationLinks");
        if (key == null) {
            Trace.error((Object)this, "removeReplicationLinks", "Port key specified is null.");
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Port key specified is null.", null, 100);
        }
        ManagePortsCIM mgrPorts = new ManagePortsCIM();
        mgrPorts.init(this.context, null, null);
        EthernetPortCIM etherPort = (EthernetPortCIM)mgrPorts.getEthernetPortByKey((Collection)key);
        if (etherPort == null) {
            Trace.error((Object)this, "removeReplicationLinks", "Port specified not found.");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), new String[]{"Port"}, "Port specified not found.", null, 100);
        }
        ArrayList<ErrorDescriptor> results = new ArrayList<ErrorDescriptor>();
        boolean failed = false;
        for (int i = 0; i < links.size(); ++i) {
            ReplicationLinkCIM link = (ReplicationLinkCIM)links.get(i);
            CIMObjectPath linkPath = link.getInstance().getObjectPath();
            try {
                this.handle.deleteInstance(linkPath);
                results.add(new ErrorDescriptor(ErrorCode.REP_LINK_DELETE_SUCCESS, new String[]{link.getRemoteAddress()}, "Replication Link Deleted."));
                continue;
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "removeReplicationLinks", "Error occured removing ReplicationLink.");
                failed = true;
                results.add(new ErrorDescriptor(ErrorCode.REP_LINK_DELETE_FAILED, new String[]{link.getRemoteAddress()}, "Error Deleting ReplicationLink."));
            }
        }
        if (failed) {
            throw new ConfigMgmtException(results, ErrorCode.SUCCESS.getKey(), "Results from ReplicationLink deletion", 300);
        }
        Trace.methodEnd(this, "removeReplicationLinks");
    }

    public ReplicationLinkEnt1Interface createReplicationLink(String remoteAddress, String description) throws ConfigMgmtException {
        String METHOD = "createReplicationLink";
        Trace.methodBegin(this, "createReplicationLink");
        ReplicationLinkCIM link = new ReplicationLinkCIM(remoteAddress, description);
        Trace.methodEnd(this, "createReplicationLink");
        return link;
    }

    private void createRepSetCIMOM(StorageVolume localVolume, String remoteVolumeWwn, String remotePeerWwn, StoragePool bitmapPool, ReplicationGroupCIM replicationGroup, ReplicationParametersCIM replicationParams, Object asyncQueue, BigInteger queueSize, String groupName, String groupDescription) throws ConfigMgmtException {
        String METHOD = "createRepSetCIMOM";
        Trace.methodBegin(this, "createRepSetCIMOM");
        CIMArgument[] inArgs = new CIMArgument[7];
        inArgs[0] = new CIMArgument("LocalElement", new CIMValue((Object)localVolume.getInstance().getObjectPath()));
        inArgs[1] = new CIMArgument("SetIndex", new CIMValue((Object)new UnsignedInt16(1)));
        inArgs[2] = new CIMArgument("RemoteElementName", new CIMValue((Object)remoteVolumeWwn));
        inArgs[3] = new CIMArgument("Bitmap", new CIMValue((Object)bitmapPool.getInstance().getObjectPath()));
        if (replicationGroup == null) {
            if (groupName != null) {
                CIMObjectPath copGrp = new CIMObjectPath("SunStorEdge_DSPReplicationGroup");
                copGrp.addKey("Name", new CIMValue((Object)groupName));
                if (groupDescription != null) {
                    copGrp.addKey("Description", new CIMValue((Object)groupDescription));
                }
                inArgs[4] = new CIMArgument("Group", new CIMValue((Object)copGrp));
            } else {
                inArgs[4] = new CIMArgument("Group", new CIMValue(null));
            }
        } else {
            inArgs[4] = new CIMArgument("Group", new CIMValue((Object)replicationGroup.getCIMInstance().getObjectPath()));
        }
        boolean toRemoveFakeParams = false;
        CIMObjectPath repParamsPath = null;
        if (replicationParams == null) {
            inArgs[5] = new CIMArgument("Parameters", new CIMValue(null));
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("InstanceID", new Date().getTime() + "");
            try {
                repParamsPath = CIMObjectWrapper.createInstance(this.handle, CIMObjectWrapper.instanceKeyBuilder(map), "SunStorEdge_DSPReplicationParameters");
                CIMInstance repParamsInst = this.handle.getInstance(repParamsPath, false, true, false, null);
                repParamsPath = repParamsInst.getObjectPath();
                repParamsInst.setProperty("Role", new CIMValue((Object)new UnsignedInt16(replicationParams.getRole())));
                repParamsInst.setProperty("Mode", new CIMValue((Object)new UnsignedInt16(replicationParams.getSyncMode())));
                repParamsInst.setProperty("AutoSynchronize", new CIMValue((Object)new Boolean(replicationParams.isAutoSync())));
                repParamsInst.setProperty("SnapBeforeResync", new CIMValue((Object)new Boolean(replicationParams.isSnapBeforeSync())));
                repParamsInst.setProperty("SnapSecondary", new CIMValue((Object)new Boolean(replicationParams.isSnapWithPrimary())));
                repParamsInst.setProperty("ReplicationPriority", new CIMValue((Object)new UnsignedInt16(replicationParams.getPriority())));
                repParamsInst.setProperty("QueueWrites", new CIMValue((Object)new UnsignedInt32((long)replicationParams.getAsyncQWriteCount())));
                repParamsInst.setProperty("QueueBlockCount", new CIMValue((Object)new UnsignedInt64(replicationParams.getAsyncQBlockCount())));
                repParamsInst.setProperty("QueueTime", new CIMValue((Object)new UnsignedInt32((long)replicationParams.getAsyncQTimeCount())));
                repParamsInst.setProperty("QueueAction", new CIMValue((Object)new UnsignedInt16(replicationParams.getAsyncQAction())));
                repParamsInst.setProperty("Peer", new CIMValue((Object)remotePeerWwn));
                repParamsInst.setProperty("QueueSize", new CIMValue((Object)new UnsignedInt64(queueSize)));
                this.handle.setInstance(repParamsPath, repParamsInst);
                toRemoveFakeParams = true;
            }
            catch (CIMException ce) {
                Trace.error((Object)this, "createRepSetCIMOM", "Errors creating ReplicationParametersCIM.");
                Trace.methodEnd(this, "createRepSetCIMOM");
                throw new ConfigMgmtException("error.systemError", "Errors creation ReplicationParametersCIM.");
            }
            inArgs[5] = new CIMArgument("Parameters", new CIMValue((Object)repParamsPath));
        }
        if (asyncQueue == null) {
            inArgs[6] = new CIMArgument("Queue", new CIMValue(null));
        } else if (asyncQueue instanceof StoragePoolInterface) {
            inArgs[6] = new CIMArgument("Queue", new CIMValue((Object)((StoragePoolInterface)asyncQueue).getInstance().getObjectPath()));
        } else if (asyncQueue instanceof StorageVolumeInterface) {
            inArgs[6] = new CIMArgument("Queue", new CIMValue((Object)((StorageVolumeInterface)asyncQueue).getInstance().getObjectPath()));
        }
        CIMArgument[] outArgs = new CIMArgument[3];
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, localVolume.getStorageDomainName(), 0);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "createRepSetCIMOM", "Configuration service object path is: " + confServiceObjectPath);
        }
        Trace.verbose((Object)this, "createRepSetCIMOM", "Calling AttachReplicationSet");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "AttachOrModifyReplicationSet", inArgs, outArgs);
        Trace.verbose((Object)this, "createRepSetCIMOM", "Returned from calling AttachReplicationSet");
        int retVal = (Integer)returnCodeValue.getValue();
        Trace.verbose((Object)this, "createRepSetCIMOM", "Return code: " + retVal);
        if (retVal != 0 && retVal != 4096) {
            Trace.error((Object)this, "createRepSetCIMOM", "Error creating ReplicationSet: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "createRepSetCIMOM");
    }

    private MethodCallStatus modifySyncCIMOM(ReplicationSetCIM repSet, String operation) throws ConfigMgmtException {
        String METHOD = "modifySyncCIMOM";
        Trace.methodBegin(this, "modifySyncCIMOM");
        CIMInstance syncInst = null;
        Trace.verbose((Object)this, "modifySyncCIMOM", "Querying the CIM for a RemoteStorageSynchronized association.");
        Enumeration enumAssoc = this.handle.references(repSet.getCIMInstance().getObjectPath(), "SunStorEdge_DSPRemoteStorageSynchronized", "SyncedElement", true, false, null);
        Trace.verbose((Object)this, "modifySyncCIMOM", "Returned from querying the CIM for a RemoteStorageSynchronized association");
        if (enumAssoc == null || !enumAssoc.hasMoreElements()) {
            Trace.error((Object)this, "modifySyncCIMOM", "RemoteStorageSynchronized not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "RemoteStorageSynchronized association not found.."), 100);
        }
        Trace.verbose((Object)this, "modifySyncCIMOM", "RemoteStorageSynchronized association instance found.");
        syncInst = (CIMInstance)enumAssoc.nextElement();
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Operation", new CIMValue((Object)new UnsignedInt16(operation))), new CIMArgument("Synchronization", new CIMValue((Object)syncInst.getObjectPath()))};
        CIMArgument[] outArgs = new CIMArgument[1];
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, repSet.getLocalVolume().getStorageDomainName(), 0);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "modifySyncCIMOM", "Configuration service object path is: " + confServiceObjectPath);
        }
        Trace.verbose((Object)this, "modifySyncCIMOM", "Calling ModifySynchronization");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "ModifySynchronization", inArgs, outArgs);
        int retVal = (Integer)returnCodeValue.getValue();
        Trace.verbose((Object)this, "modifySyncCIMOM", "Returned from calling ModifySynchronization. Return value: " + retVal);
        MethodCallStatus mcs = null;
        if (retVal == 4096) {
            CIMObjectPath jobPath = null;
            for (int i = 0; jobPath == null && i < outArgs.length; ++i) {
                if (!outArgs[i].getName().equalsIgnoreCase("Job") || outArgs[i].getValue() == null) continue;
                jobPath = (CIMObjectPath)outArgs[i].getValue().getValue();
            }
            if (jobPath == null) {
                String msg = "Extrinsic method reported job should be present, but none could be found.";
                Trace.error((Object)this, "modifySyncCIMOM", msg);
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", msg);
            }
            JobManagerInterface jobMgr = JobManagerFactory.create();
            jobMgr.init(this.context, null);
            ArrayList<JobInterface> jobs = new ArrayList<JobInterface>();
            jobs.add(jobMgr.get(jobPath, null));
            mcs = new MethodCallStatus(retVal, jobs);
        } else if (retVal == 0) {
            mcs = new MethodCallStatus();
            mcs.setReturnCode(retVal);
        } else {
            Trace.error((Object)this, "modifySyncCIMOM", "Error doing operation: " + operation);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "modifySyncCIMOM");
        return mcs;
    }

    private ArrayList getReplicationSetsCIMOM() throws ConfigMgmtException {
        String METHOD = "getReplicationSetsCIMOM";
        ArrayList<ReplicationSetCIM> cimomList = null;
        Trace.verbose((Object)this, "getReplicationSetsCIMOM", "Querying CIM for all \u0016ReplicationSetCIM Instances");
        Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPReplicationSet"), false, false, true, false, null);
        Trace.verbose((Object)this, "getReplicationSetsCIMOM", "Returned from querying CIM for all ReplicationSetCIM Instances");
        if (enumeration != null && enumeration.hasMoreElements()) {
            cimomList = new ArrayList<ReplicationSetCIM>();
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                ReplicationSetCIM rs = new ReplicationSetCIM(ci, this.context);
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "getReplicationSetsCIMOM", "Adding ReplicationSetCIM object to object list: " + rs);
                }
                cimomList.add(rs);
            }
        }
        Trace.methodEnd(this, "getReplicationSetsCIMOM");
        return cimomList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List loadRepSets(Object key) throws ConfigMgmtException {
        String METHOD = "loadRepSets";
        Trace.methodBegin(this, "loadRepSets");
        ReplicationGroupEnt1Interface repGrp = null;
        List repSets = null;
        if (key == null) {
            Trace.error((Object)this, "loadRepSets", "Key object is null");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ReplicationSet key specified is null."), 100);
        }
        if (key instanceof ReplicationGroupEnt1Interface) {
            repGrp = (ReplicationGroupEnt1Interface)key;
        } else if (key instanceof Collection) {
            Collection k = (Collection)key;
            repGrp = this.getReplicationGroupByKey(k);
        }
        if (repGrp == null) {
            Trace.error((Object)this, "loadRepSets", "Invalid Parameter: ReplicationGroup not found");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"ReplicationGroup"}, "ReplicationGroup  specified not found."), 100);
        }
        repSets = repGrp.getReplicationSets();
        if (repSets != null && repSets.isEmpty()) {
            Trace.error((Object)this, "loadRepSets", "RepGroup is empty!!!: ." + repGrp.getName());
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Replication Group is empty."), 100);
        }
        Trace.methodEnd(this, "loadRepSets");
        return repSets;
    }

    private int replicationLinkHelper(EthernetPortCIM etherPort, List links) throws ConfigMgmtException {
        String METHOD = "replicationLinkHelper";
        Trace.methodBegin(this, "replicationLinkHelper");
        Vector<String> linkPaths = new Vector<String>();
        for (int i = 0; i < links.size(); ++i) {
            ReplicationLinkCIM curLink = (ReplicationLinkCIM)links.get(i);
            if (curLink.getInstance() == null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("InstanceID", new Date().getTime() + "");
                CIMObjectPath repLinkPath = CIMObjectWrapper.createInstance(this.handle, CIMObjectWrapper.instanceKeyBuilder(map), "SunStorEdge_DSPReplicationLink");
                CIMInstance repLinkInstance = this.handle.getInstance(repLinkPath, false, true, false, null);
                try {
                    repLinkInstance.setProperty("RemoteAddress", new CIMValue((Object)curLink.getRemoteAddress()));
                    repLinkInstance.setProperty("Description", new CIMValue((Object)curLink.getDescription()));
                }
                catch (CIMException ce) {
                    Trace.error((Object)this, "replicationLinkHelper", "Error setting properties of ReplicationLink CIMInstance.");
                    throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "Error setting properties of ReplicationLink CIMInstance.", null, 100);
                }
                this.handle.setInstance(repLinkPath, repLinkInstance);
                linkPaths.add(repLinkPath.toString());
                continue;
            }
            linkPaths.add(curLink.getInstance().getObjectPath().toString());
        }
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Links", new CIMValue(linkPaths, new CIMDataType(22))), new CIMArgument("Port", new CIMValue((Object)etherPort.getInstance().getObjectPath()))};
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, "DEFAULT", 0);
        Trace.verbose((Object)this, "replicationLinkHelper", "Configuration service object path is: " + confServiceObjectPath);
        Trace.verbose((Object)this, "replicationLinkHelper", "Calling CreateOrModifyReplicationLink");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateOrModifyReplicationLink", inArgs, null);
        Trace.verbose((Object)this, "replicationLinkHelper", "Returned from calling CreateOrModifyReplicationPort");
        int retVal = (Integer)returnCodeValue.getValue();
        Trace.methodEnd(this, "replicationLinkHelper");
        return retVal;
    }

    public List getItemsByArray(String arrayName) throws ConfigMgmtException, ItemNotFoundException {
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        return msv.getItemsByArray(arrayName, 1);
    }

    public List getItemsByDisk(String arrayName, String trayId, int diskId) throws ConfigMgmtException, ItemNotFoundException {
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        return msv.getItemsByDisk(arrayName, trayId, diskId, 1);
    }

    public List getItemsByTray(String arrayName, String trayId) throws ConfigMgmtException, ItemNotFoundException {
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        return msv.getItemsByTray(arrayName, trayId, 1);
    }

    public List getItemsByVDisk(String name) throws ConfigMgmtException, ItemNotFoundException {
        ManageStorageVolumes msv = new ManageStorageVolumes();
        msv.init(this.context, null);
        return msv.getItemsByVDisk(name, 1);
    }

    public boolean doesVDiskHaveRepSets(String name) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doesVDiskHaveRepSets";
        Trace.methodBegin(this, "doesVDiskHaveRepSets");
        ManageVDisks mvd = new ManageVDisks();
        mvd.init(this.context, null);
        VDisk vdisk = (VDisk)mvd.getItemByName(name);
        if (vdisk != null) {
            return vdisk.doesVDiskHaveRepSets();
        }
        Trace.error((Object)this, "doesVDiskHaveRepSets", "VDisk: " + name + " not found");
        throw new ItemNotFoundException(name);
    }

    public boolean doesArrayHaveRepSets(String arrayName) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doesArrayHaveRepSets";
        Trace.methodBegin(this, "doesArrayHaveRepSets");
        return this.doesTrayHaveRepSets(arrayName, null);
    }

    public boolean doesTrayHaveRepSets(String arrayName, String trayId) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doesTrayHaveRepSets";
        Trace.methodBegin(this, "doesTrayHaveRepSets");
        ManageVDisks mv = new ManageVDisks();
        mv.init(this.context, null);
        ArrayList vdisks = mv.getItemsByTray(arrayName, trayId);
        int size = vdisks.size();
        for (int i = 0; i < size; ++i) {
            VDisk vdisk = (VDisk)vdisks.get(i);
            if (!vdisk.doesVDiskHaveRepSets()) continue;
            return true;
        }
        return false;
    }

    public boolean doesDiskHaveRepSets(String arrayName, String trayId, int diskId) throws ConfigMgmtException, ItemNotFoundException {
        String METHOD_NAME = "doesDiskHaveRepSets";
        Trace.methodBegin(this, "doesDiskHaveRepSets");
        ManageVDisks mv = new ManageVDisks();
        mv.init(this.context, null);
        ArrayList vdisks = mv.getItemsByDisk(arrayName, trayId, diskId);
        int size = vdisks.size();
        if (vdisks.size() > 0) {
            VDisk vdisk = (VDisk)vdisks.get(0);
            return vdisk.doesVDiskHaveRepSets();
        }
        return false;
    }
}

