/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentInterface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.ManageMirrorServicesEnt1;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirrorComponentCIM;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1.cim.MirroredVolumeCIM;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerFactory;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageDomains;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStoragePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageDomain;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StoragePool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;

public class ManageMirrorServicesCIM
extends ManageMirrorServicesEnt1 {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private Scope scope;
    private SearchFilter filter;
    private ArrayList mirroredVolumes = null;

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        String METHOD = "init";
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ConfigContext object is null"), 100);
        }
        this.context = context;
        this.handle = context.getClient();
        this.scope = scope;
        this.filter = filter;
        if (this.handle == null) {
            Trace.error((Object)this, "init", "Client object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Client object is null."), 100);
        }
        Trace.methodEnd(this, "init");
    }

    public void create(Properties props) throws ConfigMgmtException {
        Object logPoolsProp;
        Object snapPoolProp;
        Object snapCompProp;
        Object snapPolicyProp;
        Object snapChangeProp;
        Object snapNumProp;
        Object sourcesProp;
        Object domainProp;
        Object descProp;
        String METHOD = "create";
        Trace.methodBegin(this, "create");
        String name = null;
        String description = new String("");
        StorageDomain domain = null;
        Integer isolationPolicy = new Integer(1);
        Vector sources = null;
        BigInteger size = null;
        Integer resilverPriority = new Integer(128);
        Integer snapNum = new Integer(0);
        Integer snapChange = new Integer(0);
        Integer snapPolicy = new Integer(0);
        Integer snapComp = new Integer(1);
        StoragePool snapPool = null;
        Vector logPools = null;
        Trace.verbose((Object)this, "create", "Parsing creation parameters...");
        Object nameProp = props.get("name");
        if (nameProp != null) {
            MirroredVolumeCIM.validate(0, nameProp, null);
            name = (String)nameProp;
        }
        if ((descProp = props.get("description")) != null) {
            MirroredVolumeCIM.validate(1, descProp, null);
            description = (String)descProp;
        }
        if ((domainProp = props.get("domain")) == null) {
            Trace.error((Object)this, "create", "Invalid Parameter: StorageDomain property not populated.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "StorageDomain property not populated."), 100);
        }
        domain = (StorageDomain)domainProp;
        Object isolationProp = props.get("isolationPolicy");
        if (isolationProp != null) {
            MirroredVolumeCIM.validate(7, isolationProp, null);
            isolationPolicy = (Integer)isolationProp;
        }
        if ((sourcesProp = props.get("sources")) == null) {
            Trace.error((Object)this, "create", "Invalid Parameter: Sources property not populated.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Sources property not populated."), 100);
        }
        sources = (Vector)sourcesProp;
        Object sizeProp = props.get("size");
        if (sources.get(0) instanceof StorageVolumeInterface) {
            StorageVolume vol = (StorageVolume)sources.get(0);
            size = vol.getSize();
            name = vol.getName();
            snapPolicy = new Integer(vol.getSnapshotPolicy());
        } else if (sizeProp != null) {
            MirroredVolumeCIM.validate(2, sizeProp, null);
            size = (BigInteger)sizeProp;
        } else {
            Trace.error((Object)this, "create", "Invalid Parameter: Size property not populated.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Size property not populated."), 100);
        }
        Object resilverProp = props.get("resilverPriority");
        if (resilverProp != null) {
            MirroredVolumeCIM.validate(6, resilverProp, null);
            resilverPriority = (Integer)resilverProp;
        }
        if ((snapNumProp = props.get("snamNum")) != null) {
            MirroredVolumeCIM.validate(3, snapNumProp, null);
            snapNum = (Integer)snapNumProp;
        }
        if ((snapChangeProp = props.get("snapChange")) != null) {
            MirroredVolumeCIM.validate(4, snapChangeProp, null);
            snapChange = (Integer)snapChangeProp;
        }
        if ((snapPolicyProp = props.get("snapPolicy")) != null) {
            MirroredVolumeCIM.validate(5, snapPolicyProp, null);
            snapPolicy = (Integer)snapPolicyProp;
        }
        if ((snapCompProp = props.get("snapComponent")) != null) {
            snapComp = (Integer)snapCompProp;
        }
        if ((snapPoolProp = props.get("snapPool")) != null) {
            snapPool = (StoragePool)snapPoolProp;
        }
        if ((logPoolsProp = props.get("logPools")) != null) {
            logPools = (Vector)logPoolsProp;
        }
        Trace.verbose((Object)this, "create", "Done parsing parameters...");
        int retVal = this.createMirror(name, description, domain, isolationPolicy, sources, size, resilverPriority, snapNum, snapChange, snapPolicy, snapComp, snapPool, logPools, sources.size(), true);
        if (retVal != 0) {
            Trace.verbose((Object)this, "create", "Error code returned: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "create");
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD = "modify";
        Trace.methodBegin(this, "modify");
        Trace.methodEnd(this, "modify");
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String METHOD = "delete";
        Trace.methodBegin(this, "delete");
        MethodCallStatus mcs = new MethodCallStatus();
        ArrayList<ErrorDescriptor> results = new ArrayList<ErrorDescriptor>();
        boolean failed = false;
        if (list == null || list.size() == 0) {
            Trace.verbose((Object)this, "delete", "Empty list provided, returning null.");
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            MirroredVolumeCIM mirror = null;
            if (!(obj instanceof Collection)) {
                Trace.error((Object)this, "delete", "Invalid key object specified.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Invalid key object specified."), 100);
            }
            mirror = (MirroredVolumeCIM)this.getMirroredVolumeByKey((Collection)obj);
            if (mirror == null) {
                Trace.error((Object)this, "delete", "MirroredVolume specified not found.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"Mirror"}, "MirroredVolume specified not found."), 100);
            }
            int retVal = this.delete(mirror);
            if (retVal != 0) {
                failed = true;
                results.add(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, new String[]{mirror.getName()}, "Error Deleting Mirror."));
                continue;
            }
            results.add(new ErrorDescriptor(ErrorCode.MIRROR_DELETE_SUCCESSFUL, new String[]{mirror.getName()}, "Error Deleting Mirror."));
        }
        if (failed) {
            throw new ConfigMgmtException(results, ErrorCode.SUCCESS.getKey(), "Results from Mirror Deletion", 300);
        }
        mcs.setReturnCode(0);
        return mcs;
    }

    public int getMaxObjects() {
        String METHOD = "getMaxObjects";
        Trace.methodBegin(this, "getMaxObjects");
        Trace.methodEnd(this, "getMaxObjects");
        return 2048;
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD = "getItemList";
        Trace.methodBegin(this, "getItemList");
        Trace.methodEnd(this, "getItemList");
        return this.getMirroredVolumeList();
    }

    public int getItemCount() throws ConfigMgmtException {
        String METHOD = "getItemCount";
        Trace.methodBegin(this, "getItemCount");
        if (this.mirroredVolumes == null) {
            this.getMirroredVolumeList();
        }
        if (this.mirroredVolumes == null) {
            Trace.methodEnd(this, "getItemCount");
            return 0;
        }
        Trace.methodEnd(this, "getItemCount");
        return this.mirroredVolumes.size();
    }

    public List getMirroredVolumeList() throws ConfigMgmtException {
        String METHOD = "getMirroredVolumeList";
        Trace.methodBegin(this, "getMirroredVolumeList");
        ArrayList<MirroredVolumeCIM> mirroredVols = new ArrayList<MirroredVolumeCIM>();
        if (this.scope == null) {
            Trace.verbose((Object)this, "getMirroredVolumeList", "Querying CIM for all StorageVolume Instances");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStorageVolume"), false, false, true, false, null);
            Trace.verbose((Object)this, "getMirroredVolumeList", "Returned from querying CIM for all StorageVolume Instances");
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    CIMValue cv = ci.getProperty("ObjectType").getValue();
                    if (cv != null) {
                        UnsignedInt16 objectType = (UnsignedInt16)cv.getValue();
                        if (objectType.intValue() != 2) continue;
                        MirroredVolumeCIM mv = new MirroredVolumeCIM();
                        mv.init(this.context);
                        mv.setInstance(ci);
                        CIMObjectWrapper.populate(mv, mv.getFieldMap(), ci);
                        mv.loadKeys();
                        if (Trace.isTraceEnabled(this)) {
                            Trace.verbose((Object)this, "getMirroredVolumeList", "Adding MirroredVolumeInterface object to object list: " + mv);
                        }
                        mirroredVols.add(mv);
                        continue;
                    }
                    Trace.error((Object)this, "getMirroredVolumeList", "ObjectType is null.");
                    throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ObjectType is null."), 100);
                }
            }
        }
        Trace.methodEnd(this, "getMirroredVolumeList");
        return mirroredVols;
    }

    public MirroredVolumeInterface getMirroredVolumeByKey(Object key) throws ConfigMgmtException {
        CIMInstance ci;
        String METHOD = "getMirroredVolumeByKey";
        Trace.methodBegin(this, "getMirroredVolumeByKey");
        MirroredVolumeCIM mv = null;
        if (key != null) {
            CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPStorageVolume", new Vector((Collection)key));
            Trace.verbose((Object)this, "getMirroredVolumeByKey", "Querying CIM for StorageVolume Instance matching key(s)");
            ci = this.handle.getInstance(objPath, false, true, false, null);
            Trace.verbose((Object)this, "getMirroredVolumeByKey", "Returned from querying CIM for StorageVolume Instance matching key(s)");
            if (ci == null) {
                Trace.error((Object)this, "getMirroredVolumeByKey", "Could not retrieve CIMInstance.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve CIMInstance"), 100);
            }
        } else {
            Trace.error((Object)this, "getMirroredVolumeByKey", "Key object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Key object is null."), 100);
        }
        Trace.verbose((Object)this, "getMirroredVolumeByKey", "Creating MirroredVolume Java Object");
        mv = new MirroredVolumeCIM();
        mv.init(this.context);
        mv.setInstance(ci);
        CIMObjectWrapper.populate(mv, mv.getFieldMap(), ci);
        mv.loadKeys();
        if (mv == null) {
            Trace.verbose((Object)this, "getMirroredVolumeByKey", "No instance returned when trying to obtain the MirroredVolume");
            Trace.methodEnd(this, "getMirroredVolumeByKey");
            return null;
        }
        Trace.methodEnd(this, "getMirroredVolumeByKey");
        return mv;
    }

    public MirrorComponentInterface getMirrorComponentByKey(Object key) throws ConfigMgmtException {
        CIMInstance ci;
        String METHOD = "getMirrorComponentByKey";
        Trace.methodBegin(this, METHOD);
        MirrorComponentCIM mc = null;
        if (key != null) {
            CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPStorageVolume", new Vector((Collection)key));
            Trace.verbose((Object)this, METHOD, "Querying CIM for StorageVolume Instance matching key(s)");
            ci = this.handle.getInstance(objPath, false, true, false, null);
            Trace.verbose((Object)this, METHOD, "Returned from querying CIM for StorageVolume Instance matching key(s)");
            if (ci == null) {
                Trace.error((Object)this, METHOD, "Could not retrieve CIMInstance.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve CIMInstance."), 100);
            }
        } else {
            Trace.error((Object)this, METHOD, "Key object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Key object is null."), 100);
        }
        Trace.verbose((Object)this, METHOD, "Creating MirrorComponent Java Object");
        mc = new MirrorComponentCIM();
        mc.init(this.context);
        mc.setInstance(ci);
        CIMObjectWrapper.populate(mc, mc.getFieldMap(), ci);
        mc.loadKeys();
        if (mc == null) {
            Trace.verbose((Object)this, METHOD, "No instance returned when trying to obtain the MirrorComponent");
            Trace.methodEnd(this, METHOD);
            return null;
        }
        Trace.methodEnd(this, METHOD);
        return mc;
    }

    public MirroredVolumeInterface getMirroredVolumeByName(String mirrorName, String domainName) throws ConfigMgmtException {
        String METHOD = "getMirroredVolumeByName";
        Trace.methodBegin(this, "getMirroredVolumeByName");
        MirroredVolumeCIM mv = null;
        Trace.verbose((Object)this, "getMirroredVolumeByName", "Querying CIM for StorageVolume: " + mirrorName + " in StorageDomain: " + domainName);
        Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageVolume where ElementName = '" + mirrorName + "'");
        Trace.verbose((Object)this, "getMirroredVolumeByName", "Returned from querying CIM for StorageVolume: " + mirrorName);
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getMirroredVolumeByName", "StorageVolume: " + mirrorName + " Found.");
            Trace.verbose((Object)this, "getMirroredVolumeByName", "Creating StorageVolume Java Object");
            CIMInstance ci = (CIMInstance)enumeration.nextElement();
            CIMValue cv = ci.getProperty("ObjectType").getValue();
            if (cv != null) {
                UnsignedInt16 objectType = (UnsignedInt16)cv.getValue();
                int type = objectType.intValue();
                if (type == 2) {
                    mv = new MirroredVolumeCIM();
                    mv.setInstance(ci);
                    mv.init(this.context);
                    CIMObjectWrapper.populate(mv, mv.getFieldMap(), ci);
                    mv.loadKeys();
                    if (null != domainName && !mv.getStorageDomainName().equals(domainName)) {
                        Trace.verbose((Object)this, "getMirroredVolumeByName", "StorageDomain does not match, trashing.");
                        mv = null;
                    }
                }
            } else {
                Trace.error((Object)this, "getMirroredVolumeByName", "ObjectType is null.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ObjectType is null."), 100);
            }
        }
        if (mv == null) {
            Trace.verbose((Object)this, "getMirroredVolumeByName", "No instance returned when trying to obtain the MirroredVolume: " + mirrorName + " in StorageDomain: " + domainName);
            return null;
        }
        Trace.methodEnd(this, "getMirroredVolumeByName");
        return mv;
    }

    public MirrorComponentInterface getMirrorComponentByName(String compName, String domainName) throws ConfigMgmtException {
        String METHOD = "getMirrorComponentByName";
        Trace.methodBegin(this, "getMirrorComponentByName");
        MirrorComponentCIM mc = null;
        Trace.verbose((Object)this, "getMirrorComponentByName", "Querying CIM for StorageVolume: " + compName + " in StorageDomain: " + domainName);
        Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageVolume where ElementName = '" + compName + "'");
        Trace.verbose((Object)this, "getMirrorComponentByName", "Returned from querying CIM for StorageVolume: " + compName);
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "getMirrorComponentByName", "StorageVolume: " + compName + " Found.");
            Trace.verbose((Object)this, "getMirrorComponentByName", "Creating StorageVolume Java Object");
            CIMInstance ci = (CIMInstance)enumeration.nextElement();
            CIMValue cv = ci.getProperty("ObjectType").getValue();
            if (cv != null) {
                UnsignedInt16 objectType = (UnsignedInt16)cv.getValue();
                int type = objectType.intValue();
                if (type == 3) {
                    mc = new MirrorComponentCIM();
                    mc.setInstance(ci);
                    mc.init(this.context);
                    CIMObjectWrapper.populate(mc, mc.getFieldMap(), ci);
                    mc.loadKeys();
                    if (null != domainName && !mc.getStorageDomainName().equals(domainName)) {
                        Trace.verbose((Object)this, "getMirrorComponentByName", "StorageDomain does not match, trashing.");
                        mc = null;
                    }
                }
            } else {
                Trace.error((Object)this, "getMirrorComponentByName", "ObjectType is null.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "ObjectType is null."), 100);
            }
        }
        if (mc == null) {
            Trace.verbose((Object)this, "getMirrorComponentByName", "No instance returned when trying to obtain the MirroredVolume: " + compName + " in StorageDomain: " + domainName);
            return null;
        }
        Trace.methodEnd(this, "getMirrorComponentByName");
        return mc;
    }

    public void addComponent(Object mirrorKey, Properties props) throws ConfigMgmtException {
        Object logPoolsProp;
        Object snapPoolProp;
        Object snapCompProp;
        Object snapPolicyProp;
        Object snapNumProp;
        Object resilverProp;
        String METHOD = "addComponent";
        Trace.methodBegin(this, "addComponent");
        Integer isolationPolicy = new Integer(1);
        Vector sources = null;
        Integer resilverPriority = new Integer(128);
        Integer snapNum = new Integer(0);
        Integer snapChange = new Integer(0);
        Integer snapPolicy = new Integer(0);
        Integer snapComp = new Integer(1);
        StoragePool snapPool = null;
        Vector logPools = null;
        Trace.verbose((Object)this, "addComponent", "Parsing parameters...");
        if (mirrorKey == null) {
            Trace.error((Object)this, "addComponent", "MirroredVolume key specified is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "MirroredVolume key specified is null."), 100);
        }
        MirroredVolumeCIM mirror = (MirroredVolumeCIM)this.getMirroredVolumeByKey((Collection)mirrorKey);
        if (mirror == null) {
            Trace.error((Object)this, "addComponent", "MirroredVolume specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"Mirror"}, "MirroredVolume specified not found."), 100);
        }
        Object sourcesProp = props.get("sources");
        if (sourcesProp == null) {
            Trace.error((Object)this, "addComponent", "Invalid Parameter: Sources property not populated.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Sources property not populated."), 100);
        }
        sources = (Vector)sourcesProp;
        Object isolationProp = props.get("isolationPolicy");
        if (isolationProp != null) {
            MirroredVolumeCIM.validate(7, isolationProp, null);
            isolationPolicy = (Integer)isolationProp;
        }
        if ((resilverProp = props.get("resilverPriority")) != null) {
            MirroredVolumeCIM.validate(6, resilverProp, null);
            resilverPriority = (Integer)resilverProp;
        }
        if ((snapNumProp = props.get("snamNum")) == null) {
            Trace.error((Object)this, "addComponent", "Invalid Parameter: SnapNum property not populated.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "SnapNum property not populated."), 100);
        }
        MirroredVolumeCIM.validate(3, snapNumProp, null);
        snapNum = (Integer)snapNumProp;
        Object snapChangeProp = props.get("snapChange");
        if (snapChangeProp != null) {
            MirroredVolumeCIM.validate(4, snapChangeProp, null);
            snapChange = (Integer)snapChangeProp;
        }
        if ((snapPolicyProp = props.get("snapPolicy")) != null) {
            MirroredVolumeCIM.validate(5, snapPolicyProp, null);
            snapPolicy = (Integer)snapPolicyProp;
        }
        if ((snapCompProp = props.get("snapComponent")) != null) {
            snapComp = (Integer)snapCompProp;
        }
        if ((snapPoolProp = props.get("snapPool")) != null) {
            snapPool = (StoragePool)snapPoolProp;
        }
        if ((logPoolsProp = props.get("logPools")) != null) {
            logPools = (Vector)logPoolsProp;
        }
        StorageDomain domain = null;
        ManageStorageDomains mgrDomains = new ManageStorageDomains();
        mgrDomains.init(this.context, null);
        domain = (StorageDomain)mgrDomains.getItemByName(mirror.getStorageDomainName());
        if (domain == null) {
            Trace.error((Object)this, "addComponent", "StorageDomain not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"StorageDomain"}, "StorageDomain not found."), 100);
        }
        Trace.verbose((Object)this, "addComponent", "Done parsing parameters...");
        int retVal = this.createMirror(mirror.getName(), mirror.getDescription(), domain, isolationPolicy, sources, mirror.getSize(), resilverPriority, snapNum, snapChange, snapPolicy, snapComp, snapPool, logPools, mirror.getNumberOfComponents() + sources.size(), false);
        if (retVal != 0) {
            Trace.verbose((Object)this, "addComponent", "Error code returned: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "addComponent");
    }

    public void breakComponent(Object key) throws ConfigMgmtException {
        String METHOD = "breakComponent";
        Trace.methodBegin(this, "breakComponent");
        if (key == null) {
            Trace.error((Object)this, "breakComponent", "Key object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Key object specified is null."), 100);
        }
        MirrorComponentCIM component = (MirrorComponentCIM)this.getMirrorComponentByKey((Collection)key);
        int retVal = 0;
        if (component == null) {
            Trace.error((Object)this, "breakComponent", "MirrorComponent specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"MirrorComponent"}, "MirrorComponent specified not found."), 100);
        }
        retVal = this.synchronizationHelper(2, component, null);
        if (retVal != 0) {
            Trace.verbose((Object)this, "breakComponent", "Error code returned: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "breakComponent");
    }

    public void splitComponent(Object key) throws ConfigMgmtException {
        String METHOD = "splitComponent";
        Trace.methodBegin(this, "splitComponent");
        if (key == null) {
            Trace.error((Object)this, "splitComponent", "Key object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Key object specified is null."), 100);
        }
        MirrorComponentCIM component = (MirrorComponentCIM)this.getMirrorComponentByKey((Collection)key);
        int retVal = 0;
        if (component == null) {
            Trace.error((Object)this, "splitComponent", "MirrorComponent specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"MirrorComponent"}, "MirrorComponent specified not found."), 100);
        }
        retVal = this.synchronizationHelper(3, component, null);
        if (retVal != 0) {
            Trace.verbose((Object)this, "splitComponent", "Error code returned: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "splitComponent");
    }

    public MethodCallStatus rejoinComponent(Object key) throws ConfigMgmtException {
        String METHOD = "rejoinComponent";
        Trace.methodBegin(this, "rejoinComponent");
        MethodCallStatus mcs = new MethodCallStatus();
        if (key == null) {
            Trace.error((Object)this, "rejoinComponent", "Key object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Key object specified is null."), 100);
        }
        MirrorComponentCIM component = (MirrorComponentCIM)this.getMirrorComponentByKey((Collection)key);
        int retVal = 0;
        Vector retArgs = new Vector();
        if (component == null) {
            Trace.error((Object)this, "rejoinComponent", "MirrorComponent specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"MirrorComponent"}, "MirrorComponent specified not found."), 100);
        }
        retVal = this.synchronizationHelper(4, component, retArgs);
        if (retVal == 4096) {
            CIMObjectPath jobPath = null;
            for (int i = 0; jobPath == null && i < retArgs.size(); ++i) {
                CIMArgument arg = (CIMArgument)retArgs.get(i);
                if (!arg.getName().equalsIgnoreCase("Job") || arg.getValue() == null) continue;
                jobPath = (CIMObjectPath)arg.getValue().getValue();
            }
            if (jobPath == null) {
                Trace.error((Object)this, "rejoinComponent", "Extrinsic method reported job should be present, but none could be found.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "JobPath not found."), 100);
            }
            JobManagerInterface jobMgr = JobManagerFactory.create();
            jobMgr.init(this.context, null);
            ArrayList<JobInterface> jobs = new ArrayList<JobInterface>();
            jobs.add(jobMgr.get(jobPath, null));
            mcs = new MethodCallStatus(retVal, jobs);
        } else {
            if (retVal != 0) {
                Trace.verbose((Object)this, "rejoinComponent", "Error code returned: " + retVal);
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
            }
            mcs.setReturnCode(retVal);
        }
        Trace.methodEnd(this, "rejoinComponent");
        return mcs;
    }

    public MethodCallStatus reverseRejoinComponent(Object key) throws ConfigMgmtException {
        String METHOD = "reverseRejoinComponent";
        Trace.methodBegin(this, "reverseRejoinComponent");
        MethodCallStatus mcs = new MethodCallStatus();
        if (key == null) {
            Trace.error((Object)this, "reverseRejoinComponent", "Key object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Key object specified is null."), 100);
        }
        MirrorComponentCIM component = (MirrorComponentCIM)this.getMirrorComponentByKey((Collection)key);
        int retVal = 0;
        Vector retArgs = new Vector();
        if (component == null) {
            Trace.error((Object)this, "reverseRejoinComponent", "MirrorComponent specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"MirrorComponent"}, "MirrorComponent specified not found."), 100);
        }
        retVal = this.synchronizationHelper(5, component, retArgs);
        if (retVal == 4096) {
            CIMObjectPath jobPath = null;
            for (int i = 0; jobPath == null && i < retArgs.size(); ++i) {
                CIMArgument arg = (CIMArgument)retArgs.get(i);
                if (!arg.getName().equalsIgnoreCase("Job") || arg.getValue() == null) continue;
                jobPath = (CIMObjectPath)arg.getValue().getValue();
            }
            if (jobPath == null) {
                Trace.error((Object)this, "reverseRejoinComponent", "Extrinsic method reported job should be present, but none could be found.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "JobPath not found."), 100);
            }
            JobManagerInterface jobMgr = JobManagerFactory.create();
            jobMgr.init(this.context, null);
            ArrayList<JobInterface> jobs = new ArrayList<JobInterface>();
            jobs.add(jobMgr.get(jobPath, null));
            mcs = new MethodCallStatus(retVal, jobs);
        } else {
            if (retVal != 0) {
                Trace.verbose((Object)this, "reverseRejoinComponent", "Error code returned: " + retVal);
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
            }
            mcs.setReturnCode(retVal);
        }
        Trace.methodEnd(this, "reverseRejoinComponent");
        return mcs;
    }

    public void forceBreakComponent(Object key) throws ConfigMgmtException {
        String METHOD = "forcedBreakComponent";
        Trace.methodBegin(this, "forcedBreakComponent");
        if (key == null) {
            Trace.error((Object)this, "forcedBreakComponent", "Key object is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Key object specified is null."), 100);
        }
        MirrorComponentCIM component = (MirrorComponentCIM)this.getMirrorComponentByKey((Collection)key);
        int retVal = 0;
        if (component == null) {
            Trace.error((Object)this, "forcedBreakComponent", "MirrorComponent specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"MirrorComponent"}, "MirrorComponent specified not found."), 100);
        }
        retVal = this.synchronizationHelper(32768, component, null);
        if (retVal != 0) {
            Trace.verbose((Object)this, "forcedBreakComponent", "Error code returned: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "forcedBreakComponent");
    }

    public void repairLogs(Object key) throws ConfigMgmtException {
        String METHOD = "repairLogs";
        Trace.methodBegin(this, "repairLogs");
        if (key == null) {
            Trace.error((Object)this, "repairLogs", "Mirror key specified is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Mirror key specified is null."), 100);
        }
        MirroredVolumeCIM mirror = (MirroredVolumeCIM)this.getMirroredVolumeByKey((Collection)key);
        if (mirror == null) {
            Trace.error((Object)this, "repairLogs", "Mirror specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"Mirror"}, "Mirror specified not found."), 100);
        }
        int retVal = this.repairLogs(mirror);
        if (retVal != 0) {
            Trace.verbose((Object)this, "repairLogs", "Error code returned: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        Trace.methodEnd(this, "repairLogs");
    }

    public List getVolumesForMirroring(Object key, boolean legacyVolumes) throws ConfigMgmtException {
        String METHOD = "getVolumesForMirroring";
        Trace.methodBegin(this, "getVolumesForMirroring");
        ArrayList<StorageVolume> mirrorVols = new ArrayList<StorageVolume>();
        ArrayList allVols = new ArrayList();
        ManageStorageVolumes mgrVols = null;
        StorageVolume primary = null;
        String domainName = null;
        String primaryName = null;
        BigInteger primarySize = null;
        if (key == null) {
            Trace.error((Object)this, "getVolumesForMirroring", "StorageVolume key specified is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "StorageVolume key specified is null."), 100);
        }
        mgrVols = new ManageStorageVolumes();
        mgrVols.init(this.context, null);
        primary = (StorageVolume)mgrVols.getByKey((Collection)key);
        if (primary == null) {
            Trace.error((Object)this, "getVolumesForMirroring", "StorageVolume specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"StorageVolume"}, "StorageVolume specified not found."), 100);
        }
        domainName = primary.getStorageDomainName();
        primaryName = primary.getName();
        primarySize = primary.getSize();
        try {
            allVols = mgrVols.getItemsByStorageDomain(domainName);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getVolumesForMirroring", "StorageDomain of StorageVolume specified not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND, new String[]{"StorageDomain"}, "StorageDomain of StorageVolume specified not found."), 100);
        }
        for (int i = 0; i < allVols.size(); ++i) {
            StorageVolume tempVol = (StorageVolume)allVols.get(i);
            String tempName = tempVol.getName();
            if (tempVol.getState() == 6) {
                Trace.verbose((Object)this, "getVolumesForMirroring", "Volume: " + tempName + " is mapped, skipping...");
                continue;
            }
            if (tempVol.getRedundancyType() != 0) {
                Trace.verbose((Object)this, "getVolumesForMirroring", "Volume: " + tempName + " is mirrored or replicated, skipping...");
                continue;
            }
            if (tempVol.getSnapshotPoolSize() != 0) {
                Trace.verbose((Object)this, "getVolumesForMirroring", "Volume: " + tempName + " has snapshot space, skipping...");
                continue;
            }
            if (tempName.equals(primaryName)) {
                Trace.verbose((Object)this, "getVolumesForMirroring", "Volume: " + tempName + " is the primary volume, skipping...");
                continue;
            }
            if (tempVol.getSize().compareTo(primarySize) == -1) {
                Trace.verbose((Object)this, "getVolumesForMirroring", "Volume: " + tempName + " size is too small, skipping...");
                continue;
            }
            if (tempVol.getType().equals("Split")) {
                Trace.verbose((Object)this, "getVolumesForMirroring", "Volume: " + tempName + " is a split mirror component, skipping...");
                continue;
            }
            if (legacyVolumes) {
                if (!tempVol.getType().equals("Legacy")) {
                    Trace.verbose((Object)this, "getVolumesForMirroring", "Volume: " + tempName + " is not legacy, legacyVolumes = true , " + "skipping...");
                    continue;
                }
            } else if (tempVol.getType().equals("Legacy")) {
                Trace.verbose((Object)this, "getVolumesForMirroring", "Volume: " + tempName + " is legacy, legacyVolumes = false , " + "skipping...");
                continue;
            }
            mirrorVols.add(tempVol);
        }
        Trace.methodEnd(this, "getVolumesForMirroring");
        return mirrorVols;
    }

    private int synchronizationHelper(int operation, MirrorComponentCIM component, Vector retArgs) throws ConfigMgmtException {
        String METHOD = "synchronizationHelper";
        Trace.methodBegin(this, "synchronizationHelper");
        if (component == null) {
            Trace.error((Object)this, "synchronizationHelper", "MirrorComponent specified is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "MirrorComponent specified is null."), 100);
        }
        CIMArgument[] inArgs = new CIMArgument[2];
        inArgs[0] = new CIMArgument("Operation", new CIMValue((Object)new UnsignedInt16(operation)));
        Trace.verbose((Object)this, "synchronizationHelper", "Querying CIM for SynchronizedComponent associations.");
        Enumeration enumSynchs = this.handle.references(component.getInstance().getObjectPath(), "SunStorEdge_DSPSynchronizedComponent", "Antecedent", true, false, null);
        Trace.verbose((Object)this, "synchronizationHelper", "Returned from querying CIM for SynchronizedComponent associations.");
        if (enumSynchs == null) {
            Trace.error((Object)this, "synchronizationHelper", "SynchronizedComponent association not found.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "SynchronizedComponent not found."), 100);
        }
        CIMInstance synch = (CIMInstance)enumSynchs.nextElement();
        inArgs[1] = new CIMArgument("Component", new CIMValue((Object)synch.getObjectPath()));
        CIMArgument[] outArgs = new CIMArgument[1];
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, component.getStorageDomainName(), 0);
        Trace.verbose((Object)this, "synchronizationHelper", "Configuration service object path is: " + confServiceObjectPath);
        Trace.verbose((Object)this, "synchronizationHelper", "Calling ModifySynchronization");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "ModifySynchronizationComponent", inArgs, outArgs);
        Trace.verbose((Object)this, "synchronizationHelper", "Returned from calling ModifySynchronization");
        int retVal = (Integer)returnCodeValue.getValue();
        Trace.verbose((Object)this, "synchronizationHelper", "Return code: " + retVal);
        if (outArgs != null && retArgs != null) {
            for (int j = 0; j < outArgs.length; ++j) {
                retArgs.add(outArgs[j]);
            }
        }
        Trace.methodEnd(this, "synchronizationHelper");
        return retVal;
    }

    private int createMirror(String name, String description, StorageDomain domain, int isolationPolicy, Vector sources, BigInteger size, int resilverPriority, int snapNum, int snapChange, int snapPolicy, int snapCompIndex, StoragePool snapPool, Vector userLogPools, int numComponents, boolean create) throws ConfigMgmtException {
        StoragePool pool;
        String METHOD = "createMirror";
        Trace.methodBegin(this, "createMirror");
        StoragePool settingPool = null;
        Vector<StoragePool> logPools = null;
        StorageVolume snapComp = null;
        logPools = userLogPools != null ? new Vector(userLogPools) : new Vector<StoragePool>();
        if (sources.get(0) instanceof StorageVolumeInterface && create && sources.get(snapCompIndex - 1) instanceof StorageVolume) {
            snapComp = (StorageVolume)sources.get(snapCompIndex - 1);
        }
        CIMArgument[] inArgs = snapComp != null ? new CIMArgument[14] : new CIMArgument[13];
        inArgs[0] = new CIMArgument("ElementName", new CIMValue((Object)name));
        inArgs[1] = new CIMArgument("Description", new CIMValue((Object)description));
        Vector<String> sourceElements = new Vector<String>();
        for (int i = 0; i < sources.size(); ++i) {
            StoragePool tempPool;
            int h;
            if (sources.get(i) instanceof StorageVolumeInterface) {
                Trace.verbose((Object)this, "createMirror", "Adding a StorageVolume as a component parameter.");
                StorageVolume vol = (StorageVolume)sources.get(i);
                sourceElements.add(vol.getInstance().getObjectPath().toString());
                StoragePool pool2 = null;
                if (!vol.getType().equalsIgnoreCase("Legacy")) {
                    pool2 = (StoragePool)vol.getStoragePool();
                }
                if (pool2 == null || !create) continue;
                for (h = 0; h < logPools.size(); ++h) {
                    tempPool = (StoragePool)logPools.get(h);
                    if (!tempPool.getInstanceID().equals(pool2.getInstanceID())) continue;
                    pool2 = null;
                    break;
                }
                if (pool2 == null) continue;
                logPools.add(pool2);
                continue;
            }
            if (!(sources.get(i) instanceof StoragePoolInterface)) continue;
            Trace.verbose((Object)this, "createMirror", "Adding a StoragePool as a component parameter.");
            pool = (StoragePool)sources.get(i);
            sourceElements.add(pool.getInstance().getObjectPath().toString());
            boolean dupFound = false;
            if (create && userLogPools == null) {
                for (h = 0; h < logPools.size(); ++h) {
                    tempPool = (StoragePool)logPools.get(h);
                    if (!tempPool.getInstanceID().equals(pool.getInstanceID())) continue;
                    dupFound = true;
                    break;
                }
                if (!dupFound) {
                    logPools.add(pool);
                }
            }
            if (settingPool != null) continue;
            settingPool = pool;
        }
        inArgs[2] = new CIMArgument("SourceElement", new CIMValue(sourceElements, new CIMDataType(22)));
        if (numComponents < 1 || numComponents > 4) {
            Trace.error((Object)this, "createMirror", "Invalid number of mirror components specified.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.INVALID_LM_COMP_COUNT, new String[]{new Integer(numComponents).toString()}, "Invalid component count."), 100);
        }
        inArgs[3] = new CIMArgument("SourceElementCount", new CIMValue((Object)new UnsignedInt16(numComponents)));
        inArgs[4] = new CIMArgument("Size", new CIMValue((Object)new UnsignedInt64(size)));
        inArgs[5] = new CIMArgument("SnapshotComponentIndex", new CIMValue((Object)new UnsignedInt16(snapCompIndex)));
        if (settingPool == null) {
            ManageStoragePools mgrPools = new ManageStoragePools();
            mgrPools.init(this.context, null);
            pool = null;
            try {
                pool = (StoragePool)mgrPools.getItemByName("Default", "DEFAULT");
            }
            catch (ItemNotFoundException infe) {
                // empty catch block
            }
            if (pool != null) {
                settingPool = pool;
            }
        }
        Trace.verbose((Object)this, "createMirror", "Querying CIM for associated StorageCapabilities Instance");
        Enumeration enumeration = this.handle.associators(settingPool.getInstance().getObjectPath(), "SunStorEdge_DSPElementCapabilities", "SunStorEdge_DSPStorageCapabilities", "ManagedElement", "Capabilities", true, false, ConstantsEnt.StorageCapabilitiesProperties.PROP_LIST);
        Trace.verbose((Object)this, "createMirror", "Returned from querying CIM for associated StorageCapabilities Instance");
        CIMArgument[] createSettingOutArgs = new CIMArgument[1];
        CIMArgument[] createSettingInArgs = new CIMArgument[1];
        if (enumeration != null && enumeration.hasMoreElements()) {
            CIMInstance profile = (CIMInstance)enumeration.nextElement();
            createSettingInArgs[0] = new CIMArgument("SettingType", new CIMValue((Object)new UnsignedInt16(2)));
            Trace.verbose((Object)this, "createMirror", "Calling CreateSetting");
            CIMValue settingCodeValue = this.handle.invokeMethod(profile.getObjectPath(), "CreateSetting", createSettingInArgs, createSettingOutArgs);
            Trace.verbose((Object)this, "createMirror", "Returned from calling CreateSetting");
            Trace.verbose((Object)this, "createMirror", "Setting the snapshot and isolation policies");
            CIMObjectPath settingPath = (CIMObjectPath)createSettingOutArgs[0].getValue().getValue();
            CIMInstance setting = this.handle.getInstance(settingPath, false, true, true);
            try {
                setting.setProperty("SnapshotPoolPercent", new CIMValue((Object)new UnsignedInt16(snapNum * snapChange)));
                setting.setProperty("SnapshotCount", new CIMValue((Object)new UnsignedInt16(snapNum)));
                setting.setProperty("WriteActivity", new CIMValue((Object)new UnsignedInt16(snapChange)));
                setting.setProperty("SnapshotPolicy", new CIMValue((Object)new UnsignedInt16(snapPolicy)));
                setting.setProperty("ResyncPriority", new CIMValue((Object)new UnsignedInt16(resilverPriority)));
                boolean policy = false;
                if (isolationPolicy == 1) {
                    policy = true;
                }
                setting.setProperty("MirrorIsolation", new CIMValue((Object)new Boolean(policy)));
            }
            catch (CIMException ce) {
                Trace.error((Object)this, "createMirror", "Errors setting snapshot and isolation policies.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Errors setting snapshot and isolation policies."), 100);
            }
            this.handle.setInstance(settingPath, setting);
        }
        CIMObjectPath goalPath = (CIMObjectPath)createSettingOutArgs[0].getValue().getValue();
        inArgs[6] = new CIMArgument("TargetSettingGoal", new CIMValue((Object)goalPath));
        inArgs[7] = new CIMArgument("CopyType", new CIMValue((Object)new UnsignedInt16("3")));
        Vector<String> logPoolsParam = null;
        if (create) {
            if (logPools != null) {
                logPoolsParam = new Vector<String>();
                for (int k = 0; k < logPools.size(); ++k) {
                    StoragePool pool3 = (StoragePool)logPools.get(k);
                    logPoolsParam.add(pool3.getInstance().getObjectPath().toString());
                }
            } else {
                Trace.error((Object)this, "createMirror", "Log pools must be specified in this case.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.UNSPECIFIED_MIRROR_LOGS, null, "Log pools must be specified in this case."), 300);
            }
        }
        inArgs[8] = new CIMArgument("LogPool", new CIMValue(logPoolsParam, new CIMDataType(22)));
        CIMObjectPath snapPoolObjectPath = null;
        if (snapPool != null) {
            snapPoolObjectPath = snapPool.getInstance().getObjectPath();
        }
        inArgs[9] = new CIMArgument("CowPool", new CIMValue((Object)snapPoolObjectPath));
        inArgs[10] = new CIMArgument("Count", new CIMValue((Object)new UnsignedInt16(numComponents)));
        inArgs[11] = new CIMArgument("ResyncPriority", new CIMValue((Object)new UnsignedInt16(resilverPriority)));
        if (create) {
            inArgs[12] = new CIMArgument("TargetElement", new CIMValue(null));
        } else {
            ManageStorageVolumes mgr = new ManageStorageVolumes();
            mgr.init(this.context, null);
            StorageVolume vol = (StorageVolume)mgr.getItemByName(name);
            if (vol != null) {
                inArgs[12] = new CIMArgument("TargetElement", new CIMValue((Object)vol.getInstance().getObjectPath()));
            } else {
                Trace.error((Object)this, "createMirror", "Cannot find mirror to add component to.");
                throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Cannot find mirror to add component to."), 100);
            }
        }
        if (snapComp != null) {
            inArgs[13] = new CIMArgument("snapComponent", new CIMValue((Object)snapComp.getInstance().getObjectPath()));
        }
        CIMArgument[] outArgs = new CIMArgument[4];
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, domain.getName(), 0);
        Trace.verbose((Object)this, "createMirror", "Configuration service object path is: " + confServiceObjectPath);
        Trace.verbose((Object)this, "createMirror", "Calling CreateReplicaMultiple");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateReplicaMultiple", inArgs, outArgs);
        Trace.verbose((Object)this, "createMirror", "Returned from calling CreateReplicaMultiple");
        int retVal = (Integer)returnCodeValue.getValue();
        if (retVal == 33679 || retVal == 33680 || retVal == 33681) {
            for (int k = 0; k < outArgs.length; ++k) {
                CIMArgument arg = outArgs[k];
                if (arg == null || !arg.getName().equalsIgnoreCase("ErrorReport")) continue;
                this.parseMirrorCreationResults((CIMObjectPath)arg.getValue().getValue(), retVal);
            }
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "createMirror", "Return code: " + retVal);
        }
        Trace.methodEnd(this, "createMirror");
        return retVal;
    }

    private int delete(MirroredVolumeCIM mirror) throws ConfigMgmtException {
        String METHOD = "delete";
        Trace.methodBegin(this, "delete");
        if (mirror == null) {
            Trace.error((Object)this, "delete", "MirroredVolume specified is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "MirroredVolume specified is null."), 100);
        }
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("TheElement", new CIMValue((Object)mirror.getInstance().getObjectPath()))};
        CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null))};
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, mirror.getStorageDomainName(), 0);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "delete", "Configuration service object path is: " + confServiceObjectPath);
        }
        Trace.verbose((Object)this, "delete", "Calling ReturnToStoragePool");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "ReturnToStoragePool", inArgs, outArgs);
        Trace.verbose((Object)this, "delete", "Returned from calling ReturnToStoragePool");
        int retVal = (Integer)returnCodeValue.getValue();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "delete", "Return code: " + retVal);
        }
        Trace.methodEnd(this, "delete");
        return retVal;
    }

    private int repairLogs(MirroredVolumeCIM mirror) throws ConfigMgmtException {
        String METHOD = "repairLogs";
        Trace.methodBegin(this, "repairLogs");
        if (mirror == null) {
            Trace.error((Object)this, "repairLogs", "Mirror specified is null.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Mirror specified is null."), 100);
        }
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Operation", new CIMValue((Object)new UnsignedInt16(0))), new CIMArgument("Volume", new CIMValue((Object)mirror.getInstance().getObjectPath())), new CIMArgument("Log", new CIMValue(null))};
        CIMArgument[] outArgs = new CIMArgument[]{};
        CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, mirror.getStorageDomainName(), 0);
        Trace.verbose((Object)this, "repairLogs", "Configuration service object path is: " + confServiceObjectPath);
        Trace.verbose((Object)this, "repairLogs", "Calling ModifyLog");
        CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "ModifyLog", inArgs, outArgs);
        Trace.verbose((Object)this, "repairLogs", "Returned from calling ModifyLog");
        int retVal = (Integer)returnCodeValue.getValue();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "repairLogs", "Return code: " + retVal);
        }
        Trace.methodEnd(this, "repairLogs");
        return retVal;
    }

    private void parseMirrorCreationResults(CIMObjectPath errorReportPath, int returnVal) throws ConfigMgmtException {
        String METHOD = "parseMirrorCreationResults";
        Trace.methodBegin(this, "parseMirrorCreationResults");
        CIMInstance errorReportInst = null;
        ArrayList<ErrorDescriptor> results = new ArrayList<ErrorDescriptor>();
        Trace.verbose((Object)this, "parseMirrorCreationResults", "Trying to obtain SunStorEdge_DSPErrorReport instance.");
        errorReportInst = this.handle.getInstance(errorReportPath);
        if (errorReportInst == null) {
            Trace.error((Object)this, "parseMirrorCreationResults", "Could not retrieve SunStorEdge_DSPErrorReport instance.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve SunStorEdge_DSPErrorReport  instance."), 100);
        }
        Trace.verbose((Object)this, "parseMirrorCreationResults", "SunStorEdge_DSPErrorReport instance found.");
        Trace.verbose((Object)this, "parseMirrorCreationResults", "Querying CIM for associated SunStorEdge_DSPErrorSubReport instances.");
        Enumeration subReports = this.handle.associators(errorReportInst.getObjectPath(), "SunStorEdge_DSPMemberOfReport", "SunStorEdge_DSPErrorSubReport", "Report", "SubReport", true, false, null);
        Trace.verbose((Object)this, "parseMirrorCreationResults", "Returned from querying CIM for associated SunStorEdge_DSPErrorSubReport instances.");
        if (subReports != null && subReports.hasMoreElements()) {
            while (subReports.hasMoreElements()) {
                CIMInstance subRepInst = (CIMInstance)subReports.nextElement();
                int reason = -1;
                CIMValue reasonVal = subRepInst.getProperty("Reason").getValue();
                if (reasonVal == null) {
                    Trace.error((Object)this, "parseMirrorCreationResults", "Could not retrieve 'Reason'");
                    throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve 'Reason'"), 100);
                }
                reason = ((UnsignedInt16)reasonVal.getValue()).intValue();
                switch (reason) {
                    case 4: {
                        String volumeName = null;
                        CIMValue volumeNameVal = subRepInst.getProperty("VolumeName").getValue();
                        if (volumeNameVal == null) {
                            Trace.error((Object)this, "parseMirrorCreationResults", "Could not retrieve 'VolumeName'");
                            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve 'VolumeName'"), 100);
                        }
                        volumeName = (String)volumeNameVal.getValue();
                        results.add(new ErrorDescriptor(ErrorCode.MIRROR_ISOLATE_OVERLAP, new String[]{volumeName}, "Mirror Creation Failed: Overlap"));
                        break;
                    }
                    case 1: {
                        String poolName = null;
                        CIMValue poolNameVal = subRepInst.getProperty("TargetPoolName").getValue();
                        if (poolNameVal == null) {
                            Trace.error((Object)this, "parseMirrorCreationResults", "Could not retrieve 'TargetPoolName'");
                            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve 'TargetPoolName'"), 100);
                        }
                        poolName = (String)poolNameVal.getValue();
                        results.add(new ErrorDescriptor(ErrorCode.MIRROR_ISOLATE_ARRAY, new String[]{poolName}, "Mirror Creation Failed: Array Count"));
                        break;
                    }
                    case 2: {
                        String poolName = null;
                        CIMValue poolNameVal = subRepInst.getProperty("TargetPoolName").getValue();
                        if (poolNameVal == null) {
                            Trace.error((Object)this, "parseMirrorCreationResults", "Could not retrieve 'TargetPoolName'");
                            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve 'TargetPoolName'"), 100);
                        }
                        poolName = (String)poolNameVal.getValue();
                        results.add(new ErrorDescriptor(ErrorCode.MIRROR_ISOLATE_VDISK, new String[]{poolName}, "Mirror Creation Failed: VDisk Count"));
                        break;
                    }
                    case 3: {
                        String poolName = null;
                        int size = 0;
                        CIMValue poolNameVal = subRepInst.getProperty("TargetPoolName").getValue();
                        if (poolNameVal == null) {
                            Trace.error((Object)this, "parseMirrorCreationResults", "Could not retrieve 'TargetPoolName'");
                            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve 'TargetPoolName'"), 100);
                        }
                        poolName = (String)poolNameVal.getValue();
                        CIMValue sizeVal = subRepInst.getProperty("Size").getValue();
                        if (sizeVal == null) {
                            Trace.error((Object)this, "parseMirrorCreationResults", "Could not retrieve 'Size'");
                            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve 'Size'"), 100);
                        }
                        size = ((UnsignedInt16)sizeVal.getValue()).intValue();
                        results.add(new ErrorDescriptor(ErrorCode.MIRROR_ISOLATE_SIZE, new String[]{poolName, new Integer(size).toString()}, "Mirror Creation Failed: Pool Size"));
                        break;
                    }
                    case 5: {
                        String poolName = null;
                        int logs = 0;
                        CIMValue poolNameVal = subRepInst.getProperty("TargetPoolName").getValue();
                        if (poolNameVal == null) {
                            Trace.error((Object)this, "parseMirrorCreationResults", "Could not retrieve 'TargetPoolName'");
                            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve 'TargetPoolName'"), 100);
                        }
                        poolName = (String)poolNameVal.getValue();
                        CIMValue logCountVal = subRepInst.getProperty("LogCount").getValue();
                        if (logCountVal == null) {
                            Trace.error((Object)this, "parseMirrorCreationResults", "Could not retrieve 'LogCount'");
                            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Could not retrieve 'LogCount'"), 100);
                        }
                        logs = ((UnsignedInt16)logCountVal.getValue()).intValue();
                        results.add(new ErrorDescriptor(ErrorCode.MIRROR_ISOLATE_LOGS, new String[]{poolName, new Integer(logs * 2).toString()}, "Mirror Creation Failed: Log Count"));
                        break;
                    }
                }
            }
        }
        this.handle.deleteInstance(errorReportPath);
        throw new ConfigMgmtException(results, ErrorCode.CIM_ERROR.getKey() + returnVal, "Results from Mirror Creation", 300);
    }
}

