/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageMirrorServicesEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeEnt1Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import java.util.ArrayList;

public abstract class MirroredVolumeEnt1
extends StorageVolume
implements MirroredVolumeEnt1Interface {
    protected int resilverPriority = -1;
    protected int isolationPolicy = -1;
    protected MirrorComponentEnt1Interface snapComponent = null;

    public void init(ConfigContext context) throws ConfigMgmtException {
        String METHOD = "init";
        Trace.methodBegin(this, "init");
        super.init(context);
        this.initImpl(context);
        Trace.methodEnd(this, "init");
    }

    protected abstract void initImpl(ConfigContext var1) throws ConfigMgmtException;

    public abstract int getNumberOfComponents() throws ConfigMgmtException;

    public abstract ArrayList getAssociatedComponents() throws ConfigMgmtException;

    public int getResilverPriority() throws ConfigMgmtException {
        String METHOD = "getResilverPriority";
        Trace.methodBegin(this, "getResilverPriority");
        if (this.resilverPriority == -1) {
            this.getAssocPropsImpl();
        }
        Trace.methodEnd(this, "getResilverPriority");
        return this.resilverPriority;
    }

    public MirrorComponentEnt1Interface getSnapshotComponent() throws ConfigMgmtException {
        String METHOD = "getSnapshotComponent";
        Trace.methodBegin(this, "getSnapshotComponent");
        if (this.snapComponent == null) {
            this.getSnapComponentImpl();
        }
        Trace.methodEnd(this, "getSnapshotComponent");
        return this.snapComponent;
    }

    public void setSnapshotComponent(Object snapCompKey) throws ConfigMgmtException {
        String METHOD = "setSnapshotComponent";
        Trace.methodBegin(this, "setSnapshotComponent");
        if (this.snapComponent != null) {
            Trace.error((Object)this, "setSnapshotComponent", "Snapshot Component already set.");
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION, null, "Snapshot Component already set."), 100);
        }
        ManageMirrorServicesEnt1Interface mgr = (ManageMirrorServicesEnt1Interface)ManageDataServicesFactory.getMirrorServicesManager(this.context);
        mgr.init(this.context, null, null);
        this.snapComponent = (MirrorComponentEnt1Interface)mgr.getMirrorComponentByKey(snapCompKey);
        Trace.methodEnd(this, "setSnapshotComponent");
    }

    public int getIsolationPolicy() throws ConfigMgmtException {
        String METHOD = "getIsolationPolicy";
        Trace.methodBegin(this, "getIsolationPolicy");
        if (this.isolationPolicy == -1) {
            this.getAssocPropsImpl();
        }
        Trace.methodEnd(this, "getIsolationPolicy");
        return this.isolationPolicy;
    }

    protected abstract void getAssocPropsImpl() throws ConfigMgmtException;

    protected abstract void getSnapComponentImpl() throws ConfigMgmtException;

    public abstract ArrayList getLogVDisks() throws ConfigMgmtException;

    public abstract ArrayList getLogPools() throws ConfigMgmtException;

    public abstract void setResilverPriority(int var1) throws ConfigMgmtException;

    public static interface Props
    extends StorageVolume.Props {
        public static final int RESILVER_PRIORITY = 6;
        public static final int ISOLATION_POLICY = 7;
    }
}

