/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.logic;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SearchFilterException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class SearchFilter {
    private String searchValue;
    private String searchField;
    private Pattern pattern;
    private boolean isCaseSensitive = true;
    private boolean isExactSearch = true;
    private Method conversionMethod = null;
    private boolean isMultipleFieldValueFilter = false;
    private Map filterMap = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public SearchFilter() {
        Trace.constructor(this);
    }

    public SearchFilter(boolean isCaseSensitve, boolean isExactSearch) {
        this.isCaseSensitive = this.isCaseSensitive;
        this.isExactSearch = isExactSearch;
    }

    public SearchFilter(String searchField, String searchValue) {
        this.setSearchFilter(searchField, searchValue);
    }

    public SearchFilter(String searchField, Pattern p) {
        Trace.constructor(this);
        this.pattern = p;
        this.searchField = searchField;
    }

    public SearchFilter(String searchField, String searchValue, boolean isExactSearch, boolean isCaseSensitive) {
        this.setSearchFilter(searchField, searchValue, isExactSearch, isCaseSensitive);
    }

    public void setConversionMethod(String className, String methodName) throws SearchFilterException {
        try {
            Class<?> cls = Class.forName(className);
            Class[] partypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SearchFilter.class$("java.lang.String")) : class$java$lang$String};
            this.conversionMethod = cls.getMethod(methodName, partypes);
        }
        catch (Throwable e) {
            Trace.verbose((Object)this, "setConversionMethod", e);
            throw new SearchFilterException("error.applicationError", "Failed to register conversion method");
        }
    }

    public Method getConversionMethod() {
        return this.conversionMethod;
    }

    public String getSearchField() {
        return this.searchField;
    }

    public String getSearchString() {
        return this.searchValue;
    }

    public void setSearchFilter(String searchField, String searchValue) {
        String METHOD = "setSearchFilter";
        this.searchField = searchField;
        this.searchValue = searchValue;
    }

    public void setSearchString(String searchValue) {
        this.searchValue = searchValue;
    }

    public void setSearchFilter(String searchField, String searchValue, boolean isExactSearch, boolean isCaseSensitive) {
        this.isExactSearch = isExactSearch;
        this.searchField = searchField;
        this.searchValue = searchValue;
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean passesFilter(CIMInstance cimInstance) throws SearchFilterException {
        boolean isPassed = false;
        if (this.isEmpty()) {
            Trace.verbose((Object)this, "passesFilter", "search filter is empty!!!");
            isPassed = true;
        } else {
            CIMProperty cimProp = cimInstance.getProperty(this.searchField);
            if (cimProp == null) {
                String msg = "Search Field Not Found: search field <" + this.searchField + "> is not available.";
                throw new SearchFilterException("SEARCH_FIELD_NOT_FOUND", msg);
            }
            CIMValue cimValue = cimProp.getValue();
            if (cimValue != null && cimValue.getValue() != null) {
                String target = this.getString(cimValue);
                Method conversion = this.getConversionMethod();
                if (conversion != null) {
                    Trace.verbose((Object)this, "passesFilter", "Convert this target string: " + target);
                    try {
                        Class<?> cls = conversion.getDeclaringClass();
                        Object methobj = cls.newInstance();
                        Object[] arglist = new Object[]{new String(target)};
                        Object retobj = conversion.invoke(methobj, arglist);
                        target = (String)retobj;
                        Trace.verbose((Object)this, "passesFilter", "Converted target to: " + target);
                    }
                    catch (IllegalArgumentException ie) {
                        Trace.verbose((Object)this, "passesFilter", (Throwable)ie);
                        throw new SearchFilterException("incorrect.method.parameter", "IllegalArgumentException raised.");
                    }
                    catch (InvocationTargetException te) {
                        Trace.verbose((Object)this, "passesFilter", te.getCause());
                        Trace.verbose((Object)this, "passesFilter", (Throwable)te);
                        throw new SearchFilterException("error.applicationError", "InvocationTargetException raised.");
                    }
                    catch (Throwable e) {
                        Trace.verbose((Object)this, "passesFilter", e);
                        throw new SearchFilterException("error.applicationError", "Conversion method failed");
                    }
                } else {
                    Trace.verbose((Object)this, "passesFilter", "There is no conversion method for this search");
                }
                isPassed = this.passesFilter(target);
            }
        }
        return isPassed;
    }

    public boolean passesFilter(String target) {
        String METHOD = "passesFilter";
        boolean isPassed = false;
        if (target == null) {
            return false;
        }
        if (this.pattern != null) {
            isPassed = this.pattern.matcher(target).find();
        } else {
            if (this.searchValue != null && this.searchValue.equals("*")) {
                return true;
            }
            if (this.isExactSearch && this.searchValue != null) {
                isPassed = this.isCaseSensitive ? this.searchValue.equals(target) : this.searchValue.equalsIgnoreCase(target);
            } else if (this.isCaseSensitive) {
                if (target != null && this.searchValue != null) {
                    isPassed = target.indexOf(this.searchValue) != -1;
                }
            } else if (target != null && this.searchValue != null) {
                isPassed = target.toLowerCase().indexOf(this.searchValue.toLowerCase()) != -1;
            }
        }
        return isPassed;
    }

    public boolean isEmpty() {
        return this.searchValue == null && this.pattern == null && this.filterMap.isEmpty();
    }

    public boolean isExactSearch() {
        return this.isExactSearch;
    }

    private String getString(CIMValue val) {
        String ret = null;
        if (val.getType().isArrayType()) {
            Object o;
            Vector vector = (Vector)val.getValue();
            if (vector.size() > 0 && (o = vector.get(0)) != null) {
                ret = o.toString();
            }
        } else {
            ret = val.getValue().toString();
        }
        return ret;
    }

    public boolean isMultipleFieldValueFilter() {
        return this.isMultipleFieldValueFilter;
    }

    public void setIsMultipleFieldValueFilter(boolean multiValue) {
        this.isMultipleFieldValueFilter = multiValue;
    }

    public void addFilter(String fieldName, String fieldValue) {
        this.isMultipleFieldValueFilter = true;
        this.filterMap.put(fieldName, fieldValue);
    }

    public String getFilterValue(String fieldName) {
        String fv = (String)this.filterMap.get(fieldName);
        if (fv == null && this.searchField != null && this.searchField.equals(fieldName)) {
            fv = this.searchValue;
        }
        return fv;
    }

    public boolean passesFilter(String fieldName, String target) {
        boolean passes = false;
        if (this.filterMap.get(fieldName) == null) {
            passes = this.searchField == null || !this.searchField.equals(fieldName) ? true : this.passesFilter(target);
        } else {
            this.searchField = fieldName;
            this.searchValue = (String)this.filterMap.get(fieldName);
            passes = this.passesFilter(target);
        }
        return passes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

